/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.ActiveInfoStorageCalculatorViaMutualInfo;
import infodynamics.measures.continuous.kraskov.MutualInfoCalculatorMultiVariateKraskov;
import infodynamics.measures.continuous.kraskov.MutualInfoCalculatorMultiVariateKraskov1;
import infodynamics.measures.continuous.kraskov.MutualInfoCalculatorMultiVariateKraskov2;
import infodynamics.utils.MatrixUtils;

public class ActiveInfoStorageCalculatorKraskov
extends ActiveInfoStorageCalculatorViaMutualInfo {
    public static final String MI_CALCULATOR_KRASKOV1 = MutualInfoCalculatorMultiVariateKraskov1.class.getName();
    public static final String MI_CALCULATOR_KRASKOV2 = MutualInfoCalculatorMultiVariateKraskov2.class.getName();
    public static final String PROP_AUTO_EMBED_METHOD = "AUTO_EMBED_METHOD";
    public static final String AUTO_EMBED_METHOD_NONE = "NONE";
    public static final String AUTO_EMBED_METHOD_RAGWITZ = "RAGWITZ";
    public static final String AUTO_EMBED_METHOD_MAX_CORR_AIS = "MAX_CORR_AIS";
    protected String autoEmbeddingMethod = "NONE";
    public static final String PROP_K_SEARCH_MAX = "AUTO_EMBED_K_SEARCH_MAX";
    protected int k_search_max = 1;
    public static final String PROP_TAU_SEARCH_MAX = "AUTO_EMBED_TAU_SEARCH_MAX";
    protected int tau_search_max = 1;
    public static final String PROP_RAGWITZ_NUM_NNS = "AUTO_EMBED_RAGWITZ_NUM_NNS";
    protected int ragwitz_num_nns = 1;
    protected boolean ragwitz_num_nns_set = false;

    public ActiveInfoStorageCalculatorKraskov() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(MI_CALCULATOR_KRASKOV2);
    }

    public ActiveInfoStorageCalculatorKraskov(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(string);
        if (!string.equalsIgnoreCase(MI_CALCULATOR_KRASKOV1) && !string.equalsIgnoreCase(MI_CALCULATOR_KRASKOV2)) {
            throw new ClassNotFoundException("Must be an underlying Kraskov-Grassberger calculator");
        }
    }

    public ActiveInfoStorageCalculatorKraskov(int n) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(n == 1 ? MI_CALCULATOR_KRASKOV1 : MI_CALCULATOR_KRASKOV2);
        if (n != 1 && n != 2) {
            throw new ClassNotFoundException("Algorithm must be 1 or 2");
        }
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase(PROP_AUTO_EMBED_METHOD)) {
            this.autoEmbeddingMethod = string2;
        } else if (string.equalsIgnoreCase(PROP_K_SEARCH_MAX)) {
            this.k_search_max = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase(PROP_TAU_SEARCH_MAX)) {
            this.tau_search_max = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase(PROP_RAGWITZ_NUM_NNS)) {
            this.ragwitz_num_nns = Integer.parseInt(string2);
            this.ragwitz_num_nns_set = true;
        } else {
            bl = false;
            super.setProperty(string, string2);
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public String getProperty(String string) throws Exception {
        if (string.equalsIgnoreCase(PROP_AUTO_EMBED_METHOD)) {
            return this.autoEmbeddingMethod;
        }
        if (string.equalsIgnoreCase(PROP_K_SEARCH_MAX)) {
            return Integer.toString(this.k_search_max);
        }
        if (string.equalsIgnoreCase(PROP_TAU_SEARCH_MAX)) {
            return Integer.toString(this.tau_search_max);
        }
        if (string.equalsIgnoreCase(PROP_RAGWITZ_NUM_NNS)) {
            if (this.ragwitz_num_nns_set) {
                return Integer.toString(this.ragwitz_num_nns);
            }
            return this.miCalc.getProperty("k");
        }
        return super.getProperty(string);
    }

    @Override
    public void preFinaliseAddObservations() throws Exception {
        if (this.autoEmbeddingMethod.equalsIgnoreCase(AUTO_EMBED_METHOD_NONE)) {
            return;
        }
        int n = 1;
        int n2 = 1;
        if (this.autoEmbeddingMethod.equalsIgnoreCase(AUTO_EMBED_METHOD_RAGWITZ)) {
            Object object = Double.POSITIVE_INFINITY;
            if (this.debug) {
                System.out.printf("Beginning Ragwitz auto-embedding with k_max=%d, tau_max=%d\n", this.k_search_max, this.tau_search_max);
            }
            block0: for (int i = 1; i <= this.k_search_max; ++i) {
                for (int j = 1; j <= this.tau_search_max; ++j) {
                    this.miCalc.initialise(i, 1);
                    this.miCalc.startAddObservations();
                    for (double[] dArray : this.vectorOfObservationTimeSeries) {
                        double[][] dArray2 = MatrixUtils.makeDelayEmbeddingVector(dArray, i, j, (i - 1) * j, dArray.length - (i - 1) * j - 1);
                        double[][] dArray3 = MatrixUtils.makeDelayEmbeddingVector(dArray, 1, (i - 1) * j + 1, dArray.length - (i - 1) * j - 1);
                        this.miCalc.addObservations(dArray2, dArray3);
                    }
                    this.miCalc.finaliseAddObservations();
                    Object object2 = this.ragwitz_num_nns_set ? (Object)((MutualInfoCalculatorMultiVariateKraskov)this.miCalc).computePredictionErrorsFromObservations(false, this.ragwitz_num_nns) : (Object)((MutualInfoCalculatorMultiVariateKraskov)this.miCalc).computePredictionErrorsFromObservations(false);
                    if (this.debug) {
                        System.out.printf("Embedding prediction error (dim=%d) for k=%d,tau=%d is %.3f\n", ((Object)object2).length, i, j, (double)(object2[0] / (double)this.miCalc.getNumObservations()));
                    }
                    if (object2[0] / (double)this.miCalc.getNumObservations() < object) {
                        object = object2[0] / (double)this.miCalc.getNumObservations();
                        n = i;
                        n2 = j;
                    }
                    if (i == 1) continue block0;
                }
            }
        } else if (this.autoEmbeddingMethod.equalsIgnoreCase(AUTO_EMBED_METHOD_MAX_CORR_AIS)) {
            double d = Double.NEGATIVE_INFINITY;
            if (this.debug) {
                System.out.printf("Beginning max bias corrected AIS auto-embedding with k_max=%d, tau_max=%d\n", this.k_search_max, this.tau_search_max);
            }
            block3: for (int i = 1; i <= this.k_search_max; ++i) {
                for (int j = 1; j <= this.tau_search_max; ++j) {
                    this.miCalc.initialise(i, 1);
                    this.miCalc.startAddObservations();
                    for (double[] dArray : this.vectorOfObservationTimeSeries) {
                        double[][] dArray4 = MatrixUtils.makeDelayEmbeddingVector(dArray, i, j, (i - 1) * j, dArray.length - (i - 1) * j - 1);
                        double[][] dArray5 = MatrixUtils.makeDelayEmbeddingVector(dArray, 1, (i - 1) * j + 1, dArray.length - (i - 1) * j - 1);
                        this.miCalc.addObservations(dArray4, dArray5);
                    }
                    this.miCalc.finaliseAddObservations();
                    double d2 = this.miCalc.computeAverageLocalOfObservations();
                    if (this.debug) {
                        System.out.printf("AIS for k=%d,tau=%d is %.3f\n", i, j, d2);
                    }
                    if (d2 > d) {
                        d = d2;
                        n = i;
                        n2 = j;
                    }
                    if (i == 1) continue block3;
                }
            }
        } else {
            throw new RuntimeException("Unexpected value " + this.autoEmbeddingMethod + " for property " + PROP_AUTO_EMBED_METHOD);
        }
        this.k = n;
        this.tau = n2;
        if (this.debug) {
            System.out.printf("Embedding parameters set to k=%d,tau=%d\n", this.k, this.tau);
        }
    }
}

