/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.symbolic;

import infodynamics.measures.continuous.TransferEntropyCalculator;
import infodynamics.measures.continuous.TransferEntropyCommon;
import infodynamics.measures.discrete.TransferEntropyCalculatorDiscrete;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.FirstIndexComparatorDouble;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;

public class TransferEntropyCalculatorSymbolic
extends TransferEntropyCommon
implements TransferEntropyCalculator {
    protected TransferEntropyCalculatorDiscrete teCalc;
    protected int maxEmbeddingLength;
    protected int l = 1;
    protected boolean lWasSet = false;
    private int[][] destPermutations;
    private int[] destPermutationIds;
    private int[] idToDestPermutationIndex;
    private int[][] sourcePermutations;
    private int[] sourcePermutationIds;
    private int[] idToSourcePermutationIndex;
    protected Vector<int[]> destSymbolsVector;
    protected Vector<int[]> sourceSymbolsVector;
    protected static final int VAL_COLUMN = 0;
    protected static final int VAR_NUM_COLUMN = 1;

    @Override
    public void initialise(int n) throws Exception {
        super.initialise(n);
    }

    @Override
    public void initialise() throws Exception {
        int n;
        if (!this.lWasSet) {
            this.l = this.k;
        }
        this.maxEmbeddingLength = Math.max(this.k, this.l);
        RandomGenerator randomGenerator = new RandomGenerator();
        this.destPermutations = randomGenerator.generateAllDistinctPerturbations(this.k);
        this.destPermutationIds = new int[this.destPermutations.length];
        for (n = 0; n < this.destPermutations.length; ++n) {
            this.destPermutationIds[n] = this.generatePermutationId(this.destPermutations[n], this.k);
        }
        this.idToDestPermutationIndex = new int[MathsUtils.power(this.k, this.k)];
        for (n = 0; n < this.idToDestPermutationIndex.length; ++n) {
            this.idToDestPermutationIndex[n] = -1;
        }
        for (n = 0; n < this.destPermutationIds.length; ++n) {
            this.idToDestPermutationIndex[this.destPermutationIds[n]] = n;
        }
        this.sourcePermutations = randomGenerator.generateAllDistinctPerturbations(this.l);
        this.sourcePermutationIds = new int[this.sourcePermutations.length];
        for (n = 0; n < this.sourcePermutations.length; ++n) {
            this.sourcePermutationIds[n] = this.generatePermutationId(this.sourcePermutations[n], this.l);
        }
        this.idToSourcePermutationIndex = new int[MathsUtils.power(this.l, this.l)];
        for (n = 0; n < this.idToSourcePermutationIndex.length; ++n) {
            this.idToSourcePermutationIndex[n] = -1;
        }
        for (n = 0; n < this.sourcePermutationIds.length; ++n) {
            this.idToSourcePermutationIndex[this.sourcePermutationIds[n]] = n;
        }
        n = Math.max(this.destPermutationIds.length, this.sourcePermutationIds.length);
        this.teCalc = new TransferEntropyCalculatorDiscrete(n, 1);
        this.teCalc.initialise();
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase("l_HISTORY")) {
            this.l = Integer.parseInt(string2);
            this.lWasSet = true;
        } else {
            bl = false;
            super.setProperty(string, string2);
        }
        if (this.debug && bl) {
            System.out.println("Set property " + string + " to " + string2);
        }
    }

    @Override
    public String getProperty(String string) {
        if (string.equalsIgnoreCase("l_HISTORY")) {
            return Integer.toString(this.l);
        }
        return super.getProperty(string);
    }

    @Override
    public void finaliseAddObservations() {
        Object object2;
        this.totalObservations = 0;
        for (Object object2 : this.vectorOfDestinationObservations) {
            this.totalObservations += ((double[])object2).length - this.maxEmbeddingLength;
        }
        this.destSymbolsVector = new Vector();
        this.sourceSymbolsVector = new Vector();
        Iterator iterator = this.vectorOfDestinationObservations.iterator();
        object2 = this.vectorOfSourceObservations.iterator();
        while (object2.hasNext()) {
            int n;
            Object[] objectArray;
            double[] dArray = (double[])object2.next();
            double[] dArray2 = (double[])iterator.next();
            double[][] dArray3 = null;
            double[][] dArray4 = null;
            try {
                dArray3 = MatrixUtils.makeDelayEmbeddingVector(dArray2, this.k, this.k - 1, dArray2.length - this.k + 1);
                dArray4 = MatrixUtils.makeDelayEmbeddingVector(dArray, this.l, this.l - 1, dArray.length - this.l + 1);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            double[][] dArray5 = new double[this.k][2];
            int[] nArray = new int[dArray3.length];
            for (int i = 0; i < dArray3.length; ++i) {
                for (int j = 0; j < this.k; ++j) {
                    dArray5[j][0] = dArray3[i][j];
                    dArray5[j][1] = j;
                }
                Arrays.sort(dArray5, FirstIndexComparatorDouble.getInstance());
                objectArray = MatrixUtils.selectColumn(dArray5, 1);
                n = this.generatePermutationId((double[])objectArray, this.k);
                nArray[i] = this.idToDestPermutationIndex[n];
            }
            double[][] dArray6 = new double[this.l][2];
            objectArray = new int[dArray4.length];
            for (n = 0; n < dArray4.length; ++n) {
                for (int i = 0; i < this.l; ++i) {
                    dArray6[i][0] = dArray4[n][i];
                    dArray6[i][1] = i;
                }
                Arrays.sort(dArray6, FirstIndexComparatorDouble.getInstance());
                double[] dArray7 = MatrixUtils.selectColumn(dArray6, 1);
                int n2 = this.generatePermutationId(dArray7, this.l);
                objectArray[n] = this.idToSourcePermutationIndex[n2];
            }
            if (this.k > this.l) {
                objectArray = MatrixUtils.select(objectArray, this.k - this.l, objectArray.length - (this.k - this.l));
            } else if (this.l > this.k) {
                nArray = MatrixUtils.select(nArray, this.l - this.k, nArray.length - (this.l - this.k));
            }
            this.destSymbolsVector.add(nArray);
            this.sourceSymbolsVector.add((int[])objectArray);
            this.teCalc.addObservations((int[])objectArray, nArray);
            if (dArray2.length - this.maxEmbeddingLength == nArray.length - 1) continue;
            throw new RuntimeException(String.format("Number of observations %d doesn't match what's expected %d", nArray.length - 1, dArray2.length - this.maxEmbeddingLength));
        }
    }

    private int generatePermutationId(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n2 *= n;
            n2 += nArray[i];
        }
        return n2;
    }

    private int generatePermutationId(double[] dArray, int n) {
        int n2 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            n2 *= n;
            n2 += (int)dArray[i];
        }
        return n2;
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        this.lastAverage = this.teCalc.computeAverageLocalOfObservations();
        return this.lastAverage;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        double[] dArray = new double[this.totalObservations];
        int n = 0;
        Iterator<int[]> iterator = this.destSymbolsVector.iterator();
        for (int[] nArray : this.sourceSymbolsVector) {
            int[] nArray2 = iterator.next();
            double[] dArray2 = this.teCalc.computeLocalFromPreviousObservations(nArray, nArray2);
            System.arraycopy(dArray2, 1, dArray, n, dArray2.length - 1);
            n += dArray2.length - 1;
        }
        this.lastAverage = MatrixUtils.mean(dArray);
        return dArray;
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[] dArray, double[] dArray2) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) throws Exception {
        return this.teCalc.computeSignificance(n);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

