/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils;

import infodynamics.utils.FirstIndexComparatorDouble;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.NearestNeighbourSearcher;
import infodynamics.utils.NeighbourNodeData;
import java.util.Arrays;
import java.util.Collection;
import java.util.PriorityQueue;
import java.util.Vector;

public class UnivariateNearestNeighbourSearcher
extends NearestNeighbourSearcher {
    protected double[] originalDataSet;
    protected int numObservations = 0;
    protected int[] sortedArrayIndices = null;
    protected int[] indicesInSortedArray = null;
    protected double[] sortedValues = null;

    public UnivariateNearestNeighbourSearcher(double[][] dArray) throws Exception {
        this(MatrixUtils.selectColumn(dArray, 0));
        if (dArray[0].length != 1) {
            throw new Exception("Cannot define UnivariateNearestNeighbourSearcher for multivariate data");
        }
    }

    public UnivariateNearestNeighbourSearcher(double[] dArray) throws Exception {
        int n;
        this.originalDataSet = dArray;
        this.numObservations = dArray.length;
        if (this.numObservations <= 1) {
            throw new Exception("Nearest neighbour search is poorly defined for <=1 data point");
        }
        double[][] dArray2 = new double[this.numObservations][2];
        for (n = 0; n < this.numObservations; ++n) {
            dArray2[n][0] = dArray[n];
            dArray2[n][1] = n;
        }
        Arrays.sort(dArray2, FirstIndexComparatorDouble.getInstance());
        this.sortedArrayIndices = new int[this.numObservations];
        this.indicesInSortedArray = new int[this.numObservations];
        for (n = 0; n < this.numObservations; ++n) {
            this.sortedArrayIndices[n] = (int)dArray2[n][1];
            this.indicesInSortedArray[(int)dArray2[n][1]] = n;
        }
        this.sortedValues = new double[this.numObservations];
        for (n = 0; n < this.numObservations; ++n) {
            this.sortedValues[n] = this.originalDataSet[this.sortedArrayIndices[n]];
        }
    }

    protected static double norm(double d, double d2, int n) {
        switch (n) {
            case 2: {
                return Math.abs(d - d2);
            }
        }
        double d3 = d - d2;
        return d3 * d3;
    }

    @Override
    public NeighbourNodeData findNearestNeighbour(int n) {
        double d;
        int n2 = this.indicesInSortedArray[n];
        if (n2 == 0) {
            double d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[1]], this.normTypeToUse);
            return new NeighbourNodeData(this.sortedArrayIndices[1], new double[]{d2}, d2);
        }
        if (n2 == this.numObservations - 1) {
            double d3 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[this.numObservations - 2]], this.normTypeToUse);
            return new NeighbourNodeData(this.sortedArrayIndices[this.numObservations - 2], new double[]{d3}, d3);
        }
        double d4 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n2 + 1]], this.normTypeToUse);
        if (d4 < (d = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n2 - 1]], this.normTypeToUse))) {
            return new NeighbourNodeData(this.sortedArrayIndices[n2 + 1], new double[]{d4}, d4);
        }
        return new NeighbourNodeData(this.sortedArrayIndices[n2 - 1], new double[]{d4}, d4);
    }

    @Override
    public PriorityQueue<NeighbourNodeData> findKNearestNeighbours(int n, int n2) throws Exception {
        if (this.numObservations <= n) {
            throw new Exception("Not enough data points for a K nearest neighbours search");
        }
        int n3 = this.indicesInSortedArray[n2];
        int n4 = n3 == 0 ? -1 : n3 - 1;
        int n5 = n3 == this.numObservations - 1 ? -1 : n3 + 1;
        PriorityQueue<NeighbourNodeData> priorityQueue = new PriorityQueue<NeighbourNodeData>(n);
        for (int i = 0; i < n; ++i) {
            NeighbourNodeData neighbourNodeData;
            double d;
            double d2 = n5 == -1 ? Double.POSITIVE_INFINITY : UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n2], this.originalDataSet[this.sortedArrayIndices[n5]], this.normTypeToUse);
            double d3 = d = n4 == -1 ? Double.POSITIVE_INFINITY : UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n2], this.originalDataSet[this.sortedArrayIndices[n4]], this.normTypeToUse);
            if (d2 < d) {
                neighbourNodeData = new NeighbourNodeData(this.sortedArrayIndices[n5], new double[]{d2}, d2);
                n5 = n5 == this.numObservations - 1 ? -1 : n5 + 1;
            } else {
                neighbourNodeData = new NeighbourNodeData(this.sortedArrayIndices[n4], new double[]{d}, d);
                --n4;
            }
            priorityQueue.add(neighbourNodeData);
        }
        return priorityQueue;
    }

    @Override
    public PriorityQueue<NeighbourNodeData> findKNearestNeighbours(int n, int n2, int n3) throws Exception {
        int n4;
        int n5;
        if (this.numObservations <= n + 2 * n3) {
            throw new Exception("Not enough data points for a K nearest neighbours search with dynamic exclusion window of " + n3 + " points either side");
        }
        int n6 = this.indicesInSortedArray[n2];
        int n7 = -1;
        for (n5 = n6 - 1; n5 >= 0 && Math.abs(n2 - (n7 = this.sortedArrayIndices[n5])) <= n3; --n5) {
        }
        int n8 = -1;
        for (n4 = n6 + 1; n4 <= this.numObservations - 1 && Math.abs(n2 - (n8 = this.sortedArrayIndices[n4])) <= n3; ++n4) {
        }
        PriorityQueue<NeighbourNodeData> priorityQueue = new PriorityQueue<NeighbourNodeData>(n);
        for (int i = 0; i < n; ++i) {
            NeighbourNodeData neighbourNodeData;
            double d;
            double d2 = n4 == this.numObservations ? Double.POSITIVE_INFINITY : UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n2], this.originalDataSet[n8], this.normTypeToUse);
            double d3 = d = n5 == -1 ? Double.POSITIVE_INFINITY : UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n2], this.originalDataSet[n7], this.normTypeToUse);
            if (d2 < d) {
                neighbourNodeData = new NeighbourNodeData(n8, new double[]{d2}, d2);
                ++n4;
                while (n4 <= this.numObservations - 1 && Math.abs(n2 - (n8 = this.sortedArrayIndices[n4])) <= n3) {
                    ++n4;
                }
            } else {
                neighbourNodeData = new NeighbourNodeData(n7, new double[]{d}, d);
                --n5;
                while (n5 >= 0 && Math.abs(n2 - (n7 = this.sortedArrayIndices[n5])) <= n3) {
                    --n5;
                }
            }
            priorityQueue.add(neighbourNodeData);
        }
        return priorityQueue;
    }

    @Override
    public int countPointsWithinR(int n, double d, boolean bl) {
        double d2;
        int n2;
        int n3 = 0;
        int n4 = this.indicesInSortedArray[n];
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n2]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            ++n3;
        }
        for (n2 = n4 + 1; n2 < this.numObservations; ++n2) {
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n2]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            ++n3;
        }
        return n3;
    }

    public int countPointsWithinRs(int n, double d, double d2, boolean bl) {
        double d3;
        int n2;
        int n3 = 0;
        int n4 = this.indicesInSortedArray[n];
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            d3 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n2]], this.normTypeToUse);
            if (!(bl && d3 <= d2) && (bl || !(d3 < d2))) break;
            ++n3;
        }
        for (n2 = n4 + 1; n2 < this.numObservations; ++n2) {
            d3 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n2]], this.normTypeToUse);
            if (!(bl && d3 <= d) && (bl || !(d3 < d))) break;
            ++n3;
        }
        return n3;
    }

    @Override
    public int countPointsWithinR(int n, double d, int n2, boolean bl) {
        double d2;
        int n3;
        int n4 = 0;
        int n5 = this.indicesInSortedArray[n];
        for (n3 = n5 - 1; n3 >= 0; --n3) {
            if (Math.abs(n - this.sortedArrayIndices[n3]) <= n2) continue;
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n3]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            ++n4;
        }
        for (n3 = n5 + 1; n3 < this.numObservations; ++n3) {
            if (Math.abs(n - this.sortedArrayIndices[n3]) <= n2) continue;
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n3]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            ++n4;
        }
        return n4;
    }

    public int countPointsWithinROrLarger(int n, double d, boolean bl) {
        int n2 = 0;
        int n3 = this.indicesInSortedArray[n];
        for (int i = n3 - 1; i >= 0; --i) {
            double d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[i]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            ++n2;
        }
        return n2 += this.numObservations - n3 - 1;
    }

    public int countPointsSmallerAndOutsideR(int n, double d, boolean bl) {
        int n2;
        int n3 = this.indicesInSortedArray[n];
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            double d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n2]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
        }
        return n2 + 1;
    }

    @Override
    public int countPointsWithinR(double[][] dArray, double d, boolean bl) {
        if (dArray.length > 1) {
            throw new RuntimeException("sampleVectors[][] argument must have length 1 on each dimension when calling a UnivariateNearstNeighbourSearcher");
        }
        if (dArray[0].length > 1) {
            throw new RuntimeException("sampleVectors[][] argument must have length 1 on each dimension when calling a UnivariateNearstNeighbourSearcher");
        }
        return this.countPointsWithinR(dArray[0][0], d, bl);
    }

    public int countPointsWithinR(double d, double d2, boolean bl) {
        double d3;
        int n;
        int n2 = 0;
        int n3 = Arrays.binarySearch(this.sortedValues, d);
        if (n3 < 0) {
            n3 = -n3 - 1;
        }
        for (n = n3 - 1; n >= 0; --n) {
            d3 = UnivariateNearestNeighbourSearcher.norm(d, this.sortedValues[n], this.normTypeToUse);
            if (!(bl && d3 <= d2) && (bl || !(d3 < d2))) break;
            ++n2;
        }
        for (n = n3; n < this.numObservations; ++n) {
            d3 = UnivariateNearestNeighbourSearcher.norm(d, this.sortedValues[n], this.normTypeToUse);
            if (!(bl && d3 <= d2) && (bl || !(d3 < d2))) break;
            ++n2;
        }
        return n2;
    }

    @Override
    public Collection<NeighbourNodeData> findPointsWithinR(int n, double d, boolean bl) {
        double d2;
        int n2;
        Vector<NeighbourNodeData> vector = new Vector<NeighbourNodeData>();
        int n3 = this.indicesInSortedArray[n];
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n2]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            vector.add(new NeighbourNodeData(this.sortedArrayIndices[n2], new double[]{d2}, d2));
        }
        for (n2 = n3 + 1; n2 < this.numObservations; ++n2) {
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n2]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            vector.add(new NeighbourNodeData(this.sortedArrayIndices[n2], new double[]{d2}, d2));
        }
        return vector;
    }

    @Override
    public void findPointsWithinR(int n, double d, boolean bl, boolean[] blArray, int[] nArray) {
        double d2;
        int n2;
        int n3 = 0;
        int n4 = this.indicesInSortedArray[n];
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n2]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            blArray[this.sortedArrayIndices[n2]] = true;
            nArray[n3++] = this.sortedArrayIndices[n2];
        }
        for (n2 = n4 + 1; n2 < this.numObservations; ++n2) {
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n2]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            blArray[this.sortedArrayIndices[n2]] = true;
            nArray[n3++] = this.sortedArrayIndices[n2];
        }
        nArray[n3++] = -1;
    }

    @Override
    public void findPointsWithinR(int n, double d, int n2, boolean bl, boolean[] blArray, int[] nArray) {
        double d2;
        int n3;
        int n4 = 0;
        int n5 = this.indicesInSortedArray[n];
        for (n3 = n5 - 1; n3 >= 0; --n3) {
            if (Math.abs(n - this.sortedArrayIndices[n3]) <= n2) continue;
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n3]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            blArray[this.sortedArrayIndices[n3]] = true;
            nArray[n4++] = this.sortedArrayIndices[n3];
        }
        for (n3 = n5 + 1; n3 < this.numObservations; ++n3) {
            if (Math.abs(n - this.sortedArrayIndices[n3]) <= n2) continue;
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n3]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            blArray[this.sortedArrayIndices[n3]] = true;
            nArray[n4++] = this.sortedArrayIndices[n3];
        }
        nArray[n4++] = -1;
    }

    @Override
    public int findPointsWithinR(int n, double d, int n2, boolean bl, boolean[] blArray, double[] dArray, double[][] dArray2) {
        double d2;
        int n3;
        int n4 = 0;
        int n5 = this.indicesInSortedArray[n];
        for (n3 = n5 - 1; n3 >= 0; --n3) {
            if (Math.abs(n - this.sortedArrayIndices[n3]) <= n2) continue;
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n3]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            blArray[this.sortedArrayIndices[n3]] = true;
            dArray[this.sortedArrayIndices[n3]] = d2;
            dArray2[n4][0] = d2;
            dArray2[n4++][1] = this.sortedArrayIndices[n3];
        }
        for (n3 = n5 + 1; n3 < this.numObservations; ++n3) {
            if (Math.abs(n - this.sortedArrayIndices[n3]) <= n2) continue;
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n3]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            blArray[this.sortedArrayIndices[n3]] = true;
            dArray[this.sortedArrayIndices[n3]] = d2;
            dArray2[n4][0] = d2;
            dArray2[n4++][1] = this.sortedArrayIndices[n3];
        }
        dArray2[n4++][1] = -1.0;
        return n4 - 1;
    }

    public int findPointsWithinRAndTakeRadiusMax(int n, double d, int n2, boolean bl, boolean[] blArray, double[] dArray, double[][] dArray2) {
        double d2;
        int n3;
        int n4 = 0;
        int n5 = this.indicesInSortedArray[n];
        for (n3 = n5 - 1; n3 >= 0; --n3) {
            if (!blArray[this.sortedArrayIndices[n3]] || Math.abs(n - this.sortedArrayIndices[n3]) <= n2) continue;
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n3]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            if (d2 < dArray[this.sortedArrayIndices[n3]]) {
                d2 = dArray[this.sortedArrayIndices[n3]];
            }
            dArray2[n4][0] = d2;
            dArray2[n4++][1] = this.sortedArrayIndices[n3];
        }
        for (n3 = n5 + 1; n3 < this.numObservations; ++n3) {
            if (!blArray[this.sortedArrayIndices[n3]] || Math.abs(n - this.sortedArrayIndices[n3]) <= n2) continue;
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n3]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            if (d2 < dArray[this.sortedArrayIndices[n3]]) {
                d2 = dArray[this.sortedArrayIndices[n3]];
            }
            dArray2[n4][0] = d2;
            dArray2[n4++][1] = this.sortedArrayIndices[n3];
        }
        dArray2[n4++][1] = -1.0;
        return n4 - 1;
    }

    @Override
    public void findPointsWithinR(double d, double[][] dArray, boolean bl, boolean[] blArray, int[] nArray) {
        if (dArray.length > 1) {
            throw new RuntimeException("sampleVectors[][] argument must have length 1 on each dimension when calling a UnivariateNearstNeighbourSearcher");
        }
        if (dArray[0].length > 1) {
            throw new RuntimeException("sampleVectors[][] argument must have length 1 on each dimension when calling a UnivariateNearstNeighbourSearcher");
        }
        this.findPointsWithinR(d, dArray[0][0], bl, blArray, nArray);
    }

    public void findPointsWithinR(double d, double d2, boolean bl, boolean[] blArray, int[] nArray) {
        double d3;
        int n;
        int n2 = 0;
        int n3 = Arrays.binarySearch(this.sortedValues, d2);
        if (n3 < 0) {
            n3 = -n3 - 1;
        }
        for (n = n3 - 1; n >= 0; --n) {
            d3 = UnivariateNearestNeighbourSearcher.norm(d2, this.sortedValues[n], this.normTypeToUse);
            if (!(bl && d3 <= d) && (bl || !(d3 < d))) break;
            blArray[this.sortedArrayIndices[n]] = true;
            nArray[n2++] = this.sortedArrayIndices[n];
        }
        for (n = n3; n < this.numObservations; ++n) {
            d3 = UnivariateNearestNeighbourSearcher.norm(d2, this.sortedValues[n], this.normTypeToUse);
            if (!(bl && d3 <= d) && (bl || !(d3 < d))) break;
            blArray[this.sortedArrayIndices[n]] = true;
            nArray[n2++] = this.sortedArrayIndices[n];
        }
        nArray[n2++] = -1;
    }

    @Override
    public int countPointsWithinR(int n, double d, boolean bl, boolean[] blArray) {
        double d2;
        int n2;
        int n3 = 0;
        int n4 = this.indicesInSortedArray[n];
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            if (!blArray[this.sortedArrayIndices[n2]]) continue;
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n2]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            ++n3;
        }
        for (n2 = n4 + 1; n2 < this.numObservations; ++n2) {
            if (!blArray[this.sortedArrayIndices[n2]]) continue;
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n2]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            ++n3;
        }
        return n3;
    }

    @Override
    public int countPointsWithinR(int n, double d, boolean bl, boolean[] blArray, int[] nArray) {
        double d2;
        int n2;
        int n3 = 0;
        int n4 = this.indicesInSortedArray[n];
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            if (!blArray[nArray[this.sortedArrayIndices[n2]]]) continue;
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n2]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            ++n3;
        }
        for (n2 = n4 + 1; n2 < this.numObservations; ++n2) {
            if (!blArray[nArray[this.sortedArrayIndices[n2]]]) continue;
            d2 = UnivariateNearestNeighbourSearcher.norm(this.originalDataSet[n], this.originalDataSet[this.sortedArrayIndices[n2]], this.normTypeToUse);
            if (!(bl && d2 <= d) && (bl || !(d2 < d))) break;
            ++n3;
        }
        return n3;
    }

    @Override
    public int countPointsWithinR(double[][] dArray, double d, boolean bl, boolean[] blArray) {
        if (dArray.length > 1) {
            throw new RuntimeException("sampleVectors[][] argument must have length 1 on each dimension when calling a UnivariateNearstNeighbourSearcher");
        }
        if (dArray[0].length > 1) {
            throw new RuntimeException("sampleVectors[][] argument must have length 1 on each dimension when calling a UnivariateNearstNeighbourSearcher");
        }
        return this.countPointsWithinR(dArray[0][0], d, bl, blArray);
    }

    public int countPointsWithinR(double d, double d2, boolean bl, boolean[] blArray) {
        double d3;
        int n;
        int n2 = 0;
        int n3 = Arrays.binarySearch(this.sortedValues, d);
        if (n3 < 0) {
            n3 = -n3 - 1;
        }
        for (n = n3 - 1; n >= 0; --n) {
            if (!blArray[this.sortedArrayIndices[n]]) continue;
            d3 = UnivariateNearestNeighbourSearcher.norm(d, this.sortedValues[n], this.normTypeToUse);
            if (!(bl && d3 <= d2) && (bl || !(d3 < d2))) break;
            ++n2;
        }
        for (n = n3; n < this.numObservations; ++n) {
            if (!blArray[this.sortedArrayIndices[n]]) continue;
            d3 = UnivariateNearestNeighbourSearcher.norm(d, this.sortedValues[n], this.normTypeToUse);
            if (!(bl && d3 <= d2) && (bl || !(d3 < d2))) break;
            ++n2;
        }
        return n2;
    }

    public int getNumObservations() {
        return this.numObservations;
    }
}

