# coding: utf-8

"""
    SnapTrade

    Connect brokerage accounts to your app for live positions and trading

    The version of the OpenAPI document: 1.0.0
    Contact: api@snaptrade.com
    Created by: https://snaptrade.com/
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from snaptrade_client import schemas  # noqa: F401


class AccountOrderRecordLeg(
    schemas.DictSchema
):
    """
    This class is auto generated by Konfig (https://konfigthis.com)

    Describes an individual leg that makes up an order in the V2 format.
    """


    class MetaOapg:
        
        class properties:
            
            
            class leg_id(
                schemas.StrBase,
                schemas.NoneBase,
                schemas.Schema,
                schemas.NoneStrMixin
            ):
            
            
                def __new__(
                    cls,
                    *args: typing.Union[None, str, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'leg_id':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                    )
        
            @staticmethod
            def instrument() -> typing.Type['AccountOrderRecordLegInstrument']:
                return AccountOrderRecordLegInstrument
            action = schemas.StrSchema
            
            
            class execution_price(
                schemas.NumberBase,
                schemas.NoneBase,
                schemas.Schema,
                schemas.NoneDecimalMixin
            ):
            
            
                def __new__(
                    cls,
                    *args: typing.Union[None, decimal.Decimal, int, float, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'execution_price':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                    )
            
            
            class total_quantity(
                schemas.StrBase,
                schemas.NoneBase,
                schemas.Schema,
                schemas.NoneStrMixin
            ):
            
            
                def __new__(
                    cls,
                    *args: typing.Union[None, str, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'total_quantity':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                    )
            
            
            class canceled_quantity(
                schemas.StrBase,
                schemas.NoneBase,
                schemas.Schema,
                schemas.NoneStrMixin
            ):
            
            
                def __new__(
                    cls,
                    *args: typing.Union[None, str, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'canceled_quantity':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                    )
            
            
            class filled_quantity(
                schemas.StrBase,
                schemas.NoneBase,
                schemas.Schema,
                schemas.NoneStrMixin
            ):
            
            
                def __new__(
                    cls,
                    *args: typing.Union[None, str, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'filled_quantity':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                    )
        
            @staticmethod
            def status() -> typing.Type['AccountOrderRecordStatusV2Nullable']:
                return AccountOrderRecordStatusV2Nullable
            __annotations__ = {
                "leg_id": leg_id,
                "instrument": instrument,
                "action": action,
                "execution_price": execution_price,
                "total_quantity": total_quantity,
                "canceled_quantity": canceled_quantity,
                "filled_quantity": filled_quantity,
                "status": status,
            }
        additional_properties = schemas.AnyTypeSchema
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["leg_id"]) -> MetaOapg.properties.leg_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["instrument"]) -> 'AccountOrderRecordLegInstrument': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["action"]) -> MetaOapg.properties.action: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["execution_price"]) -> MetaOapg.properties.execution_price: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["total_quantity"]) -> MetaOapg.properties.total_quantity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["canceled_quantity"]) -> MetaOapg.properties.canceled_quantity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["filled_quantity"]) -> MetaOapg.properties.filled_quantity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["status"]) -> 'AccountOrderRecordStatusV2Nullable': ...
    
    @typing.overload
    def __getitem__(self, name: str) -> MetaOapg.additional_properties: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["leg_id"], typing_extensions.Literal["instrument"], typing_extensions.Literal["action"], typing_extensions.Literal["execution_price"], typing_extensions.Literal["total_quantity"], typing_extensions.Literal["canceled_quantity"], typing_extensions.Literal["filled_quantity"], typing_extensions.Literal["status"], str, ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["leg_id"]) -> typing.Union[MetaOapg.properties.leg_id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["instrument"]) -> typing.Union['AccountOrderRecordLegInstrument', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["action"]) -> typing.Union[MetaOapg.properties.action, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["execution_price"]) -> typing.Union[MetaOapg.properties.execution_price, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["total_quantity"]) -> typing.Union[MetaOapg.properties.total_quantity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["canceled_quantity"]) -> typing.Union[MetaOapg.properties.canceled_quantity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["filled_quantity"]) -> typing.Union[MetaOapg.properties.filled_quantity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["status"]) -> typing.Union['AccountOrderRecordStatusV2Nullable', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[MetaOapg.additional_properties, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["leg_id"], typing_extensions.Literal["instrument"], typing_extensions.Literal["action"], typing_extensions.Literal["execution_price"], typing_extensions.Literal["total_quantity"], typing_extensions.Literal["canceled_quantity"], typing_extensions.Literal["filled_quantity"], typing_extensions.Literal["status"], str, ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        leg_id: typing.Union[MetaOapg.properties.leg_id, None, str, schemas.Unset] = schemas.unset,
        instrument: typing.Union['AccountOrderRecordLegInstrument', schemas.Unset] = schemas.unset,
        action: typing.Union[MetaOapg.properties.action, str, schemas.Unset] = schemas.unset,
        execution_price: typing.Union[MetaOapg.properties.execution_price, None, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        total_quantity: typing.Union[MetaOapg.properties.total_quantity, None, str, schemas.Unset] = schemas.unset,
        canceled_quantity: typing.Union[MetaOapg.properties.canceled_quantity, None, str, schemas.Unset] = schemas.unset,
        filled_quantity: typing.Union[MetaOapg.properties.filled_quantity, None, str, schemas.Unset] = schemas.unset,
        status: typing.Union['AccountOrderRecordStatusV2Nullable', schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[MetaOapg.additional_properties, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
    ) -> 'AccountOrderRecordLeg':
        return super().__new__(
            cls,
            *args,
            leg_id=leg_id,
            instrument=instrument,
            action=action,
            execution_price=execution_price,
            total_quantity=total_quantity,
            canceled_quantity=canceled_quantity,
            filled_quantity=filled_quantity,
            status=status,
            _configuration=_configuration,
            **kwargs,
        )

from snaptrade_client.model.account_order_record_leg_instrument import AccountOrderRecordLegInstrument
from snaptrade_client.model.account_order_record_status_v2_nullable import AccountOrderRecordStatusV2Nullable
