import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Explicitly limits external functions that use the integration to reference one or more HTTPS proxy service endpoints and resources within those proxies.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration#api_allowed_prefixes ApiIntegration#api_allowed_prefixes}
    */
    readonly apiAllowedPrefixes: string[];
    /**
    * ARN of a cloud platform role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration#api_aws_role_arn ApiIntegration#api_aws_role_arn}
    */
    readonly apiAwsRoleArn?: string;
    /**
    * Lists the endpoints and resources in the HTTPS proxy service that are not allowed to be called from Snowflake.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration#api_blocked_prefixes ApiIntegration#api_blocked_prefixes}
    */
    readonly apiBlockedPrefixes?: string[];
    /**
    * Specifies the HTTPS proxy service type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration#api_provider ApiIntegration#api_provider}
    */
    readonly apiProvider: string;
    /**
    * The 'Application (client) id' of the Azure AD app for your remote service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration#azure_ad_application_id ApiIntegration#azure_ad_application_id}
    */
    readonly azureAdApplicationId?: string;
    /**
    * Specifies the ID for your Office 365 tenant that all Azure API Management instances belong to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration#azure_tenant_id ApiIntegration#azure_tenant_id}
    */
    readonly azureTenantId?: string;
    /**
    * Specifies whether this API integration is enabled or disabled. If the API integration is disabled, any external function that relies on it will not work.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration#enabled ApiIntegration#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Specifies the name of the API integration. This name follows the rules for Object Identifiers. The name should be unique among api integrations in your account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration#name ApiIntegration#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration snowflake_api_integration}
*/
export declare class ApiIntegration extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_api_integration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/api_integration snowflake_api_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiIntegrationConfig
    */
    constructor(scope: Construct, id: string, config: ApiIntegrationConfig);
    private _apiAllowedPrefixes?;
    get apiAllowedPrefixes(): string[];
    set apiAllowedPrefixes(value: string[]);
    get apiAllowedPrefixesInput(): string[] | undefined;
    get apiAwsExternalId(): string;
    get apiAwsIamUserArn(): string;
    private _apiAwsRoleArn?;
    get apiAwsRoleArn(): string;
    set apiAwsRoleArn(value: string);
    resetApiAwsRoleArn(): void;
    get apiAwsRoleArnInput(): string | undefined;
    private _apiBlockedPrefixes?;
    get apiBlockedPrefixes(): string[];
    set apiBlockedPrefixes(value: string[]);
    resetApiBlockedPrefixes(): void;
    get apiBlockedPrefixesInput(): string[] | undefined;
    private _apiProvider?;
    get apiProvider(): string;
    set apiProvider(value: string);
    get apiProviderInput(): string | undefined;
    private _azureAdApplicationId?;
    get azureAdApplicationId(): string;
    set azureAdApplicationId(value: string);
    resetAzureAdApplicationId(): void;
    get azureAdApplicationIdInput(): string | undefined;
    get azureConsentUrl(): string;
    get azureMultiTenantAppName(): string;
    private _azureTenantId?;
    get azureTenantId(): string;
    set azureTenantId(value: string);
    resetAzureTenantId(): void;
    get azureTenantIdInput(): string | undefined;
    get createdOn(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
