import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeFunctionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/functions#database DataSnowflakeFunctions#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the functions from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/functions#schema DataSnowflakeFunctions#schema}
    */
    readonly schema: string;
}
export interface DataSnowflakeFunctionsFunctions {
}
export declare function dataSnowflakeFunctionsFunctionsToTerraform(struct?: DataSnowflakeFunctionsFunctions): any;
export declare class DataSnowflakeFunctionsFunctionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeFunctionsFunctions | undefined;
    set internalValue(value: DataSnowflakeFunctionsFunctions | undefined);
    get argumentTypes(): string[];
    get comment(): string;
    get database(): string;
    get name(): string;
    get returnType(): string;
    get schema(): string;
}
export declare class DataSnowflakeFunctionsFunctionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeFunctionsFunctionsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/functions snowflake_functions}
*/
export declare class DataSnowflakeFunctions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_functions";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/functions snowflake_functions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeFunctionsConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeFunctionsConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _functions;
    get functions(): DataSnowflakeFunctionsFunctionsList;
    get id(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
