import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProcedureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the procedure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#comment Procedure#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the procedure. Don't use the | character.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#database Procedure#database}
    */
    readonly database: string;
    /**
    * Sets execute context - see caller's rights and owner's rights
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#execute_as Procedure#execute_as}
    */
    readonly executeAs?: string;
    /**
    * Specifies the identifier for the procedure; does not have to be unique for the schema in which the procedure is created. Don't use the | character.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#name Procedure#name}
    */
    readonly name: string;
    /**
    * Specifies the behavior of the procedure when called with null inputs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#null_input_behavior Procedure#null_input_behavior}
    */
    readonly nullInputBehavior?: string;
    /**
    * Specifies the behavior of the function when returning results
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#return_behavior Procedure#return_behavior}
    */
    readonly returnBehavior?: string;
    /**
    * The return type of the procedure
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#return_type Procedure#return_type}
    */
    readonly returnType: string;
    /**
    * The schema in which to create the procedure. Don't use the | character.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#schema Procedure#schema}
    */
    readonly schema: string;
    /**
    * Specifies the javascript code used to create the procedure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#statement Procedure#statement}
    */
    readonly statement: string;
    /**
    * arguments block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#arguments Procedure#arguments}
    */
    readonly arguments?: ProcedureArguments[] | cdktf.IResolvable;
}
export interface ProcedureArguments {
    /**
    * The argument name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#name Procedure#name}
    */
    readonly name: string;
    /**
    * The argument type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure#type Procedure#type}
    */
    readonly type: string;
}
export declare function procedureArgumentsToTerraform(struct?: ProcedureArguments | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/procedure snowflake_procedure}
*/
export declare class Procedure extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_procedure";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/procedure snowflake_procedure} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProcedureConfig
    */
    constructor(scope: Construct, id: string, config: ProcedureConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _executeAs?;
    get executeAs(): string;
    set executeAs(value: string);
    resetExecuteAs(): void;
    get executeAsInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nullInputBehavior?;
    get nullInputBehavior(): string;
    set nullInputBehavior(value: string);
    resetNullInputBehavior(): void;
    get nullInputBehaviorInput(): string | undefined;
    private _returnBehavior?;
    get returnBehavior(): string;
    set returnBehavior(value: string);
    resetReturnBehavior(): void;
    get returnBehaviorInput(): string | undefined;
    private _returnType?;
    get returnType(): string;
    set returnType(value: string);
    get returnTypeInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _statement?;
    get statement(): string;
    set statement(value: string);
    get statementInput(): string | undefined;
    private _arguments?;
    get arguments(): ProcedureArguments[] | cdktf.IResolvable;
    set arguments(value: ProcedureArguments[] | cdktf.IResolvable);
    resetArguments(): void;
    get argumentsInput(): cdktf.IResolvable | ProcedureArguments[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
