"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnowflakeProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake snowflake}
*/
class SnowflakeProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake snowflake} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SnowflakeProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.33.1',
                providerVersionConstraint: ' ~> 0.25'
            },
            terraformProviderSource: 'chanzuckerberg/snowflake'
        });
        this._account = config.account;
        this._browserAuth = config.browserAuth;
        this._host = config.host;
        this._oauthAccessToken = config.oauthAccessToken;
        this._oauthClientId = config.oauthClientId;
        this._oauthClientSecret = config.oauthClientSecret;
        this._oauthEndpoint = config.oauthEndpoint;
        this._oauthRedirectUrl = config.oauthRedirectUrl;
        this._oauthRefreshToken = config.oauthRefreshToken;
        this._password = config.password;
        this._privateKey = config.privateKey;
        this._privateKeyPassphrase = config.privateKeyPassphrase;
        this._privateKeyPath = config.privateKeyPath;
        this._region = config.region;
        this._role = config.role;
        this._username = config.username;
        this._alias = config.alias;
    }
    get account() {
        return this._account;
    }
    set account(value) {
        this._account = value;
    }
    // Temporarily expose input value. Use with caution.
    get accountInput() {
        return this._account;
    }
    get browserAuth() {
        return this._browserAuth;
    }
    set browserAuth(value) {
        this._browserAuth = value;
    }
    resetBrowserAuth() {
        this._browserAuth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get browserAuthInput() {
        return this._browserAuth;
    }
    get host() {
        return this._host;
    }
    set host(value) {
        this._host = value;
    }
    resetHost() {
        this._host = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostInput() {
        return this._host;
    }
    get oauthAccessToken() {
        return this._oauthAccessToken;
    }
    set oauthAccessToken(value) {
        this._oauthAccessToken = value;
    }
    resetOauthAccessToken() {
        this._oauthAccessToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthAccessTokenInput() {
        return this._oauthAccessToken;
    }
    get oauthClientId() {
        return this._oauthClientId;
    }
    set oauthClientId(value) {
        this._oauthClientId = value;
    }
    resetOauthClientId() {
        this._oauthClientId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthClientIdInput() {
        return this._oauthClientId;
    }
    get oauthClientSecret() {
        return this._oauthClientSecret;
    }
    set oauthClientSecret(value) {
        this._oauthClientSecret = value;
    }
    resetOauthClientSecret() {
        this._oauthClientSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthClientSecretInput() {
        return this._oauthClientSecret;
    }
    get oauthEndpoint() {
        return this._oauthEndpoint;
    }
    set oauthEndpoint(value) {
        this._oauthEndpoint = value;
    }
    resetOauthEndpoint() {
        this._oauthEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthEndpointInput() {
        return this._oauthEndpoint;
    }
    get oauthRedirectUrl() {
        return this._oauthRedirectUrl;
    }
    set oauthRedirectUrl(value) {
        this._oauthRedirectUrl = value;
    }
    resetOauthRedirectUrl() {
        this._oauthRedirectUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthRedirectUrlInput() {
        return this._oauthRedirectUrl;
    }
    get oauthRefreshToken() {
        return this._oauthRefreshToken;
    }
    set oauthRefreshToken(value) {
        this._oauthRefreshToken = value;
    }
    resetOauthRefreshToken() {
        this._oauthRefreshToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthRefreshTokenInput() {
        return this._oauthRefreshToken;
    }
    get password() {
        return this._password;
    }
    set password(value) {
        this._password = value;
    }
    resetPassword() {
        this._password = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInput() {
        return this._password;
    }
    get privateKey() {
        return this._privateKey;
    }
    set privateKey(value) {
        this._privateKey = value;
    }
    resetPrivateKey() {
        this._privateKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateKeyInput() {
        return this._privateKey;
    }
    get privateKeyPassphrase() {
        return this._privateKeyPassphrase;
    }
    set privateKeyPassphrase(value) {
        this._privateKeyPassphrase = value;
    }
    resetPrivateKeyPassphrase() {
        this._privateKeyPassphrase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateKeyPassphraseInput() {
        return this._privateKeyPassphrase;
    }
    get privateKeyPath() {
        return this._privateKeyPath;
    }
    set privateKeyPath(value) {
        this._privateKeyPath = value;
    }
    resetPrivateKeyPath() {
        this._privateKeyPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateKeyPathInput() {
        return this._privateKeyPath;
    }
    get region() {
        return this._region;
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    get role() {
        return this._role;
    }
    set role(value) {
        this._role = value;
    }
    resetRole() {
        this._role = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get roleInput() {
        return this._role;
    }
    get username() {
        return this._username;
    }
    set username(value) {
        this._username = value;
    }
    // Temporarily expose input value. Use with caution.
    get usernameInput() {
        return this._username;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            account: cdktf.stringToTerraform(this._account),
            browser_auth: cdktf.booleanToTerraform(this._browserAuth),
            host: cdktf.stringToTerraform(this._host),
            oauth_access_token: cdktf.stringToTerraform(this._oauthAccessToken),
            oauth_client_id: cdktf.stringToTerraform(this._oauthClientId),
            oauth_client_secret: cdktf.stringToTerraform(this._oauthClientSecret),
            oauth_endpoint: cdktf.stringToTerraform(this._oauthEndpoint),
            oauth_redirect_url: cdktf.stringToTerraform(this._oauthRedirectUrl),
            oauth_refresh_token: cdktf.stringToTerraform(this._oauthRefreshToken),
            password: cdktf.stringToTerraform(this._password),
            private_key: cdktf.stringToTerraform(this._privateKey),
            private_key_passphrase: cdktf.stringToTerraform(this._privateKeyPassphrase),
            private_key_path: cdktf.stringToTerraform(this._privateKeyPath),
            region: cdktf.stringToTerraform(this._region),
            role: cdktf.stringToTerraform(this._role),
            username: cdktf.stringToTerraform(this._username),
            alias: cdktf.stringToTerraform(this._alias),
        };
    }
}
exports.SnowflakeProvider = SnowflakeProvider;
_a = JSII_RTTI_SYMBOL_1;
SnowflakeProvider[_a] = { fqn: "@cdktf/provider-snowflake.SnowflakeProvider", version: "0.1.51" };
// =================
// STATIC PROPERTIES
// =================
SnowflakeProvider.tfResourceType = "snowflake";
//# sourceMappingURL=data:application/json;base64,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