# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.9.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class AllocationApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_allocation_composition_using_post(self, alloc_request, **kwargs):  # noqa: E501
        """Create an allocation composition  # noqa: E501

        Create a new allocation composition record for an allocation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_allocation_composition_using_post(alloc_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AllocationComposition alloc_request: allocRequest (required)
        :return: AllocationComposition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_allocation_composition_using_post_with_http_info(alloc_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_allocation_composition_using_post_with_http_info(alloc_request, **kwargs)  # noqa: E501
            return data

    def create_allocation_composition_using_post_with_http_info(self, alloc_request, **kwargs):  # noqa: E501
        """Create an allocation composition  # noqa: E501

        Create a new allocation composition record for an allocation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_allocation_composition_using_post_with_http_info(alloc_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AllocationComposition alloc_request: allocRequest (required)
        :return: AllocationComposition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['alloc_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_allocation_composition_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'alloc_request' is set
        if self.api_client.client_side_validation and ('alloc_request' not in params or
                                                       params['alloc_request'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `alloc_request` when calling `create_allocation_composition_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'alloc_request' in params:
            body_params = params['alloc_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/allocation_composition', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AllocationComposition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_allocation_using_post(self, allocation_request, **kwargs):  # noqa: E501
        """Create an allocation  # noqa: E501

        Create a new allocation for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_allocation_using_post(allocation_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Allocation allocation_request: allocationRequest (required)
        :return: Allocation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_allocation_using_post_with_http_info(allocation_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_allocation_using_post_with_http_info(allocation_request, **kwargs)  # noqa: E501
            return data

    def create_allocation_using_post_with_http_info(self, allocation_request, **kwargs):  # noqa: E501
        """Create an allocation  # noqa: E501

        Create a new allocation for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_allocation_using_post_with_http_info(allocation_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Allocation allocation_request: allocationRequest (required)
        :return: Allocation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['allocation_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_allocation_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'allocation_request' is set
        if self.api_client.client_side_validation and ('allocation_request' not in params or
                                                       params['allocation_request'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `allocation_request` when calling `create_allocation_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'allocation_request' in params:
            body_params = params['allocation_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/allocation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Allocation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_allocation_composition_using_delete(self, allocation_composition_id, **kwargs):  # noqa: E501
        """Delete an allocation composition  # noqa: E501

        Permanently delete an allocation composition record for an allocation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_allocation_composition_using_delete(allocation_composition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_composition_id: UUID allocation_composition_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_allocation_composition_using_delete_with_http_info(allocation_composition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_allocation_composition_using_delete_with_http_info(allocation_composition_id, **kwargs)  # noqa: E501
            return data

    def delete_allocation_composition_using_delete_with_http_info(self, allocation_composition_id, **kwargs):  # noqa: E501
        """Delete an allocation composition  # noqa: E501

        Permanently delete an allocation composition record for an allocation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_allocation_composition_using_delete_with_http_info(allocation_composition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_composition_id: UUID allocation_composition_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['allocation_composition_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_allocation_composition_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'allocation_composition_id' is set
        if self.api_client.client_side_validation and ('allocation_composition_id' not in params or
                                                       params['allocation_composition_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `allocation_composition_id` when calling `delete_allocation_composition_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'allocation_composition_id' in params:
            path_params['allocation_composition_id'] = params['allocation_composition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/allocation_composition/{allocation_composition_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_allocation_using_delete(self, allocation_id, **kwargs):  # noqa: E501
        """Delete an allocation  # noqa: E501

        Permanently delete an allocation defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_allocation_using_delete(allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_id: UUID allocation_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_allocation_using_delete_with_http_info(allocation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_allocation_using_delete_with_http_info(allocation_id, **kwargs)  # noqa: E501
            return data

    def delete_allocation_using_delete_with_http_info(self, allocation_id, **kwargs):  # noqa: E501
        """Delete an allocation  # noqa: E501

        Permanently delete an allocation defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_allocation_using_delete_with_http_info(allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_id: UUID allocation_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['allocation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_allocation_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'allocation_id' is set
        if self.api_client.client_side_validation and ('allocation_id' not in params or
                                                       params['allocation_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `allocation_id` when calling `delete_allocation_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'allocation_id' in params:
            path_params['allocation_id'] = params['allocation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/allocation/{allocation_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_allocation_all_aggregate_data_using_get(self, allocation_id, **kwargs):  # noqa: E501
        """List all Allocation aggregated data overview  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_all_aggregate_data_using_get(allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_id: Allocation Id (required)
        :return: AllocationAggregatedVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_allocation_all_aggregate_data_using_get_with_http_info(allocation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_allocation_all_aggregate_data_using_get_with_http_info(allocation_id, **kwargs)  # noqa: E501
            return data

    def get_allocation_all_aggregate_data_using_get_with_http_info(self, allocation_id, **kwargs):  # noqa: E501
        """List all Allocation aggregated data overview  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_all_aggregate_data_using_get_with_http_info(allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_id: Allocation Id (required)
        :return: AllocationAggregatedVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['allocation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_allocation_all_aggregate_data_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'allocation_id' is set
        if self.api_client.client_side_validation and ('allocation_id' not in params or
                                                       params['allocation_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `allocation_id` when calling `get_allocation_all_aggregate_data_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'allocation_id' in params:
            path_params['allocation_id'] = params['allocation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/allocation/{allocation_id}/aggregate_data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AllocationAggregatedVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_allocation_all_asset_size_all_using_get(self, allocation_id, **kwargs):  # noqa: E501
        """List all allocation asset sizes  # noqa: E501

        Get a list of asset sizes by date for a specific allocation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_all_asset_size_all_using_get(allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_id: UUID allocation_id (required)
        :param date end_date: end date
        :param bool get_latest: get_latest
        :param bool is_current_weight: is_current_weight
        :param str sort_type: D (Daily), Q (quarterly), M (Monthly), Y (Annually) 
        :param date start_date: start date
        :return: list[DateDoubleVO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_allocation_all_asset_size_all_using_get_with_http_info(allocation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_allocation_all_asset_size_all_using_get_with_http_info(allocation_id, **kwargs)  # noqa: E501
            return data

    def get_allocation_all_asset_size_all_using_get_with_http_info(self, allocation_id, **kwargs):  # noqa: E501
        """List all allocation asset sizes  # noqa: E501

        Get a list of asset sizes by date for a specific allocation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_all_asset_size_all_using_get_with_http_info(allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_id: UUID allocation_id (required)
        :param date end_date: end date
        :param bool get_latest: get_latest
        :param bool is_current_weight: is_current_weight
        :param str sort_type: D (Daily), Q (quarterly), M (Monthly), Y (Annually) 
        :param date start_date: start date
        :return: list[DateDoubleVO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['allocation_id', 'end_date', 'get_latest', 'is_current_weight', 'sort_type', 'start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_allocation_all_asset_size_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'allocation_id' is set
        if self.api_client.client_side_validation and ('allocation_id' not in params or
                                                       params['allocation_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `allocation_id` when calling `get_allocation_all_asset_size_all_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'allocation_id' in params:
            path_params['allocation_id'] = params['allocation_id']  # noqa: E501

        query_params = []
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'get_latest' in params:
            query_params.append(('get_latest', params['get_latest']))  # noqa: E501
        if 'is_current_weight' in params:
            query_params.append(('is_current_weight', params['is_current_weight']))  # noqa: E501
        if 'sort_type' in params:
            query_params.append(('sort_type', params['sort_type']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/allocation/{allocation_id}/asset_size', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DateDoubleVO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_allocation_all_holding_all_using_get(self, allocation_id, **kwargs):  # noqa: E501
        """List all allocation holdings  # noqa: E501

        Get the information for all securities assigned to a specific allocation.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_all_holding_all_using_get(allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_id: UUID allocation_id (required)
        :param date end_date: end date
        :param date start_date: start date
        :return: list[ModelHoldingVO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_allocation_all_holding_all_using_get_with_http_info(allocation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_allocation_all_holding_all_using_get_with_http_info(allocation_id, **kwargs)  # noqa: E501
            return data

    def get_allocation_all_holding_all_using_get_with_http_info(self, allocation_id, **kwargs):  # noqa: E501
        """List all allocation holdings  # noqa: E501

        Get the information for all securities assigned to a specific allocation.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_all_holding_all_using_get_with_http_info(allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_id: UUID allocation_id (required)
        :param date end_date: end date
        :param date start_date: start date
        :return: list[ModelHoldingVO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['allocation_id', 'end_date', 'start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_allocation_all_holding_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'allocation_id' is set
        if self.api_client.client_side_validation and ('allocation_id' not in params or
                                                       params['allocation_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `allocation_id` when calling `get_allocation_all_holding_all_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'allocation_id' in params:
            path_params['allocation_id'] = params['allocation_id']  # noqa: E501

        query_params = []
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/allocation/{allocation_id}/holding', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ModelHoldingVO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_allocation_all_transaction_all_using_get(self, allocation_id, **kwargs):  # noqa: E501
        """List all allocation transactions  # noqa: E501

        Get the information for all transactions made under an allocation to achieve the composition of the allocation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_all_transaction_all_using_get(allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_id: UUID allocation_id (required)
        :param bool ascending: ascending
        :param date end_date: end date
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :param date start_date: start date
        :return: PageModelTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_allocation_all_transaction_all_using_get_with_http_info(allocation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_allocation_all_transaction_all_using_get_with_http_info(allocation_id, **kwargs)  # noqa: E501
            return data

    def get_allocation_all_transaction_all_using_get_with_http_info(self, allocation_id, **kwargs):  # noqa: E501
        """List all allocation transactions  # noqa: E501

        Get the information for all transactions made under an allocation to achieve the composition of the allocation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_all_transaction_all_using_get_with_http_info(allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_id: UUID allocation_id (required)
        :param bool ascending: ascending
        :param date end_date: end date
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :param date start_date: start date
        :return: PageModelTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['allocation_id', 'ascending', 'end_date', 'order_by', 'page', 'size', 'start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_allocation_all_transaction_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'allocation_id' is set
        if self.api_client.client_side_validation and ('allocation_id' not in params or
                                                       params['allocation_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `allocation_id` when calling `get_allocation_all_transaction_all_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'allocation_id' in params:
            path_params['allocation_id'] = params['allocation_id']  # noqa: E501

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/allocation/{allocation_id}/transaction', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageModelTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_allocation_all_using_get(self, **kwargs):  # noqa: E501
        """List all allocations  # noqa: E501

        Get details for all allocations defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageAllocation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_allocation_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_allocation_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_allocation_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all allocations  # noqa: E501

        Get details for all allocations defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageAllocation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_allocation_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/allocation', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageAllocation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_allocation_composition_all_using_get(self, **kwargs):  # noqa: E501
        """List all allocations compositions  # noqa: E501

        Get the allocation composition for all allocations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_composition_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageAllocationComposition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_allocation_composition_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_allocation_composition_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_allocation_composition_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all allocations compositions  # noqa: E501

        Get the allocation composition for all allocations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_composition_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageAllocationComposition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_allocation_composition_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/allocation_composition', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageAllocationComposition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_allocation_composition_using_get(self, allocation_composition_id, **kwargs):  # noqa: E501
        """Retrieve an allocation composition  # noqa: E501

        Retrieve the information of an allocation composition record for an allocation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_composition_using_get(allocation_composition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_composition_id: UUID allocation_composition_id (required)
        :return: AllocationComposition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_allocation_composition_using_get_with_http_info(allocation_composition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_allocation_composition_using_get_with_http_info(allocation_composition_id, **kwargs)  # noqa: E501
            return data

    def get_allocation_composition_using_get_with_http_info(self, allocation_composition_id, **kwargs):  # noqa: E501
        """Retrieve an allocation composition  # noqa: E501

        Retrieve the information of an allocation composition record for an allocation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_composition_using_get_with_http_info(allocation_composition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_composition_id: UUID allocation_composition_id (required)
        :return: AllocationComposition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['allocation_composition_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_allocation_composition_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'allocation_composition_id' is set
        if self.api_client.client_side_validation and ('allocation_composition_id' not in params or
                                                       params['allocation_composition_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `allocation_composition_id` when calling `get_allocation_composition_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'allocation_composition_id' in params:
            path_params['allocation_composition_id'] = params['allocation_composition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/allocation_composition/{allocation_composition_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AllocationComposition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_allocation_using_get(self, allocation_id, **kwargs):  # noqa: E501
        """Retrieve an allocation  # noqa: E501

        Retrieve the information for an allocation defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_using_get(allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_id: UUID allocation_id (required)
        :return: Allocation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_allocation_using_get_with_http_info(allocation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_allocation_using_get_with_http_info(allocation_id, **kwargs)  # noqa: E501
            return data

    def get_allocation_using_get_with_http_info(self, allocation_id, **kwargs):  # noqa: E501
        """Retrieve an allocation  # noqa: E501

        Retrieve the information for an allocation defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_using_get_with_http_info(allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_id: UUID allocation_id (required)
        :return: Allocation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['allocation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_allocation_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'allocation_id' is set
        if self.api_client.client_side_validation and ('allocation_id' not in params or
                                                       params['allocation_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `allocation_id` when calling `get_allocation_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'allocation_id' in params:
            path_params['allocation_id'] = params['allocation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/allocation/{allocation_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Allocation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_allocation_composition_using_put(self, allocation_composition, allocation_composition_id, **kwargs):  # noqa: E501
        """Update an allocation composition  # noqa: E501

        Update the information of an allocation composition record for an allocation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_allocation_composition_using_put(allocation_composition, allocation_composition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object allocation_composition: allocation_composition (required)
        :param str allocation_composition_id: UUID allocation_composition_id (required)
        :return: AllocationComposition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_allocation_composition_using_put_with_http_info(allocation_composition, allocation_composition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_allocation_composition_using_put_with_http_info(allocation_composition, allocation_composition_id, **kwargs)  # noqa: E501
            return data

    def update_allocation_composition_using_put_with_http_info(self, allocation_composition, allocation_composition_id, **kwargs):  # noqa: E501
        """Update an allocation composition  # noqa: E501

        Update the information of an allocation composition record for an allocation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_allocation_composition_using_put_with_http_info(allocation_composition, allocation_composition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object allocation_composition: allocation_composition (required)
        :param str allocation_composition_id: UUID allocation_composition_id (required)
        :return: AllocationComposition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['allocation_composition', 'allocation_composition_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_allocation_composition_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'allocation_composition' is set
        if self.api_client.client_side_validation and ('allocation_composition' not in params or
                                                       params['allocation_composition'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `allocation_composition` when calling `update_allocation_composition_using_put`")  # noqa: E501
        # verify the required parameter 'allocation_composition_id' is set
        if self.api_client.client_side_validation and ('allocation_composition_id' not in params or
                                                       params['allocation_composition_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `allocation_composition_id` when calling `update_allocation_composition_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'allocation_composition_id' in params:
            path_params['allocation_composition_id'] = params['allocation_composition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'allocation_composition' in params:
            body_params = params['allocation_composition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/allocation_composition/{allocation_composition_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AllocationComposition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_allocation_using_put(self, allocation, allocation_id, **kwargs):  # noqa: E501
        """Update an allocation  # noqa: E501

        Update an allocation defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_allocation_using_put(allocation, allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object allocation: allocation (required)
        :param str allocation_id: UUID allocation_id (required)
        :return: Allocation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_allocation_using_put_with_http_info(allocation, allocation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_allocation_using_put_with_http_info(allocation, allocation_id, **kwargs)  # noqa: E501
            return data

    def update_allocation_using_put_with_http_info(self, allocation, allocation_id, **kwargs):  # noqa: E501
        """Update an allocation  # noqa: E501

        Update an allocation defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_allocation_using_put_with_http_info(allocation, allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object allocation: allocation (required)
        :param str allocation_id: UUID allocation_id (required)
        :return: Allocation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['allocation', 'allocation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_allocation_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'allocation' is set
        if self.api_client.client_side_validation and ('allocation' not in params or
                                                       params['allocation'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `allocation` when calling `update_allocation_using_put`")  # noqa: E501
        # verify the required parameter 'allocation_id' is set
        if self.api_client.client_side_validation and ('allocation_id' not in params or
                                                       params['allocation_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `allocation_id` when calling `update_allocation_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'allocation_id' in params:
            path_params['allocation_id'] = params['allocation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'allocation' in params:
            body_params = params['allocation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/allocation/{allocation_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Allocation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
