# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.9.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class ResourceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_fx_rate_bulk_using_post(self, fx_rate_list, **kwargs):  # noqa: E501
        """Create a bulk fxRate  # noqa: E501

        Create a bulk fxRate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_fx_rate_bulk_using_post(fx_rate_list, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FxRate] fx_rate_list: fxRateList (required)
        :return: list[FxRate]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_fx_rate_bulk_using_post_with_http_info(fx_rate_list, **kwargs)  # noqa: E501
        else:
            (data) = self.create_fx_rate_bulk_using_post_with_http_info(fx_rate_list, **kwargs)  # noqa: E501
            return data

    def create_fx_rate_bulk_using_post_with_http_info(self, fx_rate_list, **kwargs):  # noqa: E501
        """Create a bulk fxRate  # noqa: E501

        Create a bulk fxRate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_fx_rate_bulk_using_post_with_http_info(fx_rate_list, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[FxRate] fx_rate_list: fxRateList (required)
        :return: list[FxRate]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fx_rate_list']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_fx_rate_bulk_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'fx_rate_list' is set
        if self.api_client.client_side_validation and ('fx_rate_list' not in params or
                                                       params['fx_rate_list'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `fx_rate_list` when calling `create_fx_rate_bulk_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'fx_rate_list' in params:
            body_params = params['fx_rate_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/resource/fx_rate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[FxRate]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_institution_using_post(self, institution, **kwargs):  # noqa: E501
        """Create a institution  # noqa: E501

        Create a new institution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_institution_using_post(institution, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Institution institution: institution (required)
        :return: Institution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_institution_using_post_with_http_info(institution, **kwargs)  # noqa: E501
        else:
            (data) = self.create_institution_using_post_with_http_info(institution, **kwargs)  # noqa: E501
            return data

    def create_institution_using_post_with_http_info(self, institution, **kwargs):  # noqa: E501
        """Create a institution  # noqa: E501

        Create a new institution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_institution_using_post_with_http_info(institution, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Institution institution: institution (required)
        :return: Institution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['institution']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_institution_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'institution' is set
        if self.api_client.client_side_validation and ('institution' not in params or
                                                       params['institution'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `institution` when calling `create_institution_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'institution' in params:
            body_params = params['institution']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/resource/institution', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Institution',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_institution_using_delete(self, institution_id, **kwargs):  # noqa: E501
        """Delete a institution  # noqa: E501

        Delete a institution.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_institution_using_delete(institution_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str institution_id: UUID institution_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_institution_using_delete_with_http_info(institution_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_institution_using_delete_with_http_info(institution_id, **kwargs)  # noqa: E501
            return data

    def delete_institution_using_delete_with_http_info(self, institution_id, **kwargs):  # noqa: E501
        """Delete a institution  # noqa: E501

        Delete a institution.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_institution_using_delete_with_http_info(institution_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str institution_id: UUID institution_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['institution_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_institution_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'institution_id' is set
        if self.api_client.client_side_validation and ('institution_id' not in params or
                                                       params['institution_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `institution_id` when calling `delete_institution_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'institution_id' in params:
            path_params['institution_id'] = params['institution_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/resource/institution/{institution_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_result_for_mapping(self, **kwargs):  # noqa: E501
        """Get all account category mapping  # noqa: E501

        Get all account category mapping  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_result_for_mapping(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: filter
        :param str hydrogen_account_category_id: hydrogen_account_category_id
        :param bool match_primary: match_primary
        :param str tenant_name: tenant_name
        :param str vendor_name: vendor_name
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_result_for_mapping_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_account_result_for_mapping_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_account_result_for_mapping_with_http_info(self, **kwargs):  # noqa: E501
        """Get all account category mapping  # noqa: E501

        Get all account category mapping  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_result_for_mapping_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: filter
        :param str hydrogen_account_category_id: hydrogen_account_category_id
        :param bool match_primary: match_primary
        :param str tenant_name: tenant_name
        :param str vendor_name: vendor_name
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'hydrogen_account_category_id', 'match_primary', 'tenant_name', 'vendor_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_result_for_mapping" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'hydrogen_account_category_id' in params:
            query_params.append(('hydrogen_account_category_id', params['hydrogen_account_category_id']))  # noqa: E501
        if 'match_primary' in params:
            query_params.append(('match_primary', params['match_primary']))  # noqa: E501
        if 'tenant_name' in params:
            query_params.append(('tenant_name', params['tenant_name']))  # noqa: E501
        if 'vendor_name' in params:
            query_params.append(('vendor_name', params['vendor_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/resource/account_category', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[object]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_country_using_get(self, **kwargs):  # noqa: E501
        """Get All Countries  # noqa: E501

        Get All Countries.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_country_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Country]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_country_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_country_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_country_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get All Countries  # noqa: E501

        Get All Countries.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_country_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Country]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_country_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/resource/country', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Country]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_currency_using_get(self, **kwargs):  # noqa: E501
        """Get All Currencies  # noqa: E501

        Get All Currencies.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_currency_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Currency]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_currency_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_currency_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_currency_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get All Currencies  # noqa: E501

        Get All Currencies.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_currency_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Currency]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_currency_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/resource/currency', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Currency]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_merchant_category_code_using_get(self, **kwargs):  # noqa: E501
        """Get All Merchant Category Codes  # noqa: E501

        Get All Merchant Category Codes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_merchant_category_code_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: filter
        :return: list[MerchantCategoryCode]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_merchant_category_code_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_merchant_category_code_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_merchant_category_code_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get All Merchant Category Codes  # noqa: E501

        Get All Merchant Category Codes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_merchant_category_code_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: filter
        :return: list[MerchantCategoryCode]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_merchant_category_code_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/resource/merchant_category_code', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MerchantCategoryCode]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_states_using_get(self, **kwargs):  # noqa: E501
        """List all state resource  # noqa: E501

        Get the information for all possible state resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_states_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str country_code: country_code
        :return: list[State]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_states_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_states_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_states_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all state resource  # noqa: E501

        Get the information for all possible state resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_states_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str country_code: country_code
        :return: list[State]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['country_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_states_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'country_code' in params:
            query_params.append(('country_code', params['country_code']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/resource/state', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[State]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_statistics_using_get(self, **kwargs):  # noqa: E501
        """List all statistic resource  # noqa: E501

        Get the information for all possible statistic resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_statistics_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: dict(str, list[StatisticResourceVO])
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_statistics_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_statistics_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_statistics_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all statistic resource  # noqa: E501

        Get the information for all possible statistic resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_statistics_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: dict(str, list[StatisticResourceVO])
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_statistics_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/resource/statistic', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, list[StatisticResourceVO])',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_currency_exchange_rate_all_using_get(self, **kwargs):  # noqa: E501
        """List all fxRates  # noqa: E501

        Get information for all fxRates defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_currency_exchange_rate_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: filter
        :return: list[FxRateView]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_currency_exchange_rate_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_currency_exchange_rate_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_currency_exchange_rate_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all fxRates  # noqa: E501

        Get information for all fxRates defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_currency_exchange_rate_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: filter
        :return: list[FxRateView]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_currency_exchange_rate_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/resource/fx_rate', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[FxRateView]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_institution_all_using_get(self, **kwargs):  # noqa: E501
        """List all institutions  # noqa: E501

        List all institution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_institution_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageInstitution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_institution_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_institution_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_institution_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all institutions  # noqa: E501

        List all institution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_institution_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageInstitution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_institution_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/resource/institution', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageInstitution',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_institution_using_get(self, institution_id, **kwargs):  # noqa: E501
        """Retrieve a institution  # noqa: E501

        Retrieve a institution.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_institution_using_get(institution_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str institution_id: UUID institution_id (required)
        :return: Institution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_institution_using_get_with_http_info(institution_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_institution_using_get_with_http_info(institution_id, **kwargs)  # noqa: E501
            return data

    def get_institution_using_get_with_http_info(self, institution_id, **kwargs):  # noqa: E501
        """Retrieve a institution  # noqa: E501

        Retrieve a institution.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_institution_using_get_with_http_info(institution_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str institution_id: UUID institution_id (required)
        :return: Institution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['institution_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_institution_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'institution_id' is set
        if self.api_client.client_side_validation and ('institution_id' not in params or
                                                       params['institution_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `institution_id` when calling `get_institution_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'institution_id' in params:
            path_params['institution_id'] = params['institution_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/resource/institution/{institution_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Institution',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_merchants_all_using_get(self, **kwargs):  # noqa: E501
        """Get all merchants  # noqa: E501

        List all merchants.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_merchants_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: MXMerchantRes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_merchants_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_merchants_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_merchants_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get all merchants  # noqa: E501

        List all merchants.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_merchants_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: MXMerchantRes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_merchants_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/resource/merchant', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MXMerchantRes',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transaction_result_for_mapping(self, **kwargs):  # noqa: E501
        """Get all transaction category mapping  # noqa: E501

        Get all transaction category mapping  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction_result_for_mapping(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: filter
        :param str hydrogen_transaction_category_id: hydrogen_transaction_category_id
        :param bool match_primary: match_primary
        :param str tenant_name: tenant_name
        :param str vendor_name: vendor_name
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_transaction_result_for_mapping_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_transaction_result_for_mapping_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_transaction_result_for_mapping_with_http_info(self, **kwargs):  # noqa: E501
        """Get all transaction category mapping  # noqa: E501

        Get all transaction category mapping  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction_result_for_mapping_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: filter
        :param str hydrogen_transaction_category_id: hydrogen_transaction_category_id
        :param bool match_primary: match_primary
        :param str tenant_name: tenant_name
        :param str vendor_name: vendor_name
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'hydrogen_transaction_category_id', 'match_primary', 'tenant_name', 'vendor_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transaction_result_for_mapping" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'hydrogen_transaction_category_id' in params:
            query_params.append(('hydrogen_transaction_category_id', params['hydrogen_transaction_category_id']))  # noqa: E501
        if 'match_primary' in params:
            query_params.append(('match_primary', params['match_primary']))  # noqa: E501
        if 'tenant_name' in params:
            query_params.append(('tenant_name', params['tenant_name']))  # noqa: E501
        if 'vendor_name' in params:
            query_params.append(('vendor_name', params['vendor_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/resource/transaction_category', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[object]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_institution_using_put(self, institution, institution_id, **kwargs):  # noqa: E501
        """Update a institution  # noqa: E501

        Update a institution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_institution_using_put(institution, institution_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object institution: institution (required)
        :param str institution_id: UUID institution_id (required)
        :return: Institution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_institution_using_put_with_http_info(institution, institution_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_institution_using_put_with_http_info(institution, institution_id, **kwargs)  # noqa: E501
            return data

    def update_institution_using_put_with_http_info(self, institution, institution_id, **kwargs):  # noqa: E501
        """Update a institution  # noqa: E501

        Update a institution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_institution_using_put_with_http_info(institution, institution_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object institution: institution (required)
        :param str institution_id: UUID institution_id (required)
        :return: Institution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['institution', 'institution_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_institution_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'institution' is set
        if self.api_client.client_side_validation and ('institution' not in params or
                                                       params['institution'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `institution` when calling `update_institution_using_put`")  # noqa: E501
        # verify the required parameter 'institution_id' is set
        if self.api_client.client_side_validation and ('institution_id' not in params or
                                                       params['institution_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `institution_id` when calling `update_institution_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'institution_id' in params:
            path_params['institution_id'] = params['institution_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'institution' in params:
            body_params = params['institution']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/resource/institution/{institution_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Institution',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
