# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.9.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class FundingApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_bank_link_using_post(self, bank_link_info_request, **kwargs):  # noqa: E501
        """Create a bank link  # noqa: E501

        Create a new bank link for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bank_link_using_post(bank_link_info_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BankLink bank_link_info_request: bankLinkInfoRequest (required)
        :return: BankLink
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_bank_link_using_post_with_http_info(bank_link_info_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_bank_link_using_post_with_http_info(bank_link_info_request, **kwargs)  # noqa: E501
            return data

    def create_bank_link_using_post_with_http_info(self, bank_link_info_request, **kwargs):  # noqa: E501
        """Create a bank link  # noqa: E501

        Create a new bank link for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bank_link_using_post_with_http_info(bank_link_info_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BankLink bank_link_info_request: bankLinkInfoRequest (required)
        :return: BankLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_link_info_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bank_link_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_link_info_request' is set
        if self.api_client.client_side_validation and ('bank_link_info_request' not in params or
                                                       params['bank_link_info_request'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_link_info_request` when calling `create_bank_link_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bank_link_info_request' in params:
            body_params = params['bank_link_info_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/bank_link', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BankLink',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_funding_transaction_using_post(self, funding_transaction_request, **kwargs):  # noqa: E501
        """Create a funding transaction request  # noqa: E501

        Create a new funding transaction request for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_funding_transaction_using_post(funding_transaction_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FundingTransaction funding_transaction_request: fundingTransactionRequest (required)
        :return: FundingTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_funding_transaction_using_post_with_http_info(funding_transaction_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_funding_transaction_using_post_with_http_info(funding_transaction_request, **kwargs)  # noqa: E501
            return data

    def create_funding_transaction_using_post_with_http_info(self, funding_transaction_request, **kwargs):  # noqa: E501
        """Create a funding transaction request  # noqa: E501

        Create a new funding transaction request for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_funding_transaction_using_post_with_http_info(funding_transaction_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FundingTransaction funding_transaction_request: fundingTransactionRequest (required)
        :return: FundingTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['funding_transaction_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_funding_transaction_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'funding_transaction_request' is set
        if self.api_client.client_side_validation and ('funding_transaction_request' not in params or
                                                       params['funding_transaction_request'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `funding_transaction_request` when calling `create_funding_transaction_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'funding_transaction_request' in params:
            body_params = params['funding_transaction_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/funding_transaction', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FundingTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_funding_using_post(self, funding_request, **kwargs):  # noqa: E501
        """Create a funding request  # noqa: E501

        Create a new funding request for an account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_funding_using_post(funding_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Funding funding_request: fundingRequest (required)
        :return: Funding
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_funding_using_post_with_http_info(funding_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_funding_using_post_with_http_info(funding_request, **kwargs)  # noqa: E501
            return data

    def create_funding_using_post_with_http_info(self, funding_request, **kwargs):  # noqa: E501
        """Create a funding request  # noqa: E501

        Create a new funding request for an account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_funding_using_post_with_http_info(funding_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Funding funding_request: fundingRequest (required)
        :return: Funding
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['funding_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_funding_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'funding_request' is set
        if self.api_client.client_side_validation and ('funding_request' not in params or
                                                       params['funding_request'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `funding_request` when calling `create_funding_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'funding_request' in params:
            body_params = params['funding_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/funding', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Funding',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_transfer_using_post(self, external_account_transfer_request, **kwargs):  # noqa: E501
        """Create a transfer requests  # noqa: E501

        Create a new external account transfer for a client account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_transfer_using_post(external_account_transfer_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ExternalAccountTransfer external_account_transfer_request: externalAccountTransferRequest (required)
        :return: ExternalAccountTransfer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_transfer_using_post_with_http_info(external_account_transfer_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_transfer_using_post_with_http_info(external_account_transfer_request, **kwargs)  # noqa: E501
            return data

    def create_transfer_using_post_with_http_info(self, external_account_transfer_request, **kwargs):  # noqa: E501
        """Create a transfer requests  # noqa: E501

        Create a new external account transfer for a client account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_transfer_using_post_with_http_info(external_account_transfer_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ExternalAccountTransfer external_account_transfer_request: externalAccountTransferRequest (required)
        :return: ExternalAccountTransfer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_account_transfer_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_transfer_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'external_account_transfer_request' is set
        if self.api_client.client_side_validation and ('external_account_transfer_request' not in params or
                                                       params['external_account_transfer_request'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `external_account_transfer_request` when calling `create_transfer_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'external_account_transfer_request' in params:
            body_params = params['external_account_transfer_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/transfer', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExternalAccountTransfer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_bank_link_using_delete(self, bank_link_id, **kwargs):  # noqa: E501
        """Delete a bank link  # noqa: E501

        Permanently delete a bank link defined for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bank_link_using_delete(bank_link_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_link_id: UUID bank_link_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_bank_link_using_delete_with_http_info(bank_link_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_bank_link_using_delete_with_http_info(bank_link_id, **kwargs)  # noqa: E501
            return data

    def delete_bank_link_using_delete_with_http_info(self, bank_link_id, **kwargs):  # noqa: E501
        """Delete a bank link  # noqa: E501

        Permanently delete a bank link defined for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bank_link_using_delete_with_http_info(bank_link_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_link_id: UUID bank_link_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_link_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_bank_link_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_link_id' is set
        if self.api_client.client_side_validation and ('bank_link_id' not in params or
                                                       params['bank_link_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_link_id` when calling `delete_bank_link_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_link_id' in params:
            path_params['bank_link_id'] = params['bank_link_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/bank_link/{bank_link_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_funding_transaction_using_delete(self, funding_transaction_id, **kwargs):  # noqa: E501
        """Delete a funding transaction request  # noqa: E501

        Permanently delete a funding transaction request for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_funding_transaction_using_delete(funding_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str funding_transaction_id: UUID funding_transaction_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_funding_transaction_using_delete_with_http_info(funding_transaction_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_funding_transaction_using_delete_with_http_info(funding_transaction_id, **kwargs)  # noqa: E501
            return data

    def delete_funding_transaction_using_delete_with_http_info(self, funding_transaction_id, **kwargs):  # noqa: E501
        """Delete a funding transaction request  # noqa: E501

        Permanently delete a funding transaction request for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_funding_transaction_using_delete_with_http_info(funding_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str funding_transaction_id: UUID funding_transaction_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['funding_transaction_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_funding_transaction_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'funding_transaction_id' is set
        if self.api_client.client_side_validation and ('funding_transaction_id' not in params or
                                                       params['funding_transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `funding_transaction_id` when calling `delete_funding_transaction_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'funding_transaction_id' in params:
            path_params['funding_transaction_id'] = params['funding_transaction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/funding_transaction/{funding_transaction_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_funding_using_delete(self, funding_id, **kwargs):  # noqa: E501
        """Delete a funding request  # noqa: E501

        Permanently delete a funding request defined for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_funding_using_delete(funding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str funding_id: UUID funding_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_funding_using_delete_with_http_info(funding_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_funding_using_delete_with_http_info(funding_id, **kwargs)  # noqa: E501
            return data

    def delete_funding_using_delete_with_http_info(self, funding_id, **kwargs):  # noqa: E501
        """Delete a funding request  # noqa: E501

        Permanently delete a funding request defined for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_funding_using_delete_with_http_info(funding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str funding_id: UUID funding_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['funding_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_funding_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'funding_id' is set
        if self.api_client.client_side_validation and ('funding_id' not in params or
                                                       params['funding_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `funding_id` when calling `delete_funding_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'funding_id' in params:
            path_params['funding_id'] = params['funding_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/funding/{funding_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_transfer_using_delete(self, transfer_id, **kwargs):  # noqa: E501
        """Delete a transfer request  # noqa: E501

        Permanently delete a external account transfer from a client account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_transfer_using_delete(transfer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str transfer_id: UUID external_account_transfer_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_transfer_using_delete_with_http_info(transfer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_transfer_using_delete_with_http_info(transfer_id, **kwargs)  # noqa: E501
            return data

    def delete_transfer_using_delete_with_http_info(self, transfer_id, **kwargs):  # noqa: E501
        """Delete a transfer request  # noqa: E501

        Permanently delete a external account transfer from a client account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_transfer_using_delete_with_http_info(transfer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str transfer_id: UUID external_account_transfer_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['transfer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_transfer_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'transfer_id' is set
        if self.api_client.client_side_validation and ('transfer_id' not in params or
                                                       params['transfer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transfer_id` when calling `delete_transfer_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transfer_id' in params:
            path_params['transfer_id'] = params['transfer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/transfer/{transfer_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bank_link_all_using_get(self, **kwargs):  # noqa: E501
        """List all bank links  # noqa: E501

        Get all bank links defined for all clients defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bank_link_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageBankLink
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bank_link_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_bank_link_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_bank_link_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all bank links  # noqa: E501

        Get all bank links defined for all clients defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bank_link_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageBankLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'currency_conversion', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bank_link_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/bank_link', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageBankLink',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bank_link_using_get(self, bank_link_id, **kwargs):  # noqa: E501
        """Retrieve a bank link  # noqa: E501

        Retrieve the information for a bank link for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bank_link_using_get(bank_link_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_link_id: UUID bank_link_id (required)
        :param str currency_conversion: USD
        :return: BankLink
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bank_link_using_get_with_http_info(bank_link_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bank_link_using_get_with_http_info(bank_link_id, **kwargs)  # noqa: E501
            return data

    def get_bank_link_using_get_with_http_info(self, bank_link_id, **kwargs):  # noqa: E501
        """Retrieve a bank link  # noqa: E501

        Retrieve the information for a bank link for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bank_link_using_get_with_http_info(bank_link_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_link_id: UUID bank_link_id (required)
        :param str currency_conversion: USD
        :return: BankLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_link_id', 'currency_conversion']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bank_link_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_link_id' is set
        if self.api_client.client_side_validation and ('bank_link_id' not in params or
                                                       params['bank_link_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_link_id` when calling `get_bank_link_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_link_id' in params:
            path_params['bank_link_id'] = params['bank_link_id']  # noqa: E501

        query_params = []
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/bank_link/{bank_link_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BankLink',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_funding_all_using_get(self, **kwargs):  # noqa: E501
        """List all funding requests   # noqa: E501

        Get the information for all funding requests defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_funding_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageFunding
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_funding_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_funding_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_funding_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all funding requests   # noqa: E501

        Get the information for all funding requests defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_funding_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageFunding
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'currency_conversion', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_funding_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/funding', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageFunding',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_funding_transaction_all_using_get(self, **kwargs):  # noqa: E501
        """List all funding transaction requests  # noqa: E501

        Get the information for all funding transaction requests for all clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_funding_transaction_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageFundingTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_funding_transaction_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_funding_transaction_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_funding_transaction_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all funding transaction requests  # noqa: E501

        Get the information for all funding transaction requests for all clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_funding_transaction_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageFundingTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'currency_conversion', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_funding_transaction_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/funding_transaction', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageFundingTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_funding_transaction_using_get(self, funding_transaction_id, **kwargs):  # noqa: E501
        """Retrieve a funding transaction request  # noqa: E501

        Retrieve the information for a funding transaction request for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_funding_transaction_using_get(funding_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str funding_transaction_id: UUID funding_transaction_id (required)
        :param str currency_conversion: USD
        :return: FundingTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_funding_transaction_using_get_with_http_info(funding_transaction_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_funding_transaction_using_get_with_http_info(funding_transaction_id, **kwargs)  # noqa: E501
            return data

    def get_funding_transaction_using_get_with_http_info(self, funding_transaction_id, **kwargs):  # noqa: E501
        """Retrieve a funding transaction request  # noqa: E501

        Retrieve the information for a funding transaction request for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_funding_transaction_using_get_with_http_info(funding_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str funding_transaction_id: UUID funding_transaction_id (required)
        :param str currency_conversion: USD
        :return: FundingTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['funding_transaction_id', 'currency_conversion']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_funding_transaction_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'funding_transaction_id' is set
        if self.api_client.client_side_validation and ('funding_transaction_id' not in params or
                                                       params['funding_transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `funding_transaction_id` when calling `get_funding_transaction_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'funding_transaction_id' in params:
            path_params['funding_transaction_id'] = params['funding_transaction_id']  # noqa: E501

        query_params = []
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/funding_transaction/{funding_transaction_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FundingTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_funding_using_get(self, funding_id, **kwargs):  # noqa: E501
        """Retrieve a funding request  # noqa: E501

        Retrieve the information for a funding request for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_funding_using_get(funding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str funding_id: UUID funding_id (required)
        :param str currency_conversion: USD
        :return: Funding
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_funding_using_get_with_http_info(funding_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_funding_using_get_with_http_info(funding_id, **kwargs)  # noqa: E501
            return data

    def get_funding_using_get_with_http_info(self, funding_id, **kwargs):  # noqa: E501
        """Retrieve a funding request  # noqa: E501

        Retrieve the information for a funding request for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_funding_using_get_with_http_info(funding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str funding_id: UUID funding_id (required)
        :param str currency_conversion: USD
        :return: Funding
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['funding_id', 'currency_conversion']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_funding_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'funding_id' is set
        if self.api_client.client_side_validation and ('funding_id' not in params or
                                                       params['funding_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `funding_id` when calling `get_funding_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'funding_id' in params:
            path_params['funding_id'] = params['funding_id']  # noqa: E501

        query_params = []
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/funding/{funding_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Funding',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transfer_all_using_get(self, **kwargs):  # noqa: E501
        """List all transfer requests  # noqa: E501

        Get the information for all external account transfers defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transfer_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageExternalAccountTransfer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_transfer_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_transfer_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_transfer_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all transfer requests  # noqa: E501

        Get the information for all external account transfers defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transfer_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageExternalAccountTransfer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'currency_conversion', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transfer_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/transfer', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageExternalAccountTransfer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transfer_using_get(self, transfer_id, **kwargs):  # noqa: E501
        """Retrieve a transfer request  # noqa: E501

        Retrieve the information for a external account transfer for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transfer_using_get(transfer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str transfer_id: UUID external_account_transfer_id (required)
        :param str currency_conversion: USD
        :return: ExternalAccountTransfer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_transfer_using_get_with_http_info(transfer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_transfer_using_get_with_http_info(transfer_id, **kwargs)  # noqa: E501
            return data

    def get_transfer_using_get_with_http_info(self, transfer_id, **kwargs):  # noqa: E501
        """Retrieve a transfer request  # noqa: E501

        Retrieve the information for a external account transfer for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transfer_using_get_with_http_info(transfer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str transfer_id: UUID external_account_transfer_id (required)
        :param str currency_conversion: USD
        :return: ExternalAccountTransfer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['transfer_id', 'currency_conversion']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transfer_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'transfer_id' is set
        if self.api_client.client_side_validation and ('transfer_id' not in params or
                                                       params['transfer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transfer_id` when calling `get_transfer_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transfer_id' in params:
            path_params['transfer_id'] = params['transfer_id']  # noqa: E501

        query_params = []
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/transfer/{transfer_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExternalAccountTransfer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_bank_link_bulk_using_put(self, bank_link_list, **kwargs):  # noqa: E501
        """Update list of bank link  # noqa: E501

        Update bank link list for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_bank_link_bulk_using_put(bank_link_list, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[object] bank_link_list: bankLinkList (required)
        :return: list[BankLink]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_bank_link_bulk_using_put_with_http_info(bank_link_list, **kwargs)  # noqa: E501
        else:
            (data) = self.update_bank_link_bulk_using_put_with_http_info(bank_link_list, **kwargs)  # noqa: E501
            return data

    def update_bank_link_bulk_using_put_with_http_info(self, bank_link_list, **kwargs):  # noqa: E501
        """Update list of bank link  # noqa: E501

        Update bank link list for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_bank_link_bulk_using_put_with_http_info(bank_link_list, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[object] bank_link_list: bankLinkList (required)
        :return: list[BankLink]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_link_list']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_bank_link_bulk_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_link_list' is set
        if self.api_client.client_side_validation and ('bank_link_list' not in params or
                                                       params['bank_link_list'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_link_list` when calling `update_bank_link_bulk_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bank_link_list' in params:
            body_params = params['bank_link_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/bulk_bank_link', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BankLink]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_bank_link_using_put(self, bank_link, bank_link_id, **kwargs):  # noqa: E501
        """Update a bank link  # noqa: E501

        Update the information for a bank link for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_bank_link_using_put(bank_link, bank_link_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object bank_link: bank_link (required)
        :param str bank_link_id: UUID bank_link_id (required)
        :return: BankLink
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_bank_link_using_put_with_http_info(bank_link, bank_link_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_bank_link_using_put_with_http_info(bank_link, bank_link_id, **kwargs)  # noqa: E501
            return data

    def update_bank_link_using_put_with_http_info(self, bank_link, bank_link_id, **kwargs):  # noqa: E501
        """Update a bank link  # noqa: E501

        Update the information for a bank link for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_bank_link_using_put_with_http_info(bank_link, bank_link_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object bank_link: bank_link (required)
        :param str bank_link_id: UUID bank_link_id (required)
        :return: BankLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_link', 'bank_link_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_bank_link_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_link' is set
        if self.api_client.client_side_validation and ('bank_link' not in params or
                                                       params['bank_link'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_link` when calling `update_bank_link_using_put`")  # noqa: E501
        # verify the required parameter 'bank_link_id' is set
        if self.api_client.client_side_validation and ('bank_link_id' not in params or
                                                       params['bank_link_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_link_id` when calling `update_bank_link_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_link_id' in params:
            path_params['bank_link_id'] = params['bank_link_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bank_link' in params:
            body_params = params['bank_link']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/bank_link/{bank_link_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BankLink',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_funding_transaction_using_put(self, funding_transaction, funding_transaction_id, **kwargs):  # noqa: E501
        """Update a funding transaction request  # noqa: E501

        Update the information for a funding transaction request for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_funding_transaction_using_put(funding_transaction, funding_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object funding_transaction: fundingTransaction (required)
        :param str funding_transaction_id: UUID funding_transaction_id (required)
        :return: FundingTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_funding_transaction_using_put_with_http_info(funding_transaction, funding_transaction_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_funding_transaction_using_put_with_http_info(funding_transaction, funding_transaction_id, **kwargs)  # noqa: E501
            return data

    def update_funding_transaction_using_put_with_http_info(self, funding_transaction, funding_transaction_id, **kwargs):  # noqa: E501
        """Update a funding transaction request  # noqa: E501

        Update the information for a funding transaction request for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_funding_transaction_using_put_with_http_info(funding_transaction, funding_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object funding_transaction: fundingTransaction (required)
        :param str funding_transaction_id: UUID funding_transaction_id (required)
        :return: FundingTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['funding_transaction', 'funding_transaction_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_funding_transaction_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'funding_transaction' is set
        if self.api_client.client_side_validation and ('funding_transaction' not in params or
                                                       params['funding_transaction'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `funding_transaction` when calling `update_funding_transaction_using_put`")  # noqa: E501
        # verify the required parameter 'funding_transaction_id' is set
        if self.api_client.client_side_validation and ('funding_transaction_id' not in params or
                                                       params['funding_transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `funding_transaction_id` when calling `update_funding_transaction_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'funding_transaction_id' in params:
            path_params['funding_transaction_id'] = params['funding_transaction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'funding_transaction' in params:
            body_params = params['funding_transaction']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/funding_transaction/{funding_transaction_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FundingTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_funding_using_put(self, funding, funding_id, **kwargs):  # noqa: E501
        """Update a funding request  # noqa: E501

        Update the information for a funding request for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_funding_using_put(funding, funding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object funding: funding (required)
        :param str funding_id: UUID funding_id (required)
        :return: Funding
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_funding_using_put_with_http_info(funding, funding_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_funding_using_put_with_http_info(funding, funding_id, **kwargs)  # noqa: E501
            return data

    def update_funding_using_put_with_http_info(self, funding, funding_id, **kwargs):  # noqa: E501
        """Update a funding request  # noqa: E501

        Update the information for a funding request for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_funding_using_put_with_http_info(funding, funding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object funding: funding (required)
        :param str funding_id: UUID funding_id (required)
        :return: Funding
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['funding', 'funding_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_funding_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'funding' is set
        if self.api_client.client_side_validation and ('funding' not in params or
                                                       params['funding'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `funding` when calling `update_funding_using_put`")  # noqa: E501
        # verify the required parameter 'funding_id' is set
        if self.api_client.client_side_validation and ('funding_id' not in params or
                                                       params['funding_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `funding_id` when calling `update_funding_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'funding_id' in params:
            path_params['funding_id'] = params['funding_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'funding' in params:
            body_params = params['funding']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/funding/{funding_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Funding',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_transfer_using_put(self, transfer, transfer_id, **kwargs):  # noqa: E501
        """Update a transfer request  # noqa: E501

        Update the information for a external account transfer for a client account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_transfer_using_put(transfer, transfer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object transfer: transfer (required)
        :param str transfer_id: UUID external_account_transfer_id (required)
        :return: ExternalAccountTransfer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_transfer_using_put_with_http_info(transfer, transfer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_transfer_using_put_with_http_info(transfer, transfer_id, **kwargs)  # noqa: E501
            return data

    def update_transfer_using_put_with_http_info(self, transfer, transfer_id, **kwargs):  # noqa: E501
        """Update a transfer request  # noqa: E501

        Update the information for a external account transfer for a client account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_transfer_using_put_with_http_info(transfer, transfer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object transfer: transfer (required)
        :param str transfer_id: UUID external_account_transfer_id (required)
        :return: ExternalAccountTransfer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['transfer', 'transfer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_transfer_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'transfer' is set
        if self.api_client.client_side_validation and ('transfer' not in params or
                                                       params['transfer'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transfer` when calling `update_transfer_using_put`")  # noqa: E501
        # verify the required parameter 'transfer_id' is set
        if self.api_client.client_side_validation and ('transfer_id' not in params or
                                                       params['transfer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transfer_id` when calling `update_transfer_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transfer_id' in params:
            path_params['transfer_id'] = params['transfer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'transfer' in params:
            body_params = params['transfer']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/transfer/{transfer_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExternalAccountTransfer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
