# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.9.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class OrderApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_account_order_bulk_using_post(self, account_id, req, **kwargs):  # noqa: E501
        """Bulk orders for an account  # noqa: E501

        Aggregates all orders on a given date for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_order_bulk_using_post(account_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :param TokenDateRequest req: req (required)
        :return: list[Order]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_account_order_bulk_using_post_with_http_info(account_id, req, **kwargs)  # noqa: E501
        else:
            (data) = self.create_account_order_bulk_using_post_with_http_info(account_id, req, **kwargs)  # noqa: E501
            return data

    def create_account_order_bulk_using_post_with_http_info(self, account_id, req, **kwargs):  # noqa: E501
        """Bulk orders for an account  # noqa: E501

        Aggregates all orders on a given date for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_order_bulk_using_post_with_http_info(account_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :param TokenDateRequest req: req (required)
        :return: list[Order]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'req']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_order_bulk_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `create_account_order_bulk_using_post`")  # noqa: E501
        # verify the required parameter 'req' is set
        if self.api_client.client_side_validation and ('req' not in params or
                                                       params['req'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `req` when calling `create_account_order_bulk_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req' in params:
            body_params = params['req']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/account/{account_id}/order_bulk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Order]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_account_order_buy_only_using_post(self, account_id, req, **kwargs):  # noqa: E501
        """Create buy-only account rebalance orders  # noqa: E501

        Create order records necessary to rebalance an account and all its portfolios according to the allocation(s) to which the account subscribes and models to which the portfolios subscribe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_order_buy_only_using_post(account_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :param AccountPortfolioRebalanceRequest req: req (required)
        :return: list[OrderVoClone]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_account_order_buy_only_using_post_with_http_info(account_id, req, **kwargs)  # noqa: E501
        else:
            (data) = self.create_account_order_buy_only_using_post_with_http_info(account_id, req, **kwargs)  # noqa: E501
            return data

    def create_account_order_buy_only_using_post_with_http_info(self, account_id, req, **kwargs):  # noqa: E501
        """Create buy-only account rebalance orders  # noqa: E501

        Create order records necessary to rebalance an account and all its portfolios according to the allocation(s) to which the account subscribes and models to which the portfolios subscribe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_order_buy_only_using_post_with_http_info(account_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :param AccountPortfolioRebalanceRequest req: req (required)
        :return: list[OrderVoClone]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'req']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_order_buy_only_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `create_account_order_buy_only_using_post`")  # noqa: E501
        # verify the required parameter 'req' is set
        if self.api_client.client_side_validation and ('req' not in params or
                                                       params['req'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `req` when calling `create_account_order_buy_only_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req' in params:
            body_params = params['req']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/account/{account_id}/order_buy_only', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrderVoClone]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_account_order_rebalance_using_post(self, account_id, req, **kwargs):  # noqa: E501
        """Create account rebalance orders  # noqa: E501

        Create order records necessary to rebalance an account and all its portfolios according to the allocation(s) to which the account subscribes and models to which the portfolios subscribe.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_order_rebalance_using_post(account_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :param AccountPortfolioRebalanceRequest req: req (required)
        :return: list[OrderVoClone]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_account_order_rebalance_using_post_with_http_info(account_id, req, **kwargs)  # noqa: E501
        else:
            (data) = self.create_account_order_rebalance_using_post_with_http_info(account_id, req, **kwargs)  # noqa: E501
            return data

    def create_account_order_rebalance_using_post_with_http_info(self, account_id, req, **kwargs):  # noqa: E501
        """Create account rebalance orders  # noqa: E501

        Create order records necessary to rebalance an account and all its portfolios according to the allocation(s) to which the account subscribes and models to which the portfolios subscribe.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_order_rebalance_using_post_with_http_info(account_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :param AccountPortfolioRebalanceRequest req: req (required)
        :return: list[OrderVoClone]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'req']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_order_rebalance_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `create_account_order_rebalance_using_post`")  # noqa: E501
        # verify the required parameter 'req' is set
        if self.api_client.client_side_validation and ('req' not in params or
                                                       params['req'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `req` when calling `create_account_order_rebalance_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req' in params:
            body_params = params['req']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/account/{account_id}/order_rebalance', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrderVoClone]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_account_order_reconciliation(self, account_id, req, **kwargs):  # noqa: E501
        """Create account reconciliation order  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_order_reconciliation(account_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :param OrderReconcileRequest req: req (required)
        :return: OrderReconcileReturnObject
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_account_order_reconciliation_with_http_info(account_id, req, **kwargs)  # noqa: E501
        else:
            (data) = self.create_account_order_reconciliation_with_http_info(account_id, req, **kwargs)  # noqa: E501
            return data

    def create_account_order_reconciliation_with_http_info(self, account_id, req, **kwargs):  # noqa: E501
        """Create account reconciliation order  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_order_reconciliation_with_http_info(account_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :param OrderReconcileRequest req: req (required)
        :return: OrderReconcileReturnObject
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'req']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_order_reconciliation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `create_account_order_reconciliation`")  # noqa: E501
        # verify the required parameter 'req' is set
        if self.api_client.client_side_validation and ('req' not in params or
                                                       params['req'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `req` when calling `create_account_order_reconciliation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req' in params:
            body_params = params['req']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/account/{account_id}/order_reconciliation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderReconcileReturnObject',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_account_order_sell_all_using_post(self, account_id, req, **kwargs):  # noqa: E501
        """Sell all account order  # noqa: E501

        Create order records necessary to entirely sell all the holdings within an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_order_sell_all_using_post(account_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :param AccountPortfolioRebalanceRequest req: req (required)
        :return: list[OrderVoClone]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_account_order_sell_all_using_post_with_http_info(account_id, req, **kwargs)  # noqa: E501
        else:
            (data) = self.create_account_order_sell_all_using_post_with_http_info(account_id, req, **kwargs)  # noqa: E501
            return data

    def create_account_order_sell_all_using_post_with_http_info(self, account_id, req, **kwargs):  # noqa: E501
        """Sell all account order  # noqa: E501

        Create order records necessary to entirely sell all the holdings within an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_order_sell_all_using_post_with_http_info(account_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :param AccountPortfolioRebalanceRequest req: req (required)
        :return: list[OrderVoClone]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'req']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_order_sell_all_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `create_account_order_sell_all_using_post`")  # noqa: E501
        # verify the required parameter 'req' is set
        if self.api_client.client_side_validation and ('req' not in params or
                                                       params['req'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `req` when calling `create_account_order_sell_all_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req' in params:
            body_params = params['req']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/account/{account_id}/order_sell_all', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrderVoClone]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_account_order_sell_only_using_post(self, account_id, req, **kwargs):  # noqa: E501
        """Create sell-only account rebalance orders  # noqa: E501

        Create order records necessary to rebalance an account and all its portfolios according to the allocation(s) to which the account subscribes and models to which the portfolios subscribe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_order_sell_only_using_post(account_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :param AccountPortfolioRebalanceRequest req: req (required)
        :return: list[OrderVoClone]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_account_order_sell_only_using_post_with_http_info(account_id, req, **kwargs)  # noqa: E501
        else:
            (data) = self.create_account_order_sell_only_using_post_with_http_info(account_id, req, **kwargs)  # noqa: E501
            return data

    def create_account_order_sell_only_using_post_with_http_info(self, account_id, req, **kwargs):  # noqa: E501
        """Create sell-only account rebalance orders  # noqa: E501

        Create order records necessary to rebalance an account and all its portfolios according to the allocation(s) to which the account subscribes and models to which the portfolios subscribe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_order_sell_only_using_post_with_http_info(account_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :param AccountPortfolioRebalanceRequest req: req (required)
        :return: list[OrderVoClone]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'req']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_order_sell_only_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `create_account_order_sell_only_using_post`")  # noqa: E501
        # verify the required parameter 'req' is set
        if self.api_client.client_side_validation and ('req' not in params or
                                                       params['req'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `req` when calling `create_account_order_sell_only_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req' in params:
            body_params = params['req']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/account/{account_id}/order_sell_only', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrderVoClone]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_client_order_bulk_using_post(self, client_id, req, **kwargs):  # noqa: E501
        """Bulk orders for a client  # noqa: E501

        Aggregates all orders on a given date for a client  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_client_order_bulk_using_post(client_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: client_id (required)
        :param TokenDateRequest req: req (required)
        :return: list[Order]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_client_order_bulk_using_post_with_http_info(client_id, req, **kwargs)  # noqa: E501
        else:
            (data) = self.create_client_order_bulk_using_post_with_http_info(client_id, req, **kwargs)  # noqa: E501
            return data

    def create_client_order_bulk_using_post_with_http_info(self, client_id, req, **kwargs):  # noqa: E501
        """Bulk orders for a client  # noqa: E501

        Aggregates all orders on a given date for a client  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_client_order_bulk_using_post_with_http_info(client_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: client_id (required)
        :param TokenDateRequest req: req (required)
        :return: list[Order]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'req']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_client_order_bulk_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_id' is set
        if self.api_client.client_side_validation and ('client_id' not in params or
                                                       params['client_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `client_id` when calling `create_client_order_bulk_using_post`")  # noqa: E501
        # verify the required parameter 'req' is set
        if self.api_client.client_side_validation and ('req' not in params or
                                                       params['req'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `req` when calling `create_client_order_bulk_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_id' in params:
            path_params['client_id'] = params['client_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req' in params:
            body_params = params['req']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/client/{client_id}/order_bulk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Order]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_order_bulk_using_post(self, req, **kwargs):  # noqa: E501
        """Bulk orders for your firm  # noqa: E501

        Aggregates all orders on a given date for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_order_bulk_using_post(req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TokenDateRequest req: req (required)
        :return: list[Order]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_order_bulk_using_post_with_http_info(req, **kwargs)  # noqa: E501
        else:
            (data) = self.create_order_bulk_using_post_with_http_info(req, **kwargs)  # noqa: E501
            return data

    def create_order_bulk_using_post_with_http_info(self, req, **kwargs):  # noqa: E501
        """Bulk orders for your firm  # noqa: E501

        Aggregates all orders on a given date for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_order_bulk_using_post_with_http_info(req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TokenDateRequest req: req (required)
        :return: list[Order]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_order_bulk_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req' is set
        if self.api_client.client_side_validation and ('req' not in params or
                                                       params['req'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `req` when calling `create_order_bulk_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req' in params:
            body_params = params['req']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order_bulk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Order]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_order_status_using_post(self, order_status_request, **kwargs):  # noqa: E501
        """Create an order status  # noqa: E501

        Create an order status for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_order_status_using_post(order_status_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderStatus order_status_request: orderStatusRequest (required)
        :return: OrderStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_order_status_using_post_with_http_info(order_status_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_order_status_using_post_with_http_info(order_status_request, **kwargs)  # noqa: E501
            return data

    def create_order_status_using_post_with_http_info(self, order_status_request, **kwargs):  # noqa: E501
        """Create an order status  # noqa: E501

        Create an order status for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_order_status_using_post_with_http_info(order_status_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderStatus order_status_request: orderStatusRequest (required)
        :return: OrderStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_status_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_order_status_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_status_request' is set
        if self.api_client.client_side_validation and ('order_status_request' not in params or
                                                       params['order_status_request'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `order_status_request` when calling `create_order_status_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order_status_request' in params:
            body_params = params['order_status_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order_status', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_order_track_using_post(self, order_track_request, **kwargs):  # noqa: E501
        """Create an order tracking record  # noqa: E501

        Create a new order tracking record for an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_order_track_using_post(order_track_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderTrack order_track_request: orderTrackRequest (required)
        :return: OrderTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_order_track_using_post_with_http_info(order_track_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_order_track_using_post_with_http_info(order_track_request, **kwargs)  # noqa: E501
            return data

    def create_order_track_using_post_with_http_info(self, order_track_request, **kwargs):  # noqa: E501
        """Create an order tracking record  # noqa: E501

        Create a new order tracking record for an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_order_track_using_post_with_http_info(order_track_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderTrack order_track_request: orderTrackRequest (required)
        :return: OrderTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_track_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_order_track_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_track_request' is set
        if self.api_client.client_side_validation and ('order_track_request' not in params or
                                                       params['order_track_request'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `order_track_request` when calling `create_order_track_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order_track_request' in params:
            body_params = params['order_track_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order_track', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderTrack',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_order_using_post(self, order_info_request, **kwargs):  # noqa: E501
        """Create an order record  # noqa: E501

        Create an order record defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_order_using_post(order_info_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Order order_info_request: orderInfoRequest (required)
        :return: Order
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_order_using_post_with_http_info(order_info_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_order_using_post_with_http_info(order_info_request, **kwargs)  # noqa: E501
            return data

    def create_order_using_post_with_http_info(self, order_info_request, **kwargs):  # noqa: E501
        """Create an order record  # noqa: E501

        Create an order record defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_order_using_post_with_http_info(order_info_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Order order_info_request: orderInfoRequest (required)
        :return: Order
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_info_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_order_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_info_request' is set
        if self.api_client.client_side_validation and ('order_info_request' not in params or
                                                       params['order_info_request'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `order_info_request` when calling `create_order_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order_info_request' in params:
            body_params = params['order_info_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Order',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_portfolio_order_buy_only_using_post(self, portfolio_id, req, **kwargs):  # noqa: E501
        """Create buy-only portfolio rebalance orders  # noqa: E501

        Create order records necessary to rebalance a portfolio to the model to which it subscribes. However, these will only be buy transactions, and no securities will be sold.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_order_buy_only_using_post(portfolio_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: portfolio_id (required)
        :param AccountPortfolioRebalanceRequest req: req (required)
        :return: list[OrderVoClone]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_portfolio_order_buy_only_using_post_with_http_info(portfolio_id, req, **kwargs)  # noqa: E501
        else:
            (data) = self.create_portfolio_order_buy_only_using_post_with_http_info(portfolio_id, req, **kwargs)  # noqa: E501
            return data

    def create_portfolio_order_buy_only_using_post_with_http_info(self, portfolio_id, req, **kwargs):  # noqa: E501
        """Create buy-only portfolio rebalance orders  # noqa: E501

        Create order records necessary to rebalance a portfolio to the model to which it subscribes. However, these will only be buy transactions, and no securities will be sold.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_order_buy_only_using_post_with_http_info(portfolio_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: portfolio_id (required)
        :param AccountPortfolioRebalanceRequest req: req (required)
        :return: list[OrderVoClone]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_id', 'req']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_portfolio_order_buy_only_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_id' is set
        if self.api_client.client_side_validation and ('portfolio_id' not in params or
                                                       params['portfolio_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `portfolio_id` when calling `create_portfolio_order_buy_only_using_post`")  # noqa: E501
        # verify the required parameter 'req' is set
        if self.api_client.client_side_validation and ('req' not in params or
                                                       params['req'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `req` when calling `create_portfolio_order_buy_only_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_id' in params:
            path_params['portfolio_id'] = params['portfolio_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req' in params:
            body_params = params['req']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/portfolio/{portfolio_id}/order_buy_only', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrderVoClone]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_portfolio_order_rebalance_using_post(self, portfolio_id, req, **kwargs):  # noqa: E501
        """Create portfolio rebalance orders  # noqa: E501

        Create order records necessary to rebalance a portfolio to the model to which it subscribes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_order_rebalance_using_post(portfolio_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: portfolio_id (required)
        :param AccountPortfolioRebalanceRequest req: req (required)
        :return: list[OrderVoClone]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_portfolio_order_rebalance_using_post_with_http_info(portfolio_id, req, **kwargs)  # noqa: E501
        else:
            (data) = self.create_portfolio_order_rebalance_using_post_with_http_info(portfolio_id, req, **kwargs)  # noqa: E501
            return data

    def create_portfolio_order_rebalance_using_post_with_http_info(self, portfolio_id, req, **kwargs):  # noqa: E501
        """Create portfolio rebalance orders  # noqa: E501

        Create order records necessary to rebalance a portfolio to the model to which it subscribes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_order_rebalance_using_post_with_http_info(portfolio_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: portfolio_id (required)
        :param AccountPortfolioRebalanceRequest req: req (required)
        :return: list[OrderVoClone]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_id', 'req']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_portfolio_order_rebalance_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_id' is set
        if self.api_client.client_side_validation and ('portfolio_id' not in params or
                                                       params['portfolio_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `portfolio_id` when calling `create_portfolio_order_rebalance_using_post`")  # noqa: E501
        # verify the required parameter 'req' is set
        if self.api_client.client_side_validation and ('req' not in params or
                                                       params['req'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `req` when calling `create_portfolio_order_rebalance_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_id' in params:
            path_params['portfolio_id'] = params['portfolio_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req' in params:
            body_params = params['req']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/portfolio/{portfolio_id}/order_rebalance', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrderVoClone]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_portfolio_order_reconciliation(self, portfolio_id, req, **kwargs):  # noqa: E501
        """Create portfolio reconciliation order  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_order_reconciliation(portfolio_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: portfolio_id (required)
        :param OrderReconcileRequest req: req (required)
        :return: OrderReconcileReturnObject
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_portfolio_order_reconciliation_with_http_info(portfolio_id, req, **kwargs)  # noqa: E501
        else:
            (data) = self.create_portfolio_order_reconciliation_with_http_info(portfolio_id, req, **kwargs)  # noqa: E501
            return data

    def create_portfolio_order_reconciliation_with_http_info(self, portfolio_id, req, **kwargs):  # noqa: E501
        """Create portfolio reconciliation order  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_order_reconciliation_with_http_info(portfolio_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: portfolio_id (required)
        :param OrderReconcileRequest req: req (required)
        :return: OrderReconcileReturnObject
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_id', 'req']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_portfolio_order_reconciliation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_id' is set
        if self.api_client.client_side_validation and ('portfolio_id' not in params or
                                                       params['portfolio_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `portfolio_id` when calling `create_portfolio_order_reconciliation`")  # noqa: E501
        # verify the required parameter 'req' is set
        if self.api_client.client_side_validation and ('req' not in params or
                                                       params['req'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `req` when calling `create_portfolio_order_reconciliation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_id' in params:
            path_params['portfolio_id'] = params['portfolio_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req' in params:
            body_params = params['req']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/portfolio/{portfolio_id}/order_reconciliation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderReconcileReturnObject',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_portfolio_order_sell_all_using_post(self, portfolio_id, req, **kwargs):  # noqa: E501
        """Sell all portfolio order  # noqa: E501

        Create order records necessary to entirely sell all the holdings within a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_order_sell_all_using_post(portfolio_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: portfolio_id (required)
        :param AccountPortfolioRebalanceRequest req: req (required)
        :return: list[OrderVoClone]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_portfolio_order_sell_all_using_post_with_http_info(portfolio_id, req, **kwargs)  # noqa: E501
        else:
            (data) = self.create_portfolio_order_sell_all_using_post_with_http_info(portfolio_id, req, **kwargs)  # noqa: E501
            return data

    def create_portfolio_order_sell_all_using_post_with_http_info(self, portfolio_id, req, **kwargs):  # noqa: E501
        """Sell all portfolio order  # noqa: E501

        Create order records necessary to entirely sell all the holdings within a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_order_sell_all_using_post_with_http_info(portfolio_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: portfolio_id (required)
        :param AccountPortfolioRebalanceRequest req: req (required)
        :return: list[OrderVoClone]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_id', 'req']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_portfolio_order_sell_all_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_id' is set
        if self.api_client.client_side_validation and ('portfolio_id' not in params or
                                                       params['portfolio_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `portfolio_id` when calling `create_portfolio_order_sell_all_using_post`")  # noqa: E501
        # verify the required parameter 'req' is set
        if self.api_client.client_side_validation and ('req' not in params or
                                                       params['req'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `req` when calling `create_portfolio_order_sell_all_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_id' in params:
            path_params['portfolio_id'] = params['portfolio_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req' in params:
            body_params = params['req']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/portfolio/{portfolio_id}/order_sell_all', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrderVoClone]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_portfolio_order_sell_only_using_post(self, portfolio_id, req, **kwargs):  # noqa: E501
        """Create sell-only portfolio rebalance orders  # noqa: E501

        Create order records necessary to rebalance a portfolio to the model to which it subscribes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_order_sell_only_using_post(portfolio_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: portfolio_id (required)
        :param AccountPortfolioRebalanceRequest req: req (required)
        :return: list[OrderVoClone]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_portfolio_order_sell_only_using_post_with_http_info(portfolio_id, req, **kwargs)  # noqa: E501
        else:
            (data) = self.create_portfolio_order_sell_only_using_post_with_http_info(portfolio_id, req, **kwargs)  # noqa: E501
            return data

    def create_portfolio_order_sell_only_using_post_with_http_info(self, portfolio_id, req, **kwargs):  # noqa: E501
        """Create sell-only portfolio rebalance orders  # noqa: E501

        Create order records necessary to rebalance a portfolio to the model to which it subscribes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_order_sell_only_using_post_with_http_info(portfolio_id, req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: portfolio_id (required)
        :param AccountPortfolioRebalanceRequest req: req (required)
        :return: list[OrderVoClone]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_id', 'req']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_portfolio_order_sell_only_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_id' is set
        if self.api_client.client_side_validation and ('portfolio_id' not in params or
                                                       params['portfolio_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `portfolio_id` when calling `create_portfolio_order_sell_only_using_post`")  # noqa: E501
        # verify the required parameter 'req' is set
        if self.api_client.client_side_validation and ('req' not in params or
                                                       params['req'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `req` when calling `create_portfolio_order_sell_only_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_id' in params:
            path_params['portfolio_id'] = params['portfolio_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req' in params:
            body_params = params['req']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/portfolio/{portfolio_id}/order_sell_only', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrderVoClone]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_order_status_using_delete(self, order_status_id, **kwargs):  # noqa: E501
        """Delete an order status  # noqa: E501

        Permanently delete an order status defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_order_status_using_delete(order_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_status_id: UUID order_status_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_order_status_using_delete_with_http_info(order_status_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_order_status_using_delete_with_http_info(order_status_id, **kwargs)  # noqa: E501
            return data

    def delete_order_status_using_delete_with_http_info(self, order_status_id, **kwargs):  # noqa: E501
        """Delete an order status  # noqa: E501

        Permanently delete an order status defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_order_status_using_delete_with_http_info(order_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_status_id: UUID order_status_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_status_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_order_status_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_status_id' is set
        if self.api_client.client_side_validation and ('order_status_id' not in params or
                                                       params['order_status_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `order_status_id` when calling `delete_order_status_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_status_id' in params:
            path_params['order_status_id'] = params['order_status_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order_status/{order_status_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_order_track_using_delete(self, order_track_id, **kwargs):  # noqa: E501
        """Delete an order tracking record  # noqa: E501

        Permanently delete an order tracking record for an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_order_track_using_delete(order_track_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_track_id: UUID order_track_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_order_track_using_delete_with_http_info(order_track_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_order_track_using_delete_with_http_info(order_track_id, **kwargs)  # noqa: E501
            return data

    def delete_order_track_using_delete_with_http_info(self, order_track_id, **kwargs):  # noqa: E501
        """Delete an order tracking record  # noqa: E501

        Permanently delete an order tracking record for an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_order_track_using_delete_with_http_info(order_track_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_track_id: UUID order_track_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_track_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_order_track_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_track_id' is set
        if self.api_client.client_side_validation and ('order_track_id' not in params or
                                                       params['order_track_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `order_track_id` when calling `delete_order_track_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_track_id' in params:
            path_params['order_track_id'] = params['order_track_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order_track/{order_track_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_order_using_delete(self, order_id, **kwargs):  # noqa: E501
        """Delete an order record  # noqa: E501

        Permanently delete an order record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_order_using_delete(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: UUID order_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_order_using_delete_with_http_info(order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_order_using_delete_with_http_info(order_id, **kwargs)  # noqa: E501
            return data

    def delete_order_using_delete_with_http_info(self, order_id, **kwargs):  # noqa: E501
        """Delete an order record  # noqa: E501

        Permanently delete an order record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_order_using_delete_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: UUID order_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_order_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if self.api_client.client_side_validation and ('order_id' not in params or
                                                       params['order_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `order_id` when calling `delete_order_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order/{order_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_order_all_using_get(self, **kwargs):  # noqa: E501
        """List all order records  # noqa: E501

        Get the information for all order records defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageOrder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_order_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_order_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_order_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all order records  # noqa: E501

        Get the information for all order records defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageOrder
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageOrder',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_order_bulk_all_using_get(self, **kwargs):  # noqa: E501
        """List all bulk orders  # noqa: E501

        Get the information for all bulk order records.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_bulk_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageOrderBulk
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_order_bulk_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_order_bulk_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_order_bulk_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all bulk orders  # noqa: E501

        Get the information for all bulk order records.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_bulk_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageOrderBulk
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order_bulk_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order_bulk', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageOrderBulk',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_order_status_all_using_get(self, **kwargs):  # noqa: E501
        """List all order statuses  # noqa: E501

        Get the information for all order statuses defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_status_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageOrderStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_order_status_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_order_status_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_order_status_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all order statuses  # noqa: E501

        Get the information for all order statuses defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_status_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageOrderStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order_status_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order_status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageOrderStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_order_status_using_get(self, order_status_id, **kwargs):  # noqa: E501
        """Retrieve an order status  # noqa: E501

        Retrieve the information for an order status defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_status_using_get(order_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_status_id: UUID order_status_id (required)
        :return: OrderStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_order_status_using_get_with_http_info(order_status_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_order_status_using_get_with_http_info(order_status_id, **kwargs)  # noqa: E501
            return data

    def get_order_status_using_get_with_http_info(self, order_status_id, **kwargs):  # noqa: E501
        """Retrieve an order status  # noqa: E501

        Retrieve the information for an order status defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_status_using_get_with_http_info(order_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_status_id: UUID order_status_id (required)
        :return: OrderStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_status_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order_status_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_status_id' is set
        if self.api_client.client_side_validation and ('order_status_id' not in params or
                                                       params['order_status_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `order_status_id` when calling `get_order_status_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_status_id' in params:
            path_params['order_status_id'] = params['order_status_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order_status/{order_status_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_order_track_all_using_get(self, **kwargs):  # noqa: E501
        """List all order tracking records  # noqa: E501

        Get the information for all order tracking record for all order records.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_track_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageOrderTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_order_track_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_order_track_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_order_track_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all order tracking records  # noqa: E501

        Get the information for all order tracking record for all order records.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_track_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageOrderTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order_track_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order_track', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageOrderTrack',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_order_track_using_get(self, order_track_id, **kwargs):  # noqa: E501
        """Retrieve an order tracking record  # noqa: E501

        Retrieve the information for an order tracking record for an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_track_using_get(order_track_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_track_id: UUID order_track_id (required)
        :return: OrderTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_order_track_using_get_with_http_info(order_track_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_order_track_using_get_with_http_info(order_track_id, **kwargs)  # noqa: E501
            return data

    def get_order_track_using_get_with_http_info(self, order_track_id, **kwargs):  # noqa: E501
        """Retrieve an order tracking record  # noqa: E501

        Retrieve the information for an order tracking record for an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_track_using_get_with_http_info(order_track_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_track_id: UUID order_track_id (required)
        :return: OrderTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_track_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order_track_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_track_id' is set
        if self.api_client.client_side_validation and ('order_track_id' not in params or
                                                       params['order_track_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `order_track_id` when calling `get_order_track_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_track_id' in params:
            path_params['order_track_id'] = params['order_track_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order_track/{order_track_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderTrack',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_order_using_get(self, order_id, **kwargs):  # noqa: E501
        """Retrieve an order record  # noqa: E501

        Retrieve the information for an order record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_using_get(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: UUID order_id (required)
        :return: Order
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_order_using_get_with_http_info(order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_order_using_get_with_http_info(order_id, **kwargs)  # noqa: E501
            return data

    def get_order_using_get_with_http_info(self, order_id, **kwargs):  # noqa: E501
        """Retrieve an order record  # noqa: E501

        Retrieve the information for an order record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_using_get_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: UUID order_id (required)
        :return: Order
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if self.api_client.client_side_validation and ('order_id' not in params or
                                                       params['order_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `order_id` when calling `get_order_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order/{order_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Order',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_order_status_using_put(self, order_status, order_status_id, **kwargs):  # noqa: E501
        """Update an order status  # noqa: E501

        Update the information for an order status defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_order_status_using_put(order_status, order_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object order_status: order_status (required)
        :param str order_status_id: UUID order_status_id (required)
        :return: OrderStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_order_status_using_put_with_http_info(order_status, order_status_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_order_status_using_put_with_http_info(order_status, order_status_id, **kwargs)  # noqa: E501
            return data

    def update_order_status_using_put_with_http_info(self, order_status, order_status_id, **kwargs):  # noqa: E501
        """Update an order status  # noqa: E501

        Update the information for an order status defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_order_status_using_put_with_http_info(order_status, order_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object order_status: order_status (required)
        :param str order_status_id: UUID order_status_id (required)
        :return: OrderStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_status', 'order_status_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_order_status_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_status' is set
        if self.api_client.client_side_validation and ('order_status' not in params or
                                                       params['order_status'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `order_status` when calling `update_order_status_using_put`")  # noqa: E501
        # verify the required parameter 'order_status_id' is set
        if self.api_client.client_side_validation and ('order_status_id' not in params or
                                                       params['order_status_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `order_status_id` when calling `update_order_status_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_status_id' in params:
            path_params['order_status_id'] = params['order_status_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order_status' in params:
            body_params = params['order_status']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order_status/{order_status_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_order_track_using_put(self, order_track, order_track_id, **kwargs):  # noqa: E501
        """Update an order tracking record  # noqa: E501

        Update the information for an order tracking record for an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_order_track_using_put(order_track, order_track_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object order_track: order_track (required)
        :param str order_track_id: UUID order_track_id (required)
        :return: OrderTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_order_track_using_put_with_http_info(order_track, order_track_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_order_track_using_put_with_http_info(order_track, order_track_id, **kwargs)  # noqa: E501
            return data

    def update_order_track_using_put_with_http_info(self, order_track, order_track_id, **kwargs):  # noqa: E501
        """Update an order tracking record  # noqa: E501

        Update the information for an order tracking record for an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_order_track_using_put_with_http_info(order_track, order_track_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object order_track: order_track (required)
        :param str order_track_id: UUID order_track_id (required)
        :return: OrderTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_track', 'order_track_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_order_track_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_track' is set
        if self.api_client.client_side_validation and ('order_track' not in params or
                                                       params['order_track'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `order_track` when calling `update_order_track_using_put`")  # noqa: E501
        # verify the required parameter 'order_track_id' is set
        if self.api_client.client_side_validation and ('order_track_id' not in params or
                                                       params['order_track_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `order_track_id` when calling `update_order_track_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_track_id' in params:
            path_params['order_track_id'] = params['order_track_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order_track' in params:
            body_params = params['order_track']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order_track/{order_track_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderTrack',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_order_using_put(self, order, order_id, **kwargs):  # noqa: E501
        """Update an order record  # noqa: E501

        Update the information for an order record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_order_using_put(order, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object order: order (required)
        :param str order_id: UUID order_id (required)
        :return: Order
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_order_using_put_with_http_info(order, order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_order_using_put_with_http_info(order, order_id, **kwargs)  # noqa: E501
            return data

    def update_order_using_put_with_http_info(self, order, order_id, **kwargs):  # noqa: E501
        """Update an order record  # noqa: E501

        Update the information for an order record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_order_using_put_with_http_info(order, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object order: order (required)
        :param str order_id: UUID order_id (required)
        :return: Order
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order', 'order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_order_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order' is set
        if self.api_client.client_side_validation and ('order' not in params or
                                                       params['order'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `order` when calling `update_order_using_put`")  # noqa: E501
        # verify the required parameter 'order_id' is set
        if self.api_client.client_side_validation and ('order_id' not in params or
                                                       params['order_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `order_id` when calling `update_order_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order' in params:
            body_params = params['order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/order/{order_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Order',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
