# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.9.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class QuestionnaireApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_answer_using_post(self, answer, **kwargs):  # noqa: E501
        """Create an answer  # noqa: E501

        Create a new answer for question.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_answer_using_post(answer, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Answer answer: answer (required)
        :return: Answer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_answer_using_post_with_http_info(answer, **kwargs)  # noqa: E501
        else:
            (data) = self.create_answer_using_post_with_http_info(answer, **kwargs)  # noqa: E501
            return data

    def create_answer_using_post_with_http_info(self, answer, **kwargs):  # noqa: E501
        """Create an answer  # noqa: E501

        Create a new answer for question.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_answer_using_post_with_http_info(answer, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Answer answer: answer (required)
        :return: Answer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['answer']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_answer_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'answer' is set
        if self.api_client.client_side_validation and ('answer' not in params or
                                                       params['answer'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `answer` when calling `create_answer_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'answer' in params:
            body_params = params['answer']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/answer', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Answer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_question_using_post(self, question, **kwargs):  # noqa: E501
        """Create a question  # noqa: E501

        Create a new question for questionnaire.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_question_using_post(question, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Question question: question (required)
        :return: Question
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_question_using_post_with_http_info(question, **kwargs)  # noqa: E501
        else:
            (data) = self.create_question_using_post_with_http_info(question, **kwargs)  # noqa: E501
            return data

    def create_question_using_post_with_http_info(self, question, **kwargs):  # noqa: E501
        """Create a question  # noqa: E501

        Create a new question for questionnaire.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_question_using_post_with_http_info(question, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Question question: question (required)
        :return: Question
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['question']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_question_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'question' is set
        if self.api_client.client_side_validation and ('question' not in params or
                                                       params['question'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `question` when calling `create_question_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'question' in params:
            body_params = params['question']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/question', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Question',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_questionnaire_using_post(self, questionnaire, **kwargs):  # noqa: E501
        """Create a questionnaire  # noqa: E501

        Create a new questionnaire for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_questionnaire_using_post(questionnaire, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Questionnaire questionnaire: questionnaire (required)
        :return: Questionnaire
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_questionnaire_using_post_with_http_info(questionnaire, **kwargs)  # noqa: E501
        else:
            (data) = self.create_questionnaire_using_post_with_http_info(questionnaire, **kwargs)  # noqa: E501
            return data

    def create_questionnaire_using_post_with_http_info(self, questionnaire, **kwargs):  # noqa: E501
        """Create a questionnaire  # noqa: E501

        Create a new questionnaire for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_questionnaire_using_post_with_http_info(questionnaire, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Questionnaire questionnaire: questionnaire (required)
        :return: Questionnaire
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['questionnaire']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_questionnaire_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'questionnaire' is set
        if self.api_client.client_side_validation and ('questionnaire' not in params or
                                                       params['questionnaire'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `questionnaire` when calling `create_questionnaire_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'questionnaire' in params:
            body_params = params['questionnaire']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/questionnaire', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Questionnaire',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_answer_using_delete(self, answer_id, **kwargs):  # noqa: E501
        """Delete an answer  # noqa: E501

        Delete an answer for the question  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_answer_using_delete(answer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str answer_id: UUID answer_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_answer_using_delete_with_http_info(answer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_answer_using_delete_with_http_info(answer_id, **kwargs)  # noqa: E501
            return data

    def delete_answer_using_delete_with_http_info(self, answer_id, **kwargs):  # noqa: E501
        """Delete an answer  # noqa: E501

        Delete an answer for the question  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_answer_using_delete_with_http_info(answer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str answer_id: UUID answer_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['answer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_answer_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'answer_id' is set
        if self.api_client.client_side_validation and ('answer_id' not in params or
                                                       params['answer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `answer_id` when calling `delete_answer_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'answer_id' in params:
            path_params['answer_id'] = params['answer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/answer/{answer_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_question_using_delete(self, question_id, **kwargs):  # noqa: E501
        """Delete a question  # noqa: E501

        Delete an answer for the question  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_question_using_delete(question_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str question_id: UUID question_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_question_using_delete_with_http_info(question_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_question_using_delete_with_http_info(question_id, **kwargs)  # noqa: E501
            return data

    def delete_question_using_delete_with_http_info(self, question_id, **kwargs):  # noqa: E501
        """Delete a question  # noqa: E501

        Delete an answer for the question  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_question_using_delete_with_http_info(question_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str question_id: UUID question_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['question_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_question_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'question_id' is set
        if self.api_client.client_side_validation and ('question_id' not in params or
                                                       params['question_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `question_id` when calling `delete_question_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'question_id' in params:
            path_params['question_id'] = params['question_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/question/{question_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_questionnaire_using_delete(self, questionnaire_id, **kwargs):  # noqa: E501
        """Delete a questionnaire  # noqa: E501

        Permanently delete a questionnaire for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_questionnaire_using_delete(questionnaire_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str questionnaire_id: UUID questionnaire_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_questionnaire_using_delete_with_http_info(questionnaire_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_questionnaire_using_delete_with_http_info(questionnaire_id, **kwargs)  # noqa: E501
            return data

    def delete_questionnaire_using_delete_with_http_info(self, questionnaire_id, **kwargs):  # noqa: E501
        """Delete a questionnaire  # noqa: E501

        Permanently delete a questionnaire for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_questionnaire_using_delete_with_http_info(questionnaire_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str questionnaire_id: UUID questionnaire_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['questionnaire_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_questionnaire_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'questionnaire_id' is set
        if self.api_client.client_side_validation and ('questionnaire_id' not in params or
                                                       params['questionnaire_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `questionnaire_id` when calling `delete_questionnaire_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'questionnaire_id' in params:
            path_params['questionnaire_id'] = params['questionnaire_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/questionnaire/{questionnaire_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_answer_all_using_get(self, **kwargs):  # noqa: E501
        """List all Answers  # noqa: E501

        Get information for all Answers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_answer_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageAnswer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_answer_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_answer_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_answer_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all Answers  # noqa: E501

        Get information for all Answers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_answer_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageAnswer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_answer_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/answer', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageAnswer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_answer_using_get(self, answer_id, **kwargs):  # noqa: E501
        """Retrieve an answer  # noqa: E501

        Retrieve the information for an answer for question  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_answer_using_get(answer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str answer_id: UUID answer_id (required)
        :return: Answer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_answer_using_get_with_http_info(answer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_answer_using_get_with_http_info(answer_id, **kwargs)  # noqa: E501
            return data

    def get_answer_using_get_with_http_info(self, answer_id, **kwargs):  # noqa: E501
        """Retrieve an answer  # noqa: E501

        Retrieve the information for an answer for question  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_answer_using_get_with_http_info(answer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str answer_id: UUID answer_id (required)
        :return: Answer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['answer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_answer_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'answer_id' is set
        if self.api_client.client_side_validation and ('answer_id' not in params or
                                                       params['answer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `answer_id` when calling `get_answer_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'answer_id' in params:
            path_params['answer_id'] = params['answer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/answer/{answer_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Answer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_question_all_using_get(self, **kwargs):  # noqa: E501
        """List all Questions  # noqa: E501

        Get information for all Questions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_question_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageQuestion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_question_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_question_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_question_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all Questions  # noqa: E501

        Get information for all Questions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_question_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageQuestion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_question_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/question', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageQuestion',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_question_using_get(self, question_id, **kwargs):  # noqa: E501
        """Retrieve a question  # noqa: E501

        Retrieve the information for a question for questionnaire  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_question_using_get(question_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str question_id: UUID question_id (required)
        :return: Question
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_question_using_get_with_http_info(question_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_question_using_get_with_http_info(question_id, **kwargs)  # noqa: E501
            return data

    def get_question_using_get_with_http_info(self, question_id, **kwargs):  # noqa: E501
        """Retrieve a question  # noqa: E501

        Retrieve the information for a question for questionnaire  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_question_using_get_with_http_info(question_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str question_id: UUID question_id (required)
        :return: Question
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['question_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_question_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'question_id' is set
        if self.api_client.client_side_validation and ('question_id' not in params or
                                                       params['question_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `question_id` when calling `get_question_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'question_id' in params:
            path_params['question_id'] = params['question_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/question/{question_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Question',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_questionnaire_all_using_get(self, **kwargs):  # noqa: E501
        """List all questionnaires  # noqa: E501

        Get the information for all questionnaires defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_questionnaire_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageQuestionnaire
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_questionnaire_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_questionnaire_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_questionnaire_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all questionnaires  # noqa: E501

        Get the information for all questionnaires defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_questionnaire_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageQuestionnaire
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_questionnaire_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/questionnaire', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageQuestionnaire',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_questionnaire_using_get(self, questionnaire_id, **kwargs):  # noqa: E501
        """Retrieve a questionnaire  # noqa: E501

        Retrieve the information for a questionnaire for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_questionnaire_using_get(questionnaire_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str questionnaire_id: UUID questionnaire_id (required)
        :return: Questionnaire
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_questionnaire_using_get_with_http_info(questionnaire_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_questionnaire_using_get_with_http_info(questionnaire_id, **kwargs)  # noqa: E501
            return data

    def get_questionnaire_using_get_with_http_info(self, questionnaire_id, **kwargs):  # noqa: E501
        """Retrieve a questionnaire  # noqa: E501

        Retrieve the information for a questionnaire for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_questionnaire_using_get_with_http_info(questionnaire_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str questionnaire_id: UUID questionnaire_id (required)
        :return: Questionnaire
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['questionnaire_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_questionnaire_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'questionnaire_id' is set
        if self.api_client.client_side_validation and ('questionnaire_id' not in params or
                                                       params['questionnaire_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `questionnaire_id` when calling `get_questionnaire_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'questionnaire_id' in params:
            path_params['questionnaire_id'] = params['questionnaire_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/questionnaire/{questionnaire_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Questionnaire',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_answer_using_put(self, answer, answer_id, **kwargs):  # noqa: E501
        """Update an answer  # noqa: E501

        Update a answer for question.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_answer_using_put(answer, answer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object answer: answer (required)
        :param str answer_id: UUID answer_id (required)
        :return: Answer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_answer_using_put_with_http_info(answer, answer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_answer_using_put_with_http_info(answer, answer_id, **kwargs)  # noqa: E501
            return data

    def update_answer_using_put_with_http_info(self, answer, answer_id, **kwargs):  # noqa: E501
        """Update an answer  # noqa: E501

        Update a answer for question.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_answer_using_put_with_http_info(answer, answer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object answer: answer (required)
        :param str answer_id: UUID answer_id (required)
        :return: Answer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['answer', 'answer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_answer_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'answer' is set
        if self.api_client.client_side_validation and ('answer' not in params or
                                                       params['answer'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `answer` when calling `update_answer_using_put`")  # noqa: E501
        # verify the required parameter 'answer_id' is set
        if self.api_client.client_side_validation and ('answer_id' not in params or
                                                       params['answer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `answer_id` when calling `update_answer_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'answer_id' in params:
            path_params['answer_id'] = params['answer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'answer' in params:
            body_params = params['answer']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/answer/{answer_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Answer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_question_using_put(self, question, question_id, **kwargs):  # noqa: E501
        """Update a question.  # noqa: E501

        Update a question for questionnaire.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_question_using_put(question, question_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object question: question (required)
        :param str question_id: UUID question_id (required)
        :return: Question
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_question_using_put_with_http_info(question, question_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_question_using_put_with_http_info(question, question_id, **kwargs)  # noqa: E501
            return data

    def update_question_using_put_with_http_info(self, question, question_id, **kwargs):  # noqa: E501
        """Update a question.  # noqa: E501

        Update a question for questionnaire.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_question_using_put_with_http_info(question, question_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object question: question (required)
        :param str question_id: UUID question_id (required)
        :return: Question
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['question', 'question_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_question_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'question' is set
        if self.api_client.client_side_validation and ('question' not in params or
                                                       params['question'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `question` when calling `update_question_using_put`")  # noqa: E501
        # verify the required parameter 'question_id' is set
        if self.api_client.client_side_validation and ('question_id' not in params or
                                                       params['question_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `question_id` when calling `update_question_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'question_id' in params:
            path_params['question_id'] = params['question_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'question' in params:
            body_params = params['question']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/question/{question_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Question',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_questionnaire_using_put(self, questionnaire, questionnaire_id, **kwargs):  # noqa: E501
        """Update a questionnaire  # noqa: E501

        Update a questionnaire for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_questionnaire_using_put(questionnaire, questionnaire_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object questionnaire: questionnaire (required)
        :param str questionnaire_id: UUID questionnaire_id (required)
        :return: Questionnaire
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_questionnaire_using_put_with_http_info(questionnaire, questionnaire_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_questionnaire_using_put_with_http_info(questionnaire, questionnaire_id, **kwargs)  # noqa: E501
            return data

    def update_questionnaire_using_put_with_http_info(self, questionnaire, questionnaire_id, **kwargs):  # noqa: E501
        """Update a questionnaire  # noqa: E501

        Update a questionnaire for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_questionnaire_using_put_with_http_info(questionnaire, questionnaire_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object questionnaire: questionnaire (required)
        :param str questionnaire_id: UUID questionnaire_id (required)
        :return: Questionnaire
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['questionnaire', 'questionnaire_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_questionnaire_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'questionnaire' is set
        if self.api_client.client_side_validation and ('questionnaire' not in params or
                                                       params['questionnaire'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `questionnaire` when calling `update_questionnaire_using_put`")  # noqa: E501
        # verify the required parameter 'questionnaire_id' is set
        if self.api_client.client_side_validation and ('questionnaire_id' not in params or
                                                       params['questionnaire_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `questionnaire_id` when calling `update_questionnaire_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'questionnaire_id' in params:
            path_params['questionnaire_id'] = params['questionnaire_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'questionnaire' in params:
            body_params = params['questionnaire']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/nucleus/v1/questionnaire/{questionnaire_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Questionnaire',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
