"use strict";
var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
Object.defineProperties(exports, { __esModule: { value: true }, [Symbol.toStringTag]: { value: "Module" } });
const React = require("react");
const chart = require("@deephaven/chart");
const jsapiBootstrap = require("@deephaven/jsapi-bootstrap");
const reactRedux = require("react-redux");
const ReactDOM = require("react-dom");
var PluginType = Object.freeze({
  AUTH_PLUGIN: "AuthPlugin",
  DASHBOARD_PLUGIN: "DashboardPlugin",
  WIDGET_PLUGIN: "WidgetPlugin",
  TABLE_PLUGIN: "TablePlugin",
  THEME_PLUGIN: "ThemePlugin"
});
function ownKeys$i(object, enumerableOnly) {
  var keys3 = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys3.push.apply(keys3, symbols);
  }
  return keys3;
}
function _objectSpread2$1(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = null != arguments[i] ? arguments[i] : {};
    i % 2 ? ownKeys$i(Object(source), true).forEach(function(key) {
      _defineProperty$N(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys$i(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _typeof$1(obj) {
  "@babel/helpers - typeof";
  return _typeof$1 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof$1(obj);
}
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
function _defineProperty$N(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray$1(arr, i) || _nonIterableRest();
}
function _toConsumableArray$1(arr) {
  return _arrayWithoutHoles$1(arr) || _iterableToArray$1(arr) || _unsupportedIterableToArray$1(arr) || _nonIterableSpread$1();
}
function _arrayWithoutHoles$1(arr) {
  if (Array.isArray(arr))
    return _arrayLikeToArray$1(arr);
}
function _arrayWithHoles(arr) {
  if (Array.isArray(arr))
    return arr;
}
function _iterableToArray$1(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
    return Array.from(iter);
}
function _iterableToArrayLimit(arr, i) {
  var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];
  if (_i == null)
    return;
  var _arr = [];
  var _n = true;
  var _d = false;
  var _s, _e;
  try {
    for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);
      if (i && _arr.length === i)
        break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null)
        _i["return"]();
    } finally {
      if (_d)
        throw _e;
    }
  }
  return _arr;
}
function _unsupportedIterableToArray$1(o, minLen) {
  if (!o)
    return;
  if (typeof o === "string")
    return _arrayLikeToArray$1(o, minLen);
  var n2 = Object.prototype.toString.call(o).slice(8, -1);
  if (n2 === "Object" && o.constructor)
    n2 = o.constructor.name;
  if (n2 === "Map" || n2 === "Set")
    return Array.from(o);
  if (n2 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n2))
    return _arrayLikeToArray$1(o, minLen);
}
function _arrayLikeToArray$1(arr, len) {
  if (len == null || len > arr.length)
    len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++)
    arr2[i] = arr[i];
  return arr2;
}
function _nonIterableSpread$1() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
var noop$2 = function noop() {
};
var _WINDOW = {};
var _DOCUMENT = {};
var _MUTATION_OBSERVER = null;
var _PERFORMANCE = {
  mark: noop$2,
  measure: noop$2
};
try {
  if (typeof window !== "undefined")
    _WINDOW = window;
  if (typeof document !== "undefined")
    _DOCUMENT = document;
  if (typeof MutationObserver !== "undefined")
    _MUTATION_OBSERVER = MutationObserver;
  if (typeof performance !== "undefined")
    _PERFORMANCE = performance;
} catch (e2) {
}
var _ref = _WINDOW.navigator || {}, _ref$userAgent = _ref.userAgent, userAgent = _ref$userAgent === void 0 ? "" : _ref$userAgent;
var WINDOW = _WINDOW;
var DOCUMENT = _DOCUMENT;
var MUTATION_OBSERVER = _MUTATION_OBSERVER;
var PERFORMANCE = _PERFORMANCE;
!!WINDOW.document;
var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === "function" && typeof DOCUMENT.createElement === "function";
var IS_IE = ~userAgent.indexOf("MSIE") || ~userAgent.indexOf("Trident/");
var _familyProxy, _familyProxy2, _familyProxy3, _familyProxy4, _familyProxy5;
var NAMESPACE_IDENTIFIER = "___FONT_AWESOME___";
var UNITS_IN_GRID = 16;
var DEFAULT_CSS_PREFIX = "fa";
var DEFAULT_REPLACEMENT_CLASS = "svg-inline--fa";
var DATA_FA_I2SVG = "data-fa-i2svg";
var DATA_FA_PSEUDO_ELEMENT = "data-fa-pseudo-element";
var DATA_FA_PSEUDO_ELEMENT_PENDING = "data-fa-pseudo-element-pending";
var DATA_PREFIX = "data-prefix";
var DATA_ICON = "data-icon";
var HTML_CLASS_I2SVG_BASE_CLASS = "fontawesome-i2svg";
var MUTATION_APPROACH_ASYNC = "async";
var TAGNAMES_TO_SKIP_FOR_PSEUDOELEMENTS = ["HTML", "HEAD", "STYLE", "SCRIPT"];
var PRODUCTION$1 = function() {
  try {
    return true;
  } catch (e2) {
    return false;
  }
}();
var FAMILY_CLASSIC = "classic";
var FAMILY_SHARP = "sharp";
var FAMILIES = [FAMILY_CLASSIC, FAMILY_SHARP];
function familyProxy(obj) {
  return new Proxy(obj, {
    get: function get3(target, prop) {
      return prop in target ? target[prop] : target[FAMILY_CLASSIC];
    }
  });
}
var PREFIX_TO_STYLE = familyProxy((_familyProxy = {}, _defineProperty$N(_familyProxy, FAMILY_CLASSIC, {
  "fa": "solid",
  "fas": "solid",
  "fa-solid": "solid",
  "far": "regular",
  "fa-regular": "regular",
  "fal": "light",
  "fa-light": "light",
  "fat": "thin",
  "fa-thin": "thin",
  "fad": "duotone",
  "fa-duotone": "duotone",
  "fab": "brands",
  "fa-brands": "brands",
  "fak": "kit",
  "fakd": "kit",
  "fa-kit": "kit",
  "fa-kit-duotone": "kit"
}), _defineProperty$N(_familyProxy, FAMILY_SHARP, {
  "fa": "solid",
  "fass": "solid",
  "fa-solid": "solid",
  "fasr": "regular",
  "fa-regular": "regular",
  "fasl": "light",
  "fa-light": "light",
  "fast": "thin",
  "fa-thin": "thin"
}), _familyProxy));
var STYLE_TO_PREFIX = familyProxy((_familyProxy2 = {}, _defineProperty$N(_familyProxy2, FAMILY_CLASSIC, {
  solid: "fas",
  regular: "far",
  light: "fal",
  thin: "fat",
  duotone: "fad",
  brands: "fab",
  kit: "fak"
}), _defineProperty$N(_familyProxy2, FAMILY_SHARP, {
  solid: "fass",
  regular: "fasr",
  light: "fasl",
  thin: "fast"
}), _familyProxy2));
var PREFIX_TO_LONG_STYLE = familyProxy((_familyProxy3 = {}, _defineProperty$N(_familyProxy3, FAMILY_CLASSIC, {
  fab: "fa-brands",
  fad: "fa-duotone",
  fak: "fa-kit",
  fal: "fa-light",
  far: "fa-regular",
  fas: "fa-solid",
  fat: "fa-thin"
}), _defineProperty$N(_familyProxy3, FAMILY_SHARP, {
  fass: "fa-solid",
  fasr: "fa-regular",
  fasl: "fa-light",
  fast: "fa-thin"
}), _familyProxy3));
var LONG_STYLE_TO_PREFIX = familyProxy((_familyProxy4 = {}, _defineProperty$N(_familyProxy4, FAMILY_CLASSIC, {
  "fa-brands": "fab",
  "fa-duotone": "fad",
  "fa-kit": "fak",
  "fa-light": "fal",
  "fa-regular": "far",
  "fa-solid": "fas",
  "fa-thin": "fat"
}), _defineProperty$N(_familyProxy4, FAMILY_SHARP, {
  "fa-solid": "fass",
  "fa-regular": "fasr",
  "fa-light": "fasl",
  "fa-thin": "fast"
}), _familyProxy4));
var ICON_SELECTION_SYNTAX_PATTERN = /fa(s|r|l|t|d|b|k|ss|sr|sl|st)?[\-\ ]/;
var LAYERS_TEXT_CLASSNAME = "fa-layers-text";
var FONT_FAMILY_PATTERN = /Font ?Awesome ?([56 ]*)(Solid|Regular|Light|Thin|Duotone|Brands|Free|Pro|Sharp|Kit)?.*/i;
var FONT_WEIGHT_TO_PREFIX = familyProxy((_familyProxy5 = {}, _defineProperty$N(_familyProxy5, FAMILY_CLASSIC, {
  900: "fas",
  400: "far",
  normal: "far",
  300: "fal",
  100: "fat"
}), _defineProperty$N(_familyProxy5, FAMILY_SHARP, {
  900: "fass",
  400: "fasr",
  300: "fasl",
  100: "fast"
}), _familyProxy5));
var oneToTen = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
var oneToTwenty = oneToTen.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]);
var ATTRIBUTES_WATCHED_FOR_MUTATION = ["class", "data-prefix", "data-icon", "data-fa-transform", "data-fa-mask"];
var DUOTONE_CLASSES = {
  GROUP: "duotone-group",
  SWAP_OPACITY: "swap-opacity",
  PRIMARY: "primary",
  SECONDARY: "secondary"
};
var prefixes = /* @__PURE__ */ new Set();
Object.keys(STYLE_TO_PREFIX[FAMILY_CLASSIC]).map(prefixes.add.bind(prefixes));
Object.keys(STYLE_TO_PREFIX[FAMILY_SHARP]).map(prefixes.add.bind(prefixes));
var RESERVED_CLASSES = [].concat(FAMILIES, _toConsumableArray$1(prefixes), ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "fw", "inverse", "layers-counter", "layers-text", "layers", "li", "pull-left", "pull-right", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", DUOTONE_CLASSES.GROUP, DUOTONE_CLASSES.SWAP_OPACITY, DUOTONE_CLASSES.PRIMARY, DUOTONE_CLASSES.SECONDARY]).concat(oneToTen.map(function(n2) {
  return "".concat(n2, "x");
})).concat(oneToTwenty.map(function(n2) {
  return "w-".concat(n2);
}));
var initial = WINDOW.FontAwesomeConfig || {};
function getAttrConfig(attr) {
  var element = DOCUMENT.querySelector("script[" + attr + "]");
  if (element) {
    return element.getAttribute(attr);
  }
}
function coerce(val) {
  if (val === "")
    return true;
  if (val === "false")
    return false;
  if (val === "true")
    return true;
  return val;
}
if (DOCUMENT && typeof DOCUMENT.querySelector === "function") {
  var attrs = [["data-family-prefix", "familyPrefix"], ["data-css-prefix", "cssPrefix"], ["data-family-default", "familyDefault"], ["data-style-default", "styleDefault"], ["data-replacement-class", "replacementClass"], ["data-auto-replace-svg", "autoReplaceSvg"], ["data-auto-add-css", "autoAddCss"], ["data-auto-a11y", "autoA11y"], ["data-search-pseudo-elements", "searchPseudoElements"], ["data-observe-mutations", "observeMutations"], ["data-mutate-approach", "mutateApproach"], ["data-keep-original-source", "keepOriginalSource"], ["data-measure-performance", "measurePerformance"], ["data-show-missing-icons", "showMissingIcons"]];
  attrs.forEach(function(_ref2) {
    var _ref22 = _slicedToArray(_ref2, 2), attr = _ref22[0], key = _ref22[1];
    var val = coerce(getAttrConfig(attr));
    if (val !== void 0 && val !== null) {
      initial[key] = val;
    }
  });
}
var _default = {
  styleDefault: "solid",
  familyDefault: "classic",
  cssPrefix: DEFAULT_CSS_PREFIX,
  replacementClass: DEFAULT_REPLACEMENT_CLASS,
  autoReplaceSvg: true,
  autoAddCss: true,
  autoA11y: true,
  searchPseudoElements: false,
  observeMutations: true,
  mutateApproach: "async",
  keepOriginalSource: true,
  measurePerformance: false,
  showMissingIcons: true
};
if (initial.familyPrefix) {
  initial.cssPrefix = initial.familyPrefix;
}
var _config = _objectSpread2$1(_objectSpread2$1({}, _default), initial);
if (!_config.autoReplaceSvg)
  _config.observeMutations = false;
var config$1 = {};
Object.keys(_default).forEach(function(key) {
  Object.defineProperty(config$1, key, {
    enumerable: true,
    set: function set2(val) {
      _config[key] = val;
      _onChangeCb.forEach(function(cb) {
        return cb(config$1);
      });
    },
    get: function get3() {
      return _config[key];
    }
  });
});
Object.defineProperty(config$1, "familyPrefix", {
  enumerable: true,
  set: function set(val) {
    _config.cssPrefix = val;
    _onChangeCb.forEach(function(cb) {
      return cb(config$1);
    });
  },
  get: function get() {
    return _config.cssPrefix;
  }
});
WINDOW.FontAwesomeConfig = config$1;
var _onChangeCb = [];
function onChange(cb) {
  _onChangeCb.push(cb);
  return function() {
    _onChangeCb.splice(_onChangeCb.indexOf(cb), 1);
  };
}
var d$1 = UNITS_IN_GRID;
var meaninglessTransform = {
  size: 16,
  x: 0,
  y: 0,
  rotate: 0,
  flipX: false,
  flipY: false
};
function insertCss(css2) {
  if (!css2 || !IS_DOM) {
    return;
  }
  var style = DOCUMENT.createElement("style");
  style.setAttribute("type", "text/css");
  style.innerHTML = css2;
  var headChildren = DOCUMENT.head.childNodes;
  var beforeChild = null;
  for (var i = headChildren.length - 1; i > -1; i--) {
    var child = headChildren[i];
    var tagName = (child.tagName || "").toUpperCase();
    if (["STYLE", "LINK"].indexOf(tagName) > -1) {
      beforeChild = child;
    }
  }
  DOCUMENT.head.insertBefore(style, beforeChild);
  return css2;
}
var idPool = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
function nextUniqueId() {
  var size = 12;
  var id = "";
  while (size-- > 0) {
    id += idPool[Math.random() * 62 | 0];
  }
  return id;
}
function toArray(obj) {
  var array = [];
  for (var i = (obj || []).length >>> 0; i--; ) {
    array[i] = obj[i];
  }
  return array;
}
function classArray(node) {
  if (node.classList) {
    return toArray(node.classList);
  } else {
    return (node.getAttribute("class") || "").split(" ").filter(function(i) {
      return i;
    });
  }
}
function htmlEscape(str) {
  return "".concat(str).replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/'/g, "&#39;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
}
function joinAttributes(attributes) {
  return Object.keys(attributes || {}).reduce(function(acc, attributeName) {
    return acc + "".concat(attributeName, '="').concat(htmlEscape(attributes[attributeName]), '" ');
  }, "").trim();
}
function joinStyles(styles2) {
  return Object.keys(styles2 || {}).reduce(function(acc, styleName) {
    return acc + "".concat(styleName, ": ").concat(styles2[styleName].trim(), ";");
  }, "");
}
function transformIsMeaningful(transform) {
  return transform.size !== meaninglessTransform.size || transform.x !== meaninglessTransform.x || transform.y !== meaninglessTransform.y || transform.rotate !== meaninglessTransform.rotate || transform.flipX || transform.flipY;
}
function transformForSvg(_ref2) {
  var transform = _ref2.transform, containerWidth = _ref2.containerWidth, iconWidth = _ref2.iconWidth;
  var outer = {
    transform: "translate(".concat(containerWidth / 2, " 256)")
  };
  var innerTranslate = "translate(".concat(transform.x * 32, ", ").concat(transform.y * 32, ") ");
  var innerScale = "scale(".concat(transform.size / 16 * (transform.flipX ? -1 : 1), ", ").concat(transform.size / 16 * (transform.flipY ? -1 : 1), ") ");
  var innerRotate = "rotate(".concat(transform.rotate, " 0 0)");
  var inner2 = {
    transform: "".concat(innerTranslate, " ").concat(innerScale, " ").concat(innerRotate)
  };
  var path = {
    transform: "translate(".concat(iconWidth / 2 * -1, " -256)")
  };
  return {
    outer,
    inner: inner2,
    path
  };
}
function transformForCss(_ref2) {
  var transform = _ref2.transform, _ref2$width = _ref2.width, width = _ref2$width === void 0 ? UNITS_IN_GRID : _ref2$width, _ref2$height = _ref2.height, height = _ref2$height === void 0 ? UNITS_IN_GRID : _ref2$height, _ref2$startCentered = _ref2.startCentered, startCentered = _ref2$startCentered === void 0 ? false : _ref2$startCentered;
  var val = "";
  if (startCentered && IS_IE) {
    val += "translate(".concat(transform.x / d$1 - width / 2, "em, ").concat(transform.y / d$1 - height / 2, "em) ");
  } else if (startCentered) {
    val += "translate(calc(-50% + ".concat(transform.x / d$1, "em), calc(-50% + ").concat(transform.y / d$1, "em)) ");
  } else {
    val += "translate(".concat(transform.x / d$1, "em, ").concat(transform.y / d$1, "em) ");
  }
  val += "scale(".concat(transform.size / d$1 * (transform.flipX ? -1 : 1), ", ").concat(transform.size / d$1 * (transform.flipY ? -1 : 1), ") ");
  val += "rotate(".concat(transform.rotate, "deg) ");
  return val;
}
var baseStyles = ':root, :host {\n  --fa-font-solid: normal 900 1em/1 "Font Awesome 6 Solid";\n  --fa-font-regular: normal 400 1em/1 "Font Awesome 6 Regular";\n  --fa-font-light: normal 300 1em/1 "Font Awesome 6 Light";\n  --fa-font-thin: normal 100 1em/1 "Font Awesome 6 Thin";\n  --fa-font-duotone: normal 900 1em/1 "Font Awesome 6 Duotone";\n  --fa-font-sharp-solid: normal 900 1em/1 "Font Awesome 6 Sharp";\n  --fa-font-sharp-regular: normal 400 1em/1 "Font Awesome 6 Sharp";\n  --fa-font-sharp-light: normal 300 1em/1 "Font Awesome 6 Sharp";\n  --fa-font-sharp-thin: normal 100 1em/1 "Font Awesome 6 Sharp";\n  --fa-font-brands: normal 400 1em/1 "Font Awesome 6 Brands";\n}\n\nsvg:not(:root).svg-inline--fa, svg:not(:host).svg-inline--fa {\n  overflow: visible;\n  box-sizing: content-box;\n}\n\n.svg-inline--fa {\n  display: var(--fa-display, inline-block);\n  height: 1em;\n  overflow: visible;\n  vertical-align: -0.125em;\n}\n.svg-inline--fa.fa-2xs {\n  vertical-align: 0.1em;\n}\n.svg-inline--fa.fa-xs {\n  vertical-align: 0em;\n}\n.svg-inline--fa.fa-sm {\n  vertical-align: -0.0714285705em;\n}\n.svg-inline--fa.fa-lg {\n  vertical-align: -0.2em;\n}\n.svg-inline--fa.fa-xl {\n  vertical-align: -0.25em;\n}\n.svg-inline--fa.fa-2xl {\n  vertical-align: -0.3125em;\n}\n.svg-inline--fa.fa-pull-left {\n  margin-right: var(--fa-pull-margin, 0.3em);\n  width: auto;\n}\n.svg-inline--fa.fa-pull-right {\n  margin-left: var(--fa-pull-margin, 0.3em);\n  width: auto;\n}\n.svg-inline--fa.fa-li {\n  width: var(--fa-li-width, 2em);\n  top: 0.25em;\n}\n.svg-inline--fa.fa-fw {\n  width: var(--fa-fw-width, 1.25em);\n}\n\n.fa-layers svg.svg-inline--fa {\n  bottom: 0;\n  left: 0;\n  margin: auto;\n  position: absolute;\n  right: 0;\n  top: 0;\n}\n\n.fa-layers-counter, .fa-layers-text {\n  display: inline-block;\n  position: absolute;\n  text-align: center;\n}\n\n.fa-layers {\n  display: inline-block;\n  height: 1em;\n  position: relative;\n  text-align: center;\n  vertical-align: -0.125em;\n  width: 1em;\n}\n.fa-layers svg.svg-inline--fa {\n  -webkit-transform-origin: center center;\n          transform-origin: center center;\n}\n\n.fa-layers-text {\n  left: 50%;\n  top: 50%;\n  -webkit-transform: translate(-50%, -50%);\n          transform: translate(-50%, -50%);\n  -webkit-transform-origin: center center;\n          transform-origin: center center;\n}\n\n.fa-layers-counter {\n  background-color: var(--fa-counter-background-color, #ff253a);\n  border-radius: var(--fa-counter-border-radius, 1em);\n  box-sizing: border-box;\n  color: var(--fa-inverse, #fff);\n  line-height: var(--fa-counter-line-height, 1);\n  max-width: var(--fa-counter-max-width, 5em);\n  min-width: var(--fa-counter-min-width, 1.5em);\n  overflow: hidden;\n  padding: var(--fa-counter-padding, 0.25em 0.5em);\n  right: var(--fa-right, 0);\n  text-overflow: ellipsis;\n  top: var(--fa-top, 0);\n  -webkit-transform: scale(var(--fa-counter-scale, 0.25));\n          transform: scale(var(--fa-counter-scale, 0.25));\n  -webkit-transform-origin: top right;\n          transform-origin: top right;\n}\n\n.fa-layers-bottom-right {\n  bottom: var(--fa-bottom, 0);\n  right: var(--fa-right, 0);\n  top: auto;\n  -webkit-transform: scale(var(--fa-layers-scale, 0.25));\n          transform: scale(var(--fa-layers-scale, 0.25));\n  -webkit-transform-origin: bottom right;\n          transform-origin: bottom right;\n}\n\n.fa-layers-bottom-left {\n  bottom: var(--fa-bottom, 0);\n  left: var(--fa-left, 0);\n  right: auto;\n  top: auto;\n  -webkit-transform: scale(var(--fa-layers-scale, 0.25));\n          transform: scale(var(--fa-layers-scale, 0.25));\n  -webkit-transform-origin: bottom left;\n          transform-origin: bottom left;\n}\n\n.fa-layers-top-right {\n  top: var(--fa-top, 0);\n  right: var(--fa-right, 0);\n  -webkit-transform: scale(var(--fa-layers-scale, 0.25));\n          transform: scale(var(--fa-layers-scale, 0.25));\n  -webkit-transform-origin: top right;\n          transform-origin: top right;\n}\n\n.fa-layers-top-left {\n  left: var(--fa-left, 0);\n  right: auto;\n  top: var(--fa-top, 0);\n  -webkit-transform: scale(var(--fa-layers-scale, 0.25));\n          transform: scale(var(--fa-layers-scale, 0.25));\n  -webkit-transform-origin: top left;\n          transform-origin: top left;\n}\n\n.fa-1x {\n  font-size: 1em;\n}\n\n.fa-2x {\n  font-size: 2em;\n}\n\n.fa-3x {\n  font-size: 3em;\n}\n\n.fa-4x {\n  font-size: 4em;\n}\n\n.fa-5x {\n  font-size: 5em;\n}\n\n.fa-6x {\n  font-size: 6em;\n}\n\n.fa-7x {\n  font-size: 7em;\n}\n\n.fa-8x {\n  font-size: 8em;\n}\n\n.fa-9x {\n  font-size: 9em;\n}\n\n.fa-10x {\n  font-size: 10em;\n}\n\n.fa-2xs {\n  font-size: 0.625em;\n  line-height: 0.1em;\n  vertical-align: 0.225em;\n}\n\n.fa-xs {\n  font-size: 0.75em;\n  line-height: 0.0833333337em;\n  vertical-align: 0.125em;\n}\n\n.fa-sm {\n  font-size: 0.875em;\n  line-height: 0.0714285718em;\n  vertical-align: 0.0535714295em;\n}\n\n.fa-lg {\n  font-size: 1.25em;\n  line-height: 0.05em;\n  vertical-align: -0.075em;\n}\n\n.fa-xl {\n  font-size: 1.5em;\n  line-height: 0.0416666682em;\n  vertical-align: -0.125em;\n}\n\n.fa-2xl {\n  font-size: 2em;\n  line-height: 0.03125em;\n  vertical-align: -0.1875em;\n}\n\n.fa-fw {\n  text-align: center;\n  width: 1.25em;\n}\n\n.fa-ul {\n  list-style-type: none;\n  margin-left: var(--fa-li-margin, 2.5em);\n  padding-left: 0;\n}\n.fa-ul > li {\n  position: relative;\n}\n\n.fa-li {\n  left: calc(var(--fa-li-width, 2em) * -1);\n  position: absolute;\n  text-align: center;\n  width: var(--fa-li-width, 2em);\n  line-height: inherit;\n}\n\n.fa-border {\n  border-color: var(--fa-border-color, #eee);\n  border-radius: var(--fa-border-radius, 0.1em);\n  border-style: var(--fa-border-style, solid);\n  border-width: var(--fa-border-width, 0.08em);\n  padding: var(--fa-border-padding, 0.2em 0.25em 0.15em);\n}\n\n.fa-pull-left {\n  float: left;\n  margin-right: var(--fa-pull-margin, 0.3em);\n}\n\n.fa-pull-right {\n  float: right;\n  margin-left: var(--fa-pull-margin, 0.3em);\n}\n\n.fa-beat {\n  -webkit-animation-name: fa-beat;\n          animation-name: fa-beat;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, ease-in-out);\n          animation-timing-function: var(--fa-animation-timing, ease-in-out);\n}\n\n.fa-bounce {\n  -webkit-animation-name: fa-bounce;\n          animation-name: fa-bounce;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.28, 0.84, 0.42, 1));\n          animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.28, 0.84, 0.42, 1));\n}\n\n.fa-fade {\n  -webkit-animation-name: fa-fade;\n          animation-name: fa-fade;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));\n          animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));\n}\n\n.fa-beat-fade {\n  -webkit-animation-name: fa-beat-fade;\n          animation-name: fa-beat-fade;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));\n          animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));\n}\n\n.fa-flip {\n  -webkit-animation-name: fa-flip;\n          animation-name: fa-flip;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, ease-in-out);\n          animation-timing-function: var(--fa-animation-timing, ease-in-out);\n}\n\n.fa-shake {\n  -webkit-animation-name: fa-shake;\n          animation-name: fa-shake;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, linear);\n          animation-timing-function: var(--fa-animation-timing, linear);\n}\n\n.fa-spin {\n  -webkit-animation-name: fa-spin;\n          animation-name: fa-spin;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 2s);\n          animation-duration: var(--fa-animation-duration, 2s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, linear);\n          animation-timing-function: var(--fa-animation-timing, linear);\n}\n\n.fa-spin-reverse {\n  --fa-animation-direction: reverse;\n}\n\n.fa-pulse,\n.fa-spin-pulse {\n  -webkit-animation-name: fa-spin;\n          animation-name: fa-spin;\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, steps(8));\n          animation-timing-function: var(--fa-animation-timing, steps(8));\n}\n\n@media (prefers-reduced-motion: reduce) {\n  .fa-beat,\n.fa-bounce,\n.fa-fade,\n.fa-beat-fade,\n.fa-flip,\n.fa-pulse,\n.fa-shake,\n.fa-spin,\n.fa-spin-pulse {\n    -webkit-animation-delay: -1ms;\n            animation-delay: -1ms;\n    -webkit-animation-duration: 1ms;\n            animation-duration: 1ms;\n    -webkit-animation-iteration-count: 1;\n            animation-iteration-count: 1;\n    -webkit-transition-delay: 0s;\n            transition-delay: 0s;\n    -webkit-transition-duration: 0s;\n            transition-duration: 0s;\n  }\n}\n@-webkit-keyframes fa-beat {\n  0%, 90% {\n    -webkit-transform: scale(1);\n            transform: scale(1);\n  }\n  45% {\n    -webkit-transform: scale(var(--fa-beat-scale, 1.25));\n            transform: scale(var(--fa-beat-scale, 1.25));\n  }\n}\n@keyframes fa-beat {\n  0%, 90% {\n    -webkit-transform: scale(1);\n            transform: scale(1);\n  }\n  45% {\n    -webkit-transform: scale(var(--fa-beat-scale, 1.25));\n            transform: scale(var(--fa-beat-scale, 1.25));\n  }\n}\n@-webkit-keyframes fa-bounce {\n  0% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n  10% {\n    -webkit-transform: scale(var(--fa-bounce-start-scale-x, 1.1), var(--fa-bounce-start-scale-y, 0.9)) translateY(0);\n            transform: scale(var(--fa-bounce-start-scale-x, 1.1), var(--fa-bounce-start-scale-y, 0.9)) translateY(0);\n  }\n  30% {\n    -webkit-transform: scale(var(--fa-bounce-jump-scale-x, 0.9), var(--fa-bounce-jump-scale-y, 1.1)) translateY(var(--fa-bounce-height, -0.5em));\n            transform: scale(var(--fa-bounce-jump-scale-x, 0.9), var(--fa-bounce-jump-scale-y, 1.1)) translateY(var(--fa-bounce-height, -0.5em));\n  }\n  50% {\n    -webkit-transform: scale(var(--fa-bounce-land-scale-x, 1.05), var(--fa-bounce-land-scale-y, 0.95)) translateY(0);\n            transform: scale(var(--fa-bounce-land-scale-x, 1.05), var(--fa-bounce-land-scale-y, 0.95)) translateY(0);\n  }\n  57% {\n    -webkit-transform: scale(1, 1) translateY(var(--fa-bounce-rebound, -0.125em));\n            transform: scale(1, 1) translateY(var(--fa-bounce-rebound, -0.125em));\n  }\n  64% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n  100% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n}\n@keyframes fa-bounce {\n  0% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n  10% {\n    -webkit-transform: scale(var(--fa-bounce-start-scale-x, 1.1), var(--fa-bounce-start-scale-y, 0.9)) translateY(0);\n            transform: scale(var(--fa-bounce-start-scale-x, 1.1), var(--fa-bounce-start-scale-y, 0.9)) translateY(0);\n  }\n  30% {\n    -webkit-transform: scale(var(--fa-bounce-jump-scale-x, 0.9), var(--fa-bounce-jump-scale-y, 1.1)) translateY(var(--fa-bounce-height, -0.5em));\n            transform: scale(var(--fa-bounce-jump-scale-x, 0.9), var(--fa-bounce-jump-scale-y, 1.1)) translateY(var(--fa-bounce-height, -0.5em));\n  }\n  50% {\n    -webkit-transform: scale(var(--fa-bounce-land-scale-x, 1.05), var(--fa-bounce-land-scale-y, 0.95)) translateY(0);\n            transform: scale(var(--fa-bounce-land-scale-x, 1.05), var(--fa-bounce-land-scale-y, 0.95)) translateY(0);\n  }\n  57% {\n    -webkit-transform: scale(1, 1) translateY(var(--fa-bounce-rebound, -0.125em));\n            transform: scale(1, 1) translateY(var(--fa-bounce-rebound, -0.125em));\n  }\n  64% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n  100% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n}\n@-webkit-keyframes fa-fade {\n  50% {\n    opacity: var(--fa-fade-opacity, 0.4);\n  }\n}\n@keyframes fa-fade {\n  50% {\n    opacity: var(--fa-fade-opacity, 0.4);\n  }\n}\n@-webkit-keyframes fa-beat-fade {\n  0%, 100% {\n    opacity: var(--fa-beat-fade-opacity, 0.4);\n    -webkit-transform: scale(1);\n            transform: scale(1);\n  }\n  50% {\n    opacity: 1;\n    -webkit-transform: scale(var(--fa-beat-fade-scale, 1.125));\n            transform: scale(var(--fa-beat-fade-scale, 1.125));\n  }\n}\n@keyframes fa-beat-fade {\n  0%, 100% {\n    opacity: var(--fa-beat-fade-opacity, 0.4);\n    -webkit-transform: scale(1);\n            transform: scale(1);\n  }\n  50% {\n    opacity: 1;\n    -webkit-transform: scale(var(--fa-beat-fade-scale, 1.125));\n            transform: scale(var(--fa-beat-fade-scale, 1.125));\n  }\n}\n@-webkit-keyframes fa-flip {\n  50% {\n    -webkit-transform: rotate3d(var(--fa-flip-x, 0), var(--fa-flip-y, 1), var(--fa-flip-z, 0), var(--fa-flip-angle, -180deg));\n            transform: rotate3d(var(--fa-flip-x, 0), var(--fa-flip-y, 1), var(--fa-flip-z, 0), var(--fa-flip-angle, -180deg));\n  }\n}\n@keyframes fa-flip {\n  50% {\n    -webkit-transform: rotate3d(var(--fa-flip-x, 0), var(--fa-flip-y, 1), var(--fa-flip-z, 0), var(--fa-flip-angle, -180deg));\n            transform: rotate3d(var(--fa-flip-x, 0), var(--fa-flip-y, 1), var(--fa-flip-z, 0), var(--fa-flip-angle, -180deg));\n  }\n}\n@-webkit-keyframes fa-shake {\n  0% {\n    -webkit-transform: rotate(-15deg);\n            transform: rotate(-15deg);\n  }\n  4% {\n    -webkit-transform: rotate(15deg);\n            transform: rotate(15deg);\n  }\n  8%, 24% {\n    -webkit-transform: rotate(-18deg);\n            transform: rotate(-18deg);\n  }\n  12%, 28% {\n    -webkit-transform: rotate(18deg);\n            transform: rotate(18deg);\n  }\n  16% {\n    -webkit-transform: rotate(-22deg);\n            transform: rotate(-22deg);\n  }\n  20% {\n    -webkit-transform: rotate(22deg);\n            transform: rotate(22deg);\n  }\n  32% {\n    -webkit-transform: rotate(-12deg);\n            transform: rotate(-12deg);\n  }\n  36% {\n    -webkit-transform: rotate(12deg);\n            transform: rotate(12deg);\n  }\n  40%, 100% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg);\n  }\n}\n@keyframes fa-shake {\n  0% {\n    -webkit-transform: rotate(-15deg);\n            transform: rotate(-15deg);\n  }\n  4% {\n    -webkit-transform: rotate(15deg);\n            transform: rotate(15deg);\n  }\n  8%, 24% {\n    -webkit-transform: rotate(-18deg);\n            transform: rotate(-18deg);\n  }\n  12%, 28% {\n    -webkit-transform: rotate(18deg);\n            transform: rotate(18deg);\n  }\n  16% {\n    -webkit-transform: rotate(-22deg);\n            transform: rotate(-22deg);\n  }\n  20% {\n    -webkit-transform: rotate(22deg);\n            transform: rotate(22deg);\n  }\n  32% {\n    -webkit-transform: rotate(-12deg);\n            transform: rotate(-12deg);\n  }\n  36% {\n    -webkit-transform: rotate(12deg);\n            transform: rotate(12deg);\n  }\n  40%, 100% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg);\n  }\n}\n@-webkit-keyframes fa-spin {\n  0% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(360deg);\n            transform: rotate(360deg);\n  }\n}\n@keyframes fa-spin {\n  0% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(360deg);\n            transform: rotate(360deg);\n  }\n}\n.fa-rotate-90 {\n  -webkit-transform: rotate(90deg);\n          transform: rotate(90deg);\n}\n\n.fa-rotate-180 {\n  -webkit-transform: rotate(180deg);\n          transform: rotate(180deg);\n}\n\n.fa-rotate-270 {\n  -webkit-transform: rotate(270deg);\n          transform: rotate(270deg);\n}\n\n.fa-flip-horizontal {\n  -webkit-transform: scale(-1, 1);\n          transform: scale(-1, 1);\n}\n\n.fa-flip-vertical {\n  -webkit-transform: scale(1, -1);\n          transform: scale(1, -1);\n}\n\n.fa-flip-both,\n.fa-flip-horizontal.fa-flip-vertical {\n  -webkit-transform: scale(-1, -1);\n          transform: scale(-1, -1);\n}\n\n.fa-rotate-by {\n  -webkit-transform: rotate(var(--fa-rotate-angle, none));\n          transform: rotate(var(--fa-rotate-angle, none));\n}\n\n.fa-stack {\n  display: inline-block;\n  vertical-align: middle;\n  height: 2em;\n  position: relative;\n  width: 2.5em;\n}\n\n.fa-stack-1x,\n.fa-stack-2x {\n  bottom: 0;\n  left: 0;\n  margin: auto;\n  position: absolute;\n  right: 0;\n  top: 0;\n  z-index: var(--fa-stack-z-index, auto);\n}\n\n.svg-inline--fa.fa-stack-1x {\n  height: 1em;\n  width: 1.25em;\n}\n.svg-inline--fa.fa-stack-2x {\n  height: 2em;\n  width: 2.5em;\n}\n\n.fa-inverse {\n  color: var(--fa-inverse, #fff);\n}\n\n.sr-only,\n.fa-sr-only {\n  position: absolute;\n  width: 1px;\n  height: 1px;\n  padding: 0;\n  margin: -1px;\n  overflow: hidden;\n  clip: rect(0, 0, 0, 0);\n  white-space: nowrap;\n  border-width: 0;\n}\n\n.sr-only-focusable:not(:focus),\n.fa-sr-only-focusable:not(:focus) {\n  position: absolute;\n  width: 1px;\n  height: 1px;\n  padding: 0;\n  margin: -1px;\n  overflow: hidden;\n  clip: rect(0, 0, 0, 0);\n  white-space: nowrap;\n  border-width: 0;\n}\n\n.svg-inline--fa .fa-primary {\n  fill: var(--fa-primary-color, currentColor);\n  opacity: var(--fa-primary-opacity, 1);\n}\n\n.svg-inline--fa .fa-secondary {\n  fill: var(--fa-secondary-color, currentColor);\n  opacity: var(--fa-secondary-opacity, 0.4);\n}\n\n.svg-inline--fa.fa-swap-opacity .fa-primary {\n  opacity: var(--fa-secondary-opacity, 0.4);\n}\n\n.svg-inline--fa.fa-swap-opacity .fa-secondary {\n  opacity: var(--fa-primary-opacity, 1);\n}\n\n.svg-inline--fa mask .fa-primary,\n.svg-inline--fa mask .fa-secondary {\n  fill: black;\n}\n\n.fad.fa-inverse,\n.fa-duotone.fa-inverse {\n  color: var(--fa-inverse, #fff);\n}';
function css() {
  var dcp = DEFAULT_CSS_PREFIX;
  var drc = DEFAULT_REPLACEMENT_CLASS;
  var fp = config$1.cssPrefix;
  var rc = config$1.replacementClass;
  var s = baseStyles;
  if (fp !== dcp || rc !== drc) {
    var dPatt = new RegExp("\\.".concat(dcp, "\\-"), "g");
    var customPropPatt = new RegExp("\\--".concat(dcp, "\\-"), "g");
    var rPatt = new RegExp("\\.".concat(drc), "g");
    s = s.replace(dPatt, ".".concat(fp, "-")).replace(customPropPatt, "--".concat(fp, "-")).replace(rPatt, ".".concat(rc));
  }
  return s;
}
var _cssInserted = false;
function ensureCss() {
  if (config$1.autoAddCss && !_cssInserted) {
    insertCss(css());
    _cssInserted = true;
  }
}
var InjectCSS = {
  mixout: function mixout() {
    return {
      dom: {
        css,
        insertCss: ensureCss
      }
    };
  },
  hooks: function hooks() {
    return {
      beforeDOMElementCreation: function beforeDOMElementCreation() {
        ensureCss();
      },
      beforeI2svg: function beforeI2svg() {
        ensureCss();
      }
    };
  }
};
var w$1 = WINDOW || {};
if (!w$1[NAMESPACE_IDENTIFIER])
  w$1[NAMESPACE_IDENTIFIER] = {};
if (!w$1[NAMESPACE_IDENTIFIER].styles)
  w$1[NAMESPACE_IDENTIFIER].styles = {};
if (!w$1[NAMESPACE_IDENTIFIER].hooks)
  w$1[NAMESPACE_IDENTIFIER].hooks = {};
if (!w$1[NAMESPACE_IDENTIFIER].shims)
  w$1[NAMESPACE_IDENTIFIER].shims = [];
var namespace = w$1[NAMESPACE_IDENTIFIER];
var functions = [];
var listener = function listener2() {
  DOCUMENT.removeEventListener("DOMContentLoaded", listener2);
  loaded = 1;
  functions.map(function(fn) {
    return fn();
  });
};
var loaded = false;
if (IS_DOM) {
  loaded = (DOCUMENT.documentElement.doScroll ? /^loaded|^c/ : /^loaded|^i|^c/).test(DOCUMENT.readyState);
  if (!loaded)
    DOCUMENT.addEventListener("DOMContentLoaded", listener);
}
function domready(fn) {
  if (!IS_DOM)
    return;
  loaded ? setTimeout(fn, 0) : functions.push(fn);
}
function toHtml(abstractNodes) {
  var tag = abstractNodes.tag, _abstractNodes$attrib = abstractNodes.attributes, attributes = _abstractNodes$attrib === void 0 ? {} : _abstractNodes$attrib, _abstractNodes$childr = abstractNodes.children, children = _abstractNodes$childr === void 0 ? [] : _abstractNodes$childr;
  if (typeof abstractNodes === "string") {
    return htmlEscape(abstractNodes);
  } else {
    return "<".concat(tag, " ").concat(joinAttributes(attributes), ">").concat(children.map(toHtml).join(""), "</").concat(tag, ">");
  }
}
function iconFromMapping(mapping, prefix, iconName) {
  if (mapping && mapping[prefix] && mapping[prefix][iconName]) {
    return {
      prefix,
      iconName,
      icon: mapping[prefix][iconName]
    };
  }
}
var bindInternal4 = function bindInternal42(func, thisContext) {
  return function(a, b2, c2, d2) {
    return func.call(thisContext, a, b2, c2, d2);
  };
};
var reduce = function fastReduceObject(subject, fn, initialValue, thisContext) {
  var keys3 = Object.keys(subject), length = keys3.length, iterator = thisContext !== void 0 ? bindInternal4(fn, thisContext) : fn, i, key, result;
  if (initialValue === void 0) {
    i = 1;
    result = subject[keys3[0]];
  } else {
    i = 0;
    result = initialValue;
  }
  for (; i < length; i++) {
    key = keys3[i];
    result = iterator(result, subject[key], key, subject);
  }
  return result;
};
function ucs2decode(string) {
  var output = [];
  var counter2 = 0;
  var length = string.length;
  while (counter2 < length) {
    var value = string.charCodeAt(counter2++);
    if (value >= 55296 && value <= 56319 && counter2 < length) {
      var extra = string.charCodeAt(counter2++);
      if ((extra & 64512) == 56320) {
        output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
      } else {
        output.push(value);
        counter2--;
      }
    } else {
      output.push(value);
    }
  }
  return output;
}
function toHex(unicode) {
  var decoded = ucs2decode(unicode);
  return decoded.length === 1 ? decoded[0].toString(16) : null;
}
function codePointAt(string, index) {
  var size = string.length;
  var first = string.charCodeAt(index);
  var second;
  if (first >= 55296 && first <= 56319 && size > index + 1) {
    second = string.charCodeAt(index + 1);
    if (second >= 56320 && second <= 57343) {
      return (first - 55296) * 1024 + second - 56320 + 65536;
    }
  }
  return first;
}
function normalizeIcons(icons) {
  return Object.keys(icons).reduce(function(acc, iconName) {
    var icon3 = icons[iconName];
    var expanded = !!icon3.icon;
    if (expanded) {
      acc[icon3.iconName] = icon3.icon;
    } else {
      acc[iconName] = icon3;
    }
    return acc;
  }, {});
}
function defineIcons(prefix, icons) {
  var params = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
  var _params$skipHooks = params.skipHooks, skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
  var normalized = normalizeIcons(icons);
  if (typeof namespace.hooks.addPack === "function" && !skipHooks) {
    namespace.hooks.addPack(prefix, normalizeIcons(icons));
  } else {
    namespace.styles[prefix] = _objectSpread2$1(_objectSpread2$1({}, namespace.styles[prefix] || {}), normalized);
  }
  if (prefix === "fas") {
    defineIcons("fa", icons);
  }
}
var _LONG_STYLE, _PREFIXES, _PREFIXES_FOR_FAMILY;
var styles = namespace.styles, shims = namespace.shims;
var LONG_STYLE = (_LONG_STYLE = {}, _defineProperty$N(_LONG_STYLE, FAMILY_CLASSIC, Object.values(PREFIX_TO_LONG_STYLE[FAMILY_CLASSIC])), _defineProperty$N(_LONG_STYLE, FAMILY_SHARP, Object.values(PREFIX_TO_LONG_STYLE[FAMILY_SHARP])), _LONG_STYLE);
var _defaultUsablePrefix = null;
var _byUnicode = {};
var _byLigature = {};
var _byOldName = {};
var _byOldUnicode = {};
var _byAlias = {};
var PREFIXES = (_PREFIXES = {}, _defineProperty$N(_PREFIXES, FAMILY_CLASSIC, Object.keys(PREFIX_TO_STYLE[FAMILY_CLASSIC])), _defineProperty$N(_PREFIXES, FAMILY_SHARP, Object.keys(PREFIX_TO_STYLE[FAMILY_SHARP])), _PREFIXES);
function isReserved(name2) {
  return ~RESERVED_CLASSES.indexOf(name2);
}
function getIconName(cssPrefix, cls) {
  var parts = cls.split("-");
  var prefix = parts[0];
  var iconName = parts.slice(1).join("-");
  if (prefix === cssPrefix && iconName !== "" && !isReserved(iconName)) {
    return iconName;
  } else {
    return null;
  }
}
var build$1 = function build() {
  var lookup2 = function lookup3(reducer) {
    return reduce(styles, function(o, style, prefix) {
      o[prefix] = reduce(style, reducer, {});
      return o;
    }, {});
  };
  _byUnicode = lookup2(function(acc, icon3, iconName) {
    if (icon3[3]) {
      acc[icon3[3]] = iconName;
    }
    if (icon3[2]) {
      var aliases = icon3[2].filter(function(a) {
        return typeof a === "number";
      });
      aliases.forEach(function(alias) {
        acc[alias.toString(16)] = iconName;
      });
    }
    return acc;
  });
  _byLigature = lookup2(function(acc, icon3, iconName) {
    acc[iconName] = iconName;
    if (icon3[2]) {
      var aliases = icon3[2].filter(function(a) {
        return typeof a === "string";
      });
      aliases.forEach(function(alias) {
        acc[alias] = iconName;
      });
    }
    return acc;
  });
  _byAlias = lookup2(function(acc, icon3, iconName) {
    var aliases = icon3[2];
    acc[iconName] = iconName;
    aliases.forEach(function(alias) {
      acc[alias] = iconName;
    });
    return acc;
  });
  var hasRegular = "far" in styles || config$1.autoFetchSvg;
  var shimLookups = reduce(shims, function(acc, shim2) {
    var maybeNameMaybeUnicode = shim2[0];
    var prefix = shim2[1];
    var iconName = shim2[2];
    if (prefix === "far" && !hasRegular) {
      prefix = "fas";
    }
    if (typeof maybeNameMaybeUnicode === "string") {
      acc.names[maybeNameMaybeUnicode] = {
        prefix,
        iconName
      };
    }
    if (typeof maybeNameMaybeUnicode === "number") {
      acc.unicodes[maybeNameMaybeUnicode.toString(16)] = {
        prefix,
        iconName
      };
    }
    return acc;
  }, {
    names: {},
    unicodes: {}
  });
  _byOldName = shimLookups.names;
  _byOldUnicode = shimLookups.unicodes;
  _defaultUsablePrefix = getCanonicalPrefix(config$1.styleDefault, {
    family: config$1.familyDefault
  });
};
onChange(function(c2) {
  _defaultUsablePrefix = getCanonicalPrefix(c2.styleDefault, {
    family: config$1.familyDefault
  });
});
build$1();
function byUnicode(prefix, unicode) {
  return (_byUnicode[prefix] || {})[unicode];
}
function byLigature(prefix, ligature) {
  return (_byLigature[prefix] || {})[ligature];
}
function byAlias(prefix, alias) {
  return (_byAlias[prefix] || {})[alias];
}
function byOldName(name2) {
  return _byOldName[name2] || {
    prefix: null,
    iconName: null
  };
}
function byOldUnicode(unicode) {
  var oldUnicode = _byOldUnicode[unicode];
  var newUnicode = byUnicode("fas", unicode);
  return oldUnicode || (newUnicode ? {
    prefix: "fas",
    iconName: newUnicode
  } : null) || {
    prefix: null,
    iconName: null
  };
}
function getDefaultUsablePrefix() {
  return _defaultUsablePrefix;
}
var emptyCanonicalIcon = function emptyCanonicalIcon2() {
  return {
    prefix: null,
    iconName: null,
    rest: []
  };
};
function getCanonicalPrefix(styleOrPrefix) {
  var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
  var _params$family = params.family, family = _params$family === void 0 ? FAMILY_CLASSIC : _params$family;
  var style = PREFIX_TO_STYLE[family][styleOrPrefix];
  var prefix = STYLE_TO_PREFIX[family][styleOrPrefix] || STYLE_TO_PREFIX[family][style];
  var defined = styleOrPrefix in namespace.styles ? styleOrPrefix : null;
  return prefix || defined || null;
}
var PREFIXES_FOR_FAMILY = (_PREFIXES_FOR_FAMILY = {}, _defineProperty$N(_PREFIXES_FOR_FAMILY, FAMILY_CLASSIC, Object.keys(PREFIX_TO_LONG_STYLE[FAMILY_CLASSIC])), _defineProperty$N(_PREFIXES_FOR_FAMILY, FAMILY_SHARP, Object.keys(PREFIX_TO_LONG_STYLE[FAMILY_SHARP])), _PREFIXES_FOR_FAMILY);
function getCanonicalIcon(values) {
  var _famProps;
  var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
  var _params$skipLookups = params.skipLookups, skipLookups = _params$skipLookups === void 0 ? false : _params$skipLookups;
  var famProps = (_famProps = {}, _defineProperty$N(_famProps, FAMILY_CLASSIC, "".concat(config$1.cssPrefix, "-").concat(FAMILY_CLASSIC)), _defineProperty$N(_famProps, FAMILY_SHARP, "".concat(config$1.cssPrefix, "-").concat(FAMILY_SHARP)), _famProps);
  var givenPrefix = null;
  var family = FAMILY_CLASSIC;
  if (values.includes(famProps[FAMILY_CLASSIC]) || values.some(function(v2) {
    return PREFIXES_FOR_FAMILY[FAMILY_CLASSIC].includes(v2);
  })) {
    family = FAMILY_CLASSIC;
  }
  if (values.includes(famProps[FAMILY_SHARP]) || values.some(function(v2) {
    return PREFIXES_FOR_FAMILY[FAMILY_SHARP].includes(v2);
  })) {
    family = FAMILY_SHARP;
  }
  var canonical = values.reduce(function(acc, cls) {
    var iconName = getIconName(config$1.cssPrefix, cls);
    if (styles[cls]) {
      cls = LONG_STYLE[family].includes(cls) ? LONG_STYLE_TO_PREFIX[family][cls] : cls;
      givenPrefix = cls;
      acc.prefix = cls;
    } else if (PREFIXES[family].indexOf(cls) > -1) {
      givenPrefix = cls;
      acc.prefix = getCanonicalPrefix(cls, {
        family
      });
    } else if (iconName) {
      acc.iconName = iconName;
    } else if (cls !== config$1.replacementClass && cls !== famProps[FAMILY_CLASSIC] && cls !== famProps[FAMILY_SHARP]) {
      acc.rest.push(cls);
    }
    if (!skipLookups && acc.prefix && acc.iconName) {
      var shim2 = givenPrefix === "fa" ? byOldName(acc.iconName) : {};
      var aliasIconName = byAlias(acc.prefix, acc.iconName);
      if (shim2.prefix) {
        givenPrefix = null;
      }
      acc.iconName = shim2.iconName || aliasIconName || acc.iconName;
      acc.prefix = shim2.prefix || acc.prefix;
      if (acc.prefix === "far" && !styles["far"] && styles["fas"] && !config$1.autoFetchSvg) {
        acc.prefix = "fas";
      }
    }
    return acc;
  }, emptyCanonicalIcon());
  if (values.includes("fa-brands") || values.includes("fab")) {
    canonical.prefix = "fab";
  }
  if (values.includes("fa-duotone") || values.includes("fad")) {
    canonical.prefix = "fad";
  }
  if (!canonical.prefix && family === FAMILY_SHARP && (styles["fass"] || config$1.autoFetchSvg)) {
    canonical.prefix = "fass";
    canonical.iconName = byAlias(canonical.prefix, canonical.iconName) || canonical.iconName;
  }
  if (canonical.prefix === "fa" || givenPrefix === "fa") {
    canonical.prefix = getDefaultUsablePrefix() || "fas";
  }
  return canonical;
}
var Library = /* @__PURE__ */ function() {
  function Library2() {
    _classCallCheck(this, Library2);
    this.definitions = {};
  }
  _createClass(Library2, [{
    key: "add",
    value: function add() {
      var _this = this;
      for (var _len = arguments.length, definitions = new Array(_len), _key = 0; _key < _len; _key++) {
        definitions[_key] = arguments[_key];
      }
      var additions = definitions.reduce(this._pullDefinitions, {});
      Object.keys(additions).forEach(function(key) {
        _this.definitions[key] = _objectSpread2$1(_objectSpread2$1({}, _this.definitions[key] || {}), additions[key]);
        defineIcons(key, additions[key]);
        var longPrefix = PREFIX_TO_LONG_STYLE[FAMILY_CLASSIC][key];
        if (longPrefix)
          defineIcons(longPrefix, additions[key]);
        build$1();
      });
    }
  }, {
    key: "reset",
    value: function reset2() {
      this.definitions = {};
    }
  }, {
    key: "_pullDefinitions",
    value: function _pullDefinitions(additions, definition) {
      var normalized = definition.prefix && definition.iconName && definition.icon ? {
        0: definition
      } : definition;
      Object.keys(normalized).map(function(key) {
        var _normalized$key = normalized[key], prefix = _normalized$key.prefix, iconName = _normalized$key.iconName, icon3 = _normalized$key.icon;
        var aliases = icon3[2];
        if (!additions[prefix])
          additions[prefix] = {};
        if (aliases.length > 0) {
          aliases.forEach(function(alias) {
            if (typeof alias === "string") {
              additions[prefix][alias] = icon3;
            }
          });
        }
        additions[prefix][iconName] = icon3;
      });
      return additions;
    }
  }]);
  return Library2;
}();
var _plugins = [];
var _hooks = {};
var providers = {};
var defaultProviderKeys = Object.keys(providers);
function registerPlugins(nextPlugins, _ref2) {
  var obj = _ref2.mixoutsTo;
  _plugins = nextPlugins;
  _hooks = {};
  Object.keys(providers).forEach(function(k2) {
    if (defaultProviderKeys.indexOf(k2) === -1) {
      delete providers[k2];
    }
  });
  _plugins.forEach(function(plugin) {
    var mixout8 = plugin.mixout ? plugin.mixout() : {};
    Object.keys(mixout8).forEach(function(tk2) {
      if (typeof mixout8[tk2] === "function") {
        obj[tk2] = mixout8[tk2];
      }
      if (_typeof$1(mixout8[tk2]) === "object") {
        Object.keys(mixout8[tk2]).forEach(function(sk) {
          if (!obj[tk2]) {
            obj[tk2] = {};
          }
          obj[tk2][sk] = mixout8[tk2][sk];
        });
      }
    });
    if (plugin.hooks) {
      var hooks8 = plugin.hooks();
      Object.keys(hooks8).forEach(function(hook) {
        if (!_hooks[hook]) {
          _hooks[hook] = [];
        }
        _hooks[hook].push(hooks8[hook]);
      });
    }
    if (plugin.provides) {
      plugin.provides(providers);
    }
  });
  return obj;
}
function chainHooks(hook, accumulator) {
  for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
    args[_key - 2] = arguments[_key];
  }
  var hookFns = _hooks[hook] || [];
  hookFns.forEach(function(hookFn) {
    accumulator = hookFn.apply(null, [accumulator].concat(args));
  });
  return accumulator;
}
function callHooks(hook) {
  for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
    args[_key2 - 1] = arguments[_key2];
  }
  var hookFns = _hooks[hook] || [];
  hookFns.forEach(function(hookFn) {
    hookFn.apply(null, args);
  });
  return void 0;
}
function callProvided() {
  var hook = arguments[0];
  var args = Array.prototype.slice.call(arguments, 1);
  return providers[hook] ? providers[hook].apply(null, args) : void 0;
}
function findIconDefinition(iconLookup) {
  if (iconLookup.prefix === "fa") {
    iconLookup.prefix = "fas";
  }
  var iconName = iconLookup.iconName;
  var prefix = iconLookup.prefix || getDefaultUsablePrefix();
  if (!iconName)
    return;
  iconName = byAlias(prefix, iconName) || iconName;
  return iconFromMapping(library.definitions, prefix, iconName) || iconFromMapping(namespace.styles, prefix, iconName);
}
var library = new Library();
var noAuto = function noAuto2() {
  config$1.autoReplaceSvg = false;
  config$1.observeMutations = false;
  callHooks("noAuto");
};
var dom = {
  i2svg: function i2svg() {
    var params = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    if (IS_DOM) {
      callHooks("beforeI2svg", params);
      callProvided("pseudoElements2svg", params);
      return callProvided("i2svg", params);
    } else {
      return Promise.reject("Operation requires a DOM of some kind.");
    }
  },
  watch: function watch() {
    var params = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    var autoReplaceSvgRoot = params.autoReplaceSvgRoot;
    if (config$1.autoReplaceSvg === false) {
      config$1.autoReplaceSvg = true;
    }
    config$1.observeMutations = true;
    domready(function() {
      autoReplace({
        autoReplaceSvgRoot
      });
      callHooks("watch", params);
    });
  }
};
var parse = {
  icon: function icon(_icon) {
    if (_icon === null) {
      return null;
    }
    if (_typeof$1(_icon) === "object" && _icon.prefix && _icon.iconName) {
      return {
        prefix: _icon.prefix,
        iconName: byAlias(_icon.prefix, _icon.iconName) || _icon.iconName
      };
    }
    if (Array.isArray(_icon) && _icon.length === 2) {
      var iconName = _icon[1].indexOf("fa-") === 0 ? _icon[1].slice(3) : _icon[1];
      var prefix = getCanonicalPrefix(_icon[0]);
      return {
        prefix,
        iconName: byAlias(prefix, iconName) || iconName
      };
    }
    if (typeof _icon === "string" && (_icon.indexOf("".concat(config$1.cssPrefix, "-")) > -1 || _icon.match(ICON_SELECTION_SYNTAX_PATTERN))) {
      var canonicalIcon = getCanonicalIcon(_icon.split(" "), {
        skipLookups: true
      });
      return {
        prefix: canonicalIcon.prefix || getDefaultUsablePrefix(),
        iconName: byAlias(canonicalIcon.prefix, canonicalIcon.iconName) || canonicalIcon.iconName
      };
    }
    if (typeof _icon === "string") {
      var _prefix = getDefaultUsablePrefix();
      return {
        prefix: _prefix,
        iconName: byAlias(_prefix, _icon) || _icon
      };
    }
  }
};
var api = {
  noAuto,
  config: config$1,
  dom,
  parse,
  library,
  findIconDefinition,
  toHtml
};
var autoReplace = function autoReplace2() {
  var params = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
  var _params$autoReplaceSv = params.autoReplaceSvgRoot, autoReplaceSvgRoot = _params$autoReplaceSv === void 0 ? DOCUMENT : _params$autoReplaceSv;
  if ((Object.keys(namespace.styles).length > 0 || config$1.autoFetchSvg) && IS_DOM && config$1.autoReplaceSvg)
    api.dom.i2svg({
      node: autoReplaceSvgRoot
    });
};
function domVariants(val, abstractCreator) {
  Object.defineProperty(val, "abstract", {
    get: abstractCreator
  });
  Object.defineProperty(val, "html", {
    get: function get3() {
      return val.abstract.map(function(a) {
        return toHtml(a);
      });
    }
  });
  Object.defineProperty(val, "node", {
    get: function get3() {
      if (!IS_DOM)
        return;
      var container = DOCUMENT.createElement("div");
      container.innerHTML = val.html;
      return container.children;
    }
  });
  return val;
}
function asIcon(_ref2) {
  var children = _ref2.children, main = _ref2.main, mask = _ref2.mask, attributes = _ref2.attributes, styles2 = _ref2.styles, transform = _ref2.transform;
  if (transformIsMeaningful(transform) && main.found && !mask.found) {
    var width = main.width, height = main.height;
    var offset2 = {
      x: width / height / 2,
      y: 0.5
    };
    attributes["style"] = joinStyles(_objectSpread2$1(_objectSpread2$1({}, styles2), {}, {
      "transform-origin": "".concat(offset2.x + transform.x / 16, "em ").concat(offset2.y + transform.y / 16, "em")
    }));
  }
  return [{
    tag: "svg",
    attributes,
    children
  }];
}
function asSymbol(_ref2) {
  var prefix = _ref2.prefix, iconName = _ref2.iconName, children = _ref2.children, attributes = _ref2.attributes, symbol = _ref2.symbol;
  var id = symbol === true ? "".concat(prefix, "-").concat(config$1.cssPrefix, "-").concat(iconName) : symbol;
  return [{
    tag: "svg",
    attributes: {
      style: "display: none;"
    },
    children: [{
      tag: "symbol",
      attributes: _objectSpread2$1(_objectSpread2$1({}, attributes), {}, {
        id
      }),
      children
    }]
  }];
}
function makeInlineSvgAbstract(params) {
  var _params$icons = params.icons, main = _params$icons.main, mask = _params$icons.mask, prefix = params.prefix, iconName = params.iconName, transform = params.transform, symbol = params.symbol, title = params.title, maskId = params.maskId, titleId = params.titleId, extra = params.extra, _params$watchable = params.watchable, watchable = _params$watchable === void 0 ? false : _params$watchable;
  var _ref2 = mask.found ? mask : main, width = _ref2.width, height = _ref2.height;
  var isUploadedIcon = prefix === "fak";
  var attrClass = [config$1.replacementClass, iconName ? "".concat(config$1.cssPrefix, "-").concat(iconName) : ""].filter(function(c2) {
    return extra.classes.indexOf(c2) === -1;
  }).filter(function(c2) {
    return c2 !== "" || !!c2;
  }).concat(extra.classes).join(" ");
  var content = {
    children: [],
    attributes: _objectSpread2$1(_objectSpread2$1({}, extra.attributes), {}, {
      "data-prefix": prefix,
      "data-icon": iconName,
      "class": attrClass,
      "role": extra.attributes.role || "img",
      "xmlns": "http://www.w3.org/2000/svg",
      "viewBox": "0 0 ".concat(width, " ").concat(height)
    })
  };
  var uploadedIconWidthStyle = isUploadedIcon && !~extra.classes.indexOf("fa-fw") ? {
    width: "".concat(width / height * 16 * 0.0625, "em")
  } : {};
  if (watchable) {
    content.attributes[DATA_FA_I2SVG] = "";
  }
  if (title) {
    content.children.push({
      tag: "title",
      attributes: {
        id: content.attributes["aria-labelledby"] || "title-".concat(titleId || nextUniqueId())
      },
      children: [title]
    });
    delete content.attributes.title;
  }
  var args = _objectSpread2$1(_objectSpread2$1({}, content), {}, {
    prefix,
    iconName,
    main,
    mask,
    maskId,
    transform,
    symbol,
    styles: _objectSpread2$1(_objectSpread2$1({}, uploadedIconWidthStyle), extra.styles)
  });
  var _ref22 = mask.found && main.found ? callProvided("generateAbstractMask", args) || {
    children: [],
    attributes: {}
  } : callProvided("generateAbstractIcon", args) || {
    children: [],
    attributes: {}
  }, children = _ref22.children, attributes = _ref22.attributes;
  args.children = children;
  args.attributes = attributes;
  if (symbol) {
    return asSymbol(args);
  } else {
    return asIcon(args);
  }
}
function makeLayersTextAbstract(params) {
  var content = params.content, width = params.width, height = params.height, transform = params.transform, title = params.title, extra = params.extra, _params$watchable2 = params.watchable, watchable = _params$watchable2 === void 0 ? false : _params$watchable2;
  var attributes = _objectSpread2$1(_objectSpread2$1(_objectSpread2$1({}, extra.attributes), title ? {
    "title": title
  } : {}), {}, {
    "class": extra.classes.join(" ")
  });
  if (watchable) {
    attributes[DATA_FA_I2SVG] = "";
  }
  var styles2 = _objectSpread2$1({}, extra.styles);
  if (transformIsMeaningful(transform)) {
    styles2["transform"] = transformForCss({
      transform,
      startCentered: true,
      width,
      height
    });
    styles2["-webkit-transform"] = styles2["transform"];
  }
  var styleString = joinStyles(styles2);
  if (styleString.length > 0) {
    attributes["style"] = styleString;
  }
  var val = [];
  val.push({
    tag: "span",
    attributes,
    children: [content]
  });
  if (title) {
    val.push({
      tag: "span",
      attributes: {
        class: "sr-only"
      },
      children: [title]
    });
  }
  return val;
}
function makeLayersCounterAbstract(params) {
  var content = params.content, title = params.title, extra = params.extra;
  var attributes = _objectSpread2$1(_objectSpread2$1(_objectSpread2$1({}, extra.attributes), title ? {
    "title": title
  } : {}), {}, {
    "class": extra.classes.join(" ")
  });
  var styleString = joinStyles(extra.styles);
  if (styleString.length > 0) {
    attributes["style"] = styleString;
  }
  var val = [];
  val.push({
    tag: "span",
    attributes,
    children: [content]
  });
  if (title) {
    val.push({
      tag: "span",
      attributes: {
        class: "sr-only"
      },
      children: [title]
    });
  }
  return val;
}
var styles$1 = namespace.styles;
function asFoundIcon(icon3) {
  var width = icon3[0];
  var height = icon3[1];
  var _icon$slice = icon3.slice(4), _icon$slice2 = _slicedToArray(_icon$slice, 1), vectorData = _icon$slice2[0];
  var element = null;
  if (Array.isArray(vectorData)) {
    element = {
      tag: "g",
      attributes: {
        class: "".concat(config$1.cssPrefix, "-").concat(DUOTONE_CLASSES.GROUP)
      },
      children: [{
        tag: "path",
        attributes: {
          class: "".concat(config$1.cssPrefix, "-").concat(DUOTONE_CLASSES.SECONDARY),
          fill: "currentColor",
          d: vectorData[0]
        }
      }, {
        tag: "path",
        attributes: {
          class: "".concat(config$1.cssPrefix, "-").concat(DUOTONE_CLASSES.PRIMARY),
          fill: "currentColor",
          d: vectorData[1]
        }
      }]
    };
  } else {
    element = {
      tag: "path",
      attributes: {
        fill: "currentColor",
        d: vectorData
      }
    };
  }
  return {
    found: true,
    width,
    height,
    icon: element
  };
}
var missingIconResolutionMixin = {
  found: false,
  width: 512,
  height: 512
};
function maybeNotifyMissing(iconName, prefix) {
  if (!PRODUCTION$1 && !config$1.showMissingIcons && iconName) {
    console.error('Icon with name "'.concat(iconName, '" and prefix "').concat(prefix, '" is missing.'));
  }
}
function findIcon(iconName, prefix) {
  var givenPrefix = prefix;
  if (prefix === "fa" && config$1.styleDefault !== null) {
    prefix = getDefaultUsablePrefix();
  }
  return new Promise(function(resolve, reject) {
    ({
      found: false,
      width: 512,
      height: 512,
      icon: callProvided("missingIconAbstract") || {}
    });
    if (givenPrefix === "fa") {
      var shim2 = byOldName(iconName) || {};
      iconName = shim2.iconName || iconName;
      prefix = shim2.prefix || prefix;
    }
    if (iconName && prefix && styles$1[prefix] && styles$1[prefix][iconName]) {
      var icon3 = styles$1[prefix][iconName];
      return resolve(asFoundIcon(icon3));
    }
    maybeNotifyMissing(iconName, prefix);
    resolve(_objectSpread2$1(_objectSpread2$1({}, missingIconResolutionMixin), {}, {
      icon: config$1.showMissingIcons && iconName ? callProvided("missingIconAbstract") || {} : {}
    }));
  });
}
var noop$1$1 = function noop2() {
};
var p$2 = config$1.measurePerformance && PERFORMANCE && PERFORMANCE.mark && PERFORMANCE.measure ? PERFORMANCE : {
  mark: noop$1$1,
  measure: noop$1$1
};
var preamble = 'FA "6.5.0"';
var begin = function begin2(name2) {
  p$2.mark("".concat(preamble, " ").concat(name2, " begins"));
  return function() {
    return end(name2);
  };
};
var end = function end2(name2) {
  p$2.mark("".concat(preamble, " ").concat(name2, " ends"));
  p$2.measure("".concat(preamble, " ").concat(name2), "".concat(preamble, " ").concat(name2, " begins"), "".concat(preamble, " ").concat(name2, " ends"));
};
var perf = {
  begin,
  end
};
var noop$2$1 = function noop3() {
};
function isWatched(node) {
  var i2svg2 = node.getAttribute ? node.getAttribute(DATA_FA_I2SVG) : null;
  return typeof i2svg2 === "string";
}
function hasPrefixAndIcon(node) {
  var prefix = node.getAttribute ? node.getAttribute(DATA_PREFIX) : null;
  var icon3 = node.getAttribute ? node.getAttribute(DATA_ICON) : null;
  return prefix && icon3;
}
function hasBeenReplaced(node) {
  return node && node.classList && node.classList.contains && node.classList.contains(config$1.replacementClass);
}
function getMutator() {
  if (config$1.autoReplaceSvg === true) {
    return mutators.replace;
  }
  var mutator = mutators[config$1.autoReplaceSvg];
  return mutator || mutators.replace;
}
function createElementNS(tag) {
  return DOCUMENT.createElementNS("http://www.w3.org/2000/svg", tag);
}
function createElement(tag) {
  return DOCUMENT.createElement(tag);
}
function convertSVG(abstractObj) {
  var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
  var _params$ceFn = params.ceFn, ceFn = _params$ceFn === void 0 ? abstractObj.tag === "svg" ? createElementNS : createElement : _params$ceFn;
  if (typeof abstractObj === "string") {
    return DOCUMENT.createTextNode(abstractObj);
  }
  var tag = ceFn(abstractObj.tag);
  Object.keys(abstractObj.attributes || []).forEach(function(key) {
    tag.setAttribute(key, abstractObj.attributes[key]);
  });
  var children = abstractObj.children || [];
  children.forEach(function(child) {
    tag.appendChild(convertSVG(child, {
      ceFn
    }));
  });
  return tag;
}
function nodeAsComment(node) {
  var comment = " ".concat(node.outerHTML, " ");
  comment = "".concat(comment, "Font Awesome fontawesome.com ");
  return comment;
}
var mutators = {
  replace: function replace(mutation) {
    var node = mutation[0];
    if (node.parentNode) {
      mutation[1].forEach(function(_abstract) {
        node.parentNode.insertBefore(convertSVG(_abstract), node);
      });
      if (node.getAttribute(DATA_FA_I2SVG) === null && config$1.keepOriginalSource) {
        var comment = DOCUMENT.createComment(nodeAsComment(node));
        node.parentNode.replaceChild(comment, node);
      } else {
        node.remove();
      }
    }
  },
  nest: function nest(mutation) {
    var node = mutation[0];
    var _abstract2 = mutation[1];
    if (~classArray(node).indexOf(config$1.replacementClass)) {
      return mutators.replace(mutation);
    }
    var forSvg = new RegExp("".concat(config$1.cssPrefix, "-.*"));
    delete _abstract2[0].attributes.id;
    if (_abstract2[0].attributes.class) {
      var splitClasses = _abstract2[0].attributes.class.split(" ").reduce(function(acc, cls) {
        if (cls === config$1.replacementClass || cls.match(forSvg)) {
          acc.toSvg.push(cls);
        } else {
          acc.toNode.push(cls);
        }
        return acc;
      }, {
        toNode: [],
        toSvg: []
      });
      _abstract2[0].attributes.class = splitClasses.toSvg.join(" ");
      if (splitClasses.toNode.length === 0) {
        node.removeAttribute("class");
      } else {
        node.setAttribute("class", splitClasses.toNode.join(" "));
      }
    }
    var newInnerHTML = _abstract2.map(function(a) {
      return toHtml(a);
    }).join("\n");
    node.setAttribute(DATA_FA_I2SVG, "");
    node.innerHTML = newInnerHTML;
  }
};
function performOperationSync(op) {
  op();
}
function perform(mutations, callback) {
  var callbackFunction = typeof callback === "function" ? callback : noop$2$1;
  if (mutations.length === 0) {
    callbackFunction();
  } else {
    var frame = performOperationSync;
    if (config$1.mutateApproach === MUTATION_APPROACH_ASYNC) {
      frame = WINDOW.requestAnimationFrame || performOperationSync;
    }
    frame(function() {
      var mutator = getMutator();
      var mark = perf.begin("mutate");
      mutations.map(mutator);
      mark();
      callbackFunction();
    });
  }
}
var disabled = false;
function disableObservation() {
  disabled = true;
}
function enableObservation() {
  disabled = false;
}
var mo = null;
function observe(options) {
  if (!MUTATION_OBSERVER) {
    return;
  }
  if (!config$1.observeMutations) {
    return;
  }
  var _options$treeCallback = options.treeCallback, treeCallback = _options$treeCallback === void 0 ? noop$2$1 : _options$treeCallback, _options$nodeCallback = options.nodeCallback, nodeCallback = _options$nodeCallback === void 0 ? noop$2$1 : _options$nodeCallback, _options$pseudoElemen = options.pseudoElementsCallback, pseudoElementsCallback = _options$pseudoElemen === void 0 ? noop$2$1 : _options$pseudoElemen, _options$observeMutat = options.observeMutationsRoot, observeMutationsRoot = _options$observeMutat === void 0 ? DOCUMENT : _options$observeMutat;
  mo = new MUTATION_OBSERVER(function(objects) {
    if (disabled)
      return;
    var defaultPrefix = getDefaultUsablePrefix();
    toArray(objects).forEach(function(mutationRecord) {
      if (mutationRecord.type === "childList" && mutationRecord.addedNodes.length > 0 && !isWatched(mutationRecord.addedNodes[0])) {
        if (config$1.searchPseudoElements) {
          pseudoElementsCallback(mutationRecord.target);
        }
        treeCallback(mutationRecord.target);
      }
      if (mutationRecord.type === "attributes" && mutationRecord.target.parentNode && config$1.searchPseudoElements) {
        pseudoElementsCallback(mutationRecord.target.parentNode);
      }
      if (mutationRecord.type === "attributes" && isWatched(mutationRecord.target) && ~ATTRIBUTES_WATCHED_FOR_MUTATION.indexOf(mutationRecord.attributeName)) {
        if (mutationRecord.attributeName === "class" && hasPrefixAndIcon(mutationRecord.target)) {
          var _getCanonicalIcon = getCanonicalIcon(classArray(mutationRecord.target)), prefix = _getCanonicalIcon.prefix, iconName = _getCanonicalIcon.iconName;
          mutationRecord.target.setAttribute(DATA_PREFIX, prefix || defaultPrefix);
          if (iconName)
            mutationRecord.target.setAttribute(DATA_ICON, iconName);
        } else if (hasBeenReplaced(mutationRecord.target)) {
          nodeCallback(mutationRecord.target);
        }
      }
    });
  });
  if (!IS_DOM)
    return;
  mo.observe(observeMutationsRoot, {
    childList: true,
    attributes: true,
    characterData: true,
    subtree: true
  });
}
function disconnect() {
  if (!mo)
    return;
  mo.disconnect();
}
function styleParser(node) {
  var style = node.getAttribute("style");
  var val = [];
  if (style) {
    val = style.split(";").reduce(function(acc, style2) {
      var styles2 = style2.split(":");
      var prop = styles2[0];
      var value = styles2.slice(1);
      if (prop && value.length > 0) {
        acc[prop] = value.join(":").trim();
      }
      return acc;
    }, {});
  }
  return val;
}
function classParser(node) {
  var existingPrefix = node.getAttribute("data-prefix");
  var existingIconName = node.getAttribute("data-icon");
  var innerText = node.innerText !== void 0 ? node.innerText.trim() : "";
  var val = getCanonicalIcon(classArray(node));
  if (!val.prefix) {
    val.prefix = getDefaultUsablePrefix();
  }
  if (existingPrefix && existingIconName) {
    val.prefix = existingPrefix;
    val.iconName = existingIconName;
  }
  if (val.iconName && val.prefix) {
    return val;
  }
  if (val.prefix && innerText.length > 0) {
    val.iconName = byLigature(val.prefix, node.innerText) || byUnicode(val.prefix, toHex(node.innerText));
  }
  if (!val.iconName && config$1.autoFetchSvg && node.firstChild && node.firstChild.nodeType === Node.TEXT_NODE) {
    val.iconName = node.firstChild.data;
  }
  return val;
}
function attributesParser(node) {
  var extraAttributes = toArray(node.attributes).reduce(function(acc, attr) {
    if (acc.name !== "class" && acc.name !== "style") {
      acc[attr.name] = attr.value;
    }
    return acc;
  }, {});
  var title = node.getAttribute("title");
  var titleId = node.getAttribute("data-fa-title-id");
  if (config$1.autoA11y) {
    if (title) {
      extraAttributes["aria-labelledby"] = "".concat(config$1.replacementClass, "-title-").concat(titleId || nextUniqueId());
    } else {
      extraAttributes["aria-hidden"] = "true";
      extraAttributes["focusable"] = "false";
    }
  }
  return extraAttributes;
}
function blankMeta() {
  return {
    iconName: null,
    title: null,
    titleId: null,
    prefix: null,
    transform: meaninglessTransform,
    symbol: false,
    mask: {
      iconName: null,
      prefix: null,
      rest: []
    },
    maskId: null,
    extra: {
      classes: [],
      styles: {},
      attributes: {}
    }
  };
}
function parseMeta(node) {
  var parser = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {
    styleParser: true
  };
  var _classParser = classParser(node), iconName = _classParser.iconName, prefix = _classParser.prefix, extraClasses = _classParser.rest;
  var extraAttributes = attributesParser(node);
  var pluginMeta = chainHooks("parseNodeAttributes", {}, node);
  var extraStyles = parser.styleParser ? styleParser(node) : [];
  return _objectSpread2$1({
    iconName,
    title: node.getAttribute("title"),
    titleId: node.getAttribute("data-fa-title-id"),
    prefix,
    transform: meaninglessTransform,
    mask: {
      iconName: null,
      prefix: null,
      rest: []
    },
    maskId: null,
    symbol: false,
    extra: {
      classes: extraClasses,
      styles: extraStyles,
      attributes: extraAttributes
    }
  }, pluginMeta);
}
var styles$2 = namespace.styles;
function generateMutation(node) {
  var nodeMeta = config$1.autoReplaceSvg === "nest" ? parseMeta(node, {
    styleParser: false
  }) : parseMeta(node);
  if (~nodeMeta.extra.classes.indexOf(LAYERS_TEXT_CLASSNAME)) {
    return callProvided("generateLayersText", node, nodeMeta);
  } else {
    return callProvided("generateSvgReplacementMutation", node, nodeMeta);
  }
}
var knownPrefixes = /* @__PURE__ */ new Set();
FAMILIES.map(function(family) {
  knownPrefixes.add("fa-".concat(family));
});
Object.keys(PREFIX_TO_STYLE[FAMILY_CLASSIC]).map(knownPrefixes.add.bind(knownPrefixes));
Object.keys(PREFIX_TO_STYLE[FAMILY_SHARP]).map(knownPrefixes.add.bind(knownPrefixes));
knownPrefixes = _toConsumableArray$1(knownPrefixes);
function onTree(root2) {
  var callback = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : null;
  if (!IS_DOM)
    return Promise.resolve();
  var htmlClassList = DOCUMENT.documentElement.classList;
  var hclAdd = function hclAdd2(suffix) {
    return htmlClassList.add("".concat(HTML_CLASS_I2SVG_BASE_CLASS, "-").concat(suffix));
  };
  var hclRemove = function hclRemove2(suffix) {
    return htmlClassList.remove("".concat(HTML_CLASS_I2SVG_BASE_CLASS, "-").concat(suffix));
  };
  var prefixes2 = config$1.autoFetchSvg ? knownPrefixes : FAMILIES.map(function(f2) {
    return "fa-".concat(f2);
  }).concat(Object.keys(styles$2));
  if (!prefixes2.includes("fa")) {
    prefixes2.push("fa");
  }
  var prefixesDomQuery = [".".concat(LAYERS_TEXT_CLASSNAME, ":not([").concat(DATA_FA_I2SVG, "])")].concat(prefixes2.map(function(p2) {
    return ".".concat(p2, ":not([").concat(DATA_FA_I2SVG, "])");
  })).join(", ");
  if (prefixesDomQuery.length === 0) {
    return Promise.resolve();
  }
  var candidates = [];
  try {
    candidates = toArray(root2.querySelectorAll(prefixesDomQuery));
  } catch (e2) {
  }
  if (candidates.length > 0) {
    hclAdd("pending");
    hclRemove("complete");
  } else {
    return Promise.resolve();
  }
  var mark = perf.begin("onTree");
  var mutations = candidates.reduce(function(acc, node) {
    try {
      var mutation = generateMutation(node);
      if (mutation) {
        acc.push(mutation);
      }
    } catch (e2) {
      if (!PRODUCTION$1) {
        if (e2.name === "MissingIcon") {
          console.error(e2);
        }
      }
    }
    return acc;
  }, []);
  return new Promise(function(resolve, reject) {
    Promise.all(mutations).then(function(resolvedMutations) {
      perform(resolvedMutations, function() {
        hclAdd("active");
        hclAdd("complete");
        hclRemove("pending");
        if (typeof callback === "function")
          callback();
        mark();
        resolve();
      });
    }).catch(function(e2) {
      mark();
      reject(e2);
    });
  });
}
function onNode(node) {
  var callback = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : null;
  generateMutation(node).then(function(mutation) {
    if (mutation) {
      perform([mutation], callback);
    }
  });
}
function resolveIcons(next) {
  return function(maybeIconDefinition) {
    var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var iconDefinition = (maybeIconDefinition || {}).icon ? maybeIconDefinition : findIconDefinition(maybeIconDefinition || {});
    var mask = params.mask;
    if (mask) {
      mask = (mask || {}).icon ? mask : findIconDefinition(mask || {});
    }
    return next(iconDefinition, _objectSpread2$1(_objectSpread2$1({}, params), {}, {
      mask
    }));
  };
}
var render = function render2(iconDefinition) {
  var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
  var _params$transform = params.transform, transform = _params$transform === void 0 ? meaninglessTransform : _params$transform, _params$symbol = params.symbol, symbol = _params$symbol === void 0 ? false : _params$symbol, _params$mask = params.mask, mask = _params$mask === void 0 ? null : _params$mask, _params$maskId = params.maskId, maskId = _params$maskId === void 0 ? null : _params$maskId, _params$title = params.title, title = _params$title === void 0 ? null : _params$title, _params$titleId = params.titleId, titleId = _params$titleId === void 0 ? null : _params$titleId, _params$classes = params.classes, classes = _params$classes === void 0 ? [] : _params$classes, _params$attributes = params.attributes, attributes = _params$attributes === void 0 ? {} : _params$attributes, _params$styles = params.styles, styles2 = _params$styles === void 0 ? {} : _params$styles;
  if (!iconDefinition)
    return;
  var prefix = iconDefinition.prefix, iconName = iconDefinition.iconName, icon3 = iconDefinition.icon;
  return domVariants(_objectSpread2$1({
    type: "icon"
  }, iconDefinition), function() {
    callHooks("beforeDOMElementCreation", {
      iconDefinition,
      params
    });
    if (config$1.autoA11y) {
      if (title) {
        attributes["aria-labelledby"] = "".concat(config$1.replacementClass, "-title-").concat(titleId || nextUniqueId());
      } else {
        attributes["aria-hidden"] = "true";
        attributes["focusable"] = "false";
      }
    }
    return makeInlineSvgAbstract({
      icons: {
        main: asFoundIcon(icon3),
        mask: mask ? asFoundIcon(mask.icon) : {
          found: false,
          width: null,
          height: null,
          icon: {}
        }
      },
      prefix,
      iconName,
      transform: _objectSpread2$1(_objectSpread2$1({}, meaninglessTransform), transform),
      symbol,
      title,
      maskId,
      titleId,
      extra: {
        attributes,
        styles: styles2,
        classes
      }
    });
  });
};
var ReplaceElements = {
  mixout: function mixout2() {
    return {
      icon: resolveIcons(render)
    };
  },
  hooks: function hooks2() {
    return {
      mutationObserverCallbacks: function mutationObserverCallbacks(accumulator) {
        accumulator.treeCallback = onTree;
        accumulator.nodeCallback = onNode;
        return accumulator;
      }
    };
  },
  provides: function provides(providers$$1) {
    providers$$1.i2svg = function(params) {
      var _params$node = params.node, node = _params$node === void 0 ? DOCUMENT : _params$node, _params$callback = params.callback, callback = _params$callback === void 0 ? function() {
      } : _params$callback;
      return onTree(node, callback);
    };
    providers$$1.generateSvgReplacementMutation = function(node, nodeMeta) {
      var iconName = nodeMeta.iconName, title = nodeMeta.title, titleId = nodeMeta.titleId, prefix = nodeMeta.prefix, transform = nodeMeta.transform, symbol = nodeMeta.symbol, mask = nodeMeta.mask, maskId = nodeMeta.maskId, extra = nodeMeta.extra;
      return new Promise(function(resolve, reject) {
        Promise.all([findIcon(iconName, prefix), mask.iconName ? findIcon(mask.iconName, mask.prefix) : Promise.resolve({
          found: false,
          width: 512,
          height: 512,
          icon: {}
        })]).then(function(_ref2) {
          var _ref22 = _slicedToArray(_ref2, 2), main = _ref22[0], mask2 = _ref22[1];
          resolve([node, makeInlineSvgAbstract({
            icons: {
              main,
              mask: mask2
            },
            prefix,
            iconName,
            transform,
            symbol,
            maskId,
            title,
            titleId,
            extra,
            watchable: true
          })]);
        }).catch(reject);
      });
    };
    providers$$1.generateAbstractIcon = function(_ref3) {
      var children = _ref3.children, attributes = _ref3.attributes, main = _ref3.main, transform = _ref3.transform, styles2 = _ref3.styles;
      var styleString = joinStyles(styles2);
      if (styleString.length > 0) {
        attributes["style"] = styleString;
      }
      var nextChild;
      if (transformIsMeaningful(transform)) {
        nextChild = callProvided("generateAbstractTransformGrouping", {
          main,
          transform,
          containerWidth: main.width,
          iconWidth: main.width
        });
      }
      children.push(nextChild || main.icon);
      return {
        children,
        attributes
      };
    };
  }
};
var Layers = {
  mixout: function mixout3() {
    return {
      layer: function layer(assembler) {
        var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
        var _params$classes = params.classes, classes = _params$classes === void 0 ? [] : _params$classes;
        return domVariants({
          type: "layer"
        }, function() {
          callHooks("beforeDOMElementCreation", {
            assembler,
            params
          });
          var children = [];
          assembler(function(args) {
            Array.isArray(args) ? args.map(function(a) {
              children = children.concat(a.abstract);
            }) : children = children.concat(args.abstract);
          });
          return [{
            tag: "span",
            attributes: {
              class: ["".concat(config$1.cssPrefix, "-layers")].concat(_toConsumableArray$1(classes)).join(" ")
            },
            children
          }];
        });
      }
    };
  }
};
var LayersCounter = {
  mixout: function mixout4() {
    return {
      counter: function counter2(content) {
        var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
        var _params$title = params.title, title = _params$title === void 0 ? null : _params$title, _params$classes = params.classes, classes = _params$classes === void 0 ? [] : _params$classes, _params$attributes = params.attributes, attributes = _params$attributes === void 0 ? {} : _params$attributes, _params$styles = params.styles, styles2 = _params$styles === void 0 ? {} : _params$styles;
        return domVariants({
          type: "counter",
          content
        }, function() {
          callHooks("beforeDOMElementCreation", {
            content,
            params
          });
          return makeLayersCounterAbstract({
            content: content.toString(),
            title,
            extra: {
              attributes,
              styles: styles2,
              classes: ["".concat(config$1.cssPrefix, "-layers-counter")].concat(_toConsumableArray$1(classes))
            }
          });
        });
      }
    };
  }
};
var LayersText = {
  mixout: function mixout5() {
    return {
      text: function text(content) {
        var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
        var _params$transform = params.transform, transform = _params$transform === void 0 ? meaninglessTransform : _params$transform, _params$title = params.title, title = _params$title === void 0 ? null : _params$title, _params$classes = params.classes, classes = _params$classes === void 0 ? [] : _params$classes, _params$attributes = params.attributes, attributes = _params$attributes === void 0 ? {} : _params$attributes, _params$styles = params.styles, styles2 = _params$styles === void 0 ? {} : _params$styles;
        return domVariants({
          type: "text",
          content
        }, function() {
          callHooks("beforeDOMElementCreation", {
            content,
            params
          });
          return makeLayersTextAbstract({
            content,
            transform: _objectSpread2$1(_objectSpread2$1({}, meaninglessTransform), transform),
            title,
            extra: {
              attributes,
              styles: styles2,
              classes: ["".concat(config$1.cssPrefix, "-layers-text")].concat(_toConsumableArray$1(classes))
            }
          });
        });
      }
    };
  },
  provides: function provides2(providers$$1) {
    providers$$1.generateLayersText = function(node, nodeMeta) {
      var title = nodeMeta.title, transform = nodeMeta.transform, extra = nodeMeta.extra;
      var width = null;
      var height = null;
      if (IS_IE) {
        var computedFontSize = parseInt(getComputedStyle(node).fontSize, 10);
        var boundingClientRect = node.getBoundingClientRect();
        width = boundingClientRect.width / computedFontSize;
        height = boundingClientRect.height / computedFontSize;
      }
      if (config$1.autoA11y && !title) {
        extra.attributes["aria-hidden"] = "true";
      }
      return Promise.resolve([node, makeLayersTextAbstract({
        content: node.innerHTML,
        width,
        height,
        transform,
        title,
        extra,
        watchable: true
      })]);
    };
  }
};
var CLEAN_CONTENT_PATTERN = new RegExp('"', "ug");
var SECONDARY_UNICODE_RANGE = [1105920, 1112319];
function hexValueFromContent(content) {
  var cleaned = content.replace(CLEAN_CONTENT_PATTERN, "");
  var codePoint = codePointAt(cleaned, 0);
  var isPrependTen = codePoint >= SECONDARY_UNICODE_RANGE[0] && codePoint <= SECONDARY_UNICODE_RANGE[1];
  var isDoubled = cleaned.length === 2 ? cleaned[0] === cleaned[1] : false;
  return {
    value: isDoubled ? toHex(cleaned[0]) : toHex(cleaned),
    isSecondary: isPrependTen || isDoubled
  };
}
function replaceForPosition(node, position) {
  var pendingAttribute = "".concat(DATA_FA_PSEUDO_ELEMENT_PENDING).concat(position.replace(":", "-"));
  return new Promise(function(resolve, reject) {
    if (node.getAttribute(pendingAttribute) !== null) {
      return resolve();
    }
    var children = toArray(node.children);
    var alreadyProcessedPseudoElement = children.filter(function(c2) {
      return c2.getAttribute(DATA_FA_PSEUDO_ELEMENT) === position;
    })[0];
    var styles2 = WINDOW.getComputedStyle(node, position);
    var fontFamily = styles2.getPropertyValue("font-family").match(FONT_FAMILY_PATTERN);
    var fontWeight = styles2.getPropertyValue("font-weight");
    var content = styles2.getPropertyValue("content");
    if (alreadyProcessedPseudoElement && !fontFamily) {
      node.removeChild(alreadyProcessedPseudoElement);
      return resolve();
    } else if (fontFamily && content !== "none" && content !== "") {
      var _content = styles2.getPropertyValue("content");
      var family = ~["Sharp"].indexOf(fontFamily[2]) ? FAMILY_SHARP : FAMILY_CLASSIC;
      var prefix = ~["Solid", "Regular", "Light", "Thin", "Duotone", "Brands", "Kit"].indexOf(fontFamily[2]) ? STYLE_TO_PREFIX[family][fontFamily[2].toLowerCase()] : FONT_WEIGHT_TO_PREFIX[family][fontWeight];
      var _hexValueFromContent = hexValueFromContent(_content), hexValue = _hexValueFromContent.value, isSecondary = _hexValueFromContent.isSecondary;
      var isV4 = fontFamily[0].startsWith("FontAwesome");
      var iconName = byUnicode(prefix, hexValue);
      var iconIdentifier = iconName;
      if (isV4) {
        var iconName4 = byOldUnicode(hexValue);
        if (iconName4.iconName && iconName4.prefix) {
          iconName = iconName4.iconName;
          prefix = iconName4.prefix;
        }
      }
      if (iconName && !isSecondary && (!alreadyProcessedPseudoElement || alreadyProcessedPseudoElement.getAttribute(DATA_PREFIX) !== prefix || alreadyProcessedPseudoElement.getAttribute(DATA_ICON) !== iconIdentifier)) {
        node.setAttribute(pendingAttribute, iconIdentifier);
        if (alreadyProcessedPseudoElement) {
          node.removeChild(alreadyProcessedPseudoElement);
        }
        var meta = blankMeta();
        var extra = meta.extra;
        extra.attributes[DATA_FA_PSEUDO_ELEMENT] = position;
        findIcon(iconName, prefix).then(function(main) {
          var _abstract = makeInlineSvgAbstract(_objectSpread2$1(_objectSpread2$1({}, meta), {}, {
            icons: {
              main,
              mask: emptyCanonicalIcon()
            },
            prefix,
            iconName: iconIdentifier,
            extra,
            watchable: true
          }));
          var element = DOCUMENT.createElementNS("http://www.w3.org/2000/svg", "svg");
          if (position === "::before") {
            node.insertBefore(element, node.firstChild);
          } else {
            node.appendChild(element);
          }
          element.outerHTML = _abstract.map(function(a) {
            return toHtml(a);
          }).join("\n");
          node.removeAttribute(pendingAttribute);
          resolve();
        }).catch(reject);
      } else {
        resolve();
      }
    } else {
      resolve();
    }
  });
}
function replace2(node) {
  return Promise.all([replaceForPosition(node, "::before"), replaceForPosition(node, "::after")]);
}
function processable(node) {
  return node.parentNode !== document.head && !~TAGNAMES_TO_SKIP_FOR_PSEUDOELEMENTS.indexOf(node.tagName.toUpperCase()) && !node.getAttribute(DATA_FA_PSEUDO_ELEMENT) && (!node.parentNode || node.parentNode.tagName !== "svg");
}
function searchPseudoElements(root2) {
  if (!IS_DOM)
    return;
  return new Promise(function(resolve, reject) {
    var operations = toArray(root2.querySelectorAll("*")).filter(processable).map(replace2);
    var end3 = perf.begin("searchPseudoElements");
    disableObservation();
    Promise.all(operations).then(function() {
      end3();
      enableObservation();
      resolve();
    }).catch(function() {
      end3();
      enableObservation();
      reject();
    });
  });
}
var PseudoElements = {
  hooks: function hooks3() {
    return {
      mutationObserverCallbacks: function mutationObserverCallbacks(accumulator) {
        accumulator.pseudoElementsCallback = searchPseudoElements;
        return accumulator;
      }
    };
  },
  provides: function provides3(providers$$1) {
    providers$$1.pseudoElements2svg = function(params) {
      var _params$node = params.node, node = _params$node === void 0 ? DOCUMENT : _params$node;
      if (config$1.searchPseudoElements) {
        searchPseudoElements(node);
      }
    };
  }
};
var _unwatched = false;
var MutationObserver$1 = {
  mixout: function mixout6() {
    return {
      dom: {
        unwatch: function unwatch() {
          disableObservation();
          _unwatched = true;
        }
      }
    };
  },
  hooks: function hooks4() {
    return {
      bootstrap: function bootstrap() {
        observe(chainHooks("mutationObserverCallbacks", {}));
      },
      noAuto: function noAuto3() {
        disconnect();
      },
      watch: function watch2(params) {
        var observeMutationsRoot = params.observeMutationsRoot;
        if (_unwatched) {
          enableObservation();
        } else {
          observe(chainHooks("mutationObserverCallbacks", {
            observeMutationsRoot
          }));
        }
      }
    };
  }
};
var parseTransformString = function parseTransformString2(transformString) {
  var transform = {
    size: 16,
    x: 0,
    y: 0,
    flipX: false,
    flipY: false,
    rotate: 0
  };
  return transformString.toLowerCase().split(" ").reduce(function(acc, n2) {
    var parts = n2.toLowerCase().split("-");
    var first = parts[0];
    var rest = parts.slice(1).join("-");
    if (first && rest === "h") {
      acc.flipX = true;
      return acc;
    }
    if (first && rest === "v") {
      acc.flipY = true;
      return acc;
    }
    rest = parseFloat(rest);
    if (isNaN(rest)) {
      return acc;
    }
    switch (first) {
      case "grow":
        acc.size = acc.size + rest;
        break;
      case "shrink":
        acc.size = acc.size - rest;
        break;
      case "left":
        acc.x = acc.x - rest;
        break;
      case "right":
        acc.x = acc.x + rest;
        break;
      case "up":
        acc.y = acc.y - rest;
        break;
      case "down":
        acc.y = acc.y + rest;
        break;
      case "rotate":
        acc.rotate = acc.rotate + rest;
        break;
    }
    return acc;
  }, transform);
};
var PowerTransforms = {
  mixout: function mixout7() {
    return {
      parse: {
        transform: function transform(transformString) {
          return parseTransformString(transformString);
        }
      }
    };
  },
  hooks: function hooks5() {
    return {
      parseNodeAttributes: function parseNodeAttributes(accumulator, node) {
        var transformString = node.getAttribute("data-fa-transform");
        if (transformString) {
          accumulator.transform = parseTransformString(transformString);
        }
        return accumulator;
      }
    };
  },
  provides: function provides4(providers2) {
    providers2.generateAbstractTransformGrouping = function(_ref2) {
      var main = _ref2.main, transform = _ref2.transform, containerWidth = _ref2.containerWidth, iconWidth = _ref2.iconWidth;
      var outer = {
        transform: "translate(".concat(containerWidth / 2, " 256)")
      };
      var innerTranslate = "translate(".concat(transform.x * 32, ", ").concat(transform.y * 32, ") ");
      var innerScale = "scale(".concat(transform.size / 16 * (transform.flipX ? -1 : 1), ", ").concat(transform.size / 16 * (transform.flipY ? -1 : 1), ") ");
      var innerRotate = "rotate(".concat(transform.rotate, " 0 0)");
      var inner2 = {
        transform: "".concat(innerTranslate, " ").concat(innerScale, " ").concat(innerRotate)
      };
      var path = {
        transform: "translate(".concat(iconWidth / 2 * -1, " -256)")
      };
      var operations = {
        outer,
        inner: inner2,
        path
      };
      return {
        tag: "g",
        attributes: _objectSpread2$1({}, operations.outer),
        children: [{
          tag: "g",
          attributes: _objectSpread2$1({}, operations.inner),
          children: [{
            tag: main.icon.tag,
            children: main.icon.children,
            attributes: _objectSpread2$1(_objectSpread2$1({}, main.icon.attributes), operations.path)
          }]
        }]
      };
    };
  }
};
var ALL_SPACE = {
  x: 0,
  y: 0,
  width: "100%",
  height: "100%"
};
function fillBlack(_abstract) {
  var force = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : true;
  if (_abstract.attributes && (_abstract.attributes.fill || force)) {
    _abstract.attributes.fill = "black";
  }
  return _abstract;
}
function deGroup(_abstract2) {
  if (_abstract2.tag === "g") {
    return _abstract2.children;
  } else {
    return [_abstract2];
  }
}
var Masks = {
  hooks: function hooks6() {
    return {
      parseNodeAttributes: function parseNodeAttributes(accumulator, node) {
        var maskData = node.getAttribute("data-fa-mask");
        var mask = !maskData ? emptyCanonicalIcon() : getCanonicalIcon(maskData.split(" ").map(function(i) {
          return i.trim();
        }));
        if (!mask.prefix) {
          mask.prefix = getDefaultUsablePrefix();
        }
        accumulator.mask = mask;
        accumulator.maskId = node.getAttribute("data-fa-mask-id");
        return accumulator;
      }
    };
  },
  provides: function provides5(providers2) {
    providers2.generateAbstractMask = function(_ref2) {
      var children = _ref2.children, attributes = _ref2.attributes, main = _ref2.main, mask = _ref2.mask, explicitMaskId = _ref2.maskId, transform = _ref2.transform;
      var mainWidth = main.width, mainPath = main.icon;
      var maskWidth = mask.width, maskPath = mask.icon;
      var trans = transformForSvg({
        transform,
        containerWidth: maskWidth,
        iconWidth: mainWidth
      });
      var maskRect = {
        tag: "rect",
        attributes: _objectSpread2$1(_objectSpread2$1({}, ALL_SPACE), {}, {
          fill: "white"
        })
      };
      var maskInnerGroupChildrenMixin = mainPath.children ? {
        children: mainPath.children.map(fillBlack)
      } : {};
      var maskInnerGroup = {
        tag: "g",
        attributes: _objectSpread2$1({}, trans.inner),
        children: [fillBlack(_objectSpread2$1({
          tag: mainPath.tag,
          attributes: _objectSpread2$1(_objectSpread2$1({}, mainPath.attributes), trans.path)
        }, maskInnerGroupChildrenMixin))]
      };
      var maskOuterGroup = {
        tag: "g",
        attributes: _objectSpread2$1({}, trans.outer),
        children: [maskInnerGroup]
      };
      var maskId = "mask-".concat(explicitMaskId || nextUniqueId());
      var clipId = "clip-".concat(explicitMaskId || nextUniqueId());
      var maskTag = {
        tag: "mask",
        attributes: _objectSpread2$1(_objectSpread2$1({}, ALL_SPACE), {}, {
          id: maskId,
          maskUnits: "userSpaceOnUse",
          maskContentUnits: "userSpaceOnUse"
        }),
        children: [maskRect, maskOuterGroup]
      };
      var defs = {
        tag: "defs",
        children: [{
          tag: "clipPath",
          attributes: {
            id: clipId
          },
          children: deGroup(maskPath)
        }, maskTag]
      };
      children.push(defs, {
        tag: "rect",
        attributes: _objectSpread2$1({
          fill: "currentColor",
          "clip-path": "url(#".concat(clipId, ")"),
          mask: "url(#".concat(maskId, ")")
        }, ALL_SPACE)
      });
      return {
        children,
        attributes
      };
    };
  }
};
var MissingIconIndicator = {
  provides: function provides6(providers2) {
    var reduceMotion = false;
    if (WINDOW.matchMedia) {
      reduceMotion = WINDOW.matchMedia("(prefers-reduced-motion: reduce)").matches;
    }
    providers2.missingIconAbstract = function() {
      var gChildren = [];
      var FILL = {
        fill: "currentColor"
      };
      var ANIMATION_BASE = {
        attributeType: "XML",
        repeatCount: "indefinite",
        dur: "2s"
      };
      gChildren.push({
        tag: "path",
        attributes: _objectSpread2$1(_objectSpread2$1({}, FILL), {}, {
          d: "M156.5,447.7l-12.6,29.5c-18.7-9.5-35.9-21.2-51.5-34.9l22.7-22.7C127.6,430.5,141.5,440,156.5,447.7z M40.6,272H8.5 c1.4,21.2,5.4,41.7,11.7,61.1L50,321.2C45.1,305.5,41.8,289,40.6,272z M40.6,240c1.4-18.8,5.2-37,11.1-54.1l-29.5-12.6 C14.7,194.3,10,216.7,8.5,240H40.6z M64.3,156.5c7.8-14.9,17.2-28.8,28.1-41.5L69.7,92.3c-13.7,15.6-25.5,32.8-34.9,51.5 L64.3,156.5z M397,419.6c-13.9,12-29.4,22.3-46.1,30.4l11.9,29.8c20.7-9.9,39.8-22.6,56.9-37.6L397,419.6z M115,92.4 c13.9-12,29.4-22.3,46.1-30.4l-11.9-29.8c-20.7,9.9-39.8,22.6-56.8,37.6L115,92.4z M447.7,355.5c-7.8,14.9-17.2,28.8-28.1,41.5 l22.7,22.7c13.7-15.6,25.5-32.9,34.9-51.5L447.7,355.5z M471.4,272c-1.4,18.8-5.2,37-11.1,54.1l29.5,12.6 c7.5-21.1,12.2-43.5,13.6-66.8H471.4z M321.2,462c-15.7,5-32.2,8.2-49.2,9.4v32.1c21.2-1.4,41.7-5.4,61.1-11.7L321.2,462z M240,471.4c-18.8-1.4-37-5.2-54.1-11.1l-12.6,29.5c21.1,7.5,43.5,12.2,66.8,13.6V471.4z M462,190.8c5,15.7,8.2,32.2,9.4,49.2h32.1 c-1.4-21.2-5.4-41.7-11.7-61.1L462,190.8z M92.4,397c-12-13.9-22.3-29.4-30.4-46.1l-29.8,11.9c9.9,20.7,22.6,39.8,37.6,56.9 L92.4,397z M272,40.6c18.8,1.4,36.9,5.2,54.1,11.1l12.6-29.5C317.7,14.7,295.3,10,272,8.5V40.6z M190.8,50 c15.7-5,32.2-8.2,49.2-9.4V8.5c-21.2,1.4-41.7,5.4-61.1,11.7L190.8,50z M442.3,92.3L419.6,115c12,13.9,22.3,29.4,30.5,46.1 l29.8-11.9C470,128.5,457.3,109.4,442.3,92.3z M397,92.4l22.7-22.7c-15.6-13.7-32.8-25.5-51.5-34.9l-12.6,29.5 C370.4,72.1,384.4,81.5,397,92.4z"
        })
      });
      var OPACITY_ANIMATE = _objectSpread2$1(_objectSpread2$1({}, ANIMATION_BASE), {}, {
        attributeName: "opacity"
      });
      var dot = {
        tag: "circle",
        attributes: _objectSpread2$1(_objectSpread2$1({}, FILL), {}, {
          cx: "256",
          cy: "364",
          r: "28"
        }),
        children: []
      };
      if (!reduceMotion) {
        dot.children.push({
          tag: "animate",
          attributes: _objectSpread2$1(_objectSpread2$1({}, ANIMATION_BASE), {}, {
            attributeName: "r",
            values: "28;14;28;28;14;28;"
          })
        }, {
          tag: "animate",
          attributes: _objectSpread2$1(_objectSpread2$1({}, OPACITY_ANIMATE), {}, {
            values: "1;0;1;1;0;1;"
          })
        });
      }
      gChildren.push(dot);
      gChildren.push({
        tag: "path",
        attributes: _objectSpread2$1(_objectSpread2$1({}, FILL), {}, {
          opacity: "1",
          d: "M263.7,312h-16c-6.6,0-12-5.4-12-12c0-71,77.4-63.9,77.4-107.8c0-20-17.8-40.2-57.4-40.2c-29.1,0-44.3,9.6-59.2,28.7 c-3.9,5-11.1,6-16.2,2.4l-13.1-9.2c-5.6-3.9-6.9-11.8-2.6-17.2c21.2-27.2,46.4-44.7,91.2-44.7c52.3,0,97.4,29.8,97.4,80.2 c0,67.6-77.4,63.5-77.4,107.8C275.7,306.6,270.3,312,263.7,312z"
        }),
        children: reduceMotion ? [] : [{
          tag: "animate",
          attributes: _objectSpread2$1(_objectSpread2$1({}, OPACITY_ANIMATE), {}, {
            values: "1;0;0;0;0;1;"
          })
        }]
      });
      if (!reduceMotion) {
        gChildren.push({
          tag: "path",
          attributes: _objectSpread2$1(_objectSpread2$1({}, FILL), {}, {
            opacity: "0",
            d: "M232.5,134.5l7,168c0.3,6.4,5.6,11.5,12,11.5h9c6.4,0,11.7-5.1,12-11.5l7-168c0.3-6.8-5.2-12.5-12-12.5h-23 C237.7,122,232.2,127.7,232.5,134.5z"
          }),
          children: [{
            tag: "animate",
            attributes: _objectSpread2$1(_objectSpread2$1({}, OPACITY_ANIMATE), {}, {
              values: "0;0;1;1;0;0;"
            })
          }]
        });
      }
      return {
        tag: "g",
        attributes: {
          "class": "missing"
        },
        children: gChildren
      };
    };
  }
};
var SvgSymbols = {
  hooks: function hooks7() {
    return {
      parseNodeAttributes: function parseNodeAttributes(accumulator, node) {
        var symbolData = node.getAttribute("data-fa-symbol");
        var symbol = symbolData === null ? false : symbolData === "" ? true : symbolData;
        accumulator["symbol"] = symbol;
        return accumulator;
      }
    };
  }
};
var plugins = [InjectCSS, ReplaceElements, Layers, LayersCounter, LayersText, PseudoElements, MutationObserver$1, PowerTransforms, Masks, MissingIconIndicator, SvgSymbols];
registerPlugins(plugins, {
  mixoutsTo: api
});
api.noAuto;
api.config;
api.library;
api.dom;
var parse$1 = api.parse;
api.findIconDefinition;
api.toHtml;
var icon2 = api.icon;
api.layer;
api.text;
api.counter;
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function getDefaultExportFromCjs(x) {
  return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default") ? x["default"] : x;
}
function getAugmentedNamespace(n2) {
  if (n2.__esModule)
    return n2;
  var f2 = n2.default;
  if (typeof f2 == "function") {
    var a = function a2() {
      if (this instanceof a2) {
        var args = [null];
        args.push.apply(args, arguments);
        var Ctor = Function.bind.apply(f2, args);
        return new Ctor();
      }
      return f2.apply(this, arguments);
    };
    a.prototype = f2.prototype;
  } else
    a = {};
  Object.defineProperty(a, "__esModule", { value: true });
  Object.keys(n2).forEach(function(k2) {
    var d2 = Object.getOwnPropertyDescriptor(n2, k2);
    Object.defineProperty(a, k2, d2.get ? d2 : {
      enumerable: true,
      get: function() {
        return n2[k2];
      }
    });
  });
  return a;
}
var propTypesExports = {};
var propTypes = {
  get exports() {
    return propTypesExports;
  },
  set exports(v2) {
    propTypesExports = v2;
  }
};
var ReactPropTypesSecret$1 = "SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED";
var ReactPropTypesSecret_1 = ReactPropTypesSecret$1;
var ReactPropTypesSecret = ReactPropTypesSecret_1;
function emptyFunction() {
}
function emptyFunctionWithReset() {
}
emptyFunctionWithReset.resetWarningCache = emptyFunction;
var factoryWithThrowingShims = function() {
  function shim2(props, propName, componentName, location, propFullName, secret) {
    if (secret === ReactPropTypesSecret) {
      return;
    }
    var err = new Error(
      "Calling PropTypes validators directly is not supported by the `prop-types` package. Use PropTypes.checkPropTypes() to call them. Read more at http://fb.me/use-check-prop-types"
    );
    err.name = "Invariant Violation";
    throw err;
  }
  shim2.isRequired = shim2;
  function getShim() {
    return shim2;
  }
  var ReactPropTypes = {
    array: shim2,
    bigint: shim2,
    bool: shim2,
    func: shim2,
    number: shim2,
    object: shim2,
    string: shim2,
    symbol: shim2,
    any: shim2,
    arrayOf: getShim,
    element: shim2,
    elementType: shim2,
    instanceOf: getShim,
    node: shim2,
    objectOf: getShim,
    oneOf: getShim,
    oneOfType: getShim,
    shape: getShim,
    exact: getShim,
    checkPropTypes: emptyFunctionWithReset,
    resetWarningCache: emptyFunction
  };
  ReactPropTypes.PropTypes = ReactPropTypes;
  return ReactPropTypes;
};
{
  propTypes.exports = factoryWithThrowingShims();
}
function ownKeys$h(object, enumerableOnly) {
  var keys3 = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys3.push.apply(keys3, symbols);
  }
  return keys3;
}
function _objectSpread2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = null != arguments[i] ? arguments[i] : {};
    i % 2 ? ownKeys$h(Object(source), true).forEach(function(key) {
      _defineProperty$M(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys$h(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _typeof(obj) {
  "@babel/helpers - typeof";
  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof(obj);
}
function _defineProperty$M(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _objectWithoutPropertiesLoose$3(source, excluded) {
  if (source == null)
    return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0)
      continue;
    target[key] = source[key];
  }
  return target;
}
function _objectWithoutProperties$2(source, excluded) {
  if (source == null)
    return {};
  var target = _objectWithoutPropertiesLoose$3(source, excluded);
  var key, i;
  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key = sourceSymbolKeys[i];
      if (excluded.indexOf(key) >= 0)
        continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key))
        continue;
      target[key] = source[key];
    }
  }
  return target;
}
function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
}
function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr))
    return _arrayLikeToArray(arr);
}
function _iterableToArray(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
    return Array.from(iter);
}
function _unsupportedIterableToArray(o, minLen) {
  if (!o)
    return;
  if (typeof o === "string")
    return _arrayLikeToArray(o, minLen);
  var n2 = Object.prototype.toString.call(o).slice(8, -1);
  if (n2 === "Object" && o.constructor)
    n2 = o.constructor.name;
  if (n2 === "Map" || n2 === "Set")
    return Array.from(o);
  if (n2 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n2))
    return _arrayLikeToArray(o, minLen);
}
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length)
    len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++)
    arr2[i] = arr[i];
  return arr2;
}
function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function classList(props) {
  var _classes;
  var beat = props.beat, fade = props.fade, beatFade = props.beatFade, bounce = props.bounce, shake = props.shake, flash = props.flash, spin = props.spin, spinPulse = props.spinPulse, spinReverse = props.spinReverse, pulse = props.pulse, fixedWidth = props.fixedWidth, inverse = props.inverse, border = props.border, listItem = props.listItem, flip2 = props.flip, size = props.size, rotation = props.rotation, pull = props.pull;
  var classes = (_classes = {
    "fa-beat": beat,
    "fa-fade": fade,
    "fa-beat-fade": beatFade,
    "fa-bounce": bounce,
    "fa-shake": shake,
    "fa-flash": flash,
    "fa-spin": spin,
    "fa-spin-reverse": spinReverse,
    "fa-spin-pulse": spinPulse,
    "fa-pulse": pulse,
    "fa-fw": fixedWidth,
    "fa-inverse": inverse,
    "fa-border": border,
    "fa-li": listItem,
    "fa-flip": flip2 === true,
    "fa-flip-horizontal": flip2 === "horizontal" || flip2 === "both",
    "fa-flip-vertical": flip2 === "vertical" || flip2 === "both"
  }, _defineProperty$M(_classes, "fa-".concat(size), typeof size !== "undefined" && size !== null), _defineProperty$M(_classes, "fa-rotate-".concat(rotation), typeof rotation !== "undefined" && rotation !== null && rotation !== 0), _defineProperty$M(_classes, "fa-pull-".concat(pull), typeof pull !== "undefined" && pull !== null), _defineProperty$M(_classes, "fa-swap-opacity", props.swapOpacity), _classes);
  return Object.keys(classes).map(function(key) {
    return classes[key] ? key : null;
  }).filter(function(key) {
    return key;
  });
}
function _isNumerical(obj) {
  obj = obj - 0;
  return obj === obj;
}
function camelize(string) {
  if (_isNumerical(string)) {
    return string;
  }
  string = string.replace(/[\-_\s]+(.)?/g, function(match, chr) {
    return chr ? chr.toUpperCase() : "";
  });
  return string.substr(0, 1).toLowerCase() + string.substr(1);
}
var _excluded$2 = ["style"];
function capitalize(val) {
  return val.charAt(0).toUpperCase() + val.slice(1);
}
function styleToObject(style) {
  return style.split(";").map(function(s) {
    return s.trim();
  }).filter(function(s) {
    return s;
  }).reduce(function(acc, pair) {
    var i = pair.indexOf(":");
    var prop = camelize(pair.slice(0, i));
    var value = pair.slice(i + 1).trim();
    prop.startsWith("webkit") ? acc[capitalize(prop)] = value : acc[prop] = value;
    return acc;
  }, {});
}
function convert(createElement2, element) {
  var extraProps = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
  if (typeof element === "string") {
    return element;
  }
  var children = (element.children || []).map(function(child) {
    return convert(createElement2, child);
  });
  var mixins = Object.keys(element.attributes || {}).reduce(function(acc, key) {
    var val = element.attributes[key];
    switch (key) {
      case "class":
        acc.attrs["className"] = val;
        delete element.attributes["class"];
        break;
      case "style":
        acc.attrs["style"] = styleToObject(val);
        break;
      default:
        if (key.indexOf("aria-") === 0 || key.indexOf("data-") === 0) {
          acc.attrs[key.toLowerCase()] = val;
        } else {
          acc.attrs[camelize(key)] = val;
        }
    }
    return acc;
  }, {
    attrs: {}
  });
  var _extraProps$style = extraProps.style, existingStyle = _extraProps$style === void 0 ? {} : _extraProps$style, remaining = _objectWithoutProperties$2(extraProps, _excluded$2);
  mixins.attrs["style"] = _objectSpread2(_objectSpread2({}, mixins.attrs["style"]), existingStyle);
  return createElement2.apply(void 0, [element.tag, _objectSpread2(_objectSpread2({}, mixins.attrs), remaining)].concat(_toConsumableArray(children)));
}
var PRODUCTION = false;
try {
  PRODUCTION = true;
} catch (e2) {
}
function log$e() {
  if (!PRODUCTION && console && typeof console.error === "function") {
    var _console;
    (_console = console).error.apply(_console, arguments);
  }
}
function normalizeIconArgs(icon3) {
  if (icon3 && _typeof(icon3) === "object" && icon3.prefix && icon3.iconName && icon3.icon) {
    return icon3;
  }
  if (parse$1.icon) {
    return parse$1.icon(icon3);
  }
  if (icon3 === null) {
    return null;
  }
  if (icon3 && _typeof(icon3) === "object" && icon3.prefix && icon3.iconName) {
    return icon3;
  }
  if (Array.isArray(icon3) && icon3.length === 2) {
    return {
      prefix: icon3[0],
      iconName: icon3[1]
    };
  }
  if (typeof icon3 === "string") {
    return {
      prefix: "fas",
      iconName: icon3
    };
  }
}
function objectWithKey(key, value) {
  return Array.isArray(value) && value.length > 0 || !Array.isArray(value) && value ? _defineProperty$M({}, key, value) : {};
}
var FontAwesomeIcon = /* @__PURE__ */ React.forwardRef(function(props, ref) {
  var iconArgs = props.icon, maskArgs = props.mask, symbol = props.symbol, className = props.className, title = props.title, titleId = props.titleId, maskId = props.maskId;
  var iconLookup = normalizeIconArgs(iconArgs);
  var classes = objectWithKey("classes", [].concat(_toConsumableArray(classList(props)), _toConsumableArray(className.split(" "))));
  var transform = objectWithKey("transform", typeof props.transform === "string" ? parse$1.transform(props.transform) : props.transform);
  var mask = objectWithKey("mask", normalizeIconArgs(maskArgs));
  var renderedIcon = icon2(iconLookup, _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, classes), transform), mask), {}, {
    symbol,
    title,
    titleId,
    maskId
  }));
  if (!renderedIcon) {
    log$e("Could not find icon", iconLookup);
    return null;
  }
  var abstract = renderedIcon.abstract;
  var extraProps = {
    ref
  };
  Object.keys(props).forEach(function(key) {
    if (!FontAwesomeIcon.defaultProps.hasOwnProperty(key)) {
      extraProps[key] = props[key];
    }
  });
  return convertCurry(abstract[0], extraProps);
});
FontAwesomeIcon.displayName = "FontAwesomeIcon";
FontAwesomeIcon.propTypes = {
  beat: propTypesExports.bool,
  border: propTypesExports.bool,
  beatFade: propTypesExports.bool,
  bounce: propTypesExports.bool,
  className: propTypesExports.string,
  fade: propTypesExports.bool,
  flash: propTypesExports.bool,
  mask: propTypesExports.oneOfType([propTypesExports.object, propTypesExports.array, propTypesExports.string]),
  maskId: propTypesExports.string,
  fixedWidth: propTypesExports.bool,
  inverse: propTypesExports.bool,
  flip: propTypesExports.oneOf([true, false, "horizontal", "vertical", "both"]),
  icon: propTypesExports.oneOfType([propTypesExports.object, propTypesExports.array, propTypesExports.string]),
  listItem: propTypesExports.bool,
  pull: propTypesExports.oneOf(["right", "left"]),
  pulse: propTypesExports.bool,
  rotation: propTypesExports.oneOf([0, 90, 180, 270]),
  shake: propTypesExports.bool,
  size: propTypesExports.oneOf(["2xs", "xs", "sm", "lg", "xl", "2xl", "1x", "2x", "3x", "4x", "5x", "6x", "7x", "8x", "9x", "10x"]),
  spin: propTypesExports.bool,
  spinPulse: propTypesExports.bool,
  spinReverse: propTypesExports.bool,
  symbol: propTypesExports.oneOfType([propTypesExports.bool, propTypesExports.string]),
  title: propTypesExports.string,
  titleId: propTypesExports.string,
  transform: propTypesExports.oneOfType([propTypesExports.string, propTypesExports.object]),
  swapOpacity: propTypesExports.bool
};
FontAwesomeIcon.defaultProps = {
  border: false,
  className: "",
  mask: null,
  maskId: null,
  fixedWidth: false,
  inverse: false,
  flip: false,
  icon: null,
  listItem: false,
  pull: null,
  pulse: false,
  rotation: null,
  size: null,
  spin: false,
  spinPulse: false,
  spinReverse: false,
  beat: false,
  fade: false,
  beatFade: false,
  bounce: false,
  shake: false,
  symbol: false,
  title: "",
  titleId: null,
  transform: null,
  swapOpacity: false
};
var convertCurry = convert.bind(null, React.createElement);
const vsCopy = {
  prefix: "vs",
  iconName: "copy",
  icon: [512, 512, [], "f000", "m128 128 32 -32h173.248L448 210.752V448l-32 32H160l-32 -32V128zm288 96 -96 -96H160v320h256V224zM96 32 64 64v320l32 32V64h205.248l-32 -32H96z"]
};
const vsGraph = {
  prefix: "vs",
  iconName: "graph",
  icon: [512, 512, [], "f000", "M48 448H480v-32H64V0H32v432l16 16zM96 368v-256l16 -16h64l16 16v256l-16 16h-64l-16 -16zm64 -16V128H128v224h32zm192 -304v320l16 16h64l16 -16v-320l-16 -16h-64l-16 16zm64 16v288h-32V64h32zm-192 304v-192l16 -16h64l16 16v192l-16 16h-64l-16 -16zm64 -16V192H256v160h32z"]
};
const vsLink = {
  prefix: "vs",
  iconName: "link",
  icon: [512, 512, [], "f000", "M140.8 96h98.72a108.8 108.8 0 0 1 108.8 108.8v6.56A108.8 108.8 0 0 1 239.52 320H224V288h15.52A76.8 76.8 0 0 0 316.16 211.52V204.8A76.8 76.8 0 0 0 239.68 128H140.8A76.8 76.8 0 0 0 64 204.8v6.56A76.608 76.608 0 0 0 128 286.72v32a108.8 108.8 0 0 1 -96 -107.2V204.8A108.96 108.96 0 0 1 140.8 96zM384 225.28v-32a108.8 108.8 0 0 1 96 107.52v6.56A108.96 108.96 0 0 1 371.36 416h-98.88A108.8 108.8 0 0 1 163.84 307.52V300.8A108.8 108.8 0 0 1 272.48 192H288v32h-15.52A76.8 76.8 0 0 0 195.84 300.8v6.56A76.8 76.8 0 0 0 272.48 384h98.88A76.8 76.8 0 0 0 448 307.52V300.8a76.608 76.608 0 0 0 -64 -75.52z"]
};
const vsPassFilled = {
  prefix: "vs",
  iconName: "pass-filled",
  icon: [512, 512, [], "f000", "M256 480A224 224 0 1 0 256 32a224 224 0 0 0 0 448zm-32.64 -132.16h-22.72L128 275.2l22.72 -22.72 61.44 61.44 134.4 -134.72 22.72 22.72 -145.92 145.92z"]
};
const vsPass = {
  prefix: "vs",
  iconName: "pass",
  icon: [512, 512, [], "f000", "M200.64 347.84h22.72l145.92 -145.92 -22.72 -22.72 -134.4 134.72 -61.44 -61.44L128 275.2l72.64 72.64zM275.2 32c51.2 3.2 99.2 28.8 134.4 64 41.6 44.8 64 99.2 64 163.2 0 51.2 -19.2 99.2 -51.2 140.8 -32 38.4 -76.8 67.2 -128 76.8 -51.2 9.6 -102.4 3.2 -147.2 -22.4 -44.8 -25.6 -80 -64 -99.2 -112C28.8 294.4 25.6 240 41.6 192c16 -51.2 44.8 -92.8 89.6 -121.6C172.8 41.6 224 28.8 275.2 32zm16 412.8c41.6 -9.6 80 -32 108.8 -67.2 25.6 -35.2 41.6 -76.8 38.4 -121.6 0 -51.2 -19.2 -102.4 -54.4 -137.6 -32 -32 -70.4 -51.2 -115.2 -54.4 -41.6 -3.2 -86.4 6.4 -121.6 32 -35.2 25.6 -60.8 60.8 -73.6 105.6 -12.8 41.6 -12.8 86.4 6.4 128 19.2 41.6 48 73.6 86.4 96 38.4 22.4 83.2 28.8 124.8 19.2z"]
};
const vsWarning = {
  prefix: "vs",
  iconName: "warning",
  icon: [512, 512, [], "f000", "M241.92 32h28.16l209.28 392.32 -14.08 23.68H46.08L32 424.32 241.92 32zM256 72.96 72.96 416H438.4L256 72.96zM276 384v-32h-40v32h40zm-40 -64V192h40v128h-40z"]
};
const dhExclamation = {
  prefix: "dh",
  iconName: "exclamation",
  icon: [512, 512, [], "f000", "M275.2 384v-32H236.8v32h38.4zm-38.4 -64V128h38.4v192H236.8z"]
};
function _extends$1() {
  _extends$1 = Object.assign ? Object.assign.bind() : function(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends$1.apply(this, arguments);
}
function _objectWithoutPropertiesLoose$2(source, excluded) {
  if (source == null)
    return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0)
      continue;
    target[key] = source[key];
  }
  return target;
}
function _setPrototypeOf(o, p2) {
  _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p3) {
    o2.__proto__ = p3;
    return o2;
  };
  return _setPrototypeOf(o, p2);
}
function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  _setPrototypeOf(subClass, superClass);
}
function hasClass(element, className) {
  if (element.classList)
    return !!className && element.classList.contains(className);
  return (" " + (element.className.baseVal || element.className) + " ").indexOf(" " + className + " ") !== -1;
}
function addClass(element, className) {
  if (element.classList)
    element.classList.add(className);
  else if (!hasClass(element, className))
    if (typeof element.className === "string")
      element.className = element.className + " " + className;
    else
      element.setAttribute("class", (element.className && element.className.baseVal || "") + " " + className);
}
function replaceClassName(origClass, classToRemove) {
  return origClass.replace(new RegExp("(^|\\s)" + classToRemove + "(?:\\s|$)", "g"), "$1").replace(/\s+/g, " ").replace(/^\s*|\s*$/g, "");
}
function removeClass$1(element, className) {
  if (element.classList) {
    element.classList.remove(className);
  } else if (typeof element.className === "string") {
    element.className = replaceClassName(element.className, className);
  } else {
    element.setAttribute("class", replaceClassName(element.className && element.className.baseVal || "", className));
  }
}
const config = {
  disabled: false
};
const TransitionGroupContext = React.createContext(null);
var forceReflow = function forceReflow2(node) {
  return node.scrollTop;
};
var UNMOUNTED = "unmounted";
var EXITED = "exited";
var ENTERING = "entering";
var ENTERED = "entered";
var EXITING = "exiting";
var Transition = /* @__PURE__ */ function(_React$Component) {
  _inheritsLoose(Transition2, _React$Component);
  function Transition2(props, context) {
    var _this;
    _this = _React$Component.call(this, props, context) || this;
    var parentGroup = context;
    var appear = parentGroup && !parentGroup.isMounting ? props.enter : props.appear;
    var initialStatus;
    _this.appearStatus = null;
    if (props.in) {
      if (appear) {
        initialStatus = EXITED;
        _this.appearStatus = ENTERING;
      } else {
        initialStatus = ENTERED;
      }
    } else {
      if (props.unmountOnExit || props.mountOnEnter) {
        initialStatus = UNMOUNTED;
      } else {
        initialStatus = EXITED;
      }
    }
    _this.state = {
      status: initialStatus
    };
    _this.nextCallback = null;
    return _this;
  }
  Transition2.getDerivedStateFromProps = function getDerivedStateFromProps(_ref2, prevState) {
    var nextIn = _ref2.in;
    if (nextIn && prevState.status === UNMOUNTED) {
      return {
        status: EXITED
      };
    }
    return null;
  };
  var _proto = Transition2.prototype;
  _proto.componentDidMount = function componentDidMount() {
    this.updateStatus(true, this.appearStatus);
  };
  _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
    var nextStatus = null;
    if (prevProps !== this.props) {
      var status = this.state.status;
      if (this.props.in) {
        if (status !== ENTERING && status !== ENTERED) {
          nextStatus = ENTERING;
        }
      } else {
        if (status === ENTERING || status === ENTERED) {
          nextStatus = EXITING;
        }
      }
    }
    this.updateStatus(false, nextStatus);
  };
  _proto.componentWillUnmount = function componentWillUnmount() {
    this.cancelNextCallback();
  };
  _proto.getTimeouts = function getTimeouts() {
    var timeout = this.props.timeout;
    var exit, enter, appear;
    exit = enter = appear = timeout;
    if (timeout != null && typeof timeout !== "number") {
      exit = timeout.exit;
      enter = timeout.enter;
      appear = timeout.appear !== void 0 ? timeout.appear : enter;
    }
    return {
      exit,
      enter,
      appear
    };
  };
  _proto.updateStatus = function updateStatus(mounting, nextStatus) {
    if (mounting === void 0) {
      mounting = false;
    }
    if (nextStatus !== null) {
      this.cancelNextCallback();
      if (nextStatus === ENTERING) {
        if (this.props.unmountOnExit || this.props.mountOnEnter) {
          var node = this.props.nodeRef ? this.props.nodeRef.current : ReactDOM.findDOMNode(this);
          if (node)
            forceReflow(node);
        }
        this.performEnter(mounting);
      } else {
        this.performExit();
      }
    } else if (this.props.unmountOnExit && this.state.status === EXITED) {
      this.setState({
        status: UNMOUNTED
      });
    }
  };
  _proto.performEnter = function performEnter(mounting) {
    var _this2 = this;
    var enter = this.props.enter;
    var appearing = this.context ? this.context.isMounting : mounting;
    var _ref2 = this.props.nodeRef ? [appearing] : [ReactDOM.findDOMNode(this), appearing], maybeNode = _ref2[0], maybeAppearing = _ref2[1];
    var timeouts = this.getTimeouts();
    var enterTimeout = appearing ? timeouts.appear : timeouts.enter;
    if (!mounting && !enter || config.disabled) {
      this.safeSetState({
        status: ENTERED
      }, function() {
        _this2.props.onEntered(maybeNode);
      });
      return;
    }
    this.props.onEnter(maybeNode, maybeAppearing);
    this.safeSetState({
      status: ENTERING
    }, function() {
      _this2.props.onEntering(maybeNode, maybeAppearing);
      _this2.onTransitionEnd(enterTimeout, function() {
        _this2.safeSetState({
          status: ENTERED
        }, function() {
          _this2.props.onEntered(maybeNode, maybeAppearing);
        });
      });
    });
  };
  _proto.performExit = function performExit() {
    var _this3 = this;
    var exit = this.props.exit;
    var timeouts = this.getTimeouts();
    var maybeNode = this.props.nodeRef ? void 0 : ReactDOM.findDOMNode(this);
    if (!exit || config.disabled) {
      this.safeSetState({
        status: EXITED
      }, function() {
        _this3.props.onExited(maybeNode);
      });
      return;
    }
    this.props.onExit(maybeNode);
    this.safeSetState({
      status: EXITING
    }, function() {
      _this3.props.onExiting(maybeNode);
      _this3.onTransitionEnd(timeouts.exit, function() {
        _this3.safeSetState({
          status: EXITED
        }, function() {
          _this3.props.onExited(maybeNode);
        });
      });
    });
  };
  _proto.cancelNextCallback = function cancelNextCallback() {
    if (this.nextCallback !== null) {
      this.nextCallback.cancel();
      this.nextCallback = null;
    }
  };
  _proto.safeSetState = function safeSetState(nextState, callback) {
    callback = this.setNextCallback(callback);
    this.setState(nextState, callback);
  };
  _proto.setNextCallback = function setNextCallback(callback) {
    var _this4 = this;
    var active = true;
    this.nextCallback = function(event) {
      if (active) {
        active = false;
        _this4.nextCallback = null;
        callback(event);
      }
    };
    this.nextCallback.cancel = function() {
      active = false;
    };
    return this.nextCallback;
  };
  _proto.onTransitionEnd = function onTransitionEnd(timeout, handler) {
    this.setNextCallback(handler);
    var node = this.props.nodeRef ? this.props.nodeRef.current : ReactDOM.findDOMNode(this);
    var doesNotHaveTimeoutOrListener = timeout == null && !this.props.addEndListener;
    if (!node || doesNotHaveTimeoutOrListener) {
      setTimeout(this.nextCallback, 0);
      return;
    }
    if (this.props.addEndListener) {
      var _ref3 = this.props.nodeRef ? [this.nextCallback] : [node, this.nextCallback], maybeNode = _ref3[0], maybeNextCallback = _ref3[1];
      this.props.addEndListener(maybeNode, maybeNextCallback);
    }
    if (timeout != null) {
      setTimeout(this.nextCallback, timeout);
    }
  };
  _proto.render = function render3() {
    var status = this.state.status;
    if (status === UNMOUNTED) {
      return null;
    }
    var _this$props = this.props, children = _this$props.children;
    _this$props.in;
    _this$props.mountOnEnter;
    _this$props.unmountOnExit;
    _this$props.appear;
    _this$props.enter;
    _this$props.exit;
    _this$props.timeout;
    _this$props.addEndListener;
    _this$props.onEnter;
    _this$props.onEntering;
    _this$props.onEntered;
    _this$props.onExit;
    _this$props.onExiting;
    _this$props.onExited;
    _this$props.nodeRef;
    var childProps = _objectWithoutPropertiesLoose$2(_this$props, ["children", "in", "mountOnEnter", "unmountOnExit", "appear", "enter", "exit", "timeout", "addEndListener", "onEnter", "onEntering", "onEntered", "onExit", "onExiting", "onExited", "nodeRef"]);
    return (
      // allows for nested Transitions
      /* @__PURE__ */ React.createElement(TransitionGroupContext.Provider, {
        value: null
      }, typeof children === "function" ? children(status, childProps) : React.cloneElement(React.Children.only(children), childProps))
    );
  };
  return Transition2;
}(React.Component);
Transition.contextType = TransitionGroupContext;
Transition.propTypes = {};
function noop$1() {
}
Transition.defaultProps = {
  in: false,
  mountOnEnter: false,
  unmountOnExit: false,
  appear: false,
  enter: true,
  exit: true,
  onEnter: noop$1,
  onEntering: noop$1,
  onEntered: noop$1,
  onExit: noop$1,
  onExiting: noop$1,
  onExited: noop$1
};
Transition.UNMOUNTED = UNMOUNTED;
Transition.EXITED = EXITED;
Transition.ENTERING = ENTERING;
Transition.ENTERED = ENTERED;
Transition.EXITING = EXITING;
const $fQOb3$Transition = Transition;
var _addClass = function addClass$1(node, classes) {
  return node && classes && classes.split(" ").forEach(function(c2) {
    return addClass(node, c2);
  });
};
var removeClass = function removeClass2(node, classes) {
  return node && classes && classes.split(" ").forEach(function(c2) {
    return removeClass$1(node, c2);
  });
};
var CSSTransition = /* @__PURE__ */ function(_React$Component) {
  _inheritsLoose(CSSTransition2, _React$Component);
  function CSSTransition2() {
    var _this;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;
    _this.appliedClasses = {
      appear: {},
      enter: {},
      exit: {}
    };
    _this.onEnter = function(maybeNode, maybeAppearing) {
      var _this$resolveArgument = _this.resolveArguments(maybeNode, maybeAppearing), node = _this$resolveArgument[0], appearing = _this$resolveArgument[1];
      _this.removeClasses(node, "exit");
      _this.addClass(node, appearing ? "appear" : "enter", "base");
      if (_this.props.onEnter) {
        _this.props.onEnter(maybeNode, maybeAppearing);
      }
    };
    _this.onEntering = function(maybeNode, maybeAppearing) {
      var _this$resolveArgument2 = _this.resolveArguments(maybeNode, maybeAppearing), node = _this$resolveArgument2[0], appearing = _this$resolveArgument2[1];
      var type = appearing ? "appear" : "enter";
      _this.addClass(node, type, "active");
      if (_this.props.onEntering) {
        _this.props.onEntering(maybeNode, maybeAppearing);
      }
    };
    _this.onEntered = function(maybeNode, maybeAppearing) {
      var _this$resolveArgument3 = _this.resolveArguments(maybeNode, maybeAppearing), node = _this$resolveArgument3[0], appearing = _this$resolveArgument3[1];
      var type = appearing ? "appear" : "enter";
      _this.removeClasses(node, type);
      _this.addClass(node, type, "done");
      if (_this.props.onEntered) {
        _this.props.onEntered(maybeNode, maybeAppearing);
      }
    };
    _this.onExit = function(maybeNode) {
      var _this$resolveArgument4 = _this.resolveArguments(maybeNode), node = _this$resolveArgument4[0];
      _this.removeClasses(node, "appear");
      _this.removeClasses(node, "enter");
      _this.addClass(node, "exit", "base");
      if (_this.props.onExit) {
        _this.props.onExit(maybeNode);
      }
    };
    _this.onExiting = function(maybeNode) {
      var _this$resolveArgument5 = _this.resolveArguments(maybeNode), node = _this$resolveArgument5[0];
      _this.addClass(node, "exit", "active");
      if (_this.props.onExiting) {
        _this.props.onExiting(maybeNode);
      }
    };
    _this.onExited = function(maybeNode) {
      var _this$resolveArgument6 = _this.resolveArguments(maybeNode), node = _this$resolveArgument6[0];
      _this.removeClasses(node, "exit");
      _this.addClass(node, "exit", "done");
      if (_this.props.onExited) {
        _this.props.onExited(maybeNode);
      }
    };
    _this.resolveArguments = function(maybeNode, maybeAppearing) {
      return _this.props.nodeRef ? [_this.props.nodeRef.current, maybeNode] : [maybeNode, maybeAppearing];
    };
    _this.getClassNames = function(type) {
      var classNames = _this.props.classNames;
      var isStringClassNames = typeof classNames === "string";
      var prefix = isStringClassNames && classNames ? classNames + "-" : "";
      var baseClassName = isStringClassNames ? "" + prefix + type : classNames[type];
      var activeClassName = isStringClassNames ? baseClassName + "-active" : classNames[type + "Active"];
      var doneClassName = isStringClassNames ? baseClassName + "-done" : classNames[type + "Done"];
      return {
        baseClassName,
        activeClassName,
        doneClassName
      };
    };
    return _this;
  }
  var _proto = CSSTransition2.prototype;
  _proto.addClass = function addClass2(node, type, phase) {
    var className = this.getClassNames(type)[phase + "ClassName"];
    var _this$getClassNames = this.getClassNames("enter"), doneClassName = _this$getClassNames.doneClassName;
    if (type === "appear" && phase === "done" && doneClassName) {
      className += " " + doneClassName;
    }
    if (phase === "active") {
      if (node)
        forceReflow(node);
    }
    if (className) {
      this.appliedClasses[type][phase] = className;
      _addClass(node, className);
    }
  };
  _proto.removeClasses = function removeClasses(node, type) {
    var _this$appliedClasses$ = this.appliedClasses[type], baseClassName = _this$appliedClasses$.base, activeClassName = _this$appliedClasses$.active, doneClassName = _this$appliedClasses$.done;
    this.appliedClasses[type] = {};
    if (baseClassName) {
      removeClass(node, baseClassName);
    }
    if (activeClassName) {
      removeClass(node, activeClassName);
    }
    if (doneClassName) {
      removeClass(node, doneClassName);
    }
  };
  _proto.render = function render3() {
    var _this$props = this.props;
    _this$props.classNames;
    var props = _objectWithoutPropertiesLoose$2(_this$props, ["classNames"]);
    return /* @__PURE__ */ React.createElement($fQOb3$Transition, _extends$1({}, props, {
      onEnter: this.onEnter,
      onEntered: this.onEntered,
      onEntering: this.onEntering,
      onExit: this.onExit,
      onExiting: this.onExiting,
      onExited: this.onExited
    }));
  };
  return CSSTransition2;
}(React.Component);
CSSTransition.defaultProps = {
  classNames: ""
};
CSSTransition.propTypes = {};
const CSSTransition$1 = CSSTransition;
var classnamesExports = {};
var classnames = {
  get exports() {
    return classnamesExports;
  },
  set exports(v2) {
    classnamesExports = v2;
  }
};
/*!
	Copyright (c) 2018 Jed Watson.
	Licensed under the MIT License (MIT), see
	http://jedwatson.github.io/classnames
*/
(function(module2) {
  (function() {
    var hasOwn2 = {}.hasOwnProperty;
    function classNames() {
      var classes = [];
      for (var i = 0; i < arguments.length; i++) {
        var arg = arguments[i];
        if (!arg)
          continue;
        var argType = typeof arg;
        if (argType === "string" || argType === "number") {
          classes.push(arg);
        } else if (Array.isArray(arg)) {
          if (arg.length) {
            var inner2 = classNames.apply(null, arg);
            if (inner2) {
              classes.push(inner2);
            }
          }
        } else if (argType === "object") {
          if (arg.toString !== Object.prototype.toString && !arg.toString.toString().includes("[native code]")) {
            classes.push(arg.toString());
            continue;
          }
          for (var key in arg) {
            if (hasOwn2.call(arg, key) && arg[key]) {
              classes.push(key);
            }
          }
        }
      }
      return classes.join(" ");
    }
    if (module2.exports) {
      classNames.default = classNames;
      module2.exports = classNames;
    } else {
      window.classNames = classNames;
    }
  })();
})(classnames);
/**!
 * @fileOverview Kickass library to create and place poppers near their reference elements.
 * @version 1.16.1
 * @license
 * Copyright (c) 2016 Federico Zivolo and contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
var isBrowser = typeof window !== "undefined" && typeof document !== "undefined" && typeof navigator !== "undefined";
var timeoutDuration = function() {
  var longerTimeoutBrowsers = ["Edge", "Trident", "Firefox"];
  for (var i = 0; i < longerTimeoutBrowsers.length; i += 1) {
    if (isBrowser && navigator.userAgent.indexOf(longerTimeoutBrowsers[i]) >= 0) {
      return 1;
    }
  }
  return 0;
}();
function microtaskDebounce(fn) {
  var called = false;
  return function() {
    if (called) {
      return;
    }
    called = true;
    window.Promise.resolve().then(function() {
      called = false;
      fn();
    });
  };
}
function taskDebounce(fn) {
  var scheduled = false;
  return function() {
    if (!scheduled) {
      scheduled = true;
      setTimeout(function() {
        scheduled = false;
        fn();
      }, timeoutDuration);
    }
  };
}
var supportsMicroTasks = isBrowser && window.Promise;
var debounce$1 = supportsMicroTasks ? microtaskDebounce : taskDebounce;
function isFunction$1(functionToCheck) {
  var getType = {};
  return functionToCheck && getType.toString.call(functionToCheck) === "[object Function]";
}
function getStyleComputedProperty(element, property) {
  if (element.nodeType !== 1) {
    return [];
  }
  var window2 = element.ownerDocument.defaultView;
  var css2 = window2.getComputedStyle(element, null);
  return property ? css2[property] : css2;
}
function getParentNode(element) {
  if (element.nodeName === "HTML") {
    return element;
  }
  return element.parentNode || element.host;
}
function getScrollParent(element) {
  if (!element) {
    return document.body;
  }
  switch (element.nodeName) {
    case "HTML":
    case "BODY":
      return element.ownerDocument.body;
    case "#document":
      return element.body;
  }
  var _getStyleComputedProp = getStyleComputedProperty(element), overflow = _getStyleComputedProp.overflow, overflowX = _getStyleComputedProp.overflowX, overflowY = _getStyleComputedProp.overflowY;
  if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
    return element;
  }
  return getScrollParent(getParentNode(element));
}
function getReferenceNode(reference) {
  return reference && reference.referenceNode ? reference.referenceNode : reference;
}
var isIE11 = isBrowser && !!(window.MSInputMethodContext && document.documentMode);
var isIE10 = isBrowser && /MSIE 10/.test(navigator.userAgent);
function isIE(version2) {
  if (version2 === 11) {
    return isIE11;
  }
  if (version2 === 10) {
    return isIE10;
  }
  return isIE11 || isIE10;
}
function getOffsetParent(element) {
  if (!element) {
    return document.documentElement;
  }
  var noOffsetParent = isIE(10) ? document.body : null;
  var offsetParent = element.offsetParent || null;
  while (offsetParent === noOffsetParent && element.nextElementSibling) {
    offsetParent = (element = element.nextElementSibling).offsetParent;
  }
  var nodeName = offsetParent && offsetParent.nodeName;
  if (!nodeName || nodeName === "BODY" || nodeName === "HTML") {
    return element ? element.ownerDocument.documentElement : document.documentElement;
  }
  if (["TH", "TD", "TABLE"].indexOf(offsetParent.nodeName) !== -1 && getStyleComputedProperty(offsetParent, "position") === "static") {
    return getOffsetParent(offsetParent);
  }
  return offsetParent;
}
function isOffsetContainer(element) {
  var nodeName = element.nodeName;
  if (nodeName === "BODY") {
    return false;
  }
  return nodeName === "HTML" || getOffsetParent(element.firstElementChild) === element;
}
function getRoot(node) {
  if (node.parentNode !== null) {
    return getRoot(node.parentNode);
  }
  return node;
}
function findCommonOffsetParent(element1, element2) {
  if (!element1 || !element1.nodeType || !element2 || !element2.nodeType) {
    return document.documentElement;
  }
  var order = element1.compareDocumentPosition(element2) & Node.DOCUMENT_POSITION_FOLLOWING;
  var start = order ? element1 : element2;
  var end3 = order ? element2 : element1;
  var range = document.createRange();
  range.setStart(start, 0);
  range.setEnd(end3, 0);
  var commonAncestorContainer = range.commonAncestorContainer;
  if (element1 !== commonAncestorContainer && element2 !== commonAncestorContainer || start.contains(end3)) {
    if (isOffsetContainer(commonAncestorContainer)) {
      return commonAncestorContainer;
    }
    return getOffsetParent(commonAncestorContainer);
  }
  var element1root = getRoot(element1);
  if (element1root.host) {
    return findCommonOffsetParent(element1root.host, element2);
  } else {
    return findCommonOffsetParent(element1, getRoot(element2).host);
  }
}
function getScroll(element) {
  var side = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "top";
  var upperSide = side === "top" ? "scrollTop" : "scrollLeft";
  var nodeName = element.nodeName;
  if (nodeName === "BODY" || nodeName === "HTML") {
    var html = element.ownerDocument.documentElement;
    var scrollingElement = element.ownerDocument.scrollingElement || html;
    return scrollingElement[upperSide];
  }
  return element[upperSide];
}
function includeScroll(rect, element) {
  var subtract = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
  var scrollTop = getScroll(element, "top");
  var scrollLeft = getScroll(element, "left");
  var modifier = subtract ? -1 : 1;
  rect.top += scrollTop * modifier;
  rect.bottom += scrollTop * modifier;
  rect.left += scrollLeft * modifier;
  rect.right += scrollLeft * modifier;
  return rect;
}
function getBordersSize(styles2, axis) {
  var sideA = axis === "x" ? "Left" : "Top";
  var sideB = sideA === "Left" ? "Right" : "Bottom";
  return parseFloat(styles2["border" + sideA + "Width"]) + parseFloat(styles2["border" + sideB + "Width"]);
}
function getSize$1(axis, body, html, computedStyle) {
  return Math.max(body["offset" + axis], body["scroll" + axis], html["client" + axis], html["offset" + axis], html["scroll" + axis], isIE(10) ? parseInt(html["offset" + axis]) + parseInt(computedStyle["margin" + (axis === "Height" ? "Top" : "Left")]) + parseInt(computedStyle["margin" + (axis === "Height" ? "Bottom" : "Right")]) : 0);
}
function getWindowSizes(document2) {
  var body = document2.body;
  var html = document2.documentElement;
  var computedStyle = isIE(10) && getComputedStyle(html);
  return {
    height: getSize$1("Height", body, html, computedStyle),
    width: getSize$1("Width", body, html, computedStyle)
  };
}
var classCallCheck = function(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};
var createClass = function() {
  function defineProperties2(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor)
        descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  return function(Constructor, protoProps, staticProps) {
    if (protoProps)
      defineProperties2(Constructor.prototype, protoProps);
    if (staticProps)
      defineProperties2(Constructor, staticProps);
    return Constructor;
  };
}();
var defineProperty$2 = function(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
};
var _extends = Object.assign || function(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i];
    for (var key in source) {
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }
  return target;
};
function getClientRect(offsets) {
  return _extends({}, offsets, {
    right: offsets.left + offsets.width,
    bottom: offsets.top + offsets.height
  });
}
function getBoundingClientRect(element) {
  var rect = {};
  try {
    if (isIE(10)) {
      rect = element.getBoundingClientRect();
      var scrollTop = getScroll(element, "top");
      var scrollLeft = getScroll(element, "left");
      rect.top += scrollTop;
      rect.left += scrollLeft;
      rect.bottom += scrollTop;
      rect.right += scrollLeft;
    } else {
      rect = element.getBoundingClientRect();
    }
  } catch (e2) {
  }
  var result = {
    left: rect.left,
    top: rect.top,
    width: rect.right - rect.left,
    height: rect.bottom - rect.top
  };
  var sizes = element.nodeName === "HTML" ? getWindowSizes(element.ownerDocument) : {};
  var width = sizes.width || element.clientWidth || result.width;
  var height = sizes.height || element.clientHeight || result.height;
  var horizScrollbar = element.offsetWidth - width;
  var vertScrollbar = element.offsetHeight - height;
  if (horizScrollbar || vertScrollbar) {
    var styles2 = getStyleComputedProperty(element);
    horizScrollbar -= getBordersSize(styles2, "x");
    vertScrollbar -= getBordersSize(styles2, "y");
    result.width -= horizScrollbar;
    result.height -= vertScrollbar;
  }
  return getClientRect(result);
}
function getOffsetRectRelativeToArbitraryNode(children, parent) {
  var fixedPosition = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
  var isIE102 = isIE(10);
  var isHTML = parent.nodeName === "HTML";
  var childrenRect = getBoundingClientRect(children);
  var parentRect = getBoundingClientRect(parent);
  var scrollParent = getScrollParent(children);
  var styles2 = getStyleComputedProperty(parent);
  var borderTopWidth = parseFloat(styles2.borderTopWidth);
  var borderLeftWidth = parseFloat(styles2.borderLeftWidth);
  if (fixedPosition && isHTML) {
    parentRect.top = Math.max(parentRect.top, 0);
    parentRect.left = Math.max(parentRect.left, 0);
  }
  var offsets = getClientRect({
    top: childrenRect.top - parentRect.top - borderTopWidth,
    left: childrenRect.left - parentRect.left - borderLeftWidth,
    width: childrenRect.width,
    height: childrenRect.height
  });
  offsets.marginTop = 0;
  offsets.marginLeft = 0;
  if (!isIE102 && isHTML) {
    var marginTop = parseFloat(styles2.marginTop);
    var marginLeft = parseFloat(styles2.marginLeft);
    offsets.top -= borderTopWidth - marginTop;
    offsets.bottom -= borderTopWidth - marginTop;
    offsets.left -= borderLeftWidth - marginLeft;
    offsets.right -= borderLeftWidth - marginLeft;
    offsets.marginTop = marginTop;
    offsets.marginLeft = marginLeft;
  }
  if (isIE102 && !fixedPosition ? parent.contains(scrollParent) : parent === scrollParent && scrollParent.nodeName !== "BODY") {
    offsets = includeScroll(offsets, parent);
  }
  return offsets;
}
function getViewportOffsetRectRelativeToArtbitraryNode(element) {
  var excludeScroll = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : false;
  var html = element.ownerDocument.documentElement;
  var relativeOffset = getOffsetRectRelativeToArbitraryNode(element, html);
  var width = Math.max(html.clientWidth, window.innerWidth || 0);
  var height = Math.max(html.clientHeight, window.innerHeight || 0);
  var scrollTop = !excludeScroll ? getScroll(html) : 0;
  var scrollLeft = !excludeScroll ? getScroll(html, "left") : 0;
  var offset2 = {
    top: scrollTop - relativeOffset.top + relativeOffset.marginTop,
    left: scrollLeft - relativeOffset.left + relativeOffset.marginLeft,
    width,
    height
  };
  return getClientRect(offset2);
}
function isFixed(element) {
  var nodeName = element.nodeName;
  if (nodeName === "BODY" || nodeName === "HTML") {
    return false;
  }
  if (getStyleComputedProperty(element, "position") === "fixed") {
    return true;
  }
  var parentNode = getParentNode(element);
  if (!parentNode) {
    return false;
  }
  return isFixed(parentNode);
}
function getFixedPositionOffsetParent(element) {
  if (!element || !element.parentElement || isIE()) {
    return document.documentElement;
  }
  var el = element.parentElement;
  while (el && getStyleComputedProperty(el, "transform") === "none") {
    el = el.parentElement;
  }
  return el || document.documentElement;
}
function getBoundaries(popper, reference, padding, boundariesElement) {
  var fixedPosition = arguments.length > 4 && arguments[4] !== void 0 ? arguments[4] : false;
  var boundaries = { top: 0, left: 0 };
  var offsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, getReferenceNode(reference));
  if (boundariesElement === "viewport") {
    boundaries = getViewportOffsetRectRelativeToArtbitraryNode(offsetParent, fixedPosition);
  } else {
    var boundariesNode = void 0;
    if (boundariesElement === "scrollParent") {
      boundariesNode = getScrollParent(getParentNode(reference));
      if (boundariesNode.nodeName === "BODY") {
        boundariesNode = popper.ownerDocument.documentElement;
      }
    } else if (boundariesElement === "window") {
      boundariesNode = popper.ownerDocument.documentElement;
    } else {
      boundariesNode = boundariesElement;
    }
    var offsets = getOffsetRectRelativeToArbitraryNode(boundariesNode, offsetParent, fixedPosition);
    if (boundariesNode.nodeName === "HTML" && !isFixed(offsetParent)) {
      var _getWindowSizes = getWindowSizes(popper.ownerDocument), height = _getWindowSizes.height, width = _getWindowSizes.width;
      boundaries.top += offsets.top - offsets.marginTop;
      boundaries.bottom = height + offsets.top;
      boundaries.left += offsets.left - offsets.marginLeft;
      boundaries.right = width + offsets.left;
    } else {
      boundaries = offsets;
    }
  }
  padding = padding || 0;
  var isPaddingNumber = typeof padding === "number";
  boundaries.left += isPaddingNumber ? padding : padding.left || 0;
  boundaries.top += isPaddingNumber ? padding : padding.top || 0;
  boundaries.right -= isPaddingNumber ? padding : padding.right || 0;
  boundaries.bottom -= isPaddingNumber ? padding : padding.bottom || 0;
  return boundaries;
}
function getArea(_ref2) {
  var width = _ref2.width, height = _ref2.height;
  return width * height;
}
function computeAutoPlacement(placement, refRect, popper, reference, boundariesElement) {
  var padding = arguments.length > 5 && arguments[5] !== void 0 ? arguments[5] : 0;
  if (placement.indexOf("auto") === -1) {
    return placement;
  }
  var boundaries = getBoundaries(popper, reference, padding, boundariesElement);
  var rects = {
    top: {
      width: boundaries.width,
      height: refRect.top - boundaries.top
    },
    right: {
      width: boundaries.right - refRect.right,
      height: boundaries.height
    },
    bottom: {
      width: boundaries.width,
      height: boundaries.bottom - refRect.bottom
    },
    left: {
      width: refRect.left - boundaries.left,
      height: boundaries.height
    }
  };
  var sortedAreas = Object.keys(rects).map(function(key) {
    return _extends({
      key
    }, rects[key], {
      area: getArea(rects[key])
    });
  }).sort(function(a, b2) {
    return b2.area - a.area;
  });
  var filteredAreas = sortedAreas.filter(function(_ref2) {
    var width = _ref2.width, height = _ref2.height;
    return width >= popper.clientWidth && height >= popper.clientHeight;
  });
  var computedPlacement = filteredAreas.length > 0 ? filteredAreas[0].key : sortedAreas[0].key;
  var variation = placement.split("-")[1];
  return computedPlacement + (variation ? "-" + variation : "");
}
function getReferenceOffsets(state, popper, reference) {
  var fixedPosition = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : null;
  var commonOffsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, getReferenceNode(reference));
  return getOffsetRectRelativeToArbitraryNode(reference, commonOffsetParent, fixedPosition);
}
function getOuterSizes(element) {
  var window2 = element.ownerDocument.defaultView;
  var styles2 = window2.getComputedStyle(element);
  var x = parseFloat(styles2.marginTop || 0) + parseFloat(styles2.marginBottom || 0);
  var y2 = parseFloat(styles2.marginLeft || 0) + parseFloat(styles2.marginRight || 0);
  var result = {
    width: element.offsetWidth + y2,
    height: element.offsetHeight + x
  };
  return result;
}
function getOppositePlacement(placement) {
  var hash = { left: "right", right: "left", bottom: "top", top: "bottom" };
  return placement.replace(/left|right|bottom|top/g, function(matched) {
    return hash[matched];
  });
}
function getPopperOffsets(popper, referenceOffsets, placement) {
  placement = placement.split("-")[0];
  var popperRect = getOuterSizes(popper);
  var popperOffsets = {
    width: popperRect.width,
    height: popperRect.height
  };
  var isHoriz = ["right", "left"].indexOf(placement) !== -1;
  var mainSide = isHoriz ? "top" : "left";
  var secondarySide = isHoriz ? "left" : "top";
  var measurement = isHoriz ? "height" : "width";
  var secondaryMeasurement = !isHoriz ? "height" : "width";
  popperOffsets[mainSide] = referenceOffsets[mainSide] + referenceOffsets[measurement] / 2 - popperRect[measurement] / 2;
  if (placement === secondarySide) {
    popperOffsets[secondarySide] = referenceOffsets[secondarySide] - popperRect[secondaryMeasurement];
  } else {
    popperOffsets[secondarySide] = referenceOffsets[getOppositePlacement(secondarySide)];
  }
  return popperOffsets;
}
function find$1(arr, check) {
  if (Array.prototype.find) {
    return arr.find(check);
  }
  return arr.filter(check)[0];
}
function findIndex(arr, prop, value) {
  if (Array.prototype.findIndex) {
    return arr.findIndex(function(cur) {
      return cur[prop] === value;
    });
  }
  var match = find$1(arr, function(obj) {
    return obj[prop] === value;
  });
  return arr.indexOf(match);
}
function runModifiers(modifiers2, data, ends) {
  var modifiersToRun = ends === void 0 ? modifiers2 : modifiers2.slice(0, findIndex(modifiers2, "name", ends));
  modifiersToRun.forEach(function(modifier) {
    if (modifier["function"]) {
      console.warn("`modifier.function` is deprecated, use `modifier.fn`!");
    }
    var fn = modifier["function"] || modifier.fn;
    if (modifier.enabled && isFunction$1(fn)) {
      data.offsets.popper = getClientRect(data.offsets.popper);
      data.offsets.reference = getClientRect(data.offsets.reference);
      data = fn(data, modifier);
    }
  });
  return data;
}
function update() {
  if (this.state.isDestroyed) {
    return;
  }
  var data = {
    instance: this,
    styles: {},
    arrowStyles: {},
    attributes: {},
    flipped: false,
    offsets: {}
  };
  data.offsets.reference = getReferenceOffsets(this.state, this.popper, this.reference, this.options.positionFixed);
  data.placement = computeAutoPlacement(this.options.placement, data.offsets.reference, this.popper, this.reference, this.options.modifiers.flip.boundariesElement, this.options.modifiers.flip.padding);
  data.originalPlacement = data.placement;
  data.positionFixed = this.options.positionFixed;
  data.offsets.popper = getPopperOffsets(this.popper, data.offsets.reference, data.placement);
  data.offsets.popper.position = this.options.positionFixed ? "fixed" : "absolute";
  data = runModifiers(this.modifiers, data);
  if (!this.state.isCreated) {
    this.state.isCreated = true;
    this.options.onCreate(data);
  } else {
    this.options.onUpdate(data);
  }
}
function isModifierEnabled(modifiers2, modifierName) {
  return modifiers2.some(function(_ref2) {
    var name2 = _ref2.name, enabled = _ref2.enabled;
    return enabled && name2 === modifierName;
  });
}
function getSupportedPropertyName(property) {
  var prefixes2 = [false, "ms", "Webkit", "Moz", "O"];
  var upperProp = property.charAt(0).toUpperCase() + property.slice(1);
  for (var i = 0; i < prefixes2.length; i++) {
    var prefix = prefixes2[i];
    var toCheck = prefix ? "" + prefix + upperProp : property;
    if (typeof document.body.style[toCheck] !== "undefined") {
      return toCheck;
    }
  }
  return null;
}
function destroy() {
  this.state.isDestroyed = true;
  if (isModifierEnabled(this.modifiers, "applyStyle")) {
    this.popper.removeAttribute("x-placement");
    this.popper.style.position = "";
    this.popper.style.top = "";
    this.popper.style.left = "";
    this.popper.style.right = "";
    this.popper.style.bottom = "";
    this.popper.style.willChange = "";
    this.popper.style[getSupportedPropertyName("transform")] = "";
  }
  this.disableEventListeners();
  if (this.options.removeOnDestroy) {
    this.popper.parentNode.removeChild(this.popper);
  }
  return this;
}
function getWindow(element) {
  var ownerDocument = element.ownerDocument;
  return ownerDocument ? ownerDocument.defaultView : window;
}
function attachToScrollParents(scrollParent, event, callback, scrollParents) {
  var isBody = scrollParent.nodeName === "BODY";
  var target = isBody ? scrollParent.ownerDocument.defaultView : scrollParent;
  target.addEventListener(event, callback, { passive: true });
  if (!isBody) {
    attachToScrollParents(getScrollParent(target.parentNode), event, callback, scrollParents);
  }
  scrollParents.push(target);
}
function setupEventListeners(reference, options, state, updateBound) {
  state.updateBound = updateBound;
  getWindow(reference).addEventListener("resize", state.updateBound, { passive: true });
  var scrollElement = getScrollParent(reference);
  attachToScrollParents(scrollElement, "scroll", state.updateBound, state.scrollParents);
  state.scrollElement = scrollElement;
  state.eventsEnabled = true;
  return state;
}
function enableEventListeners() {
  if (!this.state.eventsEnabled) {
    this.state = setupEventListeners(this.reference, this.options, this.state, this.scheduleUpdate);
  }
}
function removeEventListeners(reference, state) {
  getWindow(reference).removeEventListener("resize", state.updateBound);
  state.scrollParents.forEach(function(target) {
    target.removeEventListener("scroll", state.updateBound);
  });
  state.updateBound = null;
  state.scrollParents = [];
  state.scrollElement = null;
  state.eventsEnabled = false;
  return state;
}
function disableEventListeners() {
  if (this.state.eventsEnabled) {
    cancelAnimationFrame(this.scheduleUpdate);
    this.state = removeEventListeners(this.reference, this.state);
  }
}
function isNumeric(n2) {
  return n2 !== "" && !isNaN(parseFloat(n2)) && isFinite(n2);
}
function setStyles(element, styles2) {
  Object.keys(styles2).forEach(function(prop) {
    var unit = "";
    if (["width", "height", "top", "right", "bottom", "left"].indexOf(prop) !== -1 && isNumeric(styles2[prop])) {
      unit = "px";
    }
    element.style[prop] = styles2[prop] + unit;
  });
}
function setAttributes(element, attributes) {
  Object.keys(attributes).forEach(function(prop) {
    var value = attributes[prop];
    if (value !== false) {
      element.setAttribute(prop, attributes[prop]);
    } else {
      element.removeAttribute(prop);
    }
  });
}
function applyStyle(data) {
  setStyles(data.instance.popper, data.styles);
  setAttributes(data.instance.popper, data.attributes);
  if (data.arrowElement && Object.keys(data.arrowStyles).length) {
    setStyles(data.arrowElement, data.arrowStyles);
  }
  return data;
}
function applyStyleOnLoad(reference, popper, options, modifierOptions, state) {
  var referenceOffsets = getReferenceOffsets(state, popper, reference, options.positionFixed);
  var placement = computeAutoPlacement(options.placement, referenceOffsets, popper, reference, options.modifiers.flip.boundariesElement, options.modifiers.flip.padding);
  popper.setAttribute("x-placement", placement);
  setStyles(popper, { position: options.positionFixed ? "fixed" : "absolute" });
  return options;
}
function getRoundedOffsets(data, shouldRound) {
  var _data$offsets = data.offsets, popper = _data$offsets.popper, reference = _data$offsets.reference;
  var round = Math.round, floor = Math.floor;
  var noRound = function noRound2(v2) {
    return v2;
  };
  var referenceWidth = round(reference.width);
  var popperWidth = round(popper.width);
  var isVertical = ["left", "right"].indexOf(data.placement) !== -1;
  var isVariation = data.placement.indexOf("-") !== -1;
  var sameWidthParity = referenceWidth % 2 === popperWidth % 2;
  var bothOddWidth = referenceWidth % 2 === 1 && popperWidth % 2 === 1;
  var horizontalToInteger = !shouldRound ? noRound : isVertical || isVariation || sameWidthParity ? round : floor;
  var verticalToInteger = !shouldRound ? noRound : round;
  return {
    left: horizontalToInteger(bothOddWidth && !isVariation && shouldRound ? popper.left - 1 : popper.left),
    top: verticalToInteger(popper.top),
    bottom: verticalToInteger(popper.bottom),
    right: horizontalToInteger(popper.right)
  };
}
var isFirefox = isBrowser && /Firefox/i.test(navigator.userAgent);
function computeStyle(data, options) {
  var x = options.x, y2 = options.y;
  var popper = data.offsets.popper;
  var legacyGpuAccelerationOption = find$1(data.instance.modifiers, function(modifier) {
    return modifier.name === "applyStyle";
  }).gpuAcceleration;
  if (legacyGpuAccelerationOption !== void 0) {
    console.warn("WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!");
  }
  var gpuAcceleration = legacyGpuAccelerationOption !== void 0 ? legacyGpuAccelerationOption : options.gpuAcceleration;
  var offsetParent = getOffsetParent(data.instance.popper);
  var offsetParentRect = getBoundingClientRect(offsetParent);
  var styles2 = {
    position: popper.position
  };
  var offsets = getRoundedOffsets(data, window.devicePixelRatio < 2 || !isFirefox);
  var sideA = x === "bottom" ? "top" : "bottom";
  var sideB = y2 === "right" ? "left" : "right";
  var prefixedProperty = getSupportedPropertyName("transform");
  var left = void 0, top = void 0;
  if (sideA === "bottom") {
    if (offsetParent.nodeName === "HTML") {
      top = -offsetParent.clientHeight + offsets.bottom;
    } else {
      top = -offsetParentRect.height + offsets.bottom;
    }
  } else {
    top = offsets.top;
  }
  if (sideB === "right") {
    if (offsetParent.nodeName === "HTML") {
      left = -offsetParent.clientWidth + offsets.right;
    } else {
      left = -offsetParentRect.width + offsets.right;
    }
  } else {
    left = offsets.left;
  }
  if (gpuAcceleration && prefixedProperty) {
    styles2[prefixedProperty] = "translate3d(" + left + "px, " + top + "px, 0)";
    styles2[sideA] = 0;
    styles2[sideB] = 0;
    styles2.willChange = "transform";
  } else {
    var invertTop = sideA === "bottom" ? -1 : 1;
    var invertLeft = sideB === "right" ? -1 : 1;
    styles2[sideA] = top * invertTop;
    styles2[sideB] = left * invertLeft;
    styles2.willChange = sideA + ", " + sideB;
  }
  var attributes = {
    "x-placement": data.placement
  };
  data.attributes = _extends({}, attributes, data.attributes);
  data.styles = _extends({}, styles2, data.styles);
  data.arrowStyles = _extends({}, data.offsets.arrow, data.arrowStyles);
  return data;
}
function isModifierRequired(modifiers2, requestingName, requestedName) {
  var requesting = find$1(modifiers2, function(_ref2) {
    var name2 = _ref2.name;
    return name2 === requestingName;
  });
  var isRequired = !!requesting && modifiers2.some(function(modifier) {
    return modifier.name === requestedName && modifier.enabled && modifier.order < requesting.order;
  });
  if (!isRequired) {
    var _requesting = "`" + requestingName + "`";
    var requested = "`" + requestedName + "`";
    console.warn(requested + " modifier is required by " + _requesting + " modifier in order to work, be sure to include it before " + _requesting + "!");
  }
  return isRequired;
}
function arrow(data, options) {
  var _data$offsets$arrow;
  if (!isModifierRequired(data.instance.modifiers, "arrow", "keepTogether")) {
    return data;
  }
  var arrowElement = options.element;
  if (typeof arrowElement === "string") {
    arrowElement = data.instance.popper.querySelector(arrowElement);
    if (!arrowElement) {
      return data;
    }
  } else {
    if (!data.instance.popper.contains(arrowElement)) {
      console.warn("WARNING: `arrow.element` must be child of its popper element!");
      return data;
    }
  }
  var placement = data.placement.split("-")[0];
  var _data$offsets = data.offsets, popper = _data$offsets.popper, reference = _data$offsets.reference;
  var isVertical = ["left", "right"].indexOf(placement) !== -1;
  var len = isVertical ? "height" : "width";
  var sideCapitalized = isVertical ? "Top" : "Left";
  var side = sideCapitalized.toLowerCase();
  var altSide = isVertical ? "left" : "top";
  var opSide = isVertical ? "bottom" : "right";
  var arrowElementSize = getOuterSizes(arrowElement)[len];
  if (reference[opSide] - arrowElementSize < popper[side]) {
    data.offsets.popper[side] -= popper[side] - (reference[opSide] - arrowElementSize);
  }
  if (reference[side] + arrowElementSize > popper[opSide]) {
    data.offsets.popper[side] += reference[side] + arrowElementSize - popper[opSide];
  }
  data.offsets.popper = getClientRect(data.offsets.popper);
  var center = reference[side] + reference[len] / 2 - arrowElementSize / 2;
  var css2 = getStyleComputedProperty(data.instance.popper);
  var popperMarginSide = parseFloat(css2["margin" + sideCapitalized]);
  var popperBorderSide = parseFloat(css2["border" + sideCapitalized + "Width"]);
  var sideValue = center - data.offsets.popper[side] - popperMarginSide - popperBorderSide;
  sideValue = Math.max(Math.min(popper[len] - arrowElementSize, sideValue), 0);
  data.arrowElement = arrowElement;
  data.offsets.arrow = (_data$offsets$arrow = {}, defineProperty$2(_data$offsets$arrow, side, Math.round(sideValue)), defineProperty$2(_data$offsets$arrow, altSide, ""), _data$offsets$arrow);
  return data;
}
function getOppositeVariation(variation) {
  if (variation === "end") {
    return "start";
  } else if (variation === "start") {
    return "end";
  }
  return variation;
}
var placements = ["auto-start", "auto", "auto-end", "top-start", "top", "top-end", "right-start", "right", "right-end", "bottom-end", "bottom", "bottom-start", "left-end", "left", "left-start"];
var validPlacements = placements.slice(3);
function clockwise(placement) {
  var counter2 = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : false;
  var index = validPlacements.indexOf(placement);
  var arr = validPlacements.slice(index + 1).concat(validPlacements.slice(0, index));
  return counter2 ? arr.reverse() : arr;
}
var BEHAVIORS = {
  FLIP: "flip",
  CLOCKWISE: "clockwise",
  COUNTERCLOCKWISE: "counterclockwise"
};
function flip(data, options) {
  if (isModifierEnabled(data.instance.modifiers, "inner")) {
    return data;
  }
  if (data.flipped && data.placement === data.originalPlacement) {
    return data;
  }
  var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, options.boundariesElement, data.positionFixed);
  var placement = data.placement.split("-")[0];
  var placementOpposite = getOppositePlacement(placement);
  var variation = data.placement.split("-")[1] || "";
  var flipOrder = [];
  switch (options.behavior) {
    case BEHAVIORS.FLIP:
      flipOrder = [placement, placementOpposite];
      break;
    case BEHAVIORS.CLOCKWISE:
      flipOrder = clockwise(placement);
      break;
    case BEHAVIORS.COUNTERCLOCKWISE:
      flipOrder = clockwise(placement, true);
      break;
    default:
      flipOrder = options.behavior;
  }
  flipOrder.forEach(function(step, index) {
    if (placement !== step || flipOrder.length === index + 1) {
      return data;
    }
    placement = data.placement.split("-")[0];
    placementOpposite = getOppositePlacement(placement);
    var popperOffsets = data.offsets.popper;
    var refOffsets = data.offsets.reference;
    var floor = Math.floor;
    var overlapsRef = placement === "left" && floor(popperOffsets.right) > floor(refOffsets.left) || placement === "right" && floor(popperOffsets.left) < floor(refOffsets.right) || placement === "top" && floor(popperOffsets.bottom) > floor(refOffsets.top) || placement === "bottom" && floor(popperOffsets.top) < floor(refOffsets.bottom);
    var overflowsLeft = floor(popperOffsets.left) < floor(boundaries.left);
    var overflowsRight = floor(popperOffsets.right) > floor(boundaries.right);
    var overflowsTop = floor(popperOffsets.top) < floor(boundaries.top);
    var overflowsBottom = floor(popperOffsets.bottom) > floor(boundaries.bottom);
    var overflowsBoundaries = placement === "left" && overflowsLeft || placement === "right" && overflowsRight || placement === "top" && overflowsTop || placement === "bottom" && overflowsBottom;
    var isVertical = ["top", "bottom"].indexOf(placement) !== -1;
    var flippedVariationByRef = !!options.flipVariations && (isVertical && variation === "start" && overflowsLeft || isVertical && variation === "end" && overflowsRight || !isVertical && variation === "start" && overflowsTop || !isVertical && variation === "end" && overflowsBottom);
    var flippedVariationByContent = !!options.flipVariationsByContent && (isVertical && variation === "start" && overflowsRight || isVertical && variation === "end" && overflowsLeft || !isVertical && variation === "start" && overflowsBottom || !isVertical && variation === "end" && overflowsTop);
    var flippedVariation = flippedVariationByRef || flippedVariationByContent;
    if (overlapsRef || overflowsBoundaries || flippedVariation) {
      data.flipped = true;
      if (overlapsRef || overflowsBoundaries) {
        placement = flipOrder[index + 1];
      }
      if (flippedVariation) {
        variation = getOppositeVariation(variation);
      }
      data.placement = placement + (variation ? "-" + variation : "");
      data.offsets.popper = _extends({}, data.offsets.popper, getPopperOffsets(data.instance.popper, data.offsets.reference, data.placement));
      data = runModifiers(data.instance.modifiers, data, "flip");
    }
  });
  return data;
}
function keepTogether(data) {
  var _data$offsets = data.offsets, popper = _data$offsets.popper, reference = _data$offsets.reference;
  var placement = data.placement.split("-")[0];
  var floor = Math.floor;
  var isVertical = ["top", "bottom"].indexOf(placement) !== -1;
  var side = isVertical ? "right" : "bottom";
  var opSide = isVertical ? "left" : "top";
  var measurement = isVertical ? "width" : "height";
  if (popper[side] < floor(reference[opSide])) {
    data.offsets.popper[opSide] = floor(reference[opSide]) - popper[measurement];
  }
  if (popper[opSide] > floor(reference[side])) {
    data.offsets.popper[opSide] = floor(reference[side]);
  }
  return data;
}
function toValue(str, measurement, popperOffsets, referenceOffsets) {
  var split = str.match(/((?:\-|\+)?\d*\.?\d*)(.*)/);
  var value = +split[1];
  var unit = split[2];
  if (!value) {
    return str;
  }
  if (unit.indexOf("%") === 0) {
    var element = void 0;
    switch (unit) {
      case "%p":
        element = popperOffsets;
        break;
      case "%":
      case "%r":
      default:
        element = referenceOffsets;
    }
    var rect = getClientRect(element);
    return rect[measurement] / 100 * value;
  } else if (unit === "vh" || unit === "vw") {
    var size = void 0;
    if (unit === "vh") {
      size = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
    } else {
      size = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
    }
    return size / 100 * value;
  } else {
    return value;
  }
}
function parseOffset(offset2, popperOffsets, referenceOffsets, basePlacement) {
  var offsets = [0, 0];
  var useHeight = ["right", "left"].indexOf(basePlacement) !== -1;
  var fragments = offset2.split(/(\+|\-)/).map(function(frag) {
    return frag.trim();
  });
  var divider = fragments.indexOf(find$1(fragments, function(frag) {
    return frag.search(/,|\s/) !== -1;
  }));
  if (fragments[divider] && fragments[divider].indexOf(",") === -1) {
    console.warn("Offsets separated by white space(s) are deprecated, use a comma (,) instead.");
  }
  var splitRegex = /\s*,\s*|\s+/;
  var ops = divider !== -1 ? [fragments.slice(0, divider).concat([fragments[divider].split(splitRegex)[0]]), [fragments[divider].split(splitRegex)[1]].concat(fragments.slice(divider + 1))] : [fragments];
  ops = ops.map(function(op, index) {
    var measurement = (index === 1 ? !useHeight : useHeight) ? "height" : "width";
    var mergeWithPrevious = false;
    return op.reduce(function(a, b2) {
      if (a[a.length - 1] === "" && ["+", "-"].indexOf(b2) !== -1) {
        a[a.length - 1] = b2;
        mergeWithPrevious = true;
        return a;
      } else if (mergeWithPrevious) {
        a[a.length - 1] += b2;
        mergeWithPrevious = false;
        return a;
      } else {
        return a.concat(b2);
      }
    }, []).map(function(str) {
      return toValue(str, measurement, popperOffsets, referenceOffsets);
    });
  });
  ops.forEach(function(op, index) {
    op.forEach(function(frag, index2) {
      if (isNumeric(frag)) {
        offsets[index] += frag * (op[index2 - 1] === "-" ? -1 : 1);
      }
    });
  });
  return offsets;
}
function offset(data, _ref2) {
  var offset2 = _ref2.offset;
  var placement = data.placement, _data$offsets = data.offsets, popper = _data$offsets.popper, reference = _data$offsets.reference;
  var basePlacement = placement.split("-")[0];
  var offsets = void 0;
  if (isNumeric(+offset2)) {
    offsets = [+offset2, 0];
  } else {
    offsets = parseOffset(offset2, popper, reference, basePlacement);
  }
  if (basePlacement === "left") {
    popper.top += offsets[0];
    popper.left -= offsets[1];
  } else if (basePlacement === "right") {
    popper.top += offsets[0];
    popper.left += offsets[1];
  } else if (basePlacement === "top") {
    popper.left += offsets[0];
    popper.top -= offsets[1];
  } else if (basePlacement === "bottom") {
    popper.left += offsets[0];
    popper.top += offsets[1];
  }
  data.popper = popper;
  return data;
}
function preventOverflow(data, options) {
  var boundariesElement = options.boundariesElement || getOffsetParent(data.instance.popper);
  if (data.instance.reference === boundariesElement) {
    boundariesElement = getOffsetParent(boundariesElement);
  }
  var transformProp = getSupportedPropertyName("transform");
  var popperStyles = data.instance.popper.style;
  var top = popperStyles.top, left = popperStyles.left, transform = popperStyles[transformProp];
  popperStyles.top = "";
  popperStyles.left = "";
  popperStyles[transformProp] = "";
  var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, boundariesElement, data.positionFixed);
  popperStyles.top = top;
  popperStyles.left = left;
  popperStyles[transformProp] = transform;
  options.boundaries = boundaries;
  var order = options.priority;
  var popper = data.offsets.popper;
  var check = {
    primary: function primary2(placement) {
      var value = popper[placement];
      if (popper[placement] < boundaries[placement] && !options.escapeWithReference) {
        value = Math.max(popper[placement], boundaries[placement]);
      }
      return defineProperty$2({}, placement, value);
    },
    secondary: function secondary2(placement) {
      var mainSide = placement === "right" ? "left" : "top";
      var value = popper[mainSide];
      if (popper[placement] > boundaries[placement] && !options.escapeWithReference) {
        value = Math.min(popper[mainSide], boundaries[placement] - (placement === "right" ? popper.width : popper.height));
      }
      return defineProperty$2({}, mainSide, value);
    }
  };
  order.forEach(function(placement) {
    var side = ["left", "top"].indexOf(placement) !== -1 ? "primary" : "secondary";
    popper = _extends({}, popper, check[side](placement));
  });
  data.offsets.popper = popper;
  return data;
}
function shift(data) {
  var placement = data.placement;
  var basePlacement = placement.split("-")[0];
  var shiftvariation = placement.split("-")[1];
  if (shiftvariation) {
    var _data$offsets = data.offsets, reference = _data$offsets.reference, popper = _data$offsets.popper;
    var isVertical = ["bottom", "top"].indexOf(basePlacement) !== -1;
    var side = isVertical ? "left" : "top";
    var measurement = isVertical ? "width" : "height";
    var shiftOffsets = {
      start: defineProperty$2({}, side, reference[side]),
      end: defineProperty$2({}, side, reference[side] + reference[measurement] - popper[measurement])
    };
    data.offsets.popper = _extends({}, popper, shiftOffsets[shiftvariation]);
  }
  return data;
}
function hide(data) {
  if (!isModifierRequired(data.instance.modifiers, "hide", "preventOverflow")) {
    return data;
  }
  var refRect = data.offsets.reference;
  var bound2 = find$1(data.instance.modifiers, function(modifier) {
    return modifier.name === "preventOverflow";
  }).boundaries;
  if (refRect.bottom < bound2.top || refRect.left > bound2.right || refRect.top > bound2.bottom || refRect.right < bound2.left) {
    if (data.hide === true) {
      return data;
    }
    data.hide = true;
    data.attributes["x-out-of-boundaries"] = "";
  } else {
    if (data.hide === false) {
      return data;
    }
    data.hide = false;
    data.attributes["x-out-of-boundaries"] = false;
  }
  return data;
}
function inner(data) {
  var placement = data.placement;
  var basePlacement = placement.split("-")[0];
  var _data$offsets = data.offsets, popper = _data$offsets.popper, reference = _data$offsets.reference;
  var isHoriz = ["left", "right"].indexOf(basePlacement) !== -1;
  var subtractLength = ["top", "left"].indexOf(basePlacement) === -1;
  popper[isHoriz ? "left" : "top"] = reference[basePlacement] - (subtractLength ? popper[isHoriz ? "width" : "height"] : 0);
  data.placement = getOppositePlacement(placement);
  data.offsets.popper = getClientRect(popper);
  return data;
}
var modifiers = {
  /**
   * Modifier used to shift the popper on the start or end of its reference
   * element.<br />
   * It will read the variation of the `placement` property.<br />
   * It can be one either `-end` or `-start`.
   * @memberof modifiers
   * @inner
   */
  shift: {
    /** @prop {number} order=100 - Index used to define the order of execution */
    order: 100,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: shift
  },
  /**
   * The `offset` modifier can shift your popper on both its axis.
   *
   * It accepts the following units:
   * - `px` or unit-less, interpreted as pixels
   * - `%` or `%r`, percentage relative to the length of the reference element
   * - `%p`, percentage relative to the length of the popper element
   * - `vw`, CSS viewport width unit
   * - `vh`, CSS viewport height unit
   *
   * For length is intended the main axis relative to the placement of the popper.<br />
   * This means that if the placement is `top` or `bottom`, the length will be the
   * `width`. In case of `left` or `right`, it will be the `height`.
   *
   * You can provide a single value (as `Number` or `String`), or a pair of values
   * as `String` divided by a comma or one (or more) white spaces.<br />
   * The latter is a deprecated method because it leads to confusion and will be
   * removed in v2.<br />
   * Additionally, it accepts additions and subtractions between different units.
   * Note that multiplications and divisions aren't supported.
   *
   * Valid examples are:
   * ```
   * 10
   * '10%'
   * '10, 10'
   * '10%, 10'
   * '10 + 10%'
   * '10 - 5vh + 3%'
   * '-10px + 5vh, 5px - 6%'
   * ```
   * > **NB**: If you desire to apply offsets to your poppers in a way that may make them overlap
   * > with their reference element, unfortunately, you will have to disable the `flip` modifier.
   * > You can read more on this at this [issue](https://github.com/FezVrasta/popper.js/issues/373).
   *
   * @memberof modifiers
   * @inner
   */
  offset: {
    /** @prop {number} order=200 - Index used to define the order of execution */
    order: 200,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: offset,
    /** @prop {Number|String} offset=0
     * The offset value as described in the modifier description
     */
    offset: 0
  },
  /**
   * Modifier used to prevent the popper from being positioned outside the boundary.
   *
   * A scenario exists where the reference itself is not within the boundaries.<br />
   * We can say it has "escaped the boundaries" — or just "escaped".<br />
   * In this case we need to decide whether the popper should either:
   *
   * - detach from the reference and remain "trapped" in the boundaries, or
   * - if it should ignore the boundary and "escape with its reference"
   *
   * When `escapeWithReference` is set to`true` and reference is completely
   * outside its boundaries, the popper will overflow (or completely leave)
   * the boundaries in order to remain attached to the edge of the reference.
   *
   * @memberof modifiers
   * @inner
   */
  preventOverflow: {
    /** @prop {number} order=300 - Index used to define the order of execution */
    order: 300,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: preventOverflow,
    /**
     * @prop {Array} [priority=['left','right','top','bottom']]
     * Popper will try to prevent overflow following these priorities by default,
     * then, it could overflow on the left and on top of the `boundariesElement`
     */
    priority: ["left", "right", "top", "bottom"],
    /**
     * @prop {number} padding=5
     * Amount of pixel used to define a minimum distance between the boundaries
     * and the popper. This makes sure the popper always has a little padding
     * between the edges of its container
     */
    padding: 5,
    /**
     * @prop {String|HTMLElement} boundariesElement='scrollParent'
     * Boundaries used by the modifier. Can be `scrollParent`, `window`,
     * `viewport` or any DOM element.
     */
    boundariesElement: "scrollParent"
  },
  /**
   * Modifier used to make sure the reference and its popper stay near each other
   * without leaving any gap between the two. Especially useful when the arrow is
   * enabled and you want to ensure that it points to its reference element.
   * It cares only about the first axis. You can still have poppers with margin
   * between the popper and its reference element.
   * @memberof modifiers
   * @inner
   */
  keepTogether: {
    /** @prop {number} order=400 - Index used to define the order of execution */
    order: 400,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: keepTogether
  },
  /**
   * This modifier is used to move the `arrowElement` of the popper to make
   * sure it is positioned between the reference element and its popper element.
   * It will read the outer size of the `arrowElement` node to detect how many
   * pixels of conjunction are needed.
   *
   * It has no effect if no `arrowElement` is provided.
   * @memberof modifiers
   * @inner
   */
  arrow: {
    /** @prop {number} order=500 - Index used to define the order of execution */
    order: 500,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: arrow,
    /** @prop {String|HTMLElement} element='[x-arrow]' - Selector or node used as arrow */
    element: "[x-arrow]"
  },
  /**
   * Modifier used to flip the popper's placement when it starts to overlap its
   * reference element.
   *
   * Requires the `preventOverflow` modifier before it in order to work.
   *
   * **NOTE:** this modifier will interrupt the current update cycle and will
   * restart it if it detects the need to flip the placement.
   * @memberof modifiers
   * @inner
   */
  flip: {
    /** @prop {number} order=600 - Index used to define the order of execution */
    order: 600,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: flip,
    /**
     * @prop {String|Array} behavior='flip'
     * The behavior used to change the popper's placement. It can be one of
     * `flip`, `clockwise`, `counterclockwise` or an array with a list of valid
     * placements (with optional variations)
     */
    behavior: "flip",
    /**
     * @prop {number} padding=5
     * The popper will flip if it hits the edges of the `boundariesElement`
     */
    padding: 5,
    /**
     * @prop {String|HTMLElement} boundariesElement='viewport'
     * The element which will define the boundaries of the popper position.
     * The popper will never be placed outside of the defined boundaries
     * (except if `keepTogether` is enabled)
     */
    boundariesElement: "viewport",
    /**
     * @prop {Boolean} flipVariations=false
     * The popper will switch placement variation between `-start` and `-end` when
     * the reference element overlaps its boundaries.
     *
     * The original placement should have a set variation.
     */
    flipVariations: false,
    /**
     * @prop {Boolean} flipVariationsByContent=false
     * The popper will switch placement variation between `-start` and `-end` when
     * the popper element overlaps its reference boundaries.
     *
     * The original placement should have a set variation.
     */
    flipVariationsByContent: false
  },
  /**
   * Modifier used to make the popper flow toward the inner of the reference element.
   * By default, when this modifier is disabled, the popper will be placed outside
   * the reference element.
   * @memberof modifiers
   * @inner
   */
  inner: {
    /** @prop {number} order=700 - Index used to define the order of execution */
    order: 700,
    /** @prop {Boolean} enabled=false - Whether the modifier is enabled or not */
    enabled: false,
    /** @prop {ModifierFn} */
    fn: inner
  },
  /**
   * Modifier used to hide the popper when its reference element is outside of the
   * popper boundaries. It will set a `x-out-of-boundaries` attribute which can
   * be used to hide with a CSS selector the popper when its reference is
   * out of boundaries.
   *
   * Requires the `preventOverflow` modifier before it in order to work.
   * @memberof modifiers
   * @inner
   */
  hide: {
    /** @prop {number} order=800 - Index used to define the order of execution */
    order: 800,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: hide
  },
  /**
   * Computes the style that will be applied to the popper element to gets
   * properly positioned.
   *
   * Note that this modifier will not touch the DOM, it just prepares the styles
   * so that `applyStyle` modifier can apply it. This separation is useful
   * in case you need to replace `applyStyle` with a custom implementation.
   *
   * This modifier has `850` as `order` value to maintain backward compatibility
   * with previous versions of Popper.js. Expect the modifiers ordering method
   * to change in future major versions of the library.
   *
   * @memberof modifiers
   * @inner
   */
  computeStyle: {
    /** @prop {number} order=850 - Index used to define the order of execution */
    order: 850,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: computeStyle,
    /**
     * @prop {Boolean} gpuAcceleration=true
     * If true, it uses the CSS 3D transformation to position the popper.
     * Otherwise, it will use the `top` and `left` properties
     */
    gpuAcceleration: true,
    /**
     * @prop {string} [x='bottom']
     * Where to anchor the X axis (`bottom` or `top`). AKA X offset origin.
     * Change this if your popper should grow in a direction different from `bottom`
     */
    x: "bottom",
    /**
     * @prop {string} [x='left']
     * Where to anchor the Y axis (`left` or `right`). AKA Y offset origin.
     * Change this if your popper should grow in a direction different from `right`
     */
    y: "right"
  },
  /**
   * Applies the computed styles to the popper element.
   *
   * All the DOM manipulations are limited to this modifier. This is useful in case
   * you want to integrate Popper.js inside a framework or view library and you
   * want to delegate all the DOM manipulations to it.
   *
   * Note that if you disable this modifier, you must make sure the popper element
   * has its position set to `absolute` before Popper.js can do its work!
   *
   * Just disable this modifier and define your own to achieve the desired effect.
   *
   * @memberof modifiers
   * @inner
   */
  applyStyle: {
    /** @prop {number} order=900 - Index used to define the order of execution */
    order: 900,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: applyStyle,
    /** @prop {Function} */
    onLoad: applyStyleOnLoad,
    /**
     * @deprecated since version 1.10.0, the property moved to `computeStyle` modifier
     * @prop {Boolean} gpuAcceleration=true
     * If true, it uses the CSS 3D transformation to position the popper.
     * Otherwise, it will use the `top` and `left` properties
     */
    gpuAcceleration: void 0
  }
};
var Defaults = {
  /**
   * Popper's placement.
   * @prop {Popper.placements} placement='bottom'
   */
  placement: "bottom",
  /**
   * Set this to true if you want popper to position it self in 'fixed' mode
   * @prop {Boolean} positionFixed=false
   */
  positionFixed: false,
  /**
   * Whether events (resize, scroll) are initially enabled.
   * @prop {Boolean} eventsEnabled=true
   */
  eventsEnabled: true,
  /**
   * Set to true if you want to automatically remove the popper when
   * you call the `destroy` method.
   * @prop {Boolean} removeOnDestroy=false
   */
  removeOnDestroy: false,
  /**
   * Callback called when the popper is created.<br />
   * By default, it is set to no-op.<br />
   * Access Popper.js instance with `data.instance`.
   * @prop {onCreate}
   */
  onCreate: function onCreate() {
  },
  /**
   * Callback called when the popper is updated. This callback is not called
   * on the initialization/creation of the popper, but only on subsequent
   * updates.<br />
   * By default, it is set to no-op.<br />
   * Access Popper.js instance with `data.instance`.
   * @prop {onUpdate}
   */
  onUpdate: function onUpdate() {
  },
  /**
   * List of modifiers used to modify the offsets before they are applied to the popper.
   * They provide most of the functionalities of Popper.js.
   * @prop {modifiers}
   */
  modifiers
};
var Popper$3 = function() {
  function Popper2(reference, popper) {
    var _this = this;
    var options = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
    classCallCheck(this, Popper2);
    this.scheduleUpdate = function() {
      return requestAnimationFrame(_this.update);
    };
    this.update = debounce$1(this.update.bind(this));
    this.options = _extends({}, Popper2.Defaults, options);
    this.state = {
      isDestroyed: false,
      isCreated: false,
      scrollParents: []
    };
    this.reference = reference && reference.jquery ? reference[0] : reference;
    this.popper = popper && popper.jquery ? popper[0] : popper;
    this.options.modifiers = {};
    Object.keys(_extends({}, Popper2.Defaults.modifiers, options.modifiers)).forEach(function(name2) {
      _this.options.modifiers[name2] = _extends({}, Popper2.Defaults.modifiers[name2] || {}, options.modifiers ? options.modifiers[name2] : {});
    });
    this.modifiers = Object.keys(this.options.modifiers).map(function(name2) {
      return _extends({
        name: name2
      }, _this.options.modifiers[name2]);
    }).sort(function(a, b2) {
      return a.order - b2.order;
    });
    this.modifiers.forEach(function(modifierOptions) {
      if (modifierOptions.enabled && isFunction$1(modifierOptions.onLoad)) {
        modifierOptions.onLoad(_this.reference, _this.popper, _this.options, modifierOptions, _this.state);
      }
    });
    this.update();
    var eventsEnabled = this.options.eventsEnabled;
    if (eventsEnabled) {
      this.enableEventListeners();
    }
    this.state.eventsEnabled = eventsEnabled;
  }
  createClass(Popper2, [{
    key: "update",
    value: function update$$1() {
      return update.call(this);
    }
  }, {
    key: "destroy",
    value: function destroy$$1() {
      return destroy.call(this);
    }
  }, {
    key: "enableEventListeners",
    value: function enableEventListeners$$1() {
      return enableEventListeners.call(this);
    }
  }, {
    key: "disableEventListeners",
    value: function disableEventListeners$$1() {
      return disableEventListeners.call(this);
    }
    /**
     * Schedules an update. It will run on the next UI update available.
     * @method scheduleUpdate
     * @memberof Popper
     */
    /**
     * Collection of utilities useful when writing custom modifiers.
     * Starting from version 1.7, this method is available only if you
     * include `popper-utils.js` before `popper.js`.
     *
     * **DEPRECATION**: This way to access PopperUtils is deprecated
     * and will be removed in v2! Use the PopperUtils module directly instead.
     * Due to the high instability of the methods contained in Utils, we can't
     * guarantee them to follow semver. Use them at your own risk!
     * @static
     * @private
     * @type {Object}
     * @deprecated since version 1.8
     * @member Utils
     * @memberof Popper
     */
  }]);
  return Popper2;
}();
Popper$3.Utils = (typeof window !== "undefined" ? window : global).PopperUtils;
Popper$3.placements = placements;
Popper$3.Defaults = Defaults;
const PopperJs = Popper$3;
var jsxRuntimeExports = {};
var jsxRuntime = {
  get exports() {
    return jsxRuntimeExports;
  },
  set exports(v2) {
    jsxRuntimeExports = v2;
  }
};
var reactJsxRuntime_production_min = {};
/*
object-assign
(c) Sindre Sorhus
@license MIT
*/
var getOwnPropertySymbols = Object.getOwnPropertySymbols;
var hasOwnProperty$2 = Object.prototype.hasOwnProperty;
var propIsEnumerable = Object.prototype.propertyIsEnumerable;
function toObject$1(val) {
  if (val === null || val === void 0) {
    throw new TypeError("Object.assign cannot be called with null or undefined");
  }
  return Object(val);
}
function shouldUseNative() {
  try {
    if (!Object.assign) {
      return false;
    }
    var test1 = new String("abc");
    test1[5] = "de";
    if (Object.getOwnPropertyNames(test1)[0] === "5") {
      return false;
    }
    var test2 = {};
    for (var i = 0; i < 10; i++) {
      test2["_" + String.fromCharCode(i)] = i;
    }
    var order2 = Object.getOwnPropertyNames(test2).map(function(n2) {
      return test2[n2];
    });
    if (order2.join("") !== "0123456789") {
      return false;
    }
    var test3 = {};
    "abcdefghijklmnopqrst".split("").forEach(function(letter) {
      test3[letter] = letter;
    });
    if (Object.keys(Object.assign({}, test3)).join("") !== "abcdefghijklmnopqrst") {
      return false;
    }
    return true;
  } catch (err) {
    return false;
  }
}
shouldUseNative() ? Object.assign : function(target, source) {
  var from;
  var to = toObject$1(target);
  var symbols;
  for (var s = 1; s < arguments.length; s++) {
    from = Object(arguments[s]);
    for (var key in from) {
      if (hasOwnProperty$2.call(from, key)) {
        to[key] = from[key];
      }
    }
    if (getOwnPropertySymbols) {
      symbols = getOwnPropertySymbols(from);
      for (var i = 0; i < symbols.length; i++) {
        if (propIsEnumerable.call(from, symbols[i])) {
          to[symbols[i]] = from[symbols[i]];
        }
      }
    }
  }
  return to;
};
/** @license React v17.0.2
 * react-jsx-runtime.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var f$1 = React, g$3 = 60103;
reactJsxRuntime_production_min.Fragment = 60107;
if ("function" === typeof Symbol && Symbol.for) {
  var h$1 = Symbol.for;
  g$3 = h$1("react.element");
  reactJsxRuntime_production_min.Fragment = h$1("react.fragment");
}
var m$1 = f$1.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner, n$1 = Object.prototype.hasOwnProperty, p$1 = { key: true, ref: true, __self: true, __source: true };
function q$1(c2, a, k2) {
  var b2, d2 = {}, e2 = null, l2 = null;
  void 0 !== k2 && (e2 = "" + k2);
  void 0 !== a.key && (e2 = "" + a.key);
  void 0 !== a.ref && (l2 = a.ref);
  for (b2 in a)
    n$1.call(a, b2) && !p$1.hasOwnProperty(b2) && (d2[b2] = a[b2]);
  if (c2 && c2.defaultProps)
    for (b2 in a = c2.defaultProps, a)
      void 0 === d2[b2] && (d2[b2] = a[b2]);
  return { $$typeof: g$3, type: c2, key: e2, ref: l2, props: d2, _owner: m$1.current };
}
reactJsxRuntime_production_min.jsx = q$1;
reactJsxRuntime_production_min.jsxs = q$1;
(function(module2) {
  {
    module2.exports = reactJsxRuntime_production_min;
  }
})(jsxRuntime);
var ERROR$4 = 0;
var WARN$4 = 1;
var INFO$4 = 2;
var DEBUG$4 = 3;
var DEBUG2$4 = 4;
function _defineProperty$L(obj, key, value) {
  key = _toPropertyKey$L(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey$L(arg) {
  var key = _toPrimitive$L(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}
function _toPrimitive$L(input, hint) {
  if (typeof input !== "object" || input === null)
    return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object")
      return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
var silent$4 = () => void 0;
let Logger$8 = class Logger {
  constructor(name2, level) {
    _defineProperty$L(this, "name", void 0);
    _defineProperty$L(this, "prefix", void 0);
    _defineProperty$L(this, "level", void 0);
    _defineProperty$L(this, "error", void 0);
    _defineProperty$L(this, "warn", void 0);
    _defineProperty$L(this, "log", void 0);
    _defineProperty$L(this, "info", void 0);
    _defineProperty$L(this, "debug", void 0);
    _defineProperty$L(this, "debug2", void 0);
    this.name = name2;
    this.prefix = name2 != null ? "[".concat(name2, "]") : "";
    this.error = silent$4;
    this.warn = silent$4;
    this.log = silent$4;
    this.info = silent$4;
    this.debug = silent$4;
    this.debug2 = silent$4;
    this.level = level;
    this.setLogLevel(level);
  }
  setLogLevel(level) {
    if (!Number.isFinite(level)) {
      console.warn("Expected a number for log level. Received: ".concat(level, ". Ignoring"));
      return;
    }
    this.level = level;
    this.error = level >= ERROR$4 ? console.error.bind(console, this.prefix) : silent$4;
    this.warn = level >= WARN$4 ? console.warn.bind(console, this.prefix) : silent$4;
    this.log = level >= INFO$4 ? console.log.bind(console, this.prefix) : silent$4;
    this.info = this.log;
    this.debug = level >= DEBUG$4 ? console.debug.bind(console, this.prefix) : silent$4;
    this.debug2 = level >= DEBUG2$4 ? console.debug.bind(console, this.prefix) : silent$4;
  }
};
const Logger$9 = Logger$8;
function _defineProperty$K(obj, key, value) {
  key = _toPropertyKey$K(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey$K(arg) {
  var key = _toPrimitive$K(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}
function _toPrimitive$K(input, hint) {
  if (typeof input !== "object" || input === null)
    return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object")
      return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
let DefaultLogger$8 = class DefaultLogger extends Logger$9 {
  constructor() {
    var level = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : INFO$4;
    super(null, level);
    _defineProperty$K(this, "modules", void 0);
    this.modules = {};
  }
  module(name2) {
    if (this.modules[name2] == null) {
      this.modules[name2] = new Logger$9(name2, this.level);
    }
    return this.modules[name2];
  }
  setLogLevel(level) {
    super.setLogLevel(level);
    if (this.modules == null) {
      return;
    }
    var keys3 = Object.keys(this.modules);
    for (var i = 0; i < keys3.length; i += 1) {
      this.modules[keys3[i]].setLogLevel(level);
    }
  }
};
const DefaultLogger$9 = DefaultLogger$8;
var Log$8 = new DefaultLogger$9();
const Log$9 = Log$8;
function asyncGeneratorStep$2(gen, resolve, reject, _next, _throw, key, arg) {
  try {
    var info2 = gen[key](arg);
    var value = info2.value;
  } catch (error) {
    reject(error);
    return;
  }
  if (info2.done) {
    resolve(value);
  } else {
    Promise.resolve(value).then(_next, _throw);
  }
}
function _asyncToGenerator$2(fn) {
  return function() {
    var self2 = this, args = arguments;
    return new Promise(function(resolve, reject) {
      var gen = fn.apply(self2, args);
      function _next(value) {
        asyncGeneratorStep$2(gen, resolve, reject, _next, _throw, "next", value);
      }
      function _throw(err) {
        asyncGeneratorStep$2(gen, resolve, reject, _next, _throw, "throw", err);
      }
      _next(void 0);
    });
  };
}
function copyToClipboard$1(_x) {
  return _copyToClipboard$1.apply(this, arguments);
}
function _copyToClipboard$1() {
  _copyToClipboard$1 = _asyncToGenerator$2(function* (text) {
    var {
      clipboard
    } = navigator;
    if (clipboard !== void 0) {
      try {
        return navigator.clipboard.writeText(text);
      } catch (_unused) {
        return copyToClipboardExecCommand$1(text);
      }
    }
    copyToClipboardExecCommand$1(text);
  });
  return _copyToClipboard$1.apply(this, arguments);
}
function copyToClipboardExecCommand$1(text) {
  var oldFocus = document.activeElement;
  var textArea = document.createElement("textarea");
  textArea.value = text;
  document.body.appendChild(textArea);
  textArea.focus();
  textArea.select();
  var result = document.execCommand("copy");
  document.body.removeChild(textArea);
  if (oldFocus instanceof HTMLElement) {
    oldFocus.focus();
  }
  if (!result)
    throw new Error("Unable to execute copy command");
}
var ERROR$3 = 0;
var WARN$3 = 1;
var INFO$3 = 2;
var DEBUG$3 = 3;
var DEBUG2$3 = 4;
function _defineProperty$J(obj, key, value) {
  key = _toPropertyKey$J(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey$J(arg) {
  var key = _toPrimitive$J(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}
function _toPrimitive$J(input, hint) {
  if (typeof input !== "object" || input === null)
    return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object")
      return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
var silent$3 = () => void 0;
let Logger$6 = class Logger2 {
  constructor(name2, level) {
    _defineProperty$J(this, "name", void 0);
    _defineProperty$J(this, "prefix", void 0);
    _defineProperty$J(this, "level", void 0);
    _defineProperty$J(this, "error", void 0);
    _defineProperty$J(this, "warn", void 0);
    _defineProperty$J(this, "log", void 0);
    _defineProperty$J(this, "info", void 0);
    _defineProperty$J(this, "debug", void 0);
    _defineProperty$J(this, "debug2", void 0);
    this.name = name2;
    this.prefix = name2 != null ? "[".concat(name2, "]") : "";
    this.error = silent$3;
    this.warn = silent$3;
    this.log = silent$3;
    this.info = silent$3;
    this.debug = silent$3;
    this.debug2 = silent$3;
    this.level = level;
    this.setLogLevel(level);
  }
  setLogLevel(level) {
    if (!Number.isFinite(level)) {
      console.warn("Expected a number for log level. Received: ".concat(level, ". Ignoring"));
      return;
    }
    this.level = level;
    this.error = level >= ERROR$3 ? console.error.bind(console, this.prefix) : silent$3;
    this.warn = level >= WARN$3 ? console.warn.bind(console, this.prefix) : silent$3;
    this.log = level >= INFO$3 ? console.log.bind(console, this.prefix) : silent$3;
    this.info = this.log;
    this.debug = level >= DEBUG$3 ? console.debug.bind(console, this.prefix) : silent$3;
    this.debug2 = level >= DEBUG2$3 ? console.debug.bind(console, this.prefix) : silent$3;
  }
};
const Logger$7 = Logger$6;
function _defineProperty$I(obj, key, value) {
  key = _toPropertyKey$I(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey$I(arg) {
  var key = _toPrimitive$I(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}
function _toPrimitive$I(input, hint) {
  if (typeof input !== "object" || input === null)
    return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object")
      return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
let DefaultLogger$6 = class DefaultLogger2 extends Logger$7 {
  constructor() {
    var level = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : INFO$3;
    super(null, level);
    _defineProperty$I(this, "modules", void 0);
    this.modules = {};
  }
  module(name2) {
    if (this.modules[name2] == null) {
      this.modules[name2] = new Logger$7(name2, this.level);
    }
    return this.modules[name2];
  }
  setLogLevel(level) {
    super.setLogLevel(level);
    if (this.modules == null) {
      return;
    }
    var keys3 = Object.keys(this.modules);
    for (var i = 0; i < keys3.length; i += 1) {
      this.modules[keys3[i]].setLogLevel(level);
    }
  }
};
const DefaultLogger$7 = DefaultLogger$6;
var Log$6 = new DefaultLogger$7();
const Log$7 = Log$6;
var FUNC_ERROR_TEXT = "Expected a function";
var NAN$1 = 0 / 0;
var symbolTag$1 = "[object Symbol]";
var reTrim$1 = /^\s+|\s+$/g;
var reIsBadHex$1 = /^[-+]0x[0-9a-f]+$/i;
var reIsBinary$1 = /^0b[01]+$/i;
var reIsOctal$1 = /^0o[0-7]+$/i;
var freeParseInt$1 = parseInt;
var freeGlobal$1 = typeof commonjsGlobal == "object" && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
var freeSelf$1 = typeof self == "object" && self && self.Object === Object && self;
var root = freeGlobal$1 || freeSelf$1 || Function("return this")();
var objectProto$1 = Object.prototype;
var objectToString$2 = objectProto$1.toString;
var nativeMax = Math.max, nativeMin = Math.min;
var now = function() {
  return root.Date.now();
};
function debounce(func, wait, options) {
  var lastArgs, lastThis, maxWait, result, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
  if (typeof func != "function") {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  wait = toNumber$1(wait) || 0;
  if (isObject$1(options)) {
    leading = !!options.leading;
    maxing = "maxWait" in options;
    maxWait = maxing ? nativeMax(toNumber$1(options.maxWait) || 0, wait) : maxWait;
    trailing = "trailing" in options ? !!options.trailing : trailing;
  }
  function invokeFunc(time) {
    var args = lastArgs, thisArg = lastThis;
    lastArgs = lastThis = void 0;
    lastInvokeTime = time;
    result = func.apply(thisArg, args);
    return result;
  }
  function leadingEdge(time) {
    lastInvokeTime = time;
    timerId = setTimeout(timerExpired, wait);
    return leading ? invokeFunc(time) : result;
  }
  function remainingWait(time) {
    var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, result2 = wait - timeSinceLastCall;
    return maxing ? nativeMin(result2, maxWait - timeSinceLastInvoke) : result2;
  }
  function shouldInvoke(time) {
    var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime;
    return lastCallTime === void 0 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
  }
  function timerExpired() {
    var time = now();
    if (shouldInvoke(time)) {
      return trailingEdge(time);
    }
    timerId = setTimeout(timerExpired, remainingWait(time));
  }
  function trailingEdge(time) {
    timerId = void 0;
    if (trailing && lastArgs) {
      return invokeFunc(time);
    }
    lastArgs = lastThis = void 0;
    return result;
  }
  function cancel() {
    if (timerId !== void 0) {
      clearTimeout(timerId);
    }
    lastInvokeTime = 0;
    lastArgs = lastCallTime = lastThis = timerId = void 0;
  }
  function flush() {
    return timerId === void 0 ? result : trailingEdge(now());
  }
  function debounced() {
    var time = now(), isInvoking = shouldInvoke(time);
    lastArgs = arguments;
    lastThis = this;
    lastCallTime = time;
    if (isInvoking) {
      if (timerId === void 0) {
        return leadingEdge(lastCallTime);
      }
      if (maxing) {
        timerId = setTimeout(timerExpired, wait);
        return invokeFunc(lastCallTime);
      }
    }
    if (timerId === void 0) {
      timerId = setTimeout(timerExpired, wait);
    }
    return result;
  }
  debounced.cancel = cancel;
  debounced.flush = flush;
  return debounced;
}
function isObject$1(value) {
  var type = typeof value;
  return !!value && (type == "object" || type == "function");
}
function isObjectLike$1(value) {
  return !!value && typeof value == "object";
}
function isSymbol$4(value) {
  return typeof value == "symbol" || isObjectLike$1(value) && objectToString$2.call(value) == symbolTag$1;
}
function toNumber$1(value) {
  if (typeof value == "number") {
    return value;
  }
  if (isSymbol$4(value)) {
    return NAN$1;
  }
  if (isObject$1(value)) {
    var other = typeof value.valueOf == "function" ? value.valueOf() : value;
    value = isObject$1(other) ? other + "" : other;
  }
  if (typeof value != "string") {
    return value === 0 ? value : +value;
  }
  value = value.replace(reTrim$1, "");
  var isBinary = reIsBinary$1.test(value);
  return isBinary || reIsOctal$1.test(value) ? freeParseInt$1(value.slice(2), isBinary ? 2 : 8) : reIsBadHex$1.test(value) ? NAN$1 : +value;
}
var lodash_debounce = debounce;
var TIMEOUT_DELAY = 3500;
var log$d = Log$7.module("useCopyToClipboard");
function useCopyToClipboard() {
  var [copied, setCopied] = React.useState(false);
  var copiedTimeout = React.useRef(null);
  var copy = React.useCallback((value) => {
    copyToClipboard$1(value).then(() => {
      setCopied(true);
    }).catch((e2) => log$d.error("Unable to copy ".concat(value), "\n", e2));
  }, []);
  React.useEffect(() => {
    if (copiedTimeout.current)
      clearTimeout(copiedTimeout.current);
    if (copied) {
      copiedTimeout.current = setTimeout(() => {
        setCopied(false);
      }, TIMEOUT_DELAY);
    }
    return () => {
      if (copiedTimeout.current)
        clearTimeout(copiedTimeout.current);
    };
  }, [copied]);
  return [copied, copy];
}
var shortidExports = {};
var shortid$1 = {
  get exports() {
    return shortidExports;
  },
  set exports(v2) {
    shortidExports = v2;
  }
};
var libExports = {};
var lib = {
  get exports() {
    return libExports;
  },
  set exports(v2) {
    libExports = v2;
  }
};
var seed = 1;
function getNextValue() {
  seed = (seed * 9301 + 49297) % 233280;
  return seed / 233280;
}
function setSeed$1(_seed_) {
  seed = _seed_;
}
var randomFromSeed$1 = {
  nextValue: getNextValue,
  seed: setSeed$1
};
var randomFromSeed = randomFromSeed$1;
var ORIGINAL = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-";
var alphabet$2;
var previousSeed;
var shuffled;
function reset() {
  shuffled = false;
}
function setCharacters(_alphabet_) {
  if (!_alphabet_) {
    if (alphabet$2 !== ORIGINAL) {
      alphabet$2 = ORIGINAL;
      reset();
    }
    return;
  }
  if (_alphabet_ === alphabet$2) {
    return;
  }
  if (_alphabet_.length !== ORIGINAL.length) {
    throw new Error("Custom alphabet for shortid must be " + ORIGINAL.length + " unique characters. You submitted " + _alphabet_.length + " characters: " + _alphabet_);
  }
  var unique = _alphabet_.split("").filter(function(item, ind, arr) {
    return ind !== arr.lastIndexOf(item);
  });
  if (unique.length) {
    throw new Error("Custom alphabet for shortid must be " + ORIGINAL.length + " unique characters. These characters were not unique: " + unique.join(", "));
  }
  alphabet$2 = _alphabet_;
  reset();
}
function characters(_alphabet_) {
  setCharacters(_alphabet_);
  return alphabet$2;
}
function setSeed(seed2) {
  randomFromSeed.seed(seed2);
  if (previousSeed !== seed2) {
    reset();
    previousSeed = seed2;
  }
}
function shuffle() {
  if (!alphabet$2) {
    setCharacters(ORIGINAL);
  }
  var sourceArray = alphabet$2.split("");
  var targetArray = [];
  var r2 = randomFromSeed.nextValue();
  var characterIndex;
  while (sourceArray.length > 0) {
    r2 = randomFromSeed.nextValue();
    characterIndex = Math.floor(r2 * sourceArray.length);
    targetArray.push(sourceArray.splice(characterIndex, 1)[0]);
  }
  return targetArray.join("");
}
function getShuffled() {
  if (shuffled) {
    return shuffled;
  }
  shuffled = shuffle();
  return shuffled;
}
function lookup(index) {
  var alphabetShuffled = getShuffled();
  return alphabetShuffled[index];
}
function get2() {
  return alphabet$2 || ORIGINAL;
}
var alphabet_1 = {
  get: get2,
  characters,
  seed: setSeed,
  lookup,
  shuffled: getShuffled
};
var crypto$1 = typeof window === "object" && (window.crypto || window.msCrypto);
var randomByte;
if (!crypto$1 || !crypto$1.getRandomValues) {
  randomByte = function(size) {
    var bytes = [];
    for (var i = 0; i < size; i++) {
      bytes.push(Math.floor(Math.random() * 256));
    }
    return bytes;
  };
} else {
  randomByte = function(size) {
    return crypto$1.getRandomValues(new Uint8Array(size));
  };
}
var randomByteBrowser = randomByte;
var format_browser = function(random2, alphabet2, size) {
  var mask = (2 << Math.log(alphabet2.length - 1) / Math.LN2) - 1;
  var step = -~(1.6 * mask * size / alphabet2.length);
  var id = "";
  while (true) {
    var bytes = random2(step);
    var i = step;
    while (i--) {
      id += alphabet2[bytes[i] & mask] || "";
      if (id.length === +size)
        return id;
    }
  }
};
var alphabet$1 = alphabet_1;
var random = randomByteBrowser;
var format = format_browser;
function generate$1(number) {
  var loopCounter = 0;
  var done;
  var str = "";
  while (!done) {
    str = str + format(random, alphabet$1.get(), 1);
    done = number < Math.pow(16, loopCounter + 1);
    loopCounter++;
  }
  return str;
}
var generate_1 = generate$1;
var generate = generate_1;
var REDUCE_TIME = 1567752802062;
var version = 7;
var counter;
var previousSeconds;
function build2(clusterWorkerId) {
  var str = "";
  var seconds = Math.floor((Date.now() - REDUCE_TIME) * 1e-3);
  if (seconds === previousSeconds) {
    counter++;
  } else {
    counter = 0;
    previousSeconds = seconds;
  }
  str = str + generate(version);
  str = str + generate(clusterWorkerId);
  if (counter > 0) {
    str = str + generate(counter);
  }
  str = str + generate(seconds);
  return str;
}
var build_1 = build2;
var alphabet = alphabet_1;
function isShortId(id) {
  if (!id || typeof id !== "string" || id.length < 6) {
    return false;
  }
  var nonAlphabetic = new RegExp("[^" + alphabet.get().replace(/[|\\{}()[\]^$+*?.-]/g, "\\$&") + "]");
  return !nonAlphabetic.test(id);
}
var isValid = isShortId;
(function(module2) {
  var alphabet2 = alphabet_1;
  var build3 = build_1;
  var isValid$1 = isValid;
  var clusterWorkerId = 0;
  function seed2(seedValue) {
    alphabet2.seed(seedValue);
    return module2.exports;
  }
  function worker(workerId) {
    clusterWorkerId = workerId;
    return module2.exports;
  }
  function characters2(newCharacters) {
    if (newCharacters !== void 0) {
      alphabet2.characters(newCharacters);
    }
    return alphabet2.shuffled();
  }
  function generate2() {
    return build3(clusterWorkerId);
  }
  module2.exports = generate2;
  module2.exports.generate = generate2;
  module2.exports.seed = seed2;
  module2.exports.worker = worker;
  module2.exports.characters = characters2;
  module2.exports.isValid = isValid$1;
})(lib);
(function(module2) {
  module2.exports = libExports;
})(shortid$1);
const shortid = /* @__PURE__ */ getDefaultExportFromCjs(shortidExports);
var safeIsNaN = Number.isNaN || function ponyfill(value) {
  return typeof value === "number" && value !== value;
};
function isEqual(first, second) {
  if (first === second) {
    return true;
  }
  if (safeIsNaN(first) && safeIsNaN(second)) {
    return true;
  }
  return false;
}
function areInputsEqual(newInputs, lastInputs) {
  if (newInputs.length !== lastInputs.length) {
    return false;
  }
  for (var i = 0; i < newInputs.length; i++) {
    if (!isEqual(newInputs[i], lastInputs[i])) {
      return false;
    }
  }
  return true;
}
function memoizeOne(resultFn, isEqual2) {
  if (isEqual2 === void 0) {
    isEqual2 = areInputsEqual;
  }
  var lastThis;
  var lastArgs = [];
  var lastResult;
  var calledOnce = false;
  function memoized() {
    var newArgs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
      newArgs[_i] = arguments[_i];
    }
    if (calledOnce && lastThis === this && isEqual2(newArgs, lastArgs)) {
      return lastResult;
    }
    lastResult = resultFn.apply(this, newArgs);
    calledOnce = true;
    lastThis = this;
    lastArgs = newArgs;
    return lastResult;
  }
  return memoized;
}
var NAN = 0 / 0;
var symbolTag = "[object Symbol]";
var reTrim = /^\s+|\s+$/g;
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
var reIsBinary = /^0b[01]+$/i;
var reIsOctal = /^0o[0-7]+$/i;
var freeParseInt = parseInt;
var objectProto = Object.prototype;
var objectToString$1 = objectProto.toString;
function baseClamp(number, lower, upper) {
  if (number === number) {
    if (upper !== void 0) {
      number = number <= upper ? number : upper;
    }
    if (lower !== void 0) {
      number = number >= lower ? number : lower;
    }
  }
  return number;
}
function isObject(value) {
  var type = typeof value;
  return !!value && (type == "object" || type == "function");
}
function isObjectLike(value) {
  return !!value && typeof value == "object";
}
function isSymbol$3(value) {
  return typeof value == "symbol" || isObjectLike(value) && objectToString$1.call(value) == symbolTag;
}
function toNumber(value) {
  if (typeof value == "number") {
    return value;
  }
  if (isSymbol$3(value)) {
    return NAN;
  }
  if (isObject(value)) {
    var other = typeof value.valueOf == "function" ? value.valueOf() : value;
    value = isObject(other) ? other + "" : other;
  }
  if (typeof value != "string") {
    return value === 0 ? value : +value;
  }
  value = value.replace(reTrim, "");
  var isBinary = reIsBinary.test(value);
  return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
}
function clamp(number, lower, upper) {
  if (upper === void 0) {
    upper = lower;
    lower = void 0;
  }
  if (upper !== void 0) {
    upper = toNumber(upper);
    upper = upper === upper ? upper : 0;
  }
  if (lower !== void 0) {
    lower = toNumber(lower);
    lower = lower === lower ? lower : 0;
  }
  return baseClamp(toNumber(number), lower, upper);
}
var lodash_clamp = clamp;
Log$9.module("@deephaven/plugin.PluginUtils");
var plotly_minExports = {};
var plotly_min = {
  get exports() {
    return plotly_minExports;
  },
  set exports(v2) {
    plotly_minExports = v2;
  }
};
(function(module2, exports2) {
  /*! For license information please see plotly.min.js.LICENSE.txt */
  !function(t, e2) {
    module2.exports = e2();
  }(self, function() {
    return function() {
      var t = { 79288: function(t2, e3, r3) {
        var n2 = r3(3400), i = { "X,X div": 'direction:ltr;font-family:"Open Sans",verdana,arial,sans-serif;margin:0;padding:0;', "X input,X button": 'font-family:"Open Sans",verdana,arial,sans-serif;', "X input:focus,X button:focus": "outline:none;", "X a": "text-decoration:none;", "X a:hover": "text-decoration:none;", "X .crisp": "shape-rendering:crispEdges;", "X .user-select-none": "-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;-o-user-select:none;user-select:none;", "X svg": "overflow:hidden;", "X svg a": "fill:#447adb;", "X svg a:hover": "fill:#3c6dc5;", "X .main-svg": "position:absolute;top:0;left:0;pointer-events:none;", "X .main-svg .draglayer": "pointer-events:all;", "X .cursor-default": "cursor:default;", "X .cursor-pointer": "cursor:pointer;", "X .cursor-crosshair": "cursor:crosshair;", "X .cursor-move": "cursor:move;", "X .cursor-col-resize": "cursor:col-resize;", "X .cursor-row-resize": "cursor:row-resize;", "X .cursor-ns-resize": "cursor:ns-resize;", "X .cursor-ew-resize": "cursor:ew-resize;", "X .cursor-sw-resize": "cursor:sw-resize;", "X .cursor-s-resize": "cursor:s-resize;", "X .cursor-se-resize": "cursor:se-resize;", "X .cursor-w-resize": "cursor:w-resize;", "X .cursor-e-resize": "cursor:e-resize;", "X .cursor-nw-resize": "cursor:nw-resize;", "X .cursor-n-resize": "cursor:n-resize;", "X .cursor-ne-resize": "cursor:ne-resize;", "X .cursor-grab": "cursor:-webkit-grab;cursor:grab;", "X .modebar": "position:absolute;top:2px;right:2px;", "X .ease-bg": "-webkit-transition:background-color .3s ease 0s;-moz-transition:background-color .3s ease 0s;-ms-transition:background-color .3s ease 0s;-o-transition:background-color .3s ease 0s;transition:background-color .3s ease 0s;", "X .modebar--hover>:not(.watermark)": "opacity:0;-webkit-transition:opacity .3s ease 0s;-moz-transition:opacity .3s ease 0s;-ms-transition:opacity .3s ease 0s;-o-transition:opacity .3s ease 0s;transition:opacity .3s ease 0s;", "X:hover .modebar--hover .modebar-group": "opacity:1;", "X .modebar-group": "float:left;display:inline-block;box-sizing:border-box;padding-left:8px;position:relative;vertical-align:middle;white-space:nowrap;", "X .modebar-btn": "position:relative;font-size:16px;padding:3px 4px;height:22px;cursor:pointer;line-height:normal;box-sizing:border-box;", "X .modebar-btn svg": "position:relative;top:2px;", "X .modebar.vertical": "display:flex;flex-direction:column;flex-wrap:wrap;align-content:flex-end;max-height:100%;", "X .modebar.vertical svg": "top:-1px;", "X .modebar.vertical .modebar-group": "display:block;float:none;padding-left:0px;padding-bottom:8px;", "X .modebar.vertical .modebar-group .modebar-btn": "display:block;text-align:center;", "X [data-title]:before,X [data-title]:after": "position:absolute;-webkit-transform:translate3d(0, 0, 0);-moz-transform:translate3d(0, 0, 0);-ms-transform:translate3d(0, 0, 0);-o-transform:translate3d(0, 0, 0);transform:translate3d(0, 0, 0);display:none;opacity:0;z-index:1001;pointer-events:none;top:110%;right:50%;", "X [data-title]:hover:before,X [data-title]:hover:after": "display:block;opacity:1;", "X [data-title]:before": 'content:"";position:absolute;background:rgba(0,0,0,0);border:6px solid rgba(0,0,0,0);z-index:1002;margin-top:-12px;border-bottom-color:#69738a;margin-right:-6px;', "X [data-title]:after": "content:attr(data-title);background:#69738a;color:#fff;padding:8px 10px;font-size:12px;line-height:12px;white-space:nowrap;margin-right:-18px;border-radius:2px;", "X .vertical [data-title]:before,X .vertical [data-title]:after": "top:0%;right:200%;", "X .vertical [data-title]:before": "border:6px solid rgba(0,0,0,0);border-left-color:#69738a;margin-top:8px;margin-right:-30px;", Y: 'font-family:"Open Sans",verdana,arial,sans-serif;position:fixed;top:50px;right:20px;z-index:10000;font-size:10pt;max-width:180px;', "Y p": "margin:0;", "Y .notifier-note": "min-width:180px;max-width:250px;border:1px solid #fff;z-index:3000;margin:0;background-color:#8c97af;background-color:rgba(140,151,175,.9);color:#fff;padding:10px;overflow-wrap:break-word;word-wrap:break-word;-ms-hyphens:auto;-webkit-hyphens:auto;hyphens:auto;", "Y .notifier-close": "color:#fff;opacity:.8;float:right;padding:0 5px;background:none;border:none;font-size:20px;font-weight:bold;line-height:20px;", "Y .notifier-close:hover": "color:#444;text-decoration:none;cursor:pointer;" };
        for (var a in i) {
          var o = a.replace(/^,/, " ,").replace(/X/g, ".js-plotly-plot .plotly").replace(/Y/g, ".plotly-notifier");
          n2.addStyleRule(o, i[a]);
        }
      }, 86712: function(t2, e3, r3) {
        t2.exports = r3(84224);
      }, 37240: function(t2, e3, r3) {
        t2.exports = r3(51132);
      }, 29744: function(t2, e3, r3) {
        t2.exports = r3(94456);
      }, 29352: function(t2, e3, r3) {
        t2.exports = r3(67244);
      }, 96144: function(t2, e3, r3) {
        t2.exports = r3(97776);
      }, 53219: function(t2, e3, r3) {
        t2.exports = r3(61712);
      }, 4624: function(t2, e3, r3) {
        t2.exports = r3(95856);
      }, 54543: function(t2, e3, r3) {
        t2.exports = r3(54272);
      }, 45e3: function(t2, e3, r3) {
        t2.exports = r3(85404);
      }, 62300: function(t2, e3, r3) {
        t2.exports = r3(26048);
      }, 6920: function(t2, e3, r3) {
        t2.exports = r3(66240);
      }, 10264: function(t2, e3, r3) {
        t2.exports = r3(40448);
      }, 32016: function(t2, e3, r3) {
        t2.exports = r3(64884);
      }, 27528: function(t2, e3, r3) {
        t2.exports = r3(15088);
      }, 75556: function(t2, e3, r3) {
        t2.exports = r3(76744);
      }, 39204: function(t2, e3, r3) {
        t2.exports = r3(94704);
      }, 73996: function(t2, e3, r3) {
        t2.exports = r3(62396);
      }, 16489: function(t2, e3, r3) {
        t2.exports = r3(32028);
      }, 5e3: function(t2, e3, r3) {
        t2.exports = r3(81932);
      }, 77280: function(t2, e3, r3) {
        t2.exports = r3(45536);
      }, 33992: function(t2, e3, r3) {
        t2.exports = r3(42600);
      }, 17600: function(t2, e3, r3) {
        t2.exports = r3(21536);
      }, 49116: function(t2, e3, r3) {
        t2.exports = r3(65664);
      }, 46808: function(t2, e3, r3) {
        t2.exports = r3(29044);
      }, 36168: function(t2, e3, r3) {
        t2.exports = r3(48928);
      }, 13792: function(t2, e3, r3) {
        var n2 = r3(32016);
        n2.register([r3(37240), r3(29352), r3(5e3), r3(33992), r3(17600), r3(49116), r3(6920), r3(67484), r3(79440), r3(39204), r3(83096), r3(36168), r3(20260), r3(63560), r3(65832), r3(46808), r3(73996), r3(48824), r3(89904), r3(25120), r3(13752), r3(4340), r3(62300), r3(29800), r3(8363), r3(54543), r3(86636), r3(42192), r3(32140), r3(77280), r3(89296), r3(56816), r3(70192), r3(45e3), r3(27528), r3(84764), r3(3920), r3(50248), r3(4624), r3(69967), r3(10264), r3(86152), r3(53219), r3(81604), r3(63796), r3(29744), r3(89336), r3(86712), r3(75556), r3(16489), r3(97312), r3(96144)]), t2.exports = n2;
      }, 3920: function(t2, e3, r3) {
        t2.exports = r3(43480);
      }, 25120: function(t2, e3, r3) {
        t2.exports = r3(6296);
      }, 4340: function(t2, e3, r3) {
        t2.exports = r3(7404);
      }, 86152: function(t2, e3, r3) {
        t2.exports = r3(65456);
      }, 56816: function(t2, e3, r3) {
        t2.exports = r3(22020);
      }, 89296: function(t2, e3, r3) {
        t2.exports = r3(29928);
      }, 20260: function(t2, e3, r3) {
        t2.exports = r3(75792);
      }, 32140: function(t2, e3, r3) {
        t2.exports = r3(156);
      }, 84764: function(t2, e3, r3) {
        t2.exports = r3(45499);
      }, 48824: function(t2, e3, r3) {
        t2.exports = r3(3296);
      }, 69967: function(t2, e3, r3) {
        t2.exports = r3(4184);
      }, 8363: function(t2, e3, r3) {
        t2.exports = r3(36952);
      }, 86636: function(t2, e3, r3) {
        t2.exports = r3(38983);
      }, 70192: function(t2, e3, r3) {
        t2.exports = r3(11572);
      }, 81604: function(t2, e3, r3) {
        t2.exports = r3(76924);
      }, 63796: function(t2, e3, r3) {
        t2.exports = r3(62944);
      }, 89336: function(t2, e3, r3) {
        t2.exports = r3(95443);
      }, 67484: function(t2, e3, r3) {
        t2.exports = r3(34864);
      }, 97312: function(t2, e3, r3) {
        t2.exports = r3(76272);
      }, 42192: function(t2, e3, r3) {
        t2.exports = r3(97924);
      }, 29800: function(t2, e3, r3) {
        t2.exports = r3(15436);
      }, 63560: function(t2, e3, r3) {
        t2.exports = r3(5621);
      }, 89904: function(t2, e3, r3) {
        t2.exports = r3(91304);
      }, 50248: function(t2, e3, r3) {
        t2.exports = r3(41724);
      }, 65832: function(t2, e3, r3) {
        t2.exports = r3(31991);
      }, 79440: function(t2, e3, r3) {
        t2.exports = r3(22869);
      }, 13752: function(t2, e3, r3) {
        t2.exports = r3(67776);
      }, 83096: function(t2, e3, r3) {
        t2.exports = r3(95952);
      }, 72196: function(t2) {
        t2.exports = [{ path: "", backoff: 0 }, { path: "M-2.4,-3V3L0.6,0Z", backoff: 0.6 }, { path: "M-3.7,-2.5V2.5L1.3,0Z", backoff: 1.3 }, { path: "M-4.45,-3L-1.65,-0.2V0.2L-4.45,3L1.55,0Z", backoff: 1.55 }, { path: "M-2.2,-2.2L-0.2,-0.2V0.2L-2.2,2.2L-1.4,3L1.6,0L-1.4,-3Z", backoff: 1.6 }, { path: "M-4.4,-2.1L-0.6,-0.2V0.2L-4.4,2.1L-4,3L2,0L-4,-3Z", backoff: 2 }, { path: "M2,0A2,2 0 1,1 0,-2A2,2 0 0,1 2,0Z", backoff: 0, noRotate: true }, { path: "M2,2V-2H-2V2Z", backoff: 0, noRotate: true }];
      }, 13916: function(t2, e3, r3) {
        var n2 = r3(72196), i = r3(25376), a = r3(33816), o = r3(31780).templatedArray;
        r3(36208), t2.exports = o("annotation", { visible: { valType: "boolean", dflt: true, editType: "calc+arraydraw" }, text: { valType: "string", editType: "calc+arraydraw" }, textangle: { valType: "angle", dflt: 0, editType: "calc+arraydraw" }, font: i({ editType: "calc+arraydraw", colorEditType: "arraydraw" }), width: { valType: "number", min: 1, dflt: null, editType: "calc+arraydraw" }, height: { valType: "number", min: 1, dflt: null, editType: "calc+arraydraw" }, opacity: { valType: "number", min: 0, max: 1, dflt: 1, editType: "arraydraw" }, align: { valType: "enumerated", values: ["left", "center", "right"], dflt: "center", editType: "arraydraw" }, valign: { valType: "enumerated", values: ["top", "middle", "bottom"], dflt: "middle", editType: "arraydraw" }, bgcolor: { valType: "color", dflt: "rgba(0,0,0,0)", editType: "arraydraw" }, bordercolor: { valType: "color", dflt: "rgba(0,0,0,0)", editType: "arraydraw" }, borderpad: { valType: "number", min: 0, dflt: 1, editType: "calc+arraydraw" }, borderwidth: { valType: "number", min: 0, dflt: 1, editType: "calc+arraydraw" }, showarrow: { valType: "boolean", dflt: true, editType: "calc+arraydraw" }, arrowcolor: { valType: "color", editType: "arraydraw" }, arrowhead: { valType: "integer", min: 0, max: n2.length, dflt: 1, editType: "arraydraw" }, startarrowhead: { valType: "integer", min: 0, max: n2.length, dflt: 1, editType: "arraydraw" }, arrowside: { valType: "flaglist", flags: ["end", "start"], extras: ["none"], dflt: "end", editType: "arraydraw" }, arrowsize: { valType: "number", min: 0.3, dflt: 1, editType: "calc+arraydraw" }, startarrowsize: { valType: "number", min: 0.3, dflt: 1, editType: "calc+arraydraw" }, arrowwidth: { valType: "number", min: 0.1, editType: "calc+arraydraw" }, standoff: { valType: "number", min: 0, dflt: 0, editType: "calc+arraydraw" }, startstandoff: { valType: "number", min: 0, dflt: 0, editType: "calc+arraydraw" }, ax: { valType: "any", editType: "calc+arraydraw" }, ay: { valType: "any", editType: "calc+arraydraw" }, axref: { valType: "enumerated", dflt: "pixel", values: ["pixel", a.idRegex.x.toString()], editType: "calc" }, ayref: { valType: "enumerated", dflt: "pixel", values: ["pixel", a.idRegex.y.toString()], editType: "calc" }, xref: { valType: "enumerated", values: ["paper", a.idRegex.x.toString()], editType: "calc" }, x: { valType: "any", editType: "calc+arraydraw" }, xanchor: { valType: "enumerated", values: ["auto", "left", "center", "right"], dflt: "auto", editType: "calc+arraydraw" }, xshift: { valType: "number", dflt: 0, editType: "calc+arraydraw" }, yref: { valType: "enumerated", values: ["paper", a.idRegex.y.toString()], editType: "calc" }, y: { valType: "any", editType: "calc+arraydraw" }, yanchor: { valType: "enumerated", values: ["auto", "top", "middle", "bottom"], dflt: "auto", editType: "calc+arraydraw" }, yshift: { valType: "number", dflt: 0, editType: "calc+arraydraw" }, clicktoshow: { valType: "enumerated", values: [false, "onoff", "onout"], dflt: false, editType: "arraydraw" }, xclick: { valType: "any", editType: "arraydraw" }, yclick: { valType: "any", editType: "arraydraw" }, hovertext: { valType: "string", editType: "arraydraw" }, hoverlabel: { bgcolor: { valType: "color", editType: "arraydraw" }, bordercolor: { valType: "color", editType: "arraydraw" }, font: i({ editType: "arraydraw" }), editType: "arraydraw" }, captureevents: { valType: "boolean", editType: "arraydraw" }, editType: "calc", _deprecated: { ref: { valType: "string", editType: "calc" } } });
      }, 90272: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(54460), a = r3(23816).draw;
        function o(t3) {
          var e4 = t3._fullLayout;
          n2.filterVisible(e4.annotations).forEach(function(e5) {
            var r4 = i.getFromId(t3, e5.xref), n3 = i.getFromId(t3, e5.yref), a2 = i.getRefType(e5.xref), o2 = i.getRefType(e5.yref);
            e5._extremes = {}, "range" === a2 && s(e5, r4), "range" === o2 && s(e5, n3);
          });
        }
        function s(t3, e4) {
          var r4, n3 = e4._id, a2 = n3.charAt(0), o2 = t3[a2], s2 = t3["a" + a2], l2 = t3[a2 + "ref"], u2 = t3["a" + a2 + "ref"], c2 = t3["_" + a2 + "padplus"], f2 = t3["_" + a2 + "padminus"], h2 = { x: 1, y: -1 }[a2] * t3[a2 + "shift"], p2 = 3 * t3.arrowsize * t3.arrowwidth || 0, d2 = p2 + h2, v2 = p2 - h2, g2 = 3 * t3.startarrowsize * t3.arrowwidth || 0, y2 = g2 + h2, m2 = g2 - h2;
          if (u2 === l2) {
            var x = i.findExtremes(e4, [e4.r2c(o2)], { ppadplus: d2, ppadminus: v2 }), b2 = i.findExtremes(e4, [e4.r2c(s2)], { ppadplus: Math.max(c2, y2), ppadminus: Math.max(f2, m2) });
            r4 = { min: [x.min[0], b2.min[0]], max: [x.max[0], b2.max[0]] };
          } else
            y2 = s2 ? y2 + s2 : y2, m2 = s2 ? m2 - s2 : m2, r4 = i.findExtremes(e4, [e4.r2c(o2)], { ppadplus: Math.max(c2, d2, y2), ppadminus: Math.max(f2, v2, m2) });
          t3._extremes[n3] = r4;
        }
        t2.exports = function(t3) {
          var e4 = t3._fullLayout;
          if (n2.filterVisible(e4.annotations).length && t3._fullData.length)
            return n2.syncOrAsync([a, o], t3);
        };
      }, 42300: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(24040), a = r3(31780).arrayEditor;
        function o(t3, e4) {
          var r4, n3, i2, a2, o2, l2, u2, c2 = t3._fullLayout.annotations, f2 = [], h2 = [], p2 = [], d2 = (e4 || []).length;
          for (r4 = 0; r4 < c2.length; r4++)
            if (a2 = (i2 = c2[r4]).clicktoshow) {
              for (n3 = 0; n3 < d2; n3++)
                if (l2 = (o2 = e4[n3]).xaxis, u2 = o2.yaxis, l2._id === i2.xref && u2._id === i2.yref && l2.d2r(o2.x) === s(i2._xclick, l2) && u2.d2r(o2.y) === s(i2._yclick, u2)) {
                  (i2.visible ? "onout" === a2 ? h2 : p2 : f2).push(r4);
                  break;
                }
              n3 === d2 && i2.visible && "onout" === a2 && h2.push(r4);
            }
          return { on: f2, off: h2, explicitOff: p2 };
        }
        function s(t3, e4) {
          return "log" === e4.type ? e4.l2r(t3) : e4.d2r(t3);
        }
        t2.exports = { hasClickToShow: function(t3, e4) {
          var r4 = o(t3, e4);
          return r4.on.length > 0 || r4.explicitOff.length > 0;
        }, onClick: function(t3, e4) {
          var r4, s2, l2 = o(t3, e4), u2 = l2.on, c2 = l2.off.concat(l2.explicitOff), f2 = {}, h2 = t3._fullLayout.annotations;
          if (u2.length || c2.length) {
            for (r4 = 0; r4 < u2.length; r4++)
              (s2 = a(t3.layout, "annotations", h2[u2[r4]])).modifyItem("visible", true), n2.extendFlat(f2, s2.getUpdateObj());
            for (r4 = 0; r4 < c2.length; r4++)
              (s2 = a(t3.layout, "annotations", h2[c2[r4]])).modifyItem("visible", false), n2.extendFlat(f2, s2.getUpdateObj());
            return i.call("update", t3, {}, f2);
          }
        } };
      }, 87192: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(76308);
        t2.exports = function(t3, e4, r4, a) {
          a("opacity");
          var o = a("bgcolor"), s = a("bordercolor"), l2 = i.opacity(s);
          a("borderpad");
          var u2 = a("borderwidth"), c2 = a("showarrow");
          if (a("text", c2 ? " " : r4._dfltTitle.annotation), a("textangle"), n2.coerceFont(a, "font", r4.font), a("width"), a("align"), a("height") && a("valign"), c2) {
            var f2, h2, p2 = a("arrowside");
            -1 !== p2.indexOf("end") && (f2 = a("arrowhead"), h2 = a("arrowsize")), -1 !== p2.indexOf("start") && (a("startarrowhead", f2), a("startarrowsize", h2)), a("arrowcolor", l2 ? e4.bordercolor : i.defaultLine), a("arrowwidth", 2 * (l2 && u2 || 1)), a("standoff"), a("startstandoff");
          }
          var d2 = a("hovertext"), v2 = r4.hoverlabel || {};
          if (d2) {
            var g2 = a("hoverlabel.bgcolor", v2.bgcolor || (i.opacity(o) ? i.rgb(o) : i.defaultLine)), y2 = a("hoverlabel.bordercolor", v2.bordercolor || i.contrast(g2));
            n2.coerceFont(a, "hoverlabel.font", { family: v2.font.family, size: v2.font.size, color: v2.font.color || y2 });
          }
          a("captureevents", !!d2);
        };
      }, 26828: function(t2, e3, r3) {
        var n2 = r3(38248), i = r3(36896);
        t2.exports = function(t3, e4, r4, a) {
          e4 = e4 || {};
          var o = "log" === r4 && "linear" === e4.type, s = "linear" === r4 && "log" === e4.type;
          if (o || s)
            for (var l2, u2, c2 = t3._fullLayout.annotations, f2 = e4._id.charAt(0), h2 = 0; h2 < c2.length; h2++)
              l2 = c2[h2], u2 = "annotations[" + h2 + "].", l2[f2 + "ref"] === e4._id && p2(f2), l2["a" + f2 + "ref"] === e4._id && p2("a" + f2);
          function p2(t4) {
            var r5 = l2[t4], s2 = null;
            s2 = o ? i(r5, e4.range) : Math.pow(10, r5), n2(s2) || (s2 = null), a(u2 + t4, s2);
          }
        };
      }, 45216: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(54460), a = r3(51272), o = r3(87192), s = r3(13916);
        function l2(t3, e4, r4) {
          function a2(r5, i2) {
            return n2.coerce(t3, e4, s, r5, i2);
          }
          var l3 = a2("visible"), u2 = a2("clicktoshow");
          if (l3 || u2) {
            o(t3, e4, r4, a2);
            for (var c2 = e4.showarrow, f2 = ["x", "y"], h2 = [-10, -30], p2 = { _fullLayout: r4 }, d2 = 0; d2 < 2; d2++) {
              var v2 = f2[d2], g2 = i.coerceRef(t3, e4, p2, v2, "", "paper");
              if ("paper" !== g2 && i.getFromId(p2, g2)._annIndices.push(e4._index), i.coercePosition(e4, p2, a2, g2, v2, 0.5), c2) {
                var y2 = "a" + v2, m2 = i.coerceRef(t3, e4, p2, y2, "pixel", ["pixel", "paper"]);
                "pixel" !== m2 && m2 !== g2 && (m2 = e4[y2] = "pixel");
                var x = "pixel" === m2 ? h2[d2] : 0.4;
                i.coercePosition(e4, p2, a2, m2, y2, x);
              }
              a2(v2 + "anchor"), a2(v2 + "shift");
            }
            if (n2.noneOrAll(t3, e4, ["x", "y"]), c2 && n2.noneOrAll(t3, e4, ["ax", "ay"]), u2) {
              var b2 = a2("xclick"), _ = a2("yclick");
              e4._xclick = void 0 === b2 ? e4.x : i.cleanPosition(b2, p2, e4.xref), e4._yclick = void 0 === _ ? e4.y : i.cleanPosition(_, p2, e4.yref);
            }
          }
        }
        t2.exports = function(t3, e4) {
          a(t3, e4, { name: "annotations", handleItemDefaults: l2 });
        };
      }, 23816: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(24040), a = r3(7316), o = r3(3400), s = o.strTranslate, l2 = r3(54460), u2 = r3(76308), c2 = r3(43616), f2 = r3(93024), h2 = r3(72736), p2 = r3(93972), d2 = r3(86476), v2 = r3(31780).arrayEditor, g2 = r3(33652);
        function y2(t3, e4) {
          var r4 = t3._fullLayout.annotations[e4] || {}, n3 = l2.getFromId(t3, r4.xref), i2 = l2.getFromId(t3, r4.yref);
          n3 && n3.setScale(), i2 && i2.setScale(), x(t3, r4, e4, false, n3, i2);
        }
        function m2(t3, e4, r4, n3, i2) {
          var a2 = i2[r4], o2 = i2[r4 + "ref"], s2 = -1 !== r4.indexOf("y"), u3 = "domain" === l2.getRefType(o2), c3 = s2 ? n3.h : n3.w;
          return t3 ? u3 ? a2 + (s2 ? -e4 : e4) / t3._length : t3.p2r(t3.r2p(a2) + e4) : a2 + (s2 ? -e4 : e4) / c3;
        }
        function x(t3, e4, r4, a2, y3, x2) {
          var b2, _, w2 = t3._fullLayout, T = t3._fullLayout._size, k2 = t3._context.edits;
          a2 ? (b2 = "annotation-" + a2, _ = a2 + ".annotations") : (b2 = "annotation", _ = "annotations");
          var A2 = v2(t3.layout, _, e4), M = A2.modifyBase, S = A2.modifyItem, E2 = A2.getUpdateObj;
          w2._infolayer.selectAll("." + b2 + '[data-index="' + r4 + '"]').remove();
          var L = "clip" + w2._uid + "_ann" + r4;
          if (e4._input && false !== e4.visible) {
            var C2 = { x: {}, y: {} }, P = +e4.textangle || 0, O = w2._infolayer.append("g").classed(b2, true).attr("data-index", String(r4)).style("opacity", e4.opacity), I2 = O.append("g").classed("annotation-text-g", true), D2 = k2[e4.showarrow ? "annotationTail" : "annotationPosition"], z2 = e4.captureevents || k2.annotationText || D2, R = I2.append("g").style("pointer-events", z2 ? "all" : null).call(p2, "pointer").on("click", function() {
              t3._dragging = false, t3.emit("plotly_clickannotation", W(n2.event));
            });
            e4.hovertext && R.on("mouseover", function() {
              var r5 = e4.hoverlabel, n3 = r5.font, i2 = this.getBoundingClientRect(), a3 = t3.getBoundingClientRect();
              f2.loneHover({ x0: i2.left - a3.left, x1: i2.right - a3.left, y: (i2.top + i2.bottom) / 2 - a3.top, text: e4.hovertext, color: r5.bgcolor, borderColor: r5.bordercolor, fontFamily: n3.family, fontSize: n3.size, fontColor: n3.color }, { container: w2._hoverlayer.node(), outerContainer: w2._paper.node(), gd: t3 });
            }).on("mouseout", function() {
              f2.loneUnhover(w2._hoverlayer.node());
            });
            var F2 = e4.borderwidth, B2 = e4.borderpad, N = F2 + B2, j = R.append("rect").attr("class", "bg").style("stroke-width", F2 + "px").call(u2.stroke, e4.bordercolor).call(u2.fill, e4.bgcolor), U = e4.width || e4.height, V = w2._topclips.selectAll("#" + L).data(U ? [0] : []);
            V.enter().append("clipPath").classed("annclip", true).attr("id", L).append("rect"), V.exit().remove();
            var q2 = e4.font, H2 = w2._meta ? o.templateString(e4.text, w2._meta) : e4.text, G2 = R.append("text").classed("annotation-text", true).text(H2);
            k2.annotationText ? G2.call(h2.makeEditable, { delegate: R, gd: t3 }).call(Y).on("edit", function(r5) {
              e4.text = r5, this.call(Y), S("text", r5), y3 && y3.autorange && M(y3._name + ".autorange", true), x2 && x2.autorange && M(x2._name + ".autorange", true), i.call("_guiRelayout", t3, E2());
            }) : G2.call(Y);
          } else
            n2.selectAll("#" + L).remove();
          function W(t4) {
            var n3 = { index: r4, annotation: e4._input, fullAnnotation: e4, event: t4 };
            return a2 && (n3.subplotId = a2), n3;
          }
          function Y(r5) {
            return r5.call(c2.font, q2).attr({ "text-anchor": { left: "start", right: "end" }[e4.align] || "middle" }), h2.convertToTspans(r5, t3, X), r5;
          }
          function X() {
            var r5 = G2.selectAll("a");
            1 === r5.size() && r5.text() === G2.text() && R.insert("a", ":first-child").attr({ "xlink:xlink:href": r5.attr("xlink:href"), "xlink:xlink:show": r5.attr("xlink:show") }).style({ cursor: "pointer" }).node().appendChild(j.node());
            var n3 = R.select(".annotation-text-math-group"), f3 = !n3.empty(), v3 = c2.bBox((f3 ? n3 : G2).node()), b3 = v3.width, _2 = v3.height, A3 = e4.width || b3, z3 = e4.height || _2, B3 = Math.round(A3 + 2 * N), q3 = Math.round(z3 + 2 * N);
            function H3(t4, e5) {
              return "auto" === e5 && (e5 = t4 < 1 / 3 ? "left" : t4 > 2 / 3 ? "right" : "center"), { center: 0, middle: 0, left: 0.5, bottom: -0.5, right: -0.5, top: 0.5 }[e5];
            }
            for (var Y2 = false, X2 = ["x", "y"], Z = 0; Z < X2.length; Z++) {
              var K, J, $, Q, tt2, et = X2[Z], rt = e4[et + "ref"] || et, nt = e4["a" + et + "ref"], it = { x: y3, y: x2 }[et], at = (P + ("x" === et ? 0 : -90)) * Math.PI / 180, ot = B3 * Math.cos(at), st = q3 * Math.sin(at), lt = Math.abs(ot) + Math.abs(st), ut = e4[et + "anchor"], ct = e4[et + "shift"] * ("x" === et ? 1 : -1), ft = C2[et], ht = l2.getRefType(rt);
              if (it && "domain" !== ht) {
                var pt = it.r2fraction(e4[et]);
                (pt < 0 || pt > 1) && (nt === rt ? ((pt = it.r2fraction(e4["a" + et])) < 0 || pt > 1) && (Y2 = true) : Y2 = true), K = it._offset + it.r2p(e4[et]), Q = 0.5;
              } else {
                var dt = "domain" === ht;
                "x" === et ? ($ = e4[et], K = dt ? it._offset + it._length * $ : K = T.l + T.w * $) : ($ = 1 - e4[et], K = dt ? it._offset + it._length * $ : K = T.t + T.h * $), Q = e4.showarrow ? 0.5 : $;
              }
              if (e4.showarrow) {
                ft.head = K;
                var vt = e4["a" + et];
                if (tt2 = ot * H3(0.5, e4.xanchor) - st * H3(0.5, e4.yanchor), nt === rt) {
                  var gt = l2.getRefType(nt);
                  "domain" === gt ? ("y" === et && (vt = 1 - vt), ft.tail = it._offset + it._length * vt) : "paper" === gt ? "y" === et ? (vt = 1 - vt, ft.tail = T.t + T.h * vt) : ft.tail = T.l + T.w * vt : ft.tail = it._offset + it.r2p(vt), J = tt2;
                } else
                  ft.tail = K + vt, J = tt2 + vt;
                ft.text = ft.tail + tt2;
                var yt = w2["x" === et ? "width" : "height"];
                if ("paper" === rt && (ft.head = o.constrain(ft.head, 1, yt - 1)), "pixel" === nt) {
                  var mt = -Math.max(ft.tail - 3, ft.text), xt = Math.min(ft.tail + 3, ft.text) - yt;
                  mt > 0 ? (ft.tail += mt, ft.text += mt) : xt > 0 && (ft.tail -= xt, ft.text -= xt);
                }
                ft.tail += ct, ft.head += ct;
              } else
                J = tt2 = lt * H3(Q, ut), ft.text = K + tt2;
              ft.text += ct, tt2 += ct, J += ct, e4["_" + et + "padplus"] = lt / 2 + J, e4["_" + et + "padminus"] = lt / 2 - J, e4["_" + et + "size"] = lt, e4["_" + et + "shift"] = tt2;
            }
            if (Y2)
              R.remove();
            else {
              var bt = 0, _t = 0;
              if ("left" !== e4.align && (bt = (A3 - b3) * ("center" === e4.align ? 0.5 : 1)), "top" !== e4.valign && (_t = (z3 - _2) * ("middle" === e4.valign ? 0.5 : 1)), f3)
                n3.select("svg").attr({ x: N + bt - 1, y: N + _t }).call(c2.setClipUrl, U ? L : null, t3);
              else {
                var wt = N + _t - v3.top, Tt = N + bt - v3.left;
                G2.call(h2.positionText, Tt, wt).call(c2.setClipUrl, U ? L : null, t3);
              }
              V.select("rect").call(c2.setRect, N, N, A3, z3), j.call(c2.setRect, F2 / 2, F2 / 2, B3 - F2, q3 - F2), R.call(c2.setTranslate, Math.round(C2.x.text - B3 / 2), Math.round(C2.y.text - q3 / 2)), I2.attr({ transform: "rotate(" + P + "," + C2.x.text + "," + C2.y.text + ")" });
              var kt, At = function(r6, n4) {
                O.selectAll(".annotation-arrow-g").remove();
                var l3 = C2.x.head, f4 = C2.y.head, h3 = C2.x.tail + r6, p3 = C2.y.tail + n4, v4 = C2.x.text + r6, b4 = C2.y.text + n4, _3 = o.rotationXYMatrix(P, v4, b4), w3 = o.apply2DTransform(_3), A4 = o.apply2DTransform2(_3), L2 = +j.attr("width"), D3 = +j.attr("height"), z4 = v4 - 0.5 * L2, F3 = z4 + L2, B4 = b4 - 0.5 * D3, N2 = B4 + D3, U2 = [[z4, B4, z4, N2], [z4, N2, F3, N2], [F3, N2, F3, B4], [F3, B4, z4, B4]].map(A4);
                if (!U2.reduce(function(t4, e5) {
                  return t4 ^ !!o.segmentsIntersect(l3, f4, l3 + 1e6, f4 + 1e6, e5[0], e5[1], e5[2], e5[3]);
                }, false)) {
                  U2.forEach(function(t4) {
                    var e5 = o.segmentsIntersect(h3, p3, l3, f4, t4[0], t4[1], t4[2], t4[3]);
                    e5 && (h3 = e5.x, p3 = e5.y);
                  });
                  var V2 = e4.arrowwidth, q4 = e4.arrowcolor, H4 = e4.arrowside, G3 = O.append("g").style({ opacity: u2.opacity(q4) }).classed("annotation-arrow-g", true), W2 = G3.append("path").attr("d", "M" + h3 + "," + p3 + "L" + l3 + "," + f4).style("stroke-width", V2 + "px").call(u2.stroke, u2.rgb(q4));
                  if (g2(W2, H4, e4), k2.annotationPosition && W2.node().parentNode && !a2) {
                    var Y3 = l3, X3 = f4;
                    if (e4.standoff) {
                      var Z2 = Math.sqrt(Math.pow(l3 - h3, 2) + Math.pow(f4 - p3, 2));
                      Y3 += e4.standoff * (h3 - l3) / Z2, X3 += e4.standoff * (p3 - f4) / Z2;
                    }
                    var K2, J2, $2 = G3.append("path").classed("annotation-arrow", true).classed("anndrag", true).classed("cursor-move", true).attr({ d: "M3,3H-3V-3H3ZM0,0L" + (h3 - Y3) + "," + (p3 - X3), transform: s(Y3, X3) }).style("stroke-width", V2 + 6 + "px").call(u2.stroke, "rgba(0,0,0,0)").call(u2.fill, "rgba(0,0,0,0)");
                    d2.init({ element: $2.node(), gd: t3, prepFn: function() {
                      var t4 = c2.getTranslate(R);
                      K2 = t4.x, J2 = t4.y, y3 && y3.autorange && M(y3._name + ".autorange", true), x2 && x2.autorange && M(x2._name + ".autorange", true);
                    }, moveFn: function(t4, r7) {
                      var n5 = w3(K2, J2), i2 = n5[0] + t4, a3 = n5[1] + r7;
                      R.call(c2.setTranslate, i2, a3), S("x", m2(y3, t4, "x", T, e4)), S("y", m2(x2, r7, "y", T, e4)), e4.axref === e4.xref && S("ax", m2(y3, t4, "ax", T, e4)), e4.ayref === e4.yref && S("ay", m2(x2, r7, "ay", T, e4)), G3.attr("transform", s(t4, r7)), I2.attr({ transform: "rotate(" + P + "," + i2 + "," + a3 + ")" });
                    }, doneFn: function() {
                      i.call("_guiRelayout", t3, E2());
                      var e5 = document.querySelector(".js-notes-box-panel");
                      e5 && e5.redraw(e5.selectedObj);
                    } });
                  }
                }
              };
              e4.showarrow && At(0, 0), D2 && d2.init({ element: R.node(), gd: t3, prepFn: function() {
                kt = I2.attr("transform");
              }, moveFn: function(t4, r6) {
                var n4 = "pointer";
                if (e4.showarrow)
                  e4.axref === e4.xref ? S("ax", m2(y3, t4, "ax", T, e4)) : S("ax", e4.ax + t4), e4.ayref === e4.yref ? S("ay", m2(x2, r6, "ay", T.w, e4)) : S("ay", e4.ay + r6), At(t4, r6);
                else {
                  if (a2)
                    return;
                  var i2, o2;
                  if (y3)
                    i2 = m2(y3, t4, "x", T, e4);
                  else {
                    var l3 = e4._xsize / T.w, u3 = e4.x + (e4._xshift - e4.xshift) / T.w - l3 / 2;
                    i2 = d2.align(u3 + t4 / T.w, l3, 0, 1, e4.xanchor);
                  }
                  if (x2)
                    o2 = m2(x2, r6, "y", T, e4);
                  else {
                    var c3 = e4._ysize / T.h, f4 = e4.y - (e4._yshift + e4.yshift) / T.h - c3 / 2;
                    o2 = d2.align(f4 - r6 / T.h, c3, 0, 1, e4.yanchor);
                  }
                  S("x", i2), S("y", o2), y3 && x2 || (n4 = d2.getCursor(y3 ? 0.5 : i2, x2 ? 0.5 : o2, e4.xanchor, e4.yanchor));
                }
                I2.attr({ transform: s(t4, r6) + kt }), p2(R, n4);
              }, clickFn: function(r6, n4) {
                e4.captureevents && t3.emit("plotly_clickannotation", W(n4));
              }, doneFn: function() {
                p2(R), i.call("_guiRelayout", t3, E2());
                var e5 = document.querySelector(".js-notes-box-panel");
                e5 && e5.redraw(e5.selectedObj);
              } });
            }
          }
        }
        t2.exports = { draw: function(t3) {
          var e4 = t3._fullLayout;
          e4._infolayer.selectAll(".annotation").remove();
          for (var r4 = 0; r4 < e4.annotations.length; r4++)
            e4.annotations[r4].visible && y2(t3, r4);
          return a.previousPromises(t3);
        }, drawOne: y2, drawRaw: x };
      }, 33652: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(76308), a = r3(72196), o = r3(3400), s = o.strScale, l2 = o.strRotate, u2 = o.strTranslate;
        t2.exports = function(t3, e4, r4) {
          var o2, c2, f2, h2, p2 = t3.node(), d2 = a[r4.arrowhead || 0], v2 = a[r4.startarrowhead || 0], g2 = (r4.arrowwidth || 1) * (r4.arrowsize || 1), y2 = (r4.arrowwidth || 1) * (r4.startarrowsize || 1), m2 = e4.indexOf("start") >= 0, x = e4.indexOf("end") >= 0, b2 = d2.backoff * g2 + r4.standoff, _ = v2.backoff * y2 + r4.startstandoff;
          if ("line" === p2.nodeName) {
            o2 = { x: +t3.attr("x1"), y: +t3.attr("y1") }, c2 = { x: +t3.attr("x2"), y: +t3.attr("y2") };
            var w2 = o2.x - c2.x, T = o2.y - c2.y;
            if (h2 = (f2 = Math.atan2(T, w2)) + Math.PI, b2 && _ && b2 + _ > Math.sqrt(w2 * w2 + T * T))
              return void D2();
            if (b2) {
              if (b2 * b2 > w2 * w2 + T * T)
                return void D2();
              var k2 = b2 * Math.cos(f2), A2 = b2 * Math.sin(f2);
              c2.x += k2, c2.y += A2, t3.attr({ x2: c2.x, y2: c2.y });
            }
            if (_) {
              if (_ * _ > w2 * w2 + T * T)
                return void D2();
              var M = _ * Math.cos(f2), S = _ * Math.sin(f2);
              o2.x -= M, o2.y -= S, t3.attr({ x1: o2.x, y1: o2.y });
            }
          } else if ("path" === p2.nodeName) {
            var E2 = p2.getTotalLength(), L = "";
            if (E2 < b2 + _)
              return void D2();
            var C2 = p2.getPointAtLength(0), P = p2.getPointAtLength(0.1);
            f2 = Math.atan2(C2.y - P.y, C2.x - P.x), o2 = p2.getPointAtLength(Math.min(_, E2)), L = "0px," + _ + "px,";
            var O = p2.getPointAtLength(E2), I2 = p2.getPointAtLength(E2 - 0.1);
            h2 = Math.atan2(O.y - I2.y, O.x - I2.x), c2 = p2.getPointAtLength(Math.max(0, E2 - b2)), L += E2 - (L ? _ + b2 : b2) + "px," + E2 + "px", t3.style("stroke-dasharray", L);
          }
          function D2() {
            t3.style("stroke-dasharray", "0px,100px");
          }
          function z2(e5, a2, o3, c3) {
            e5.path && (e5.noRotate && (o3 = 0), n2.select(p2.parentNode).append("path").attr({ class: t3.attr("class"), d: e5.path, transform: u2(a2.x, a2.y) + l2(180 * o3 / Math.PI) + s(c3) }).style({ fill: i.rgb(r4.arrowcolor), "stroke-width": 0 }));
          }
          m2 && z2(v2, o2, f2, y2), x && z2(d2, c2, h2, g2);
        };
      }, 79180: function(t2, e3, r3) {
        var n2 = r3(23816), i = r3(42300);
        t2.exports = { moduleType: "component", name: "annotations", layoutAttributes: r3(13916), supplyLayoutDefaults: r3(45216), includeBasePlot: r3(36632)("annotations"), calcAutorange: r3(90272), draw: n2.draw, drawOne: n2.drawOne, drawRaw: n2.drawRaw, hasClickToShow: i.hasClickToShow, onClick: i.onClick, convertCoords: r3(26828) };
      }, 45899: function(t2, e3, r3) {
        var n2 = r3(13916), i = r3(67824).overrideAll, a = r3(31780).templatedArray;
        t2.exports = i(a("annotation", { visible: n2.visible, x: { valType: "any" }, y: { valType: "any" }, z: { valType: "any" }, ax: { valType: "number" }, ay: { valType: "number" }, xanchor: n2.xanchor, xshift: n2.xshift, yanchor: n2.yanchor, yshift: n2.yshift, text: n2.text, textangle: n2.textangle, font: n2.font, width: n2.width, height: n2.height, opacity: n2.opacity, align: n2.align, valign: n2.valign, bgcolor: n2.bgcolor, bordercolor: n2.bordercolor, borderpad: n2.borderpad, borderwidth: n2.borderwidth, showarrow: n2.showarrow, arrowcolor: n2.arrowcolor, arrowhead: n2.arrowhead, startarrowhead: n2.startarrowhead, arrowside: n2.arrowside, arrowsize: n2.arrowsize, startarrowsize: n2.startarrowsize, arrowwidth: n2.arrowwidth, standoff: n2.standoff, startstandoff: n2.startstandoff, hovertext: n2.hovertext, hoverlabel: n2.hoverlabel, captureevents: n2.captureevents }), "calc", "from-root");
      }, 42456: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(54460);
        function a(t3, e4) {
          var r4 = e4.fullSceneLayout.domain, a2 = e4.fullLayout._size, o = { pdata: null, type: "linear", autorange: false, range: [-1 / 0, 1 / 0] };
          t3._xa = {}, n2.extendFlat(t3._xa, o), i.setConvert(t3._xa), t3._xa._offset = a2.l + r4.x[0] * a2.w, t3._xa.l2p = function() {
            return 0.5 * (1 + t3._pdata[0] / t3._pdata[3]) * a2.w * (r4.x[1] - r4.x[0]);
          }, t3._ya = {}, n2.extendFlat(t3._ya, o), i.setConvert(t3._ya), t3._ya._offset = a2.t + (1 - r4.y[1]) * a2.h, t3._ya.l2p = function() {
            return 0.5 * (1 - t3._pdata[1] / t3._pdata[3]) * a2.h * (r4.y[1] - r4.y[0]);
          };
        }
        t2.exports = function(t3) {
          for (var e4 = t3.fullSceneLayout.annotations, r4 = 0; r4 < e4.length; r4++)
            a(e4[r4], t3);
          t3.fullLayout._infolayer.selectAll(".annotation-" + t3.id).remove();
        };
      }, 52808: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(54460), a = r3(51272), o = r3(87192), s = r3(45899);
        function l2(t3, e4, r4, a2) {
          function l3(r5, i2) {
            return n2.coerce(t3, e4, s, r5, i2);
          }
          function u2(t4) {
            var n3 = t4 + "axis", a3 = { _fullLayout: {} };
            return a3._fullLayout[n3] = r4[n3], i.coercePosition(e4, a3, l3, t4, t4, 0.5);
          }
          l3("visible") && (o(t3, e4, a2.fullLayout, l3), u2("x"), u2("y"), u2("z"), n2.noneOrAll(t3, e4, ["x", "y", "z"]), e4.xref = "x", e4.yref = "y", e4.zref = "z", l3("xanchor"), l3("yanchor"), l3("xshift"), l3("yshift"), e4.showarrow && (e4.axref = "pixel", e4.ayref = "pixel", l3("ax", -10), l3("ay", -30), n2.noneOrAll(t3, e4, ["ax", "ay"])));
        }
        t2.exports = function(t3, e4, r4) {
          a(t3, e4, { name: "annotations", handleItemDefaults: l2, fullLayout: r4.fullLayout });
        };
      }, 71836: function(t2, e3, r3) {
        var n2 = r3(23816).drawRaw, i = r3(94424), a = ["x", "y", "z"];
        t2.exports = function(t3) {
          for (var e4 = t3.fullSceneLayout, r4 = t3.dataScale, o = e4.annotations, s = 0; s < o.length; s++) {
            for (var l2 = o[s], u2 = false, c2 = 0; c2 < 3; c2++) {
              var f2 = a[c2], h2 = l2[f2], p2 = e4[f2 + "axis"].r2fraction(h2);
              if (p2 < 0 || p2 > 1) {
                u2 = true;
                break;
              }
            }
            u2 ? t3.fullLayout._infolayer.select(".annotation-" + t3.id + '[data-index="' + s + '"]').remove() : (l2._pdata = i(t3.glplot.cameraParams, [e4.xaxis.r2l(l2.x) * r4[0], e4.yaxis.r2l(l2.y) * r4[1], e4.zaxis.r2l(l2.z) * r4[2]]), n2(t3.graphDiv, l2, s, t3.id, l2._xa, l2._ya));
          }
        };
      }, 56864: function(t2, e3, r3) {
        var n2 = r3(24040), i = r3(3400);
        t2.exports = { moduleType: "component", name: "annotations3d", schema: { subplots: { scene: { annotations: r3(45899) } } }, layoutAttributes: r3(45899), handleDefaults: r3(52808), includeBasePlot: function(t3, e4) {
          var r4 = n2.subplotsRegistry.gl3d;
          if (r4)
            for (var a = r4.attrRegex, o = Object.keys(t3), s = 0; s < o.length; s++) {
              var l2 = o[s];
              a.test(l2) && (t3[l2].annotations || []).length && (i.pushUnique(e4._basePlotModules, r4), i.pushUnique(e4._subplots.gl3d, l2));
            }
        }, convert: r3(42456), draw: r3(71836) };
      }, 54976: function(t2, e3, r3) {
        t2.exports = r3(38700), r3(15168), r3(67020), r3(89792), r3(55668), r3(65168), r3(2084), r3(26368), r3(24747), r3(65616), r3(30632), r3(73040), r3(1104), r3(51456), r3(4592), r3(45348);
      }, 97776: function(t2, e3, r3) {
        var n2 = r3(54976), i = r3(3400), a = r3(39032), o = a.EPOCHJD, s = a.ONEDAY, l2 = { valType: "enumerated", values: i.sortObjectKeys(n2.calendars), editType: "calc", dflt: "gregorian" }, u2 = function(t3, e4, r4, n3) {
          var a2 = {};
          return a2[r4] = l2, i.coerce(t3, e4, a2, r4, n3);
        }, c2 = "##", f2 = { d: { 0: "dd", "-": "d" }, e: { 0: "d", "-": "d" }, a: { 0: "D", "-": "D" }, A: { 0: "DD", "-": "DD" }, j: { 0: "oo", "-": "o" }, W: { 0: "ww", "-": "w" }, m: { 0: "mm", "-": "m" }, b: { 0: "M", "-": "M" }, B: { 0: "MM", "-": "MM" }, y: { 0: "yy", "-": "yy" }, Y: { 0: "yyyy", "-": "yyyy" }, U: c2, w: c2, c: { 0: "D M d %X yyyy", "-": "D M d %X yyyy" }, x: { 0: "mm/dd/yyyy", "-": "mm/dd/yyyy" } }, h2 = {};
        function p2(t3) {
          var e4 = h2[t3];
          return e4 || (h2[t3] = n2.instance(t3));
        }
        function d2(t3) {
          return i.extendFlat({}, l2, { description: t3 });
        }
        function v2(t3) {
          return "Sets the calendar system to use with `" + t3 + "` date data.";
        }
        var g2 = { xcalendar: d2(v2("x")) }, y2 = i.extendFlat({}, g2, { ycalendar: d2(v2("y")) }), m2 = i.extendFlat({}, y2, { zcalendar: d2(v2("z")) }), x = d2(["Sets the calendar system to use for `range` and `tick0`", "if this is a date axis. This does not set the calendar for", "interpreting data on this axis, that's specified in the trace", "or via the global `layout.calendar`"].join(" "));
        t2.exports = { moduleType: "component", name: "calendars", schema: { traces: { scatter: y2, bar: y2, box: y2, heatmap: y2, contour: y2, histogram: y2, histogram2d: y2, histogram2dcontour: y2, scatter3d: m2, surface: m2, mesh3d: m2, scattergl: y2, ohlc: g2, candlestick: g2 }, layout: { calendar: d2(["Sets the default calendar system to use for interpreting and", "displaying dates throughout the plot."].join(" ")) }, subplots: { xaxis: { calendar: x }, yaxis: { calendar: x }, scene: { xaxis: { calendar: x }, yaxis: { calendar: x }, zaxis: { calendar: x } }, polar: { radialaxis: { calendar: x } } }, transforms: { filter: { valuecalendar: d2(["WARNING: All transforms are deprecated and may be removed from the API in next major version.", "Sets the calendar system to use for `value`, if it is a date."].join(" ")), targetcalendar: d2(["WARNING: All transforms are deprecated and may be removed from the API in next major version.", "Sets the calendar system to use for `target`, if it is an", "array of dates. If `target` is a string (eg *x*) we use the", "corresponding trace attribute (eg `xcalendar`) if it exists,", "even if `targetcalendar` is provided."].join(" ")) } } }, layoutAttributes: l2, handleDefaults: u2, handleTraceDefaults: function(t3, e4, r4, n3) {
          for (var i2 = 0; i2 < r4.length; i2++)
            u2(t3, e4, r4[i2] + "calendar", n3.calendar);
        }, CANONICAL_SUNDAY: { chinese: "2000-01-02", coptic: "2000-01-03", discworld: "2000-01-03", ethiopian: "2000-01-05", hebrew: "5000-01-01", islamic: "1000-01-02", julian: "2000-01-03", mayan: "5000-01-01", nanakshahi: "1000-01-05", nepali: "2000-01-05", persian: "1000-01-01", jalali: "1000-01-01", taiwan: "1000-01-04", thai: "2000-01-04", ummalqura: "1400-01-06" }, CANONICAL_TICK: { chinese: "2000-01-01", coptic: "2000-01-01", discworld: "2000-01-01", ethiopian: "2000-01-01", hebrew: "5000-01-01", islamic: "1000-01-01", julian: "2000-01-01", mayan: "5000-01-01", nanakshahi: "1000-01-01", nepali: "2000-01-01", persian: "1000-01-01", jalali: "1000-01-01", taiwan: "1000-01-01", thai: "2000-01-01", ummalqura: "1400-01-01" }, DFLTRANGE: { chinese: ["2000-01-01", "2001-01-01"], coptic: ["1700-01-01", "1701-01-01"], discworld: ["1800-01-01", "1801-01-01"], ethiopian: ["2000-01-01", "2001-01-01"], hebrew: ["5700-01-01", "5701-01-01"], islamic: ["1400-01-01", "1401-01-01"], julian: ["2000-01-01", "2001-01-01"], mayan: ["5200-01-01", "5201-01-01"], nanakshahi: ["0500-01-01", "0501-01-01"], nepali: ["2000-01-01", "2001-01-01"], persian: ["1400-01-01", "1401-01-01"], jalali: ["1400-01-01", "1401-01-01"], taiwan: ["0100-01-01", "0101-01-01"], thai: ["2500-01-01", "2501-01-01"], ummalqura: ["1400-01-01", "1401-01-01"] }, getCal: p2, worldCalFmt: function(t3, e4, r4) {
          for (var n3, i2, a2, l3, u3, h3 = Math.floor((e4 + 0.05) / s) + o, d3 = p2(r4).fromJD(h3), v3 = 0; -1 !== (v3 = t3.indexOf("%", v3)); )
            "0" === (n3 = t3.charAt(v3 + 1)) || "-" === n3 || "_" === n3 ? (a2 = 3, i2 = t3.charAt(v3 + 2), "_" === n3 && (n3 = "-")) : (i2 = n3, n3 = "0", a2 = 2), (l3 = f2[i2]) ? (u3 = l3 === c2 ? c2 : d3.formatDate(l3[n3]), t3 = t3.substr(0, v3) + u3 + t3.substr(v3 + a2), v3 += u3.length) : v3 += a2;
          return t3;
        } };
      }, 22548: function(t2, e3) {
        e3.defaults = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b", "#e377c2", "#7f7f7f", "#bcbd22", "#17becf"], e3.defaultLine = "#444", e3.lightLine = "#eee", e3.background = "#fff", e3.borderLine = "#BEC8D9", e3.lightFraction = 1e3 / 11;
      }, 76308: function(t2, e3, r3) {
        var n2 = r3(49760), i = r3(38248), a = r3(38116).isTypedArray, o = t2.exports = {}, s = r3(22548);
        o.defaults = s.defaults;
        var l2 = o.defaultLine = s.defaultLine;
        o.lightLine = s.lightLine;
        var u2 = o.background = s.background;
        function c2(t3) {
          if (i(t3) || "string" != typeof t3)
            return t3;
          var e4 = t3.trim();
          if ("rgb" !== e4.substr(0, 3))
            return t3;
          var r4 = e4.match(/^rgba?\s*\(([^()]*)\)$/);
          if (!r4)
            return t3;
          var n3 = r4[1].trim().split(/\s*[\s,]\s*/), a2 = "a" === e4.charAt(3) && 4 === n3.length;
          if (!a2 && 3 !== n3.length)
            return t3;
          for (var o2 = 0; o2 < n3.length; o2++) {
            if (!n3[o2].length)
              return t3;
            if (n3[o2] = Number(n3[o2]), !(n3[o2] >= 0))
              return t3;
            if (3 === o2)
              n3[o2] > 1 && (n3[o2] = 1);
            else if (n3[o2] >= 1)
              return t3;
          }
          var s2 = Math.round(255 * n3[0]) + ", " + Math.round(255 * n3[1]) + ", " + Math.round(255 * n3[2]);
          return a2 ? "rgba(" + s2 + ", " + n3[3] + ")" : "rgb(" + s2 + ")";
        }
        o.tinyRGB = function(t3) {
          var e4 = t3.toRgb();
          return "rgb(" + Math.round(e4.r) + ", " + Math.round(e4.g) + ", " + Math.round(e4.b) + ")";
        }, o.rgb = function(t3) {
          return o.tinyRGB(n2(t3));
        }, o.opacity = function(t3) {
          return t3 ? n2(t3).getAlpha() : 0;
        }, o.addOpacity = function(t3, e4) {
          var r4 = n2(t3).toRgb();
          return "rgba(" + Math.round(r4.r) + ", " + Math.round(r4.g) + ", " + Math.round(r4.b) + ", " + e4 + ")";
        }, o.combine = function(t3, e4) {
          var r4 = n2(t3).toRgb();
          if (1 === r4.a)
            return n2(t3).toRgbString();
          var i2 = n2(e4 || u2).toRgb(), a2 = 1 === i2.a ? i2 : { r: 255 * (1 - i2.a) + i2.r * i2.a, g: 255 * (1 - i2.a) + i2.g * i2.a, b: 255 * (1 - i2.a) + i2.b * i2.a }, o2 = { r: a2.r * (1 - r4.a) + r4.r * r4.a, g: a2.g * (1 - r4.a) + r4.g * r4.a, b: a2.b * (1 - r4.a) + r4.b * r4.a };
          return n2(o2).toRgbString();
        }, o.contrast = function(t3, e4, r4) {
          var i2 = n2(t3);
          return 1 !== i2.getAlpha() && (i2 = n2(o.combine(t3, u2))), (i2.isDark() ? e4 ? i2.lighten(e4) : u2 : r4 ? i2.darken(r4) : l2).toString();
        }, o.stroke = function(t3, e4) {
          var r4 = n2(e4);
          t3.style({ stroke: o.tinyRGB(r4), "stroke-opacity": r4.getAlpha() });
        }, o.fill = function(t3, e4) {
          var r4 = n2(e4);
          t3.style({ fill: o.tinyRGB(r4), "fill-opacity": r4.getAlpha() });
        }, o.clean = function(t3) {
          if (t3 && "object" == typeof t3) {
            var e4, r4, n3, i2, s2 = Object.keys(t3);
            for (e4 = 0; e4 < s2.length; e4++)
              if (i2 = t3[n3 = s2[e4]], "color" === n3.substr(n3.length - 5))
                if (Array.isArray(i2))
                  for (r4 = 0; r4 < i2.length; r4++)
                    i2[r4] = c2(i2[r4]);
                else
                  t3[n3] = c2(i2);
              else if ("colorscale" === n3.substr(n3.length - 10) && Array.isArray(i2))
                for (r4 = 0; r4 < i2.length; r4++)
                  Array.isArray(i2[r4]) && (i2[r4][1] = c2(i2[r4][1]));
              else if (Array.isArray(i2)) {
                var l3 = i2[0];
                if (!Array.isArray(l3) && l3 && "object" == typeof l3)
                  for (r4 = 0; r4 < i2.length; r4++)
                    o.clean(i2[r4]);
              } else
                i2 && "object" == typeof i2 && !a(i2) && o.clean(i2);
          }
        };
      }, 42996: function(t2, e3, r3) {
        var n2 = r3(94724), i = r3(25376), a = r3(92880).extendFlat, o = r3(67824).overrideAll;
        t2.exports = o({ orientation: { valType: "enumerated", values: ["h", "v"], dflt: "v" }, thicknessmode: { valType: "enumerated", values: ["fraction", "pixels"], dflt: "pixels" }, thickness: { valType: "number", min: 0, dflt: 30 }, lenmode: { valType: "enumerated", values: ["fraction", "pixels"], dflt: "fraction" }, len: { valType: "number", min: 0, dflt: 1 }, x: { valType: "number" }, xref: { valType: "enumerated", dflt: "paper", values: ["container", "paper"], editType: "layoutstyle" }, xanchor: { valType: "enumerated", values: ["left", "center", "right"] }, xpad: { valType: "number", min: 0, dflt: 10 }, y: { valType: "number" }, yref: { valType: "enumerated", dflt: "paper", values: ["container", "paper"], editType: "layoutstyle" }, yanchor: { valType: "enumerated", values: ["top", "middle", "bottom"] }, ypad: { valType: "number", min: 0, dflt: 10 }, outlinecolor: n2.linecolor, outlinewidth: n2.linewidth, bordercolor: n2.linecolor, borderwidth: { valType: "number", min: 0, dflt: 0 }, bgcolor: { valType: "color", dflt: "rgba(0,0,0,0)" }, tickmode: n2.minor.tickmode, nticks: n2.nticks, tick0: n2.tick0, dtick: n2.dtick, tickvals: n2.tickvals, ticktext: n2.ticktext, ticks: a({}, n2.ticks, { dflt: "" }), ticklabeloverflow: a({}, n2.ticklabeloverflow, {}), ticklabelposition: { valType: "enumerated", values: ["outside", "inside", "outside top", "inside top", "outside left", "inside left", "outside right", "inside right", "outside bottom", "inside bottom"], dflt: "outside" }, ticklen: n2.ticklen, tickwidth: n2.tickwidth, tickcolor: n2.tickcolor, ticklabelstep: n2.ticklabelstep, showticklabels: n2.showticklabels, labelalias: n2.labelalias, tickfont: i({}), tickangle: n2.tickangle, tickformat: n2.tickformat, tickformatstops: n2.tickformatstops, tickprefix: n2.tickprefix, showtickprefix: n2.showtickprefix, ticksuffix: n2.ticksuffix, showticksuffix: n2.showticksuffix, separatethousands: n2.separatethousands, exponentformat: n2.exponentformat, minexponent: n2.minexponent, showexponent: n2.showexponent, title: { text: { valType: "string" }, font: i({}), side: { valType: "enumerated", values: ["right", "top", "bottom"] } }, _deprecated: { title: { valType: "string" }, titlefont: i({}), titleside: { valType: "enumerated", values: ["right", "top", "bottom"], dflt: "top" } } }, "colorbars", "from-root");
      }, 63964: function(t2) {
        t2.exports = { cn: { colorbar: "colorbar", cbbg: "cbbg", cbfill: "cbfill", cbfills: "cbfills", cbline: "cbline", cblines: "cblines", cbaxis: "cbaxis", cbtitleunshift: "cbtitleunshift", cbtitle: "cbtitle", cboutline: "cboutline", crisp: "crisp", jsPlaceholder: "js-placeholder" } };
      }, 64013: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(31780), a = r3(26332), o = r3(25404), s = r3(95936), l2 = r3(42568), u2 = r3(42996);
        t2.exports = function(t3, e4, r4) {
          var c2 = i.newContainer(e4, "colorbar"), f2 = t3.colorbar || {};
          function h2(t4, e5) {
            return n2.coerce(f2, c2, u2, t4, e5);
          }
          var p2 = r4.margin || { t: 0, b: 0, l: 0, r: 0 }, d2 = r4.width - p2.l - p2.r, v2 = r4.height - p2.t - p2.b, g2 = "v" === h2("orientation"), y2 = h2("thicknessmode");
          h2("thickness", "fraction" === y2 ? 30 / (g2 ? d2 : v2) : 30);
          var m2 = h2("lenmode");
          h2("len", "fraction" === m2 ? 1 : g2 ? v2 : d2);
          var x, b2, _, w2 = "paper" === h2("yref"), T = "paper" === h2("xref"), k2 = "left";
          g2 ? (_ = "middle", k2 = T ? "left" : "right", x = T ? 1.02 : 1, b2 = 0.5) : (_ = w2 ? "bottom" : "top", k2 = "center", x = 0.5, b2 = w2 ? 1.02 : 1), n2.coerce(f2, c2, { x: { valType: "number", min: T ? -2 : 0, max: T ? 3 : 1, dflt: x } }, "x"), n2.coerce(f2, c2, { y: { valType: "number", min: w2 ? -2 : 0, max: w2 ? 3 : 1, dflt: b2 } }, "y"), h2("xanchor", k2), h2("xpad"), h2("yanchor", _), h2("ypad"), n2.noneOrAll(f2, c2, ["x", "y"]), h2("outlinecolor"), h2("outlinewidth"), h2("bordercolor"), h2("borderwidth"), h2("bgcolor");
          var A2 = n2.coerce(f2, c2, { ticklabelposition: { valType: "enumerated", dflt: "outside", values: g2 ? ["outside", "inside", "outside top", "inside top", "outside bottom", "inside bottom"] : ["outside", "inside", "outside left", "inside left", "outside right", "inside right"] } }, "ticklabelposition");
          h2("ticklabeloverflow", -1 !== A2.indexOf("inside") ? "hide past domain" : "hide past div"), a(f2, c2, h2, "linear");
          var M = r4.font, S = { noAutotickangles: true, outerTicks: false, font: M };
          -1 !== A2.indexOf("inside") && (S.bgColor = "black"), l2(f2, c2, h2, "linear", S), s(f2, c2, h2, "linear", S), o(f2, c2, h2, "linear", S), h2("title.text", r4._dfltTitle.colorbar);
          var E2 = c2.showticklabels ? c2.tickfont : M, L = n2.extendFlat({}, E2, { color: M.color, size: n2.bigFont(E2.size) });
          n2.coerceFont(h2, "title.font", L), h2("title.side", g2 ? "top" : "right");
        };
      }, 37848: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(49760), a = r3(7316), o = r3(24040), s = r3(54460), l2 = r3(86476), u2 = r3(3400), c2 = u2.strTranslate, f2 = r3(92880).extendFlat, h2 = r3(93972), p2 = r3(43616), d2 = r3(76308), v2 = r3(81668), g2 = r3(72736), y2 = r3(94288).flipScale, m2 = r3(28336), x = r3(37668), b2 = r3(94724), _ = r3(84284), w2 = _.LINE_SPACING, T = _.FROM_TL, k2 = _.FROM_BR, A2 = r3(63964).cn;
        t2.exports = { draw: function(t3) {
          var e4 = t3._fullLayout._infolayer.selectAll("g." + A2.colorbar).data(function(t4) {
            var e5, r4, n3, i2, a2 = t4._fullLayout, o2 = t4.calcdata, s2 = [];
            function l3(t5) {
              return f2(t5, { _fillcolor: null, _line: { color: null, width: null, dash: null }, _levels: { start: null, end: null, size: null }, _filllevels: null, _fillgradient: null, _zrange: null });
            }
            function u3() {
              "function" == typeof i2.calc ? i2.calc(t4, n3, e5) : (e5._fillgradient = r4.reversescale ? y2(r4.colorscale) : r4.colorscale, e5._zrange = [r4[i2.min], r4[i2.max]]);
            }
            for (var c3 = 0; c3 < o2.length; c3++) {
              var h3 = o2[c3];
              if ((n3 = h3[0].trace)._module) {
                var p3 = n3._module.colorbar;
                if (true === n3.visible && p3)
                  for (var d3 = Array.isArray(p3), v3 = d3 ? p3 : [p3], g3 = 0; g3 < v3.length; g3++) {
                    var m3 = (i2 = v3[g3]).container;
                    (r4 = m3 ? n3[m3] : n3) && r4.showscale && ((e5 = l3(r4.colorbar))._id = "cb" + n3.uid + (d3 && m3 ? "-" + m3 : ""), e5._traceIndex = n3.index, e5._propPrefix = (m3 ? m3 + "." : "") + "colorbar.", e5._meta = n3._meta, u3(), s2.push(e5));
                  }
              }
            }
            for (var x2 in a2._colorAxes)
              if ((r4 = a2[x2]).showscale) {
                var b3 = a2._colorAxes[x2];
                (e5 = l3(r4.colorbar))._id = "cb" + x2, e5._propPrefix = x2 + ".colorbar.", e5._meta = a2._meta, i2 = { min: "cmin", max: "cmax" }, "heatmap" !== b3[0] && (n3 = b3[1], i2.calc = n3._module.colorbar.calc), u3(), s2.push(e5);
              }
            return s2;
          }(t3), function(t4) {
            return t4._id;
          });
          e4.enter().append("g").attr("class", function(t4) {
            return t4._id;
          }).classed(A2.colorbar, true), e4.each(function(e5) {
            var r4 = n2.select(this);
            u2.ensureSingle(r4, "rect", A2.cbbg), u2.ensureSingle(r4, "g", A2.cbfills), u2.ensureSingle(r4, "g", A2.cblines), u2.ensureSingle(r4, "g", A2.cbaxis, function(t4) {
              t4.classed(A2.crisp, true);
            }), u2.ensureSingle(r4, "g", A2.cbtitleunshift, function(t4) {
              t4.append("g").classed(A2.cbtitle, true);
            }), u2.ensureSingle(r4, "rect", A2.cboutline);
            var y3 = function(t4, e6, r5) {
              var o2 = "v" === e6.orientation, l3 = e6.len, h3 = e6.lenmode, y4 = e6.thickness, _2 = e6.thicknessmode, M = e6.outlinewidth, S = e6.borderwidth, E2 = e6.bgcolor, L = e6.xanchor, C2 = e6.yanchor, P = e6.xpad, O = e6.ypad, I2 = e6.x, D2 = o2 ? e6.y : 1 - e6.y, z2 = "paper" === e6.yref, R = "paper" === e6.xref, F2 = r5._fullLayout, B2 = F2._size, N = e6._fillcolor, j = e6._line, U = e6.title, V = U.side, q2 = e6._zrange || n2.extent(("function" == typeof N ? N : j.color).domain()), H2 = "function" == typeof j.color ? j.color : function() {
                return j.color;
              }, G2 = "function" == typeof N ? N : function() {
                return N;
              }, W = e6._levels, Y = function(t5, e7, r6) {
                var n3, i2, a2 = e7._levels, o3 = [], s2 = [], l4 = a2.end + a2.size / 100, u3 = a2.size, c3 = 1.001 * r6[0] - 1e-3 * r6[1], f3 = 1.001 * r6[1] - 1e-3 * r6[0];
                for (i2 = 0; i2 < 1e5 && (n3 = a2.start + i2 * u3, !(u3 > 0 ? n3 >= l4 : n3 <= l4)); i2++)
                  n3 > c3 && n3 < f3 && o3.push(n3);
                if (e7._fillgradient)
                  s2 = [0];
                else if ("function" == typeof e7._fillcolor) {
                  var h4 = e7._filllevels;
                  if (h4)
                    for (l4 = h4.end + h4.size / 100, u3 = h4.size, i2 = 0; i2 < 1e5 && (n3 = h4.start + i2 * u3, !(u3 > 0 ? n3 >= l4 : n3 <= l4)); i2++)
                      n3 > r6[0] && n3 < r6[1] && s2.push(n3);
                  else
                    (s2 = o3.map(function(t6) {
                      return t6 - a2.size / 2;
                    })).push(s2[s2.length - 1] + a2.size);
                } else
                  e7._fillcolor && "string" == typeof e7._fillcolor && (s2 = [0]);
                return a2.size < 0 && (o3.reverse(), s2.reverse()), { line: o3, fill: s2 };
              }(0, e6, q2), X = Y.fill, Z = Y.line, K = Math.round(y4 * ("fraction" === _2 ? o2 ? B2.w : B2.h : 1)), J = K / (o2 ? B2.w : B2.h), $ = Math.round(l3 * ("fraction" === h3 ? o2 ? B2.h : B2.w : 1)), Q = $ / (o2 ? B2.h : B2.w), tt2 = R ? B2.w : r5._fullLayout.width, et = z2 ? B2.h : r5._fullLayout.height, rt = Math.round(o2 ? I2 * tt2 + P : D2 * et + O), nt = { center: 0.5, right: 1 }[L] || 0, it = { top: 1, middle: 0.5 }[C2] || 0, at = o2 ? I2 - nt * J : D2 - it * J, ot = o2 ? D2 - it * Q : I2 - nt * Q, st = Math.round(o2 ? et * (1 - ot) : tt2 * ot);
              e6._lenFrac = Q, e6._thickFrac = J, e6._uFrac = at, e6._vFrac = ot;
              var lt = e6._axis = function(t5, e7, r6) {
                var n3 = t5._fullLayout, i2 = "v" === e7.orientation, a2 = { type: "linear", range: r6, tickmode: e7.tickmode, nticks: e7.nticks, tick0: e7.tick0, dtick: e7.dtick, tickvals: e7.tickvals, ticktext: e7.ticktext, ticks: e7.ticks, ticklen: e7.ticklen, tickwidth: e7.tickwidth, tickcolor: e7.tickcolor, showticklabels: e7.showticklabels, labelalias: e7.labelalias, ticklabelposition: e7.ticklabelposition, ticklabeloverflow: e7.ticklabeloverflow, ticklabelstep: e7.ticklabelstep, tickfont: e7.tickfont, tickangle: e7.tickangle, tickformat: e7.tickformat, exponentformat: e7.exponentformat, minexponent: e7.minexponent, separatethousands: e7.separatethousands, showexponent: e7.showexponent, showtickprefix: e7.showtickprefix, tickprefix: e7.tickprefix, showticksuffix: e7.showticksuffix, ticksuffix: e7.ticksuffix, title: e7.title, showline: true, anchor: "free", side: i2 ? "right" : "bottom", position: 1 }, o3 = i2 ? "y" : "x", s2 = { type: "linear", _id: o3 + e7._id }, l4 = { letter: o3, font: n3.font, noAutotickangles: "y" === o3, noHover: true, noTickson: true, noTicklabelmode: true, noInsideRange: true, calendar: n3.calendar };
                function c3(t6, e8) {
                  return u2.coerce(a2, s2, b2, t6, e8);
                }
                return m2(a2, s2, c3, l4, n3), x(a2, s2, c3, l4), s2;
              }(r5, e6, q2);
              lt.position = J + (o2 ? I2 + P / B2.w : D2 + O / B2.h);
              var ut = -1 !== ["top", "bottom"].indexOf(V);
              if (o2 && ut && (lt.title.side = V, lt.titlex = I2 + P / B2.w, lt.titley = ot + ("top" === U.side ? Q - O / B2.h : O / B2.h)), o2 || ut || (lt.title.side = V, lt.titley = D2 + O / B2.h, lt.titlex = ot + P / B2.w), j.color && "auto" === e6.tickmode) {
                lt.tickmode = "linear", lt.tick0 = W.start;
                var ct = W.size, ft = u2.constrain($ / 50, 4, 15) + 1, ht = (q2[1] - q2[0]) / ((e6.nticks || ft) * ct);
                if (ht > 1) {
                  var pt = Math.pow(10, Math.floor(Math.log(ht) / Math.LN10));
                  ct *= pt * u2.roundUp(ht / pt, [2, 5, 10]), (Math.abs(W.start) / W.size + 1e-6) % 1 < 2e-6 && (lt.tick0 = 0);
                }
                lt.dtick = ct;
              }
              lt.domain = o2 ? [ot + O / B2.h, ot + Q - O / B2.h] : [ot + P / B2.w, ot + Q - P / B2.w], lt.setScale(), t4.attr("transform", c2(Math.round(B2.l), Math.round(B2.t)));
              var dt, vt = t4.select("." + A2.cbtitleunshift).attr("transform", c2(-Math.round(B2.l), -Math.round(B2.t))), gt = lt.ticklabelposition, yt = lt.title.font.size, mt = t4.select("." + A2.cbaxis), xt = 0, bt = 0;
              function _t(n3, i2) {
                var a2 = { propContainer: lt, propName: e6._propPrefix + "title", traceIndex: e6._traceIndex, _meta: e6._meta, placeholder: F2._dfltTitle.colorbar, containerGroup: t4.select("." + A2.cbtitle) }, o3 = "h" === n3.charAt(0) ? n3.substr(1) : "h" + n3;
                t4.selectAll("." + o3 + ",." + o3 + "-math-group").remove(), v2.draw(r5, n3, f2(a2, i2 || {}));
              }
              return u2.syncOrAsync([a.previousPromises, function() {
                var t5, e7;
                (o2 && ut || !o2 && !ut) && ("top" === V && (t5 = P + B2.l + tt2 * I2, e7 = O + B2.t + et * (1 - ot - Q) + 3 + 0.75 * yt), "bottom" === V && (t5 = P + B2.l + tt2 * I2, e7 = O + B2.t + et * (1 - ot) - 3 - 0.25 * yt), "right" === V && (e7 = O + B2.t + et * D2 + 3 + 0.75 * yt, t5 = P + B2.l + tt2 * ot), _t(lt._id + "title", { attributes: { x: t5, y: e7, "text-anchor": o2 ? "start" : "middle" } }));
              }, function() {
                if (!o2 && !ut || o2 && ut) {
                  var a2, l4 = t4.select("." + A2.cbtitle), f3 = l4.select("text"), h4 = [-M / 2, M / 2], d3 = l4.select(".h" + lt._id + "title-math-group").node(), v3 = 15.6;
                  if (f3.node() && (v3 = parseInt(f3.node().style.fontSize, 10) * w2), d3 ? (a2 = p2.bBox(d3), bt = a2.width, (xt = a2.height) > v3 && (h4[1] -= (xt - v3) / 2)) : f3.node() && !f3.classed(A2.jsPlaceholder) && (a2 = p2.bBox(f3.node()), bt = a2.width, xt = a2.height), o2) {
                    if (xt) {
                      if (xt += 5, "top" === V)
                        lt.domain[1] -= xt / B2.h, h4[1] *= -1;
                      else {
                        lt.domain[0] += xt / B2.h;
                        var y5 = g2.lineCount(f3);
                        h4[1] += (1 - y5) * v3;
                      }
                      l4.attr("transform", c2(h4[0], h4[1])), lt.setScale();
                    }
                  } else
                    bt && ("right" === V && (lt.domain[0] += (bt + yt / 2) / B2.w), l4.attr("transform", c2(h4[0], h4[1])), lt.setScale());
                }
                t4.selectAll("." + A2.cbfills + ",." + A2.cblines).attr("transform", o2 ? c2(0, Math.round(B2.h * (1 - lt.domain[1]))) : c2(Math.round(B2.w * lt.domain[0]), 0)), mt.attr("transform", o2 ? c2(0, Math.round(-B2.t)) : c2(Math.round(-B2.l), 0));
                var m3 = t4.select("." + A2.cbfills).selectAll("rect." + A2.cbfill).attr("style", "").data(X);
                m3.enter().append("rect").classed(A2.cbfill, true).attr("style", ""), m3.exit().remove();
                var x2 = q2.map(lt.c2p).map(Math.round).sort(function(t5, e7) {
                  return t5 - e7;
                });
                m3.each(function(t5, a3) {
                  var s2 = [0 === a3 ? q2[0] : (X[a3] + X[a3 - 1]) / 2, a3 === X.length - 1 ? q2[1] : (X[a3] + X[a3 + 1]) / 2].map(lt.c2p).map(Math.round);
                  o2 && (s2[1] = u2.constrain(s2[1] + (s2[1] > s2[0]) ? 1 : -1, x2[0], x2[1]));
                  var l5 = n2.select(this).attr(o2 ? "x" : "y", rt).attr(o2 ? "y" : "x", n2.min(s2)).attr(o2 ? "width" : "height", Math.max(K, 2)).attr(o2 ? "height" : "width", Math.max(n2.max(s2) - n2.min(s2), 2));
                  if (e6._fillgradient)
                    p2.gradient(l5, r5, e6._id, o2 ? "vertical" : "horizontalreversed", e6._fillgradient, "fill");
                  else {
                    var c3 = G2(t5).replace("e-", "");
                    l5.attr("fill", i(c3).toHexString());
                  }
                });
                var b3 = t4.select("." + A2.cblines).selectAll("path." + A2.cbline).data(j.color && j.width ? Z : []);
                b3.enter().append("path").classed(A2.cbline, true), b3.exit().remove(), b3.each(function(t5) {
                  var e7 = rt, r6 = Math.round(lt.c2p(t5)) + j.width / 2 % 1;
                  n2.select(this).attr("d", "M" + (o2 ? e7 + "," + r6 : r6 + "," + e7) + (o2 ? "h" : "v") + K).call(p2.lineGroupStyle, j.width, H2(t5), j.dash);
                }), mt.selectAll("g." + lt._id + "tick,path").remove();
                var _3 = rt + K + (M || 0) / 2 - ("outside" === e6.ticks ? 1 : 0), T2 = s.calcTicks(lt), k3 = s.getTickSigns(lt)[2];
                return s.drawTicks(r5, lt, { vals: "inside" === lt.ticks ? s.clipEnds(lt, T2) : T2, layer: mt, path: s.makeTickPath(lt, _3, k3), transFn: s.makeTransTickFn(lt) }), s.drawLabels(r5, lt, { vals: T2, layer: mt, transFn: s.makeTransTickLabelFn(lt), labelFns: s.makeLabelFns(lt, _3) });
              }, function() {
                if (o2 && !ut || !o2 && ut) {
                  var t5, i2, a2 = lt.position || 0, s2 = lt._offset + lt._length / 2;
                  if ("right" === V)
                    i2 = s2, t5 = B2.l + tt2 * a2 + 10 + yt * (lt.showticklabels ? 1 : 0.5);
                  else if (t5 = s2, "bottom" === V && (i2 = B2.t + et * a2 + 10 + (-1 === gt.indexOf("inside") ? lt.tickfont.size : 0) + ("intside" !== lt.ticks && e6.ticklen || 0)), "top" === V) {
                    var l4 = U.text.split("<br>").length;
                    i2 = B2.t + et * a2 + 10 - K - w2 * yt * l4;
                  }
                  _t((o2 ? "h" : "v") + lt._id + "title", { avoid: { selection: n2.select(r5).selectAll("g." + lt._id + "tick"), side: V, offsetTop: o2 ? 0 : B2.t, offsetLeft: o2 ? B2.l : 0, maxShift: o2 ? F2.width : F2.height }, attributes: { x: t5, y: i2, "text-anchor": "middle" }, transform: { rotate: o2 ? -90 : 0, offset: 0 } });
                }
              }, a.previousPromises, function() {
                var n3, s2 = K + M / 2;
                -1 === gt.indexOf("inside") && (n3 = p2.bBox(mt.node()), s2 += o2 ? n3.width : n3.height), dt = vt.select("text");
                var u3 = 0, f3 = o2 && "top" === V, v3 = !o2 && "right" === V, g3 = 0;
                if (dt.node() && !dt.classed(A2.jsPlaceholder)) {
                  var m3, x2 = vt.select(".h" + lt._id + "title-math-group").node();
                  x2 && (o2 && ut || !o2 && !ut) ? (u3 = (n3 = p2.bBox(x2)).width, m3 = n3.height) : (u3 = (n3 = p2.bBox(vt.node())).right - B2.l - (o2 ? rt : st), m3 = n3.bottom - B2.t - (o2 ? st : rt), o2 || "top" !== V || (s2 += n3.height, g3 = n3.height)), v3 && (dt.attr("transform", c2(u3 / 2 + yt / 2, 0)), u3 *= 2), s2 = Math.max(s2, o2 ? u3 : m3);
                }
                var b3 = 2 * (o2 ? P : O) + s2 + S + M / 2, w3 = 0;
                !o2 && U.text && "bottom" === C2 && D2 <= 0 && (b3 += w3 = b3 / 2, g3 += w3), F2._hColorbarMoveTitle = w3, F2._hColorbarMoveCBTitle = g3;
                var N2 = S + M, j2 = (o2 ? rt : st) - N2 / 2 - (o2 ? P : 0), q3 = (o2 ? st : rt) - (o2 ? $ : O + g3 - w3);
                t4.select("." + A2.cbbg).attr("x", j2).attr("y", q3).attr(o2 ? "width" : "height", Math.max(b3 - w3, 2)).attr(o2 ? "height" : "width", Math.max($ + N2, 2)).call(d2.fill, E2).call(d2.stroke, e6.bordercolor).style("stroke-width", S);
                var H3 = v3 ? Math.max(u3 - 10, 0) : 0;
                t4.selectAll("." + A2.cboutline).attr("x", (o2 ? rt : st + P) + H3).attr("y", (o2 ? st + O - $ : rt) + (f3 ? xt : 0)).attr(o2 ? "width" : "height", Math.max(K, 2)).attr(o2 ? "height" : "width", Math.max($ - (o2 ? 2 * O + xt : 2 * P + H3), 2)).call(d2.stroke, e6.outlinecolor).style({ fill: "none", "stroke-width": M });
                var G3 = o2 ? nt * b3 : 0, W2 = o2 ? 0 : (1 - it) * b3 - g3;
                if (G3 = R ? B2.l - G3 : -G3, W2 = z2 ? B2.t - W2 : -W2, t4.attr("transform", c2(G3, W2)), !o2 && (S || i(E2).getAlpha() && !i.equals(F2.paper_bgcolor, E2))) {
                  var Y2 = mt.selectAll("text"), X2 = Y2[0].length, Z2 = t4.select("." + A2.cbbg).node(), J2 = p2.bBox(Z2), Q2 = p2.getTranslate(t4);
                  Y2.each(function(t5, e7) {
                    var r6 = X2 - 1;
                    if (0 === e7 || e7 === r6) {
                      var n4, i2 = p2.bBox(this), a2 = p2.getTranslate(this);
                      if (e7 === r6) {
                        var o3 = i2.right + a2.x;
                        (n4 = J2.right + Q2.x + st - S - 2 + I2 - o3) > 0 && (n4 = 0);
                      } else if (0 === e7) {
                        var s3 = i2.left + a2.x;
                        (n4 = J2.left + Q2.x + st + S + 2 - s3) < 0 && (n4 = 0);
                      }
                      n4 && (X2 < 3 ? this.setAttribute("transform", "translate(" + n4 + ",0) " + this.getAttribute("transform")) : this.setAttribute("visibility", "hidden"));
                    }
                  });
                }
                var tt3 = {}, et2 = T[L], at2 = k2[L], ot2 = T[C2], ct2 = k2[C2], ft2 = b3 - K;
                o2 ? ("pixels" === h3 ? (tt3.y = D2, tt3.t = $ * ot2, tt3.b = $ * ct2) : (tt3.t = tt3.b = 0, tt3.yt = D2 + l3 * ot2, tt3.yb = D2 - l3 * ct2), "pixels" === _2 ? (tt3.x = I2, tt3.l = b3 * et2, tt3.r = b3 * at2) : (tt3.l = ft2 * et2, tt3.r = ft2 * at2, tt3.xl = I2 - y4 * et2, tt3.xr = I2 + y4 * at2)) : ("pixels" === h3 ? (tt3.x = I2, tt3.l = $ * et2, tt3.r = $ * at2) : (tt3.l = tt3.r = 0, tt3.xl = I2 + l3 * et2, tt3.xr = I2 - l3 * at2), "pixels" === _2 ? (tt3.y = 1 - D2, tt3.t = b3 * ot2, tt3.b = b3 * ct2) : (tt3.t = ft2 * ot2, tt3.b = ft2 * ct2, tt3.yt = D2 - y4 * ot2, tt3.yb = D2 + y4 * ct2));
                var ht2 = e6.y < 0.5 ? "b" : "t", pt2 = e6.x < 0.5 ? "l" : "r";
                r5._fullLayout._reservedMargin[e6._id] = {};
                var bt2 = { r: F2.width - j2 - G3, l: j2 + tt3.r, b: F2.height - q3 - W2, t: q3 + tt3.b };
                R && z2 ? a.autoMargin(r5, e6._id, tt3) : R ? r5._fullLayout._reservedMargin[e6._id][ht2] = bt2[ht2] : z2 || o2 ? r5._fullLayout._reservedMargin[e6._id][pt2] = bt2[pt2] : r5._fullLayout._reservedMargin[e6._id][ht2] = bt2[ht2];
              }], r5);
            }(r4, e5, t3);
            y3 && y3.then && (t3._promises || []).push(y3), t3._context.edits.colorbarPosition && function(t4, e6, r5) {
              var n3, i2, a2, s2 = "v" === e6.orientation, u3 = r5._fullLayout._size;
              l2.init({ element: t4.node(), gd: r5, prepFn: function() {
                n3 = t4.attr("transform"), h2(t4);
              }, moveFn: function(r6, o2) {
                t4.attr("transform", n3 + c2(r6, o2)), i2 = l2.align((s2 ? e6._uFrac : e6._vFrac) + r6 / u3.w, s2 ? e6._thickFrac : e6._lenFrac, 0, 1, e6.xanchor), a2 = l2.align((s2 ? e6._vFrac : 1 - e6._uFrac) - o2 / u3.h, s2 ? e6._lenFrac : e6._thickFrac, 0, 1, e6.yanchor);
                var f3 = l2.getCursor(i2, a2, e6.xanchor, e6.yanchor);
                h2(t4, f3);
              }, doneFn: function() {
                if (h2(t4), void 0 !== i2 && void 0 !== a2) {
                  var n4 = {};
                  n4[e6._propPrefix + "x"] = i2, n4[e6._propPrefix + "y"] = a2, void 0 !== e6._traceIndex ? o.call("_guiRestyle", r5, n4, e6._traceIndex) : o.call("_guiRelayout", r5, n4);
                }
              } });
            }(r4, e5, t3);
          }), e4.exit().each(function(e5) {
            a.autoMargin(t3, e5._id);
          }).remove(), e4.order();
        } };
      }, 90553: function(t2, e3, r3) {
        var n2 = r3(3400);
        t2.exports = function(t3) {
          return n2.isPlainObject(t3.colorbar);
        };
      }, 55080: function(t2, e3, r3) {
        t2.exports = { moduleType: "component", name: "colorbar", attributes: r3(42996), supplyDefaults: r3(64013), draw: r3(37848).draw, hasColorbar: r3(90553) };
      }, 49084: function(t2, e3, r3) {
        var n2 = r3(42996), i = r3(53756).counter, a = r3(95376), o = r3(88304).scales;
        function s(t3) {
          return "`" + t3 + "`";
        }
        a(o), t2.exports = function(t3, e4) {
          t3 = t3 || "";
          var r4, a2 = (e4 = e4 || {}).cLetter || "c", l2 = ("onlyIfNumerical" in e4 ? e4.onlyIfNumerical : Boolean(t3), "noScale" in e4 ? e4.noScale : "marker.line" === t3), u2 = "showScaleDflt" in e4 ? e4.showScaleDflt : "z" === a2, c2 = "string" == typeof e4.colorscaleDflt ? o[e4.colorscaleDflt] : null, f2 = e4.editTypeOverride || "", h2 = t3 ? t3 + "." : "";
          "colorAttr" in e4 ? (r4 = e4.colorAttr, e4.colorAttr) : s(h2 + (r4 = { z: "z", c: "color" }[a2]));
          var p2 = a2 + "auto", d2 = a2 + "min", v2 = a2 + "max", g2 = a2 + "mid", y2 = {};
          y2[d2] = y2[v2] = void 0;
          var m2 = {};
          m2[p2] = false;
          var x = {};
          return "color" === r4 && (x.color = { valType: "color", arrayOk: true, editType: f2 || "style" }, e4.anim && (x.color.anim = true)), x[p2] = { valType: "boolean", dflt: true, editType: "calc", impliedEdits: y2 }, x[d2] = { valType: "number", dflt: null, editType: f2 || "plot", impliedEdits: m2 }, x[v2] = { valType: "number", dflt: null, editType: f2 || "plot", impliedEdits: m2 }, x[g2] = { valType: "number", dflt: null, editType: "calc", impliedEdits: y2 }, x.colorscale = { valType: "colorscale", editType: "calc", dflt: c2, impliedEdits: { autocolorscale: false } }, x.autocolorscale = { valType: "boolean", dflt: false !== e4.autoColorDflt, editType: "calc", impliedEdits: { colorscale: void 0 } }, x.reversescale = { valType: "boolean", dflt: false, editType: "plot" }, l2 || (x.showscale = { valType: "boolean", dflt: u2, editType: "calc" }, x.colorbar = n2), e4.noColorAxis || (x.coloraxis = { valType: "subplotid", regex: i("coloraxis"), dflt: null, editType: "calc" }), x;
        };
      }, 47128: function(t2, e3, r3) {
        var n2 = r3(38248), i = r3(3400), a = r3(94288).extractOpts;
        t2.exports = function(t3, e4, r4) {
          var o, s = t3._fullLayout, l2 = r4.vals, u2 = r4.containerStr, c2 = u2 ? i.nestedProperty(e4, u2).get() : e4, f2 = a(c2), h2 = false !== f2.auto, p2 = f2.min, d2 = f2.max, v2 = f2.mid, g2 = function() {
            return i.aggNums(Math.min, null, l2);
          }, y2 = function() {
            return i.aggNums(Math.max, null, l2);
          };
          void 0 === p2 ? p2 = g2() : h2 && (p2 = c2._colorAx && n2(p2) ? Math.min(p2, g2()) : g2()), void 0 === d2 ? d2 = y2() : h2 && (d2 = c2._colorAx && n2(d2) ? Math.max(d2, y2()) : y2()), h2 && void 0 !== v2 && (d2 - v2 > v2 - p2 ? p2 = v2 - (d2 - v2) : d2 - v2 < v2 - p2 && (d2 = v2 + (v2 - p2))), p2 === d2 && (p2 -= 0.5, d2 += 0.5), f2._sync("min", p2), f2._sync("max", d2), f2.autocolorscale && (o = p2 * d2 < 0 ? s.colorscale.diverging : p2 >= 0 ? s.colorscale.sequential : s.colorscale.sequentialminus, f2._sync("colorscale", o));
        };
      }, 95504: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(94288).hasColorscale, a = r3(94288).extractOpts;
        t2.exports = function(t3, e4) {
          function r4(t4, e5) {
            var r5 = t4["_" + e5];
            void 0 !== r5 && (t4[e5] = r5);
          }
          function o(t4, i2) {
            var o2 = i2.container ? n2.nestedProperty(t4, i2.container).get() : t4;
            if (o2)
              if (o2.coloraxis)
                o2._colorAx = e4[o2.coloraxis];
              else {
                var s2 = a(o2), l3 = s2.auto;
                (l3 || void 0 === s2.min) && r4(o2, i2.min), (l3 || void 0 === s2.max) && r4(o2, i2.max), s2.autocolorscale && r4(o2, "colorscale");
              }
          }
          for (var s = 0; s < t3.length; s++) {
            var l2 = t3[s], u2 = l2._module.colorbar;
            if (u2)
              if (Array.isArray(u2))
                for (var c2 = 0; c2 < u2.length; c2++)
                  o(l2, u2[c2]);
              else
                o(l2, u2);
            i(l2, "marker.line") && o(l2, { container: "marker.line", min: "cmin", max: "cmax" });
          }
          for (var f2 in e4._colorAxes)
            o(e4[f2], { min: "cmin", max: "cmax" });
        };
      }, 27260: function(t2, e3, r3) {
        var n2 = r3(38248), i = r3(3400), a = r3(90553), o = r3(64013), s = r3(88304).isValid, l2 = r3(24040).traceIs;
        function u2(t3, e4) {
          var r4 = e4.slice(0, e4.length - 1);
          return e4 ? i.nestedProperty(t3, r4).get() || {} : t3;
        }
        t2.exports = function t3(e4, r4, c2, f2, h2) {
          var p2 = h2.prefix, d2 = h2.cLetter, v2 = "_module" in r4, g2 = u2(e4, p2), y2 = u2(r4, p2), m2 = u2(r4._template || {}, p2) || {}, x = function() {
            return delete e4.coloraxis, delete r4.coloraxis, t3(e4, r4, c2, f2, h2);
          };
          if (v2) {
            var b2 = c2._colorAxes || {}, _ = f2(p2 + "coloraxis");
            if (_) {
              var w2 = l2(r4, "contour") && i.nestedProperty(r4, "contours.coloring").get() || "heatmap", T = b2[_];
              return void (T ? (T[2].push(x), T[0] !== w2 && (T[0] = false, i.warn(["Ignoring coloraxis:", _, "setting", "as it is linked to incompatible colorscales."].join(" ")))) : b2[_] = [w2, r4, [x]]);
            }
          }
          var k2 = g2[d2 + "min"], A2 = g2[d2 + "max"], M = n2(k2) && n2(A2) && k2 < A2;
          f2(p2 + d2 + "auto", !M) ? f2(p2 + d2 + "mid") : (f2(p2 + d2 + "min"), f2(p2 + d2 + "max"));
          var S, E2, L = g2.colorscale, C2 = m2.colorscale;
          void 0 !== L && (S = !s(L)), void 0 !== C2 && (S = !s(C2)), f2(p2 + "autocolorscale", S), f2(p2 + "colorscale"), f2(p2 + "reversescale"), "marker.line." !== p2 && (p2 && v2 && (E2 = a(g2)), f2(p2 + "showscale", E2) && (p2 && m2 && (y2._template = m2), o(g2, y2, c2)));
        };
      }, 94288: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(49760), a = r3(38248), o = r3(3400), s = r3(76308), l2 = r3(88304).isValid, u2 = ["showscale", "autocolorscale", "colorscale", "reversescale", "colorbar"], c2 = ["min", "max", "mid", "auto"];
        function f2(t3) {
          var e4, r4, n3, i2 = t3._colorAx, a2 = i2 || t3, o2 = {};
          for (r4 = 0; r4 < u2.length; r4++)
            o2[n3 = u2[r4]] = a2[n3];
          if (i2)
            for (e4 = "c", r4 = 0; r4 < c2.length; r4++)
              o2[n3 = c2[r4]] = a2["c" + n3];
          else {
            var s2;
            for (r4 = 0; r4 < c2.length; r4++)
              ((s2 = "c" + (n3 = c2[r4])) in a2 || (s2 = "z" + n3) in a2) && (o2[n3] = a2[s2]);
            e4 = s2.charAt(0);
          }
          return o2._sync = function(t4, r5) {
            var n4 = -1 !== c2.indexOf(t4) ? e4 + t4 : t4;
            a2[n4] = a2["_" + n4] = r5;
          }, o2;
        }
        function h2(t3) {
          for (var e4 = f2(t3), r4 = e4.min, n3 = e4.max, i2 = e4.reversescale ? p2(e4.colorscale) : e4.colorscale, a2 = i2.length, o2 = new Array(a2), s2 = new Array(a2), l3 = 0; l3 < a2; l3++) {
            var u3 = i2[l3];
            o2[l3] = r4 + u3[0] * (n3 - r4), s2[l3] = u3[1];
          }
          return { domain: o2, range: s2 };
        }
        function p2(t3) {
          for (var e4 = t3.length, r4 = new Array(e4), n3 = e4 - 1, i2 = 0; n3 >= 0; n3--, i2++) {
            var a2 = t3[n3];
            r4[i2] = [1 - a2[0], a2[1]];
          }
          return r4;
        }
        function d2(t3, e4) {
          e4 = e4 || {};
          for (var r4 = t3.domain, o2 = t3.range, l3 = o2.length, u3 = new Array(l3), c3 = 0; c3 < l3; c3++) {
            var f3 = i(o2[c3]).toRgb();
            u3[c3] = [f3.r, f3.g, f3.b, f3.a];
          }
          var h3, p3 = n2.scale.linear().domain(r4).range(u3).clamp(true), d3 = e4.noNumericCheck, g2 = e4.returnArray;
          return (h3 = d3 && g2 ? p3 : d3 ? function(t4) {
            return v2(p3(t4));
          } : g2 ? function(t4) {
            return a(t4) ? p3(t4) : i(t4).isValid() ? t4 : s.defaultLine;
          } : function(t4) {
            return a(t4) ? v2(p3(t4)) : i(t4).isValid() ? t4 : s.defaultLine;
          }).domain = p3.domain, h3.range = function() {
            return o2;
          }, h3;
        }
        function v2(t3) {
          var e4 = { r: t3[0], g: t3[1], b: t3[2], a: t3[3] };
          return i(e4).toRgbString();
        }
        t2.exports = { hasColorscale: function(t3, e4, r4) {
          var n3 = e4 ? o.nestedProperty(t3, e4).get() || {} : t3, i2 = n3[r4 || "color"];
          i2 && i2._inputArray && (i2 = i2._inputArray);
          var s2 = false;
          if (o.isArrayOrTypedArray(i2)) {
            for (var u3 = 0; u3 < i2.length; u3++)
              if (a(i2[u3])) {
                s2 = true;
                break;
              }
          }
          return o.isPlainObject(n3) && (s2 || true === n3.showscale || a(n3.cmin) && a(n3.cmax) || l2(n3.colorscale) || o.isPlainObject(n3.colorbar));
        }, extractOpts: f2, extractScale: h2, flipScale: p2, makeColorScaleFunc: d2, makeColorScaleFuncFromTrace: function(t3, e4) {
          return d2(h2(t3), e4);
        } };
      }, 8932: function(t2, e3, r3) {
        var n2 = r3(88304), i = r3(94288);
        t2.exports = { moduleType: "component", name: "colorscale", attributes: r3(49084), layoutAttributes: r3(92332), supplyLayoutDefaults: r3(51608), handleDefaults: r3(27260), crossTraceDefaults: r3(95504), calc: r3(47128), scales: n2.scales, defaultScale: n2.defaultScale, getScale: n2.get, isValidScale: n2.isValid, hasColorscale: i.hasColorscale, extractOpts: i.extractOpts, extractScale: i.extractScale, flipScale: i.flipScale, makeColorScaleFunc: i.makeColorScaleFunc, makeColorScaleFuncFromTrace: i.makeColorScaleFuncFromTrace };
      }, 92332: function(t2, e3, r3) {
        var n2 = r3(92880).extendFlat, i = r3(49084), a = r3(88304).scales;
        t2.exports = { editType: "calc", colorscale: { editType: "calc", sequential: { valType: "colorscale", dflt: a.Reds, editType: "calc" }, sequentialminus: { valType: "colorscale", dflt: a.Blues, editType: "calc" }, diverging: { valType: "colorscale", dflt: a.RdBu, editType: "calc" } }, coloraxis: n2({ _isSubplotObj: true, editType: "calc" }, i("", { colorAttr: "corresponding trace color array(s)", noColorAxis: true, showScaleDflt: true })) };
      }, 51608: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(31780), a = r3(92332), o = r3(27260);
        t2.exports = function(t3, e4) {
          function r4(r5, i2) {
            return n2.coerce(t3, e4, a, r5, i2);
          }
          r4("colorscale.sequential"), r4("colorscale.sequentialminus"), r4("colorscale.diverging");
          var s, l2, u2 = e4._colorAxes;
          function c2(t4, e5) {
            return n2.coerce(s, l2, a.coloraxis, t4, e5);
          }
          for (var f2 in u2) {
            var h2 = u2[f2];
            if (h2[0])
              s = t3[f2] || {}, (l2 = i.newContainer(e4, f2, "coloraxis"))._name = f2, o(s, l2, e4, c2, { prefix: "", cLetter: "c" });
            else {
              for (var p2 = 0; p2 < h2[2].length; p2++)
                h2[2][p2]();
              delete e4._colorAxes[f2];
            }
          }
        };
      }, 88304: function(t2, e3, r3) {
        var n2 = r3(49760), i = { Greys: [[0, "rgb(0,0,0)"], [1, "rgb(255,255,255)"]], YlGnBu: [[0, "rgb(8,29,88)"], [0.125, "rgb(37,52,148)"], [0.25, "rgb(34,94,168)"], [0.375, "rgb(29,145,192)"], [0.5, "rgb(65,182,196)"], [0.625, "rgb(127,205,187)"], [0.75, "rgb(199,233,180)"], [0.875, "rgb(237,248,217)"], [1, "rgb(255,255,217)"]], Greens: [[0, "rgb(0,68,27)"], [0.125, "rgb(0,109,44)"], [0.25, "rgb(35,139,69)"], [0.375, "rgb(65,171,93)"], [0.5, "rgb(116,196,118)"], [0.625, "rgb(161,217,155)"], [0.75, "rgb(199,233,192)"], [0.875, "rgb(229,245,224)"], [1, "rgb(247,252,245)"]], YlOrRd: [[0, "rgb(128,0,38)"], [0.125, "rgb(189,0,38)"], [0.25, "rgb(227,26,28)"], [0.375, "rgb(252,78,42)"], [0.5, "rgb(253,141,60)"], [0.625, "rgb(254,178,76)"], [0.75, "rgb(254,217,118)"], [0.875, "rgb(255,237,160)"], [1, "rgb(255,255,204)"]], Bluered: [[0, "rgb(0,0,255)"], [1, "rgb(255,0,0)"]], RdBu: [[0, "rgb(5,10,172)"], [0.35, "rgb(106,137,247)"], [0.5, "rgb(190,190,190)"], [0.6, "rgb(220,170,132)"], [0.7, "rgb(230,145,90)"], [1, "rgb(178,10,28)"]], Reds: [[0, "rgb(220,220,220)"], [0.2, "rgb(245,195,157)"], [0.4, "rgb(245,160,105)"], [1, "rgb(178,10,28)"]], Blues: [[0, "rgb(5,10,172)"], [0.35, "rgb(40,60,190)"], [0.5, "rgb(70,100,245)"], [0.6, "rgb(90,120,245)"], [0.7, "rgb(106,137,247)"], [1, "rgb(220,220,220)"]], Picnic: [[0, "rgb(0,0,255)"], [0.1, "rgb(51,153,255)"], [0.2, "rgb(102,204,255)"], [0.3, "rgb(153,204,255)"], [0.4, "rgb(204,204,255)"], [0.5, "rgb(255,255,255)"], [0.6, "rgb(255,204,255)"], [0.7, "rgb(255,153,255)"], [0.8, "rgb(255,102,204)"], [0.9, "rgb(255,102,102)"], [1, "rgb(255,0,0)"]], Rainbow: [[0, "rgb(150,0,90)"], [0.125, "rgb(0,0,200)"], [0.25, "rgb(0,25,255)"], [0.375, "rgb(0,152,255)"], [0.5, "rgb(44,255,150)"], [0.625, "rgb(151,255,0)"], [0.75, "rgb(255,234,0)"], [0.875, "rgb(255,111,0)"], [1, "rgb(255,0,0)"]], Portland: [[0, "rgb(12,51,131)"], [0.25, "rgb(10,136,186)"], [0.5, "rgb(242,211,56)"], [0.75, "rgb(242,143,56)"], [1, "rgb(217,30,30)"]], Jet: [[0, "rgb(0,0,131)"], [0.125, "rgb(0,60,170)"], [0.375, "rgb(5,255,255)"], [0.625, "rgb(255,255,0)"], [0.875, "rgb(250,0,0)"], [1, "rgb(128,0,0)"]], Hot: [[0, "rgb(0,0,0)"], [0.3, "rgb(230,0,0)"], [0.6, "rgb(255,210,0)"], [1, "rgb(255,255,255)"]], Blackbody: [[0, "rgb(0,0,0)"], [0.2, "rgb(230,0,0)"], [0.4, "rgb(230,210,0)"], [0.7, "rgb(255,255,255)"], [1, "rgb(160,200,255)"]], Earth: [[0, "rgb(0,0,130)"], [0.1, "rgb(0,180,180)"], [0.2, "rgb(40,210,40)"], [0.4, "rgb(230,230,50)"], [0.6, "rgb(120,70,20)"], [1, "rgb(255,255,255)"]], Electric: [[0, "rgb(0,0,0)"], [0.15, "rgb(30,0,100)"], [0.4, "rgb(120,0,100)"], [0.6, "rgb(160,90,0)"], [0.8, "rgb(230,200,0)"], [1, "rgb(255,250,220)"]], Viridis: [[0, "#440154"], [0.06274509803921569, "#48186a"], [0.12549019607843137, "#472d7b"], [0.18823529411764706, "#424086"], [0.25098039215686274, "#3b528b"], [0.3137254901960784, "#33638d"], [0.3764705882352941, "#2c728e"], [0.4392156862745098, "#26828e"], [0.5019607843137255, "#21918c"], [0.5647058823529412, "#1fa088"], [0.6274509803921569, "#28ae80"], [0.6901960784313725, "#3fbc73"], [0.7529411764705882, "#5ec962"], [0.8156862745098039, "#84d44b"], [0.8784313725490196, "#addc30"], [0.9411764705882353, "#d8e219"], [1, "#fde725"]], Cividis: [[0, "rgb(0,32,76)"], [0.058824, "rgb(0,42,102)"], [0.117647, "rgb(0,52,110)"], [0.176471, "rgb(39,63,108)"], [0.235294, "rgb(60,74,107)"], [0.294118, "rgb(76,85,107)"], [0.352941, "rgb(91,95,109)"], [0.411765, "rgb(104,106,112)"], [0.470588, "rgb(117,117,117)"], [0.529412, "rgb(131,129,120)"], [0.588235, "rgb(146,140,120)"], [0.647059, "rgb(161,152,118)"], [0.705882, "rgb(176,165,114)"], [0.764706, "rgb(192,177,109)"], [0.823529, "rgb(209,191,102)"], [0.882353, "rgb(225,204,92)"], [0.941176, "rgb(243,219,79)"], [1, "rgb(255,233,69)"]] }, a = i.RdBu;
        function o(t3) {
          var e4 = 0;
          if (!Array.isArray(t3) || t3.length < 2)
            return false;
          if (!t3[0] || !t3[t3.length - 1])
            return false;
          if (0 != +t3[0][0] || 1 != +t3[t3.length - 1][0])
            return false;
          for (var r4 = 0; r4 < t3.length; r4++) {
            var i2 = t3[r4];
            if (2 !== i2.length || +i2[0] < e4 || !n2(i2[1]).isValid())
              return false;
            e4 = +i2[0];
          }
          return true;
        }
        t2.exports = { scales: i, defaultScale: a, get: function(t3, e4) {
          if (e4 || (e4 = a), !t3)
            return e4;
          function r4() {
            try {
              t3 = i[t3] || JSON.parse(t3);
            } catch (r5) {
              t3 = e4;
            }
          }
          return "string" == typeof t3 && (r4(), "string" == typeof t3 && r4()), o(t3) ? t3 : e4;
        }, isValid: function(t3) {
          return void 0 !== i[t3] || o(t3);
        } };
      }, 78316: function(t2) {
        t2.exports = function(t3, e3, r3, n2, i) {
          var a = (t3 - r3) / (n2 - r3), o = a + e3 / (n2 - r3), s = (a + o) / 2;
          return "left" === i || "bottom" === i ? a : "center" === i || "middle" === i ? s : "right" === i || "top" === i ? o : a < 2 / 3 - s ? a : o > 4 / 3 - s ? o : s;
        };
      }, 67416: function(t2, e3, r3) {
        var n2 = r3(3400), i = [["sw-resize", "s-resize", "se-resize"], ["w-resize", "move", "e-resize"], ["nw-resize", "n-resize", "ne-resize"]];
        t2.exports = function(t3, e4, r4, a) {
          return t3 = "left" === r4 ? 0 : "center" === r4 ? 1 : "right" === r4 ? 2 : n2.constrain(Math.floor(3 * t3), 0, 2), e4 = "bottom" === a ? 0 : "middle" === a ? 1 : "top" === a ? 2 : n2.constrain(Math.floor(3 * e4), 0, 2), i[e4][t3];
        };
      }, 72760: function(t2, e3) {
        e3.selectMode = function(t3) {
          return "lasso" === t3 || "select" === t3;
        }, e3.drawMode = function(t3) {
          return "drawclosedpath" === t3 || "drawopenpath" === t3 || "drawline" === t3 || "drawrect" === t3 || "drawcircle" === t3;
        }, e3.openMode = function(t3) {
          return "drawline" === t3 || "drawopenpath" === t3;
        }, e3.rectMode = function(t3) {
          return "select" === t3 || "drawline" === t3 || "drawrect" === t3 || "drawcircle" === t3;
        }, e3.freeMode = function(t3) {
          return "lasso" === t3 || "drawclosedpath" === t3 || "drawopenpath" === t3;
        }, e3.selectingOrDrawing = function(t3) {
          return e3.freeMode(t3) || e3.rectMode(t3);
        };
      }, 86476: function(t2, e3, r3) {
        var n2 = r3(29128), i = r3(52264), a = r3(89184), o = r3(3400).removeElement, s = r3(33816), l2 = t2.exports = {};
        l2.align = r3(78316), l2.getCursor = r3(67416);
        var u2 = r3(2616);
        function c2() {
          var t3 = document.createElement("div");
          t3.className = "dragcover";
          var e4 = t3.style;
          return e4.position = "fixed", e4.left = 0, e4.right = 0, e4.top = 0, e4.bottom = 0, e4.zIndex = 999999999, e4.background = "none", document.body.appendChild(t3), t3;
        }
        function f2(t3) {
          return n2(t3.changedTouches ? t3.changedTouches[0] : t3, document.body);
        }
        l2.unhover = u2.wrapped, l2.unhoverRaw = u2.raw, l2.init = function(t3) {
          var e4, r4, n3, u3, h2, p2, d2, v2, g2 = t3.gd, y2 = 1, m2 = g2._context.doubleClickDelay, x = t3.element;
          g2._mouseDownTime || (g2._mouseDownTime = 0), x.style.pointerEvents = "all", x.onmousedown = _, a ? (x._ontouchstart && x.removeEventListener("touchstart", x._ontouchstart), x._ontouchstart = _, x.addEventListener("touchstart", _, { passive: false })) : x.ontouchstart = _;
          var b2 = t3.clampFn || function(t4, e5, r5) {
            return Math.abs(t4) < r5 && (t4 = 0), Math.abs(e5) < r5 && (e5 = 0), [t4, e5];
          };
          function _(a2) {
            g2._dragged = false, g2._dragging = true;
            var o2 = f2(a2);
            e4 = o2[0], r4 = o2[1], d2 = a2.target, p2 = a2, v2 = 2 === a2.buttons || a2.ctrlKey, void 0 === a2.clientX && void 0 === a2.clientY && (a2.clientX = e4, a2.clientY = r4), (n3 = new Date().getTime()) - g2._mouseDownTime < m2 ? y2 += 1 : (y2 = 1, g2._mouseDownTime = n3), t3.prepFn && t3.prepFn(a2, e4, r4), i && !v2 ? (h2 = c2()).style.cursor = window.getComputedStyle(x).cursor : i || (h2 = document, u3 = window.getComputedStyle(document.documentElement).cursor, document.documentElement.style.cursor = window.getComputedStyle(x).cursor), document.addEventListener("mouseup", T), document.addEventListener("touchend", T), false !== t3.dragmode && (a2.preventDefault(), document.addEventListener("mousemove", w2), document.addEventListener("touchmove", w2, { passive: false }));
          }
          function w2(n4) {
            n4.preventDefault();
            var i2 = f2(n4), a2 = t3.minDrag || s.MINDRAG, o2 = b2(i2[0] - e4, i2[1] - r4, a2), u4 = o2[0], c3 = o2[1];
            (u4 || c3) && (g2._dragged = true, l2.unhover(g2, n4)), g2._dragged && t3.moveFn && !v2 && (g2._dragdata = { element: x, dx: u4, dy: c3 }, t3.moveFn(u4, c3));
          }
          function T(e5) {
            if (delete g2._dragdata, false !== t3.dragmode && (e5.preventDefault(), document.removeEventListener("mousemove", w2), document.removeEventListener("touchmove", w2)), document.removeEventListener("mouseup", T), document.removeEventListener("touchend", T), i ? o(h2) : u3 && (h2.documentElement.style.cursor = u3, u3 = null), g2._dragging) {
              if (g2._dragging = false, new Date().getTime() - g2._mouseDownTime > m2 && (y2 = Math.max(y2 - 1, 1)), g2._dragged)
                t3.doneFn && t3.doneFn();
              else if (t3.clickFn && t3.clickFn(y2, p2), !v2) {
                var r5;
                try {
                  r5 = new MouseEvent("click", e5);
                } catch (t4) {
                  var n4 = f2(e5);
                  (r5 = document.createEvent("MouseEvents")).initMouseEvent("click", e5.bubbles, e5.cancelable, e5.view, e5.detail, e5.screenX, e5.screenY, n4[0], n4[1], e5.ctrlKey, e5.altKey, e5.shiftKey, e5.metaKey, e5.button, e5.relatedTarget);
                }
                d2.dispatchEvent(r5);
              }
              g2._dragging = false, g2._dragged = false;
            } else
              g2._dragged = false;
          }
        }, l2.coverSlip = c2;
      }, 2616: function(t2, e3, r3) {
        var n2 = r3(95924), i = r3(91200), a = r3(52200).getGraphDiv, o = r3(92456), s = t2.exports = {};
        s.wrapped = function(t3, e4, r4) {
          (t3 = a(t3))._fullLayout && i.clear(t3._fullLayout._uid + o.HOVERID), s.raw(t3, e4, r4);
        }, s.raw = function(t3, e4) {
          var r4 = t3._fullLayout, i2 = t3._hoverdata;
          e4 || (e4 = {}), e4.target && !t3._dragged && false === n2.triggerHandler(t3, "plotly_beforehover", e4) || (r4._hoverlayer.selectAll("g").remove(), r4._hoverlayer.selectAll("line").remove(), r4._hoverlayer.selectAll("circle").remove(), t3._hoverdata = void 0, e4.target && i2 && t3.emit("plotly_unhover", { event: e4, points: i2 }));
        };
      }, 98192: function(t2, e3) {
        e3.u = { valType: "string", values: ["solid", "dot", "dash", "longdash", "dashdot", "longdashdot"], dflt: "solid", editType: "style" }, e3.c = { shape: { valType: "enumerated", values: ["", "/", "\\", "x", "-", "|", "+", "."], dflt: "", arrayOk: true, editType: "style" }, fillmode: { valType: "enumerated", values: ["replace", "overlay"], dflt: "replace", editType: "style" }, bgcolor: { valType: "color", arrayOk: true, editType: "style" }, fgcolor: { valType: "color", arrayOk: true, editType: "style" }, fgopacity: { valType: "number", editType: "style", min: 0, max: 1 }, size: { valType: "number", min: 0, dflt: 8, arrayOk: true, editType: "style" }, solidity: { valType: "number", min: 0, max: 1, dflt: 0.3, arrayOk: true, editType: "style" }, editType: "style" };
      }, 43616: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(3400), a = i.numberFormat, o = r3(38248), s = r3(49760), l2 = r3(24040), u2 = r3(76308), c2 = r3(8932), f2 = i.strTranslate, h2 = r3(72736), p2 = r3(9616), d2 = r3(84284).LINE_SPACING, v2 = r3(13448).DESELECTDIM, g2 = r3(43028), y2 = r3(7152), m2 = r3(10624).appendArrayPointValue, x = t2.exports = {};
        function b2(t3, e4, r4) {
          var n3 = e4.fillpattern, i2 = n3 && x.getPatternAttr(n3.shape, 0, "");
          if (i2) {
            var a2 = x.getPatternAttr(n3.bgcolor, 0, null), o2 = x.getPatternAttr(n3.fgcolor, 0, null), s2 = n3.fgopacity, l3 = x.getPatternAttr(n3.size, 0, 8), c3 = x.getPatternAttr(n3.solidity, 0, 0.3), f3 = e4.uid;
            x.pattern(t3, "point", r4, f3, i2, l3, c3, void 0, n3.fillmode, a2, o2, s2);
          } else
            e4.fillcolor && t3.call(u2.fill, e4.fillcolor);
        }
        x.font = function(t3, e4, r4, n3) {
          i.isPlainObject(e4) && (n3 = e4.color, r4 = e4.size, e4 = e4.family), e4 && t3.style("font-family", e4), r4 + 1 && t3.style("font-size", r4 + "px"), n3 && t3.call(u2.fill, n3);
        }, x.setPosition = function(t3, e4, r4) {
          t3.attr("x", e4).attr("y", r4);
        }, x.setSize = function(t3, e4, r4) {
          t3.attr("width", e4).attr("height", r4);
        }, x.setRect = function(t3, e4, r4, n3, i2) {
          t3.call(x.setPosition, e4, r4).call(x.setSize, n3, i2);
        }, x.translatePoint = function(t3, e4, r4, n3) {
          var i2 = r4.c2p(t3.x), a2 = n3.c2p(t3.y);
          return !!(o(i2) && o(a2) && e4.node()) && ("text" === e4.node().nodeName ? e4.attr("x", i2).attr("y", a2) : e4.attr("transform", f2(i2, a2)), true);
        }, x.translatePoints = function(t3, e4, r4) {
          t3.each(function(t4) {
            var i2 = n2.select(this);
            x.translatePoint(t4, i2, e4, r4);
          });
        }, x.hideOutsideRangePoint = function(t3, e4, r4, n3, i2, a2) {
          e4.attr("display", r4.isPtWithinRange(t3, i2) && n3.isPtWithinRange(t3, a2) ? null : "none");
        }, x.hideOutsideRangePoints = function(t3, e4) {
          if (e4._hasClipOnAxisFalse) {
            var r4 = e4.xaxis, i2 = e4.yaxis;
            t3.each(function(e5) {
              var a2 = e5[0].trace, o2 = a2.xcalendar, s2 = a2.ycalendar, u3 = l2.traceIs(a2, "bar-like") ? ".bartext" : ".point,.textpoint";
              t3.selectAll(u3).each(function(t4) {
                x.hideOutsideRangePoint(t4, n2.select(this), r4, i2, o2, s2);
              });
            });
          }
        }, x.crispRound = function(t3, e4, r4) {
          return e4 && o(e4) ? t3._context.staticPlot ? e4 : e4 < 1 ? 1 : Math.round(e4) : r4 || 0;
        }, x.singleLineStyle = function(t3, e4, r4, n3, i2) {
          e4.style("fill", "none");
          var a2 = (((t3 || [])[0] || {}).trace || {}).line || {}, o2 = r4 || a2.width || 0, s2 = i2 || a2.dash || "";
          u2.stroke(e4, n3 || a2.color), x.dashLine(e4, s2, o2);
        }, x.lineGroupStyle = function(t3, e4, r4, i2) {
          t3.style("fill", "none").each(function(t4) {
            var a2 = (((t4 || [])[0] || {}).trace || {}).line || {}, o2 = e4 || a2.width || 0, s2 = i2 || a2.dash || "";
            n2.select(this).call(u2.stroke, r4 || a2.color).call(x.dashLine, s2, o2);
          });
        }, x.dashLine = function(t3, e4, r4) {
          r4 = +r4 || 0, e4 = x.dashStyle(e4, r4), t3.style({ "stroke-dasharray": e4, "stroke-width": r4 + "px" });
        }, x.dashStyle = function(t3, e4) {
          e4 = +e4 || 1;
          var r4 = Math.max(e4, 3);
          return "solid" === t3 ? t3 = "" : "dot" === t3 ? t3 = r4 + "px," + r4 + "px" : "dash" === t3 ? t3 = 3 * r4 + "px," + 3 * r4 + "px" : "longdash" === t3 ? t3 = 5 * r4 + "px," + 5 * r4 + "px" : "dashdot" === t3 ? t3 = 3 * r4 + "px," + r4 + "px," + r4 + "px," + r4 + "px" : "longdashdot" === t3 && (t3 = 5 * r4 + "px," + 2 * r4 + "px," + r4 + "px," + 2 * r4 + "px"), t3;
        }, x.singleFillStyle = function(t3, e4) {
          var r4 = n2.select(t3.node());
          b2(t3, ((r4.data()[0] || [])[0] || {}).trace || {}, e4);
        }, x.fillGroupStyle = function(t3, e4) {
          t3.style("stroke-width", 0).each(function(t4) {
            var r4 = n2.select(this);
            t4[0].trace && b2(r4, t4[0].trace, e4);
          });
        };
        var _ = r3(71984);
        x.symbolNames = [], x.symbolFuncs = [], x.symbolBackOffs = [], x.symbolNeedLines = {}, x.symbolNoDot = {}, x.symbolNoFill = {}, x.symbolList = [], Object.keys(_).forEach(function(t3) {
          var e4 = _[t3], r4 = e4.n;
          x.symbolList.push(r4, String(r4), t3, r4 + 100, String(r4 + 100), t3 + "-open"), x.symbolNames[r4] = t3, x.symbolFuncs[r4] = e4.f, x.symbolBackOffs[r4] = e4.backoff || 0, e4.needLine && (x.symbolNeedLines[r4] = true), e4.noDot ? x.symbolNoDot[r4] = true : x.symbolList.push(r4 + 200, String(r4 + 200), t3 + "-dot", r4 + 300, String(r4 + 300), t3 + "-open-dot"), e4.noFill && (x.symbolNoFill[r4] = true);
        });
        var w2 = x.symbolNames.length;
        function T(t3, e4, r4, n3) {
          var i2 = t3 % 100;
          return x.symbolFuncs[i2](e4, r4, n3) + (t3 >= 200 ? "M0,0.5L0.5,0L0,-0.5L-0.5,0Z" : "");
        }
        x.symbolNumber = function(t3) {
          if (o(t3))
            t3 = +t3;
          else if ("string" == typeof t3) {
            var e4 = 0;
            t3.indexOf("-open") > 0 && (e4 = 100, t3 = t3.replace("-open", "")), t3.indexOf("-dot") > 0 && (e4 += 200, t3 = t3.replace("-dot", "")), (t3 = x.symbolNames.indexOf(t3)) >= 0 && (t3 += e4);
          }
          return t3 % 100 >= w2 || t3 >= 400 ? 0 : Math.floor(Math.max(t3, 0));
        };
        var k2 = { x1: 1, x2: 0, y1: 0, y2: 0 }, A2 = { x1: 0, x2: 0, y1: 1, y2: 0 }, M = a("~f"), S = { radial: { node: "radialGradient" }, radialreversed: { node: "radialGradient", reversed: true }, horizontal: { node: "linearGradient", attrs: k2 }, horizontalreversed: { node: "linearGradient", attrs: k2, reversed: true }, vertical: { node: "linearGradient", attrs: A2 }, verticalreversed: { node: "linearGradient", attrs: A2, reversed: true } };
        x.gradient = function(t3, e4, r4, a2, o2, l3) {
          for (var c3 = o2.length, f3 = S[a2], h3 = new Array(c3), p3 = 0; p3 < c3; p3++)
            f3.reversed ? h3[c3 - 1 - p3] = [M(100 * (1 - o2[p3][0])), o2[p3][1]] : h3[p3] = [M(100 * o2[p3][0]), o2[p3][1]];
          var d3 = e4._fullLayout, v3 = "g" + d3._uid + "-" + r4, g3 = d3._defs.select(".gradients").selectAll("#" + v3).data([a2 + h3.join(";")], i.identity);
          g3.exit().remove(), g3.enter().append(f3.node).each(function() {
            var t4 = n2.select(this);
            f3.attrs && t4.attr(f3.attrs), t4.attr("id", v3);
            var e5 = t4.selectAll("stop").data(h3);
            e5.exit().remove(), e5.enter().append("stop"), e5.each(function(t5) {
              var e6 = s(t5[1]);
              n2.select(this).attr({ offset: t5[0] + "%", "stop-color": u2.tinyRGB(e6), "stop-opacity": e6.getAlpha() });
            });
          }), t3.style(l3, V(v3, e4)).style(l3 + "-opacity", null), t3.classed("gradient_filled", true);
        }, x.pattern = function(t3, e4, r4, a2, o2, l3, c3, f3, h3, p3, d3, v3) {
          var g3 = "legend" === e4;
          f3 && ("overlay" === h3 ? (p3 = f3, d3 = u2.contrast(p3)) : (p3 = void 0, d3 = f3));
          var y3, m3, x2, b3, _2, w3, T2, k3, A3, M2 = r4._fullLayout, S2 = "p" + M2._uid + "-" + a2, E3 = {}, L2 = s(d3), C3 = u2.tinyRGB(L2), P2 = v3 * L2.getAlpha();
          switch (o2) {
            case "/":
              y3 = l3 * Math.sqrt(2), m3 = l3 * Math.sqrt(2), w3 = "path", E3 = { d: x2 = "M-" + y3 / 4 + "," + m3 / 4 + "l" + y3 / 2 + ",-" + m3 / 2 + "M0," + m3 + "L" + y3 + ",0M" + y3 / 4 * 3 + "," + m3 / 4 * 5 + "l" + y3 / 2 + ",-" + m3 / 2, opacity: P2, stroke: C3, "stroke-width": (b3 = c3 * l3) + "px" };
              break;
            case "\\":
              y3 = l3 * Math.sqrt(2), m3 = l3 * Math.sqrt(2), w3 = "path", E3 = { d: x2 = "M" + y3 / 4 * 3 + ",-" + m3 / 4 + "l" + y3 / 2 + "," + m3 / 2 + "M0,0L" + y3 + "," + m3 + "M-" + y3 / 4 + "," + m3 / 4 * 3 + "l" + y3 / 2 + "," + m3 / 2, opacity: P2, stroke: C3, "stroke-width": (b3 = c3 * l3) + "px" };
              break;
            case "x":
              y3 = l3 * Math.sqrt(2), m3 = l3 * Math.sqrt(2), x2 = "M-" + y3 / 4 + "," + m3 / 4 + "l" + y3 / 2 + ",-" + m3 / 2 + "M0," + m3 + "L" + y3 + ",0M" + y3 / 4 * 3 + "," + m3 / 4 * 5 + "l" + y3 / 2 + ",-" + m3 / 2 + "M" + y3 / 4 * 3 + ",-" + m3 / 4 + "l" + y3 / 2 + "," + m3 / 2 + "M0,0L" + y3 + "," + m3 + "M-" + y3 / 4 + "," + m3 / 4 * 3 + "l" + y3 / 2 + "," + m3 / 2, b3 = l3 - l3 * Math.sqrt(1 - c3), w3 = "path", E3 = { d: x2, opacity: P2, stroke: C3, "stroke-width": b3 + "px" };
              break;
            case "|":
              w3 = "path", w3 = "path", E3 = { d: x2 = "M" + (y3 = l3) / 2 + ",0L" + y3 / 2 + "," + (m3 = l3), opacity: P2, stroke: C3, "stroke-width": (b3 = c3 * l3) + "px" };
              break;
            case "-":
              w3 = "path", w3 = "path", E3 = { d: x2 = "M0," + (m3 = l3) / 2 + "L" + (y3 = l3) + "," + m3 / 2, opacity: P2, stroke: C3, "stroke-width": (b3 = c3 * l3) + "px" };
              break;
            case "+":
              w3 = "path", x2 = "M" + (y3 = l3) / 2 + ",0L" + y3 / 2 + "," + (m3 = l3) + "M0," + m3 / 2 + "L" + y3 + "," + m3 / 2, b3 = l3 - l3 * Math.sqrt(1 - c3), w3 = "path", E3 = { d: x2, opacity: P2, stroke: C3, "stroke-width": b3 + "px" };
              break;
            case ".":
              y3 = l3, m3 = l3, c3 < Math.PI / 4 ? _2 = Math.sqrt(c3 * l3 * l3 / Math.PI) : (T2 = c3, k3 = Math.PI / 4, _2 = (A3 = l3 / 2) + (l3 / Math.sqrt(2) - A3) * (T2 - k3) / (1 - k3)), w3 = "circle", E3 = { cx: y3 / 2, cy: m3 / 2, r: _2, opacity: P2, fill: C3 };
          }
          var O2 = [o2 || "noSh", p3 || "noBg", d3 || "noFg", l3, c3].join(";"), I3 = M2._defs.select(".patterns").selectAll("#" + S2).data([O2], i.identity);
          I3.exit().remove(), I3.enter().append("pattern").each(function() {
            var t4 = n2.select(this);
            if (t4.attr({ id: S2, width: y3 + "px", height: m3 + "px", patternUnits: "userSpaceOnUse", patternTransform: g3 ? "scale(0.8)" : "" }), p3) {
              var e5 = s(p3), r5 = u2.tinyRGB(e5), i2 = e5.getAlpha(), a3 = t4.selectAll("rect").data([0]);
              a3.exit().remove(), a3.enter().append("rect").attr({ width: y3 + "px", height: m3 + "px", fill: r5, "fill-opacity": i2 });
            }
            var o3 = t4.selectAll(w3).data([0]);
            o3.exit().remove(), o3.enter().append(w3).attr(E3);
          }), t3.style("fill", V(S2, r4)).style("fill-opacity", null), t3.classed("pattern_filled", true);
        }, x.initGradients = function(t3) {
          var e4 = t3._fullLayout;
          i.ensureSingle(e4._defs, "g", "gradients").selectAll("linearGradient,radialGradient").remove(), n2.select(t3).selectAll(".gradient_filled").classed("gradient_filled", false);
        }, x.initPatterns = function(t3) {
          var e4 = t3._fullLayout;
          i.ensureSingle(e4._defs, "g", "patterns").selectAll("pattern").remove(), n2.select(t3).selectAll(".pattern_filled").classed("pattern_filled", false);
        }, x.getPatternAttr = function(t3, e4, r4) {
          return t3 && i.isArrayOrTypedArray(t3) ? e4 < t3.length ? t3[e4] : r4 : t3;
        }, x.pointStyle = function(t3, e4, r4, i2) {
          if (t3.size()) {
            var a2 = x.makePointStyleFns(e4);
            t3.each(function(t4) {
              x.singlePointStyle(t4, n2.select(this), e4, a2, r4, i2);
            });
          }
        }, x.singlePointStyle = function(t3, e4, r4, n3, a2, o2) {
          var s2 = r4.marker, l3 = s2.line;
          if (o2 && o2.i >= 0 && void 0 === t3.i && (t3.i = o2.i), e4.style("opacity", n3.selectedOpacityFn ? n3.selectedOpacityFn(t3) : void 0 === t3.mo ? s2.opacity : t3.mo), n3.ms2mrc) {
            var c3;
            c3 = "various" === t3.ms || "various" === s2.size ? 3 : n3.ms2mrc(t3.ms), t3.mrc = c3, n3.selectedSizeFn && (c3 = t3.mrc = n3.selectedSizeFn(t3));
            var f3 = x.symbolNumber(t3.mx || s2.symbol) || 0;
            t3.om = f3 % 200 >= 100;
            var h3 = rt(t3, r4), p3 = G2(t3, r4);
            e4.attr("d", T(f3, c3, h3, p3));
          }
          var d3, v3, g3, y3 = false;
          if (t3.so)
            g3 = l3.outlierwidth, v3 = l3.outliercolor, d3 = s2.outliercolor;
          else {
            var m3 = (l3 || {}).width;
            g3 = (t3.mlw + 1 || m3 + 1 || (t3.trace ? (t3.trace.marker.line || {}).width : 0) + 1) - 1 || 0, v3 = "mlc" in t3 ? t3.mlcc = n3.lineScale(t3.mlc) : i.isArrayOrTypedArray(l3.color) ? u2.defaultLine : l3.color, i.isArrayOrTypedArray(s2.color) && (d3 = u2.defaultLine, y3 = true), d3 = "mc" in t3 ? t3.mcc = n3.markerScale(t3.mc) : s2.color || s2.colors || "rgba(0,0,0,0)", n3.selectedColorFn && (d3 = n3.selectedColorFn(t3));
          }
          if (t3.om)
            e4.call(u2.stroke, d3).style({ "stroke-width": (g3 || 1) + "px", fill: "none" });
          else {
            e4.style("stroke-width", (t3.isBlank ? 0 : g3) + "px");
            var b3 = s2.gradient, _2 = t3.mgt;
            _2 ? y3 = true : _2 = b3 && b3.type, i.isArrayOrTypedArray(_2) && (_2 = _2[0], S[_2] || (_2 = 0));
            var w3 = s2.pattern, k3 = w3 && x.getPatternAttr(w3.shape, t3.i, "");
            if (_2 && "none" !== _2) {
              var A3 = t3.mgc;
              A3 ? y3 = true : A3 = b3.color;
              var M2 = r4.uid;
              y3 && (M2 += "-" + t3.i), x.gradient(e4, a2, M2, _2, [[0, A3], [1, d3]], "fill");
            } else if (k3) {
              var E3 = false, L2 = w3.fgcolor;
              !L2 && o2 && o2.color && (L2 = o2.color, E3 = true);
              var C3 = x.getPatternAttr(L2, t3.i, o2 && o2.color || null), P2 = x.getPatternAttr(w3.bgcolor, t3.i, null), O2 = w3.fgopacity, I3 = x.getPatternAttr(w3.size, t3.i, 8), D3 = x.getPatternAttr(w3.solidity, t3.i, 0.3);
              E3 = E3 || t3.mcc || i.isArrayOrTypedArray(w3.shape) || i.isArrayOrTypedArray(w3.bgcolor) || i.isArrayOrTypedArray(w3.fgcolor) || i.isArrayOrTypedArray(w3.size) || i.isArrayOrTypedArray(w3.solidity);
              var z3 = r4.uid;
              E3 && (z3 += "-" + t3.i), x.pattern(e4, "point", a2, z3, k3, I3, D3, t3.mcc, w3.fillmode, P2, C3, O2);
            } else
              i.isArrayOrTypedArray(d3) ? u2.fill(e4, d3[t3.i]) : u2.fill(e4, d3);
            g3 && u2.stroke(e4, v3);
          }
        }, x.makePointStyleFns = function(t3) {
          var e4 = {}, r4 = t3.marker;
          return e4.markerScale = x.tryColorscale(r4, ""), e4.lineScale = x.tryColorscale(r4, "line"), l2.traceIs(t3, "symbols") && (e4.ms2mrc = g2.isBubble(t3) ? y2(t3) : function() {
            return (r4.size || 6) / 2;
          }), t3.selectedpoints && i.extendFlat(e4, x.makeSelectedPointStyleFns(t3)), e4;
        }, x.makeSelectedPointStyleFns = function(t3) {
          var e4 = {}, r4 = t3.selected || {}, n3 = t3.unselected || {}, a2 = t3.marker || {}, o2 = r4.marker || {}, s2 = n3.marker || {}, u3 = a2.opacity, c3 = o2.opacity, f3 = s2.opacity, h3 = void 0 !== c3, p3 = void 0 !== f3;
          (i.isArrayOrTypedArray(u3) || h3 || p3) && (e4.selectedOpacityFn = function(t4) {
            var e5 = void 0 === t4.mo ? a2.opacity : t4.mo;
            return t4.selected ? h3 ? c3 : e5 : p3 ? f3 : v2 * e5;
          });
          var d3 = a2.color, g3 = o2.color, y3 = s2.color;
          (g3 || y3) && (e4.selectedColorFn = function(t4) {
            var e5 = t4.mcc || d3;
            return t4.selected ? g3 || e5 : y3 || e5;
          });
          var m3 = a2.size, x2 = o2.size, b3 = s2.size, _2 = void 0 !== x2, w3 = void 0 !== b3;
          return l2.traceIs(t3, "symbols") && (_2 || w3) && (e4.selectedSizeFn = function(t4) {
            var e5 = t4.mrc || m3 / 2;
            return t4.selected ? _2 ? x2 / 2 : e5 : w3 ? b3 / 2 : e5;
          }), e4;
        }, x.makeSelectedTextStyleFns = function(t3) {
          var e4 = {}, r4 = t3.selected || {}, n3 = t3.unselected || {}, i2 = t3.textfont || {}, a2 = r4.textfont || {}, o2 = n3.textfont || {}, s2 = i2.color, l3 = a2.color, c3 = o2.color;
          return e4.selectedTextColorFn = function(t4) {
            var e5 = t4.tc || s2;
            return t4.selected ? l3 || e5 : c3 || (l3 ? e5 : u2.addOpacity(e5, v2));
          }, e4;
        }, x.selectedPointStyle = function(t3, e4) {
          if (t3.size() && e4.selectedpoints) {
            var r4 = x.makeSelectedPointStyleFns(e4), i2 = e4.marker || {}, a2 = [];
            r4.selectedOpacityFn && a2.push(function(t4, e5) {
              t4.style("opacity", r4.selectedOpacityFn(e5));
            }), r4.selectedColorFn && a2.push(function(t4, e5) {
              u2.fill(t4, r4.selectedColorFn(e5));
            }), r4.selectedSizeFn && a2.push(function(t4, n3) {
              var a3 = n3.mx || i2.symbol || 0, o2 = r4.selectedSizeFn(n3);
              t4.attr("d", T(x.symbolNumber(a3), o2, rt(n3, e4), G2(n3, e4))), n3.mrc2 = o2;
            }), a2.length && t3.each(function(t4) {
              for (var e5 = n2.select(this), r5 = 0; r5 < a2.length; r5++)
                a2[r5](e5, t4);
            });
          }
        }, x.tryColorscale = function(t3, e4) {
          var r4 = e4 ? i.nestedProperty(t3, e4).get() : t3;
          if (r4) {
            var n3 = r4.color;
            if ((r4.colorscale || r4._colorAx) && i.isArrayOrTypedArray(n3))
              return c2.makeColorScaleFuncFromTrace(r4);
          }
          return i.identity;
        };
        var E2, L, C2 = { start: 1, end: -1, middle: 0, bottom: 1, top: -1 };
        function P(t3, e4, r4, i2, a2) {
          var o2 = n2.select(t3.node().parentNode), s2 = -1 !== e4.indexOf("top") ? "top" : -1 !== e4.indexOf("bottom") ? "bottom" : "middle", l3 = -1 !== e4.indexOf("left") ? "end" : -1 !== e4.indexOf("right") ? "start" : "middle", u3 = i2 ? i2 / 0.8 + 1 : 0, c3 = (h2.lineCount(t3) - 1) * d2 + 1, p3 = C2[l3] * u3, v3 = 0.75 * r4 + C2[s2] * u3 + (C2[s2] - 1) * c3 * r4 / 2;
          t3.attr("text-anchor", l3), a2 || o2.attr("transform", f2(p3, v3));
        }
        function O(t3, e4) {
          var r4 = t3.ts || e4.textfont.size;
          return o(r4) && r4 > 0 ? r4 : 0;
        }
        function I2(t3, e4, r4) {
          return r4 && (t3 = N(t3)), e4 ? z2(t3[1]) : D2(t3[0]);
        }
        function D2(t3) {
          var e4 = n2.round(t3, 2);
          return E2 = e4, e4;
        }
        function z2(t3) {
          var e4 = n2.round(t3, 2);
          return L = e4, e4;
        }
        function R(t3, e4, r4, n3) {
          var i2 = t3[0] - e4[0], a2 = t3[1] - e4[1], o2 = r4[0] - e4[0], s2 = r4[1] - e4[1], l3 = Math.pow(i2 * i2 + a2 * a2, 0.25), u3 = Math.pow(o2 * o2 + s2 * s2, 0.25), c3 = (u3 * u3 * i2 - l3 * l3 * o2) * n3, f3 = (u3 * u3 * a2 - l3 * l3 * s2) * n3, h3 = 3 * u3 * (l3 + u3), p3 = 3 * l3 * (l3 + u3);
          return [[D2(e4[0] + (h3 && c3 / h3)), z2(e4[1] + (h3 && f3 / h3))], [D2(e4[0] - (p3 && c3 / p3)), z2(e4[1] - (p3 && f3 / p3))]];
        }
        x.textPointStyle = function(t3, e4, r4) {
          if (t3.size()) {
            var a2;
            if (e4.selectedpoints) {
              var o2 = x.makeSelectedTextStyleFns(e4);
              a2 = o2.selectedTextColorFn;
            }
            var s2 = e4.texttemplate, l3 = r4._fullLayout;
            t3.each(function(t4) {
              var o3 = n2.select(this), u3 = s2 ? i.extractOption(t4, e4, "txt", "texttemplate") : i.extractOption(t4, e4, "tx", "text");
              if (u3 || 0 === u3) {
                if (s2) {
                  var c3 = e4._module.formatLabels, f3 = c3 ? c3(t4, e4, l3) : {}, p3 = {};
                  m2(p3, e4, t4.i);
                  var d3 = e4._meta || {};
                  u3 = i.texttemplateString(u3, f3, l3._d3locale, p3, t4, d3);
                }
                var v3 = t4.tp || e4.textposition, g3 = O(t4, e4), y3 = a2 ? a2(t4) : t4.tc || e4.textfont.color;
                o3.call(x.font, t4.tf || e4.textfont.family, g3, y3).text(u3).call(h2.convertToTspans, r4).call(P, v3, g3, t4.mrc);
              } else
                o3.remove();
            });
          }
        }, x.selectedTextStyle = function(t3, e4) {
          if (t3.size() && e4.selectedpoints) {
            var r4 = x.makeSelectedTextStyleFns(e4);
            t3.each(function(t4) {
              var i2 = n2.select(this), a2 = r4.selectedTextColorFn(t4), o2 = t4.tp || e4.textposition, s2 = O(t4, e4);
              u2.fill(i2, a2);
              var c3 = l2.traceIs(e4, "bar-like");
              P(i2, o2, s2, t4.mrc2 || t4.mrc, c3);
            });
          }
        }, x.smoothopen = function(t3, e4) {
          if (t3.length < 3)
            return "M" + t3.join("L");
          var r4, n3 = "M" + t3[0], i2 = [];
          for (r4 = 1; r4 < t3.length - 1; r4++)
            i2.push(R(t3[r4 - 1], t3[r4], t3[r4 + 1], e4));
          for (n3 += "Q" + i2[0][0] + " " + t3[1], r4 = 2; r4 < t3.length - 1; r4++)
            n3 += "C" + i2[r4 - 2][1] + " " + i2[r4 - 1][0] + " " + t3[r4];
          return n3 + "Q" + i2[t3.length - 3][1] + " " + t3[t3.length - 1];
        }, x.smoothclosed = function(t3, e4) {
          if (t3.length < 3)
            return "M" + t3.join("L") + "Z";
          var r4, n3 = "M" + t3[0], i2 = t3.length - 1, a2 = [R(t3[i2], t3[0], t3[1], e4)];
          for (r4 = 1; r4 < i2; r4++)
            a2.push(R(t3[r4 - 1], t3[r4], t3[r4 + 1], e4));
          for (a2.push(R(t3[i2 - 1], t3[i2], t3[0], e4)), r4 = 1; r4 <= i2; r4++)
            n3 += "C" + a2[r4 - 1][1] + " " + a2[r4][0] + " " + t3[r4];
          return n3 + "C" + a2[i2][1] + " " + a2[0][0] + " " + t3[0] + "Z";
        };
        var F2 = { hv: function(t3, e4, r4) {
          return "H" + D2(e4[0]) + "V" + I2(e4, 1, r4);
        }, vh: function(t3, e4, r4) {
          return "V" + z2(e4[1]) + "H" + I2(e4, 0, r4);
        }, hvh: function(t3, e4, r4) {
          return "H" + D2((t3[0] + e4[0]) / 2) + "V" + z2(e4[1]) + "H" + I2(e4, 0, r4);
        }, vhv: function(t3, e4, r4) {
          return "V" + z2((t3[1] + e4[1]) / 2) + "H" + D2(e4[0]) + "V" + I2(e4, 1, r4);
        } }, B2 = function(t3, e4, r4) {
          return "L" + I2(e4, 0, r4) + "," + I2(e4, 1, r4);
        };
        function N(t3, e4) {
          var r4 = t3.backoff, n3 = t3.trace, a2 = t3.d, o2 = t3.i;
          if (r4 && n3 && n3.marker && n3.marker.angle % 360 == 0 && n3.line && "spline" !== n3.line.shape) {
            var s2 = i.isArrayOrTypedArray(r4), l3 = t3, u3 = e4 ? e4[0] : E2 || 0, c3 = e4 ? e4[1] : L || 0, f3 = l3[0], h3 = l3[1], p3 = f3 - u3, d3 = h3 - c3, v3 = Math.atan2(d3, p3), g3 = s2 ? r4[o2] : r4;
            if ("auto" === g3) {
              var y3 = l3.i;
              "scatter" === n3.type && y3--;
              var m3 = l3.marker, b3 = m3.symbol;
              i.isArrayOrTypedArray(b3) && (b3 = b3[y3]);
              var _2 = m3.size;
              i.isArrayOrTypedArray(_2) && (_2 = _2[y3]), g3 = m3 ? x.symbolBackOffs[x.symbolNumber(b3)] * _2 : 0, g3 += x.getMarkerStandoff(a2[y3], n3) || 0;
            }
            var w3 = f3 - g3 * Math.cos(v3), T2 = h3 - g3 * Math.sin(v3);
            (w3 <= f3 && w3 >= u3 || w3 >= f3 && w3 <= u3) && (T2 <= h3 && T2 >= c3 || T2 >= h3 && T2 <= c3) && (t3 = [w3, T2]);
          }
          return t3;
        }
        x.steps = function(t3) {
          var e4 = F2[t3] || B2;
          return function(t4) {
            for (var r4 = "M" + D2(t4[0][0]) + "," + z2(t4[0][1]), n3 = t4.length, i2 = 1; i2 < n3; i2++)
              r4 += e4(t4[i2 - 1], t4[i2], i2 === n3 - 1);
            return r4;
          };
        }, x.applyBackoff = N, x.makeTester = function() {
          var t3 = i.ensureSingleById(n2.select("body"), "svg", "js-plotly-tester", function(t4) {
            t4.attr(p2.svgAttrs).style({ position: "absolute", left: "-10000px", top: "-10000px", width: "9000px", height: "9000px", "z-index": "1" });
          }), e4 = i.ensureSingle(t3, "path", "js-reference-point", function(t4) {
            t4.attr("d", "M0,0H1V1H0Z").style({ "stroke-width": 0, fill: "black" });
          });
          x.tester = t3, x.testref = e4;
        }, x.savedBBoxes = {};
        var j = 0;
        function U(t3) {
          var e4 = t3.getAttribute("data-unformatted");
          if (null !== e4)
            return e4 + t3.getAttribute("data-math") + t3.getAttribute("text-anchor") + t3.getAttribute("style");
        }
        function V(t3, e4) {
          if (!t3)
            return null;
          var r4 = e4._context, n3 = r4._exportedPlot ? "" : r4._baseUrl || "";
          return n3 ? "url('" + n3 + "#" + t3 + "')" : "url(#" + t3 + ")";
        }
        x.bBox = function(t3, e4, r4) {
          var a2, o2, s2;
          if (r4 || (r4 = U(t3)), r4) {
            if (a2 = x.savedBBoxes[r4])
              return i.extendFlat({}, a2);
          } else if (1 === t3.childNodes.length) {
            var l3 = t3.childNodes[0];
            if (r4 = U(l3)) {
              var u3 = +l3.getAttribute("x") || 0, c3 = +l3.getAttribute("y") || 0, f3 = l3.getAttribute("transform");
              if (!f3) {
                var p3 = x.bBox(l3, false, r4);
                return u3 && (p3.left += u3, p3.right += u3), c3 && (p3.top += c3, p3.bottom += c3), p3;
              }
              if (r4 += "~" + u3 + "~" + c3 + "~" + f3, a2 = x.savedBBoxes[r4])
                return i.extendFlat({}, a2);
            }
          }
          e4 ? o2 = t3 : (s2 = x.tester.node(), o2 = t3.cloneNode(true), s2.appendChild(o2)), n2.select(o2).attr("transform", null).call(h2.positionText, 0, 0);
          var d3 = o2.getBoundingClientRect(), v3 = x.testref.node().getBoundingClientRect();
          e4 || s2.removeChild(o2);
          var g3 = { height: d3.height, width: d3.width, left: d3.left - v3.left, top: d3.top - v3.top, right: d3.right - v3.left, bottom: d3.bottom - v3.top };
          return j >= 1e4 && (x.savedBBoxes = {}, j = 0), r4 && (x.savedBBoxes[r4] = g3), j++, i.extendFlat({}, g3);
        }, x.setClipUrl = function(t3, e4, r4) {
          t3.attr("clip-path", V(e4, r4));
        }, x.getTranslate = function(t3) {
          var e4 = (t3[t3.attr ? "attr" : "getAttribute"]("transform") || "").replace(/.*\btranslate\((-?\d*\.?\d*)[^-\d]*(-?\d*\.?\d*)[^\d].*/, function(t4, e5, r4) {
            return [e5, r4].join(" ");
          }).split(" ");
          return { x: +e4[0] || 0, y: +e4[1] || 0 };
        }, x.setTranslate = function(t3, e4, r4) {
          var n3 = t3.attr ? "attr" : "getAttribute", i2 = t3.attr ? "attr" : "setAttribute", a2 = t3[n3]("transform") || "";
          return e4 = e4 || 0, r4 = r4 || 0, a2 = a2.replace(/(\btranslate\(.*?\);?)/, "").trim(), a2 = (a2 += f2(e4, r4)).trim(), t3[i2]("transform", a2), a2;
        }, x.getScale = function(t3) {
          var e4 = (t3[t3.attr ? "attr" : "getAttribute"]("transform") || "").replace(/.*\bscale\((\d*\.?\d*)[^\d]*(\d*\.?\d*)[^\d].*/, function(t4, e5, r4) {
            return [e5, r4].join(" ");
          }).split(" ");
          return { x: +e4[0] || 1, y: +e4[1] || 1 };
        }, x.setScale = function(t3, e4, r4) {
          var n3 = t3.attr ? "attr" : "getAttribute", i2 = t3.attr ? "attr" : "setAttribute", a2 = t3[n3]("transform") || "";
          return e4 = e4 || 1, r4 = r4 || 1, a2 = a2.replace(/(\bscale\(.*?\);?)/, "").trim(), a2 = (a2 += "scale(" + e4 + "," + r4 + ")").trim(), t3[i2]("transform", a2), a2;
        };
        var q2 = /\s*sc.*/;
        x.setPointGroupScale = function(t3, e4, r4) {
          if (e4 = e4 || 1, r4 = r4 || 1, t3) {
            var n3 = 1 === e4 && 1 === r4 ? "" : "scale(" + e4 + "," + r4 + ")";
            t3.each(function() {
              var t4 = (this.getAttribute("transform") || "").replace(q2, "");
              t4 = (t4 += n3).trim(), this.setAttribute("transform", t4);
            });
          }
        };
        var H2 = /translate\([^)]*\)\s*$/;
        function G2(t3, e4) {
          var r4;
          return t3 && (r4 = t3.mf), void 0 === r4 && (r4 = e4.marker && e4.marker.standoff || 0), e4._geo || e4._xA ? r4 : -r4;
        }
        x.setTextPointsScale = function(t3, e4, r4) {
          t3 && t3.each(function() {
            var t4, i2 = n2.select(this), a2 = i2.select("text");
            if (a2.node()) {
              var o2 = parseFloat(a2.attr("x") || 0), s2 = parseFloat(a2.attr("y") || 0), l3 = (i2.attr("transform") || "").match(H2);
              t4 = 1 === e4 && 1 === r4 ? [] : [f2(o2, s2), "scale(" + e4 + "," + r4 + ")", f2(-o2, -s2)], l3 && t4.push(l3), i2.attr("transform", t4.join(""));
            }
          });
        }, x.getMarkerStandoff = G2;
        var W, Y, X, Z, K, J, $ = Math.atan2, Q = Math.cos, tt2 = Math.sin;
        function et(t3, e4) {
          var r4 = e4[0], n3 = e4[1];
          return [r4 * Q(t3) - n3 * tt2(t3), r4 * tt2(t3) + n3 * Q(t3)];
        }
        function rt(t3, e4) {
          var r4, n3, a2 = t3.ma;
          void 0 === a2 && ((a2 = e4.marker.angle) && !i.isArrayOrTypedArray(a2) || (a2 = 0));
          var s2 = e4.marker.angleref;
          if ("previous" === s2 || "north" === s2) {
            if (e4._geo) {
              var l3 = e4._geo.project(t3.lonlat);
              r4 = l3[0], n3 = l3[1];
            } else {
              var u3 = e4._xA, c3 = e4._yA;
              if (!u3 || !c3)
                return 90;
              r4 = u3.c2p(t3.x), n3 = c3.c2p(t3.y);
            }
            if (e4._geo) {
              var f3, h3 = t3.lonlat[0], p3 = t3.lonlat[1], d3 = e4._geo.project([h3, p3 + 1e-5]), v3 = e4._geo.project([h3 + 1e-5, p3]), g3 = $(v3[1] - n3, v3[0] - r4), y3 = $(d3[1] - n3, d3[0] - r4);
              if ("north" === s2)
                f3 = a2 / 180 * Math.PI;
              else if ("previous" === s2) {
                var m3 = h3 / 180 * Math.PI, x2 = p3 / 180 * Math.PI, b3 = W / 180 * Math.PI, _2 = Y / 180 * Math.PI, w3 = b3 - m3, T2 = Q(_2) * tt2(w3), k3 = tt2(_2) * Q(x2) - Q(_2) * tt2(x2) * Q(w3);
                f3 = -$(T2, k3) - Math.PI, W = h3, Y = p3;
              }
              var A3 = et(g3, [Q(f3), 0]), M2 = et(y3, [tt2(f3), 0]);
              a2 = $(A3[1] + M2[1], A3[0] + M2[0]) / Math.PI * 180, "previous" !== s2 || J === e4.uid && t3.i === K + 1 || (a2 = null);
            }
            if ("previous" === s2 && !e4._geo)
              if (J === e4.uid && t3.i === K + 1 && o(r4) && o(n3)) {
                var S2 = r4 - X, E3 = n3 - Z, L2 = e4.line && e4.line.shape || "", C3 = L2.slice(L2.length - 1);
                "h" === C3 && (E3 = 0), "v" === C3 && (S2 = 0), a2 += $(E3, S2) / Math.PI * 180 + 90;
              } else
                a2 = null;
          }
          return X = r4, Z = n3, K = t3.i, J = e4.uid, a2;
        }
        x.getMarkerAngle = rt;
      }, 71984: function(t2, e3, r3) {
        var n2, i, a, o, s = r3(21984), l2 = r3(33428).round, u2 = "M0,0Z", c2 = Math.sqrt(2), f2 = Math.sqrt(3), h2 = Math.PI, p2 = Math.cos, d2 = Math.sin;
        function v2(t3) {
          return null === t3;
        }
        function g2(t3, e4, r4) {
          if (!(t3 && t3 % 360 != 0 || e4))
            return r4;
          if (a === t3 && o === e4 && n2 === r4)
            return i;
          function l3(t4, r5) {
            var n3 = p2(t4), i2 = d2(t4), a2 = r5[0], o2 = r5[1] + (e4 || 0);
            return [a2 * n3 - o2 * i2, a2 * i2 + o2 * n3];
          }
          a = t3, o = e4, n2 = r4;
          for (var u3 = t3 / 180 * h2, c3 = 0, f3 = 0, v3 = s(r4), g3 = "", y2 = 0; y2 < v3.length; y2++) {
            var m2 = v3[y2], x = m2[0], b2 = c3, _ = f3;
            if ("M" === x || "L" === x)
              c3 = +m2[1], f3 = +m2[2];
            else if ("m" === x || "l" === x)
              c3 += +m2[1], f3 += +m2[2];
            else if ("H" === x)
              c3 = +m2[1];
            else if ("h" === x)
              c3 += +m2[1];
            else if ("V" === x)
              f3 = +m2[1];
            else if ("v" === x)
              f3 += +m2[1];
            else if ("A" === x) {
              c3 = +m2[1], f3 = +m2[2];
              var w2 = l3(u3, [+m2[6], +m2[7]]);
              m2[6] = w2[0], m2[7] = w2[1], m2[3] = +m2[3] + t3;
            }
            "H" !== x && "V" !== x || (x = "L"), "h" !== x && "v" !== x || (x = "l"), "m" !== x && "l" !== x || (c3 -= b2, f3 -= _);
            var T = l3(u3, [c3, f3]);
            "H" !== x && "V" !== x || (x = "L"), "M" !== x && "L" !== x && "m" !== x && "l" !== x || (m2[1] = T[0], m2[2] = T[1]), m2[0] = x, g3 += m2[0] + m2.slice(1).join(",");
          }
          return i = g3, g3;
        }
        t2.exports = { circle: { n: 0, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2), i2 = "M" + n3 + ",0A" + n3 + "," + n3 + " 0 1,1 0,-" + n3 + "A" + n3 + "," + n3 + " 0 0,1 " + n3 + ",0Z";
          return r4 ? g2(e4, r4, i2) : i2;
        } }, square: { n: 1, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2);
          return g2(e4, r4, "M" + n3 + "," + n3 + "H-" + n3 + "V-" + n3 + "H" + n3 + "Z");
        } }, diamond: { n: 2, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(1.3 * t3, 2);
          return g2(e4, r4, "M" + n3 + ",0L0," + n3 + "L-" + n3 + ",0L0,-" + n3 + "Z");
        } }, cross: { n: 3, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(0.4 * t3, 2), i2 = l2(1.2 * t3, 2);
          return g2(e4, r4, "M" + i2 + "," + n3 + "H" + n3 + "V" + i2 + "H-" + n3 + "V" + n3 + "H-" + i2 + "V-" + n3 + "H-" + n3 + "V-" + i2 + "H" + n3 + "V-" + n3 + "H" + i2 + "Z");
        } }, x: { n: 4, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(0.8 * t3 / c2, 2), i2 = "l" + n3 + "," + n3, a2 = "l" + n3 + ",-" + n3, o2 = "l-" + n3 + ",-" + n3, s2 = "l-" + n3 + "," + n3;
          return g2(e4, r4, "M0," + n3 + i2 + a2 + o2 + a2 + o2 + s2 + o2 + s2 + i2 + s2 + i2 + "Z");
        } }, "triangle-up": { n: 5, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(2 * t3 / f2, 2);
          return g2(e4, r4, "M-" + n3 + "," + l2(t3 / 2, 2) + "H" + n3 + "L0,-" + l2(t3, 2) + "Z");
        } }, "triangle-down": { n: 6, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(2 * t3 / f2, 2);
          return g2(e4, r4, "M-" + n3 + ",-" + l2(t3 / 2, 2) + "H" + n3 + "L0," + l2(t3, 2) + "Z");
        } }, "triangle-left": { n: 7, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(2 * t3 / f2, 2);
          return g2(e4, r4, "M" + l2(t3 / 2, 2) + ",-" + n3 + "V" + n3 + "L-" + l2(t3, 2) + ",0Z");
        } }, "triangle-right": { n: 8, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(2 * t3 / f2, 2);
          return g2(e4, r4, "M-" + l2(t3 / 2, 2) + ",-" + n3 + "V" + n3 + "L" + l2(t3, 2) + ",0Z");
        } }, "triangle-ne": { n: 9, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(0.6 * t3, 2), i2 = l2(1.2 * t3, 2);
          return g2(e4, r4, "M-" + i2 + ",-" + n3 + "H" + n3 + "V" + i2 + "Z");
        } }, "triangle-se": { n: 10, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(0.6 * t3, 2), i2 = l2(1.2 * t3, 2);
          return g2(e4, r4, "M" + n3 + ",-" + i2 + "V" + n3 + "H-" + i2 + "Z");
        } }, "triangle-sw": { n: 11, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(0.6 * t3, 2), i2 = l2(1.2 * t3, 2);
          return g2(e4, r4, "M" + i2 + "," + n3 + "H-" + n3 + "V-" + i2 + "Z");
        } }, "triangle-nw": { n: 12, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(0.6 * t3, 2), i2 = l2(1.2 * t3, 2);
          return g2(e4, r4, "M-" + n3 + "," + i2 + "V-" + n3 + "H" + i2 + "Z");
        } }, pentagon: { n: 13, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(0.951 * t3, 2), i2 = l2(0.588 * t3, 2), a2 = l2(-t3, 2), o2 = l2(-0.309 * t3, 2);
          return g2(e4, r4, "M" + n3 + "," + o2 + "L" + i2 + "," + l2(0.809 * t3, 2) + "H-" + i2 + "L-" + n3 + "," + o2 + "L0," + a2 + "Z");
        } }, hexagon: { n: 14, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2), i2 = l2(t3 / 2, 2), a2 = l2(t3 * f2 / 2, 2);
          return g2(e4, r4, "M" + a2 + ",-" + i2 + "V" + i2 + "L0," + n3 + "L-" + a2 + "," + i2 + "V-" + i2 + "L0,-" + n3 + "Z");
        } }, hexagon2: { n: 15, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2), i2 = l2(t3 / 2, 2), a2 = l2(t3 * f2 / 2, 2);
          return g2(e4, r4, "M-" + i2 + "," + a2 + "H" + i2 + "L" + n3 + ",0L" + i2 + ",-" + a2 + "H-" + i2 + "L-" + n3 + ",0Z");
        } }, octagon: { n: 16, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(0.924 * t3, 2), i2 = l2(0.383 * t3, 2);
          return g2(e4, r4, "M-" + i2 + ",-" + n3 + "H" + i2 + "L" + n3 + ",-" + i2 + "V" + i2 + "L" + i2 + "," + n3 + "H-" + i2 + "L-" + n3 + "," + i2 + "V-" + i2 + "Z");
        } }, star: { n: 17, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = 1.4 * t3, i2 = l2(0.225 * n3, 2), a2 = l2(0.951 * n3, 2), o2 = l2(0.363 * n3, 2), s2 = l2(0.588 * n3, 2), c3 = l2(-n3, 2), f3 = l2(-0.309 * n3, 2), h3 = l2(0.118 * n3, 2), p3 = l2(0.809 * n3, 2);
          return g2(e4, r4, "M" + i2 + "," + f3 + "H" + a2 + "L" + o2 + "," + h3 + "L" + s2 + "," + p3 + "L0," + l2(0.382 * n3, 2) + "L-" + s2 + "," + p3 + "L-" + o2 + "," + h3 + "L-" + a2 + "," + f3 + "H-" + i2 + "L0," + c3 + "Z");
        } }, hexagram: { n: 18, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(0.66 * t3, 2), i2 = l2(0.38 * t3, 2), a2 = l2(0.76 * t3, 2);
          return g2(e4, r4, "M-" + a2 + ",0l-" + i2 + ",-" + n3 + "h" + a2 + "l" + i2 + ",-" + n3 + "l" + i2 + "," + n3 + "h" + a2 + "l-" + i2 + "," + n3 + "l" + i2 + "," + n3 + "h-" + a2 + "l-" + i2 + "," + n3 + "l-" + i2 + ",-" + n3 + "h-" + a2 + "Z");
        } }, "star-triangle-up": { n: 19, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3 * f2 * 0.8, 2), i2 = l2(0.8 * t3, 2), a2 = l2(1.6 * t3, 2), o2 = l2(4 * t3, 2), s2 = "A " + o2 + "," + o2 + " 0 0 1 ";
          return g2(e4, r4, "M-" + n3 + "," + i2 + s2 + n3 + "," + i2 + s2 + "0,-" + a2 + s2 + "-" + n3 + "," + i2 + "Z");
        } }, "star-triangle-down": { n: 20, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3 * f2 * 0.8, 2), i2 = l2(0.8 * t3, 2), a2 = l2(1.6 * t3, 2), o2 = l2(4 * t3, 2), s2 = "A " + o2 + "," + o2 + " 0 0 1 ";
          return g2(e4, r4, "M" + n3 + ",-" + i2 + s2 + "-" + n3 + ",-" + i2 + s2 + "0," + a2 + s2 + n3 + ",-" + i2 + "Z");
        } }, "star-square": { n: 21, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(1.1 * t3, 2), i2 = l2(2 * t3, 2), a2 = "A " + i2 + "," + i2 + " 0 0 1 ";
          return g2(e4, r4, "M-" + n3 + ",-" + n3 + a2 + "-" + n3 + "," + n3 + a2 + n3 + "," + n3 + a2 + n3 + ",-" + n3 + a2 + "-" + n3 + ",-" + n3 + "Z");
        } }, "star-diamond": { n: 22, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(1.4 * t3, 2), i2 = l2(1.9 * t3, 2), a2 = "A " + i2 + "," + i2 + " 0 0 1 ";
          return g2(e4, r4, "M-" + n3 + ",0" + a2 + "0," + n3 + a2 + n3 + ",0" + a2 + "0,-" + n3 + a2 + "-" + n3 + ",0Z");
        } }, "diamond-tall": { n: 23, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(0.7 * t3, 2), i2 = l2(1.4 * t3, 2);
          return g2(e4, r4, "M0," + i2 + "L" + n3 + ",0L0,-" + i2 + "L-" + n3 + ",0Z");
        } }, "diamond-wide": { n: 24, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(1.4 * t3, 2), i2 = l2(0.7 * t3, 2);
          return g2(e4, r4, "M0," + i2 + "L" + n3 + ",0L0,-" + i2 + "L-" + n3 + ",0Z");
        } }, hourglass: { n: 25, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2);
          return g2(e4, r4, "M" + n3 + "," + n3 + "H-" + n3 + "L" + n3 + ",-" + n3 + "H-" + n3 + "Z");
        }, noDot: true }, bowtie: { n: 26, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2);
          return g2(e4, r4, "M" + n3 + "," + n3 + "V-" + n3 + "L-" + n3 + "," + n3 + "V-" + n3 + "Z");
        }, noDot: true }, "circle-cross": { n: 27, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2);
          return g2(e4, r4, "M0," + n3 + "V-" + n3 + "M" + n3 + ",0H-" + n3 + "M" + n3 + ",0A" + n3 + "," + n3 + " 0 1,1 0,-" + n3 + "A" + n3 + "," + n3 + " 0 0,1 " + n3 + ",0Z");
        }, needLine: true, noDot: true }, "circle-x": { n: 28, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2), i2 = l2(t3 / c2, 2);
          return g2(e4, r4, "M" + i2 + "," + i2 + "L-" + i2 + ",-" + i2 + "M" + i2 + ",-" + i2 + "L-" + i2 + "," + i2 + "M" + n3 + ",0A" + n3 + "," + n3 + " 0 1,1 0,-" + n3 + "A" + n3 + "," + n3 + " 0 0,1 " + n3 + ",0Z");
        }, needLine: true, noDot: true }, "square-cross": { n: 29, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2);
          return g2(e4, r4, "M0," + n3 + "V-" + n3 + "M" + n3 + ",0H-" + n3 + "M" + n3 + "," + n3 + "H-" + n3 + "V-" + n3 + "H" + n3 + "Z");
        }, needLine: true, noDot: true }, "square-x": { n: 30, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2);
          return g2(e4, r4, "M" + n3 + "," + n3 + "L-" + n3 + ",-" + n3 + "M" + n3 + ",-" + n3 + "L-" + n3 + "," + n3 + "M" + n3 + "," + n3 + "H-" + n3 + "V-" + n3 + "H" + n3 + "Z");
        }, needLine: true, noDot: true }, "diamond-cross": { n: 31, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(1.3 * t3, 2);
          return g2(e4, r4, "M" + n3 + ",0L0," + n3 + "L-" + n3 + ",0L0,-" + n3 + "ZM0,-" + n3 + "V" + n3 + "M-" + n3 + ",0H" + n3);
        }, needLine: true, noDot: true }, "diamond-x": { n: 32, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(1.3 * t3, 2), i2 = l2(0.65 * t3, 2);
          return g2(e4, r4, "M" + n3 + ",0L0," + n3 + "L-" + n3 + ",0L0,-" + n3 + "ZM-" + i2 + ",-" + i2 + "L" + i2 + "," + i2 + "M-" + i2 + "," + i2 + "L" + i2 + ",-" + i2);
        }, needLine: true, noDot: true }, "cross-thin": { n: 33, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(1.4 * t3, 2);
          return g2(e4, r4, "M0," + n3 + "V-" + n3 + "M" + n3 + ",0H-" + n3);
        }, needLine: true, noDot: true, noFill: true }, "x-thin": { n: 34, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2);
          return g2(e4, r4, "M" + n3 + "," + n3 + "L-" + n3 + ",-" + n3 + "M" + n3 + ",-" + n3 + "L-" + n3 + "," + n3);
        }, needLine: true, noDot: true, noFill: true }, asterisk: { n: 35, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(1.2 * t3, 2), i2 = l2(0.85 * t3, 2);
          return g2(e4, r4, "M0," + n3 + "V-" + n3 + "M" + n3 + ",0H-" + n3 + "M" + i2 + "," + i2 + "L-" + i2 + ",-" + i2 + "M" + i2 + ",-" + i2 + "L-" + i2 + "," + i2);
        }, needLine: true, noDot: true, noFill: true }, hash: { n: 36, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3 / 2, 2), i2 = l2(t3, 2);
          return g2(e4, r4, "M" + n3 + "," + i2 + "V-" + i2 + "M" + (n3 - i2) + ",-" + i2 + "V" + i2 + "M" + i2 + "," + n3 + "H-" + i2 + "M-" + i2 + "," + (n3 - i2) + "H" + i2);
        }, needLine: true, noFill: true }, "y-up": { n: 37, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(1.2 * t3, 2), i2 = l2(1.6 * t3, 2), a2 = l2(0.8 * t3, 2);
          return g2(e4, r4, "M-" + n3 + "," + a2 + "L0,0M" + n3 + "," + a2 + "L0,0M0,-" + i2 + "L0,0");
        }, needLine: true, noDot: true, noFill: true }, "y-down": { n: 38, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(1.2 * t3, 2), i2 = l2(1.6 * t3, 2), a2 = l2(0.8 * t3, 2);
          return g2(e4, r4, "M-" + n3 + ",-" + a2 + "L0,0M" + n3 + ",-" + a2 + "L0,0M0," + i2 + "L0,0");
        }, needLine: true, noDot: true, noFill: true }, "y-left": { n: 39, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(1.2 * t3, 2), i2 = l2(1.6 * t3, 2), a2 = l2(0.8 * t3, 2);
          return g2(e4, r4, "M" + a2 + "," + n3 + "L0,0M" + a2 + ",-" + n3 + "L0,0M-" + i2 + ",0L0,0");
        }, needLine: true, noDot: true, noFill: true }, "y-right": { n: 40, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(1.2 * t3, 2), i2 = l2(1.6 * t3, 2), a2 = l2(0.8 * t3, 2);
          return g2(e4, r4, "M-" + a2 + "," + n3 + "L0,0M-" + a2 + ",-" + n3 + "L0,0M" + i2 + ",0L0,0");
        }, needLine: true, noDot: true, noFill: true }, "line-ew": { n: 41, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(1.4 * t3, 2);
          return g2(e4, r4, "M" + n3 + ",0H-" + n3);
        }, needLine: true, noDot: true, noFill: true }, "line-ns": { n: 42, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(1.4 * t3, 2);
          return g2(e4, r4, "M0," + n3 + "V-" + n3);
        }, needLine: true, noDot: true, noFill: true }, "line-ne": { n: 43, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2);
          return g2(e4, r4, "M" + n3 + ",-" + n3 + "L-" + n3 + "," + n3);
        }, needLine: true, noDot: true, noFill: true }, "line-nw": { n: 44, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2);
          return g2(e4, r4, "M" + n3 + "," + n3 + "L-" + n3 + ",-" + n3);
        }, needLine: true, noDot: true, noFill: true }, "arrow-up": { n: 45, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2);
          return g2(e4, r4, "M0,0L-" + n3 + "," + l2(2 * t3, 2) + "H" + n3 + "Z");
        }, backoff: 1, noDot: true }, "arrow-down": { n: 46, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2);
          return g2(e4, r4, "M0,0L-" + n3 + ",-" + l2(2 * t3, 2) + "H" + n3 + "Z");
        }, noDot: true }, "arrow-left": { n: 47, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(2 * t3, 2), i2 = l2(t3, 2);
          return g2(e4, r4, "M0,0L" + n3 + ",-" + i2 + "V" + i2 + "Z");
        }, noDot: true }, "arrow-right": { n: 48, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(2 * t3, 2), i2 = l2(t3, 2);
          return g2(e4, r4, "M0,0L-" + n3 + ",-" + i2 + "V" + i2 + "Z");
        }, noDot: true }, "arrow-bar-up": { n: 49, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2);
          return g2(e4, r4, "M-" + n3 + ",0H" + n3 + "M0,0L-" + n3 + "," + l2(2 * t3, 2) + "H" + n3 + "Z");
        }, backoff: 1, needLine: true, noDot: true }, "arrow-bar-down": { n: 50, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(t3, 2);
          return g2(e4, r4, "M-" + n3 + ",0H" + n3 + "M0,0L-" + n3 + ",-" + l2(2 * t3, 2) + "H" + n3 + "Z");
        }, needLine: true, noDot: true }, "arrow-bar-left": { n: 51, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(2 * t3, 2), i2 = l2(t3, 2);
          return g2(e4, r4, "M0,-" + i2 + "V" + i2 + "M0,0L" + n3 + ",-" + i2 + "V" + i2 + "Z");
        }, needLine: true, noDot: true }, "arrow-bar-right": { n: 52, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = l2(2 * t3, 2), i2 = l2(t3, 2);
          return g2(e4, r4, "M0,-" + i2 + "V" + i2 + "M0,0L-" + n3 + ",-" + i2 + "V" + i2 + "Z");
        }, needLine: true, noDot: true }, arrow: { n: 53, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = h2 / 2.5, i2 = 2 * t3 * p2(n3), a2 = 2 * t3 * d2(n3);
          return g2(e4, r4, "M0,0L" + -i2 + "," + a2 + "L" + i2 + "," + a2 + "Z");
        }, backoff: 0.9, noDot: true }, "arrow-wide": { n: 54, f: function(t3, e4, r4) {
          if (v2(e4))
            return u2;
          var n3 = h2 / 4, i2 = 2 * t3 * p2(n3), a2 = 2 * t3 * d2(n3);
          return g2(e4, r4, "M0,0L" + -i2 + "," + a2 + "A " + 2 * t3 + "," + 2 * t3 + " 0 0 1 " + i2 + "," + a2 + "Z");
        }, backoff: 0.4, noDot: true } };
      }, 97644: function(t2) {
        t2.exports = { visible: { valType: "boolean", editType: "calc" }, type: { valType: "enumerated", values: ["percent", "constant", "sqrt", "data"], editType: "calc" }, symmetric: { valType: "boolean", editType: "calc" }, array: { valType: "data_array", editType: "calc" }, arrayminus: { valType: "data_array", editType: "calc" }, value: { valType: "number", min: 0, dflt: 10, editType: "calc" }, valueminus: { valType: "number", min: 0, dflt: 10, editType: "calc" }, traceref: { valType: "integer", min: 0, dflt: 0, editType: "style" }, tracerefminus: { valType: "integer", min: 0, dflt: 0, editType: "style" }, copy_ystyle: { valType: "boolean", editType: "plot" }, copy_zstyle: { valType: "boolean", editType: "style" }, color: { valType: "color", editType: "style" }, thickness: { valType: "number", min: 0, dflt: 2, editType: "style" }, width: { valType: "number", min: 0, editType: "plot" }, editType: "calc", _deprecated: { opacity: { valType: "number", editType: "style" } } };
      }, 14880: function(t2, e3, r3) {
        var n2 = r3(38248), i = r3(24040), a = r3(54460), o = r3(3400), s = r3(93792);
        function l2(t3, e4, r4, i2) {
          var l3 = e4["error_" + i2] || {}, u2 = [];
          if (l3.visible && -1 !== ["linear", "log"].indexOf(r4.type)) {
            for (var c2 = s(l3), f2 = 0; f2 < t3.length; f2++) {
              var h2 = t3[f2], p2 = h2.i;
              if (void 0 === p2)
                p2 = f2;
              else if (null === p2)
                continue;
              var d2 = h2[i2];
              if (n2(r4.c2l(d2))) {
                var v2 = c2(d2, p2);
                if (n2(v2[0]) && n2(v2[1])) {
                  var g2 = h2[i2 + "s"] = d2 - v2[0], y2 = h2[i2 + "h"] = d2 + v2[1];
                  u2.push(g2, y2);
                }
              }
            }
            var m2 = r4._id, x = e4._extremes[m2], b2 = a.findExtremes(r4, u2, o.extendFlat({ tozero: x.opts.tozero }, { padded: true }));
            x.min = x.min.concat(b2.min), x.max = x.max.concat(b2.max);
          }
        }
        t2.exports = function(t3) {
          for (var e4 = t3.calcdata, r4 = 0; r4 < e4.length; r4++) {
            var n3 = e4[r4], o2 = n3[0].trace;
            if (true === o2.visible && i.traceIs(o2, "errorBarsOK")) {
              var s2 = a.getFromId(t3, o2.xaxis), u2 = a.getFromId(t3, o2.yaxis);
              l2(n3, o2, s2, "x"), l2(n3, o2, u2, "y");
            }
          }
        };
      }, 93792: function(t2) {
        function e3(t3, e4) {
          return "percent" === t3 ? function(t4) {
            return Math.abs(t4 * e4 / 100);
          } : "constant" === t3 ? function() {
            return Math.abs(e4);
          } : "sqrt" === t3 ? function(t4) {
            return Math.sqrt(Math.abs(t4));
          } : void 0;
        }
        t2.exports = function(t3) {
          var r3 = t3.type, n2 = t3.symmetric;
          if ("data" === r3) {
            var i = t3.array || [];
            if (n2)
              return function(t4, e4) {
                var r4 = +i[e4];
                return [r4, r4];
              };
            var a = t3.arrayminus || [];
            return function(t4, e4) {
              var r4 = +i[e4], n3 = +a[e4];
              return isNaN(r4) && isNaN(n3) ? [NaN, NaN] : [n3 || 0, r4 || 0];
            };
          }
          var o = e3(r3, t3.value), s = e3(r3, t3.valueminus);
          return n2 || void 0 === t3.valueminus ? function(t4) {
            var e4 = o(t4);
            return [e4, e4];
          } : function(t4) {
            return [s(t4), o(t4)];
          };
        };
      }, 65200: function(t2, e3, r3) {
        var n2 = r3(38248), i = r3(24040), a = r3(3400), o = r3(31780), s = r3(97644);
        t2.exports = function(t3, e4, r4, l2) {
          var u2 = "error_" + l2.axis, c2 = o.newContainer(e4, u2), f2 = t3[u2] || {};
          function h2(t4, e5) {
            return a.coerce(f2, c2, s, t4, e5);
          }
          if (false !== h2("visible", void 0 !== f2.array || void 0 !== f2.value || "sqrt" === f2.type)) {
            var p2 = h2("type", "array" in f2 ? "data" : "percent"), d2 = true;
            "sqrt" !== p2 && (d2 = h2("symmetric", !(("data" === p2 ? "arrayminus" : "valueminus") in f2))), "data" === p2 ? (h2("array"), h2("traceref"), d2 || (h2("arrayminus"), h2("tracerefminus"))) : "percent" !== p2 && "constant" !== p2 || (h2("value"), d2 || h2("valueminus"));
            var v2 = "copy_" + l2.inherit + "style";
            l2.inherit && (e4["error_" + l2.inherit] || {}).visible && h2(v2, !(f2.color || n2(f2.thickness) || n2(f2.width))), l2.inherit && c2[v2] || (h2("color", r4), h2("thickness"), h2("width", i.traceIs(e4, "gl3d") ? 0 : 4));
          }
        };
      }, 64968: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(67824).overrideAll, a = r3(97644), o = { error_x: n2.extendFlat({}, a), error_y: n2.extendFlat({}, a) };
        delete o.error_x.copy_zstyle, delete o.error_y.copy_zstyle, delete o.error_y.copy_ystyle;
        var s = { error_x: n2.extendFlat({}, a), error_y: n2.extendFlat({}, a), error_z: n2.extendFlat({}, a) };
        delete s.error_x.copy_ystyle, delete s.error_y.copy_ystyle, delete s.error_z.copy_ystyle, delete s.error_z.copy_zstyle, t2.exports = { moduleType: "component", name: "errorbars", schema: { traces: { scatter: o, bar: o, histogram: o, scatter3d: i(s, "calc", "nested"), scattergl: i(o, "calc", "nested") } }, supplyDefaults: r3(65200), calc: r3(14880), makeComputeError: r3(93792), plot: r3(78512), style: r3(92036), hoverInfo: function(t3, e4, r4) {
          (e4.error_y || {}).visible && (r4.yerr = t3.yh - t3.y, e4.error_y.symmetric || (r4.yerrneg = t3.y - t3.ys)), (e4.error_x || {}).visible && (r4.xerr = t3.xh - t3.x, e4.error_x.symmetric || (r4.xerrneg = t3.x - t3.xs));
        } };
      }, 78512: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(38248), a = r3(43616), o = r3(43028);
        t2.exports = function(t3, e4, r4, s) {
          var l2 = r4.xaxis, u2 = r4.yaxis, c2 = s && s.duration > 0, f2 = t3._context.staticPlot;
          e4.each(function(e5) {
            var h2, p2 = e5[0].trace, d2 = p2.error_x || {}, v2 = p2.error_y || {};
            p2.ids && (h2 = function(t4) {
              return t4.id;
            });
            var g2 = o.hasMarkers(p2) && p2.marker.maxdisplayed > 0;
            v2.visible || d2.visible || (e5 = []);
            var y2 = n2.select(this).selectAll("g.errorbar").data(e5, h2);
            if (y2.exit().remove(), e5.length) {
              d2.visible || y2.selectAll("path.xerror").remove(), v2.visible || y2.selectAll("path.yerror").remove(), y2.style("opacity", 1);
              var m2 = y2.enter().append("g").classed("errorbar", true);
              c2 && m2.style("opacity", 0).transition().duration(s.duration).style("opacity", 1), a.setClipUrl(y2, r4.layerClipId, t3), y2.each(function(t4) {
                var e6 = n2.select(this), r5 = function(t5, e7, r6) {
                  var n3 = { x: e7.c2p(t5.x), y: r6.c2p(t5.y) };
                  return void 0 !== t5.yh && (n3.yh = r6.c2p(t5.yh), n3.ys = r6.c2p(t5.ys), i(n3.ys) || (n3.noYS = true, n3.ys = r6.c2p(t5.ys, true))), void 0 !== t5.xh && (n3.xh = e7.c2p(t5.xh), n3.xs = e7.c2p(t5.xs), i(n3.xs) || (n3.noXS = true, n3.xs = e7.c2p(t5.xs, true))), n3;
                }(t4, l2, u2);
                if (!g2 || t4.vis) {
                  var a2, o2 = e6.select("path.yerror");
                  if (v2.visible && i(r5.x) && i(r5.yh) && i(r5.ys)) {
                    var h3 = v2.width;
                    a2 = "M" + (r5.x - h3) + "," + r5.yh + "h" + 2 * h3 + "m-" + h3 + ",0V" + r5.ys, r5.noYS || (a2 += "m-" + h3 + ",0h" + 2 * h3), o2.size() ? c2 && (o2 = o2.transition().duration(s.duration).ease(s.easing)) : o2 = e6.append("path").style("vector-effect", f2 ? "none" : "non-scaling-stroke").classed("yerror", true), o2.attr("d", a2);
                  } else
                    o2.remove();
                  var p3 = e6.select("path.xerror");
                  if (d2.visible && i(r5.y) && i(r5.xh) && i(r5.xs)) {
                    var y3 = (d2.copy_ystyle ? v2 : d2).width;
                    a2 = "M" + r5.xh + "," + (r5.y - y3) + "v" + 2 * y3 + "m0,-" + y3 + "H" + r5.xs, r5.noXS || (a2 += "m0,-" + y3 + "v" + 2 * y3), p3.size() ? c2 && (p3 = p3.transition().duration(s.duration).ease(s.easing)) : p3 = e6.append("path").style("vector-effect", f2 ? "none" : "non-scaling-stroke").classed("xerror", true), p3.attr("d", a2);
                  } else
                    p3.remove();
                }
              });
            }
          });
        };
      }, 92036: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(76308);
        t2.exports = function(t3) {
          t3.each(function(t4) {
            var e4 = t4[0].trace, r4 = e4.error_y || {}, a = e4.error_x || {}, o = n2.select(this);
            o.selectAll("path.yerror").style("stroke-width", r4.thickness + "px").call(i.stroke, r4.color), a.copy_ystyle && (a = r4), o.selectAll("path.xerror").style("stroke-width", a.thickness + "px").call(i.stroke, a.color);
          });
        };
      }, 55756: function(t2, e3, r3) {
        var n2 = r3(25376), i = r3(65460).hoverlabel, a = r3(92880).extendFlat;
        t2.exports = { hoverlabel: { bgcolor: a({}, i.bgcolor, { arrayOk: true }), bordercolor: a({}, i.bordercolor, { arrayOk: true }), font: n2({ arrayOk: true, editType: "none" }), align: a({}, i.align, { arrayOk: true }), namelength: a({}, i.namelength, { arrayOk: true }), editType: "none" } };
      }, 55056: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(24040);
        function a(t3, e4, r4, i2) {
          i2 = i2 || n2.identity, Array.isArray(t3) && (e4[0][r4] = i2(t3));
        }
        t2.exports = function(t3) {
          var e4 = t3.calcdata, r4 = t3._fullLayout;
          function o(t4) {
            return function(e5) {
              return n2.coerceHoverinfo({ hoverinfo: e5 }, { _module: t4._module }, r4);
            };
          }
          for (var s = 0; s < e4.length; s++) {
            var l2 = e4[s], u2 = l2[0].trace;
            if (!i.traceIs(u2, "pie-like")) {
              var c2 = i.traceIs(u2, "2dMap") ? a : n2.fillArray;
              c2(u2.hoverinfo, l2, "hi", o(u2)), u2.hovertemplate && c2(u2.hovertemplate, l2, "ht"), u2.hoverlabel && (c2(u2.hoverlabel.bgcolor, l2, "hbg"), c2(u2.hoverlabel.bordercolor, l2, "hbc"), c2(u2.hoverlabel.font.size, l2, "hts"), c2(u2.hoverlabel.font.color, l2, "htc"), c2(u2.hoverlabel.font.family, l2, "htf"), c2(u2.hoverlabel.namelength, l2, "hnl"), c2(u2.hoverlabel.align, l2, "hta"));
            }
          }
        };
      }, 62376: function(t2, e3, r3) {
        var n2 = r3(24040), i = r3(83292).hover;
        t2.exports = function(t3, e4, r4) {
          var a = n2.getComponentMethod("annotations", "onClick")(t3, t3._hoverdata);
          function o() {
            t3.emit("plotly_click", { points: t3._hoverdata, event: e4 });
          }
          void 0 !== r4 && i(t3, e4, r4, true), t3._hoverdata && e4 && e4.target && (a && a.then ? a.then(o) : o(), e4.stopImmediatePropagation && e4.stopImmediatePropagation());
        };
      }, 92456: function(t2) {
        t2.exports = { YANGLE: 60, HOVERARROWSIZE: 6, HOVERTEXTPAD: 3, HOVERFONTSIZE: 13, HOVERFONT: "Arial, sans-serif", HOVERMINTIME: 50, HOVERID: "-hover" };
      }, 95448: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(55756), a = r3(16132);
        t2.exports = function(t3, e4, r4, o) {
          var s = n2.extendFlat({}, o.hoverlabel);
          e4.hovertemplate && (s.namelength = -1), a(t3, e4, function(r5, a2) {
            return n2.coerce(t3, e4, i, r5, a2);
          }, s);
        };
      }, 10624: function(t2, e3, r3) {
        var n2 = r3(3400);
        e3.getSubplot = function(t3) {
          return t3.subplot || t3.xaxis + t3.yaxis || t3.geo;
        }, e3.isTraceInSubplots = function(t3, r4) {
          if ("splom" === t3.type) {
            for (var n3 = t3.xaxes || [], i2 = t3.yaxes || [], a2 = 0; a2 < n3.length; a2++)
              for (var o2 = 0; o2 < i2.length; o2++)
                if (-1 !== r4.indexOf(n3[a2] + i2[o2]))
                  return true;
            return false;
          }
          return -1 !== r4.indexOf(e3.getSubplot(t3));
        }, e3.flat = function(t3, e4) {
          for (var r4 = new Array(t3.length), n3 = 0; n3 < t3.length; n3++)
            r4[n3] = e4;
          return r4;
        }, e3.p2c = function(t3, e4) {
          for (var r4 = new Array(t3.length), n3 = 0; n3 < t3.length; n3++)
            r4[n3] = t3[n3].p2c(e4);
          return r4;
        }, e3.getDistanceFunction = function(t3, r4, n3, i2) {
          return "closest" === t3 ? i2 || e3.quadrature(r4, n3) : "x" === t3.charAt(0) ? r4 : n3;
        }, e3.getClosest = function(t3, e4, r4) {
          if (false !== r4.index)
            r4.index >= 0 && r4.index < t3.length ? r4.distance = 0 : r4.index = false;
          else
            for (var n3 = 0; n3 < t3.length; n3++) {
              var i2 = e4(t3[n3]);
              i2 <= r4.distance && (r4.index = n3, r4.distance = i2);
            }
          return r4;
        }, e3.inbox = function(t3, e4, r4) {
          return t3 * e4 < 0 || 0 === t3 ? r4 : 1 / 0;
        }, e3.quadrature = function(t3, e4) {
          return function(r4) {
            var n3 = t3(r4), i2 = e4(r4);
            return Math.sqrt(n3 * n3 + i2 * i2);
          };
        }, e3.makeEventData = function(t3, r4, n3) {
          var i2 = "index" in t3 ? t3.index : t3.pointNumber, a2 = { data: r4._input, fullData: r4, curveNumber: r4.index, pointNumber: i2 };
          if (r4._indexToPoints) {
            var o2 = r4._indexToPoints[i2];
            1 === o2.length ? a2.pointIndex = o2[0] : a2.pointIndices = o2;
          } else
            a2.pointIndex = i2;
          return r4._module.eventData ? a2 = r4._module.eventData(a2, t3, r4, n3, i2) : ("xVal" in t3 ? a2.x = t3.xVal : "x" in t3 && (a2.x = t3.x), "yVal" in t3 ? a2.y = t3.yVal : "y" in t3 && (a2.y = t3.y), t3.xa && (a2.xaxis = t3.xa), t3.ya && (a2.yaxis = t3.ya), void 0 !== t3.zLabelVal && (a2.z = t3.zLabelVal)), e3.appendArrayPointValue(a2, r4, i2), a2;
        }, e3.appendArrayPointValue = function(t3, e4, r4) {
          var i2 = e4._arrayAttrs;
          if (i2)
            for (var s2 = 0; s2 < i2.length; s2++) {
              var l3 = i2[s2], u2 = a(l3);
              if (void 0 === t3[u2]) {
                var c2 = o(n2.nestedProperty(e4, l3).get(), r4);
                void 0 !== c2 && (t3[u2] = c2);
              }
            }
        }, e3.appendArrayMultiPointValues = function(t3, e4, r4) {
          var i2 = e4._arrayAttrs;
          if (i2)
            for (var s2 = 0; s2 < i2.length; s2++) {
              var l3 = i2[s2], u2 = a(l3);
              if (void 0 === t3[u2]) {
                for (var c2 = n2.nestedProperty(e4, l3).get(), f2 = new Array(r4.length), h2 = 0; h2 < r4.length; h2++)
                  f2[h2] = o(c2, r4[h2]);
                t3[u2] = f2;
              }
            }
        };
        var i = { ids: "id", locations: "location", labels: "label", values: "value", "marker.colors": "color", parents: "parent" };
        function a(t3) {
          return i[t3] || t3;
        }
        function o(t3, e4) {
          return Array.isArray(e4) ? Array.isArray(t3) && Array.isArray(t3[e4[0]]) ? t3[e4[0]][e4[1]] : void 0 : t3[e4];
        }
        var s = { x: true, y: true }, l2 = { "x unified": true, "y unified": true };
        e3.isUnifiedHover = function(t3) {
          return "string" == typeof t3 && !!l2[t3];
        }, e3.isXYhover = function(t3) {
          return "string" == typeof t3 && !!s[t3];
        };
      }, 83292: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(38248), a = r3(49760), o = r3(3400), s = o.strTranslate, l2 = o.strRotate, u2 = r3(95924), c2 = r3(72736), f2 = r3(72213), h2 = r3(43616), p2 = r3(76308), d2 = r3(86476), v2 = r3(54460), g2 = r3(24040), y2 = r3(10624), m2 = r3(92456), x = r3(77864), b2 = r3(31140), _ = m2.YANGLE, w2 = Math.PI * _ / 180, T = 1 / Math.sin(w2), k2 = Math.cos(w2), A2 = Math.sin(w2), M = m2.HOVERARROWSIZE, S = m2.HOVERTEXTPAD, E2 = { box: true, ohlc: true, violin: true, candlestick: true }, L = { scatter: true, scattergl: true, splom: true };
        function C2(t3) {
          return [t3.trace.index, t3.index, t3.x0, t3.y0, t3.name, t3.attr, t3.xa ? t3.xa._id : "", t3.ya ? t3.ya._id : ""].join(",");
        }
        e3.hover = function(t3, e4, r4, a2) {
          t3 = o.getGraphDiv(t3);
          var s2 = e4.target;
          o.throttle(t3._fullLayout._uid + m2.HOVERID, m2.HOVERMINTIME, function() {
            !function(t4, e5, r5, a3, s3) {
              r5 || (r5 = "xy");
              var l3 = Array.isArray(r5) ? r5 : [r5], c3 = t4._fullLayout, h3 = c3._plots || [], v3 = h3[r5], m3 = c3._has("cartesian");
              if (v3) {
                var x2 = v3.overlays.map(function(t5) {
                  return t5.id;
                });
                l3 = l3.concat(x2);
              }
              for (var b3 = l3.length, _2 = new Array(b3), w3 = new Array(b3), k3 = false, A3 = 0; A3 < b3; A3++) {
                var S2 = l3[A3];
                if (h3[S2])
                  k3 = true, _2[A3] = h3[S2].xaxis, w3[A3] = h3[S2].yaxis;
                else {
                  if (!c3[S2] || !c3[S2]._subplot)
                    return void o.warn("Unrecognized subplot: " + S2);
                  var P2 = c3[S2]._subplot;
                  _2[A3] = P2.xaxis, w3[A3] = P2.yaxis;
                }
              }
              var I3 = e5.hovermode || c3.hovermode;
              if (I3 && !k3 && (I3 = "closest"), -1 === ["x", "y", "closest", "x unified", "y unified"].indexOf(I3) || !t4.calcdata || t4.querySelector(".zoombox") || t4._dragging)
                return d2.unhoverRaw(t4, e5);
              var N2 = c3.hoverdistance;
              -1 === N2 && (N2 = 1 / 0);
              var q3 = c3.spikedistance;
              -1 === q3 && (q3 = 1 / 0);
              var H2, G2, W, Y, X, Z, K, J, $, Q, tt2, et, rt, nt = [], it = [], at = { hLinePoint: null, vLinePoint: null }, ot = false;
              if (Array.isArray(e5))
                for (I3 = "array", W = 0; W < e5.length; W++)
                  (X = t4.calcdata[e5[W].curveNumber || 0]) && (Z = X[0].trace, "skip" !== X[0].trace.hoverinfo && (it.push(X), "h" === Z.orientation && (ot = true)));
              else {
                for (Y = 0; Y < t4.calcdata.length; Y++)
                  X = t4.calcdata[Y], "skip" !== (Z = X[0].trace).hoverinfo && y2.isTraceInSubplots(Z, l3) && (it.push(X), "h" === Z.orientation && (ot = true));
                var st, lt;
                if (s3) {
                  if (false === u2.triggerHandler(t4, "plotly_beforehover", e5))
                    return;
                  var ut = s3.getBoundingClientRect();
                  st = e5.clientX - ut.left, lt = e5.clientY - ut.top, c3._calcInverseTransform(t4);
                  var ct = o.apply3DTransform(c3._invTransform)(st, lt);
                  if (st = ct[0], lt = ct[1], st < 0 || st > _2[0]._length || lt < 0 || lt > w3[0]._length)
                    return d2.unhoverRaw(t4, e5);
                } else
                  st = "xpx" in e5 ? e5.xpx : _2[0]._length / 2, lt = "ypx" in e5 ? e5.ypx : w3[0]._length / 2;
                if (e5.pointerX = st + _2[0]._offset, e5.pointerY = lt + w3[0]._offset, H2 = "xval" in e5 ? y2.flat(l3, e5.xval) : y2.p2c(_2, st), G2 = "yval" in e5 ? y2.flat(l3, e5.yval) : y2.p2c(w3, lt), !i(H2[0]) || !i(G2[0]))
                  return o.warn("Fx.hover failed", e5, t4), d2.unhoverRaw(t4, e5);
              }
              var ft = 1 / 0;
              function ht(t5, r6) {
                for (Y = 0; Y < it.length; Y++)
                  if ((X = it[Y]) && X[0] && X[0].trace && true === (Z = X[0].trace).visible && 0 !== Z._length && -1 === ["carpet", "contourcarpet"].indexOf(Z._module.name)) {
                    if ("splom" === Z.type ? K = l3[J = 0] : (K = y2.getSubplot(Z), J = l3.indexOf(K)), $ = I3, y2.isUnifiedHover($) && ($ = $.charAt(0)), et = { cd: X, trace: Z, xa: _2[J], ya: w3[J], maxHoverDistance: N2, maxSpikeDistance: q3, index: false, distance: Math.min(ft, N2), spikeDistance: 1 / 0, xSpike: void 0, ySpike: void 0, color: p2.defaultLine, name: Z.name, x0: void 0, x1: void 0, y0: void 0, y1: void 0, xLabelVal: void 0, yLabelVal: void 0, zLabelVal: void 0, text: void 0 }, c3[K] && (et.subplot = c3[K]._subplot), c3._splomScenes && c3._splomScenes[Z.uid] && (et.scene = c3._splomScenes[Z.uid]), rt = nt.length, "array" === $) {
                      var n3 = e5[Y];
                      "pointNumber" in n3 ? (et.index = n3.pointNumber, $ = "closest") : ($ = "", "xval" in n3 && (Q = n3.xval, $ = "x"), "yval" in n3 && (tt2 = n3.yval, $ = $ ? "closest" : "y"));
                    } else
                      void 0 !== t5 && void 0 !== r6 ? (Q = t5, tt2 = r6) : (Q = H2[J], tt2 = G2[J]);
                    if (0 !== N2)
                      if (Z._module && Z._module.hoverPoints) {
                        var a4 = Z._module.hoverPoints(et, Q, tt2, $, { finiteRange: true, hoverLayer: c3._hoverlayer });
                        if (a4)
                          for (var s4, u3 = 0; u3 < a4.length; u3++)
                            s4 = a4[u3], i(s4.x0) && i(s4.y0) && nt.push(R(s4, I3));
                      } else
                        o.log("Unrecognized trace type in hover:", Z);
                    if ("closest" === I3 && nt.length > rt && (nt.splice(0, rt), ft = nt[0].distance), m3 && 0 !== q3 && 0 === nt.length) {
                      et.distance = q3, et.index = false;
                      var f3 = Z._module.hoverPoints(et, Q, tt2, "closest", { hoverLayer: c3._hoverlayer });
                      if (f3 && (f3 = f3.filter(function(t6) {
                        return t6.spikeDistance <= q3;
                      })), f3 && f3.length) {
                        var h4, d3 = f3.filter(function(t6) {
                          return t6.xa.showspikes && "hovered data" !== t6.xa.spikesnap;
                        });
                        if (d3.length) {
                          var v4 = d3[0];
                          i(v4.x0) && i(v4.y0) && (h4 = dt(v4), (!at.vLinePoint || at.vLinePoint.spikeDistance > h4.spikeDistance) && (at.vLinePoint = h4));
                        }
                        var g3 = f3.filter(function(t6) {
                          return t6.ya.showspikes && "hovered data" !== t6.ya.spikesnap;
                        });
                        if (g3.length) {
                          var x3 = g3[0];
                          i(x3.x0) && i(x3.y0) && (h4 = dt(x3), (!at.hLinePoint || at.hLinePoint.spikeDistance > h4.spikeDistance) && (at.hLinePoint = h4));
                        }
                      }
                    }
                  }
              }
              function pt(t5, e6, r6) {
                for (var n3, i2 = null, a4 = 1 / 0, o2 = 0; o2 < t5.length; o2++)
                  n3 = t5[o2].spikeDistance, r6 && 0 === o2 && (n3 = -1 / 0), n3 <= a4 && n3 <= e6 && (i2 = t5[o2], a4 = n3);
                return i2;
              }
              function dt(t5) {
                return t5 ? { xa: t5.xa, ya: t5.ya, x: void 0 !== t5.xSpike ? t5.xSpike : (t5.x0 + t5.x1) / 2, y: void 0 !== t5.ySpike ? t5.ySpike : (t5.y0 + t5.y1) / 2, distance: t5.distance, spikeDistance: t5.spikeDistance, curveNumber: t5.trace.index, color: t5.color, pointNumber: t5.index } : null;
              }
              ht();
              var vt = { fullLayout: c3, container: c3._hoverlayer, event: e5 }, gt = t4._spikepoints, yt = { vLinePoint: at.vLinePoint, hLinePoint: at.hLinePoint };
              t4._spikepoints = yt;
              var mt = function() {
                nt.sort(function(t5, e6) {
                  return t5.distance - e6.distance;
                }), nt = function(t5, e6) {
                  for (var r6 = e6.charAt(0), n3 = [], i2 = [], a4 = [], o2 = 0; o2 < t5.length; o2++) {
                    var s4 = t5[o2];
                    g2.traceIs(s4.trace, "bar-like") || g2.traceIs(s4.trace, "box-violin") ? a4.push(s4) : s4.trace[r6 + "period"] ? i2.push(s4) : n3.push(s4);
                  }
                  return n3.concat(i2).concat(a4);
                }(nt, I3);
              };
              mt();
              var xt = I3.charAt(0), bt = ("x" === xt || "y" === xt) && nt[0] && L[nt[0].trace.type];
              if (m3 && 0 !== q3 && 0 !== nt.length) {
                var _t = pt(nt.filter(function(t5) {
                  return t5.ya.showspikes;
                }), q3, bt);
                at.hLinePoint = dt(_t);
                var wt = pt(nt.filter(function(t5) {
                  return t5.xa.showspikes;
                }), q3, bt);
                at.vLinePoint = dt(wt);
              }
              if (0 === nt.length) {
                var Tt = d2.unhoverRaw(t4, e5);
                return !m3 || null === at.hLinePoint && null === at.vLinePoint || B2(gt) && F2(t4, at, vt), Tt;
              }
              if (m3 && B2(gt) && F2(t4, at, vt), y2.isXYhover($) && 0 !== nt[0].length && "splom" !== nt[0].trace.type) {
                var kt = nt[0], At = (nt = E2[kt.trace.type] ? nt.filter(function(t5) {
                  return t5.trace.index === kt.trace.index;
                }) : [kt]).length;
                ht(j("x", kt, c3), j("y", kt, c3));
                var Mt, St = [], Et = {}, Lt = 0, Ct = function(t5) {
                  var e6 = E2[t5.trace.type] ? C2(t5) : t5.trace.index;
                  if (Et[e6]) {
                    var r6 = Et[e6] - 1, n3 = St[r6];
                    r6 > 0 && Math.abs(t5.distance) < Math.abs(n3.distance) && (St[r6] = t5);
                  } else
                    Lt++, Et[e6] = Lt, St.push(t5);
                };
                for (Mt = 0; Mt < At; Mt++)
                  Ct(nt[Mt]);
                for (Mt = nt.length - 1; Mt > At - 1; Mt--)
                  Ct(nt[Mt]);
                nt = St, mt();
              }
              var Pt = t4._hoverdata, Ot = [], It = U(t4), Dt = V(t4);
              for (W = 0; W < nt.length; W++) {
                var zt = nt[W], Rt = y2.makeEventData(zt, zt.trace, zt.cd);
                if (false !== zt.hovertemplate) {
                  var Ft = false;
                  zt.cd[zt.index] && zt.cd[zt.index].ht && (Ft = zt.cd[zt.index].ht), zt.hovertemplate = Ft || zt.trace.hovertemplate || false;
                }
                if (zt.xa && zt.ya) {
                  var Bt = zt.x0 + zt.xa._offset, Nt = zt.x1 + zt.xa._offset, jt = zt.y0 + zt.ya._offset, Ut = zt.y1 + zt.ya._offset, Vt = Math.min(Bt, Nt), qt = Math.max(Bt, Nt), Ht = Math.min(jt, Ut), Gt = Math.max(jt, Ut);
                  Rt.bbox = { x0: Vt + Dt, x1: qt + Dt, y0: Ht + It, y1: Gt + It };
                }
                zt.eventData = [Rt], Ot.push(Rt);
              }
              t4._hoverdata = Ot;
              var Wt = "y" === I3 && (it.length > 1 || nt.length > 1) || "closest" === I3 && ot && nt.length > 1, Yt = p2.combine(c3.plot_bgcolor || p2.background, c3.paper_bgcolor), Xt = O(nt, { gd: t4, hovermode: I3, rotateLabels: Wt, bgColor: Yt, container: c3._hoverlayer, outerContainer: c3._paper.node(), commonLabelOpts: c3.hoverlabel, hoverdistance: c3.hoverdistance }), Zt = Xt.hoverLabels;
              if (y2.isUnifiedHover(I3) || (function(t5, e6, r6, n3) {
                var i2, a4, o2, s4, l4, u3, c4, f3 = e6 ? "xa" : "ya", h4 = e6 ? "ya" : "xa", p3 = 0, d3 = 1, v4 = t5.size(), g3 = new Array(v4), y3 = 0, m4 = n3.minX, x3 = n3.maxX, b4 = n3.minY, _3 = n3.maxY, w4 = function(t6) {
                  return t6 * r6._invScaleX;
                }, k4 = function(t6) {
                  return t6 * r6._invScaleY;
                };
                function A4(t6) {
                  var e7 = t6[0], r7 = t6[t6.length - 1];
                  if (a4 = e7.pmin - e7.pos - e7.dp + e7.size, o2 = r7.pos + r7.dp + r7.size - e7.pmax, a4 > 0.01) {
                    for (l4 = t6.length - 1; l4 >= 0; l4--)
                      t6[l4].dp += a4;
                    i2 = false;
                  }
                  if (!(o2 < 0.01)) {
                    if (a4 < -0.01) {
                      for (l4 = t6.length - 1; l4 >= 0; l4--)
                        t6[l4].dp -= o2;
                      i2 = false;
                    }
                    if (i2) {
                      var n4 = 0;
                      for (s4 = 0; s4 < t6.length; s4++)
                        (u3 = t6[s4]).pos + u3.dp + u3.size > e7.pmax && n4++;
                      for (s4 = t6.length - 1; s4 >= 0 && !(n4 <= 0); s4--)
                        (u3 = t6[s4]).pos > e7.pmax - 1 && (u3.del = true, n4--);
                      for (s4 = 0; s4 < t6.length && !(n4 <= 0); s4++)
                        if ((u3 = t6[s4]).pos < e7.pmin + 1)
                          for (u3.del = true, n4--, o2 = 2 * u3.size, l4 = t6.length - 1; l4 >= 0; l4--)
                            t6[l4].dp -= o2;
                      for (s4 = t6.length - 1; s4 >= 0 && !(n4 <= 0); s4--)
                        (u3 = t6[s4]).pos + u3.dp + u3.size > e7.pmax && (u3.del = true, n4--);
                    }
                  }
                }
                for (t5.each(function(t6) {
                  var n4 = t6[f3], i3 = t6[h4], a5 = "x" === n4._id.charAt(0), o3 = n4.range;
                  0 === y3 && o3 && o3[0] > o3[1] !== a5 && (d3 = -1);
                  var s5 = 0, l5 = a5 ? r6.width : r6.height;
                  if ("x" === r6.hovermode || "y" === r6.hovermode) {
                    var u4, c5, p4 = D2(t6, e6), v5 = t6.anchor, A5 = "end" === v5 ? -1 : 1;
                    if ("middle" === v5)
                      c5 = (u4 = t6.crossPos + (a5 ? k4(p4.y - t6.by / 2) : w4(t6.bx / 2 + t6.tx2width / 2))) + (a5 ? k4(t6.by) : w4(t6.bx));
                    else if (a5)
                      c5 = (u4 = t6.crossPos + k4(M + p4.y) - k4(t6.by / 2 - M)) + k4(t6.by);
                    else {
                      var S4 = w4(A5 * M + p4.x), E4 = S4 + w4(A5 * t6.bx);
                      u4 = t6.crossPos + Math.min(S4, E4), c5 = t6.crossPos + Math.max(S4, E4);
                    }
                    a5 ? void 0 !== b4 && void 0 !== _3 && Math.min(c5, _3) - Math.max(u4, b4) > 1 && ("left" === i3.side ? (s5 = i3._mainLinePosition, l5 = r6.width) : l5 = i3._mainLinePosition) : void 0 !== m4 && void 0 !== x3 && Math.min(c5, x3) - Math.max(u4, m4) > 1 && ("top" === i3.side ? (s5 = i3._mainLinePosition, l5 = r6.height) : l5 = i3._mainLinePosition);
                  }
                  g3[y3++] = [{ datum: t6, traceIndex: t6.trace.index, dp: 0, pos: t6.pos, posref: t6.posref, size: t6.by * (a5 ? T : 1) / 2, pmin: s5, pmax: l5 }];
                }), g3.sort(function(t6, e7) {
                  return t6[0].posref - e7[0].posref || d3 * (e7[0].traceIndex - t6[0].traceIndex);
                }); !i2 && p3 <= v4; ) {
                  for (p3++, i2 = true, s4 = 0; s4 < g3.length - 1; ) {
                    var S3 = g3[s4], E3 = g3[s4 + 1], L2 = S3[S3.length - 1], C3 = E3[0];
                    if ((a4 = L2.pos + L2.dp + L2.size - C3.pos - C3.dp + C3.size) > 0.01 && L2.pmin === C3.pmin && L2.pmax === C3.pmax) {
                      for (l4 = E3.length - 1; l4 >= 0; l4--)
                        E3[l4].dp += a4;
                      for (S3.push.apply(S3, E3), g3.splice(s4 + 1, 1), c4 = 0, l4 = S3.length - 1; l4 >= 0; l4--)
                        c4 += S3[l4].dp;
                      for (o2 = c4 / S3.length, l4 = S3.length - 1; l4 >= 0; l4--)
                        S3[l4].dp -= o2;
                      i2 = false;
                    } else
                      s4++;
                  }
                  g3.forEach(A4);
                }
                for (s4 = g3.length - 1; s4 >= 0; s4--) {
                  var P3 = g3[s4];
                  for (l4 = P3.length - 1; l4 >= 0; l4--) {
                    var O2 = P3[l4], I4 = O2.datum;
                    I4.offset = O2.dp, I4.del = O2.del;
                  }
                }
              }(Zt, Wt, c3, Xt.commonLabelBoundingBox), z2(Zt, Wt, c3._invScaleX, c3._invScaleY)), s3 && s3.tagName) {
                var Kt = g2.getComponentMethod("annotations", "hasClickToShow")(t4, Ot);
                f2(n2.select(s3), Kt ? "pointer" : "");
              }
              s3 && !a3 && function(t5, e6, r6) {
                if (!r6 || r6.length !== t5._hoverdata.length)
                  return true;
                for (var n3 = r6.length - 1; n3 >= 0; n3--) {
                  var i2 = r6[n3], a4 = t5._hoverdata[n3];
                  if (i2.curveNumber !== a4.curveNumber || String(i2.pointNumber) !== String(a4.pointNumber) || String(i2.pointNumbers) !== String(a4.pointNumbers))
                    return true;
                }
                return false;
              }(t4, 0, Pt) && (Pt && t4.emit("plotly_unhover", { event: e5, points: Pt }), t4.emit("plotly_hover", { event: e5, points: t4._hoverdata, xaxes: _2, yaxes: w3, xvals: H2, yvals: G2 }));
            }(t3, e4, r4, a2, s2);
          });
        }, e3.loneHover = function(t3, e4) {
          var r4 = true;
          Array.isArray(t3) || (r4 = false, t3 = [t3]);
          var i2 = e4.gd, a2 = U(i2), o2 = V(i2), s2 = O(t3.map(function(t4) {
            var r5 = t4._x0 || t4.x0 || t4.x || 0, n3 = t4._x1 || t4.x1 || t4.x || 0, s3 = t4._y0 || t4.y0 || t4.y || 0, l4 = t4._y1 || t4.y1 || t4.y || 0, u4 = t4.eventData;
            if (u4) {
              var c3 = Math.min(r5, n3), f3 = Math.max(r5, n3), h3 = Math.min(s3, l4), d3 = Math.max(s3, l4), v3 = t4.trace;
              if (g2.traceIs(v3, "gl3d")) {
                var y3 = i2._fullLayout[v3.scene]._scene.container, m3 = y3.offsetLeft, x2 = y3.offsetTop;
                c3 += m3, f3 += m3, h3 += x2, d3 += x2;
              }
              u4.bbox = { x0: c3 + o2, x1: f3 + o2, y0: h3 + a2, y1: d3 + a2 }, e4.inOut_bbox && e4.inOut_bbox.push(u4.bbox);
            } else
              u4 = false;
            return { color: t4.color || p2.defaultLine, x0: t4.x0 || t4.x || 0, x1: t4.x1 || t4.x || 0, y0: t4.y0 || t4.y || 0, y1: t4.y1 || t4.y || 0, xLabel: t4.xLabel, yLabel: t4.yLabel, zLabel: t4.zLabel, text: t4.text, name: t4.name, idealAlign: t4.idealAlign, borderColor: t4.borderColor, fontFamily: t4.fontFamily, fontSize: t4.fontSize, fontColor: t4.fontColor, nameLength: t4.nameLength, textAlign: t4.textAlign, trace: t4.trace || { index: 0, hoverinfo: "" }, xa: { _offset: 0 }, ya: { _offset: 0 }, index: 0, hovertemplate: t4.hovertemplate || false, hovertemplateLabels: t4.hovertemplateLabels || false, eventData: u4 };
          }), { gd: i2, hovermode: "closest", rotateLabels: false, bgColor: e4.bgColor || p2.background, container: n2.select(e4.container), outerContainer: e4.outerContainer || e4.container }).hoverLabels, l3 = 0, u3 = 0;
          return s2.sort(function(t4, e5) {
            return t4.y0 - e5.y0;
          }).each(function(t4, r5) {
            var n3 = t4.y0 - t4.by / 2;
            t4.offset = n3 - 5 < l3 ? l3 - n3 + 5 : 0, l3 = n3 + t4.by + t4.offset, r5 === e4.anchorIndex && (u3 = t4.offset);
          }).each(function(t4) {
            t4.offset -= u3;
          }), z2(s2, false, i2._fullLayout._invScaleX, i2._fullLayout._invScaleY), r4 ? s2 : s2.node();
        };
        var P = /<extra>([\s\S]*)<\/extra>/;
        function O(t3, e4) {
          var r4 = e4.gd, i2 = r4._fullLayout, a2 = e4.hovermode, u3 = e4.rotateLabels, f3 = e4.bgColor, d3 = e4.container, v3 = e4.outerContainer, w3 = e4.commonLabelOpts || {};
          if (0 === t3.length)
            return [[]];
          var T2 = e4.fontFamily || m2.HOVERFONT, k3 = e4.fontSize || m2.HOVERFONTSIZE, A3 = t3[0], E3 = A3.xa, L2 = A3.ya, P2 = a2.charAt(0), O2 = P2 + "Label", D3 = A3[O2];
          if (void 0 === D3 && "multicategory" === E3.type)
            for (var z3 = 0; z3 < t3.length && void 0 === (D3 = t3[z3][O2]); z3++)
              ;
          var R2 = q2(r4, v3), F3 = R2.top, B3 = R2.width, N2 = R2.height, j2 = void 0 !== D3 && A3.distance <= e4.hoverdistance && ("x" === a2 || "y" === a2);
          if (j2) {
            var U2, V2, H2 = true;
            for (U2 = 0; U2 < t3.length; U2++)
              if (H2 && void 0 === t3[U2].zLabel && (H2 = false), V2 = t3[U2].hoverinfo || t3[U2].trace.hoverinfo) {
                var G2 = Array.isArray(V2) ? V2 : V2.split("+");
                if (-1 === G2.indexOf("all") && -1 === G2.indexOf(a2)) {
                  j2 = false;
                  break;
                }
              }
            H2 && (j2 = false);
          }
          var W = d3.selectAll("g.axistext").data(j2 ? [0] : []);
          W.enter().append("g").classed("axistext", true), W.exit().remove();
          var Y = { minX: 0, maxX: 0, minY: 0, maxY: 0 };
          if (W.each(function() {
            var t4 = n2.select(this), e5 = o.ensureSingle(t4, "path", "", function(t5) {
              t5.style({ "stroke-width": "1px" });
            }), l3 = o.ensureSingle(t4, "text", "", function(t5) {
              t5.attr("data-notex", 1);
            }), u4 = w3.bgcolor || p2.defaultLine, f4 = w3.bordercolor || p2.contrast(u4), d4 = p2.contrast(u4), v4 = { family: w3.font.family || T2, size: w3.font.size || k3, color: w3.font.color || d4 };
            e5.style({ fill: u4, stroke: f4 }), l3.text(D3).call(h2.font, v4).call(c2.positionText, 0, 0).call(c2.convertToTspans, r4), t4.attr("transform", "");
            var g3, y3, m3 = q2(r4, l3.node());
            if ("x" === a2) {
              var x2 = "top" === E3.side ? "-" : "";
              l3.attr("text-anchor", "middle").call(c2.positionText, 0, "top" === E3.side ? F3 - m3.bottom - M - S : F3 - m3.top + M + S), g3 = E3._offset + (A3.x0 + A3.x1) / 2, y3 = L2._offset + ("top" === E3.side ? 0 : L2._length);
              var b3 = m3.width / 2 + S;
              g3 < b3 ? (g3 = b3, e5.attr("d", "M-" + (b3 - M) + ",0L-" + (b3 - 2 * M) + "," + x2 + M + "H" + b3 + "v" + x2 + (2 * S + m3.height) + "H-" + b3 + "V" + x2 + M + "Z")) : g3 > i2.width - b3 ? (g3 = i2.width - b3, e5.attr("d", "M" + (b3 - M) + ",0L" + b3 + "," + x2 + M + "v" + x2 + (2 * S + m3.height) + "H-" + b3 + "V" + x2 + M + "H" + (b3 - 2 * M) + "Z")) : e5.attr("d", "M0,0L" + M + "," + x2 + M + "H" + b3 + "v" + x2 + (2 * S + m3.height) + "H-" + b3 + "V" + x2 + M + "H-" + M + "Z"), Y.minX = g3 - b3, Y.maxX = g3 + b3, "top" === E3.side ? (Y.minY = y3 - (2 * S + m3.height), Y.maxY = y3 - S) : (Y.minY = y3 + S, Y.maxY = y3 + (2 * S + m3.height));
            } else {
              var _2, C3, P3;
              "right" === L2.side ? (_2 = "start", C3 = 1, P3 = "", g3 = E3._offset + E3._length) : (_2 = "end", C3 = -1, P3 = "-", g3 = E3._offset), y3 = L2._offset + (A3.y0 + A3.y1) / 2, l3.attr("text-anchor", _2), e5.attr("d", "M0,0L" + P3 + M + "," + M + "V" + (S + m3.height / 2) + "h" + P3 + (2 * S + m3.width) + "V-" + (S + m3.height / 2) + "H" + P3 + M + "V-" + M + "Z"), Y.minY = y3 - (S + m3.height / 2), Y.maxY = y3 + (S + m3.height / 2), "right" === L2.side ? (Y.minX = g3 + M, Y.maxX = g3 + M + (2 * S + m3.width)) : (Y.minX = g3 - M - (2 * S + m3.width), Y.maxX = g3 - M);
              var O3, I3 = m3.height / 2, z4 = F3 - m3.top - I3, R3 = "clip" + i2._uid + "commonlabel" + L2._id;
              if (g3 < m3.width + 2 * S + M) {
                O3 = "M-" + (M + S) + "-" + I3 + "h-" + (m3.width - S) + "V" + I3 + "h" + (m3.width - S) + "Z";
                var B4 = m3.width - g3 + S;
                c2.positionText(l3, B4, z4), "end" === _2 && l3.selectAll("tspan").each(function() {
                  var t5 = n2.select(this), e6 = h2.tester.append("text").text(t5.text()).call(h2.font, v4), i3 = q2(r4, e6.node());
                  Math.round(i3.width) < Math.round(m3.width) && t5.attr("x", B4 - i3.width), e6.remove();
                });
              } else
                c2.positionText(l3, C3 * (S + M), z4), O3 = null;
              var N3 = i2._topclips.selectAll("#" + R3).data(O3 ? [0] : []);
              N3.enter().append("clipPath").attr("id", R3).append("path"), N3.exit().remove(), N3.select("path").attr("d", O3), h2.setClipUrl(l3, O3 ? R3 : null, r4);
            }
            t4.attr("transform", s(g3, y3));
          }), y2.isUnifiedHover(a2)) {
            d3.selectAll("g.hovertext").remove();
            var X = t3.filter(function(t4) {
              return "none" !== t4.hoverinfo;
            });
            if (0 === X.length)
              return [];
            var Z = i2.hoverlabel, K = Z.font, J = { showlegend: true, legend: { title: { text: D3, font: K }, font: K, bgcolor: Z.bgcolor, bordercolor: Z.bordercolor, borderwidth: 1, tracegroupgap: 7, traceorder: i2.legend ? i2.legend.traceorder : void 0, orientation: "v" } }, $ = { font: K };
            x(J, $, r4._fullData);
            var Q = $.legend;
            Q.entries = [];
            for (var tt2 = 0; tt2 < X.length; tt2++) {
              var et = X[tt2];
              if ("none" !== et.hoverinfo) {
                var rt = I2(et, true, a2, i2, D3), nt = rt[0], it = rt[1];
                et.name = it, et.text = "" !== it ? it + " : " + nt : nt;
                var at = et.cd[et.index];
                at && (at.mc && (et.mc = at.mc), at.mcc && (et.mc = at.mcc), at.mlc && (et.mlc = at.mlc), at.mlcc && (et.mlc = at.mlcc), at.mlw && (et.mlw = at.mlw), at.mrc && (et.mrc = at.mrc), at.dir && (et.dir = at.dir)), et._distinct = true, Q.entries.push([et]);
              }
            }
            Q.entries.sort(function(t4, e5) {
              return t4[0].trace.index - e5[0].trace.index;
            }), Q.layer = d3, Q._inHover = true, Q._groupTitleFont = Z.grouptitlefont, b2(r4, Q);
            var ot, st, lt, ut, ct = d3.select("g.legend"), ft = q2(r4, ct.node()), ht = ft.width + 2 * S, pt = ft.height + 2 * S, dt = X[0], vt = (dt.x0 + dt.x1) / 2, gt = (dt.y0 + dt.y1) / 2, yt = !(g2.traceIs(dt.trace, "bar-like") || g2.traceIs(dt.trace, "box-violin"));
            "y" === P2 ? yt ? (st = gt - S, ot = gt + S) : (st = Math.min.apply(null, X.map(function(t4) {
              return Math.min(t4.y0, t4.y1);
            })), ot = Math.max.apply(null, X.map(function(t4) {
              return Math.max(t4.y0, t4.y1);
            }))) : st = ot = o.mean(X.map(function(t4) {
              return (t4.y0 + t4.y1) / 2;
            })) - pt / 2, "x" === P2 ? yt ? (lt = vt + S, ut = vt - S) : (lt = Math.max.apply(null, X.map(function(t4) {
              return Math.max(t4.x0, t4.x1);
            })), ut = Math.min.apply(null, X.map(function(t4) {
              return Math.min(t4.x0, t4.x1);
            }))) : lt = ut = o.mean(X.map(function(t4) {
              return (t4.x0 + t4.x1) / 2;
            })) - ht / 2;
            var mt, xt, bt = E3._offset, _t = L2._offset;
            return ut += bt - ht, st += _t - pt, mt = (lt += bt) + ht < B3 && lt >= 0 ? lt : ut + ht < B3 && ut >= 0 ? ut : bt + ht < B3 ? bt : lt - vt < vt - ut + ht ? B3 - ht : 0, mt += S, xt = (ot += _t) + pt < N2 && ot >= 0 ? ot : st + pt < N2 && st >= 0 ? st : _t + pt < N2 ? _t : ot - gt < gt - st + pt ? N2 - pt : 0, xt += S, ct.attr("transform", s(mt - 1, xt - 1)), ct;
          }
          var wt = d3.selectAll("g.hovertext").data(t3, function(t4) {
            return C2(t4);
          });
          return wt.enter().append("g").classed("hovertext", true).each(function() {
            var t4 = n2.select(this);
            t4.append("rect").call(p2.fill, p2.addOpacity(f3, 0.8)), t4.append("text").classed("name", true), t4.append("path").style("stroke-width", "1px"), t4.append("text").classed("nums", true).call(h2.font, T2, k3);
          }), wt.exit().remove(), wt.each(function(t4) {
            var e5 = n2.select(this).attr("transform", ""), o2 = t4.color;
            Array.isArray(o2) && (o2 = o2[t4.eventData[0].pointNumber]);
            var d4 = t4.bgcolor || o2, v4 = p2.combine(p2.opacity(d4) ? d4 : p2.defaultLine, f3), g3 = p2.combine(p2.opacity(o2) ? o2 : p2.defaultLine, f3), y3 = t4.borderColor || p2.contrast(v4), m3 = I2(t4, j2, a2, i2, D3, e5), x2 = m3[0], b3 = m3[1], w4 = e5.select("text.nums").call(h2.font, t4.fontFamily || T2, t4.fontSize || k3, t4.fontColor || y3).text(x2).attr("data-notex", 1).call(c2.positionText, 0, 0).call(c2.convertToTspans, r4), A4 = e5.select("text.name"), E4 = 0, L3 = 0;
            if (b3 && b3 !== x2) {
              A4.call(h2.font, t4.fontFamily || T2, t4.fontSize || k3, g3).text(b3).attr("data-notex", 1).call(c2.positionText, 0, 0).call(c2.convertToTspans, r4);
              var C3 = q2(r4, A4.node());
              E4 = C3.width + 2 * S, L3 = C3.height + 2 * S;
            } else
              A4.remove(), e5.select("rect").remove();
            e5.select("path").style({ fill: v4, stroke: y3 });
            var P3 = t4.xa._offset + (t4.x0 + t4.x1) / 2, O3 = t4.ya._offset + (t4.y0 + t4.y1) / 2, z4 = Math.abs(t4.x1 - t4.x0), R3 = Math.abs(t4.y1 - t4.y0), U3 = q2(r4, w4.node()), V3 = U3.width / i2._invScaleX, H3 = U3.height / i2._invScaleY;
            t4.ty0 = (F3 - U3.top) / i2._invScaleY, t4.bx = V3 + 2 * S, t4.by = Math.max(H3 + 2 * S, L3), t4.anchor = "start", t4.txwidth = V3, t4.tx2width = E4, t4.offset = 0;
            var G3, W2, Y2 = (V3 + M + S + E4) * i2._invScaleX;
            if (u3)
              t4.pos = P3, G3 = O3 + R3 / 2 + Y2 <= N2, W2 = O3 - R3 / 2 - Y2 >= 0, "top" !== t4.idealAlign && G3 || !W2 ? G3 ? (O3 += R3 / 2, t4.anchor = "start") : t4.anchor = "middle" : (O3 -= R3 / 2, t4.anchor = "end"), t4.crossPos = O3;
            else {
              if (t4.pos = O3, G3 = P3 + z4 / 2 + Y2 <= B3, W2 = P3 - z4 / 2 - Y2 >= 0, "left" !== t4.idealAlign && G3 || !W2)
                if (G3)
                  P3 += z4 / 2, t4.anchor = "start";
                else {
                  t4.anchor = "middle";
                  var X2 = Y2 / 2, Z2 = P3 + X2 - B3, K2 = P3 - X2;
                  Z2 > 0 && (P3 -= Z2), K2 < 0 && (P3 += -K2);
                }
              else
                P3 -= z4 / 2, t4.anchor = "end";
              t4.crossPos = P3;
            }
            w4.attr("text-anchor", t4.anchor), E4 && A4.attr("text-anchor", t4.anchor), e5.attr("transform", s(P3, O3) + (u3 ? l2(_) : ""));
          }), { hoverLabels: wt, commonLabelBoundingBox: Y };
        }
        function I2(t3, e4, r4, n3, i2, a2) {
          var s2 = "", l3 = "";
          void 0 !== t3.nameOverride && (t3.name = t3.nameOverride), t3.name && (t3.trace._meta && (t3.name = o.templateString(t3.name, t3.trace._meta)), s2 = N(t3.name, t3.nameLength));
          var u3 = r4.charAt(0), c3 = "x" === u3 ? "y" : "x";
          void 0 !== t3.zLabel ? (void 0 !== t3.xLabel && (l3 += "x: " + t3.xLabel + "<br>"), void 0 !== t3.yLabel && (l3 += "y: " + t3.yLabel + "<br>"), "choropleth" !== t3.trace.type && "choroplethmapbox" !== t3.trace.type && (l3 += (l3 ? "z: " : "") + t3.zLabel)) : e4 && t3[u3 + "Label"] === i2 ? l3 = t3[c3 + "Label"] || "" : void 0 === t3.xLabel ? void 0 !== t3.yLabel && "scattercarpet" !== t3.trace.type && (l3 = t3.yLabel) : l3 = void 0 === t3.yLabel ? t3.xLabel : "(" + t3.xLabel + ", " + t3.yLabel + ")", !t3.text && 0 !== t3.text || Array.isArray(t3.text) || (l3 += (l3 ? "<br>" : "") + t3.text), void 0 !== t3.extraText && (l3 += (l3 ? "<br>" : "") + t3.extraText), a2 && "" === l3 && !t3.hovertemplate && ("" === s2 && a2.remove(), l3 = s2);
          var f3 = t3.hovertemplate || false;
          if (f3) {
            var h3 = t3.hovertemplateLabels || t3;
            t3[u3 + "Label"] !== i2 && (h3[u3 + "other"] = h3[u3 + "Val"], h3[u3 + "otherLabel"] = h3[u3 + "Label"]), l3 = (l3 = o.hovertemplateString(f3, h3, n3._d3locale, t3.eventData[0] || {}, t3.trace._meta)).replace(P, function(e5, r5) {
              return s2 = N(r5, t3.nameLength), "";
            });
          }
          return [l3, s2];
        }
        function D2(t3, e4) {
          var r4 = 0, n3 = t3.offset;
          return e4 && (n3 *= -A2, r4 = t3.offset * k2), { x: r4, y: n3 };
        }
        function z2(t3, e4, r4, i2) {
          var a2 = function(t4) {
            return t4 * r4;
          }, o2 = function(t4) {
            return t4 * i2;
          };
          t3.each(function(t4) {
            var r5 = n2.select(this);
            if (t4.del)
              return r5.remove();
            var i3, s2, l3, u3, f3 = r5.select("text.nums"), p3 = t4.anchor, d3 = "end" === p3 ? -1 : 1, v3 = (u3 = (l3 = (s2 = { start: 1, end: -1, middle: 0 }[(i3 = t4).anchor]) * (M + S)) + s2 * (i3.txwidth + S), "middle" === i3.anchor && (l3 -= i3.tx2width / 2, u3 += i3.txwidth / 2 + S), { alignShift: s2, textShiftX: l3, text2ShiftX: u3 }), g3 = D2(t4, e4), y3 = g3.x, m3 = g3.y, x2 = "middle" === p3;
            r5.select("path").attr("d", x2 ? "M-" + a2(t4.bx / 2 + t4.tx2width / 2) + "," + o2(m3 - t4.by / 2) + "h" + a2(t4.bx) + "v" + o2(t4.by) + "h-" + a2(t4.bx) + "Z" : "M0,0L" + a2(d3 * M + y3) + "," + o2(M + m3) + "v" + o2(t4.by / 2 - M) + "h" + a2(d3 * t4.bx) + "v-" + o2(t4.by) + "H" + a2(d3 * M + y3) + "V" + o2(m3 - M) + "Z");
            var b3 = y3 + v3.textShiftX, _2 = m3 + t4.ty0 - t4.by / 2 + S, w3 = t4.textAlign || "auto";
            "auto" !== w3 && ("left" === w3 && "start" !== p3 ? (f3.attr("text-anchor", "start"), b3 = x2 ? -t4.bx / 2 - t4.tx2width / 2 + S : -t4.bx - S) : "right" === w3 && "end" !== p3 && (f3.attr("text-anchor", "end"), b3 = x2 ? t4.bx / 2 - t4.tx2width / 2 - S : t4.bx + S)), f3.call(c2.positionText, a2(b3), o2(_2)), t4.tx2width && (r5.select("text.name").call(c2.positionText, a2(v3.text2ShiftX + v3.alignShift * S + y3), o2(m3 + t4.ty0 - t4.by / 2 + S)), r5.select("rect").call(h2.setRect, a2(v3.text2ShiftX + (v3.alignShift - 1) * t4.tx2width / 2 + y3), o2(m3 - t4.by / 2 - 1), a2(t4.tx2width), o2(t4.by + 2)));
          });
        }
        function R(t3, e4) {
          var r4 = t3.index, n3 = t3.trace || {}, a2 = t3.cd[0], s2 = t3.cd[r4] || {};
          function l3(t4) {
            return t4 || i(t4) && 0 === t4;
          }
          var u3 = Array.isArray(r4) ? function(t4, e5) {
            var i2 = o.castOption(a2, r4, t4);
            return l3(i2) ? i2 : o.extractOption({}, n3, "", e5);
          } : function(t4, e5) {
            return o.extractOption(s2, n3, t4, e5);
          };
          function c3(e5, r5, n4) {
            var i2 = u3(r5, n4);
            l3(i2) && (t3[e5] = i2);
          }
          if (c3("hoverinfo", "hi", "hoverinfo"), c3("bgcolor", "hbg", "hoverlabel.bgcolor"), c3("borderColor", "hbc", "hoverlabel.bordercolor"), c3("fontFamily", "htf", "hoverlabel.font.family"), c3("fontSize", "hts", "hoverlabel.font.size"), c3("fontColor", "htc", "hoverlabel.font.color"), c3("nameLength", "hnl", "hoverlabel.namelength"), c3("textAlign", "hta", "hoverlabel.align"), t3.posref = "y" === e4 || "closest" === e4 && "h" === n3.orientation ? t3.xa._offset + (t3.x0 + t3.x1) / 2 : t3.ya._offset + (t3.y0 + t3.y1) / 2, t3.x0 = o.constrain(t3.x0, 0, t3.xa._length), t3.x1 = o.constrain(t3.x1, 0, t3.xa._length), t3.y0 = o.constrain(t3.y0, 0, t3.ya._length), t3.y1 = o.constrain(t3.y1, 0, t3.ya._length), void 0 !== t3.xLabelVal && (t3.xLabel = "xLabel" in t3 ? t3.xLabel : v2.hoverLabelText(t3.xa, t3.xLabelVal, n3.xhoverformat), t3.xVal = t3.xa.c2d(t3.xLabelVal)), void 0 !== t3.yLabelVal && (t3.yLabel = "yLabel" in t3 ? t3.yLabel : v2.hoverLabelText(t3.ya, t3.yLabelVal, n3.yhoverformat), t3.yVal = t3.ya.c2d(t3.yLabelVal)), void 0 !== t3.zLabelVal && void 0 === t3.zLabel && (t3.zLabel = String(t3.zLabelVal)), !(isNaN(t3.xerr) || "log" === t3.xa.type && t3.xerr <= 0)) {
            var f3 = v2.tickText(t3.xa, t3.xa.c2l(t3.xerr), "hover").text;
            void 0 !== t3.xerrneg ? t3.xLabel += " +" + f3 + " / -" + v2.tickText(t3.xa, t3.xa.c2l(t3.xerrneg), "hover").text : t3.xLabel += " ± " + f3, "x" === e4 && (t3.distance += 1);
          }
          if (!(isNaN(t3.yerr) || "log" === t3.ya.type && t3.yerr <= 0)) {
            var h3 = v2.tickText(t3.ya, t3.ya.c2l(t3.yerr), "hover").text;
            void 0 !== t3.yerrneg ? t3.yLabel += " +" + h3 + " / -" + v2.tickText(t3.ya, t3.ya.c2l(t3.yerrneg), "hover").text : t3.yLabel += " ± " + h3, "y" === e4 && (t3.distance += 1);
          }
          var p3 = t3.hoverinfo || t3.trace.hoverinfo;
          return p3 && "all" !== p3 && (-1 === (p3 = Array.isArray(p3) ? p3 : p3.split("+")).indexOf("x") && (t3.xLabel = void 0), -1 === p3.indexOf("y") && (t3.yLabel = void 0), -1 === p3.indexOf("z") && (t3.zLabel = void 0), -1 === p3.indexOf("text") && (t3.text = void 0), -1 === p3.indexOf("name") && (t3.name = void 0)), t3;
        }
        function F2(t3, e4, r4) {
          var n3, i2, o2 = r4.container, s2 = r4.fullLayout, l3 = s2._size, u3 = r4.event, c3 = !!e4.hLinePoint, f3 = !!e4.vLinePoint;
          if (o2.selectAll(".spikeline").remove(), f3 || c3) {
            var d3 = p2.combine(s2.plot_bgcolor, s2.paper_bgcolor);
            if (c3) {
              var g3, y3, m3 = e4.hLinePoint;
              n3 = m3 && m3.xa, "cursor" === (i2 = m3 && m3.ya).spikesnap ? (g3 = u3.pointerX, y3 = u3.pointerY) : (g3 = n3._offset + m3.x, y3 = i2._offset + m3.y);
              var x2, b3, _2 = a.readability(m3.color, d3) < 1.5 ? p2.contrast(d3) : m3.color, w3 = i2.spikemode, T2 = i2.spikethickness, k3 = i2.spikecolor || _2, A3 = v2.getPxPosition(t3, i2);
              if (-1 !== w3.indexOf("toaxis") || -1 !== w3.indexOf("across")) {
                if (-1 !== w3.indexOf("toaxis") && (x2 = A3, b3 = g3), -1 !== w3.indexOf("across")) {
                  var M2 = i2._counterDomainMin, S2 = i2._counterDomainMax;
                  "free" === i2.anchor && (M2 = Math.min(M2, i2.position), S2 = Math.max(S2, i2.position)), x2 = l3.l + M2 * l3.w, b3 = l3.l + S2 * l3.w;
                }
                o2.insert("line", ":first-child").attr({ x1: x2, x2: b3, y1: y3, y2: y3, "stroke-width": T2, stroke: k3, "stroke-dasharray": h2.dashStyle(i2.spikedash, T2) }).classed("spikeline", true).classed("crisp", true), o2.insert("line", ":first-child").attr({ x1: x2, x2: b3, y1: y3, y2: y3, "stroke-width": T2 + 2, stroke: d3 }).classed("spikeline", true).classed("crisp", true);
              }
              -1 !== w3.indexOf("marker") && o2.insert("circle", ":first-child").attr({ cx: A3 + ("right" !== i2.side ? T2 : -T2), cy: y3, r: T2, fill: k3 }).classed("spikeline", true);
            }
            if (f3) {
              var E3, L2, C3 = e4.vLinePoint;
              n3 = C3 && C3.xa, i2 = C3 && C3.ya, "cursor" === n3.spikesnap ? (E3 = u3.pointerX, L2 = u3.pointerY) : (E3 = n3._offset + C3.x, L2 = i2._offset + C3.y);
              var P2, O2, I3 = a.readability(C3.color, d3) < 1.5 ? p2.contrast(d3) : C3.color, D3 = n3.spikemode, z3 = n3.spikethickness, R2 = n3.spikecolor || I3, F3 = v2.getPxPosition(t3, n3);
              if (-1 !== D3.indexOf("toaxis") || -1 !== D3.indexOf("across")) {
                if (-1 !== D3.indexOf("toaxis") && (P2 = F3, O2 = L2), -1 !== D3.indexOf("across")) {
                  var B3 = n3._counterDomainMin, N2 = n3._counterDomainMax;
                  "free" === n3.anchor && (B3 = Math.min(B3, n3.position), N2 = Math.max(N2, n3.position)), P2 = l3.t + (1 - N2) * l3.h, O2 = l3.t + (1 - B3) * l3.h;
                }
                o2.insert("line", ":first-child").attr({ x1: E3, x2: E3, y1: P2, y2: O2, "stroke-width": z3, stroke: R2, "stroke-dasharray": h2.dashStyle(n3.spikedash, z3) }).classed("spikeline", true).classed("crisp", true), o2.insert("line", ":first-child").attr({ x1: E3, x2: E3, y1: P2, y2: O2, "stroke-width": z3 + 2, stroke: d3 }).classed("spikeline", true).classed("crisp", true);
              }
              -1 !== D3.indexOf("marker") && o2.insert("circle", ":first-child").attr({ cx: E3, cy: F3 - ("top" !== n3.side ? z3 : -z3), r: z3, fill: R2 }).classed("spikeline", true);
            }
          }
        }
        function B2(t3, e4) {
          return !e4 || e4.vLinePoint !== t3._spikepoints.vLinePoint || e4.hLinePoint !== t3._spikepoints.hLinePoint;
        }
        function N(t3, e4) {
          return c2.plainText(t3 || "", { len: e4, allowedTags: ["br", "sub", "sup", "b", "i", "em"] });
        }
        function j(t3, e4, r4) {
          var n3 = e4[t3 + "a"], i2 = e4[t3 + "Val"], a2 = e4.cd[0];
          if ("category" === n3.type || "multicategory" === n3.type)
            i2 = n3._categoriesMap[i2];
          else if ("date" === n3.type) {
            var o2 = e4.trace[t3 + "periodalignment"];
            if (o2) {
              var s2 = e4.cd[e4.index], l3 = s2[t3 + "Start"];
              void 0 === l3 && (l3 = s2[t3]);
              var u3 = s2[t3 + "End"];
              void 0 === u3 && (u3 = s2[t3]);
              var c3 = u3 - l3;
              "end" === o2 ? i2 += c3 : "middle" === o2 && (i2 += c3 / 2);
            }
            i2 = n3.d2c(i2);
          }
          return a2 && a2.t && a2.t.posLetter === n3._id && ("group" !== r4.boxmode && "group" !== r4.violinmode || (i2 += a2.t.dPos)), i2;
        }
        function U(t3) {
          return t3.offsetTop + t3.clientTop;
        }
        function V(t3) {
          return t3.offsetLeft + t3.clientLeft;
        }
        function q2(t3, e4) {
          var r4 = t3._fullLayout, n3 = e4.getBoundingClientRect(), i2 = n3.left, a2 = n3.top, s2 = i2 + n3.width, l3 = a2 + n3.height, u3 = o.apply3DTransform(r4._invTransform)(i2, a2), c3 = o.apply3DTransform(r4._invTransform)(s2, l3), f3 = u3[0], h3 = u3[1], p3 = c3[0], d3 = c3[1];
          return { x: f3, y: h3, width: p3 - f3, height: d3 - h3, top: Math.min(h3, d3), left: Math.min(f3, p3), right: Math.max(f3, p3), bottom: Math.max(h3, d3) };
        }
      }, 16132: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(76308), a = r3(10624).isUnifiedHover;
        t2.exports = function(t3, e4, r4, o) {
          o = o || {};
          var s = e4.legend;
          function l2(t4) {
            o.font[t4] || (o.font[t4] = s ? e4.legend.font[t4] : e4.font[t4]);
          }
          e4 && a(e4.hovermode) && (o.font || (o.font = {}), l2("size"), l2("family"), l2("color"), s ? (o.bgcolor || (o.bgcolor = i.combine(e4.legend.bgcolor, e4.paper_bgcolor)), o.bordercolor || (o.bordercolor = e4.legend.bordercolor)) : o.bgcolor || (o.bgcolor = e4.paper_bgcolor)), r4("hoverlabel.bgcolor", o.bgcolor), r4("hoverlabel.bordercolor", o.bordercolor), r4("hoverlabel.namelength", o.namelength), n2.coerceFont(r4, "hoverlabel.font", o.font), r4("hoverlabel.align", o.align);
        };
      }, 41008: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(65460);
        t2.exports = function(t3, e4) {
          function r4(r5, a) {
            return void 0 !== e4[r5] ? e4[r5] : n2.coerce(t3, e4, i, r5, a);
          }
          return r4("clickmode"), r4("hovermode");
        };
      }, 93024: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(3400), a = r3(86476), o = r3(10624), s = r3(65460), l2 = r3(83292);
        t2.exports = { moduleType: "component", name: "fx", constants: r3(92456), schema: { layout: s }, attributes: r3(55756), layoutAttributes: s, supplyLayoutGlobalDefaults: r3(81976), supplyDefaults: r3(95448), supplyLayoutDefaults: r3(88336), calc: r3(55056), getDistanceFunction: o.getDistanceFunction, getClosest: o.getClosest, inbox: o.inbox, quadrature: o.quadrature, appendArrayPointValue: o.appendArrayPointValue, castHoverOption: function(t3, e4, r4) {
          return i.castOption(t3, e4, "hoverlabel." + r4);
        }, castHoverinfo: function(t3, e4, r4) {
          return i.castOption(t3, r4, "hoverinfo", function(r5) {
            return i.coerceHoverinfo({ hoverinfo: r5 }, { _module: t3._module }, e4);
          });
        }, hover: l2.hover, unhover: a.unhover, loneHover: l2.loneHover, loneUnhover: function(t3) {
          var e4 = i.isD3Selection(t3) ? t3 : n2.select(t3);
          e4.selectAll("g.hovertext").remove(), e4.selectAll(".spikeline").remove();
        }, click: r3(62376) };
      }, 65460: function(t2, e3, r3) {
        var n2 = r3(92456), i = r3(25376), a = i({ editType: "none" });
        a.family.dflt = n2.HOVERFONT, a.size.dflt = n2.HOVERFONTSIZE, t2.exports = { clickmode: { valType: "flaglist", flags: ["event", "select"], dflt: "event", editType: "plot", extras: ["none"] }, dragmode: { valType: "enumerated", values: ["zoom", "pan", "select", "lasso", "drawclosedpath", "drawopenpath", "drawline", "drawrect", "drawcircle", "orbit", "turntable", false], dflt: "zoom", editType: "modebar" }, hovermode: { valType: "enumerated", values: ["x", "y", "closest", false, "x unified", "y unified"], dflt: "closest", editType: "modebar" }, hoverdistance: { valType: "integer", min: -1, dflt: 20, editType: "none" }, spikedistance: { valType: "integer", min: -1, dflt: -1, editType: "none" }, hoverlabel: { bgcolor: { valType: "color", editType: "none" }, bordercolor: { valType: "color", editType: "none" }, font: a, grouptitlefont: i({ editType: "none" }), align: { valType: "enumerated", values: ["left", "right", "auto"], dflt: "auto", editType: "none" }, namelength: { valType: "integer", min: -1, dflt: 15, editType: "none" }, editType: "none" }, selectdirection: { valType: "enumerated", values: ["h", "v", "d", "any"], dflt: "any", editType: "none" } };
      }, 88336: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(65460), a = r3(41008), o = r3(16132);
        t2.exports = function(t3, e4) {
          function r4(r5, a2) {
            return n2.coerce(t3, e4, i, r5, a2);
          }
          a(t3, e4) && (r4("hoverdistance"), r4("spikedistance")), "select" === r4("dragmode") && r4("selectdirection");
          var s = e4._has("mapbox"), l2 = e4._has("geo"), u2 = e4._basePlotModules.length;
          "zoom" === e4.dragmode && ((s || l2) && 1 === u2 || s && l2 && 2 === u2) && (e4.dragmode = "pan"), o(t3, e4, r4), n2.coerceFont(r4, "hoverlabel.grouptitlefont", e4.hoverlabel.font);
        };
      }, 81976: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(16132), a = r3(65460);
        t2.exports = function(t3, e4) {
          i(t3, e4, function(r4, i2) {
            return n2.coerce(t3, e4, a, r4, i2);
          });
        };
      }, 12704: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(53756).counter, a = r3(86968).u, o = r3(33816).idRegex, s = r3(31780), l2 = { rows: { valType: "integer", min: 1, editType: "plot" }, roworder: { valType: "enumerated", values: ["top to bottom", "bottom to top"], dflt: "top to bottom", editType: "plot" }, columns: { valType: "integer", min: 1, editType: "plot" }, subplots: { valType: "info_array", freeLength: true, dimensions: 2, items: { valType: "enumerated", values: [i("xy").toString(), ""], editType: "plot" }, editType: "plot" }, xaxes: { valType: "info_array", freeLength: true, items: { valType: "enumerated", values: [o.x.toString(), ""], editType: "plot" }, editType: "plot" }, yaxes: { valType: "info_array", freeLength: true, items: { valType: "enumerated", values: [o.y.toString(), ""], editType: "plot" }, editType: "plot" }, pattern: { valType: "enumerated", values: ["independent", "coupled"], dflt: "coupled", editType: "plot" }, xgap: { valType: "number", min: 0, max: 1, editType: "plot" }, ygap: { valType: "number", min: 0, max: 1, editType: "plot" }, domain: a({ name: "grid", editType: "plot", noGridCell: true }, {}), xside: { valType: "enumerated", values: ["bottom", "bottom plot", "top plot", "top"], dflt: "bottom plot", editType: "plot" }, yside: { valType: "enumerated", values: ["left", "left plot", "right plot", "right"], dflt: "left plot", editType: "plot" }, editType: "plot" };
        function u2(t3, e4, r4) {
          var n3 = e4[r4 + "axes"], i2 = Object.keys((t3._splomAxes || {})[r4] || {});
          return Array.isArray(n3) ? n3 : i2.length ? i2 : void 0;
        }
        function c2(t3, e4, r4, n3, i2, a2) {
          var o2 = e4(t3 + "gap", r4), s2 = e4("domain." + t3);
          e4(t3 + "side", n3);
          for (var l3 = new Array(i2), u3 = s2[0], c3 = (s2[1] - u3) / (i2 - o2), f3 = c3 * (1 - o2), h2 = 0; h2 < i2; h2++) {
            var p2 = u3 + c3 * h2;
            l3[a2 ? i2 - 1 - h2 : h2] = [p2, p2 + f3];
          }
          return l3;
        }
        function f2(t3, e4, r4, n3, i2) {
          var a2, o2 = new Array(r4);
          function s2(t4, r5) {
            -1 !== e4.indexOf(r5) && void 0 === n3[r5] ? (o2[t4] = r5, n3[r5] = t4) : o2[t4] = "";
          }
          if (Array.isArray(t3))
            for (a2 = 0; a2 < r4; a2++)
              s2(a2, t3[a2]);
          else
            for (s2(0, i2), a2 = 1; a2 < r4; a2++)
              s2(a2, i2 + (a2 + 1));
          return o2;
        }
        t2.exports = { moduleType: "component", name: "grid", schema: { layout: { grid: l2 } }, layoutAttributes: l2, sizeDefaults: function(t3, e4) {
          var r4 = t3.grid || {}, i2 = u2(e4, r4, "x"), a2 = u2(e4, r4, "y");
          if (t3.grid || i2 || a2) {
            var o2, f3, h2 = Array.isArray(r4.subplots) && Array.isArray(r4.subplots[0]), p2 = Array.isArray(i2), d2 = Array.isArray(a2), v2 = p2 && i2 !== r4.xaxes && d2 && a2 !== r4.yaxes;
            h2 ? (o2 = r4.subplots.length, f3 = r4.subplots[0].length) : (d2 && (o2 = a2.length), p2 && (f3 = i2.length));
            var g2 = s.newContainer(e4, "grid"), y2 = k2("rows", o2), m2 = k2("columns", f3);
            if (y2 * m2 > 1) {
              h2 || p2 || d2 || "independent" === k2("pattern") && (h2 = true), g2._hasSubplotGrid = h2;
              var x, b2, _ = "top to bottom" === k2("roworder"), w2 = h2 ? 0.2 : 0.1, T = h2 ? 0.3 : 0.1;
              v2 && e4._splomGridDflt && (x = e4._splomGridDflt.xside, b2 = e4._splomGridDflt.yside), g2._domains = { x: c2("x", k2, w2, x, m2), y: c2("y", k2, T, b2, y2, _) };
            } else
              delete e4.grid;
          }
          function k2(t4, e5) {
            return n2.coerce(r4, g2, l2, t4, e5);
          }
        }, contentDefaults: function(t3, e4) {
          var r4 = e4.grid;
          if (r4 && r4._domains) {
            var n3, i2, a2, o2, s2, l3, c3, h2 = t3.grid || {}, p2 = e4._subplots, d2 = r4._hasSubplotGrid, v2 = r4.rows, g2 = r4.columns, y2 = "independent" === r4.pattern, m2 = r4._axisMap = {};
            if (d2) {
              var x = h2.subplots || [];
              l3 = r4.subplots = new Array(v2);
              var b2 = 1;
              for (n3 = 0; n3 < v2; n3++) {
                var _ = l3[n3] = new Array(g2), w2 = x[n3] || [];
                for (i2 = 0; i2 < g2; i2++)
                  if (y2 ? (s2 = 1 === b2 ? "xy" : "x" + b2 + "y" + b2, b2++) : s2 = w2[i2], _[i2] = "", -1 !== p2.cartesian.indexOf(s2)) {
                    if (c3 = s2.indexOf("y"), a2 = s2.slice(0, c3), o2 = s2.slice(c3), void 0 !== m2[a2] && m2[a2] !== i2 || void 0 !== m2[o2] && m2[o2] !== n3)
                      continue;
                    _[i2] = s2, m2[a2] = i2, m2[o2] = n3;
                  }
              }
            } else {
              var T = u2(e4, h2, "x"), k2 = u2(e4, h2, "y");
              r4.xaxes = f2(T, p2.xaxis, g2, m2, "x"), r4.yaxes = f2(k2, p2.yaxis, v2, m2, "y");
            }
            var A2 = r4._anchors = {}, M = "top to bottom" === r4.roworder;
            for (var S in m2) {
              var E2, L, C2, P = S.charAt(0), O = r4[P + "side"];
              if (O.length < 8)
                A2[S] = "free";
              else if ("x" === P) {
                if ("t" === O.charAt(0) === M ? (E2 = 0, L = 1, C2 = v2) : (E2 = v2 - 1, L = -1, C2 = -1), d2) {
                  var I2 = m2[S];
                  for (n3 = E2; n3 !== C2; n3 += L)
                    if ((s2 = l3[n3][I2]) && (c3 = s2.indexOf("y"), s2.slice(0, c3) === S)) {
                      A2[S] = s2.slice(c3);
                      break;
                    }
                } else
                  for (n3 = E2; n3 !== C2; n3 += L)
                    if (o2 = r4.yaxes[n3], -1 !== p2.cartesian.indexOf(S + o2)) {
                      A2[S] = o2;
                      break;
                    }
              } else if ("l" === O.charAt(0) ? (E2 = 0, L = 1, C2 = g2) : (E2 = g2 - 1, L = -1, C2 = -1), d2) {
                var D2 = m2[S];
                for (n3 = E2; n3 !== C2; n3 += L)
                  if ((s2 = l3[D2][n3]) && (c3 = s2.indexOf("y"), s2.slice(c3) === S)) {
                    A2[S] = s2.slice(0, c3);
                    break;
                  }
              } else
                for (n3 = E2; n3 !== C2; n3 += L)
                  if (a2 = r4.xaxes[n3], -1 !== p2.cartesian.indexOf(a2 + S)) {
                    A2[S] = a2;
                    break;
                  }
            }
          }
        } };
      }, 65760: function(t2, e3, r3) {
        var n2 = r3(33816), i = r3(31780).templatedArray;
        r3(36208), t2.exports = i("image", { visible: { valType: "boolean", dflt: true, editType: "arraydraw" }, source: { valType: "string", editType: "arraydraw" }, layer: { valType: "enumerated", values: ["below", "above"], dflt: "above", editType: "arraydraw" }, sizex: { valType: "number", dflt: 0, editType: "arraydraw" }, sizey: { valType: "number", dflt: 0, editType: "arraydraw" }, sizing: { valType: "enumerated", values: ["fill", "contain", "stretch"], dflt: "contain", editType: "arraydraw" }, opacity: { valType: "number", min: 0, max: 1, dflt: 1, editType: "arraydraw" }, x: { valType: "any", dflt: 0, editType: "arraydraw" }, y: { valType: "any", dflt: 0, editType: "arraydraw" }, xanchor: { valType: "enumerated", values: ["left", "center", "right"], dflt: "left", editType: "arraydraw" }, yanchor: { valType: "enumerated", values: ["top", "middle", "bottom"], dflt: "top", editType: "arraydraw" }, xref: { valType: "enumerated", values: ["paper", n2.idRegex.x.toString()], dflt: "paper", editType: "arraydraw" }, yref: { valType: "enumerated", values: ["paper", n2.idRegex.y.toString()], dflt: "paper", editType: "arraydraw" }, editType: "arraydraw" });
      }, 63556: function(t2, e3, r3) {
        var n2 = r3(38248), i = r3(36896);
        t2.exports = function(t3, e4, r4, a) {
          e4 = e4 || {};
          var o = "log" === r4 && "linear" === e4.type, s = "linear" === r4 && "log" === e4.type;
          if (o || s) {
            for (var l2, u2, c2 = t3._fullLayout.images, f2 = e4._id.charAt(0), h2 = 0; h2 < c2.length; h2++)
              if (u2 = "images[" + h2 + "].", (l2 = c2[h2])[f2 + "ref"] === e4._id) {
                var p2 = l2[f2], d2 = l2["size" + f2], v2 = null, g2 = null;
                if (o) {
                  v2 = i(p2, e4.range);
                  var y2 = d2 / Math.pow(10, v2) / 2;
                  g2 = 2 * Math.log(y2 + Math.sqrt(1 + y2 * y2)) / Math.LN10;
                } else
                  g2 = (v2 = Math.pow(10, p2)) * (Math.pow(10, d2 / 2) - Math.pow(10, -d2 / 2));
                n2(v2) ? n2(g2) || (g2 = null) : (v2 = null, g2 = null), a(u2 + f2, v2), a(u2 + "size" + f2, g2);
              }
          }
        };
      }, 25024: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(54460), a = r3(51272), o = r3(65760);
        function s(t3, e4, r4) {
          function a2(r5, i2) {
            return n2.coerce(t3, e4, o, r5, i2);
          }
          var s2 = a2("source");
          if (!a2("visible", !!s2))
            return e4;
          a2("layer"), a2("xanchor"), a2("yanchor"), a2("sizex"), a2("sizey"), a2("sizing"), a2("opacity");
          for (var l2 = { _fullLayout: r4 }, u2 = ["x", "y"], c2 = 0; c2 < 2; c2++) {
            var f2 = u2[c2], h2 = i.coerceRef(t3, e4, l2, f2, "paper", void 0);
            "paper" !== h2 && i.getFromId(l2, h2)._imgIndices.push(e4._index), i.coercePosition(e4, l2, a2, h2, f2, 0);
          }
          return e4;
        }
        t2.exports = function(t3, e4) {
          a(t3, e4, { name: "images", handleItemDefaults: s });
        };
      }, 60963: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(43616), a = r3(54460), o = r3(79811), s = r3(9616);
        t2.exports = function(t3) {
          var e4, r4, l2 = t3._fullLayout, u2 = [], c2 = {}, f2 = [];
          for (r4 = 0; r4 < l2.images.length; r4++) {
            var h2 = l2.images[r4];
            if (h2.visible)
              if ("below" === h2.layer && "paper" !== h2.xref && "paper" !== h2.yref) {
                e4 = o.ref2id(h2.xref) + o.ref2id(h2.yref);
                var p2 = l2._plots[e4];
                if (!p2) {
                  f2.push(h2);
                  continue;
                }
                p2.mainplot && (e4 = p2.mainplot.id), c2[e4] || (c2[e4] = []), c2[e4].push(h2);
              } else
                "above" === h2.layer ? u2.push(h2) : f2.push(h2);
          }
          var d2 = { left: { sizing: "xMin", offset: 0 }, center: { sizing: "xMid", offset: -0.5 }, right: { sizing: "xMax", offset: -1 } }, v2 = { top: { sizing: "YMin", offset: 0 }, middle: { sizing: "YMid", offset: -0.5 }, bottom: { sizing: "YMax", offset: -1 } };
          function g2(e5) {
            var r5 = n2.select(this);
            if (this._imgSrc !== e5.source)
              if (r5.attr("xmlns", s.svg), e5.source && "data:" === e5.source.slice(0, 5))
                r5.attr("xlink:href", e5.source), this._imgSrc = e5.source;
              else {
                var i2 = new Promise(function(t4) {
                  var n3 = new Image();
                  function i3() {
                    r5.remove(), t4();
                  }
                  this.img = n3, n3.setAttribute("crossOrigin", "anonymous"), n3.onerror = i3, n3.onload = function() {
                    var e6 = document.createElement("canvas");
                    e6.width = this.width, e6.height = this.height, e6.getContext("2d", { willReadFrequently: true }).drawImage(this, 0, 0);
                    var n4 = e6.toDataURL("image/png");
                    r5.attr("xlink:href", n4), t4();
                  }, r5.on("error", i3), n3.src = e5.source, this._imgSrc = e5.source;
                }.bind(this));
                t3._promises.push(i2);
              }
          }
          function y2(e5) {
            var r5, o2, s2 = n2.select(this), u3 = a.getFromId(t3, e5.xref), c3 = a.getFromId(t3, e5.yref), f3 = "domain" === a.getRefType(e5.xref), h3 = "domain" === a.getRefType(e5.yref), p3 = l2._size;
            r5 = void 0 !== u3 ? "string" == typeof e5.xref && f3 ? u3._length * e5.sizex : Math.abs(u3.l2p(e5.sizex) - u3.l2p(0)) : e5.sizex * p3.w, o2 = void 0 !== c3 ? "string" == typeof e5.yref && h3 ? c3._length * e5.sizey : Math.abs(c3.l2p(e5.sizey) - c3.l2p(0)) : e5.sizey * p3.h;
            var g3, y3, m3 = r5 * d2[e5.xanchor].offset, x2 = o2 * v2[e5.yanchor].offset, b3 = d2[e5.xanchor].sizing + v2[e5.yanchor].sizing;
            switch (g3 = void 0 !== u3 ? "string" == typeof e5.xref && f3 ? u3._length * e5.x + u3._offset : u3.r2p(e5.x) + u3._offset : e5.x * p3.w + p3.l, g3 += m3, y3 = void 0 !== c3 ? "string" == typeof e5.yref && h3 ? c3._length * (1 - e5.y) + c3._offset : c3.r2p(e5.y) + c3._offset : p3.h - e5.y * p3.h + p3.t, y3 += x2, e5.sizing) {
              case "fill":
                b3 += " slice";
                break;
              case "stretch":
                b3 = "none";
            }
            s2.attr({ x: g3, y: y3, width: r5, height: o2, preserveAspectRatio: b3, opacity: e5.opacity });
            var _2 = (u3 && "domain" !== a.getRefType(e5.xref) ? u3._id : "") + (c3 && "domain" !== a.getRefType(e5.yref) ? c3._id : "");
            i.setClipUrl(s2, _2 ? "clip" + l2._uid + _2 : null, t3);
          }
          var m2 = l2._imageLowerLayer.selectAll("image").data(f2), x = l2._imageUpperLayer.selectAll("image").data(u2);
          m2.enter().append("image"), x.enter().append("image"), m2.exit().remove(), x.exit().remove(), m2.each(function(t4) {
            g2.bind(this)(t4), y2.bind(this)(t4);
          }), x.each(function(t4) {
            g2.bind(this)(t4), y2.bind(this)(t4);
          });
          var b2 = Object.keys(l2._plots);
          for (r4 = 0; r4 < b2.length; r4++) {
            e4 = b2[r4];
            var _ = l2._plots[e4];
            if (_.imagelayer) {
              var w2 = _.imagelayer.selectAll("image").data(c2[e4] || []);
              w2.enter().append("image"), w2.exit().remove(), w2.each(function(t4) {
                g2.bind(this)(t4), y2.bind(this)(t4);
              });
            }
          }
        };
      }, 7402: function(t2, e3, r3) {
        t2.exports = { moduleType: "component", name: "images", layoutAttributes: r3(65760), supplyLayoutDefaults: r3(25024), includeBasePlot: r3(36632)("images"), draw: r3(60963), convertCoords: r3(63556) };
      }, 3800: function(t2, e3, r3) {
        var n2 = r3(25376), i = r3(22548);
        t2.exports = { _isSubplotObj: true, visible: { valType: "boolean", dflt: true, editType: "legend" }, bgcolor: { valType: "color", editType: "legend" }, bordercolor: { valType: "color", dflt: i.defaultLine, editType: "legend" }, borderwidth: { valType: "number", min: 0, dflt: 0, editType: "legend" }, font: n2({ editType: "legend" }), grouptitlefont: n2({ editType: "legend" }), orientation: { valType: "enumerated", values: ["v", "h"], dflt: "v", editType: "legend" }, traceorder: { valType: "flaglist", flags: ["reversed", "grouped"], extras: ["normal"], editType: "legend" }, tracegroupgap: { valType: "number", min: 0, dflt: 10, editType: "legend" }, entrywidth: { valType: "number", min: 0, editType: "legend" }, entrywidthmode: { valType: "enumerated", values: ["fraction", "pixels"], dflt: "pixels", editType: "legend" }, itemsizing: { valType: "enumerated", values: ["trace", "constant"], dflt: "trace", editType: "legend" }, itemwidth: { valType: "number", min: 30, dflt: 30, editType: "legend" }, itemclick: { valType: "enumerated", values: ["toggle", "toggleothers", false], dflt: "toggle", editType: "legend" }, itemdoubleclick: { valType: "enumerated", values: ["toggle", "toggleothers", false], dflt: "toggleothers", editType: "legend" }, groupclick: { valType: "enumerated", values: ["toggleitem", "togglegroup"], dflt: "togglegroup", editType: "legend" }, x: { valType: "number", editType: "legend" }, xref: { valType: "enumerated", dflt: "paper", values: ["container", "paper"], editType: "layoutstyle" }, xanchor: { valType: "enumerated", values: ["auto", "left", "center", "right"], dflt: "left", editType: "legend" }, y: { valType: "number", editType: "legend" }, yref: { valType: "enumerated", dflt: "paper", values: ["container", "paper"], editType: "layoutstyle" }, yanchor: { valType: "enumerated", values: ["auto", "top", "middle", "bottom"], editType: "legend" }, uirevision: { valType: "any", editType: "none" }, valign: { valType: "enumerated", values: ["top", "middle", "bottom"], dflt: "middle", editType: "legend" }, title: { text: { valType: "string", dflt: "", editType: "legend" }, font: n2({ editType: "legend" }), side: { valType: "enumerated", values: ["top", "left", "top left", "top center", "top right"], editType: "legend" }, editType: "legend" }, editType: "legend" };
      }, 65196: function(t2) {
        t2.exports = { scrollBarWidth: 6, scrollBarMinHeight: 20, scrollBarColor: "#808BA4", scrollBarMargin: 4, scrollBarEnterAttrs: { rx: 20, ry: 3, width: 0, height: 0 }, titlePad: 2, itemGap: 5 };
      }, 77864: function(t2, e3, r3) {
        var n2 = r3(24040), i = r3(3400), a = r3(31780), o = r3(45464), s = r3(3800), l2 = r3(64859), u2 = r3(42451);
        function c2(t3, e4, r4, c3) {
          var f2 = e4[t3] || {}, h2 = a.newContainer(r4, t3);
          function p2(t4, e5) {
            return i.coerce(f2, h2, s, t4, e5);
          }
          var d2 = i.coerceFont(p2, "font", r4.font);
          if (p2("bgcolor", r4.paper_bgcolor), p2("bordercolor"), p2("visible")) {
            for (var v2, g2 = function(t4, e5) {
              var r5 = v2._input, n3 = v2;
              return i.coerce(r5, n3, o, t4, e5);
            }, y2 = r4.font || {}, m2 = i.coerceFont(p2, "grouptitlefont", i.extendFlat({}, y2, { size: Math.round(1.1 * y2.size) })), x = 0, b2 = false, _ = "normal", w2 = (r4.shapes || []).filter(function(t4) {
              return t4.showlegend;
            }), T = c3.concat(w2).filter(function(e5) {
              return t3 === (e5.legend || "legend");
            }), k2 = 0; k2 < T.length; k2++)
              if ((v2 = T[k2]).visible) {
                var A2 = v2._isShape;
                (v2.showlegend || v2._dfltShowLegend && !(v2._module && v2._module.attributes && v2._module.attributes.showlegend && false === v2._module.attributes.showlegend.dflt)) && (x++, v2.showlegend && (b2 = true, (!A2 && n2.traceIs(v2, "pie-like") || true === v2._input.showlegend) && x++), i.coerceFont(g2, "legendgrouptitle.font", m2)), (!A2 && n2.traceIs(v2, "bar") && "stack" === r4.barmode || -1 !== ["tonextx", "tonexty"].indexOf(v2.fill)) && (_ = u2.isGrouped({ traceorder: _ }) ? "grouped+reversed" : "reversed"), void 0 !== v2.legendgroup && "" !== v2.legendgroup && (_ = u2.isReversed({ traceorder: _ }) ? "reversed+grouped" : "grouped");
              }
            var M = i.coerce(e4, r4, l2, "showlegend", b2 && x > ("legend" === t3 ? 1 : 0));
            if (false === M && (r4[t3] = void 0), (false !== M || f2.uirevision) && (p2("uirevision", r4.uirevision), false !== M)) {
              p2("borderwidth");
              var S, E2, L, C2 = "h" === p2("orientation"), P = "paper" === p2("yref"), O = "paper" === p2("xref"), I2 = "left";
              if (C2 ? (S = 0, n2.getComponentMethod("rangeslider", "isVisible")(e4.xaxis) ? P ? (E2 = 1.1, L = "bottom") : (E2 = 1, L = "top") : P ? (E2 = -0.1, L = "top") : (E2 = 0, L = "bottom")) : (E2 = 1, L = "auto", O ? S = 1.02 : (S = 1, I2 = "right")), i.coerce(f2, h2, { x: { valType: "number", editType: "legend", min: O ? -2 : 0, max: O ? 3 : 1, dflt: S } }, "x"), i.coerce(f2, h2, { y: { valType: "number", editType: "legend", min: P ? -2 : 0, max: P ? 3 : 1, dflt: E2 } }, "y"), p2("traceorder", _), u2.isGrouped(r4[t3]) && p2("tracegroupgap"), p2("entrywidth"), p2("entrywidthmode"), p2("itemsizing"), p2("itemwidth"), p2("itemclick"), p2("itemdoubleclick"), p2("groupclick"), p2("xanchor", I2), p2("yanchor", L), p2("valign"), i.noneOrAll(f2, h2, ["x", "y"]), p2("title.text")) {
                p2("title.side", C2 ? "left" : "top");
                var D2 = i.extendFlat({}, d2, { size: i.bigFont(d2.size) });
                i.coerceFont(p2, "title.font", D2);
              }
            }
          }
        }
        t2.exports = function(t3, e4, r4) {
          var n3, a2 = r4.slice(), o2 = e4.shapes;
          if (o2)
            for (n3 = 0; n3 < o2.length; n3++) {
              var s2 = o2[n3];
              if (s2.showlegend) {
                var l3 = { _input: s2._input, visible: s2.visible, showlegend: s2.showlegend, legend: s2.legend };
                a2.push(l3);
              }
            }
          var u3 = ["legend"];
          for (n3 = 0; n3 < a2.length; n3++)
            i.pushUnique(u3, a2[n3].legend);
          for (e4._legends = [], n3 = 0; n3 < u3.length; n3++) {
            var f2 = u3[n3];
            c2(f2, t3, e4, a2), e4[f2] && e4[f2].visible && (e4[f2]._id = f2), e4._legends.push(f2);
          }
        };
      }, 31140: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(3400), a = r3(7316), o = r3(24040), s = r3(95924), l2 = r3(86476), u2 = r3(43616), c2 = r3(76308), f2 = r3(72736), h2 = r3(33048), p2 = r3(65196), d2 = r3(84284), v2 = d2.LINE_SPACING, g2 = d2.FROM_TL, y2 = d2.FROM_BR, m2 = r3(35456), x = r3(2012), b2 = r3(42451), _ = 1, w2 = /^legend[0-9]*$/;
        function T(t3, e4) {
          var r4, s2, h3 = e4 || {}, d3 = t3._fullLayout, w3 = O(h3), T2 = h3._inHover;
          if (T2 ? (s2 = h3.layer, r4 = "hover") : (s2 = d3._infolayer, r4 = w3), s2) {
            var S2;
            if (r4 += d3._uid, t3._legendMouseDownTime || (t3._legendMouseDownTime = 0), T2) {
              if (!h3.entries)
                return;
              S2 = m2(h3.entries, h3);
            } else {
              for (var I2 = (t3.calcdata || []).slice(), D2 = d3.shapes, z2 = 0; z2 < D2.length; z2++) {
                var R = D2[z2];
                if (R.showlegend) {
                  var F2 = { _isShape: true, _fullInput: R, index: R._index, name: R.name || R.label.text || "shape " + R._index, legend: R.legend, legendgroup: R.legendgroup, legendgrouptitle: R.legendgrouptitle, legendrank: R.legendrank, legendwidth: R.legendwidth, showlegend: R.showlegend, visible: R.visible, opacity: R.opacity, mode: "line" === R.type ? "lines" : "markers", line: R.line, marker: { line: R.line, color: R.fillcolor, size: 12, symbol: "rect" === R.type ? "square" : "circle" === R.type ? "circle" : "hexagon2" } };
                  I2.push([{ trace: F2 }]);
                }
              }
              S2 = d3.showlegend && m2(I2, h3, d3._legends.length > 1);
            }
            var B2 = d3.hiddenlabels || [];
            if (!(T2 || d3.showlegend && S2.length))
              return s2.selectAll("." + w3).remove(), d3._topdefs.select("#" + r4).remove(), a.autoMargin(t3, w3);
            var N = i.ensureSingle(s2, "g", w3, function(t4) {
              T2 || t4.attr("pointer-events", "all");
            }), j = i.ensureSingleById(d3._topdefs, "clipPath", r4, function(t4) {
              t4.append("rect");
            }), U = i.ensureSingle(N, "rect", "bg", function(t4) {
              t4.attr("shape-rendering", "crispEdges");
            });
            U.call(c2.stroke, h3.bordercolor).call(c2.fill, h3.bgcolor).style("stroke-width", h3.borderwidth + "px");
            var V, q2 = i.ensureSingle(N, "g", "scrollbox"), H2 = h3.title;
            h3._titleWidth = 0, h3._titleHeight = 0, H2.text ? ((V = i.ensureSingle(q2, "text", w3 + "titletext")).attr("text-anchor", "start").call(u2.font, H2.font).text(H2.text), L(V, q2, t3, h3, _)) : q2.selectAll("." + w3 + "titletext").remove();
            var G2 = i.ensureSingle(N, "rect", "scrollbar", function(t4) {
              t4.attr(p2.scrollBarEnterAttrs).call(c2.fill, p2.scrollBarColor);
            }), W = q2.selectAll("g.groups").data(S2);
            W.enter().append("g").attr("class", "groups"), W.exit().remove();
            var Y = W.selectAll("g.traces").data(i.identity);
            Y.enter().append("g").attr("class", "traces"), Y.exit().remove(), Y.style("opacity", function(t4) {
              var e5 = t4[0].trace;
              return o.traceIs(e5, "pie-like") ? -1 !== B2.indexOf(t4[0].label) ? 0.5 : 1 : "legendonly" === e5.visible ? 0.5 : 1;
            }).each(function() {
              n2.select(this).call(M, t3, h3);
            }).call(x, t3, h3).each(function() {
              T2 || n2.select(this).call(E2, t3, w3);
            }), i.syncOrAsync([a.previousPromises, function() {
              return function(t4, e5, r5, i2) {
                var a2 = t4._fullLayout, o2 = O(i2);
                i2 || (i2 = a2[o2]);
                var s3 = a2._size, l3 = b2.isVertical(i2), c3 = b2.isGrouped(i2), f3 = "fraction" === i2.entrywidthmode, h4 = i2.borderwidth, d4 = 2 * h4, v3 = p2.itemGap, g3 = i2.itemwidth + 2 * v3, y3 = 2 * (h4 + v3), m3 = P(i2), x2 = i2.y < 0 || 0 === i2.y && "top" === m3, _2 = i2.y > 1 || 1 === i2.y && "bottom" === m3, w4 = i2.tracegroupgap, T3 = {};
                i2._maxHeight = Math.max(x2 || _2 ? a2.height / 2 : s3.h, 30);
                var A3 = 0;
                i2._width = 0, i2._height = 0;
                var M2 = function(t5) {
                  var e6 = 0, r6 = 0, n3 = t5.title.side;
                  return n3 && (-1 !== n3.indexOf("left") && (e6 = t5._titleWidth), -1 !== n3.indexOf("top") && (r6 = t5._titleHeight)), [e6, r6];
                }(i2);
                if (l3)
                  r5.each(function(t5) {
                    var e6 = t5[0].height;
                    u2.setTranslate(this, h4 + M2[0], h4 + M2[1] + i2._height + e6 / 2 + v3), i2._height += e6, i2._width = Math.max(i2._width, t5[0].width);
                  }), A3 = g3 + i2._width, i2._width += v3 + g3 + d4, i2._height += y3, c3 && (e5.each(function(t5, e6) {
                    u2.setTranslate(this, 0, e6 * i2.tracegroupgap);
                  }), i2._height += (i2._lgroupsLength - 1) * i2.tracegroupgap);
                else {
                  var S3 = C2(i2), E3 = i2.x < 0 || 0 === i2.x && "right" === S3, L2 = i2.x > 1 || 1 === i2.x && "left" === S3, I3 = _2 || x2, D3 = a2.width / 2;
                  i2._maxWidth = Math.max(E3 ? I3 && "left" === S3 ? s3.l + s3.w : D3 : L2 ? I3 && "right" === S3 ? s3.r + s3.w : D3 : s3.w, 2 * g3);
                  var z3 = 0, R2 = 0;
                  r5.each(function(t5) {
                    var e6 = k2(t5, i2, g3);
                    z3 = Math.max(z3, e6), R2 += e6;
                  }), A3 = null;
                  var F3 = 0;
                  if (c3) {
                    var B3 = 0, N2 = 0, j2 = 0;
                    e5.each(function() {
                      var t5 = 0, e6 = 0;
                      n2.select(this).selectAll("g.traces").each(function(r7) {
                        var n3 = k2(r7, i2, g3), a3 = r7[0].height;
                        u2.setTranslate(this, M2[0], M2[1] + h4 + v3 + a3 / 2 + e6), e6 += a3, t5 = Math.max(t5, n3), T3[r7[0].trace.legendgroup] = t5;
                      });
                      var r6 = t5 + v3;
                      N2 > 0 && r6 + h4 + N2 > i2._maxWidth ? (F3 = Math.max(F3, N2), N2 = 0, j2 += B3 + w4, B3 = e6) : B3 = Math.max(B3, e6), u2.setTranslate(this, N2, j2), N2 += r6;
                    }), i2._width = Math.max(F3, N2) + h4, i2._height = j2 + B3 + y3;
                  } else {
                    var U2 = r5.size(), V2 = R2 + d4 + (U2 - 1) * v3 < i2._maxWidth, q3 = 0, H3 = 0, G3 = 0, W2 = 0;
                    r5.each(function(t5) {
                      var e6 = t5[0].height, r6 = k2(t5, i2, g3), n3 = V2 ? r6 : z3;
                      f3 || (n3 += v3), n3 + h4 + H3 - v3 >= i2._maxWidth && (F3 = Math.max(F3, W2), H3 = 0, G3 += q3, i2._height += q3, q3 = 0), u2.setTranslate(this, M2[0] + h4 + H3, M2[1] + h4 + G3 + e6 / 2 + v3), W2 = H3 + r6 + v3, H3 += n3, q3 = Math.max(q3, e6);
                    }), V2 ? (i2._width = H3 + d4, i2._height = q3 + y3) : (i2._width = Math.max(F3, W2) + d4, i2._height += q3 + y3);
                  }
                }
                i2._width = Math.ceil(Math.max(i2._width + M2[0], i2._titleWidth + 2 * (h4 + p2.titlePad))), i2._height = Math.ceil(Math.max(i2._height + M2[1], i2._titleHeight + 2 * (h4 + p2.itemGap))), i2._effHeight = Math.min(i2._height, i2._maxHeight);
                var Y2 = t4._context.edits, X = Y2.legendText || Y2.legendPosition;
                r5.each(function(t5) {
                  var e6 = n2.select(this).select("." + o2 + "toggle"), r6 = t5[0].height, a3 = t5[0].trace.legendgroup, s4 = k2(t5, i2, g3);
                  c3 && "" !== a3 && (s4 = T3[a3]);
                  var h5 = X ? g3 : A3 || s4;
                  l3 || f3 || (h5 += v3 / 2), u2.setRect(e6, 0, -r6 / 2, h5, r6);
                });
              }(t3, W, Y, h3);
            }, function() {
              var e5, c3, m3, x2, b3 = d3._size, _2 = h3.borderwidth, k3 = "paper" === h3.xref, M2 = "paper" === h3.yref;
              if (H2.text && function(t4, e6, r5) {
                if ("top center" === e6.title.side || "top right" === e6.title.side) {
                  var n3 = e6.title.font.size * v2, i2 = 0, a2 = t4.node(), o2 = u2.bBox(a2).width;
                  "top center" === e6.title.side ? i2 = 0.5 * (e6._width - 2 * r5 - 2 * p2.titlePad - o2) : "top right" === e6.title.side && (i2 = e6._width - 2 * r5 - 2 * p2.titlePad - o2), f2.positionText(t4, r5 + p2.titlePad + i2, r5 + n3);
                }
              }(V, h3, _2), !T2) {
                var S3, E3;
                S3 = k3 ? b3.l + b3.w * h3.x - g2[C2(h3)] * h3._width : d3.width * h3.x - g2[C2(h3)] * h3._width, E3 = M2 ? b3.t + b3.h * (1 - h3.y) - g2[P(h3)] * h3._effHeight : d3.height * (1 - h3.y) - g2[P(h3)] * h3._effHeight;
                var L2 = function(t4, e6, r5, n3) {
                  var i2 = t4._fullLayout, o2 = i2[e6], s3 = C2(o2), l3 = P(o2), u3 = "paper" === o2.xref, c4 = "paper" === o2.yref;
                  t4._fullLayout._reservedMargin[e6] = {};
                  var f3 = o2.y < 0.5 ? "b" : "t", h4 = o2.x < 0.5 ? "l" : "r", p3 = { r: i2.width - r5, l: r5 + o2._width, b: i2.height - n3, t: n3 + o2._effHeight };
                  if (u3 && c4)
                    return a.autoMargin(t4, e6, { x: o2.x, y: o2.y, l: o2._width * g2[s3], r: o2._width * y2[s3], b: o2._effHeight * y2[l3], t: o2._effHeight * g2[l3] });
                  u3 ? t4._fullLayout._reservedMargin[e6][f3] = p3[f3] : c4 || "v" === o2.orientation ? t4._fullLayout._reservedMargin[e6][h4] = p3[h4] : t4._fullLayout._reservedMargin[e6][f3] = p3[f3];
                }(t3, w3, S3, E3);
                if (L2)
                  return;
                if (d3.margin.autoexpand) {
                  var O2 = S3, I3 = E3;
                  S3 = k3 ? i.constrain(S3, 0, d3.width - h3._width) : O2, E3 = M2 ? i.constrain(E3, 0, d3.height - h3._effHeight) : I3, S3 !== O2 && i.log("Constrain " + w3 + ".x to make legend fit inside graph"), E3 !== I3 && i.log("Constrain " + w3 + ".y to make legend fit inside graph");
                }
                u2.setTranslate(N, S3, E3);
              }
              if (G2.on(".drag", null), N.on("wheel", null), T2 || h3._height <= h3._maxHeight || t3._context.staticPlot) {
                var D3 = h3._effHeight;
                T2 && (D3 = h3._height), U.attr({ width: h3._width - _2, height: D3 - _2, x: _2 / 2, y: _2 / 2 }), u2.setTranslate(q2, 0, 0), j.select("rect").attr({ width: h3._width - 2 * _2, height: D3 - 2 * _2, x: _2, y: _2 }), u2.setClipUrl(q2, r4, t3), u2.setRect(G2, 0, 0, 0, 0), delete h3._scrollY;
              } else {
                var z3, R2, F3, B3 = Math.max(p2.scrollBarMinHeight, h3._effHeight * h3._effHeight / h3._height), W2 = h3._effHeight - B3 - 2 * p2.scrollBarMargin, Y2 = h3._height - h3._effHeight, X = W2 / Y2, Z = Math.min(h3._scrollY || 0, Y2);
                U.attr({ width: h3._width - 2 * _2 + p2.scrollBarWidth + p2.scrollBarMargin, height: h3._effHeight - _2, x: _2 / 2, y: _2 / 2 }), j.select("rect").attr({ width: h3._width - 2 * _2 + p2.scrollBarWidth + p2.scrollBarMargin, height: h3._effHeight - 2 * _2, x: _2, y: _2 + Z }), u2.setClipUrl(q2, r4, t3), $(Z, B3, X), N.on("wheel", function() {
                  $(Z = i.constrain(h3._scrollY + n2.event.deltaY / W2 * Y2, 0, Y2), B3, X), 0 !== Z && Z !== Y2 && n2.event.preventDefault();
                });
                var K = n2.behavior.drag().on("dragstart", function() {
                  var t4 = n2.event.sourceEvent;
                  z3 = "touchstart" === t4.type ? t4.changedTouches[0].clientY : t4.clientY, F3 = Z;
                }).on("drag", function() {
                  var t4 = n2.event.sourceEvent;
                  2 === t4.buttons || t4.ctrlKey || (R2 = "touchmove" === t4.type ? t4.changedTouches[0].clientY : t4.clientY, Z = function(t5, e6, r5) {
                    var n3 = (r5 - e6) / X + t5;
                    return i.constrain(n3, 0, Y2);
                  }(F3, z3, R2), $(Z, B3, X));
                });
                G2.call(K);
                var J = n2.behavior.drag().on("dragstart", function() {
                  var t4 = n2.event.sourceEvent;
                  "touchstart" === t4.type && (z3 = t4.changedTouches[0].clientY, F3 = Z);
                }).on("drag", function() {
                  var t4 = n2.event.sourceEvent;
                  "touchmove" === t4.type && (R2 = t4.changedTouches[0].clientY, Z = function(t5, e6, r5) {
                    var n3 = (e6 - r5) / X + t5;
                    return i.constrain(n3, 0, Y2);
                  }(F3, z3, R2), $(Z, B3, X));
                });
                q2.call(J);
              }
              function $(e6, r5, n3) {
                h3._scrollY = t3._fullLayout[w3]._scrollY = e6, u2.setTranslate(q2, 0, -e6), u2.setRect(G2, h3._width, p2.scrollBarMargin + e6 * n3, p2.scrollBarWidth, r5), j.select("rect").attr("y", _2 + e6);
              }
              t3._context.edits.legendPosition && (N.classed("cursor-move", true), l2.init({ element: N.node(), gd: t3, prepFn: function() {
                var t4 = u2.getTranslate(N);
                m3 = t4.x, x2 = t4.y;
              }, moveFn: function(t4, r5) {
                var n3 = m3 + t4, i2 = x2 + r5;
                u2.setTranslate(N, n3, i2), e5 = l2.align(n3, h3._width, b3.l, b3.l + b3.w, h3.xanchor), c3 = l2.align(i2 + h3._height, -h3._height, b3.t + b3.h, b3.t, h3.yanchor);
              }, doneFn: function() {
                if (void 0 !== e5 && void 0 !== c3) {
                  var r5 = {};
                  r5[w3 + ".x"] = e5, r5[w3 + ".y"] = c3, o.call("_guiRelayout", t3, r5);
                }
              }, clickFn: function(e6, r5) {
                var n3 = s2.selectAll("g.traces").filter(function() {
                  var t4 = this.getBoundingClientRect();
                  return r5.clientX >= t4.left && r5.clientX <= t4.right && r5.clientY >= t4.top && r5.clientY <= t4.bottom;
                });
                n3.size() > 0 && A2(t3, N, n3, e6, r5);
              } }));
            }], t3);
          }
        }
        function k2(t3, e4, r4) {
          var n3 = t3[0], i2 = n3.width, a2 = e4.entrywidthmode, o2 = n3.trace.legendwidth || e4.entrywidth;
          return "fraction" === a2 ? e4._maxWidth * o2 : r4 + (o2 || i2);
        }
        function A2(t3, e4, r4, n3, i2) {
          var a2 = r4.data()[0][0].trace, l3 = { event: i2, node: r4.node(), curveNumber: a2.index, expandedIndex: a2._expandedIndex, data: t3.data, layout: t3.layout, frames: t3._transitionData._frames, config: t3._context, fullData: t3._fullData, fullLayout: t3._fullLayout };
          a2._group && (l3.group = a2._group), o.traceIs(a2, "pie-like") && (l3.label = r4.datum()[0].label);
          var u3 = s.triggerHandler(t3, "plotly_legendclick", l3);
          if (1 === n3) {
            if (false === u3)
              return;
            e4._clickTimeout = setTimeout(function() {
              t3._fullLayout && h2(r4, t3, n3);
            }, t3._context.doubleClickDelay);
          } else
            2 === n3 && (e4._clickTimeout && clearTimeout(e4._clickTimeout), t3._legendMouseDownTime = 0, false !== s.triggerHandler(t3, "plotly_legenddoubleclick", l3) && false !== u3 && h2(r4, t3, n3));
        }
        function M(t3, e4, r4) {
          var n3, a2, s2 = O(r4), l3 = t3.data()[0][0], c3 = l3.trace, h3 = o.traceIs(c3, "pie-like"), d3 = !r4._inHover && e4._context.edits.legendText && !h3, v3 = r4._maxNameLength;
          l3.groupTitle ? (n3 = l3.groupTitle.text, a2 = l3.groupTitle.font) : (a2 = r4.font, r4.entries ? n3 = l3.text : (n3 = h3 ? l3.label : c3.name, c3._meta && (n3 = i.templateString(n3, c3._meta))));
          var g3 = i.ensureSingle(t3, "text", s2 + "text");
          g3.attr("text-anchor", "start").call(u2.font, a2).text(d3 ? S(n3, v3) : n3);
          var y3 = r4.itemwidth + 2 * p2.itemGap;
          f2.positionText(g3, y3, 0), d3 ? g3.call(f2.makeEditable, { gd: e4, text: n3 }).call(L, t3, e4, r4).on("edit", function(n4) {
            this.text(S(n4, v3)).call(L, t3, e4, r4);
            var a3 = l3.trace._fullInput || {}, s3 = {};
            if (o.hasTransform(a3, "groupby")) {
              var u3 = o.getTransformIndices(a3, "groupby"), f3 = u3[u3.length - 1], h4 = i.keyedContainer(a3, "transforms[" + f3 + "].styles", "target", "value.name");
              h4.set(l3.trace._group, n4), s3 = h4.constructUpdate();
            } else
              s3.name = n4;
            return a3._isShape ? o.call("_guiRelayout", e4, "shapes[" + c3.index + "].name", s3.name) : o.call("_guiRestyle", e4, s3, c3.index);
          }) : L(g3, t3, e4, r4);
        }
        function S(t3, e4) {
          var r4 = Math.max(4, e4);
          if (t3 && t3.trim().length >= r4 / 2)
            return t3;
          for (var n3 = r4 - (t3 = t3 || "").length; n3 > 0; n3--)
            t3 += " ";
          return t3;
        }
        function E2(t3, e4, r4) {
          var a2, o2 = e4._context.doubleClickDelay, s2 = 1, l3 = i.ensureSingle(t3, "rect", r4 + "toggle", function(t4) {
            e4._context.staticPlot || t4.style("cursor", "pointer").attr("pointer-events", "all"), t4.call(c2.fill, "rgba(0,0,0,0)");
          });
          e4._context.staticPlot || (l3.on("mousedown", function() {
            (a2 = new Date().getTime()) - e4._legendMouseDownTime < o2 ? s2 += 1 : (s2 = 1, e4._legendMouseDownTime = a2);
          }), l3.on("mouseup", function() {
            if (!e4._dragged && !e4._editing) {
              var i2 = e4._fullLayout[r4];
              new Date().getTime() - e4._legendMouseDownTime > o2 && (s2 = Math.max(s2 - 1, 1)), A2(e4, i2, t3, s2, n2.event);
            }
          }));
        }
        function L(t3, e4, r4, n3, i2) {
          n3._inHover && t3.attr("data-notex", true), f2.convertToTspans(t3, r4, function() {
            !function(t4, e5, r5, n4) {
              var i3 = t4.data()[0][0];
              if (r5._inHover || !i3 || i3.trace.showlegend) {
                var a2 = t4.select("g[class*=math-group]"), o2 = a2.node(), s2 = O(r5);
                r5 || (r5 = e5._fullLayout[s2]);
                var l3, c3, h3 = r5.borderwidth, d3 = (n4 === _ ? r5.title.font : i3.groupTitle ? i3.groupTitle.font : r5.font).size * v2;
                if (o2) {
                  var g3 = u2.bBox(o2);
                  l3 = g3.height, c3 = g3.width, n4 === _ ? u2.setTranslate(a2, h3, h3 + 0.75 * l3) : u2.setTranslate(a2, 0, 0.25 * l3);
                } else {
                  var y3 = "." + s2 + (n4 === _ ? "title" : "") + "text", m3 = t4.select(y3), x2 = f2.lineCount(m3), b3 = m3.node();
                  if (l3 = d3 * x2, c3 = b3 ? u2.bBox(b3).width : 0, n4 === _)
                    "left" === r5.title.side && (c3 += 2 * p2.itemGap), f2.positionText(m3, h3 + p2.titlePad, h3 + d3);
                  else {
                    var w3 = 2 * p2.itemGap + r5.itemwidth;
                    i3.groupTitle && (w3 = p2.itemGap, c3 -= r5.itemwidth), f2.positionText(m3, w3, -d3 * ((x2 - 1) / 2 - 0.3));
                  }
                }
                n4 === _ ? (r5._titleWidth = c3, r5._titleHeight = l3) : (i3.lineHeight = d3, i3.height = Math.max(l3, 16) + 3, i3.width = c3);
              } else
                t4.remove();
            }(e4, r4, n3, i2);
          });
        }
        function C2(t3) {
          return i.isRightAnchor(t3) ? "right" : i.isCenterAnchor(t3) ? "center" : "left";
        }
        function P(t3) {
          return i.isBottomAnchor(t3) ? "bottom" : i.isMiddleAnchor(t3) ? "middle" : "top";
        }
        function O(t3) {
          return t3._id || "legend";
        }
        t2.exports = function(t3, e4) {
          if (e4)
            T(t3, e4);
          else {
            var r4 = t3._fullLayout, i2 = r4._legends;
            r4._infolayer.selectAll('[class^="legend"]').each(function() {
              var t4 = n2.select(this), e5 = t4.attr("class").split(" ")[0];
              e5.match(w2) && -1 === i2.indexOf(e5) && t4.remove();
            });
            for (var a2 = 0; a2 < i2.length; a2++) {
              var o2 = i2[a2];
              T(t3, t3._fullLayout[o2]);
            }
          }
        };
      }, 35456: function(t2, e3, r3) {
        var n2 = r3(24040), i = r3(42451);
        t2.exports = function(t3, e4, r4) {
          var a, o, s = e4._inHover, l2 = i.isGrouped(e4), u2 = i.isReversed(e4), c2 = {}, f2 = [], h2 = false, p2 = {}, d2 = 0, v2 = 0;
          function g2(t4, n3, a2) {
            if (false !== e4.visible && (!r4 || t4 === e4._id))
              if ("" !== n3 && i.isGrouped(e4))
                -1 === f2.indexOf(n3) ? (f2.push(n3), h2 = true, c2[n3] = [a2]) : c2[n3].push(a2);
              else {
                var o2 = "~~i" + d2;
                f2.push(o2), c2[o2] = [a2], d2++;
              }
          }
          for (a = 0; a < t3.length; a++) {
            var y2 = t3[a], m2 = y2[0], x = m2.trace, b2 = x.legend, _ = x.legendgroup;
            if (s || x.visible && x.showlegend)
              if (n2.traceIs(x, "pie-like"))
                for (p2[_] || (p2[_] = {}), o = 0; o < y2.length; o++) {
                  var w2 = y2[o].label;
                  p2[_][w2] || (g2(b2, _, { label: w2, color: y2[o].color, i: y2[o].i, trace: x, pts: y2[o].pts }), p2[_][w2] = true, v2 = Math.max(v2, (w2 || "").length));
                }
              else
                g2(b2, _, m2), v2 = Math.max(v2, (x.name || "").length);
          }
          if (!f2.length)
            return [];
          var T = !h2 || !l2, k2 = [];
          for (a = 0; a < f2.length; a++) {
            var A2 = c2[f2[a]];
            T ? k2.push(A2[0]) : k2.push(A2);
          }
          for (T && (k2 = [k2]), a = 0; a < k2.length; a++) {
            var M = 1 / 0;
            for (o = 0; o < k2[a].length; o++) {
              var S = k2[a][o].trace.legendrank;
              M > S && (M = S);
            }
            k2[a][0]._groupMinRank = M, k2[a][0]._preGroupSort = a;
          }
          var E2 = function(t4, e5) {
            return t4.trace.legendrank - e5.trace.legendrank || t4._preSort - e5._preSort;
          };
          for (k2.forEach(function(t4, e5) {
            t4[0]._preGroupSort = e5;
          }), k2.sort(function(t4, e5) {
            return t4[0]._groupMinRank - e5[0]._groupMinRank || t4[0]._preGroupSort - e5[0]._preGroupSort;
          }), a = 0; a < k2.length; a++) {
            k2[a].forEach(function(t4, e5) {
              t4._preSort = e5;
            }), k2[a].sort(E2);
            var L = k2[a][0].trace, C2 = null;
            for (o = 0; o < k2[a].length; o++) {
              var P = k2[a][o].trace.legendgrouptitle;
              if (P && P.text) {
                C2 = P, s && (P.font = e4._groupTitleFont);
                break;
              }
            }
            if (u2 && k2[a].reverse(), C2) {
              var O = false;
              for (o = 0; o < k2[a].length; o++)
                if (n2.traceIs(k2[a][o].trace, "pie-like")) {
                  O = true;
                  break;
                }
              k2[a].unshift({ i: -1, groupTitle: C2, noClick: O, trace: { showlegend: L.showlegend, legendgroup: L.legendgroup, visible: "toggleitem" === e4.groupclick || L.visible } });
            }
            for (o = 0; o < k2[a].length; o++)
              k2[a][o] = [k2[a][o]];
          }
          return e4._lgroupsLength = k2.length, e4._maxNameLength = v2, k2;
        };
      }, 33048: function(t2, e3, r3) {
        var n2 = r3(24040), i = r3(3400), a = i.pushUnique, o = true;
        t2.exports = function(t3, e4, r4) {
          var s = e4._fullLayout;
          if (!e4._dragged && !e4._editing) {
            var l2, u2 = s.legend.itemclick, c2 = s.legend.itemdoubleclick, f2 = s.legend.groupclick;
            if (1 === r4 && "toggle" === u2 && "toggleothers" === c2 && o && e4.data && e4._context.showTips ? (i.notifier(i._(e4, "Double-click on legend to isolate one trace"), "long"), o = false) : o = false, 1 === r4 ? l2 = u2 : 2 === r4 && (l2 = c2), l2) {
              var h2 = "togglegroup" === f2, p2 = s.hiddenlabels ? s.hiddenlabels.slice() : [], d2 = t3.data()[0][0];
              if (!d2.groupTitle || !d2.noClick) {
                var v2 = e4._fullData, g2 = (s.shapes || []).filter(function(t4) {
                  return t4.showlegend;
                }), y2 = v2.concat(g2), m2 = d2.trace;
                m2._isShape && (m2 = m2._fullInput);
                var x, b2, _, w2, T, k2 = m2.legendgroup, A2 = {}, M = [], S = [], E2 = [], L = (s.shapes || []).map(function(t4) {
                  return t4._input;
                }), C2 = false, P = m2.legend, O = m2._fullInput;
                if (O && O._isShape || !n2.traceIs(m2, "pie-like")) {
                  var I2, D2 = k2 && k2.length, z2 = [];
                  if (D2)
                    for (x = 0; x < y2.length; x++)
                      (I2 = y2[x]).visible && I2.legendgroup === k2 && z2.push(x);
                  if ("toggle" === l2) {
                    var R;
                    switch (m2.visible) {
                      case true:
                        R = "legendonly";
                        break;
                      case false:
                        R = false;
                        break;
                      case "legendonly":
                        R = true;
                    }
                    if (D2)
                      if (h2)
                        for (x = 0; x < y2.length; x++) {
                          var F2 = y2[x];
                          false !== F2.visible && F2.legendgroup === k2 && tt2(F2, R);
                        }
                      else
                        tt2(m2, R);
                    else
                      tt2(m2, R);
                  } else if ("toggleothers" === l2) {
                    var B2, N, j, U, V = true;
                    for (x = 0; x < y2.length; x++)
                      if (B2 = (U = y2[x]) === m2, N = true !== U.showlegend, !(B2 || N || D2 && U.legendgroup === k2 || U.legend !== P || true !== U.visible || n2.traceIs(U, "notLegendIsolatable"))) {
                        V = false;
                        break;
                      }
                    for (x = 0; x < y2.length; x++)
                      if (false !== (U = y2[x]).visible && U.legend === P && !n2.traceIs(U, "notLegendIsolatable"))
                        switch (m2.visible) {
                          case "legendonly":
                            tt2(U, true);
                            break;
                          case true:
                            j = !!V || "legendonly", B2 = U === m2, N = true !== U.showlegend && !U.legendgroup, tt2(U, !!(B2 || D2 && U.legendgroup === k2 || N) || j);
                        }
                  }
                  for (x = 0; x < S.length; x++)
                    if (_ = S[x]) {
                      var q2 = _.constructUpdate(), H2 = Object.keys(q2);
                      for (b2 = 0; b2 < H2.length; b2++)
                        w2 = H2[b2], (A2[w2] = A2[w2] || [])[E2[x]] = q2[w2];
                    }
                  for (T = Object.keys(A2), x = 0; x < T.length; x++)
                    for (w2 = T[x], b2 = 0; b2 < M.length; b2++)
                      A2[w2].hasOwnProperty(b2) || (A2[w2][b2] = void 0);
                  C2 ? n2.call("_guiUpdate", e4, A2, { shapes: L }, M) : n2.call("_guiRestyle", e4, A2, M);
                } else {
                  var G2 = d2.label, W = p2.indexOf(G2);
                  if ("toggle" === l2)
                    -1 === W ? p2.push(G2) : p2.splice(W, 1);
                  else if ("toggleothers" === l2) {
                    var Y = -1 !== W, X = [];
                    for (x = 0; x < e4.calcdata.length; x++) {
                      var Z = e4.calcdata[x];
                      for (b2 = 0; b2 < Z.length; b2++) {
                        var K = Z[b2].label;
                        P === Z[0].trace.legend && G2 !== K && (-1 === p2.indexOf(K) && (Y = true), a(p2, K), X.push(K));
                      }
                    }
                    if (!Y)
                      for (var J = 0; J < X.length; J++) {
                        var $ = p2.indexOf(X[J]);
                        -1 !== $ && p2.splice($, 1);
                      }
                  }
                  n2.call("_guiRelayout", e4, "hiddenlabels", p2);
                }
              }
            }
          }
          function Q(t4, e5) {
            var r5 = M.indexOf(t4), n3 = A2.visible;
            return n3 || (n3 = A2.visible = []), -1 === M.indexOf(t4) && (M.push(t4), r5 = M.length - 1), n3[r5] = e5, r5;
          }
          function tt2(t4, e5) {
            if (!d2.groupTitle || h2) {
              var r5, a2 = t4._fullInput || t4, o2 = a2._isShape, s2 = a2.index;
              if (void 0 === s2 && (s2 = a2._index), n2.hasTransform(a2, "groupby")) {
                var l3 = S[s2];
                if (!l3) {
                  var u3 = n2.getTransformIndices(a2, "groupby"), c3 = u3[u3.length - 1];
                  l3 = i.keyedContainer(a2, "transforms[" + c3 + "].styles", "target", "value.visible"), S[s2] = l3;
                }
                var f3 = l3.get(t4._group);
                void 0 === f3 && (f3 = true), false !== f3 && l3.set(t4._group, e5), E2[s2] = Q(s2, false !== a2.visible);
              } else {
                var p3 = false !== a2.visible && e5;
                o2 ? (r5 = p3, L[s2].visible = r5, C2 = true) : Q(s2, p3);
              }
            }
          }
        };
      }, 42451: function(t2, e3) {
        e3.isGrouped = function(t3) {
          return -1 !== (t3.traceorder || "").indexOf("grouped");
        }, e3.isVertical = function(t3) {
          return "h" !== t3.orientation;
        }, e3.isReversed = function(t3) {
          return -1 !== (t3.traceorder || "").indexOf("reversed");
        };
      }, 2780: function(t2, e3, r3) {
        t2.exports = { moduleType: "component", name: "legend", layoutAttributes: r3(3800), supplyLayoutDefaults: r3(77864), draw: r3(31140), style: r3(2012) };
      }, 2012: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(24040), a = r3(3400), o = a.strTranslate, s = r3(43616), l2 = r3(76308), u2 = r3(94288).extractOpts, c2 = r3(43028), f2 = r3(10528), h2 = r3(69656).castOption, p2 = r3(65196);
        function d2(t3, e4) {
          return (e4 ? "radial" : "horizontal") + (t3 ? "" : "reversed");
        }
        function v2(t3) {
          var e4 = t3[0].trace, r4 = e4.contours, n3 = c2.hasLines(e4), i2 = c2.hasMarkers(e4), a2 = e4.visible && e4.fill && "none" !== e4.fill, o2 = false, s2 = false;
          if (r4) {
            var l3 = r4.coloring;
            "lines" === l3 ? o2 = true : n3 = "none" === l3 || "heatmap" === l3 || r4.showlines, "constraint" === r4.type ? a2 = "=" !== r4._operation : "fill" !== l3 && "heatmap" !== l3 || (s2 = true);
          }
          return { showMarker: i2, showLine: n3, showFill: a2, showGradientLine: o2, showGradientFill: s2, anyLine: n3 || o2, anyFill: a2 || s2 };
        }
        function g2(t3, e4, r4) {
          return t3 && a.isArrayOrTypedArray(t3) ? e4 : t3 > r4 ? r4 : t3;
        }
        t2.exports = function(t3, e4, r4) {
          var y2 = e4._fullLayout;
          r4 || (r4 = y2.legend);
          var m2 = "constant" === r4.itemsizing, x = r4.itemwidth, b2 = (x + 2 * p2.itemGap) / 2, _ = o(b2, 0), w2 = function(t4, e5, r5, n3) {
            var i2;
            if (t4 + 1)
              i2 = t4;
            else {
              if (!(e5 && e5.width > 0))
                return 0;
              i2 = e5.width;
            }
            return m2 ? n3 : Math.min(i2, r5);
          };
          function T(t4, a2, o2) {
            var c3 = t4[0].trace, f3 = c3.marker || {}, h3 = f3.line || {}, p3 = f3.cornerradius ? "M6,3a3,3,0,0,1-3,3H-3a3,3,0,0,1-3-3V-3a3,3,0,0,1,3-3H3a3,3,0,0,1,3,3Z" : "M6,6H-6V-6H6Z", d3 = o2 ? c3.visible && c3.type === o2 : i.traceIs(c3, "bar"), v3 = n2.select(a2).select("g.legendpoints").selectAll("path.legend" + o2).data(d3 ? [t4] : []);
            v3.enter().append("path").classed("legend" + o2, true).attr("d", p3).attr("transform", _), v3.exit().remove(), v3.each(function(t5) {
              var i2 = n2.select(this), a3 = t5[0], o3 = w2(a3.mlw, f3.line, 5, 2);
              i2.style("stroke-width", o3 + "px");
              var p4 = a3.mcc;
              if (!r4._inHover && "mc" in a3) {
                var d4 = u2(f3), v4 = d4.mid;
                void 0 === v4 && (v4 = (d4.max + d4.min) / 2), p4 = s.tryColorscale(f3, "")(v4);
              }
              var y3 = p4 || a3.mc || f3.color, m3 = f3.pattern, x2 = m3 && s.getPatternAttr(m3.shape, 0, "");
              if (x2) {
                var b3 = s.getPatternAttr(m3.bgcolor, 0, null), _2 = s.getPatternAttr(m3.fgcolor, 0, null), T2 = m3.fgopacity, k3 = g2(m3.size, 8, 10), A2 = g2(m3.solidity, 0.5, 1), M = "legend-" + c3.uid;
                i2.call(s.pattern, "legend", e4, M, x2, k3, A2, p4, m3.fillmode, b3, _2, T2);
              } else
                i2.call(l2.fill, y3);
              o3 && l2.stroke(i2, a3.mlc || h3.color);
            });
          }
          function k2(t4, r5, o2) {
            var s2 = t4[0], l3 = s2.trace, u3 = o2 ? l3.visible && l3.type === o2 : i.traceIs(l3, o2), c3 = n2.select(r5).select("g.legendpoints").selectAll("path.legend" + o2).data(u3 ? [t4] : []);
            if (c3.enter().append("path").classed("legend" + o2, true).attr("d", "M6,6H-6V-6H6Z").attr("transform", _), c3.exit().remove(), c3.size()) {
              var p3 = l3.marker || {}, d3 = w2(h2(p3.line.width, s2.pts), p3.line, 5, 2), v3 = "pieLike", g3 = a.minExtend(l3, { marker: { line: { width: d3 } } }, v3), y3 = a.minExtend(s2, { trace: g3 }, v3);
              f2(c3, y3, g3, e4);
            }
          }
          t3.each(function(t4) {
            var e5 = n2.select(this), i2 = a.ensureSingle(e5, "g", "layers");
            i2.style("opacity", t4[0].trace.opacity);
            var s2 = r4.valign, l3 = t4[0].lineHeight, u3 = t4[0].height;
            if ("middle" !== s2 && l3 && u3) {
              var c3 = { top: 1, bottom: -1 }[s2] * (0.5 * (l3 - u3 + 3));
              i2.attr("transform", o(0, c3));
            } else
              i2.attr("transform", null);
            i2.selectAll("g.legendfill").data([t4]).enter().append("g").classed("legendfill", true), i2.selectAll("g.legendlines").data([t4]).enter().append("g").classed("legendlines", true);
            var f3 = i2.selectAll("g.legendsymbols").data([t4]);
            f3.enter().append("g").classed("legendsymbols", true), f3.selectAll("g.legendpoints").data([t4]).enter().append("g").classed("legendpoints", true);
          }).each(function(t4) {
            var r5, i2 = t4[0].trace, o2 = [];
            if (i2.visible)
              switch (i2.type) {
                case "histogram2d":
                case "heatmap":
                  o2 = [["M-15,-2V4H15V-2Z"]], r5 = true;
                  break;
                case "choropleth":
                case "choroplethmapbox":
                  o2 = [["M-6,-6V6H6V-6Z"]], r5 = true;
                  break;
                case "densitymapbox":
                  o2 = [["M-6,0 a6,6 0 1,0 12,0 a 6,6 0 1,0 -12,0"]], r5 = "radial";
                  break;
                case "cone":
                  o2 = [["M-6,2 A2,2 0 0,0 -6,6 V6L6,4Z"], ["M-6,-6 A2,2 0 0,0 -6,-2 L6,-4Z"], ["M-6,-2 A2,2 0 0,0 -6,2 L6,0Z"]], r5 = false;
                  break;
                case "streamtube":
                  o2 = [["M-6,2 A2,2 0 0,0 -6,6 H6 A2,2 0 0,1 6,2 Z"], ["M-6,-6 A2,2 0 0,0 -6,-2 H6 A2,2 0 0,1 6,-6 Z"], ["M-6,-2 A2,2 0 0,0 -6,2 H6 A2,2 0 0,1 6,-2 Z"]], r5 = false;
                  break;
                case "surface":
                  o2 = [["M-6,-6 A2,3 0 0,0 -6,0 H6 A2,3 0 0,1 6,-6 Z"], ["M-6,1 A2,3 0 0,1 -6,6 H6 A2,3 0 0,0 6,0 Z"]], r5 = true;
                  break;
                case "mesh3d":
                  o2 = [["M-6,6H0L-6,-6Z"], ["M6,6H0L6,-6Z"], ["M-6,-6H6L0,6Z"]], r5 = false;
                  break;
                case "volume":
                  o2 = [["M-6,6H0L-6,-6Z"], ["M6,6H0L6,-6Z"], ["M-6,-6H6L0,6Z"]], r5 = true;
                  break;
                case "isosurface":
                  o2 = [["M-6,6H0L-6,-6Z"], ["M6,6H0L6,-6Z"], ["M-6,-6 A12,24 0 0,0 6,-6 L0,6Z"]], r5 = false;
              }
            var c3 = n2.select(this).select("g.legendpoints").selectAll("path.legend3dandfriends").data(o2);
            c3.enter().append("path").classed("legend3dandfriends", true).attr("transform", _).style("stroke-miterlimit", 1), c3.exit().remove(), c3.each(function(t5, o3) {
              var c4, f3 = n2.select(this), h3 = u2(i2), p3 = h3.colorscale, v3 = h3.reversescale;
              if (p3) {
                if (!r5) {
                  var g3 = p3.length;
                  c4 = 0 === o3 ? p3[v3 ? g3 - 1 : 0][1] : 1 === o3 ? p3[v3 ? 0 : g3 - 1][1] : p3[Math.floor((g3 - 1) / 2)][1];
                }
              } else {
                var y3 = i2.vertexcolor || i2.facecolor || i2.color;
                c4 = a.isArrayOrTypedArray(y3) ? y3[o3] || y3[0] : y3;
              }
              f3.attr("d", t5[0]), c4 ? f3.call(l2.fill, c4) : f3.call(function(t6) {
                if (t6.size()) {
                  var n3 = "legendfill-" + i2.uid;
                  s.gradient(t6, e4, n3, d2(v3, "radial" === r5), p3, "fill");
                }
              });
            });
          }).each(function(t4) {
            var e5 = t4[0].trace, r5 = "waterfall" === e5.type;
            if (t4[0]._distinct && r5) {
              var i2 = t4[0].trace[t4[0].dir].marker;
              return t4[0].mc = i2.color, t4[0].mlw = i2.line.width, t4[0].mlc = i2.line.color, T(t4, this, "waterfall");
            }
            var a2 = [];
            e5.visible && r5 && (a2 = t4[0].hasTotals ? [["increasing", "M-6,-6V6H0Z"], ["totals", "M6,6H0L-6,-6H-0Z"], ["decreasing", "M6,6V-6H0Z"]] : [["increasing", "M-6,-6V6H6Z"], ["decreasing", "M6,6V-6H-6Z"]]);
            var o2 = n2.select(this).select("g.legendpoints").selectAll("path.legendwaterfall").data(a2);
            o2.enter().append("path").classed("legendwaterfall", true).attr("transform", _).style("stroke-miterlimit", 1), o2.exit().remove(), o2.each(function(t5) {
              var r6 = n2.select(this), i3 = e5[t5[0]].marker, a3 = w2(void 0, i3.line, 5, 2);
              r6.attr("d", t5[1]).style("stroke-width", a3 + "px").call(l2.fill, i3.color), a3 && r6.call(l2.stroke, i3.line.color);
            });
          }).each(function(t4) {
            T(t4, this, "funnel");
          }).each(function(t4) {
            T(t4, this);
          }).each(function(t4) {
            var r5 = t4[0].trace, o2 = n2.select(this).select("g.legendpoints").selectAll("path.legendbox").data(r5.visible && i.traceIs(r5, "box-violin") ? [t4] : []);
            o2.enter().append("path").classed("legendbox", true).attr("d", "M6,6H-6V-6H6Z").attr("transform", _), o2.exit().remove(), o2.each(function() {
              var t5 = n2.select(this);
              if ("all" !== r5.boxpoints && "all" !== r5.points || 0 !== l2.opacity(r5.fillcolor) || 0 !== l2.opacity((r5.line || {}).color)) {
                var i2 = w2(void 0, r5.line, 5, 2);
                t5.style("stroke-width", i2 + "px").call(l2.fill, r5.fillcolor), i2 && l2.stroke(t5, r5.line.color);
              } else {
                var u3 = a.minExtend(r5, { marker: { size: m2 ? 12 : a.constrain(r5.marker.size, 2, 16), sizeref: 1, sizemin: 1, sizemode: "diameter" } });
                o2.call(s.pointStyle, u3, e4);
              }
            });
          }).each(function(t4) {
            k2(t4, this, "funnelarea");
          }).each(function(t4) {
            k2(t4, this, "pie");
          }).each(function(t4) {
            var r5, i2, o2 = v2(t4), l3 = o2.showFill, f3 = o2.showLine, h3 = o2.showGradientLine, p3 = o2.showGradientFill, g3 = o2.anyFill, y3 = o2.anyLine, m3 = t4[0], b3 = m3.trace, _2 = u2(b3), T2 = _2.colorscale, k3 = _2.reversescale, A2 = c2.hasMarkers(b3) || !g3 ? "M5,0" : y3 ? "M5,-2" : "M5,-3", M = n2.select(this), S = M.select(".legendfill").selectAll("path").data(l3 || p3 ? [t4] : []);
            if (S.enter().append("path").classed("js-fill", true), S.exit().remove(), S.attr("d", A2 + "h" + x + "v6h-" + x + "z").call(function(t5) {
              if (t5.size())
                if (l3)
                  s.fillGroupStyle(t5, e4);
                else {
                  var r6 = "legendfill-" + b3.uid;
                  s.gradient(t5, e4, r6, d2(k3), T2, "fill");
                }
            }), f3 || h3) {
              var E2 = w2(void 0, b3.line, 10, 5);
              i2 = a.minExtend(b3, { line: { width: E2 } }), r5 = [a.minExtend(m3, { trace: i2 })];
            }
            var L = M.select(".legendlines").selectAll("path").data(f3 || h3 ? [r5] : []);
            L.enter().append("path").classed("js-line", true), L.exit().remove(), L.attr("d", A2 + (h3 ? "l" + x + ",0.0001" : "h" + x)).call(f3 ? s.lineGroupStyle : function(t5) {
              if (t5.size()) {
                var r6 = "legendline-" + b3.uid;
                s.lineGroupStyle(t5), s.gradient(t5, e4, r6, d2(k3), T2, "stroke");
              }
            });
          }).each(function(t4) {
            var r5, i2, o2 = v2(t4), l3 = o2.anyFill, u3 = o2.anyLine, f3 = o2.showLine, h3 = o2.showMarker, p3 = t4[0], d3 = p3.trace, g3 = !h3 && !u3 && !l3 && c2.hasText(d3);
            function y3(t5, e5, r6, n3) {
              var i3 = a.nestedProperty(d3, t5).get(), o3 = a.isArrayOrTypedArray(i3) && e5 ? e5(i3) : i3;
              if (m2 && o3 && void 0 !== n3 && (o3 = n3), r6) {
                if (o3 < r6[0])
                  return r6[0];
                if (o3 > r6[1])
                  return r6[1];
              }
              return o3;
            }
            function x2(t5) {
              return p3._distinct && p3.index && t5[p3.index] ? t5[p3.index] : t5[0];
            }
            if (h3 || g3 || f3) {
              var b3 = {}, w3 = {};
              if (h3) {
                b3.mc = y3("marker.color", x2), b3.mx = y3("marker.symbol", x2), b3.mo = y3("marker.opacity", a.mean, [0.2, 1]), b3.mlc = y3("marker.line.color", x2), b3.mlw = y3("marker.line.width", a.mean, [0, 5], 2), w3.marker = { sizeref: 1, sizemin: 1, sizemode: "diameter" };
                var T2 = y3("marker.size", a.mean, [2, 16], 12);
                b3.ms = T2, w3.marker.size = T2;
              }
              f3 && (w3.line = { width: y3("line.width", x2, [0, 10], 5) }), g3 && (b3.tx = "Aa", b3.tp = y3("textposition", x2), b3.ts = 10, b3.tc = y3("textfont.color", x2), b3.tf = y3("textfont.family", x2)), r5 = [a.minExtend(p3, b3)], (i2 = a.minExtend(d3, w3)).selectedpoints = null, i2.texttemplate = null;
            }
            var k3 = n2.select(this).select("g.legendpoints"), A2 = k3.selectAll("path.scatterpts").data(h3 ? r5 : []);
            A2.enter().insert("path", ":first-child").classed("scatterpts", true).attr("transform", _), A2.exit().remove(), A2.call(s.pointStyle, i2, e4), h3 && (r5[0].mrc = 3);
            var M = k3.selectAll("g.pointtext").data(g3 ? r5 : []);
            M.enter().append("g").classed("pointtext", true).append("text").attr("transform", _), M.exit().remove(), M.selectAll("text").call(s.textPointStyle, i2, e4);
          }).each(function(t4) {
            var e5 = t4[0].trace, r5 = n2.select(this).select("g.legendpoints").selectAll("path.legendcandle").data(e5.visible && "candlestick" === e5.type ? [t4, t4] : []);
            r5.enter().append("path").classed("legendcandle", true).attr("d", function(t5, e6) {
              return e6 ? "M-15,0H-8M-8,6V-6H8Z" : "M15,0H8M8,-6V6H-8Z";
            }).attr("transform", _).style("stroke-miterlimit", 1), r5.exit().remove(), r5.each(function(t5, r6) {
              var i2 = n2.select(this), a2 = e5[r6 ? "increasing" : "decreasing"], o2 = w2(void 0, a2.line, 5, 2);
              i2.style("stroke-width", o2 + "px").call(l2.fill, a2.fillcolor), o2 && l2.stroke(i2, a2.line.color);
            });
          }).each(function(t4) {
            var e5 = t4[0].trace, r5 = n2.select(this).select("g.legendpoints").selectAll("path.legendohlc").data(e5.visible && "ohlc" === e5.type ? [t4, t4] : []);
            r5.enter().append("path").classed("legendohlc", true).attr("d", function(t5, e6) {
              return e6 ? "M-15,0H0M-8,-6V0" : "M15,0H0M8,6V0";
            }).attr("transform", _).style("stroke-miterlimit", 1), r5.exit().remove(), r5.each(function(t5, r6) {
              var i2 = n2.select(this), a2 = e5[r6 ? "increasing" : "decreasing"], o2 = w2(void 0, a2.line, 5, 2);
              i2.style("fill", "none").call(s.dashLine, a2.line.dash, o2), o2 && l2.stroke(i2, a2.line.color);
            });
          });
        };
      }, 66540: function(t2, e3, r3) {
        r3(76052), t2.exports = { editType: "modebar", orientation: { valType: "enumerated", values: ["v", "h"], dflt: "h", editType: "modebar" }, bgcolor: { valType: "color", editType: "modebar" }, color: { valType: "color", editType: "modebar" }, activecolor: { valType: "color", editType: "modebar" }, uirevision: { valType: "any", editType: "none" }, add: { valType: "string", arrayOk: true, dflt: "", editType: "modebar" }, remove: { valType: "string", arrayOk: true, dflt: "", editType: "modebar" } };
      }, 44248: function(t2, e3, r3) {
        var n2 = r3(24040), i = r3(7316), a = r3(79811), o = r3(9224), s = r3(4016).eraseActiveShape, l2 = r3(3400), u2 = l2._, c2 = t2.exports = {};
        function f2(t3, e4) {
          var r4, i2, o2 = e4.currentTarget, s2 = o2.getAttribute("data-attr"), l3 = o2.getAttribute("data-val") || true, u3 = t3._fullLayout, c3 = {}, f3 = a.list(t3, null, true), h3 = u3._cartesianSpikesEnabled;
          if ("zoom" === s2) {
            var p3, d3 = "in" === l3 ? 0.5 : 2, v3 = (1 + d3) / 2, g3 = (1 - d3) / 2;
            for (i2 = 0; i2 < f3.length; i2++)
              if (!(r4 = f3[i2]).fixedrange)
                if (p3 = r4._name, "auto" === l3)
                  c3[p3 + ".autorange"] = true;
                else if ("reset" === l3)
                  void 0 === r4._rangeInitial0 && void 0 === r4._rangeInitial1 ? c3[p3 + ".autorange"] = true : void 0 === r4._rangeInitial0 ? (c3[p3 + ".autorange"] = r4._autorangeInitial, c3[p3 + ".range"] = [null, r4._rangeInitial1]) : void 0 === r4._rangeInitial1 ? (c3[p3 + ".range"] = [r4._rangeInitial0, null], c3[p3 + ".autorange"] = r4._autorangeInitial) : c3[p3 + ".range"] = [r4._rangeInitial0, r4._rangeInitial1], void 0 !== r4._showSpikeInitial && (c3[p3 + ".showspikes"] = r4._showSpikeInitial, "on" !== h3 || r4._showSpikeInitial || (h3 = "off"));
                else {
                  var y3 = [r4.r2l(r4.range[0]), r4.r2l(r4.range[1])], m3 = [v3 * y3[0] + g3 * y3[1], v3 * y3[1] + g3 * y3[0]];
                  c3[p3 + ".range[0]"] = r4.l2r(m3[0]), c3[p3 + ".range[1]"] = r4.l2r(m3[1]);
                }
          } else
            "hovermode" !== s2 || "x" !== l3 && "y" !== l3 || (l3 = u3._isHoriz ? "y" : "x", o2.setAttribute("data-val", l3)), c3[s2] = l3;
          u3._cartesianSpikesEnabled = h3, n2.call("_guiRelayout", t3, c3);
        }
        function h2(t3, e4) {
          for (var r4 = e4.currentTarget, i2 = r4.getAttribute("data-attr"), a2 = r4.getAttribute("data-val") || true, o2 = t3._fullLayout._subplots.gl3d || [], s2 = {}, l3 = i2.split("."), u3 = 0; u3 < o2.length; u3++)
            s2[o2[u3] + "." + l3[1]] = a2;
          var c3 = "pan" === a2 ? a2 : "zoom";
          s2.dragmode = c3, n2.call("_guiRelayout", t3, s2);
        }
        function p2(t3, e4) {
          for (var r4 = e4.currentTarget.getAttribute("data-attr"), i2 = "resetLastSave" === r4, a2 = "resetDefault" === r4, o2 = t3._fullLayout, s2 = o2._subplots.gl3d || [], l3 = {}, u3 = 0; u3 < s2.length; u3++) {
            var c3, f3 = s2[u3], h3 = f3 + ".camera", p3 = f3 + ".aspectratio", d3 = f3 + ".aspectmode", v3 = o2[f3]._scene;
            i2 ? (l3[h3 + ".up"] = v3.viewInitial.up, l3[h3 + ".eye"] = v3.viewInitial.eye, l3[h3 + ".center"] = v3.viewInitial.center, c3 = true) : a2 && (l3[h3 + ".up"] = null, l3[h3 + ".eye"] = null, l3[h3 + ".center"] = null, c3 = true), c3 && (l3[p3 + ".x"] = v3.viewInitial.aspectratio.x, l3[p3 + ".y"] = v3.viewInitial.aspectratio.y, l3[p3 + ".z"] = v3.viewInitial.aspectratio.z, l3[d3] = v3.viewInitial.aspectmode);
          }
          n2.call("_guiRelayout", t3, l3);
        }
        function d2(t3, e4) {
          var r4 = e4.currentTarget, n3 = r4._previousVal, i2 = t3._fullLayout, a2 = i2._subplots.gl3d || [], o2 = ["xaxis", "yaxis", "zaxis"], s2 = {}, l3 = {};
          if (n3)
            l3 = n3, r4._previousVal = null;
          else {
            for (var u3 = 0; u3 < a2.length; u3++) {
              var c3 = a2[u3], f3 = i2[c3], h3 = c3 + ".hovermode";
              s2[h3] = f3.hovermode, l3[h3] = false;
              for (var p3 = 0; p3 < 3; p3++) {
                var d3 = o2[p3], v3 = c3 + "." + d3 + ".showspikes";
                l3[v3] = false, s2[v3] = f3[d3].showspikes;
              }
            }
            r4._previousVal = s2;
          }
          return l3;
        }
        function v2(t3, e4) {
          for (var r4 = e4.currentTarget, i2 = r4.getAttribute("data-attr"), a2 = r4.getAttribute("data-val") || true, o2 = t3._fullLayout, s2 = o2._subplots.geo || [], l3 = 0; l3 < s2.length; l3++) {
            var u3 = s2[l3], c3 = o2[u3];
            if ("zoom" === i2) {
              var f3 = c3.projection.scale, h3 = "in" === a2 ? 2 * f3 : 0.5 * f3;
              n2.call("_guiRelayout", t3, u3 + ".projection.scale", h3);
            }
          }
          "reset" === i2 && x(t3, "geo");
        }
        function g2(t3) {
          var e4 = t3._fullLayout;
          return !e4.hovermode && (e4._has("cartesian") ? e4._isHoriz ? "y" : "x" : "closest");
        }
        function y2(t3) {
          var e4 = g2(t3);
          n2.call("_guiRelayout", t3, "hovermode", e4);
        }
        function m2(t3, e4) {
          for (var r4 = e4.currentTarget.getAttribute("data-val"), i2 = t3._fullLayout, a2 = i2._subplots.mapbox || [], o2 = {}, s2 = 0; s2 < a2.length; s2++) {
            var l3 = a2[s2], u3 = i2[l3].zoom, c3 = "in" === r4 ? 1.05 * u3 : u3 / 1.05;
            o2[l3 + ".zoom"] = c3;
          }
          n2.call("_guiRelayout", t3, o2);
        }
        function x(t3, e4) {
          for (var r4 = t3._fullLayout, i2 = r4._subplots[e4] || [], a2 = {}, o2 = 0; o2 < i2.length; o2++)
            for (var s2 = i2[o2], l3 = r4[s2]._subplot.viewInitial, u3 = Object.keys(l3), c3 = 0; c3 < u3.length; c3++) {
              var f3 = u3[c3];
              a2[s2 + "." + f3] = l3[f3];
            }
          n2.call("_guiRelayout", t3, a2);
        }
        c2.toImage = { name: "toImage", title: function(t3) {
          var e4 = (t3._context.toImageButtonOptions || {}).format || "png";
          return u2(t3, "png" === e4 ? "Download plot as a png" : "Download plot");
        }, icon: o.camera, click: function(t3) {
          var e4 = t3._context.toImageButtonOptions, r4 = { format: e4.format || "png" };
          l2.notifier(u2(t3, "Taking snapshot - this may take a few seconds"), "long"), "svg" !== r4.format && l2.isIE() && (l2.notifier(u2(t3, "IE only supports svg.  Changing format to svg."), "long"), r4.format = "svg"), ["filename", "width", "height", "scale"].forEach(function(t4) {
            t4 in e4 && (r4[t4] = e4[t4]);
          }), n2.call("downloadImage", t3, r4).then(function(e5) {
            l2.notifier(u2(t3, "Snapshot succeeded") + " - " + e5, "long");
          }).catch(function() {
            l2.notifier(u2(t3, "Sorry, there was a problem downloading your snapshot!"), "long");
          });
        } }, c2.sendDataToCloud = { name: "sendDataToCloud", title: function(t3) {
          return u2(t3, "Edit in Chart Studio");
        }, icon: o.disk, click: function(t3) {
          i.sendDataToCloud(t3);
        } }, c2.editInChartStudio = { name: "editInChartStudio", title: function(t3) {
          return u2(t3, "Edit in Chart Studio");
        }, icon: o.pencil, click: function(t3) {
          i.sendDataToCloud(t3);
        } }, c2.zoom2d = { name: "zoom2d", _cat: "zoom", title: function(t3) {
          return u2(t3, "Zoom");
        }, attr: "dragmode", val: "zoom", icon: o.zoombox, click: f2 }, c2.pan2d = { name: "pan2d", _cat: "pan", title: function(t3) {
          return u2(t3, "Pan");
        }, attr: "dragmode", val: "pan", icon: o.pan, click: f2 }, c2.select2d = { name: "select2d", _cat: "select", title: function(t3) {
          return u2(t3, "Box Select");
        }, attr: "dragmode", val: "select", icon: o.selectbox, click: f2 }, c2.lasso2d = { name: "lasso2d", _cat: "lasso", title: function(t3) {
          return u2(t3, "Lasso Select");
        }, attr: "dragmode", val: "lasso", icon: o.lasso, click: f2 }, c2.drawclosedpath = { name: "drawclosedpath", title: function(t3) {
          return u2(t3, "Draw closed freeform");
        }, attr: "dragmode", val: "drawclosedpath", icon: o.drawclosedpath, click: f2 }, c2.drawopenpath = { name: "drawopenpath", title: function(t3) {
          return u2(t3, "Draw open freeform");
        }, attr: "dragmode", val: "drawopenpath", icon: o.drawopenpath, click: f2 }, c2.drawline = { name: "drawline", title: function(t3) {
          return u2(t3, "Draw line");
        }, attr: "dragmode", val: "drawline", icon: o.drawline, click: f2 }, c2.drawrect = { name: "drawrect", title: function(t3) {
          return u2(t3, "Draw rectangle");
        }, attr: "dragmode", val: "drawrect", icon: o.drawrect, click: f2 }, c2.drawcircle = { name: "drawcircle", title: function(t3) {
          return u2(t3, "Draw circle");
        }, attr: "dragmode", val: "drawcircle", icon: o.drawcircle, click: f2 }, c2.eraseshape = { name: "eraseshape", title: function(t3) {
          return u2(t3, "Erase active shape");
        }, icon: o.eraseshape, click: s }, c2.zoomIn2d = { name: "zoomIn2d", _cat: "zoomin", title: function(t3) {
          return u2(t3, "Zoom in");
        }, attr: "zoom", val: "in", icon: o.zoom_plus, click: f2 }, c2.zoomOut2d = { name: "zoomOut2d", _cat: "zoomout", title: function(t3) {
          return u2(t3, "Zoom out");
        }, attr: "zoom", val: "out", icon: o.zoom_minus, click: f2 }, c2.autoScale2d = { name: "autoScale2d", _cat: "autoscale", title: function(t3) {
          return u2(t3, "Autoscale");
        }, attr: "zoom", val: "auto", icon: o.autoscale, click: f2 }, c2.resetScale2d = { name: "resetScale2d", _cat: "resetscale", title: function(t3) {
          return u2(t3, "Reset axes");
        }, attr: "zoom", val: "reset", icon: o.home, click: f2 }, c2.hoverClosestCartesian = { name: "hoverClosestCartesian", _cat: "hoverclosest", title: function(t3) {
          return u2(t3, "Show closest data on hover");
        }, attr: "hovermode", val: "closest", icon: o.tooltip_basic, gravity: "ne", click: f2 }, c2.hoverCompareCartesian = { name: "hoverCompareCartesian", _cat: "hoverCompare", title: function(t3) {
          return u2(t3, "Compare data on hover");
        }, attr: "hovermode", val: function(t3) {
          return t3._fullLayout._isHoriz ? "y" : "x";
        }, icon: o.tooltip_compare, gravity: "ne", click: f2 }, c2.zoom3d = { name: "zoom3d", _cat: "zoom", title: function(t3) {
          return u2(t3, "Zoom");
        }, attr: "scene.dragmode", val: "zoom", icon: o.zoombox, click: h2 }, c2.pan3d = { name: "pan3d", _cat: "pan", title: function(t3) {
          return u2(t3, "Pan");
        }, attr: "scene.dragmode", val: "pan", icon: o.pan, click: h2 }, c2.orbitRotation = { name: "orbitRotation", title: function(t3) {
          return u2(t3, "Orbital rotation");
        }, attr: "scene.dragmode", val: "orbit", icon: o["3d_rotate"], click: h2 }, c2.tableRotation = { name: "tableRotation", title: function(t3) {
          return u2(t3, "Turntable rotation");
        }, attr: "scene.dragmode", val: "turntable", icon: o["z-axis"], click: h2 }, c2.resetCameraDefault3d = { name: "resetCameraDefault3d", _cat: "resetCameraDefault", title: function(t3) {
          return u2(t3, "Reset camera to default");
        }, attr: "resetDefault", icon: o.home, click: p2 }, c2.resetCameraLastSave3d = { name: "resetCameraLastSave3d", _cat: "resetCameraLastSave", title: function(t3) {
          return u2(t3, "Reset camera to last save");
        }, attr: "resetLastSave", icon: o.movie, click: p2 }, c2.hoverClosest3d = { name: "hoverClosest3d", _cat: "hoverclosest", title: function(t3) {
          return u2(t3, "Toggle show closest data on hover");
        }, attr: "hovermode", val: null, toggle: true, icon: o.tooltip_basic, gravity: "ne", click: function(t3, e4) {
          var r4 = d2(t3, e4);
          n2.call("_guiRelayout", t3, r4);
        } }, c2.zoomInGeo = { name: "zoomInGeo", _cat: "zoomin", title: function(t3) {
          return u2(t3, "Zoom in");
        }, attr: "zoom", val: "in", icon: o.zoom_plus, click: v2 }, c2.zoomOutGeo = { name: "zoomOutGeo", _cat: "zoomout", title: function(t3) {
          return u2(t3, "Zoom out");
        }, attr: "zoom", val: "out", icon: o.zoom_minus, click: v2 }, c2.resetGeo = { name: "resetGeo", _cat: "reset", title: function(t3) {
          return u2(t3, "Reset");
        }, attr: "reset", val: null, icon: o.autoscale, click: v2 }, c2.hoverClosestGeo = { name: "hoverClosestGeo", _cat: "hoverclosest", title: function(t3) {
          return u2(t3, "Toggle show closest data on hover");
        }, attr: "hovermode", val: null, toggle: true, icon: o.tooltip_basic, gravity: "ne", click: y2 }, c2.hoverClosestGl2d = { name: "hoverClosestGl2d", _cat: "hoverclosest", title: function(t3) {
          return u2(t3, "Toggle show closest data on hover");
        }, attr: "hovermode", val: null, toggle: true, icon: o.tooltip_basic, gravity: "ne", click: y2 }, c2.hoverClosestPie = { name: "hoverClosestPie", _cat: "hoverclosest", title: function(t3) {
          return u2(t3, "Toggle show closest data on hover");
        }, attr: "hovermode", val: "closest", icon: o.tooltip_basic, gravity: "ne", click: y2 }, c2.resetViewSankey = { name: "resetSankeyGroup", title: function(t3) {
          return u2(t3, "Reset view");
        }, icon: o.home, click: function(t3) {
          for (var e4 = { "node.groups": [], "node.x": [], "node.y": [] }, r4 = 0; r4 < t3._fullData.length; r4++) {
            var i2 = t3._fullData[r4]._viewInitial;
            e4["node.groups"].push(i2.node.groups.slice()), e4["node.x"].push(i2.node.x.slice()), e4["node.y"].push(i2.node.y.slice());
          }
          n2.call("restyle", t3, e4);
        } }, c2.toggleHover = { name: "toggleHover", title: function(t3) {
          return u2(t3, "Toggle show closest data on hover");
        }, attr: "hovermode", val: null, toggle: true, icon: o.tooltip_basic, gravity: "ne", click: function(t3, e4) {
          var r4 = d2(t3, e4);
          r4.hovermode = g2(t3), n2.call("_guiRelayout", t3, r4);
        } }, c2.resetViews = { name: "resetViews", title: function(t3) {
          return u2(t3, "Reset views");
        }, icon: o.home, click: function(t3, e4) {
          var r4 = e4.currentTarget;
          r4.setAttribute("data-attr", "zoom"), r4.setAttribute("data-val", "reset"), f2(t3, e4), r4.setAttribute("data-attr", "resetLastSave"), p2(t3, e4), x(t3, "geo"), x(t3, "mapbox");
        } }, c2.toggleSpikelines = { name: "toggleSpikelines", title: function(t3) {
          return u2(t3, "Toggle Spike Lines");
        }, icon: o.spikeline, attr: "_cartesianSpikesEnabled", val: "on", click: function(t3) {
          var e4 = t3._fullLayout, r4 = e4._cartesianSpikesEnabled;
          e4._cartesianSpikesEnabled = "on" === r4 ? "off" : "on", n2.call("_guiRelayout", t3, function(t4) {
            for (var e5 = "on" === t4._fullLayout._cartesianSpikesEnabled, r5 = a.list(t4, null, true), n3 = {}, i2 = 0; i2 < r5.length; i2++) {
              var o2 = r5[i2];
              n3[o2._name + ".showspikes"] = !!e5 || o2._showSpikeInitial;
            }
            return n3;
          }(t3));
        } }, c2.resetViewMapbox = { name: "resetViewMapbox", _cat: "resetView", title: function(t3) {
          return u2(t3, "Reset view");
        }, attr: "reset", icon: o.home, click: function(t3) {
          x(t3, "mapbox");
        } }, c2.zoomInMapbox = { name: "zoomInMapbox", _cat: "zoomin", title: function(t3) {
          return u2(t3, "Zoom in");
        }, attr: "zoom", val: "in", icon: o.zoom_plus, click: m2 }, c2.zoomOutMapbox = { name: "zoomOutMapbox", _cat: "zoomout", title: function(t3) {
          return u2(t3, "Zoom out");
        }, attr: "zoom", val: "out", icon: o.zoom_minus, click: m2 };
      }, 76052: function(t2, e3, r3) {
        var n2 = r3(44248), i = Object.keys(n2), a = ["drawline", "drawopenpath", "drawclosedpath", "drawcircle", "drawrect", "eraseshape"], o = ["v1hovermode", "hoverclosest", "hovercompare", "togglehover", "togglespikelines"].concat(a), s = [];
        i.forEach(function(t3) {
          !function(t4) {
            if (-1 === o.indexOf(t4._cat || t4.name)) {
              var e4 = t4.name, r4 = (t4._cat || t4.name).toLowerCase();
              -1 === s.indexOf(e4) && s.push(e4), -1 === s.indexOf(r4) && s.push(r4);
            }
          }(n2[t3]);
        }), s.sort(), t2.exports = { DRAW_MODES: a, backButtons: o, foreButtons: s };
      }, 90824: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(76308), a = r3(31780), o = r3(66540);
        t2.exports = function(t3, e4) {
          var r4 = t3.modebar || {}, s = a.newContainer(e4, "modebar");
          function l2(t4, e5) {
            return n2.coerce(r4, s, o, t4, e5);
          }
          l2("orientation"), l2("bgcolor", i.addOpacity(e4.paper_bgcolor, 0.5));
          var u2 = i.contrast(i.rgb(e4.modebar.bgcolor));
          l2("color", i.addOpacity(u2, 0.3)), l2("activecolor", i.addOpacity(u2, 0.7)), l2("uirevision", e4.uirevision), l2("add"), l2("remove");
        };
      }, 45460: function(t2, e3, r3) {
        t2.exports = { moduleType: "component", name: "modebar", layoutAttributes: r3(66540), supplyLayoutDefaults: r3(90824), manage: r3(18816) };
      }, 18816: function(t2, e3, r3) {
        var n2 = r3(79811), i = r3(43028), a = r3(24040), o = r3(10624).isUnifiedHover, s = r3(66400), l2 = r3(44248), u2 = r3(76052).DRAW_MODES, c2 = r3(3400).extendDeep;
        t2.exports = function(t3) {
          var e4 = t3._fullLayout, r4 = t3._context, f2 = e4._modeBar;
          if (r4.displayModeBar || r4.watermark) {
            if (!Array.isArray(r4.modeBarButtonsToRemove))
              throw new Error(["*modeBarButtonsToRemove* configuration options", "must be an array."].join(" "));
            if (!Array.isArray(r4.modeBarButtonsToAdd))
              throw new Error(["*modeBarButtonsToAdd* configuration options", "must be an array."].join(" "));
            var h2, p2 = r4.modeBarButtons;
            h2 = Array.isArray(p2) && p2.length ? function(t4) {
              for (var e5 = c2([], t4), r5 = 0; r5 < e5.length; r5++)
                for (var n3 = e5[r5], i2 = 0; i2 < n3.length; i2++) {
                  var a2 = n3[i2];
                  if ("string" == typeof a2) {
                    if (void 0 === l2[a2])
                      throw new Error(["*modeBarButtons* configuration options", "invalid button name"].join(" "));
                    e5[r5][i2] = l2[a2];
                  }
                }
              return e5;
            }(p2) : !r4.displayModeBar && r4.watermark ? [] : function(t4) {
              var e5 = t4._fullLayout, r5 = t4._fullData, s2 = t4._context;
              function c3(t5, e6) {
                if ("string" == typeof e6) {
                  if (e6.toLowerCase() === t5.toLowerCase())
                    return true;
                } else {
                  var r6 = e6.name, n3 = e6._cat || e6.name;
                  if (r6 === t5 || n3 === t5.toLowerCase())
                    return true;
                }
                return false;
              }
              var f3 = e5.modebar.add;
              "string" == typeof f3 && (f3 = [f3]);
              var h3 = e5.modebar.remove;
              "string" == typeof h3 && (h3 = [h3]);
              var p3 = s2.modeBarButtonsToAdd.concat(f3.filter(function(t5) {
                for (var e6 = 0; e6 < s2.modeBarButtonsToRemove.length; e6++)
                  if (c3(t5, s2.modeBarButtonsToRemove[e6]))
                    return false;
                return true;
              })), d2 = s2.modeBarButtonsToRemove.concat(h3.filter(function(t5) {
                for (var e6 = 0; e6 < s2.modeBarButtonsToAdd.length; e6++)
                  if (c3(t5, s2.modeBarButtonsToAdd[e6]))
                    return false;
                return true;
              })), v2 = e5._has("cartesian"), g2 = e5._has("gl3d"), y2 = e5._has("geo"), m2 = e5._has("pie"), x = e5._has("funnelarea"), b2 = e5._has("gl2d"), _ = e5._has("ternary"), w2 = e5._has("mapbox"), T = e5._has("polar"), k2 = e5._has("smith"), A2 = e5._has("sankey"), M = function(t5) {
                for (var e6 = n2.list({ _fullLayout: t5 }, null, true), r6 = 0; r6 < e6.length; r6++)
                  if (!e6[r6].fixedrange)
                    return false;
                return true;
              }(e5), S = o(e5.hovermode), E2 = [];
              function L(t5) {
                if (t5.length) {
                  for (var e6 = [], r6 = 0; r6 < t5.length; r6++) {
                    for (var n3 = t5[r6], i2 = l2[n3], a2 = i2.name.toLowerCase(), o2 = (i2._cat || i2.name).toLowerCase(), s3 = false, u3 = 0; u3 < d2.length; u3++) {
                      var c4 = d2[u3].toLowerCase();
                      if (c4 === a2 || c4 === o2) {
                        s3 = true;
                        break;
                      }
                    }
                    s3 || e6.push(l2[n3]);
                  }
                  E2.push(e6);
                }
              }
              var C2 = ["toImage"];
              s2.showEditInChartStudio ? C2.push("editInChartStudio") : s2.showSendToCloud && C2.push("sendDataToCloud"), L(C2);
              var P = [], O = [], I2 = [], D2 = [];
              (v2 || b2 || m2 || x || _) + y2 + g2 + w2 + T + k2 > 1 ? (O = ["toggleHover"], I2 = ["resetViews"]) : y2 ? (P = ["zoomInGeo", "zoomOutGeo"], O = ["hoverClosestGeo"], I2 = ["resetGeo"]) : g2 ? (O = ["hoverClosest3d"], I2 = ["resetCameraDefault3d", "resetCameraLastSave3d"]) : w2 ? (P = ["zoomInMapbox", "zoomOutMapbox"], O = ["toggleHover"], I2 = ["resetViewMapbox"]) : b2 ? O = ["hoverClosestGl2d"] : m2 ? O = ["hoverClosestPie"] : A2 ? (O = ["hoverClosestCartesian", "hoverCompareCartesian"], I2 = ["resetViewSankey"]) : O = ["toggleHover"], v2 && (O = ["toggleSpikelines", "hoverClosestCartesian", "hoverCompareCartesian"]), (function(t5) {
                for (var e6 = 0; e6 < t5.length; e6++)
                  if (!a.traceIs(t5[e6], "noHover"))
                    return false;
                return true;
              }(r5) || S) && (O = []), !v2 && !b2 || M || (P = ["zoomIn2d", "zoomOut2d", "autoScale2d"], "resetViews" !== I2[0] && (I2 = ["resetScale2d"])), g2 ? D2 = ["zoom3d", "pan3d", "orbitRotation", "tableRotation"] : (v2 || b2) && !M || _ ? D2 = ["zoom2d", "pan2d"] : w2 || y2 ? D2 = ["pan2d"] : T && (D2 = ["zoom2d"]), function(t5) {
                for (var e6 = false, r6 = 0; r6 < t5.length && !e6; r6++) {
                  var n3 = t5[r6];
                  n3._module && n3._module.selectPoints && (a.traceIs(n3, "scatter-like") ? (i.hasMarkers(n3) || i.hasText(n3)) && (e6 = true) : a.traceIs(n3, "box-violin") && "all" !== n3.boxpoints && "all" !== n3.points || (e6 = true));
                }
                return e6;
              }(r5) && D2.push("select2d", "lasso2d");
              var z2 = [], R = function(t5) {
                -1 === z2.indexOf(t5) && -1 !== O.indexOf(t5) && z2.push(t5);
              };
              if (Array.isArray(p3)) {
                for (var F2 = [], B2 = 0; B2 < p3.length; B2++) {
                  var N = p3[B2];
                  "string" == typeof N ? (N = N.toLowerCase(), -1 !== u2.indexOf(N) ? (e5._has("mapbox") || e5._has("cartesian")) && D2.push(N) : "togglespikelines" === N ? R("toggleSpikelines") : "togglehover" === N ? R("toggleHover") : "hovercompare" === N ? R("hoverCompareCartesian") : "hoverclosest" === N ? (R("hoverClosestCartesian"), R("hoverClosestGeo"), R("hoverClosest3d"), R("hoverClosestGl2d"), R("hoverClosestPie")) : "v1hovermode" === N && (R("toggleHover"), R("hoverClosestCartesian"), R("hoverCompareCartesian"), R("hoverClosestGeo"), R("hoverClosest3d"), R("hoverClosestGl2d"), R("hoverClosestPie"))) : F2.push(N);
                }
                p3 = F2;
              }
              return L(D2), L(P.concat(I2)), L(z2), function(t5, e6) {
                if (e6.length)
                  if (Array.isArray(e6[0]))
                    for (var r6 = 0; r6 < e6.length; r6++)
                      t5.push(e6[r6]);
                  else
                    t5.push(e6);
                return t5;
              }(E2, p3);
            }(t3), f2 ? f2.update(t3, h2) : e4._modeBar = s(t3, h2);
          } else
            f2 && (f2.destroy(), delete e4._modeBar);
        };
      }, 66400: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(38248), a = r3(3400), o = r3(9224), s = r3(25788).version, l2 = new DOMParser();
        function u2(t3) {
          this.container = t3.container, this.element = document.createElement("div"), this.update(t3.graphInfo, t3.buttons), this.container.appendChild(this.element);
        }
        var c2 = u2.prototype;
        c2.update = function(t3, e4) {
          this.graphInfo = t3;
          var r4 = this.graphInfo._context, n3 = this.graphInfo._fullLayout, i2 = "modebar-" + n3._uid;
          this.element.setAttribute("id", i2), this._uid = i2, this.element.className = "modebar", "hover" === r4.displayModeBar && (this.element.className += " modebar--hover ease-bg"), "v" === n3.modebar.orientation && (this.element.className += " vertical", e4 = e4.reverse());
          var o2 = n3.modebar, s2 = "hover" === r4.displayModeBar ? ".js-plotly-plot .plotly:hover " : "";
          a.deleteRelatedStyleRule(i2), a.addRelatedStyleRule(i2, s2 + "#" + i2 + " .modebar-group", "background-color: " + o2.bgcolor), a.addRelatedStyleRule(i2, "#" + i2 + " .modebar-btn .icon path", "fill: " + o2.color), a.addRelatedStyleRule(i2, "#" + i2 + " .modebar-btn:hover .icon path", "fill: " + o2.activecolor), a.addRelatedStyleRule(i2, "#" + i2 + " .modebar-btn.active .icon path", "fill: " + o2.activecolor);
          var l3 = !this.hasButtons(e4), u3 = this.hasLogo !== r4.displaylogo, c3 = this.locale !== r4.locale;
          if (this.locale = r4.locale, (l3 || u3 || c3) && (this.removeAllButtons(), this.updateButtons(e4), r4.watermark || r4.displaylogo)) {
            var f2 = this.getLogo();
            r4.watermark && (f2.className = f2.className + " watermark"), "v" === n3.modebar.orientation ? this.element.insertBefore(f2, this.element.childNodes[0]) : this.element.appendChild(f2), this.hasLogo = true;
          }
          this.updateActiveButton();
        }, c2.updateButtons = function(t3) {
          var e4 = this;
          this.buttons = t3, this.buttonElements = [], this.buttonsNames = [], this.buttons.forEach(function(t4) {
            var r4 = e4.createGroup();
            t4.forEach(function(t5) {
              var n3 = t5.name;
              if (!n3)
                throw new Error("must provide button 'name' in button config");
              if (-1 !== e4.buttonsNames.indexOf(n3))
                throw new Error("button name '" + n3 + "' is taken");
              e4.buttonsNames.push(n3);
              var i2 = e4.createButton(t5);
              e4.buttonElements.push(i2), r4.appendChild(i2);
            }), e4.element.appendChild(r4);
          });
        }, c2.createGroup = function() {
          var t3 = document.createElement("div");
          return t3.className = "modebar-group", t3;
        }, c2.createButton = function(t3) {
          var e4 = this, r4 = document.createElement("a");
          r4.setAttribute("rel", "tooltip"), r4.className = "modebar-btn";
          var i2 = t3.title;
          void 0 === i2 ? i2 = t3.name : "function" == typeof i2 && (i2 = i2(this.graphInfo)), (i2 || 0 === i2) && r4.setAttribute("data-title", i2), void 0 !== t3.attr && r4.setAttribute("data-attr", t3.attr);
          var a2 = t3.val;
          if (void 0 !== a2 && ("function" == typeof a2 && (a2 = a2(this.graphInfo)), r4.setAttribute("data-val", a2)), "function" != typeof t3.click)
            throw new Error("must provide button 'click' function in button config");
          r4.addEventListener("click", function(r5) {
            t3.click(e4.graphInfo, r5), e4.updateActiveButton(r5.currentTarget);
          }), r4.setAttribute("data-toggle", t3.toggle || false), t3.toggle && n2.select(r4).classed("active", true);
          var s2 = t3.icon;
          return "function" == typeof s2 ? r4.appendChild(s2()) : r4.appendChild(this.createIcon(s2 || o.question)), r4.setAttribute("data-gravity", t3.gravity || "n"), r4;
        }, c2.createIcon = function(t3) {
          var e4, r4 = i(t3.height) ? Number(t3.height) : t3.ascent - t3.descent, n3 = "http://www.w3.org/2000/svg";
          if (t3.path) {
            (e4 = document.createElementNS(n3, "svg")).setAttribute("viewBox", [0, 0, t3.width, r4].join(" ")), e4.setAttribute("class", "icon");
            var a2 = document.createElementNS(n3, "path");
            a2.setAttribute("d", t3.path), t3.transform ? a2.setAttribute("transform", t3.transform) : void 0 !== t3.ascent && a2.setAttribute("transform", "matrix(1 0 0 -1 0 " + t3.ascent + ")"), e4.appendChild(a2);
          }
          return t3.svg && (e4 = l2.parseFromString(t3.svg, "application/xml").childNodes[0]), e4.setAttribute("height", "1em"), e4.setAttribute("width", "1em"), e4;
        }, c2.updateActiveButton = function(t3) {
          var e4 = this.graphInfo._fullLayout, r4 = void 0 !== t3 ? t3.getAttribute("data-attr") : null;
          this.buttonElements.forEach(function(t4) {
            var i2 = t4.getAttribute("data-val") || true, o2 = t4.getAttribute("data-attr"), s2 = "true" === t4.getAttribute("data-toggle"), l3 = n2.select(t4);
            if (s2)
              o2 === r4 && l3.classed("active", !l3.classed("active"));
            else {
              var u3 = null === o2 ? o2 : a.nestedProperty(e4, o2).get();
              l3.classed("active", u3 === i2);
            }
          });
        }, c2.hasButtons = function(t3) {
          var e4 = this.buttons;
          if (!e4)
            return false;
          if (t3.length !== e4.length)
            return false;
          for (var r4 = 0; r4 < t3.length; ++r4) {
            if (t3[r4].length !== e4[r4].length)
              return false;
            for (var n3 = 0; n3 < t3[r4].length; n3++)
              if (t3[r4][n3].name !== e4[r4][n3].name)
                return false;
          }
          return true;
        }, c2.getLogo = function() {
          var t3 = this.createGroup(), e4 = document.createElement("a");
          return e4.href = "https://plotly.com/", e4.target = "_blank", e4.setAttribute("data-title", a._(this.graphInfo, "Produced with Plotly.js") + " (v" + s + ")"), e4.className = "modebar-btn plotlyjsicon modebar-btn--logo", e4.appendChild(this.createIcon(o.newplotlylogo)), t3.appendChild(e4), t3;
        }, c2.removeAllButtons = function() {
          for (; this.element.firstChild; )
            this.element.removeChild(this.element.firstChild);
          this.hasLogo = false;
        }, c2.destroy = function() {
          a.removeElement(this.container.querySelector(".modebar")), a.deleteRelatedStyleRule(this._uid);
        }, t2.exports = function(t3, e4) {
          var r4 = t3._fullLayout, i2 = new u2({ graphInfo: t3, container: r4._modebardiv.node(), buttons: e4 });
          return r4._privateplot && n2.select(i2.element).append("span").classed("badge-private float--left", true).text("PRIVATE"), i2;
        };
      }, 26680: function(t2, e3, r3) {
        var n2 = r3(25376), i = r3(22548), a = (0, r3(31780).templatedArray)("button", { visible: { valType: "boolean", dflt: true, editType: "plot" }, step: { valType: "enumerated", values: ["month", "year", "day", "hour", "minute", "second", "all"], dflt: "month", editType: "plot" }, stepmode: { valType: "enumerated", values: ["backward", "todate"], dflt: "backward", editType: "plot" }, count: { valType: "number", min: 0, dflt: 1, editType: "plot" }, label: { valType: "string", editType: "plot" }, editType: "plot" });
        t2.exports = { visible: { valType: "boolean", editType: "plot" }, buttons: a, x: { valType: "number", min: -2, max: 3, editType: "plot" }, xanchor: { valType: "enumerated", values: ["auto", "left", "center", "right"], dflt: "left", editType: "plot" }, y: { valType: "number", min: -2, max: 3, editType: "plot" }, yanchor: { valType: "enumerated", values: ["auto", "top", "middle", "bottom"], dflt: "bottom", editType: "plot" }, font: n2({ editType: "plot" }), bgcolor: { valType: "color", dflt: i.lightLine, editType: "plot" }, activecolor: { valType: "color", editType: "plot" }, bordercolor: { valType: "color", dflt: i.defaultLine, editType: "plot" }, borderwidth: { valType: "number", min: 0, dflt: 0, editType: "plot" }, editType: "plot" };
      }, 85984: function(t2) {
        t2.exports = { yPad: 0.02, minButtonWidth: 30, rx: 3, ry: 3, lightAmount: 25, darkAmount: 10 };
      }, 22148: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(76308), a = r3(31780), o = r3(51272), s = r3(26680), l2 = r3(85984);
        function u2(t3, e4, r4, i2) {
          var a2 = i2.calendar;
          function o2(r5, i3) {
            return n2.coerce(t3, e4, s.buttons, r5, i3);
          }
          if (o2("visible")) {
            var l3 = o2("step");
            "all" !== l3 && (!a2 || "gregorian" === a2 || "month" !== l3 && "year" !== l3 ? o2("stepmode") : e4.stepmode = "backward", o2("count")), o2("label");
          }
        }
        t2.exports = function(t3, e4, r4, c2, f2) {
          var h2 = t3.rangeselector || {}, p2 = a.newContainer(e4, "rangeselector");
          function d2(t4, e5) {
            return n2.coerce(h2, p2, s, t4, e5);
          }
          if (d2("visible", o(h2, p2, { name: "buttons", handleItemDefaults: u2, calendar: f2 }).length > 0)) {
            var v2 = function(t4, e5, r5) {
              for (var n3 = r5.filter(function(r6) {
                return e5[r6].anchor === t4._id;
              }), i2 = 0, a2 = 0; a2 < n3.length; a2++) {
                var o2 = e5[n3[a2]].domain;
                o2 && (i2 = Math.max(o2[1], i2));
              }
              return [t4.domain[0], i2 + l2.yPad];
            }(e4, r4, c2);
            d2("x", v2[0]), d2("y", v2[1]), n2.noneOrAll(t3, e4, ["x", "y"]), d2("xanchor"), d2("yanchor"), n2.coerceFont(d2, "font", r4.font);
            var g2 = d2("bgcolor");
            d2("activecolor", i.contrast(g2, l2.lightAmount, l2.darkAmount)), d2("bordercolor"), d2("borderwidth");
          }
        };
      }, 50216: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(24040), a = r3(7316), o = r3(76308), s = r3(43616), l2 = r3(3400), u2 = l2.strTranslate, c2 = r3(72736), f2 = r3(79811), h2 = r3(84284), p2 = h2.LINE_SPACING, d2 = h2.FROM_TL, v2 = h2.FROM_BR, g2 = r3(85984), y2 = r3(48040);
        function m2(t3) {
          return t3._id;
        }
        function x(t3, e4, r4) {
          var n3 = l2.ensureSingle(t3, "rect", "selector-rect", function(t4) {
            t4.attr("shape-rendering", "crispEdges");
          });
          n3.attr({ rx: g2.rx, ry: g2.ry }), n3.call(o.stroke, e4.bordercolor).call(o.fill, function(t4, e5) {
            return e5._isActive || e5._isHovered ? t4.activecolor : t4.bgcolor;
          }(e4, r4)).style("stroke-width", e4.borderwidth + "px");
        }
        function b2(t3, e4, r4, n3) {
          var i2, a2;
          l2.ensureSingle(t3, "text", "selector-text", function(t4) {
            t4.attr("text-anchor", "middle");
          }).call(s.font, e4.font).text((i2 = r4, a2 = n3._fullLayout._meta, i2.label ? a2 ? l2.templateString(i2.label, a2) : i2.label : "all" === i2.step ? "all" : i2.count + i2.step.charAt(0))).call(function(t4) {
            c2.convertToTspans(t4, n3);
          });
        }
        t2.exports = function(t3) {
          var e4 = t3._fullLayout._infolayer.selectAll(".rangeselector").data(function(t4) {
            for (var e5 = f2.list(t4, "x", true), r4 = [], n3 = 0; n3 < e5.length; n3++) {
              var i2 = e5[n3];
              i2.rangeselector && i2.rangeselector.visible && r4.push(i2);
            }
            return r4;
          }(t3), m2);
          e4.enter().append("g").classed("rangeselector", true), e4.exit().remove(), e4.style({ cursor: "pointer", "pointer-events": "all" }), e4.each(function(e5) {
            var r4 = n2.select(this), o2 = e5, f3 = o2.rangeselector, h3 = r4.selectAll("g.button").data(l2.filterVisible(f3.buttons));
            h3.enter().append("g").classed("button", true), h3.exit().remove(), h3.each(function(e6) {
              var r5 = n2.select(this), a2 = y2(o2, e6);
              e6._isActive = function(t4, e7, r6) {
                if ("all" === e7.step)
                  return true === t4.autorange;
                var n3 = Object.keys(r6);
                return t4.range[0] === r6[n3[0]] && t4.range[1] === r6[n3[1]];
              }(o2, e6, a2), r5.call(x, f3, e6), r5.call(b2, f3, e6, t3), r5.on("click", function() {
                t3._dragged || i.call("_guiRelayout", t3, a2);
              }), r5.on("mouseover", function() {
                e6._isHovered = true, r5.call(x, f3, e6);
              }), r5.on("mouseout", function() {
                e6._isHovered = false, r5.call(x, f3, e6);
              });
            }), function(t4, e6, r5, i2, o3) {
              var f4 = 0, h4 = 0, y3 = r5.borderwidth;
              e6.each(function() {
                var t5 = n2.select(this).select(".selector-text"), e7 = r5.font.size * p2, i3 = Math.max(e7 * c2.lineCount(t5), 16) + 3;
                h4 = Math.max(h4, i3);
              }), e6.each(function() {
                var t5 = n2.select(this), e7 = t5.select(".selector-rect"), i3 = t5.select(".selector-text"), a2 = i3.node() && s.bBox(i3.node()).width, o4 = r5.font.size * p2, l3 = c2.lineCount(i3), d3 = Math.max(a2 + 10, g2.minButtonWidth);
                t5.attr("transform", u2(y3 + f4, y3)), e7.attr({ x: 0, y: 0, width: d3, height: h4 }), c2.positionText(i3, d3 / 2, h4 / 2 - (l3 - 1) * o4 / 2 + 3), f4 += d3 + 5;
              });
              var m3 = t4._fullLayout._size, x2 = m3.l + m3.w * r5.x, b3 = m3.t + m3.h * (1 - r5.y), _ = "left";
              l2.isRightAnchor(r5) && (x2 -= f4, _ = "right"), l2.isCenterAnchor(r5) && (x2 -= f4 / 2, _ = "center");
              var w2 = "top";
              l2.isBottomAnchor(r5) && (b3 -= h4, w2 = "bottom"), l2.isMiddleAnchor(r5) && (b3 -= h4 / 2, w2 = "middle"), f4 = Math.ceil(f4), h4 = Math.ceil(h4), x2 = Math.round(x2), b3 = Math.round(b3), a.autoMargin(t4, i2 + "-range-selector", { x: r5.x, y: r5.y, l: f4 * d2[_], r: f4 * v2[_], b: h4 * v2[w2], t: h4 * d2[w2] }), o3.attr("transform", u2(x2, b3));
            }(t3, h3, f3, o2._name, r4);
          });
        };
      }, 48040: function(t2, e3, r3) {
        var n2 = r3(73220), i = r3(3400).titleCase;
        t2.exports = function(t3, e4) {
          var r4 = t3._name, a = {};
          if ("all" === e4.step)
            a[r4 + ".autorange"] = true;
          else {
            var o = function(t4, e5) {
              var r5, a2 = t4.range, o2 = new Date(t4.r2l(a2[1])), s = e5.step, l2 = n2["utc" + i(s)], u2 = e5.count;
              switch (e5.stepmode) {
                case "backward":
                  r5 = t4.l2r(+l2.offset(o2, -u2));
                  break;
                case "todate":
                  var c2 = l2.offset(o2, -u2);
                  r5 = t4.l2r(+l2.ceil(c2));
              }
              return [r5, a2[1]];
            }(t3, e4);
            a[r4 + ".range[0]"] = o[0], a[r4 + ".range[1]"] = o[1];
          }
          return a;
        };
      }, 41152: function(t2, e3, r3) {
        t2.exports = { moduleType: "component", name: "rangeselector", schema: { subplots: { xaxis: { rangeselector: r3(26680) } } }, layoutAttributes: r3(26680), handleDefaults: r3(22148), draw: r3(50216) };
      }, 11200: function(t2, e3, r3) {
        var n2 = r3(22548);
        t2.exports = { bgcolor: { valType: "color", dflt: n2.background, editType: "plot" }, bordercolor: { valType: "color", dflt: n2.defaultLine, editType: "plot" }, borderwidth: { valType: "integer", dflt: 0, min: 0, editType: "plot" }, autorange: { valType: "boolean", dflt: true, editType: "calc", impliedEdits: { "range[0]": void 0, "range[1]": void 0 } }, range: { valType: "info_array", items: [{ valType: "any", editType: "calc", impliedEdits: { "^autorange": false } }, { valType: "any", editType: "calc", impliedEdits: { "^autorange": false } }], editType: "calc", impliedEdits: { autorange: false } }, thickness: { valType: "number", dflt: 0.15, min: 0, max: 1, editType: "plot" }, visible: { valType: "boolean", dflt: true, editType: "calc" }, editType: "calc" };
      }, 26652: function(t2, e3, r3) {
        var n2 = r3(79811).list, i = r3(19280).getAutoRange, a = r3(74636);
        t2.exports = function(t3) {
          for (var e4 = n2(t3, "x", true), r4 = 0; r4 < e4.length; r4++) {
            var o = e4[r4], s = o[a.name];
            s && s.visible && s.autorange && (s._input.autorange = true, s._input.range = s.range = i(t3, o));
          }
        };
      }, 74636: function(t2) {
        t2.exports = { name: "rangeslider", containerClassName: "rangeslider-container", bgClassName: "rangeslider-bg", rangePlotClassName: "rangeslider-rangeplot", maskMinClassName: "rangeslider-mask-min", maskMaxClassName: "rangeslider-mask-max", slideBoxClassName: "rangeslider-slidebox", grabberMinClassName: "rangeslider-grabber-min", grabAreaMinClassName: "rangeslider-grabarea-min", handleMinClassName: "rangeslider-handle-min", grabberMaxClassName: "rangeslider-grabber-max", grabAreaMaxClassName: "rangeslider-grabarea-max", handleMaxClassName: "rangeslider-handle-max", maskMinOppAxisClassName: "rangeslider-mask-min-opp-axis", maskMaxOppAxisClassName: "rangeslider-mask-max-opp-axis", maskColor: "rgba(0,0,0,0.4)", maskOppAxisColor: "rgba(0,0,0,0.2)", slideBoxFill: "transparent", slideBoxCursor: "ew-resize", grabAreaFill: "transparent", grabAreaCursor: "col-resize", grabAreaWidth: 10, handleWidth: 4, handleRadius: 1, handleStrokeWidth: 1, extraPad: 15 };
      }, 94040: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(31780), a = r3(79811), o = r3(11200), s = r3(10936);
        t2.exports = function(t3, e4, r4) {
          var l2 = t3[r4], u2 = e4[r4];
          if (l2.rangeslider || e4._requestRangeslider[u2._id]) {
            n2.isPlainObject(l2.rangeslider) || (l2.rangeslider = {});
            var c2, f2, h2 = l2.rangeslider, p2 = i.newContainer(u2, "rangeslider");
            if (_("visible")) {
              _("bgcolor", e4.plot_bgcolor), _("bordercolor"), _("borderwidth"), _("thickness"), _("autorange", !u2.isValidRange(h2.range)), _("range");
              var d2 = e4._subplots;
              if (d2)
                for (var v2 = d2.cartesian.filter(function(t4) {
                  return t4.substr(0, t4.indexOf("y")) === a.name2id(r4);
                }).map(function(t4) {
                  return t4.substr(t4.indexOf("y"), t4.length);
                }), g2 = n2.simpleMap(v2, a.id2name), y2 = 0; y2 < g2.length; y2++) {
                  var m2 = g2[y2];
                  c2 = h2[m2] || {}, f2 = i.newContainer(p2, m2, "yaxis");
                  var x, b2 = e4[m2];
                  c2.range && b2.isValidRange(c2.range) && (x = "fixed"), "match" !== w2("rangemode", x) && w2("range", b2.range.slice());
                }
              p2._input = h2;
            }
          }
          function _(t4, e5) {
            return n2.coerce(h2, p2, o, t4, e5);
          }
          function w2(t4, e5) {
            return n2.coerce(c2, f2, s, t4, e5);
          }
        };
      }, 20060: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(24040), a = r3(7316), o = r3(3400), s = o.strTranslate, l2 = r3(43616), u2 = r3(76308), c2 = r3(81668), f2 = r3(57952), h2 = r3(79811), p2 = r3(86476), d2 = r3(93972), v2 = r3(74636);
        function g2(t3) {
          return "number" == typeof t3.clientX ? t3.clientX : t3.touches && t3.touches.length > 0 ? t3.touches[0].clientX : 0;
        }
        function y2(t3, e4, r4, n3) {
          var i2 = o.ensureSingle(t3, "rect", v2.bgClassName, function(t4) {
            t4.attr({ x: 0, y: 0, "shape-rendering": "crispEdges" });
          }), a2 = n3.borderwidth % 2 == 0 ? n3.borderwidth : n3.borderwidth - 1, c3 = -n3._offsetShift, f3 = l2.crispRound(e4, n3.borderwidth);
          i2.attr({ width: n3._width + a2, height: n3._height + a2, transform: s(c3, c3), "stroke-width": f3 }).call(u2.stroke, n3.bordercolor).call(u2.fill, n3.bgcolor);
        }
        function m2(t3, e4, r4, n3) {
          var i2 = e4._fullLayout;
          o.ensureSingleById(i2._topdefs, "clipPath", n3._clipId, function(t4) {
            t4.append("rect").attr({ x: 0, y: 0 });
          }).select("rect").attr({ width: n3._width, height: n3._height });
        }
        function x(t3, e4, r4, i2) {
          var s2, u3 = e4.calcdata, c3 = t3.selectAll("g." + v2.rangePlotClassName).data(r4._subplotsWith, o.identity);
          c3.enter().append("g").attr("class", function(t4) {
            return v2.rangePlotClassName + " " + t4;
          }).call(l2.setClipUrl, i2._clipId, e4), c3.order(), c3.exit().remove(), c3.each(function(t4, o2) {
            var l3 = n2.select(this), c4 = 0 === o2, p3 = h2.getFromId(e4, t4, "y"), d3 = p3._name, v3 = i2[d3], g3 = { data: [], layout: { xaxis: { type: r4.type, domain: [0, 1], range: i2.range.slice(), calendar: r4.calendar }, width: i2._width, height: i2._height, margin: { t: 0, b: 0, l: 0, r: 0 } }, _context: e4._context };
            r4.rangebreaks && (g3.layout.xaxis.rangebreaks = r4.rangebreaks), g3.layout[d3] = { type: p3.type, domain: [0, 1], range: "match" !== v3.rangemode ? v3.range.slice() : p3.range.slice(), calendar: p3.calendar }, p3.rangebreaks && (g3.layout[d3].rangebreaks = p3.rangebreaks), a.supplyDefaults(g3);
            var y3 = g3._fullLayout.xaxis, m3 = g3._fullLayout[d3];
            y3.clearCalc(), y3.setScale(), m3.clearCalc(), m3.setScale();
            var x2 = { id: t4, plotgroup: l3, xaxis: y3, yaxis: m3, isRangePlot: true };
            c4 ? s2 = x2 : (x2.mainplot = "xy", x2.mainplotinfo = s2), f2.rangePlot(e4, x2, function(t5, e5) {
              for (var r5 = [], n3 = 0; n3 < t5.length; n3++) {
                var i3 = t5[n3], a2 = i3[0].trace;
                a2.xaxis + a2.yaxis === e5 && r5.push(i3);
              }
              return r5;
            }(u3, t4));
          });
        }
        function b2(t3, e4, r4, n3, i2) {
          o.ensureSingle(t3, "rect", v2.maskMinClassName, function(t4) {
            t4.attr({ x: 0, y: 0, "shape-rendering": "crispEdges" });
          }).attr("height", n3._height).call(u2.fill, v2.maskColor), o.ensureSingle(t3, "rect", v2.maskMaxClassName, function(t4) {
            t4.attr({ y: 0, "shape-rendering": "crispEdges" });
          }).attr("height", n3._height).call(u2.fill, v2.maskColor), "match" !== i2.rangemode && (o.ensureSingle(t3, "rect", v2.maskMinOppAxisClassName, function(t4) {
            t4.attr({ y: 0, "shape-rendering": "crispEdges" });
          }).attr("width", n3._width).call(u2.fill, v2.maskOppAxisColor), o.ensureSingle(t3, "rect", v2.maskMaxOppAxisClassName, function(t4) {
            t4.attr({ y: 0, "shape-rendering": "crispEdges" });
          }).attr("width", n3._width).style("border-top", v2.maskOppBorder).call(u2.fill, v2.maskOppAxisColor));
        }
        function _(t3, e4, r4, n3) {
          e4._context.staticPlot || o.ensureSingle(t3, "rect", v2.slideBoxClassName, function(t4) {
            t4.attr({ y: 0, cursor: v2.slideBoxCursor, "shape-rendering": "crispEdges" });
          }).attr({ height: n3._height, fill: v2.slideBoxFill });
        }
        function w2(t3, e4, r4, n3) {
          var i2 = o.ensureSingle(t3, "g", v2.grabberMinClassName), a2 = o.ensureSingle(t3, "g", v2.grabberMaxClassName), s2 = { x: 0, width: v2.handleWidth, rx: v2.handleRadius, fill: u2.background, stroke: u2.defaultLine, "stroke-width": v2.handleStrokeWidth, "shape-rendering": "crispEdges" }, l3 = { y: Math.round(n3._height / 4), height: Math.round(n3._height / 2) };
          o.ensureSingle(i2, "rect", v2.handleMinClassName, function(t4) {
            t4.attr(s2);
          }).attr(l3), o.ensureSingle(a2, "rect", v2.handleMaxClassName, function(t4) {
            t4.attr(s2);
          }).attr(l3);
          var c3 = { width: v2.grabAreaWidth, x: 0, y: 0, fill: v2.grabAreaFill, cursor: e4._context.staticPlot ? void 0 : v2.grabAreaCursor };
          o.ensureSingle(i2, "rect", v2.grabAreaMinClassName, function(t4) {
            t4.attr(c3);
          }).attr("height", n3._height), o.ensureSingle(a2, "rect", v2.grabAreaMaxClassName, function(t4) {
            t4.attr(c3);
          }).attr("height", n3._height);
        }
        t2.exports = function(t3) {
          for (var e4 = t3._fullLayout, r4 = e4._rangeSliderData, a2 = 0; a2 < r4.length; a2++) {
            var l3 = r4[a2][v2.name];
            l3._clipId = l3._id + "-" + e4._uid;
          }
          var u3 = e4._infolayer.selectAll("g." + v2.containerClassName).data(r4, function(t4) {
            return t4._name;
          });
          u3.exit().each(function(t4) {
            var r5 = t4[v2.name];
            e4._topdefs.select("#" + r5._clipId).remove();
          }).remove(), 0 !== r4.length && (u3.enter().append("g").classed(v2.containerClassName, true).attr("pointer-events", "all"), u3.each(function(r5) {
            var a3 = n2.select(this), l4 = r5[v2.name], u4 = e4[h2.id2name(r5.anchor)], f3 = l4[h2.id2name(r5.anchor)];
            if (l4.range) {
              var T, k2 = o.simpleMap(l4.range, r5.r2l), A2 = o.simpleMap(r5.range, r5.r2l);
              T = A2[0] < A2[1] ? [Math.min(k2[0], A2[0]), Math.max(k2[1], A2[1])] : [Math.max(k2[0], A2[0]), Math.min(k2[1], A2[1])], l4.range = l4._input.range = o.simpleMap(T, r5.l2r);
            }
            r5.cleanRange("rangeslider.range");
            var M = e4._size, S = r5.domain;
            l4._width = M.w * (S[1] - S[0]);
            var E2 = Math.round(M.l + M.w * S[0]), L = Math.round(M.t + M.h * (1 - r5._counterDomainMin) + ("bottom" === r5.side ? r5._depth : 0) + l4._offsetShift + v2.extraPad);
            a3.attr("transform", s(E2, L)), l4._rl = o.simpleMap(l4.range, r5.r2l);
            var C2 = l4._rl[0], P = l4._rl[1], O = P - C2;
            if (l4.p2d = function(t4) {
              return t4 / l4._width * O + C2;
            }, l4.d2p = function(t4) {
              return (t4 - C2) / O * l4._width;
            }, r5.rangebreaks) {
              var I2 = r5.locateBreaks(C2, P);
              if (I2.length) {
                var D2, z2, R = 0;
                for (D2 = 0; D2 < I2.length; D2++)
                  R += (z2 = I2[D2]).max - z2.min;
                var F2 = l4._width / (P - C2 - R), B2 = [-F2 * C2];
                for (D2 = 0; D2 < I2.length; D2++)
                  z2 = I2[D2], B2.push(B2[B2.length - 1] - F2 * (z2.max - z2.min));
                for (l4.d2p = function(t4) {
                  for (var e5 = B2[0], r6 = 0; r6 < I2.length; r6++) {
                    var n3 = I2[r6];
                    if (t4 >= n3.max)
                      e5 = B2[r6 + 1];
                    else if (t4 < n3.min)
                      break;
                  }
                  return e5 + F2 * t4;
                }, D2 = 0; D2 < I2.length; D2++)
                  (z2 = I2[D2]).pmin = l4.d2p(z2.min), z2.pmax = l4.d2p(z2.max);
                l4.p2d = function(t4) {
                  for (var e5 = B2[0], r6 = 0; r6 < I2.length; r6++) {
                    var n3 = I2[r6];
                    if (t4 >= n3.pmax)
                      e5 = B2[r6 + 1];
                    else if (t4 < n3.pmin)
                      break;
                  }
                  return (t4 - e5) / F2;
                };
              }
            }
            if ("match" !== f3.rangemode) {
              var N = u4.r2l(f3.range[0]), j = u4.r2l(f3.range[1]) - N;
              l4.d2pOppAxis = function(t4) {
                return (t4 - N) / j * l4._height;
              };
            }
            a3.call(y2, t3, r5, l4).call(m2, t3, r5, l4).call(x, t3, r5, l4).call(b2, t3, r5, l4, f3).call(_, t3, r5, l4).call(w2, t3, r5, l4), function(t4, e5, r6, a4) {
              if (!e5._context.staticPlot) {
                var s2 = t4.select("rect." + v2.slideBoxClassName).node(), l5 = t4.select("rect." + v2.grabAreaMinClassName).node(), u5 = t4.select("rect." + v2.grabAreaMaxClassName).node();
                t4.on("mousedown", c3), t4.on("touchstart", c3);
              }
              function c3() {
                var c4 = n2.event, f4 = c4.target, h3 = g2(c4), v3 = h3 - t4.node().getBoundingClientRect().left, y3 = a4.d2p(r6._rl[0]), m3 = a4.d2p(r6._rl[1]), x2 = p2.coverSlip();
                function b3(t5) {
                  var c5, p3, b4, _3 = +g2(t5) - h3;
                  switch (f4) {
                    case s2:
                      if (b4 = "ew-resize", y3 + _3 > r6._length || m3 + _3 < 0)
                        return;
                      c5 = y3 + _3, p3 = m3 + _3;
                      break;
                    case l5:
                      if (b4 = "col-resize", y3 + _3 > r6._length)
                        return;
                      c5 = y3 + _3, p3 = m3;
                      break;
                    case u5:
                      if (b4 = "col-resize", m3 + _3 < 0)
                        return;
                      c5 = y3, p3 = m3 + _3;
                      break;
                    default:
                      b4 = "ew-resize", c5 = v3, p3 = v3 + _3;
                  }
                  if (p3 < c5) {
                    var w3 = p3;
                    p3 = c5, c5 = w3;
                  }
                  a4._pixelMin = c5, a4._pixelMax = p3, d2(n2.select(x2), b4), function(t6, e6, r7, n3) {
                    function a5(t7) {
                      return r7.l2r(o.constrain(t7, n3._rl[0], n3._rl[1]));
                    }
                    var s3 = a5(n3.p2d(n3._pixelMin)), l6 = a5(n3.p2d(n3._pixelMax));
                    window.requestAnimationFrame(function() {
                      i.call("_guiRelayout", e6, r7._name + ".range", [s3, l6]);
                    });
                  }(0, e5, r6, a4);
                }
                function _2() {
                  x2.removeEventListener("mousemove", b3), x2.removeEventListener("mouseup", _2), this.removeEventListener("touchmove", b3), this.removeEventListener("touchend", _2), o.removeElement(x2);
                }
                this.addEventListener("touchmove", b3), this.addEventListener("touchend", _2), x2.addEventListener("mousemove", b3), x2.addEventListener("mouseup", _2);
              }
            }(a3, t3, r5, l4), function(t4, e5, r6, n3, i2, a4) {
              var l5 = v2.handleWidth / 2;
              function u5(t5) {
                return o.constrain(t5, 0, n3._width);
              }
              function c3(t5) {
                return o.constrain(t5, 0, n3._height);
              }
              function f4(t5) {
                return o.constrain(t5, -l5, n3._width + l5);
              }
              var h3 = u5(n3.d2p(r6._rl[0])), p3 = u5(n3.d2p(r6._rl[1]));
              if (t4.select("rect." + v2.slideBoxClassName).attr("x", h3).attr("width", p3 - h3), t4.select("rect." + v2.maskMinClassName).attr("width", h3), t4.select("rect." + v2.maskMaxClassName).attr("x", p3).attr("width", n3._width - p3), "match" !== a4.rangemode) {
                var d3 = n3._height - c3(n3.d2pOppAxis(i2._rl[1])), g3 = n3._height - c3(n3.d2pOppAxis(i2._rl[0]));
                t4.select("rect." + v2.maskMinOppAxisClassName).attr("x", h3).attr("height", d3).attr("width", p3 - h3), t4.select("rect." + v2.maskMaxOppAxisClassName).attr("x", h3).attr("y", g3).attr("height", n3._height - g3).attr("width", p3 - h3), t4.select("rect." + v2.slideBoxClassName).attr("y", d3).attr("height", g3 - d3);
              }
              var y3 = 0.5, m3 = Math.round(f4(h3 - l5)) - y3, x2 = Math.round(f4(p3 - l5)) + y3;
              t4.select("g." + v2.grabberMinClassName).attr("transform", s(m3, y3)), t4.select("g." + v2.grabberMaxClassName).attr("transform", s(x2, y3));
            }(a3, 0, r5, l4, u4, f3), "bottom" === r5.side && c2.draw(t3, r5._id + "title", { propContainer: r5, propName: r5._name + ".title", placeholder: e4._dfltTitle.x, attributes: { x: r5._offset + r5._length / 2, y: L + l4._height + l4._offsetShift + 10 + 1.5 * r5.title.font.size, "text-anchor": "middle" } });
          }));
        };
      }, 97944: function(t2, e3, r3) {
        var n2 = r3(79811), i = r3(72736), a = r3(74636), o = r3(84284).LINE_SPACING, s = a.name;
        function l2(t3) {
          var e4 = t3 && t3[s];
          return e4 && e4.visible;
        }
        e3.isVisible = l2, e3.makeData = function(t3) {
          var e4 = n2.list({ _fullLayout: t3 }, "x", true), r4 = t3.margin, i2 = [];
          if (!t3._has("gl2d"))
            for (var a2 = 0; a2 < e4.length; a2++) {
              var o2 = e4[a2];
              if (l2(o2)) {
                i2.push(o2);
                var u2 = o2[s];
                u2._id = s + o2._id, u2._height = (t3.height - r4.b - r4.t) * u2.thickness, u2._offsetShift = Math.floor(u2.borderwidth / 2);
              }
            }
          t3._rangeSliderData = i2;
        }, e3.autoMarginOpts = function(t3, e4) {
          var r4 = t3._fullLayout, n3 = e4[s], l3 = e4._id.charAt(0), u2 = 0, c2 = 0;
          return "bottom" === e4.side && (u2 = e4._depth, e4.title.text !== r4._dfltTitle[l3] && (c2 = 1.5 * e4.title.font.size + 10 + n3._offsetShift, c2 += (e4.title.text.match(i.BR_TAG_ALL) || []).length * e4.title.font.size * o)), { x: 0, y: e4._counterDomainMin, l: 0, r: 0, t: 0, b: n3._height + u2 + Math.max(r4.margin.b, c2), pad: a.extraPad + 2 * n3._offsetShift };
        };
      }, 49692: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(11200), a = r3(10936), o = r3(97944);
        t2.exports = { moduleType: "component", name: "rangeslider", schema: { subplots: { xaxis: { rangeslider: n2.extendFlat({}, i, { yaxis: a }) } } }, layoutAttributes: r3(11200), handleDefaults: r3(94040), calcAutorange: r3(26652), draw: r3(20060), isVisible: o.isVisible, makeData: o.makeData, autoMarginOpts: o.autoMarginOpts };
      }, 10936: function(t2) {
        t2.exports = { _isSubplotObj: true, rangemode: { valType: "enumerated", values: ["auto", "fixed", "match"], dflt: "match", editType: "calc" }, range: { valType: "info_array", items: [{ valType: "any", editType: "plot" }, { valType: "any", editType: "plot" }], editType: "plot" }, editType: "calc" };
      }, 93956: function(t2, e3, r3) {
        var n2 = r3(13916), i = r3(52904).line, a = r3(98192).u, o = r3(92880).extendFlat, s = r3(67824).overrideAll, l2 = r3(31780).templatedArray;
        r3(36208), t2.exports = s(l2("selection", { type: { valType: "enumerated", values: ["rect", "path"] }, xref: o({}, n2.xref, {}), yref: o({}, n2.yref, {}), x0: { valType: "any" }, x1: { valType: "any" }, y0: { valType: "any" }, y1: { valType: "any" }, path: { valType: "string", editType: "arraydraw" }, opacity: { valType: "number", min: 0, max: 1, dflt: 0.7, editType: "arraydraw" }, line: { color: i.color, width: o({}, i.width, { min: 1, dflt: 1 }), dash: o({}, a, { dflt: "dot" }) } }), "arraydraw", "from-root");
      }, 83280: function(t2) {
        t2.exports = { BENDPX: 1.5, MINSELECT: 12, SELECTDELAY: 100, SELECTID: "-select" };
      }, 74224: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(54460), a = r3(51272), o = r3(93956), s = r3(65152);
        function l2(t3, e4, r4) {
          function a2(r5, i2) {
            return n2.coerce(t3, e4, o, r5, i2);
          }
          var l3 = a2("path"), u2 = "path" !== a2("type", l3 ? "path" : "rect");
          u2 && delete e4.path, a2("opacity"), a2("line.color"), a2("line.width"), a2("line.dash");
          for (var c2 = ["x", "y"], f2 = 0; f2 < 2; f2++) {
            var h2, p2, d2, v2 = c2[f2], g2 = { _fullLayout: r4 }, y2 = i.coerceRef(t3, e4, g2, v2);
            if ((h2 = i.getFromId(g2, y2))._selectionIndices.push(e4._index), d2 = s.rangeToShapePosition(h2), p2 = s.shapePositionToRange(h2), u2) {
              var m2 = v2 + "0", x = v2 + "1", b2 = t3[m2], _ = t3[x];
              t3[m2] = p2(t3[m2], true), t3[x] = p2(t3[x], true), i.coercePosition(e4, g2, a2, y2, m2), i.coercePosition(e4, g2, a2, y2, x);
              var w2 = e4[m2], T = e4[x];
              void 0 !== w2 && void 0 !== T && (e4[m2] = d2(w2), e4[x] = d2(T), t3[m2] = b2, t3[x] = _);
            }
          }
          u2 && n2.noneOrAll(t3, e4, ["x0", "x1", "y0", "y1"]);
        }
        t2.exports = function(t3, e4) {
          a(t3, e4, { name: "selections", handleItemDefaults: l2 });
          for (var r4 = e4.selections, n3 = 0; n3 < r4.length; n3++) {
            var i2 = r4[n3];
            i2 && void 0 === i2.path && (void 0 !== i2.x0 && void 0 !== i2.x1 && void 0 !== i2.y0 && void 0 !== i2.y1 || (e4.selections[n3] = null));
          }
        };
      }, 23640: function(t2, e3, r3) {
        var n2 = r3(9856).readPaths, i = r3(55496), a = r3(1936).clearOutlineControllers, o = r3(76308), s = r3(43616), l2 = r3(31780).arrayEditor, u2 = r3(65152), c2 = u2.getPathString;
        function f2(t3) {
          var e4 = t3._fullLayout;
          for (var r4 in a(t3), e4._selectionLayer.selectAll("path").remove(), e4._plots) {
            var n3 = e4._plots[r4].selectionLayer;
            n3 && n3.selectAll("path").remove();
          }
          for (var i2 = 0; i2 < e4.selections.length; i2++)
            p2(t3, i2);
        }
        function h2(t3) {
          return t3._context.editSelection;
        }
        function p2(t3, e4) {
          t3._fullLayout._paperdiv.selectAll('.selectionlayer [data-index="' + e4 + '"]').remove();
          var r4 = u2.makeSelectionsOptionsAndPlotinfo(t3, e4), a2 = r4.options, p3 = r4.plotinfo;
          a2._input && function(r5) {
            var u3 = c2(t3, a2), g2 = { "data-index": e4, "fill-rule": "evenodd", d: u3 }, y2 = a2.opacity, m2 = "rgba(0,0,0,0)", x = a2.line.color || o.contrast(t3._fullLayout.plot_bgcolor), b2 = a2.line.width, _ = a2.line.dash;
            b2 || (b2 = 5, _ = "solid");
            var w2 = h2(t3) && t3._fullLayout._activeSelectionIndex === e4;
            w2 && (m2 = t3._fullLayout.activeselection.fillcolor, y2 = t3._fullLayout.activeselection.opacity);
            for (var T = [], k2 = 1; k2 >= 0; k2--) {
              var A2 = r5.append("path").attr(g2).style("opacity", k2 ? 0.1 : y2).call(o.stroke, x).call(o.fill, m2).call(s.dashLine, k2 ? "solid" : _, k2 ? 4 + b2 : b2);
              if (d2(A2, t3, a2), w2) {
                var M = l2(t3.layout, "selections", a2);
                A2.style({ cursor: "move" });
                var S = { element: A2.node(), plotinfo: p3, gd: t3, editHelpers: M, isActiveSelection: true }, E2 = n2(u3, t3);
                i(E2, A2, S);
              } else
                A2.style("pointer-events", k2 ? "all" : "none");
              T[k2] = A2;
            }
            var L = T[0];
            T[1].node().addEventListener("click", function() {
              return function(t4, e5) {
                if (h2(t4)) {
                  var r6 = +e5.node().getAttribute("data-index");
                  if (r6 >= 0) {
                    if (r6 === t4._fullLayout._activeSelectionIndex)
                      return void v2(t4);
                    t4._fullLayout._activeSelectionIndex = r6, t4._fullLayout._deactivateSelection = v2, f2(t4);
                  }
                }
              }(t3, L);
            });
          }(t3._fullLayout._selectionLayer);
        }
        function d2(t3, e4, r4) {
          var n3 = r4.xref + r4.yref;
          s.setClipUrl(t3, "clip" + e4._fullLayout._uid + n3, e4);
        }
        function v2(t3) {
          h2(t3) && t3._fullLayout._activeSelectionIndex >= 0 && (a(t3), delete t3._fullLayout._activeSelectionIndex, f2(t3));
        }
        t2.exports = { draw: f2, drawOne: p2, activateLastSelection: function(t3) {
          if (h2(t3)) {
            var e4 = t3._fullLayout.selections.length - 1;
            t3._fullLayout._activeSelectionIndex = e4, t3._fullLayout._deactivateSelection = v2, f2(t3);
          }
        } };
      }, 34200: function(t2, e3, r3) {
        var n2 = r3(98192).u, i = r3(92880).extendFlat;
        t2.exports = { newselection: { mode: { valType: "enumerated", values: ["immediate", "gradual"], dflt: "immediate", editType: "none" }, line: { color: { valType: "color", editType: "none" }, width: { valType: "number", min: 1, dflt: 1, editType: "none" }, dash: i({}, n2, { dflt: "dot", editType: "none" }), editType: "none" }, editType: "none" }, activeselection: { fillcolor: { valType: "color", dflt: "rgba(0,0,0,0)", editType: "none" }, opacity: { valType: "number", min: 0, max: 1, dflt: 0.5, editType: "none" }, editType: "none" } };
      }, 81004: function(t2) {
        t2.exports = function(t3, e3, r3) {
          r3("newselection.mode"), r3("newselection.line.width") && (r3("newselection.line.color"), r3("newselection.line.dash")), r3("activeselection.fillcolor"), r3("activeselection.opacity");
        };
      }, 5968: function(t2, e3, r3) {
        var n2 = r3(72760).selectMode, i = r3(1936).clearOutline, a = r3(9856), o = a.readPaths, s = a.writePaths, l2 = a.fixDatesForPaths;
        t2.exports = function(t3, e4) {
          if (t3.length) {
            var r4 = t3[0][0];
            if (r4) {
              var a2 = r4.getAttribute("d"), u2 = e4.gd, c2 = u2._fullLayout.newselection, f2 = e4.plotinfo, h2 = f2.xaxis, p2 = f2.yaxis, d2 = e4.isActiveSelection, v2 = e4.dragmode, g2 = (u2.layout || {}).selections || [];
              if (!n2(v2) && void 0 !== d2) {
                var y2 = u2._fullLayout._activeSelectionIndex;
                if (y2 < g2.length)
                  switch (u2._fullLayout.selections[y2].type) {
                    case "rect":
                      v2 = "select";
                      break;
                    case "path":
                      v2 = "lasso";
                  }
              }
              var m2, x = o(a2, u2, f2, d2), b2 = { xref: h2._id, yref: p2._id, opacity: c2.opacity, line: { color: c2.line.color, width: c2.line.width, dash: c2.line.dash } };
              1 === x.length && (m2 = x[0]), m2 && 5 === m2.length && "select" === v2 ? (b2.type = "rect", b2.x0 = m2[0][1], b2.y0 = m2[0][2], b2.x1 = m2[2][1], b2.y1 = m2[2][2]) : (b2.type = "path", h2 && p2 && l2(x, h2, p2), b2.path = s(x), m2 = null), i(u2);
              for (var _ = e4.editHelpers, w2 = (_ || {}).modifyItem, T = [], k2 = 0; k2 < g2.length; k2++) {
                var A2 = u2._fullLayout.selections[k2];
                if (A2) {
                  if (T[k2] = A2._input, void 0 !== d2 && k2 === u2._fullLayout._activeSelectionIndex) {
                    var M = b2;
                    switch (A2.type) {
                      case "rect":
                        w2("x0", M.x0), w2("x1", M.x1), w2("y0", M.y0), w2("y1", M.y1);
                        break;
                      case "path":
                        w2("path", M.path);
                    }
                  }
                } else
                  T[k2] = A2;
              }
              return void 0 === d2 ? (T.push(b2), T) : _ ? _.getUpdateObj() : {};
            }
          }
        };
      }, 5840: function(t2, e3, r3) {
        var n2 = r3(3400).strTranslate;
        function i(t3, e4) {
          switch (t3.type) {
            case "log":
              return t3.p2d(e4);
            case "date":
              return t3.p2r(e4, 0, t3.calendar);
            default:
              return t3.p2r(e4);
          }
        }
        t2.exports = { p2r: i, r2p: function(t3, e4) {
          switch (t3.type) {
            case "log":
              return t3.d2p(e4);
            case "date":
              return t3.r2p(e4, 0, t3.calendar);
            default:
              return t3.r2p(e4);
          }
        }, axValue: function(t3) {
          var e4 = "y" === t3._id.charAt(0) ? 1 : 0;
          return function(r4) {
            return i(t3, r4[e4]);
          };
        }, getTransform: function(t3) {
          return n2(t3.xaxis._offset, t3.yaxis._offset);
        } };
      }, 22676: function(t2, e3, r3) {
        var n2 = r3(23640), i = r3(43156);
        t2.exports = { moduleType: "component", name: "selections", layoutAttributes: r3(93956), supplyLayoutDefaults: r3(74224), supplyDrawNewSelectionDefaults: r3(81004), includeBasePlot: r3(36632)("selections"), draw: n2.draw, drawOne: n2.drawOne, reselect: i.reselect, prepSelect: i.prepSelect, clearOutline: i.clearOutline, clearSelectionsCache: i.clearSelectionsCache, selectOnClick: i.selectOnClick };
      }, 43156: function(t2, e3, r3) {
        var n2 = r3(14756), i = r3(61456), a = r3(24040), o = r3(43616).dashStyle, s = r3(76308), l2 = r3(93024), u2 = r3(10624).makeEventData, c2 = r3(72760), f2 = c2.freeMode, h2 = c2.rectMode, p2 = c2.drawMode, d2 = c2.openMode, v2 = c2.selectMode, g2 = r3(65152), y2 = r3(85448), m2 = r3(55496), x = r3(1936).clearOutline, b2 = r3(9856), _ = b2.handleEllipse, w2 = b2.readPaths, T = r3(93940).newShapes, k2 = r3(5968), A2 = r3(23640).activateLastSelection, M = r3(3400), S = M.sorterAsc, E2 = r3(92065), L = r3(91200), C2 = r3(79811).getFromId, P = r3(73696), O = r3(39172).redrawReglTraces, I2 = r3(83280), D2 = I2.MINSELECT, z2 = E2.filter, R = E2.tester, F2 = r3(5840), B2 = F2.p2r, N = F2.axValue, j = F2.getTransform;
        function U(t3) {
          return void 0 !== t3.subplot;
        }
        function V(t3, e4, r4, n3, i2, a2, o2) {
          var s2, l3, u3, c3, f3, h3, p3, v3, g3, y3 = e4._hoverdata, x2 = e4._fullLayout.clickmode.indexOf("event") > -1, b3 = [];
          if (function(t4) {
            return t4 && Array.isArray(t4) && true !== t4[0].hoverOnBox;
          }(y3)) {
            W(t3, e4, a2);
            var _2 = function(t4, e5) {
              var r5, n4, i3 = t4[0], a3 = -1, o3 = [];
              for (n4 = 0; n4 < e5.length; n4++)
                if (r5 = e5[n4], i3.fullData._expandedIndex === r5.cd[0].trace._expandedIndex) {
                  if (true === i3.hoverOnBox)
                    break;
                  void 0 !== i3.pointNumber ? a3 = i3.pointNumber : void 0 !== i3.binNumber && (a3 = i3.binNumber, o3 = i3.pointNumbers);
                  break;
                }
              return { pointNumber: a3, pointNumbers: o3, searchInfo: r5 };
            }(y3, s2 = Z(e4, r4, n3, i2));
            if (_2.pointNumbers.length > 0 ? function(t4, e5) {
              var r5, n4, i3, a3 = [];
              for (i3 = 0; i3 < t4.length; i3++)
                (r5 = t4[i3]).cd[0].trace.selectedpoints && r5.cd[0].trace.selectedpoints.length > 0 && a3.push(r5);
              if (1 === a3.length && a3[0] === e5.searchInfo && (n4 = e5.searchInfo.cd[0].trace).selectedpoints.length === e5.pointNumbers.length) {
                for (i3 = 0; i3 < e5.pointNumbers.length; i3++)
                  if (n4.selectedpoints.indexOf(e5.pointNumbers[i3]) < 0)
                    return false;
                return true;
              }
              return false;
            }(s2, _2) : function(t4) {
              var e5, r5, n4 = 0;
              for (r5 = 0; r5 < t4.length; r5++)
                if ((e5 = t4[r5].cd[0].trace).selectedpoints) {
                  if (e5.selectedpoints.length > 1)
                    return false;
                  if ((n4 += e5.selectedpoints.length) > 1)
                    return false;
                }
              return 1 === n4;
            }(s2) && (h3 = J(_2))) {
              for (o2 && o2.remove(), g3 = 0; g3 < s2.length; g3++)
                (l3 = s2[g3])._module.selectPoints(l3, false);
              $(e4, s2), Y(a2), x2 && ht(e4);
            } else {
              for (p3 = t3.shiftKey && (void 0 !== h3 ? h3 : J(_2)), u3 = function(t4, e5, r5) {
                return { pointNumber: t4, searchInfo: e5, subtract: !!r5 };
              }(_2.pointNumber, _2.searchInfo, p3), c3 = G2(a2.selectionDefs.concat([u3])), g3 = 0; g3 < s2.length; g3++)
                if (f3 = tt2(s2[g3]._module.selectPoints(s2[g3], c3), s2[g3]), b3.length)
                  for (var w3 = 0; w3 < f3.length; w3++)
                    b3.push(f3[w3]);
                else
                  b3 = f3;
              if ($(e4, s2, v3 = { points: b3 }), u3 && a2 && a2.selectionDefs.push(u3), o2) {
                var T2 = a2.mergedPolygons, k3 = d2(a2.dragmode);
                m2(et(T2, k3), o2, a2);
              }
              x2 && ft(e4, v3);
            }
          }
        }
        function q2(t3) {
          return "pointNumber" in t3 && "searchInfo" in t3;
        }
        function H2(t3) {
          return { xmin: 0, xmax: 0, ymin: 0, ymax: 0, pts: [], contains: function(e4, r4, n3, i2) {
            var a2 = t3.searchInfo.cd[0].trace._expandedIndex;
            return i2.cd[0].trace._expandedIndex === a2 && n3 === t3.pointNumber;
          }, isRect: false, degenerate: false, subtract: !!t3.subtract };
        }
        function G2(t3) {
          if (t3.length) {
            for (var e4 = [], r4 = q2(t3[0]) ? 0 : t3[0][0][0], n3 = r4, i2 = q2(t3[0]) ? 0 : t3[0][0][1], a2 = i2, o2 = 0; o2 < t3.length; o2++)
              if (q2(t3[o2]))
                e4.push(H2(t3[o2]));
              else {
                var s2 = R(t3[o2]);
                s2.subtract = !!t3[o2].subtract, e4.push(s2), r4 = Math.min(r4, s2.xmin), n3 = Math.max(n3, s2.xmax), i2 = Math.min(i2, s2.ymin), a2 = Math.max(a2, s2.ymax);
              }
            return { xmin: r4, xmax: n3, ymin: i2, ymax: a2, pts: [], contains: function(t4, r5, n4, i3) {
              for (var a3 = false, o3 = 0; o3 < e4.length; o3++)
                e4[o3].contains(t4, r5, n4, i3) && (a3 = !e4[o3].subtract);
              return a3;
            }, isRect: false, degenerate: false };
          }
        }
        function W(t3, e4, r4) {
          var n3 = e4._fullLayout, i2 = r4.plotinfo, a2 = r4.dragmode, o2 = n3._lastSelectedSubplot && n3._lastSelectedSubplot === i2.id, s2 = (t3.shiftKey || t3.altKey) && !(p2(a2) && d2(a2));
          o2 && s2 && i2.selection && i2.selection.selectionDefs && !r4.selectionDefs ? (r4.selectionDefs = i2.selection.selectionDefs, r4.mergedPolygons = i2.selection.mergedPolygons) : s2 && i2.selection || Y(r4), o2 || (x(e4), n3._lastSelectedSubplot = i2.id);
        }
        function Y(t3, e4) {
          var r4 = t3.dragmode, n3 = t3.plotinfo, i2 = t3.gd;
          (function(t4) {
            return t4._fullLayout._activeShapeIndex >= 0;
          })(i2) && i2._fullLayout._deactivateShape(i2), function(t4) {
            return t4._fullLayout._activeSelectionIndex >= 0;
          }(i2) && i2._fullLayout._deactivateSelection(i2);
          var o2 = i2._fullLayout._zoomlayer, s2 = p2(r4), l3 = v2(r4);
          if (s2 || l3) {
            var u3, c3, f3 = o2.selectAll(".select-outline-" + n3.id);
            f3 && i2._fullLayout._outlining && (s2 && (u3 = T(f3, t3)), u3 && a.call("_guiRelayout", i2, { shapes: u3 }), l3 && !U(t3) && (c3 = k2(f3, t3)), c3 && (i2._fullLayout._noEmitSelectedAtStart = true, a.call("_guiRelayout", i2, { selections: c3 }).then(function() {
              e4 && A2(i2);
            })), i2._fullLayout._outlining = false);
          }
          n3.selection = {}, n3.selection.selectionDefs = t3.selectionDefs = [], n3.selection.mergedPolygons = t3.mergedPolygons = [];
        }
        function X(t3) {
          return t3._id;
        }
        function Z(t3, e4, r4, n3) {
          if (!t3.calcdata)
            return [];
          var i2, a2, o2, s2 = [], l3 = e4.map(X), u3 = r4.map(X);
          for (o2 = 0; o2 < t3.calcdata.length; o2++)
            if (true === (a2 = (i2 = t3.calcdata[o2])[0].trace).visible && a2._module && a2._module.selectPoints)
              if (!U({ subplot: n3 }) || a2.subplot !== n3 && a2.geo !== n3)
                if ("splom" === a2.type) {
                  if (a2._xaxes[l3[0]] && a2._yaxes[u3[0]]) {
                    var c3 = K(a2._module, i2, e4[0], r4[0]);
                    c3.scene = t3._fullLayout._splomScenes[a2.uid], s2.push(c3);
                  }
                } else if ("sankey" === a2.type) {
                  var f3 = K(a2._module, i2, e4[0], r4[0]);
                  s2.push(f3);
                } else {
                  if (!(-1 !== l3.indexOf(a2.xaxis) || a2._xA && a2._xA.overlaying))
                    continue;
                  if (!(-1 !== u3.indexOf(a2.yaxis) || a2._yA && a2._yA.overlaying))
                    continue;
                  s2.push(K(a2._module, i2, C2(t3, a2.xaxis), C2(t3, a2.yaxis)));
                }
              else
                s2.push(K(a2._module, i2, e4[0], r4[0]));
          return s2;
        }
        function K(t3, e4, r4, n3) {
          return { _module: t3, cd: e4, xaxis: r4, yaxis: n3 };
        }
        function J(t3) {
          var e4 = t3.searchInfo.cd[0].trace, r4 = t3.pointNumber, n3 = t3.pointNumbers, i2 = n3.length > 0 ? n3[0] : r4;
          return !!e4.selectedpoints && e4.selectedpoints.indexOf(i2) > -1;
        }
        function $(t3, e4, r4) {
          var n3, i2;
          for (n3 = 0; n3 < e4.length; n3++) {
            var o2 = e4[n3].cd[0].trace._fullInput, s2 = t3._fullLayout._tracePreGUI[o2.uid] || {};
            void 0 === s2.selectedpoints && (s2.selectedpoints = o2._input.selectedpoints || null);
          }
          if (r4) {
            var l3 = r4.points || [];
            for (n3 = 0; n3 < e4.length; n3++)
              (i2 = e4[n3].cd[0].trace)._input.selectedpoints = i2._fullInput.selectedpoints = [], i2._fullInput !== i2 && (i2.selectedpoints = []);
            for (var u3 = 0; u3 < l3.length; u3++) {
              var c3 = l3[u3], f3 = c3.data, h3 = c3.fullData, p3 = c3.pointIndex, d3 = c3.pointIndices;
              d3 ? ([].push.apply(f3.selectedpoints, d3), i2._fullInput !== i2 && [].push.apply(h3.selectedpoints, d3)) : (f3.selectedpoints.push(p3), i2._fullInput !== i2 && h3.selectedpoints.push(p3));
            }
          } else
            for (n3 = 0; n3 < e4.length; n3++)
              delete (i2 = e4[n3].cd[0].trace).selectedpoints, delete i2._input.selectedpoints, i2._fullInput !== i2 && delete i2._fullInput.selectedpoints;
          !function(t4, e5) {
            for (var r5 = false, n4 = 0; n4 < e5.length; n4++) {
              var i3 = e5[n4], o3 = i3.cd;
              a.traceIs(o3[0].trace, "regl") && (r5 = true);
              var s3 = i3._module, l4 = s3.styleOnSelect || s3.style;
              l4 && (l4(t4, o3, o3[0].node3), o3[0].nodeRangePlot3 && l4(t4, o3, o3[0].nodeRangePlot3));
            }
            r5 && (P(t4), O(t4));
          }(t3, e4);
        }
        function Q(t3, e4, r4) {
          for (var i2 = (r4 ? n2.difference : n2.union)({ regions: t3 }, { regions: [e4] }).regions.reverse(), a2 = 0; a2 < i2.length; a2++) {
            var o2 = i2[a2];
            o2.subtract = st(o2, i2.slice(0, a2));
          }
          return i2;
        }
        function tt2(t3, e4) {
          if (Array.isArray(t3))
            for (var r4 = e4.cd, n3 = e4.cd[0].trace, i2 = 0; i2 < t3.length; i2++)
              t3[i2] = u2(t3[i2], n3, r4);
          return t3;
        }
        function et(t3, e4) {
          for (var r4 = [], n3 = 0; n3 < t3.length; n3++) {
            r4[n3] = [];
            for (var i2 = 0; i2 < t3[n3].length; i2++) {
              r4[n3][i2] = [], r4[n3][i2][0] = i2 ? "L" : "M";
              for (var a2 = 0; a2 < t3[n3][i2].length; a2++)
                r4[n3][i2].push(t3[n3][i2][a2]);
            }
            e4 || r4[n3].push(["Z", r4[n3][0][1], r4[n3][0][2]]);
          }
          return r4;
        }
        function rt(t3, e4) {
          for (var r4, n3, i2 = [], a2 = [], o2 = 0; o2 < e4.length; o2++) {
            var s2 = e4[o2];
            n3 = s2._module.selectPoints(s2, t3), a2.push(n3), r4 = tt2(n3, s2), i2 = i2.concat(r4);
          }
          return i2;
        }
        function nt(t3, e4, r4, n3, i2) {
          var a2, o2, s2, l3 = !!n3;
          i2 && (a2 = i2.plotinfo, o2 = i2.xaxes[0]._id, s2 = i2.yaxes[0]._id);
          var u3 = [], c3 = [], f3 = ot(t3), h3 = t3._fullLayout;
          if (a2) {
            var d3 = h3._zoomlayer, g3 = h3.dragmode, y3 = p2(g3), m3 = v2(g3);
            if (y3 || m3) {
              var x2 = C2(t3, o2, "x"), b3 = C2(t3, s2, "y");
              if (x2 && b3) {
                var _2 = d3.selectAll(".select-outline-" + a2.id);
                if (_2 && t3._fullLayout._outlining && _2.length) {
                  for (var T2 = _2[0][0].getAttribute("d"), k3 = w2(T2, t3, a2), A3 = [], M2 = 0; M2 < k3.length; M2++) {
                    for (var S2 = k3[M2], E3 = [], L2 = 0; L2 < S2.length; L2++)
                      E3.push([lt(x2, S2[L2][1]), lt(b3, S2[L2][2])]);
                    E3.xref = o2, E3.yref = s2, E3.subtract = st(E3, A3), A3.push(E3);
                  }
                  f3 = f3.concat(A3);
                }
              }
            }
          }
          var P2 = o2 && s2 ? [o2 + s2] : h3._subplots.cartesian;
          !function(t4) {
            var e5 = t4.calcdata;
            if (e5)
              for (var r5 = 0; r5 < e5.length; r5++) {
                var n4 = e5[r5][0].trace, i3 = t4._fullLayout._splomScenes;
                if (i3) {
                  var a3 = i3[n4.uid];
                  a3 && (a3.selectBatch = []);
                }
              }
          }(t3);
          for (var O2 = {}, I3 = 0; I3 < P2.length; I3++) {
            var D3 = P2[I3], z3 = D3.indexOf("y"), R2 = D3.slice(0, z3), F3 = D3.slice(z3), B3 = o2 && s2 ? r4 : void 0;
            if (B3 = at(f3, R2, F3, B3)) {
              var N2 = n3;
              if (!l3) {
                var j2 = C2(t3, R2, "x"), U2 = C2(t3, F3, "y");
                N2 = Z(t3, [j2], [U2], D3);
                for (var V2 = 0; V2 < N2.length; V2++) {
                  var q3 = N2[V2], H3 = q3.cd[0], G3 = H3.trace;
                  if ("scattergl" === q3._module.name && !H3.t.xpx) {
                    var W2 = G3.x, Y2 = G3.y, X2 = G3._length;
                    H3.t.xpx = [], H3.t.ypx = [];
                    for (var K2 = 0; K2 < X2; K2++)
                      H3.t.xpx[K2] = j2.c2p(W2[K2]), H3.t.ypx[K2] = U2.c2p(Y2[K2]);
                  }
                  "splom" === q3._module.name && (O2[G3.uid] || (O2[G3.uid] = true));
                }
              }
              var J2 = rt(B3, N2);
              u3 = u3.concat(J2), c3 = c3.concat(N2);
            }
          }
          var Q2 = { points: u3 };
          $(t3, c3, Q2);
          var tt3 = h3.clickmode.indexOf("event") > -1 && e4;
          if (!a2 && e4) {
            var et2 = ot(t3, true);
            if (et2.length) {
              var nt2 = et2[0].xref, pt = et2[0].yref;
              if (nt2 && pt) {
                var dt = ut(et2);
                ct([C2(t3, nt2, "x"), C2(t3, pt, "y")])(Q2, dt);
              }
            }
            t3._fullLayout._noEmitSelectedAtStart ? t3._fullLayout._noEmitSelectedAtStart = false : tt3 && ft(t3, Q2), h3._reselect = false;
          }
          if (!a2 && h3._deselect) {
            var vt = h3._deselect;
            (function(t4, e5, r5) {
              for (var n4 = 0; n4 < r5.length; n4++) {
                var i3 = r5[n4];
                if (i3.xaxis && i3.xaxis._id === t4 && i3.yaxis && i3.yaxis._id === e5)
                  return true;
              }
              return false;
            })(o2 = vt.xref, s2 = vt.yref, c3) || it(t3, o2, s2, n3), tt3 && (Q2.points.length ? ft(t3, Q2) : ht(t3)), h3._deselect = false;
          }
          return { eventData: Q2, selectionTesters: r4 };
        }
        function it(t3, e4, r4, n3) {
          n3 = Z(t3, [C2(t3, e4, "x")], [C2(t3, r4, "y")], e4 + r4);
          for (var i2 = 0; i2 < n3.length; i2++) {
            var a2 = n3[i2];
            a2._module.selectPoints(a2, false);
          }
          $(t3, n3);
        }
        function at(t3, e4, r4, n3) {
          for (var i2, a2 = 0; a2 < t3.length; a2++) {
            var o2 = t3[a2];
            e4 === o2.xref && r4 === o2.yref && (i2 ? n3 = G2(i2 = Q(i2, o2, !!o2.subtract)) : (i2 = [o2], n3 = R(o2)));
          }
          return n3;
        }
        function ot(t3, e4) {
          for (var r4 = [], n3 = t3._fullLayout, i2 = n3.selections, a2 = i2.length, o2 = 0; o2 < a2; o2++)
            if (!e4 || o2 === n3._activeSelectionIndex) {
              var s2 = i2[o2];
              if (s2) {
                var l3, u3, c3, f3, h3, p3 = s2.xref, d3 = s2.yref, v3 = C2(t3, p3, "x"), m3 = C2(t3, d3, "y");
                if ("rect" === s2.type) {
                  h3 = [];
                  var x2 = lt(v3, s2.x0), b3 = lt(v3, s2.x1), _2 = lt(m3, s2.y0), w3 = lt(m3, s2.y1);
                  h3 = [[x2, _2], [x2, w3], [b3, w3], [b3, _2]], l3 = Math.min(x2, b3), u3 = Math.max(x2, b3), c3 = Math.min(_2, w3), f3 = Math.max(_2, w3), h3.xmin = l3, h3.xmax = u3, h3.ymin = c3, h3.ymax = f3, h3.xref = p3, h3.yref = d3, h3.subtract = false, h3.isRect = true, r4.push(h3);
                } else if ("path" === s2.type)
                  for (var T2 = s2.path.split("Z"), k3 = [], A3 = 0; A3 < T2.length; A3++) {
                    var M2 = T2[A3];
                    if (M2) {
                      M2 += "Z";
                      var S2 = g2.extractPathCoords(M2, y2.paramIsX, "raw"), E3 = g2.extractPathCoords(M2, y2.paramIsY, "raw");
                      l3 = 1 / 0, u3 = -1 / 0, c3 = 1 / 0, f3 = -1 / 0, h3 = [];
                      for (var L2 = 0; L2 < S2.length; L2++) {
                        var P2 = lt(v3, S2[L2]), O2 = lt(m3, E3[L2]);
                        h3.push([P2, O2]), l3 = Math.min(P2, l3), u3 = Math.max(P2, u3), c3 = Math.min(O2, c3), f3 = Math.max(O2, f3);
                      }
                      h3.xmin = l3, h3.xmax = u3, h3.ymin = c3, h3.ymax = f3, h3.xref = p3, h3.yref = d3, h3.subtract = st(h3, k3), k3.push(h3), r4.push(h3);
                    }
                  }
              }
            }
          return r4;
        }
        function st(t3, e4) {
          for (var r4 = false, n3 = 0; n3 < e4.length; n3++)
            for (var a2 = e4[n3], o2 = 0; o2 < t3.length; o2++)
              if (i(t3[o2], a2)) {
                r4 = !r4;
                break;
              }
          return r4;
        }
        function lt(t3, e4) {
          return "date" === t3.type && (e4 = e4.replace("_", " ")), "log" === t3.type ? t3.c2p(e4) : t3.r2p(e4, null, t3.calendar);
        }
        function ut(t3) {
          for (var e4 = t3.length, r4 = [], n3 = 0; n3 < e4; n3++) {
            var i2 = t3[n3];
            r4 = (r4 = r4.concat(i2)).concat([i2[0]]);
          }
          return (a2 = r4).isRect = 5 === a2.length && a2[0][0] === a2[4][0] && a2[0][1] === a2[4][1] && a2[0][0] === a2[1][0] && a2[2][0] === a2[3][0] && a2[0][1] === a2[3][1] && a2[1][1] === a2[2][1] || a2[0][1] === a2[1][1] && a2[2][1] === a2[3][1] && a2[0][0] === a2[3][0] && a2[1][0] === a2[2][0], a2.isRect && (a2.xmin = Math.min(a2[0][0], a2[2][0]), a2.xmax = Math.max(a2[0][0], a2[2][0]), a2.ymin = Math.min(a2[0][1], a2[2][1]), a2.ymax = Math.max(a2[0][1], a2[2][1])), a2;
          var a2;
        }
        function ct(t3) {
          return function(e4, r4) {
            for (var n3, i2, a2 = 0; a2 < t3.length; a2++) {
              var o2 = t3[a2], s2 = o2._id, l3 = s2.charAt(0);
              if (r4.isRect) {
                n3 || (n3 = {});
                var u3 = r4[l3 + "min"], c3 = r4[l3 + "max"];
                void 0 !== u3 && void 0 !== c3 && (n3[s2] = [B2(o2, u3), B2(o2, c3)].sort(S));
              } else
                i2 || (i2 = {}), i2[s2] = r4.map(N(o2));
            }
            n3 && (e4.range = n3), i2 && (e4.lassoPoints = i2);
          };
        }
        function ft(t3, e4) {
          e4 && (e4.selections = (t3.layout || {}).selections || []), t3.emit("plotly_selected", e4);
        }
        function ht(t3) {
          t3.emit("plotly_deselect", null);
        }
        t2.exports = { reselect: nt, prepSelect: function(t3, e4, r4, n3, i2) {
          var u3 = !U(n3), c3 = f2(i2), g3 = h2(i2), y3 = d2(i2), x2 = p2(i2), b3 = v2(i2), w3 = "drawcircle" === i2, T2 = "drawline" === i2 || w3, k3 = n3.gd, A3 = k3._fullLayout, S2 = b3 && "immediate" === A3.newselection.mode && u3, E3 = A3._zoomlayer, C3 = n3.element.getBoundingClientRect(), P2 = n3.plotinfo, O2 = j(P2), F3 = e4 - C3.left, B3 = r4 - C3.top;
          A3._calcInverseTransform(k3);
          var N2 = M.apply3DTransform(A3._invTransform)(F3, B3);
          F3 = N2[0], B3 = N2[1];
          var q3, H3, X2, K2, J2, tt3, at2, ot2 = A3._invScaleX, st2 = A3._invScaleY, lt2 = F3, pt = B3, dt = "M" + F3 + "," + B3, vt = n3.xaxes[0], gt = n3.yaxes[0], yt = vt._length, mt = gt._length, xt = t3.altKey && !(p2(i2) && y3);
          W(t3, k3, n3), c3 && (q3 = z2([[F3, B3]], I2.BENDPX));
          var bt = E3.selectAll("path.select-outline-" + P2.id).data([1]), _t = x2 ? A3.newshape : A3.newselection;
          x2 && (n3.hasText = _t.label.text || _t.label.texttemplate);
          var wt = x2 && !y3 ? _t.fillcolor : "rgba(0,0,0,0)", Tt = _t.line.color || (u3 ? s.contrast(k3._fullLayout.plot_bgcolor) : "#7f7f7f");
          bt.enter().append("path").attr("class", "select-outline select-outline-" + P2.id).style({ opacity: x2 ? _t.opacity / 2 : 1, "stroke-dasharray": o(_t.line.dash, _t.line.width), "stroke-width": _t.line.width + "px", "shape-rendering": "crispEdges" }).call(s.stroke, Tt).call(s.fill, wt).attr("fill-rule", "evenodd").classed("cursor-move", !!x2).attr("transform", O2).attr("d", dt + "Z");
          var kt = E3.append("path").attr("class", "zoombox-corners").style({ fill: s.background, stroke: s.defaultLine, "stroke-width": 1 }).attr("transform", O2).attr("d", "M0,0Z");
          if (x2 && n3.hasText) {
            var At = E3.select(".label-temp");
            At.empty() && (At = E3.append("g").classed("label-temp", true).classed("select-outline", true).style({ opacity: 0.8 }));
          }
          var Mt = A3._uid + I2.SELECTID, St = [], Et = Z(k3, n3.xaxes, n3.yaxes, n3.subplot);
          S2 && !t3.shiftKey && (n3._clearSubplotSelections = function() {
            if (u3) {
              var t4 = vt._id, e5 = gt._id;
              it(k3, t4, e5, Et);
              for (var r5 = (k3.layout || {}).selections || [], n4 = [], i3 = false, o2 = 0; o2 < r5.length; o2++) {
                var s2 = A3.selections[o2];
                s2.xref !== t4 || s2.yref !== e5 ? n4.push(r5[o2]) : i3 = true;
              }
              i3 && (k3._fullLayout._noEmitSelectedAtStart = true, a.call("_guiRelayout", k3, { selections: n4 }));
            }
          });
          var Lt = function(t4) {
            return t4.plotinfo.fillRangeItems || ct(t4.xaxes.concat(t4.yaxes));
          }(n3);
          n3.moveFn = function(t4, e5) {
            n3._clearSubplotSelections && (n3._clearSubplotSelections(), n3._clearSubplotSelections = void 0), lt2 = Math.max(0, Math.min(yt, ot2 * t4 + F3)), pt = Math.max(0, Math.min(mt, st2 * e5 + B3));
            var r5 = Math.abs(lt2 - F3), i3 = Math.abs(pt - B3);
            if (g3) {
              var a2, o2, s2;
              if (b3) {
                var l3 = A3.selectdirection;
                switch (a2 = "any" === l3 ? i3 < Math.min(0.6 * r5, D2) ? "h" : r5 < Math.min(0.6 * i3, D2) ? "v" : "d" : l3) {
                  case "h":
                    o2 = w3 ? mt / 2 : 0, s2 = mt;
                    break;
                  case "v":
                    o2 = w3 ? yt / 2 : 0, s2 = yt;
                }
              }
              if (x2)
                switch (A3.newshape.drawdirection) {
                  case "vertical":
                    a2 = "h", o2 = w3 ? mt / 2 : 0, s2 = mt;
                    break;
                  case "horizontal":
                    a2 = "v", o2 = w3 ? yt / 2 : 0, s2 = yt;
                    break;
                  case "ortho":
                    r5 < i3 ? (a2 = "h", o2 = B3, s2 = pt) : (a2 = "v", o2 = F3, s2 = lt2);
                    break;
                  default:
                    a2 = "d";
                }
              "h" === a2 ? ((K2 = T2 ? _(w3, [lt2, o2], [lt2, s2]) : [[F3, o2], [F3, s2], [lt2, s2], [lt2, o2]]).xmin = T2 ? lt2 : Math.min(F3, lt2), K2.xmax = T2 ? lt2 : Math.max(F3, lt2), K2.ymin = Math.min(o2, s2), K2.ymax = Math.max(o2, s2), kt.attr("d", "M" + K2.xmin + "," + (B3 - D2) + "h-4v" + 2 * D2 + "h4ZM" + (K2.xmax - 1) + "," + (B3 - D2) + "h4v" + 2 * D2 + "h-4Z")) : "v" === a2 ? ((K2 = T2 ? _(w3, [o2, pt], [s2, pt]) : [[o2, B3], [o2, pt], [s2, pt], [s2, B3]]).xmin = Math.min(o2, s2), K2.xmax = Math.max(o2, s2), K2.ymin = T2 ? pt : Math.min(B3, pt), K2.ymax = T2 ? pt : Math.max(B3, pt), kt.attr("d", "M" + (F3 - D2) + "," + K2.ymin + "v-4h" + 2 * D2 + "v4ZM" + (F3 - D2) + "," + (K2.ymax - 1) + "v4h" + 2 * D2 + "v-4Z")) : "d" === a2 && ((K2 = T2 ? _(w3, [F3, B3], [lt2, pt]) : [[F3, B3], [F3, pt], [lt2, pt], [lt2, B3]]).xmin = Math.min(F3, lt2), K2.xmax = Math.max(F3, lt2), K2.ymin = Math.min(B3, pt), K2.ymax = Math.max(B3, pt), kt.attr("d", "M0,0Z"));
            } else
              c3 && (q3.addPt([lt2, pt]), K2 = q3.filtered);
            if (n3.selectionDefs && n3.selectionDefs.length ? (X2 = Q(n3.mergedPolygons, K2, xt), K2.subtract = xt, H3 = G2(n3.selectionDefs.concat([K2]))) : (X2 = [K2], H3 = R(K2)), m2(et(X2, y3), bt, n3), b3) {
              var u4, f3 = nt(k3, false), h3 = f3.eventData ? f3.eventData.points.slice() : [];
              f3 = nt(k3, false, H3, Et, n3), H3 = f3.selectionTesters, at2 = f3.eventData, u4 = q3 ? q3.filtered : ut(X2), L.throttle(Mt, I2.SELECTDELAY, function() {
                for (var t5 = (St = rt(H3, Et)).slice(), e6 = 0; e6 < h3.length; e6++) {
                  for (var r6 = h3[e6], n4 = false, i4 = 0; i4 < t5.length; i4++)
                    if (t5[i4].curveNumber === r6.curveNumber && t5[i4].pointNumber === r6.pointNumber) {
                      n4 = true;
                      break;
                    }
                  n4 || t5.push(r6);
                }
                t5.length && (at2 || (at2 = {}), at2.points = t5), Lt(at2, u4), function(t6, e7) {
                  t6.emit("plotly_selecting", e7);
                }(k3, at2);
              });
            }
          }, n3.clickFn = function(t4, e5) {
            if (kt.remove(), k3._fullLayout._activeShapeIndex >= 0)
              k3._fullLayout._deactivateShape(k3);
            else if (!x2) {
              var r5 = A3.clickmode;
              L.done(Mt).then(function() {
                if (L.clear(Mt), 2 === t4) {
                  for (bt.remove(), J2 = 0; J2 < Et.length; J2++)
                    (tt3 = Et[J2])._module.selectPoints(tt3, false);
                  if ($(k3, Et), Y(n3), ht(k3), Et.length) {
                    var i3 = Et[0].xaxis, o2 = Et[0].yaxis;
                    if (i3 && o2) {
                      for (var s2 = [], u4 = k3._fullLayout.selections, c4 = 0; c4 < u4.length; c4++) {
                        var f3 = u4[c4];
                        f3 && (f3.xref === i3._id && f3.yref === o2._id || s2.push(f3));
                      }
                      s2.length < u4.length && (k3._fullLayout._noEmitSelectedAtStart = true, a.call("_guiRelayout", k3, { selections: s2 }));
                    }
                  }
                } else
                  r5.indexOf("select") > -1 && V(e5, k3, n3.xaxes, n3.yaxes, n3.subplot, n3, bt), "event" === r5 && ft(k3, void 0);
                l2.click(k3, e5, P2.id);
              }).catch(M.error);
            }
          }, n3.doneFn = function() {
            kt.remove(), L.done(Mt).then(function() {
              L.clear(Mt), !S2 && K2 && n3.selectionDefs && (K2.subtract = xt, n3.selectionDefs.push(K2), n3.mergedPolygons.length = 0, [].push.apply(n3.mergedPolygons, X2)), (S2 || x2) && Y(n3, S2), n3.doneFnCompleted && n3.doneFnCompleted(St), b3 && ft(k3, at2);
            }).catch(M.error);
          };
        }, clearOutline: x, clearSelectionsCache: Y, selectOnClick: V };
      }, 46056: function(t2, e3, r3) {
        var n2 = r3(13916), i = r3(25376), a = r3(52904).line, o = r3(98192).u, s = r3(92880).extendFlat, l2 = r3(31780).templatedArray, u2 = (r3(36208), r3(45464)), c2 = r3(21776).ye, f2 = r3(97728);
        t2.exports = l2("shape", { visible: s({}, u2.visible, { editType: "calc+arraydraw" }), showlegend: { valType: "boolean", dflt: false, editType: "calc+arraydraw" }, legend: s({}, u2.legend, { editType: "calc+arraydraw" }), legendgroup: s({}, u2.legendgroup, { editType: "calc+arraydraw" }), legendgrouptitle: { text: s({}, u2.legendgrouptitle.text, { editType: "calc+arraydraw" }), font: i({ editType: "calc+arraydraw" }), editType: "calc+arraydraw" }, legendrank: s({}, u2.legendrank, { editType: "calc+arraydraw" }), legendwidth: s({}, u2.legendwidth, { editType: "calc+arraydraw" }), type: { valType: "enumerated", values: ["circle", "rect", "path", "line"], editType: "calc+arraydraw" }, layer: { valType: "enumerated", values: ["below", "above"], dflt: "above", editType: "arraydraw" }, xref: s({}, n2.xref, {}), xsizemode: { valType: "enumerated", values: ["scaled", "pixel"], dflt: "scaled", editType: "calc+arraydraw" }, xanchor: { valType: "any", editType: "calc+arraydraw" }, x0: { valType: "any", editType: "calc+arraydraw" }, x1: { valType: "any", editType: "calc+arraydraw" }, yref: s({}, n2.yref, {}), ysizemode: { valType: "enumerated", values: ["scaled", "pixel"], dflt: "scaled", editType: "calc+arraydraw" }, yanchor: { valType: "any", editType: "calc+arraydraw" }, y0: { valType: "any", editType: "calc+arraydraw" }, y1: { valType: "any", editType: "calc+arraydraw" }, path: { valType: "string", editType: "calc+arraydraw" }, opacity: { valType: "number", min: 0, max: 1, dflt: 1, editType: "arraydraw" }, line: { color: s({}, a.color, { editType: "arraydraw" }), width: s({}, a.width, { editType: "calc+arraydraw" }), dash: s({}, o, { editType: "arraydraw" }), editType: "calc+arraydraw" }, fillcolor: { valType: "color", dflt: "rgba(0,0,0,0)", editType: "arraydraw" }, fillrule: { valType: "enumerated", values: ["evenodd", "nonzero"], dflt: "evenodd", editType: "arraydraw" }, editable: { valType: "boolean", dflt: false, editType: "calc+arraydraw" }, label: { text: { valType: "string", dflt: "", editType: "arraydraw" }, texttemplate: c2({}, { keys: Object.keys(f2) }), font: i({ editType: "calc+arraydraw", colorEditType: "arraydraw" }), textposition: { valType: "enumerated", values: ["top left", "top center", "top right", "middle left", "middle center", "middle right", "bottom left", "bottom center", "bottom right", "start", "middle", "end"], editType: "arraydraw" }, textangle: { valType: "angle", dflt: "auto", editType: "calc+arraydraw" }, xanchor: { valType: "enumerated", values: ["auto", "left", "center", "right"], dflt: "auto", editType: "calc+arraydraw" }, yanchor: { valType: "enumerated", values: ["top", "middle", "bottom"], editType: "calc+arraydraw" }, padding: { valType: "number", dflt: 3, min: 0, editType: "arraydraw" }, editType: "arraydraw" }, editType: "arraydraw" });
      }, 96084: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(54460), a = r3(85448), o = r3(65152);
        function s(t3) {
          return u2(t3.line.width, t3.xsizemode, t3.x0, t3.x1, t3.path, false);
        }
        function l2(t3) {
          return u2(t3.line.width, t3.ysizemode, t3.y0, t3.y1, t3.path, true);
        }
        function u2(t3, e4, r4, i2, s2, l3) {
          var u3 = t3 / 2, c3 = l3;
          if ("pixel" === e4) {
            var f2 = s2 ? o.extractPathCoords(s2, l3 ? a.paramIsY : a.paramIsX) : [r4, i2], h2 = n2.aggNums(Math.max, null, f2), p2 = n2.aggNums(Math.min, null, f2), d2 = p2 < 0 ? Math.abs(p2) + u3 : u3, v2 = h2 > 0 ? h2 + u3 : u3;
            return { ppad: u3, ppadplus: c3 ? d2 : v2, ppadminus: c3 ? v2 : d2 };
          }
          return { ppad: u3 };
        }
        function c2(t3, e4, r4, n3, i2) {
          var s2 = "category" === t3.type || "multicategory" === t3.type ? t3.r2c : t3.d2c;
          if (void 0 !== e4)
            return [s2(e4), s2(r4)];
          if (n3) {
            var l3, u3, c3, f2, h2 = 1 / 0, p2 = -1 / 0, d2 = n3.match(a.segmentRE);
            for ("date" === t3.type && (s2 = o.decodeDate(s2)), l3 = 0; l3 < d2.length; l3++)
              void 0 !== (u3 = i2[d2[l3].charAt(0)].drawn) && (!(c3 = d2[l3].substr(1).match(a.paramRE)) || c3.length < u3 || ((f2 = s2(c3[u3])) < h2 && (h2 = f2), f2 > p2 && (p2 = f2)));
            return p2 >= h2 ? [h2, p2] : void 0;
          }
        }
        t2.exports = function(t3) {
          var e4 = t3._fullLayout, r4 = n2.filterVisible(e4.shapes);
          if (r4.length && t3._fullData.length)
            for (var o2 = 0; o2 < r4.length; o2++) {
              var u3, f2, h2 = r4[o2];
              h2._extremes = {};
              var p2 = i.getRefType(h2.xref), d2 = i.getRefType(h2.yref);
              if ("paper" !== h2.xref && "domain" !== p2) {
                var v2 = "pixel" === h2.xsizemode ? h2.xanchor : h2.x0, g2 = "pixel" === h2.xsizemode ? h2.xanchor : h2.x1;
                (f2 = c2(u3 = i.getFromId(t3, h2.xref), v2, g2, h2.path, a.paramIsX)) && (h2._extremes[u3._id] = i.findExtremes(u3, f2, s(h2)));
              }
              if ("paper" !== h2.yref && "domain" !== d2) {
                var y2 = "pixel" === h2.ysizemode ? h2.yanchor : h2.y0, m2 = "pixel" === h2.ysizemode ? h2.yanchor : h2.y1;
                (f2 = c2(u3 = i.getFromId(t3, h2.yref), y2, m2, h2.path, a.paramIsY)) && (h2._extremes[u3._id] = i.findExtremes(u3, f2, l2(h2)));
              }
            }
        };
      }, 85448: function(t2) {
        t2.exports = { segmentRE: /[MLHVQCTSZ][^MLHVQCTSZ]*/g, paramRE: /[^\s,]+/g, paramIsX: { M: { 0: true, drawn: 0 }, L: { 0: true, drawn: 0 }, H: { 0: true, drawn: 0 }, V: {}, Q: { 0: true, 2: true, drawn: 2 }, C: { 0: true, 2: true, 4: true, drawn: 4 }, T: { 0: true, drawn: 0 }, S: { 0: true, 2: true, drawn: 2 }, Z: {} }, paramIsY: { M: { 1: true, drawn: 1 }, L: { 1: true, drawn: 1 }, H: {}, V: { 0: true, drawn: 0 }, Q: { 1: true, 3: true, drawn: 3 }, C: { 1: true, 3: true, 5: true, drawn: 5 }, T: { 1: true, drawn: 1 }, S: { 1: true, 3: true, drawn: 5 }, Z: {} }, numParams: { M: 2, L: 2, H: 1, V: 1, Q: 4, C: 6, T: 2, S: 4, Z: 0 } };
      }, 43712: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(54460), a = r3(51272), o = r3(46056), s = r3(65152);
        function l2(t3, e4, r4) {
          function a2(r5, i2) {
            return n2.coerce(t3, e4, o, r5, i2);
          }
          if (e4._isShape = true, a2("visible")) {
            a2("showlegend") && (a2("legend"), a2("legendwidth"), a2("legendgroup"), a2("legendgrouptitle.text"), n2.coerceFont(a2, "legendgrouptitle.font"), a2("legendrank"));
            var l3 = a2("path"), u2 = a2("type", l3 ? "path" : "rect"), c2 = "path" !== u2;
            c2 && delete e4.path, a2("editable"), a2("layer"), a2("opacity"), a2("fillcolor"), a2("fillrule"), a2("line.width") && (a2("line.color"), a2("line.dash"));
            for (var f2 = a2("xsizemode"), h2 = a2("ysizemode"), p2 = ["x", "y"], d2 = 0; d2 < 2; d2++) {
              var v2, g2, y2, m2 = p2[d2], x = m2 + "anchor", b2 = "x" === m2 ? f2 : h2, _ = { _fullLayout: r4 }, w2 = i.coerceRef(t3, e4, _, m2, void 0, "paper");
              if ("range" === i.getRefType(w2) ? ((v2 = i.getFromId(_, w2))._shapeIndices.push(e4._index), y2 = s.rangeToShapePosition(v2), g2 = s.shapePositionToRange(v2)) : g2 = y2 = n2.identity, c2) {
                var T = m2 + "0", k2 = m2 + "1", A2 = t3[T], M = t3[k2];
                t3[T] = g2(t3[T], true), t3[k2] = g2(t3[k2], true), "pixel" === b2 ? (a2(T, 0), a2(k2, 10)) : (i.coercePosition(e4, _, a2, w2, T, 0.25), i.coercePosition(e4, _, a2, w2, k2, 0.75)), e4[T] = y2(e4[T]), e4[k2] = y2(e4[k2]), t3[T] = A2, t3[k2] = M;
              }
              if ("pixel" === b2) {
                var S = t3[x];
                t3[x] = g2(t3[x], true), i.coercePosition(e4, _, a2, w2, x, 0.25), e4[x] = y2(e4[x]), t3[x] = S;
              }
            }
            c2 && n2.noneOrAll(t3, e4, ["x0", "x1", "y0", "y1"]);
            var E2, L, C2 = "line" === u2;
            if (c2 && (E2 = a2("label.texttemplate")), E2 || (L = a2("label.text")), L || E2) {
              a2("label.textangle");
              var P = a2("label.textposition", C2 ? "middle" : "middle center");
              a2("label.xanchor"), a2("label.yanchor", function(t4, e5) {
                return t4 ? "bottom" : -1 !== e5.indexOf("top") ? "top" : -1 !== e5.indexOf("bottom") ? "bottom" : "middle";
              }(C2, P)), a2("label.padding"), n2.coerceFont(a2, "label.font", r4.font);
            }
          }
        }
        t2.exports = function(t3, e4) {
          a(t3, e4, { name: "shapes", handleItemDefaults: l2 });
        };
      }, 60728: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(54460), a = r3(72736), o = r3(43616), s = r3(9856).readPaths, l2 = r3(65152), u2 = l2.getPathString, c2 = r3(97728), f2 = r3(84284).FROM_TL;
        t2.exports = function(t3, e4, r4, h2) {
          if (h2.selectAll(".shape-label").remove(), r4.label.text || r4.label.texttemplate) {
            var p2;
            if (r4.label.texttemplate) {
              var d2 = {};
              if ("path" !== r4.type) {
                var v2 = i.getFromId(t3, r4.xref), g2 = i.getFromId(t3, r4.yref);
                for (var y2 in c2) {
                  var m2 = c2[y2](r4, v2, g2);
                  void 0 !== m2 && (d2[y2] = m2);
                }
              }
              p2 = n2.texttemplateStringForShapes(r4.label.texttemplate, {}, t3._fullLayout._d3locale, d2);
            } else
              p2 = r4.label.text;
            var x, b2, _, w2, T = { "data-index": e4 }, k2 = r4.label.font, A2 = h2.append("g").attr(T).classed("shape-label", true).append("text").attr({ "data-notex": 1 }).classed("shape-label-text", true).text(p2);
            if (r4.path) {
              var M = u2(t3, r4), S = s(M, t3);
              x = 1 / 0, _ = 1 / 0, b2 = -1 / 0, w2 = -1 / 0;
              for (var E2 = 0; E2 < S.length; E2++)
                for (var L = 0; L < S[E2].length; L++)
                  for (var C2 = S[E2][L], P = 1; P < C2.length; P += 2) {
                    var O = C2[P], I2 = C2[P + 1];
                    x = Math.min(x, O), b2 = Math.max(b2, O), _ = Math.min(_, I2), w2 = Math.max(w2, I2);
                  }
            } else {
              var D2 = i.getFromId(t3, r4.xref), z2 = i.getRefType(r4.xref), R = i.getFromId(t3, r4.yref), F2 = i.getRefType(r4.yref), B2 = l2.getDataToPixel(t3, D2, false, z2), N = l2.getDataToPixel(t3, R, true, F2);
              x = B2(r4.x0), b2 = B2(r4.x1), _ = N(r4.y0), w2 = N(r4.y1);
            }
            var j = r4.label.textangle;
            "auto" === j && (j = "line" === r4.type ? function(t4, e5, r5, n3) {
              var i2, a2;
              return a2 = Math.abs(r5 - t4), i2 = r5 >= t4 ? e5 - n3 : n3 - e5, -180 / Math.PI * Math.atan2(i2, a2);
            }(x, _, b2, w2) : 0), A2.call(function(e5) {
              return e5.call(o.font, k2).attr({}), a.convertToTspans(e5, t3), e5;
            });
            var U = function(t4, e5, r5, n3, i2, a2, o2) {
              var s2, l3, u3, c3, h3 = i2.label.textposition, p3 = i2.label.textangle, d3 = i2.label.padding, v3 = i2.type, g3 = Math.PI / 180 * a2, y3 = Math.sin(g3), m3 = Math.cos(g3), x2 = i2.label.xanchor, b3 = i2.label.yanchor;
              if ("line" === v3) {
                "start" === h3 ? (s2 = t4, l3 = e5) : "end" === h3 ? (s2 = r5, l3 = n3) : (s2 = (t4 + r5) / 2, l3 = (e5 + n3) / 2), "auto" === x2 && (x2 = "start" === h3 ? "auto" === p3 ? r5 > t4 ? "left" : r5 < t4 ? "right" : "center" : r5 > t4 ? "right" : r5 < t4 ? "left" : "center" : "end" === h3 ? "auto" === p3 ? r5 > t4 ? "right" : r5 < t4 ? "left" : "center" : r5 > t4 ? "left" : r5 < t4 ? "right" : "center" : "center");
                var _2 = { bottom: -1, middle: 0, top: 1 };
                if ("auto" === p3) {
                  var w3 = _2[b3];
                  u3 = -d3 * y3 * w3, c3 = d3 * m3 * w3;
                } else
                  u3 = d3 * { left: 1, center: 0, right: -1 }[x2], c3 = d3 * _2[b3];
                s2 += u3, l3 += c3;
              } else
                u3 = d3 + 3, -1 !== h3.indexOf("right") ? (s2 = Math.max(t4, r5) - u3, "auto" === x2 && (x2 = "right")) : -1 !== h3.indexOf("left") ? (s2 = Math.min(t4, r5) + u3, "auto" === x2 && (x2 = "left")) : (s2 = (t4 + r5) / 2, "auto" === x2 && (x2 = "center")), l3 = -1 !== h3.indexOf("top") ? Math.min(e5, n3) : -1 !== h3.indexOf("bottom") ? Math.max(e5, n3) : (e5 + n3) / 2, c3 = d3, "bottom" === b3 ? l3 -= c3 : "top" === b3 && (l3 += c3);
              var T2 = f2[b3], k3 = i2.label.font.size, A3 = o2.height;
              return { textx: s2 + (A3 * T2 - k3) * y3, texty: l3 + -(A3 * T2 - k3) * m3, xanchor: x2 };
            }(x, _, b2, w2, r4, j, o.bBox(A2.node())), V = U.textx, q2 = U.texty, H2 = U.xanchor;
            A2.attr({ "text-anchor": { left: "start", center: "middle", right: "end" }[H2], y: q2, x: V, transform: "rotate(" + j + "," + V + "," + q2 + ")" }).call(a.positionText, V, q2);
          }
        };
      }, 55496: function(t2, e3, r3) {
        var n2 = r3(3400).strTranslate, i = r3(86476), a = r3(72760), o = a.drawMode, s = a.selectMode, l2 = r3(24040), u2 = r3(76308), c2 = r3(7e3), f2 = c2.i000, h2 = c2.i090, p2 = c2.i180, d2 = c2.i270, v2 = r3(1936).clearOutlineControllers, g2 = r3(9856), y2 = g2.pointsOnRectangle, m2 = g2.pointsOnEllipse, x = g2.writePaths, b2 = r3(93940).newShapes, _ = r3(93940).createShapeObj, w2 = r3(5968), T = r3(60728);
        function k2(t3, e4) {
          var r4, n3, i2, a2 = t3[e4][1], o2 = t3[e4][2], s2 = t3.length;
          return n3 = t3[r4 = (e4 + 1) % s2][1], i2 = t3[r4][2], n3 === a2 && i2 === o2 && (n3 = t3[r4 = (e4 + 2) % s2][1], i2 = t3[r4][2]), [r4, n3, i2];
        }
        t2.exports = function t3(e4, r4, a2, c3) {
          c3 || (c3 = 0);
          var g3 = a2.gd;
          function A2() {
            t3(e4, r4, a2, c3++), (m2(e4[0]) || a2.hasText) && M({ redrawing: true });
          }
          function M(t4) {
            var e5 = {};
            void 0 !== a2.isActiveShape && (a2.isActiveShape = false, e5 = b2(r4, a2)), void 0 !== a2.isActiveSelection && (a2.isActiveSelection = false, e5 = w2(r4, a2), g3._fullLayout._reselect = true), Object.keys(e5).length && l2.call((t4 || {}).redrawing ? "relayout" : "_guiRelayout", g3, e5);
          }
          var S, E2, L, C2, P, O = g3._fullLayout._zoomlayer, I2 = a2.dragmode, D2 = o(I2), z2 = s(I2);
          if ((D2 || z2) && (g3._fullLayout._outlining = true), v2(g3), r4.attr("d", x(e4)), c3 || !a2.isActiveShape && !a2.isActiveSelection || (P = function(t4, e5) {
            for (var r5 = 0; r5 < e5.length; r5++) {
              var n3 = e5[r5];
              t4[r5] = [];
              for (var i2 = 0; i2 < n3.length; i2++) {
                t4[r5][i2] = [];
                for (var a3 = 0; a3 < n3[i2].length; a3++)
                  t4[r5][i2][a3] = n3[i2][a3];
              }
            }
            return t4;
          }([], e4), function(t4) {
            S = [];
            for (var r5 = 0; r5 < e4.length; r5++) {
              var o2 = e4[r5], s2 = y2(o2), l3 = !s2 && m2(o2);
              S[r5] = [];
              for (var c4 = o2.length, v3 = 0; v3 < c4; v3++)
                if ("Z" !== o2[v3][0] && (!l3 || v3 === f2 || v3 === h2 || v3 === p2 || v3 === d2)) {
                  var x2, b3 = s2 && a2.isActiveSelection;
                  b3 && (x2 = k2(o2, v3));
                  var _2 = o2[v3][1], w3 = o2[v3][2], T2 = t4.append(b3 ? "rect" : "circle").attr("data-i", r5).attr("data-j", v3).style({ fill: u2.background, stroke: u2.defaultLine, "stroke-width": 1, "shape-rendering": "crispEdges" });
                  if (b3) {
                    var A3 = x2[1] - _2, M2 = x2[2] - w3, E3 = M2 ? 5 : Math.max(Math.min(25, Math.abs(A3) - 5), 5), L2 = A3 ? 5 : Math.max(Math.min(25, Math.abs(M2) - 5), 5);
                    T2.classed(M2 ? "cursor-ew-resize" : "cursor-ns-resize", true).attr("width", E3).attr("height", L2).attr("x", _2 - E3 / 2).attr("y", w3 - L2 / 2).attr("transform", n2(A3 / 2, M2 / 2));
                  } else
                    T2.classed("cursor-grab", true).attr("r", 5).attr("cx", _2).attr("cy", w3);
                  S[r5][v3] = { element: T2.node(), gd: g3, prepFn: B2, doneFn: j, clickFn: U }, i.init(S[r5][v3]);
                }
            }
          }(O.append("g").attr("class", "outline-controllers")), function() {
            if (E2 = [], e4.length) {
              E2[0] = { element: r4[0][0], gd: g3, prepFn: q2, doneFn: H2, clickFn: G2 }, i.init(E2[0]);
            }
          }()), D2 && a2.hasText) {
            var R = O.select(".label-temp"), F2 = _(r4, a2, a2.dragmode);
            T(g3, "label-temp", F2, R);
          }
          function B2(t4) {
            L = +t4.srcElement.getAttribute("data-i"), C2 = +t4.srcElement.getAttribute("data-j"), S[L][C2].moveFn = N;
          }
          function N(t4, r5) {
            if (e4.length) {
              var n3 = P[L][C2][1], i2 = P[L][C2][2], o2 = e4[L], s2 = o2.length;
              if (y2(o2)) {
                var l3 = t4, u3 = r5;
                a2.isActiveSelection && (k2(o2, C2)[1] === o2[C2][1] ? u3 = 0 : l3 = 0);
                for (var c4 = 0; c4 < s2; c4++)
                  if (c4 !== C2) {
                    var f3 = o2[c4];
                    f3[1] === o2[C2][1] && (f3[1] = n3 + l3), f3[2] === o2[C2][2] && (f3[2] = i2 + u3);
                  }
                if (o2[C2][1] = n3 + l3, o2[C2][2] = i2 + u3, !y2(o2))
                  for (var h3 = 0; h3 < s2; h3++)
                    for (var p3 = 0; p3 < o2[h3].length; p3++)
                      o2[h3][p3] = P[L][h3][p3];
              } else
                o2[C2][1] = n3 + t4, o2[C2][2] = i2 + r5;
              A2();
            }
          }
          function j() {
            M();
          }
          function U(t4, r5) {
            if (2 === t4) {
              L = +r5.srcElement.getAttribute("data-i"), C2 = +r5.srcElement.getAttribute("data-j");
              var n3 = e4[L];
              y2(n3) || m2(n3) || function() {
                if (e4.length && e4[L] && e4[L].length) {
                  for (var t5 = [], r6 = 0; r6 < e4[L].length; r6++)
                    r6 !== C2 && t5.push(e4[L][r6]);
                  t5.length > 1 && (2 !== t5.length || "Z" !== t5[1][0]) && (0 === C2 && (t5[0][0] = "M"), e4[L] = t5, A2(), M());
                }
              }();
            }
          }
          function V(t4, r5) {
            !function(t5, r6) {
              if (e4.length)
                for (var n3 = 0; n3 < e4.length; n3++)
                  for (var i2 = 0; i2 < e4[n3].length; i2++)
                    for (var a3 = 0; a3 + 2 < e4[n3][i2].length; a3 += 2)
                      e4[n3][i2][a3 + 1] = P[n3][i2][a3 + 1] + t5, e4[n3][i2][a3 + 2] = P[n3][i2][a3 + 2] + r6;
            }(t4, r5), A2();
          }
          function q2(t4) {
            (L = +t4.srcElement.getAttribute("data-i")) || (L = 0), E2[L].moveFn = V;
          }
          function H2() {
            M();
          }
          function G2(t4) {
            2 === t4 && function(t5) {
              if (s(t5._fullLayout.dragmode)) {
                v2(t5);
                var e5 = t5._fullLayout._activeSelectionIndex, r5 = (t5.layout || {}).selections || [];
                if (e5 < r5.length) {
                  for (var n3 = [], i2 = 0; i2 < r5.length; i2++)
                    i2 !== e5 && n3.push(r5[i2]);
                  delete t5._fullLayout._activeSelectionIndex;
                  var a3 = t5._fullLayout.selections[e5];
                  t5._fullLayout._deselect = { xref: a3.xref, yref: a3.yref }, l2.call("_guiRelayout", t5, { selections: n3 });
                }
              }
            }(g3);
          }
        };
      }, 4016: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(24040), a = r3(3400), o = r3(54460), s = r3(9856).readPaths, l2 = r3(55496), u2 = r3(60728), c2 = r3(1936).clearOutlineControllers, f2 = r3(76308), h2 = r3(43616), p2 = r3(31780).arrayEditor, d2 = r3(86476), v2 = r3(93972), g2 = r3(85448), y2 = r3(65152), m2 = y2.getPathString;
        function x(t3) {
          var e4 = t3._fullLayout;
          for (var r4 in e4._shapeUpperLayer.selectAll("path").remove(), e4._shapeLowerLayer.selectAll("path").remove(), e4._shapeUpperLayer.selectAll("text").remove(), e4._shapeLowerLayer.selectAll("text").remove(), e4._plots) {
            var n3 = e4._plots[r4].shapelayer;
            n3 && (n3.selectAll("path").remove(), n3.selectAll("text").remove());
          }
          for (var i2 = 0; i2 < e4.shapes.length; i2++)
            true === e4.shapes[i2].visible && w2(t3, i2);
        }
        function b2(t3) {
          return !!t3._fullLayout._outlining;
        }
        function _(t3) {
          return !t3._context.edits.shapePosition;
        }
        function w2(t3, e4) {
          t3._fullLayout._paperdiv.selectAll('.shapelayer [data-index="' + e4 + '"]').remove();
          var r4 = y2.makeShapesOptionsAndPlotinfo(t3, e4), c3 = r4.options, w3 = r4.plotinfo;
          function M(r5) {
            var M2 = m2(t3, c3), S = { "data-index": e4, "fill-rule": c3.fillrule, d: M2 }, E2 = c3.opacity, L = c3.fillcolor, C2 = c3.line.width ? c3.line.color : "rgba(0,0,0,0)", P = c3.line.width, O = c3.line.dash;
            P || true !== c3.editable || (P = 5, O = "solid");
            var I2 = "Z" !== M2[M2.length - 1], D2 = _(t3) && c3.editable && t3._fullLayout._activeShapeIndex === e4;
            D2 && (L = I2 ? "rgba(0,0,0,0)" : t3._fullLayout.activeshape.fillcolor, E2 = t3._fullLayout.activeshape.opacity);
            var z2, R = r5.append("g").classed("shape-group", true).attr({ "data-index": e4 }), F2 = R.append("path").attr(S).style("opacity", E2).call(f2.stroke, C2).call(f2.fill, L).call(h2.dashLine, O, P);
            if (T(R, t3, c3), u2(t3, e4, c3, R), (D2 || t3._context.edits.shapePosition) && (z2 = p2(t3.layout, "shapes", c3)), D2) {
              F2.style({ cursor: "move" });
              var B2 = { element: F2.node(), plotinfo: w3, gd: t3, editHelpers: z2, hasText: c3.label.text || c3.label.texttemplate, isActiveShape: true }, N = s(M2, t3);
              l2(N, F2, B2);
            } else
              t3._context.edits.shapePosition ? function(t4, e5, r6, s2, l3, c4) {
                var f3, p3, x2, _2, w4, A3, M3, S2, E3, L2, C3, P2, O2, I3, D3, z3, R2 = 10, F3 = 10, B3 = "pixel" === r6.xsizemode, N2 = "pixel" === r6.ysizemode, j = "line" === r6.type, U = "path" === r6.type, V = c4.modifyItem, q2 = n2.select(e5.node().parentNode), H2 = o.getFromId(t4, r6.xref), G2 = o.getRefType(r6.xref), W = o.getFromId(t4, r6.yref), Y = o.getRefType(r6.yref), X = y2.getDataToPixel(t4, H2, false, G2), Z = y2.getDataToPixel(t4, W, true, Y), K = y2.getPixelToData(t4, H2, false, G2), J = y2.getPixelToData(t4, W, true, Y), $ = j ? function() {
                  var t5 = 10, n3 = Math.max(r6.line.width, t5), i2 = l3.append("g").attr("data-index", s2).attr("drag-helper", true);
                  i2.append("path").attr("d", e5.attr("d")).style({ cursor: "move", "stroke-width": n3, "stroke-opacity": "0" });
                  var a2 = { "fill-opacity": "0" }, o2 = Math.max(n3 / 2, t5);
                  return i2.append("circle").attr({ "data-line-point": "start-point", cx: B3 ? X(r6.xanchor) + r6.x0 : X(r6.x0), cy: N2 ? Z(r6.yanchor) - r6.y0 : Z(r6.y0), r: o2 }).style(a2).classed("cursor-grab", true), i2.append("circle").attr({ "data-line-point": "end-point", cx: B3 ? X(r6.xanchor) + r6.x1 : X(r6.x1), cy: N2 ? Z(r6.yanchor) - r6.y1 : Z(r6.y1), r: o2 }).style(a2).classed("cursor-grab", true), i2;
                }() : e5, Q = { element: $.node(), gd: t4, prepFn: function(n3) {
                  b2(t4) || (B3 && (w4 = X(r6.xanchor)), N2 && (A3 = Z(r6.yanchor)), "path" === r6.type ? D3 = r6.path : (f3 = B3 ? r6.x0 : X(r6.x0), p3 = N2 ? r6.y0 : Z(r6.y0), x2 = B3 ? r6.x1 : X(r6.x1), _2 = N2 ? r6.y1 : Z(r6.y1)), f3 < x2 ? (E3 = f3, O2 = "x0", L2 = x2, I3 = "x1") : (E3 = x2, O2 = "x1", L2 = f3, I3 = "x0"), !N2 && p3 < _2 || N2 && p3 > _2 ? (M3 = p3, C3 = "y0", S2 = _2, P2 = "y1") : (M3 = _2, C3 = "y1", S2 = p3, P2 = "y0"), tt2(n3), nt(l3, r6), function(t5, e6, r7) {
                    var n4 = e6.xref, i2 = e6.yref, a2 = o.getFromId(r7, n4), s3 = o.getFromId(r7, i2), l4 = "";
                    "paper" === n4 || a2.autorange || (l4 += n4), "paper" === i2 || s3.autorange || (l4 += i2), h2.setClipUrl(t5, l4 ? "clip" + r7._fullLayout._uid + l4 : null, r7);
                  }(e5, r6, t4), Q.moveFn = "move" === z3 ? et : rt, Q.altKey = n3.altKey);
                }, doneFn: function() {
                  b2(t4) || (v2(e5), it(l3), T(e5, t4, r6), i.call("_guiRelayout", t4, c4.getUpdateObj()));
                }, clickFn: function() {
                  b2(t4) || it(l3);
                } };
                function tt2(r7) {
                  if (b2(t4))
                    z3 = null;
                  else if (j)
                    z3 = "path" === r7.target.tagName ? "move" : "start-point" === r7.target.attributes["data-line-point"].value ? "resize-over-start-point" : "resize-over-end-point";
                  else {
                    var n3 = Q.element.getBoundingClientRect(), i2 = n3.right - n3.left, a2 = n3.bottom - n3.top, o2 = r7.clientX - n3.left, s3 = r7.clientY - n3.top, l4 = !U && i2 > R2 && a2 > F3 && !r7.shiftKey ? d2.getCursor(o2 / i2, 1 - s3 / a2) : "move";
                    v2(e5, l4), z3 = l4.split("-")[0];
                  }
                }
                function et(n3, i2) {
                  if ("path" === r6.type) {
                    var a2 = function(t5) {
                      return t5;
                    }, o2 = a2, c5 = a2;
                    B3 ? V("xanchor", r6.xanchor = K(w4 + n3)) : (o2 = function(t5) {
                      return K(X(t5) + n3);
                    }, H2 && "date" === H2.type && (o2 = y2.encodeDate(o2))), N2 ? V("yanchor", r6.yanchor = J(A3 + i2)) : (c5 = function(t5) {
                      return J(Z(t5) + i2);
                    }, W && "date" === W.type && (c5 = y2.encodeDate(c5))), V("path", r6.path = k2(D3, o2, c5));
                  } else
                    B3 ? V("xanchor", r6.xanchor = K(w4 + n3)) : (V("x0", r6.x0 = K(f3 + n3)), V("x1", r6.x1 = K(x2 + n3))), N2 ? V("yanchor", r6.yanchor = J(A3 + i2)) : (V("y0", r6.y0 = J(p3 + i2)), V("y1", r6.y1 = J(_2 + i2)));
                  e5.attr("d", m2(t4, r6)), nt(l3, r6), u2(t4, s2, r6, q2);
                }
                function rt(n3, i2) {
                  if (U) {
                    var a2 = function(t5) {
                      return t5;
                    }, o2 = a2, c5 = a2;
                    B3 ? V("xanchor", r6.xanchor = K(w4 + n3)) : (o2 = function(t5) {
                      return K(X(t5) + n3);
                    }, H2 && "date" === H2.type && (o2 = y2.encodeDate(o2))), N2 ? V("yanchor", r6.yanchor = J(A3 + i2)) : (c5 = function(t5) {
                      return J(Z(t5) + i2);
                    }, W && "date" === W.type && (c5 = y2.encodeDate(c5))), V("path", r6.path = k2(D3, o2, c5));
                  } else if (j) {
                    if ("resize-over-start-point" === z3) {
                      var h3 = f3 + n3, d3 = N2 ? p3 - i2 : p3 + i2;
                      V("x0", r6.x0 = B3 ? h3 : K(h3)), V("y0", r6.y0 = N2 ? d3 : J(d3));
                    } else if ("resize-over-end-point" === z3) {
                      var v3 = x2 + n3, g3 = N2 ? _2 - i2 : _2 + i2;
                      V("x1", r6.x1 = B3 ? v3 : K(v3)), V("y1", r6.y1 = N2 ? g3 : J(g3));
                    }
                  } else {
                    var b3 = function(t5) {
                      return -1 !== z3.indexOf(t5);
                    }, T2 = b3("n"), G3 = b3("s"), Y2 = b3("w"), $2 = b3("e"), Q2 = T2 ? M3 + i2 : M3, tt3 = G3 ? S2 + i2 : S2, et2 = Y2 ? E3 + n3 : E3, rt2 = $2 ? L2 + n3 : L2;
                    N2 && (T2 && (Q2 = M3 - i2), G3 && (tt3 = S2 - i2)), (!N2 && tt3 - Q2 > F3 || N2 && Q2 - tt3 > F3) && (V(C3, r6[C3] = N2 ? Q2 : J(Q2)), V(P2, r6[P2] = N2 ? tt3 : J(tt3))), rt2 - et2 > R2 && (V(O2, r6[O2] = B3 ? et2 : K(et2)), V(I3, r6[I3] = B3 ? rt2 : K(rt2)));
                  }
                  e5.attr("d", m2(t4, r6)), nt(l3, r6), u2(t4, s2, r6, q2);
                }
                function nt(t5, e6) {
                  (B3 || N2) && function() {
                    var r7 = "path" !== e6.type, n3 = t5.selectAll(".visual-cue").data([0]);
                    n3.enter().append("path").attr({ fill: "#fff", "fill-rule": "evenodd", stroke: "#000", "stroke-width": 1 }).classed("visual-cue", true);
                    var i2 = X(B3 ? e6.xanchor : a.midRange(r7 ? [e6.x0, e6.x1] : y2.extractPathCoords(e6.path, g2.paramIsX))), o2 = Z(N2 ? e6.yanchor : a.midRange(r7 ? [e6.y0, e6.y1] : y2.extractPathCoords(e6.path, g2.paramIsY)));
                    if (i2 = y2.roundPositionForSharpStrokeRendering(i2, 1), o2 = y2.roundPositionForSharpStrokeRendering(o2, 1), B3 && N2) {
                      var s3 = "M" + (i2 - 1 - 1) + "," + (o2 - 1 - 1) + "h-8v2h8 v8h2v-8 h8v-2h-8 v-8h-2 Z";
                      n3.attr("d", s3);
                    } else if (B3) {
                      var l4 = "M" + (i2 - 1 - 1) + "," + (o2 - 9 - 1) + "v18 h2 v-18 Z";
                      n3.attr("d", l4);
                    } else {
                      var u3 = "M" + (i2 - 9 - 1) + "," + (o2 - 1 - 1) + "h18 v2 h-18 Z";
                      n3.attr("d", u3);
                    }
                  }();
                }
                function it(t5) {
                  t5.selectAll(".visual-cue").remove();
                }
                d2.init(Q), $.node().onmousemove = tt2;
              }(t3, F2, c3, e4, r5, z2) : true === c3.editable && F2.style("pointer-events", I2 || f2.opacity(L) * E2 <= 0.5 ? "stroke" : "all");
            F2.node().addEventListener("click", function() {
              return function(t4, e5) {
                if (_(t4)) {
                  var r6 = +e5.node().getAttribute("data-index");
                  if (r6 >= 0) {
                    if (r6 === t4._fullLayout._activeShapeIndex)
                      return void A2(t4);
                    t4._fullLayout._activeShapeIndex = r6, t4._fullLayout._deactivateShape = A2, x(t4);
                  }
                }
              }(t3, F2);
            });
          }
          c3._input && true === c3.visible && ("below" !== c3.layer ? M(t3._fullLayout._shapeUpperLayer) : "paper" === c3.xref || "paper" === c3.yref ? M(t3._fullLayout._shapeLowerLayer) : w3._hadPlotinfo ? M((w3.mainplotinfo || w3).shapelayer) : M(t3._fullLayout._shapeLowerLayer));
        }
        function T(t3, e4, r4) {
          var n3 = (r4.xref + r4.yref).replace(/paper/g, "").replace(/[xyz][1-9]* *domain/g, "");
          h2.setClipUrl(t3, n3 ? "clip" + e4._fullLayout._uid + n3 : null, e4);
        }
        function k2(t3, e4, r4) {
          return t3.replace(g2.segmentRE, function(t4) {
            var n3 = 0, i2 = t4.charAt(0), a2 = g2.paramIsX[i2], o2 = g2.paramIsY[i2], s2 = g2.numParams[i2];
            return i2 + t4.substr(1).replace(g2.paramRE, function(t5) {
              return n3 >= s2 || (a2[n3] ? t5 = e4(t5) : o2[n3] && (t5 = r4(t5)), n3++), t5;
            });
          });
        }
        function A2(t3) {
          _(t3) && t3._fullLayout._activeShapeIndex >= 0 && (c2(t3), delete t3._fullLayout._activeShapeIndex, x(t3));
        }
        t2.exports = { draw: x, drawOne: w2, eraseActiveShape: function(t3) {
          if (_(t3)) {
            c2(t3);
            var e4 = t3._fullLayout._activeShapeIndex, r4 = (t3.layout || {}).shapes || [];
            if (e4 < r4.length) {
              for (var n3 = [], a2 = 0; a2 < r4.length; a2++)
                a2 !== e4 && n3.push(r4[a2]);
              return delete t3._fullLayout._activeShapeIndex, i.call("_guiRelayout", t3, { shapes: n3 });
            }
          }
        }, drawLabel: u2 };
      }, 92872: function(t2, e3, r3) {
        var n2 = r3(67824).overrideAll, i = r3(45464), a = r3(25376), o = r3(98192).u, s = r3(92880).extendFlat, l2 = r3(21776).ye, u2 = r3(97728);
        t2.exports = n2({ newshape: { visible: s({}, i.visible, {}), showlegend: { valType: "boolean", dflt: false }, legend: s({}, i.legend, {}), legendgroup: s({}, i.legendgroup, {}), legendgrouptitle: { text: s({}, i.legendgrouptitle.text, {}), font: a({}) }, legendrank: s({}, i.legendrank, {}), legendwidth: s({}, i.legendwidth, {}), line: { color: { valType: "color" }, width: { valType: "number", min: 0, dflt: 4 }, dash: s({}, o, { dflt: "solid" }) }, fillcolor: { valType: "color", dflt: "rgba(0,0,0,0)" }, fillrule: { valType: "enumerated", values: ["evenodd", "nonzero"], dflt: "evenodd" }, opacity: { valType: "number", min: 0, max: 1, dflt: 1 }, layer: { valType: "enumerated", values: ["below", "above"], dflt: "above" }, drawdirection: { valType: "enumerated", values: ["ortho", "horizontal", "vertical", "diagonal"], dflt: "diagonal" }, name: s({}, i.name, {}), label: { text: { valType: "string", dflt: "" }, texttemplate: l2({ newshape: true }, { keys: Object.keys(u2) }), font: a({}), textposition: { valType: "enumerated", values: ["top left", "top center", "top right", "middle left", "middle center", "middle right", "bottom left", "bottom center", "bottom right", "start", "middle", "end"] }, textangle: { valType: "angle", dflt: "auto" }, xanchor: { valType: "enumerated", values: ["auto", "left", "center", "right"], dflt: "auto" }, yanchor: { valType: "enumerated", values: ["top", "middle", "bottom"] }, padding: { valType: "number", dflt: 3, min: 0 } } }, activeshape: { fillcolor: { valType: "color", dflt: "rgb(255,0,255)" }, opacity: { valType: "number", min: 0, max: 1, dflt: 0.5 } } }, "none", "from-root");
      }, 7e3: function(t2) {
        t2.exports = { CIRCLE_SIDES: 32, i000: 0, i090: 8, i180: 16, i270: 24, cos45: Math.cos(Math.PI / 4), sin45: Math.sin(Math.PI / 4), SQRT2: Math.sqrt(2) };
      }, 65144: function(t2, e3, r3) {
        var n2 = r3(76308), i = r3(3400);
        t2.exports = function(t3, e4, r4) {
          if (r4("newshape.visible"), r4("newshape.name"), r4("newshape.showlegend"), r4("newshape.legend"), r4("newshape.legendwidth"), r4("newshape.legendgroup"), r4("newshape.legendgrouptitle.text"), i.coerceFont(r4, "newshape.legendgrouptitle.font"), r4("newshape.legendrank"), r4("newshape.drawdirection"), r4("newshape.layer"), r4("newshape.fillcolor"), r4("newshape.fillrule"), r4("newshape.opacity"), r4("newshape.line.width")) {
            var a = (t3 || {}).plot_bgcolor || "#FFF";
            r4("newshape.line.color", n2.contrast(a)), r4("newshape.line.dash");
          }
          var o = "drawline" === t3.dragmode, s = r4("newshape.label.text"), l2 = r4("newshape.label.texttemplate");
          if (s || l2) {
            r4("newshape.label.textangle");
            var u2 = r4("newshape.label.textposition", o ? "middle" : "middle center");
            r4("newshape.label.xanchor"), r4("newshape.label.yanchor", function(t4, e5) {
              return t4 ? "bottom" : -1 !== e5.indexOf("top") ? "top" : -1 !== e5.indexOf("bottom") ? "bottom" : "middle";
            }(o, u2)), r4("newshape.label.padding"), i.coerceFont(r4, "newshape.label.font", e4.font);
          }
          r4("activeshape.fillcolor"), r4("activeshape.opacity");
        };
      }, 9856: function(t2, e3, r3) {
        var n2 = r3(21984), i = r3(7e3), a = i.CIRCLE_SIDES, o = i.SQRT2, s = r3(5840), l2 = s.p2r, u2 = s.r2p, c2 = [0, 3, 4, 5, 6, 1, 2], f2 = [0, 3, 4, 1, 2];
        function h2(t3, e4) {
          return Math.abs(t3 - e4) <= 1e-6;
        }
        function p2(t3, e4) {
          var r4 = e4[1] - t3[1], n3 = e4[2] - t3[2];
          return Math.sqrt(r4 * r4 + n3 * n3);
        }
        e3.writePaths = function(t3) {
          var e4 = t3.length;
          if (!e4)
            return "M0,0Z";
          for (var r4 = "", n3 = 0; n3 < e4; n3++)
            for (var i2 = t3[n3].length, a2 = 0; a2 < i2; a2++) {
              var o2 = t3[n3][a2][0];
              if ("Z" === o2)
                r4 += "Z";
              else
                for (var s2 = t3[n3][a2].length, l3 = 0; l3 < s2; l3++) {
                  var u3 = l3;
                  "Q" === o2 || "S" === o2 ? u3 = f2[l3] : "C" === o2 && (u3 = c2[l3]), r4 += t3[n3][a2][u3], l3 > 0 && l3 < s2 - 1 && (r4 += ",");
                }
            }
          return r4;
        }, e3.readPaths = function(t3, e4, r4, i2) {
          var o2, s2, c3, f3 = n2(t3), h3 = [], p3 = -1, d2 = 0, v2 = 0, g2 = function() {
            s2 = d2, c3 = v2;
          };
          g2();
          for (var y2 = 0; y2 < f3.length; y2++) {
            var m2, x, b2, _, w2 = [], T = f3[y2][0], k2 = T;
            switch (T) {
              case "M":
                h3[++p3] = [], d2 = +f3[y2][1], v2 = +f3[y2][2], w2.push([k2, d2, v2]), g2();
                break;
              case "Q":
              case "S":
                m2 = +f3[y2][1], b2 = +f3[y2][2], d2 = +f3[y2][3], v2 = +f3[y2][4], w2.push([k2, d2, v2, m2, b2]);
                break;
              case "C":
                m2 = +f3[y2][1], b2 = +f3[y2][2], x = +f3[y2][3], _ = +f3[y2][4], d2 = +f3[y2][5], v2 = +f3[y2][6], w2.push([k2, d2, v2, m2, b2, x, _]);
                break;
              case "T":
              case "L":
                d2 = +f3[y2][1], v2 = +f3[y2][2], w2.push([k2, d2, v2]);
                break;
              case "H":
                k2 = "L", d2 = +f3[y2][1], w2.push([k2, d2, v2]);
                break;
              case "V":
                k2 = "L", v2 = +f3[y2][1], w2.push([k2, d2, v2]);
                break;
              case "A":
                k2 = "L";
                var A2 = +f3[y2][1], M = +f3[y2][2];
                +f3[y2][4] || (A2 = -A2, M = -M);
                var S = d2 - A2, E2 = v2;
                for (o2 = 1; o2 <= a / 2; o2++) {
                  var L = 2 * Math.PI * o2 / a;
                  w2.push([k2, S + A2 * Math.cos(L), E2 + M * Math.sin(L)]);
                }
                break;
              case "Z":
                d2 === s2 && v2 === c3 || (d2 = s2, v2 = c3, w2.push([k2, d2, v2]));
            }
            for (var C2 = (r4 || {}).domain, P = e4._fullLayout._size, O = r4 && "pixel" === r4.xsizemode, I2 = r4 && "pixel" === r4.ysizemode, D2 = false === i2, z2 = 0; z2 < w2.length; z2++) {
              for (o2 = 0; o2 + 2 < 7; o2 += 2) {
                var R = w2[z2][o2 + 1], F2 = w2[z2][o2 + 2];
                void 0 !== R && void 0 !== F2 && (d2 = R, v2 = F2, r4 && (r4.xaxis && r4.xaxis.p2r ? (D2 && (R -= r4.xaxis._offset), R = O ? u2(r4.xaxis, r4.xanchor) + R : l2(r4.xaxis, R)) : (D2 && (R -= P.l), C2 ? R = C2.x[0] + R / P.w : R /= P.w), r4.yaxis && r4.yaxis.p2r ? (D2 && (F2 -= r4.yaxis._offset), F2 = I2 ? u2(r4.yaxis, r4.yanchor) - F2 : l2(r4.yaxis, F2)) : (D2 && (F2 -= P.t), F2 = C2 ? C2.y[1] - F2 / P.h : 1 - F2 / P.h)), w2[z2][o2 + 1] = R, w2[z2][o2 + 2] = F2);
              }
              h3[p3].push(w2[z2].slice());
            }
          }
          return h3;
        }, e3.pointsOnRectangle = function(t3) {
          if (5 !== t3.length)
            return false;
          for (var e4 = 1; e4 < 3; e4++) {
            if (!h2(t3[0][e4] - t3[1][e4], t3[3][e4] - t3[2][e4]))
              return false;
            if (!h2(t3[0][e4] - t3[3][e4], t3[1][e4] - t3[2][e4]))
              return false;
          }
          return !(!h2(t3[0][1], t3[1][1]) && !h2(t3[0][1], t3[3][1]) || !(p2(t3[0], t3[1]) * p2(t3[0], t3[3])));
        }, e3.pointsOnEllipse = function(t3) {
          var e4 = t3.length;
          if (e4 !== a + 1)
            return false;
          e4 = a;
          for (var r4 = 0; r4 < e4; r4++) {
            var n3 = (2 * e4 - r4) % e4, i2 = (e4 / 2 + n3) % e4, o2 = (e4 / 2 + r4) % e4;
            if (!h2(p2(t3[r4], t3[o2]), p2(t3[n3], t3[i2])))
              return false;
          }
          return true;
        }, e3.handleEllipse = function(t3, r4, n3) {
          if (!t3)
            return [r4, n3];
          var i2 = e3.ellipseOver({ x0: r4[0], y0: r4[1], x1: n3[0], y1: n3[1] }), s2 = (i2.x1 + i2.x0) / 2, l3 = (i2.y1 + i2.y0) / 2, u3 = (i2.x1 - i2.x0) / 2, c3 = (i2.y1 - i2.y0) / 2;
          u3 || (u3 = c3 /= o), c3 || (c3 = u3 /= o);
          for (var f3 = [], h3 = 0; h3 < a; h3++) {
            var p3 = 2 * h3 * Math.PI / a;
            f3.push([s2 + u3 * Math.cos(p3), l3 + c3 * Math.sin(p3)]);
          }
          return f3;
        }, e3.ellipseOver = function(t3) {
          var e4 = t3.x0, r4 = t3.y0, n3 = t3.x1, i2 = t3.y1, a2 = n3 - e4, s2 = i2 - r4, l3 = ((e4 -= a2) + n3) / 2, u3 = ((r4 -= s2) + i2) / 2;
          return { x0: l3 - (a2 *= o), y0: u3 - (s2 *= o), x1: l3 + a2, y1: u3 + s2 };
        }, e3.fixDatesForPaths = function(t3, e4, r4) {
          var n3 = "date" === e4.type, i2 = "date" === r4.type;
          if (!n3 && !i2)
            return t3;
          for (var a2 = 0; a2 < t3.length; a2++)
            for (var o2 = 0; o2 < t3[a2].length; o2++)
              for (var s2 = 0; s2 + 2 < t3[a2][o2].length; s2 += 2)
                n3 && (t3[a2][o2][s2 + 1] = t3[a2][o2][s2 + 1].replace(" ", "_")), i2 && (t3[a2][o2][s2 + 2] = t3[a2][o2][s2 + 2].replace(" ", "_"));
          return t3;
        };
      }, 93940: function(t2, e3, r3) {
        var n2 = r3(72760), i = n2.drawMode, a = n2.openMode, o = r3(7e3), s = o.i000, l2 = o.i090, u2 = o.i180, c2 = o.i270, f2 = o.cos45, h2 = o.sin45, p2 = r3(5840), d2 = p2.p2r, v2 = p2.r2p, g2 = r3(1936).clearOutline, y2 = r3(9856), m2 = y2.readPaths, x = y2.writePaths, b2 = y2.ellipseOver, _ = y2.fixDatesForPaths;
        function w2(t3, e4, r4) {
          var n3, i2 = t3[0][0], o2 = e4.gd, p3 = i2.getAttribute("d"), g3 = o2._fullLayout.newshape, y3 = e4.plotinfo, w3 = e4.isActiveShape, T = y3.xaxis, k2 = y3.yaxis, A2 = !!y3.domain || !y3.xaxis, M = !!y3.domain || !y3.yaxis, S = a(r4), E2 = m2(p3, o2, y3, w3), L = { editable: true, visible: g3.visible, name: g3.name, showlegend: g3.showlegend, legend: g3.legend, legendwidth: g3.legendwidth, legendgroup: g3.legendgroup, legendgrouptitle: { text: g3.legendgrouptitle.text, font: g3.legendgrouptitle.font }, legendrank: g3.legendrank, label: g3.label, xref: A2 ? "paper" : T._id, yref: M ? "paper" : k2._id, layer: g3.layer, opacity: g3.opacity, line: { color: g3.line.color, width: g3.line.width, dash: g3.line.dash } };
          if (S || (L.fillcolor = g3.fillcolor, L.fillrule = g3.fillrule), 1 === E2.length && (n3 = E2[0]), n3 && 5 === n3.length && "drawrect" === r4)
            L.type = "rect", L.x0 = n3[0][1], L.y0 = n3[0][2], L.x1 = n3[2][1], L.y1 = n3[2][2];
          else if (n3 && "drawline" === r4)
            L.type = "line", L.x0 = n3[0][1], L.y0 = n3[0][2], L.x1 = n3[1][1], L.y1 = n3[1][2];
          else if (n3 && "drawcircle" === r4) {
            L.type = "circle";
            var C2 = n3[s][1], P = n3[l2][1], O = n3[u2][1], I2 = n3[c2][1], D2 = n3[s][2], z2 = n3[l2][2], R = n3[u2][2], F2 = n3[c2][2], B2 = y3.xaxis && ("date" === y3.xaxis.type || "log" === y3.xaxis.type), N = y3.yaxis && ("date" === y3.yaxis.type || "log" === y3.yaxis.type);
            B2 && (C2 = v2(y3.xaxis, C2), P = v2(y3.xaxis, P), O = v2(y3.xaxis, O), I2 = v2(y3.xaxis, I2)), N && (D2 = v2(y3.yaxis, D2), z2 = v2(y3.yaxis, z2), R = v2(y3.yaxis, R), F2 = v2(y3.yaxis, F2));
            var j = (P + I2) / 2, U = (D2 + R) / 2, V = b2({ x0: j, y0: U, x1: j + (I2 - P + O - C2) / 2 * f2, y1: U + (F2 - z2 + R - D2) / 2 * h2 });
            B2 && (V.x0 = d2(y3.xaxis, V.x0), V.x1 = d2(y3.xaxis, V.x1)), N && (V.y0 = d2(y3.yaxis, V.y0), V.y1 = d2(y3.yaxis, V.y1)), L.x0 = V.x0, L.y0 = V.y0, L.x1 = V.x1, L.y1 = V.y1;
          } else
            L.type = "path", T && k2 && _(E2, T, k2), L.path = x(E2), n3 = null;
          return L;
        }
        t2.exports = { newShapes: function(t3, e4) {
          if (t3.length && t3[0][0]) {
            var r4 = e4.gd, n3 = e4.isActiveShape, a2 = e4.dragmode, o2 = (r4.layout || {}).shapes || [];
            if (!i(a2) && void 0 !== n3) {
              var s2 = r4._fullLayout._activeShapeIndex;
              if (s2 < o2.length)
                switch (r4._fullLayout.shapes[s2].type) {
                  case "rect":
                    a2 = "drawrect";
                    break;
                  case "circle":
                    a2 = "drawcircle";
                    break;
                  case "line":
                    a2 = "drawline";
                    break;
                  case "path":
                    var l3 = o2[s2].path || "";
                    a2 = "Z" === l3[l3.length - 1] ? "drawclosedpath" : "drawopenpath";
                }
            }
            var u3 = w2(t3, e4, a2);
            g2(r4);
            for (var c3 = e4.editHelpers, f3 = (c3 || {}).modifyItem, h3 = [], p3 = 0; p3 < o2.length; p3++) {
              var d3 = r4._fullLayout.shapes[p3];
              if (h3[p3] = d3._input, void 0 !== n3 && p3 === r4._fullLayout._activeShapeIndex) {
                var v3 = u3;
                switch (d3.type) {
                  case "line":
                  case "rect":
                  case "circle":
                    f3("x0", v3.x0), f3("x1", v3.x1), f3("y0", v3.y0), f3("y1", v3.y1);
                    break;
                  case "path":
                    f3("path", v3.path);
                }
              }
            }
            return void 0 === n3 ? (h3.push(u3), h3) : c3 ? c3.getUpdateObj() : {};
          }
        }, createShapeObj: w2 };
      }, 1936: function(t2) {
        t2.exports = { clearOutlineControllers: function(t3) {
          var e3 = t3._fullLayout._zoomlayer;
          e3 && e3.selectAll(".outline-controllers").remove();
        }, clearOutline: function(t3) {
          var e3 = t3._fullLayout._zoomlayer;
          e3 && e3.selectAll(".select-outline").remove(), t3._fullLayout._outlining = false;
        } };
      }, 65152: function(t2, e3, r3) {
        var n2 = r3(85448), i = r3(3400), a = r3(54460);
        e3.rangeToShapePosition = function(t3) {
          return "log" === t3.type ? t3.r2d : function(t4) {
            return t4;
          };
        }, e3.shapePositionToRange = function(t3) {
          return "log" === t3.type ? t3.d2r : function(t4) {
            return t4;
          };
        }, e3.decodeDate = function(t3) {
          return function(e4) {
            return e4.replace && (e4 = e4.replace("_", " ")), t3(e4);
          };
        }, e3.encodeDate = function(t3) {
          return function(e4) {
            return t3(e4).replace(" ", "_");
          };
        }, e3.extractPathCoords = function(t3, e4, r4) {
          var a2 = [];
          return t3.match(n2.segmentRE).forEach(function(t4) {
            var o = e4[t4.charAt(0)].drawn;
            if (void 0 !== o) {
              var s = t4.substr(1).match(n2.paramRE);
              if (s && !(s.length < o)) {
                var l2 = s[o], u2 = r4 ? l2 : i.cleanNumber(l2);
                a2.push(u2);
              }
            }
          }), a2;
        }, e3.getDataToPixel = function(t3, r4, n3, i2) {
          var a2, o = t3._fullLayout._size;
          if (r4)
            if ("domain" === i2)
              a2 = function(t4) {
                return r4._length * (n3 ? 1 - t4 : t4) + r4._offset;
              };
            else {
              var s = e3.shapePositionToRange(r4);
              a2 = function(t4) {
                return r4._offset + r4.r2p(s(t4, true));
              }, "date" === r4.type && (a2 = e3.decodeDate(a2));
            }
          else
            a2 = n3 ? function(t4) {
              return o.t + o.h * (1 - t4);
            } : function(t4) {
              return o.l + o.w * t4;
            };
          return a2;
        }, e3.getPixelToData = function(t3, r4, n3, i2) {
          var a2, o = t3._fullLayout._size;
          if (r4)
            if ("domain" === i2)
              a2 = function(t4) {
                var e4 = (t4 - r4._offset) / r4._length;
                return n3 ? 1 - e4 : e4;
              };
            else {
              var s = e3.rangeToShapePosition(r4);
              a2 = function(t4) {
                return s(r4.p2r(t4 - r4._offset));
              };
            }
          else
            a2 = n3 ? function(t4) {
              return 1 - (t4 - o.t) / o.h;
            } : function(t4) {
              return (t4 - o.l) / o.w;
            };
          return a2;
        }, e3.roundPositionForSharpStrokeRendering = function(t3, e4) {
          var r4 = 1 === Math.round(e4 % 2), n3 = Math.round(t3);
          return r4 ? n3 + 0.5 : n3;
        }, e3.makeShapesOptionsAndPlotinfo = function(t3, e4) {
          var r4 = t3._fullLayout.shapes[e4] || {}, n3 = t3._fullLayout._plots[r4.xref + r4.yref];
          return n3 ? n3._hadPlotinfo = true : (n3 = {}, r4.xref && "paper" !== r4.xref && (n3.xaxis = t3._fullLayout[r4.xref + "axis"]), r4.yref && "paper" !== r4.yref && (n3.yaxis = t3._fullLayout[r4.yref + "axis"])), n3.xsizemode = r4.xsizemode, n3.ysizemode = r4.ysizemode, n3.xanchor = r4.xanchor, n3.yanchor = r4.yanchor, { options: r4, plotinfo: n3 };
        }, e3.makeSelectionsOptionsAndPlotinfo = function(t3, e4) {
          var r4 = t3._fullLayout.selections[e4] || {}, n3 = t3._fullLayout._plots[r4.xref + r4.yref];
          return n3 ? n3._hadPlotinfo = true : (n3 = {}, r4.xref && (n3.xaxis = t3._fullLayout[r4.xref + "axis"]), r4.yref && (n3.yaxis = t3._fullLayout[r4.yref + "axis"])), { options: r4, plotinfo: n3 };
        }, e3.getPathString = function(t3, r4) {
          var o, s, l2, u2, c2, f2, h2, p2, d2 = r4.type, v2 = a.getRefType(r4.xref), g2 = a.getRefType(r4.yref), y2 = a.getFromId(t3, r4.xref), m2 = a.getFromId(t3, r4.yref), x = t3._fullLayout._size;
          if (y2 ? "domain" === v2 ? s = function(t4) {
            return y2._offset + y2._length * t4;
          } : (o = e3.shapePositionToRange(y2), s = function(t4) {
            return y2._offset + y2.r2p(o(t4, true));
          }) : s = function(t4) {
            return x.l + x.w * t4;
          }, m2 ? "domain" === g2 ? u2 = function(t4) {
            return m2._offset + m2._length * (1 - t4);
          } : (l2 = e3.shapePositionToRange(m2), u2 = function(t4) {
            return m2._offset + m2.r2p(l2(t4, true));
          }) : u2 = function(t4) {
            return x.t + x.h * (1 - t4);
          }, "path" === d2)
            return y2 && "date" === y2.type && (s = e3.decodeDate(s)), m2 && "date" === m2.type && (u2 = e3.decodeDate(u2)), function(t4, e4, r5) {
              var a2 = t4.path, o2 = t4.xsizemode, s2 = t4.ysizemode, l3 = t4.xanchor, u3 = t4.yanchor;
              return a2.replace(n2.segmentRE, function(t5) {
                var a3 = 0, c3 = t5.charAt(0), f3 = n2.paramIsX[c3], h3 = n2.paramIsY[c3], p3 = n2.numParams[c3], d3 = t5.substr(1).replace(n2.paramRE, function(t6) {
                  return f3[a3] ? t6 = "pixel" === o2 ? e4(l3) + Number(t6) : e4(t6) : h3[a3] && (t6 = "pixel" === s2 ? r5(u3) - Number(t6) : r5(t6)), ++a3 > p3 && (t6 = "X"), t6;
                });
                return a3 > p3 && (d3 = d3.replace(/[\s,]*X.*/, ""), i.log("Ignoring extra params in segment " + t5)), c3 + d3;
              });
            }(r4, s, u2);
          if ("pixel" === r4.xsizemode) {
            var b2 = s(r4.xanchor);
            c2 = b2 + r4.x0, f2 = b2 + r4.x1;
          } else
            c2 = s(r4.x0), f2 = s(r4.x1);
          if ("pixel" === r4.ysizemode) {
            var _ = u2(r4.yanchor);
            h2 = _ - r4.y0, p2 = _ - r4.y1;
          } else
            h2 = u2(r4.y0), p2 = u2(r4.y1);
          if ("line" === d2)
            return "M" + c2 + "," + h2 + "L" + f2 + "," + p2;
          if ("rect" === d2)
            return "M" + c2 + "," + h2 + "H" + f2 + "V" + p2 + "H" + c2 + "Z";
          var w2 = (c2 + f2) / 2, T = (h2 + p2) / 2, k2 = Math.abs(w2 - c2), A2 = Math.abs(T - h2), M = "A" + k2 + "," + A2, S = w2 + k2 + "," + T;
          return "M" + S + M + " 0 1,1 " + w2 + "," + (T - A2) + M + " 0 0,1 " + S + "Z";
        };
      }, 41592: function(t2, e3, r3) {
        var n2 = r3(4016);
        t2.exports = { moduleType: "component", name: "shapes", layoutAttributes: r3(46056), supplyLayoutDefaults: r3(43712), supplyDrawNewShapeDefaults: r3(65144), includeBasePlot: r3(36632)("shapes"), calcAutorange: r3(96084), draw: n2.draw, drawOne: n2.drawOne };
      }, 97728: function(t2) {
        function e3(t3, e4) {
          return e4 ? e4.d2l(t3) : t3;
        }
        function r3(t3, e4) {
          return e4 ? e4.l2d(t3) : t3;
        }
        function n2(t3, r4) {
          return e3(t3.x1, r4) - e3(t3.x0, r4);
        }
        function i(t3, r4, n3) {
          return e3(t3.y1, n3) - e3(t3.y0, n3);
        }
        t2.exports = { x0: function(t3) {
          return t3.x0;
        }, x1: function(t3) {
          return t3.x1;
        }, y0: function(t3) {
          return t3.y0;
        }, y1: function(t3) {
          return t3.y1;
        }, slope: function(t3, e4, r4) {
          return "line" !== t3.type ? void 0 : i(t3, 0, r4) / n2(t3, e4);
        }, dx: n2, dy: i, width: function(t3, e4) {
          return Math.abs(n2(t3, e4));
        }, height: function(t3, e4, r4) {
          return Math.abs(i(t3, 0, r4));
        }, length: function(t3, e4, r4) {
          return "line" !== t3.type ? void 0 : Math.sqrt(Math.pow(n2(t3, e4), 2) + Math.pow(i(t3, 0, r4), 2));
        }, xcenter: function(t3, n3) {
          return r3((e3(t3.x1, n3) + e3(t3.x0, n3)) / 2, n3);
        }, ycenter: function(t3, n3, i2) {
          return r3((e3(t3.y1, i2) + e3(t3.y0, i2)) / 2, i2);
        } };
      }, 89861: function(t2, e3, r3) {
        var n2 = r3(25376), i = r3(66741), a = r3(92880).extendDeepAll, o = r3(67824).overrideAll, s = r3(85656), l2 = r3(31780).templatedArray, u2 = r3(60876), c2 = l2("step", { visible: { valType: "boolean", dflt: true }, method: { valType: "enumerated", values: ["restyle", "relayout", "animate", "update", "skip"], dflt: "restyle" }, args: { valType: "info_array", freeLength: true, items: [{ valType: "any" }, { valType: "any" }, { valType: "any" }] }, label: { valType: "string" }, value: { valType: "string" }, execute: { valType: "boolean", dflt: true } });
        t2.exports = o(l2("slider", { visible: { valType: "boolean", dflt: true }, active: { valType: "number", min: 0, dflt: 0 }, steps: c2, lenmode: { valType: "enumerated", values: ["fraction", "pixels"], dflt: "fraction" }, len: { valType: "number", min: 0, dflt: 1 }, x: { valType: "number", min: -2, max: 3, dflt: 0 }, pad: a(i({ editType: "arraydraw" }), {}, { t: { dflt: 20 } }), xanchor: { valType: "enumerated", values: ["auto", "left", "center", "right"], dflt: "left" }, y: { valType: "number", min: -2, max: 3, dflt: 0 }, yanchor: { valType: "enumerated", values: ["auto", "top", "middle", "bottom"], dflt: "top" }, transition: { duration: { valType: "number", min: 0, dflt: 150 }, easing: { valType: "enumerated", values: s.transition.easing.values, dflt: "cubic-in-out" } }, currentvalue: { visible: { valType: "boolean", dflt: true }, xanchor: { valType: "enumerated", values: ["left", "center", "right"], dflt: "left" }, offset: { valType: "number", dflt: 10 }, prefix: { valType: "string" }, suffix: { valType: "string" }, font: n2({}) }, font: n2({}), activebgcolor: { valType: "color", dflt: u2.gripBgActiveColor }, bgcolor: { valType: "color", dflt: u2.railBgColor }, bordercolor: { valType: "color", dflt: u2.railBorderColor }, borderwidth: { valType: "number", min: 0, dflt: u2.railBorderWidth }, ticklen: { valType: "number", min: 0, dflt: u2.tickLength }, tickcolor: { valType: "color", dflt: u2.tickColor }, tickwidth: { valType: "number", min: 0, dflt: 1 }, minorticklen: { valType: "number", min: 0, dflt: u2.minorTickLength } }), "arraydraw", "from-root");
      }, 60876: function(t2) {
        t2.exports = { name: "sliders", containerClassName: "slider-container", groupClassName: "slider-group", inputAreaClass: "slider-input-area", railRectClass: "slider-rail-rect", railTouchRectClass: "slider-rail-touch-rect", gripRectClass: "slider-grip-rect", tickRectClass: "slider-tick-rect", inputProxyClass: "slider-input-proxy", labelsClass: "slider-labels", labelGroupClass: "slider-label-group", labelClass: "slider-label", currentValueClass: "slider-current-value", railHeight: 5, menuIndexAttrName: "slider-active-index", autoMarginIdRoot: "slider-", minWidth: 30, minHeight: 30, textPadX: 40, arrowOffsetX: 4, railRadius: 2, railWidth: 5, railBorder: 4, railBorderWidth: 1, railBorderColor: "#bec8d9", railBgColor: "#f8fafc", railInset: 8, stepInset: 10, gripRadius: 10, gripWidth: 20, gripHeight: 20, gripBorder: 20, gripBorderWidth: 1, gripBorderColor: "#bec8d9", gripBgColor: "#f6f8fa", gripBgActiveColor: "#dbdde0", labelPadding: 8, labelOffset: 0, tickWidth: 1, tickColor: "#333", tickOffset: 25, tickLength: 7, minorTickOffset: 25, minorTickColor: "#333", minorTickLength: 4, currentValuePadding: 8, currentValueInset: 0 };
      }, 8132: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(51272), a = r3(89861), o = r3(60876).name, s = a.steps;
        function l2(t3, e4, r4) {
          function o2(r5, i2) {
            return n2.coerce(t3, e4, a, r5, i2);
          }
          for (var s2 = i(t3, e4, { name: "steps", handleItemDefaults: u2 }), l3 = 0, c2 = 0; c2 < s2.length; c2++)
            s2[c2].visible && l3++;
          if (l3 < 2 ? e4.visible = false : o2("visible")) {
            e4._stepCount = l3;
            var f2 = e4._visibleSteps = n2.filterVisible(s2);
            (s2[o2("active")] || {}).visible || (e4.active = f2[0]._index), o2("x"), o2("y"), n2.noneOrAll(t3, e4, ["x", "y"]), o2("xanchor"), o2("yanchor"), o2("len"), o2("lenmode"), o2("pad.t"), o2("pad.r"), o2("pad.b"), o2("pad.l"), n2.coerceFont(o2, "font", r4.font), o2("currentvalue.visible") && (o2("currentvalue.xanchor"), o2("currentvalue.prefix"), o2("currentvalue.suffix"), o2("currentvalue.offset"), n2.coerceFont(o2, "currentvalue.font", e4.font)), o2("transition.duration"), o2("transition.easing"), o2("bgcolor"), o2("activebgcolor"), o2("bordercolor"), o2("borderwidth"), o2("ticklen"), o2("tickwidth"), o2("tickcolor"), o2("minorticklen");
          }
        }
        function u2(t3, e4) {
          function r4(r5, i3) {
            return n2.coerce(t3, e4, s, r5, i3);
          }
          if ("skip" === t3.method || Array.isArray(t3.args) ? r4("visible") : e4.visible = false) {
            r4("method"), r4("args");
            var i2 = r4("label", "step-" + e4._index);
            r4("value", i2), r4("execute");
          }
        }
        t2.exports = function(t3, e4) {
          i(t3, e4, { name: o, handleItemDefaults: l2 });
        };
      }, 79664: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(7316), a = r3(76308), o = r3(43616), s = r3(3400), l2 = s.strTranslate, u2 = r3(72736), c2 = r3(31780).arrayEditor, f2 = r3(60876), h2 = r3(84284), p2 = h2.LINE_SPACING, d2 = h2.FROM_TL, v2 = h2.FROM_BR;
        function g2(t3) {
          return f2.autoMarginIdRoot + t3._index;
        }
        function y2(t3) {
          return t3._index;
        }
        function m2(t3, e4) {
          var r4 = o.tester.selectAll("g." + f2.labelGroupClass).data(e4._visibleSteps);
          r4.enter().append("g").classed(f2.labelGroupClass, true);
          var a2 = 0, l3 = 0;
          r4.each(function(t4) {
            var r5 = _(n2.select(this), { step: t4 }, e4).node();
            if (r5) {
              var i2 = o.bBox(r5);
              l3 = Math.max(l3, i2.height), a2 = Math.max(a2, i2.width);
            }
          }), r4.remove();
          var c3 = e4._dims = {};
          c3.inputAreaWidth = Math.max(f2.railWidth, f2.gripHeight);
          var h3 = t3._fullLayout._size;
          c3.lx = h3.l + h3.w * e4.x, c3.ly = h3.t + h3.h * (1 - e4.y), "fraction" === e4.lenmode ? c3.outerLength = Math.round(h3.w * e4.len) : c3.outerLength = e4.len, c3.inputAreaStart = 0, c3.inputAreaLength = Math.round(c3.outerLength - e4.pad.l - e4.pad.r);
          var p3 = (c3.inputAreaLength - 2 * f2.stepInset) / (e4._stepCount - 1), y3 = a2 + f2.labelPadding;
          if (c3.labelStride = Math.max(1, Math.ceil(y3 / p3)), c3.labelHeight = l3, c3.currentValueMaxWidth = 0, c3.currentValueHeight = 0, c3.currentValueTotalHeight = 0, c3.currentValueMaxLines = 1, e4.currentvalue.visible) {
            var m3 = o.tester.append("g");
            r4.each(function(t4) {
              var r5 = x(m3, e4, t4.label), n3 = r5.node() && o.bBox(r5.node()) || { width: 0, height: 0 }, i2 = u2.lineCount(r5);
              c3.currentValueMaxWidth = Math.max(c3.currentValueMaxWidth, Math.ceil(n3.width)), c3.currentValueHeight = Math.max(c3.currentValueHeight, Math.ceil(n3.height)), c3.currentValueMaxLines = Math.max(c3.currentValueMaxLines, i2);
            }), c3.currentValueTotalHeight = c3.currentValueHeight + e4.currentvalue.offset, m3.remove();
          }
          c3.height = c3.currentValueTotalHeight + f2.tickOffset + e4.ticklen + f2.labelOffset + c3.labelHeight + e4.pad.t + e4.pad.b;
          var b3 = "left";
          s.isRightAnchor(e4) && (c3.lx -= c3.outerLength, b3 = "right"), s.isCenterAnchor(e4) && (c3.lx -= c3.outerLength / 2, b3 = "center");
          var w3 = "top";
          s.isBottomAnchor(e4) && (c3.ly -= c3.height, w3 = "bottom"), s.isMiddleAnchor(e4) && (c3.ly -= c3.height / 2, w3 = "middle"), c3.outerLength = Math.ceil(c3.outerLength), c3.height = Math.ceil(c3.height), c3.lx = Math.round(c3.lx), c3.ly = Math.round(c3.ly);
          var T2 = { y: e4.y, b: c3.height * v2[w3], t: c3.height * d2[w3] };
          "fraction" === e4.lenmode ? (T2.l = 0, T2.xl = e4.x - e4.len * d2[b3], T2.r = 0, T2.xr = e4.x + e4.len * v2[b3]) : (T2.x = e4.x, T2.l = c3.outerLength * d2[b3], T2.r = c3.outerLength * v2[b3]), i.autoMargin(t3, g2(e4), T2);
        }
        function x(t3, e4, r4) {
          if (e4.currentvalue.visible) {
            var n3, i2, a2 = e4._dims;
            switch (e4.currentvalue.xanchor) {
              case "right":
                n3 = a2.inputAreaLength - f2.currentValueInset - a2.currentValueMaxWidth, i2 = "left";
                break;
              case "center":
                n3 = 0.5 * a2.inputAreaLength, i2 = "middle";
                break;
              default:
                n3 = f2.currentValueInset, i2 = "left";
            }
            var l3 = s.ensureSingle(t3, "text", f2.labelClass, function(t4) {
              t4.attr({ "text-anchor": i2, "data-notex": 1 });
            }), c3 = e4.currentvalue.prefix ? e4.currentvalue.prefix : "";
            if ("string" == typeof r4)
              c3 += r4;
            else {
              var h3 = e4.steps[e4.active].label, d3 = e4._gd._fullLayout._meta;
              d3 && (h3 = s.templateString(h3, d3)), c3 += h3;
            }
            e4.currentvalue.suffix && (c3 += e4.currentvalue.suffix), l3.call(o.font, e4.currentvalue.font).text(c3).call(u2.convertToTspans, e4._gd);
            var v3 = u2.lineCount(l3), g3 = (a2.currentValueMaxLines + 1 - v3) * e4.currentvalue.font.size * p2;
            return u2.positionText(l3, n3, g3), l3;
          }
        }
        function b2(t3, e4, r4) {
          s.ensureSingle(t3, "rect", f2.gripRectClass, function(n3) {
            n3.call(A2, e4, t3, r4).style("pointer-events", "all");
          }).attr({ width: f2.gripWidth, height: f2.gripHeight, rx: f2.gripRadius, ry: f2.gripRadius }).call(a.stroke, r4.bordercolor).call(a.fill, r4.bgcolor).style("stroke-width", r4.borderwidth + "px");
        }
        function _(t3, e4, r4) {
          var n3 = s.ensureSingle(t3, "text", f2.labelClass, function(t4) {
            t4.attr({ "text-anchor": "middle", "data-notex": 1 });
          }), i2 = e4.step.label, a2 = r4._gd._fullLayout._meta;
          return a2 && (i2 = s.templateString(i2, a2)), n3.call(o.font, r4.font).text(i2).call(u2.convertToTspans, r4._gd), n3;
        }
        function w2(t3, e4) {
          var r4 = s.ensureSingle(t3, "g", f2.labelsClass), i2 = e4._dims, a2 = r4.selectAll("g." + f2.labelGroupClass).data(i2.labelSteps);
          a2.enter().append("g").classed(f2.labelGroupClass, true), a2.exit().remove(), a2.each(function(t4) {
            var r5 = n2.select(this);
            r5.call(_, t4, e4), o.setTranslate(r5, E2(e4, t4.fraction), f2.tickOffset + e4.ticklen + e4.font.size * p2 + f2.labelOffset + i2.currentValueTotalHeight);
          });
        }
        function T(t3, e4, r4, n3, i2) {
          var a2 = Math.round(n3 * (r4._stepCount - 1)), o2 = r4._visibleSteps[a2]._index;
          o2 !== r4.active && k2(t3, e4, r4, o2, true, i2);
        }
        function k2(t3, e4, r4, n3, a2, o2) {
          var s2 = r4.active;
          r4.active = n3, c2(t3.layout, f2.name, r4).applyUpdate("active", n3);
          var l3 = r4.steps[r4.active];
          e4.call(S, r4, o2), e4.call(x, r4), t3.emit("plotly_sliderchange", { slider: r4, step: r4.steps[r4.active], interaction: a2, previousActive: s2 }), l3 && l3.method && a2 && (e4._nextMethod ? (e4._nextMethod.step = l3, e4._nextMethod.doCallback = a2, e4._nextMethod.doTransition = o2) : (e4._nextMethod = { step: l3, doCallback: a2, doTransition: o2 }, e4._nextMethodRaf = window.requestAnimationFrame(function() {
            var r5 = e4._nextMethod.step;
            r5.method && (r5.execute && i.executeAPICommand(t3, r5.method, r5.args), e4._nextMethod = null, e4._nextMethodRaf = null);
          })));
        }
        function A2(t3, e4, r4) {
          if (!e4._context.staticPlot) {
            var i2 = r4.node(), o2 = n2.select(e4);
            t3.on("mousedown", l3), t3.on("touchstart", l3);
          }
          function s2() {
            return r4.data()[0];
          }
          function l3() {
            var t4 = s2();
            e4.emit("plotly_sliderstart", { slider: t4 });
            var l4 = r4.select("." + f2.gripRectClass);
            n2.event.stopPropagation(), n2.event.preventDefault(), l4.call(a.fill, t4.activebgcolor);
            var u3 = L(t4, n2.mouse(i2)[0]);
            function c3() {
              var t5 = s2(), a2 = L(t5, n2.mouse(i2)[0]);
              T(e4, r4, t5, a2, false);
            }
            function h3() {
              var t5 = s2();
              t5._dragging = false, l4.call(a.fill, t5.bgcolor), o2.on("mouseup", null), o2.on("mousemove", null), o2.on("touchend", null), o2.on("touchmove", null), e4.emit("plotly_sliderend", { slider: t5, step: t5.steps[t5.active] });
            }
            T(e4, r4, t4, u3, true), t4._dragging = true, o2.on("mousemove", c3), o2.on("touchmove", c3), o2.on("mouseup", h3), o2.on("touchend", h3);
          }
        }
        function M(t3, e4) {
          var r4 = t3.selectAll("rect." + f2.tickRectClass).data(e4._visibleSteps), i2 = e4._dims;
          r4.enter().append("rect").classed(f2.tickRectClass, true), r4.exit().remove(), r4.attr({ width: e4.tickwidth + "px", "shape-rendering": "crispEdges" }), r4.each(function(t4, r5) {
            var s2 = r5 % i2.labelStride == 0, l3 = n2.select(this);
            l3.attr({ height: s2 ? e4.ticklen : e4.minorticklen }).call(a.fill, e4.tickcolor), o.setTranslate(l3, E2(e4, r5 / (e4._stepCount - 1)) - 0.5 * e4.tickwidth, (s2 ? f2.tickOffset : f2.minorTickOffset) + i2.currentValueTotalHeight);
          });
        }
        function S(t3, e4, r4) {
          for (var n3 = t3.select("rect." + f2.gripRectClass), i2 = 0, a2 = 0; a2 < e4._stepCount; a2++)
            if (e4._visibleSteps[a2]._index === e4.active) {
              i2 = a2;
              break;
            }
          var o2 = E2(e4, i2 / (e4._stepCount - 1));
          if (!e4._invokingCommand) {
            var s2 = n3;
            r4 && e4.transition.duration > 0 && (s2 = s2.transition().duration(e4.transition.duration).ease(e4.transition.easing)), s2.attr("transform", l2(o2 - 0.5 * f2.gripWidth, e4._dims.currentValueTotalHeight));
          }
        }
        function E2(t3, e4) {
          var r4 = t3._dims;
          return r4.inputAreaStart + f2.stepInset + (r4.inputAreaLength - 2 * f2.stepInset) * Math.min(1, Math.max(0, e4));
        }
        function L(t3, e4) {
          var r4 = t3._dims;
          return Math.min(1, Math.max(0, (e4 - f2.stepInset - r4.inputAreaStart) / (r4.inputAreaLength - 2 * f2.stepInset - 2 * r4.inputAreaStart)));
        }
        function C2(t3, e4, r4) {
          var n3 = r4._dims, i2 = s.ensureSingle(t3, "rect", f2.railTouchRectClass, function(n4) {
            n4.call(A2, e4, t3, r4).style("pointer-events", "all");
          });
          i2.attr({ width: n3.inputAreaLength, height: Math.max(n3.inputAreaWidth, f2.tickOffset + r4.ticklen + n3.labelHeight) }).call(a.fill, r4.bgcolor).attr("opacity", 0), o.setTranslate(i2, 0, n3.currentValueTotalHeight);
        }
        function P(t3, e4) {
          var r4 = e4._dims, n3 = r4.inputAreaLength - 2 * f2.railInset, i2 = s.ensureSingle(t3, "rect", f2.railRectClass);
          i2.attr({ width: n3, height: f2.railWidth, rx: f2.railRadius, ry: f2.railRadius, "shape-rendering": "crispEdges" }).call(a.stroke, e4.bordercolor).call(a.fill, e4.bgcolor).style("stroke-width", e4.borderwidth + "px"), o.setTranslate(i2, f2.railInset, 0.5 * (r4.inputAreaWidth - f2.railWidth) + r4.currentValueTotalHeight);
        }
        t2.exports = function(t3) {
          var e4 = t3._context.staticPlot, r4 = t3._fullLayout, a2 = function(t4, e5) {
            for (var r5 = t4[f2.name], n3 = [], i2 = 0; i2 < r5.length; i2++) {
              var a3 = r5[i2];
              a3.visible && (a3._gd = e5, n3.push(a3));
            }
            return n3;
          }(r4, t3), s2 = r4._infolayer.selectAll("g." + f2.containerClassName).data(a2.length > 0 ? [0] : []);
          function l3(e5) {
            e5._commandObserver && (e5._commandObserver.remove(), delete e5._commandObserver), i.autoMargin(t3, g2(e5));
          }
          if (s2.enter().append("g").classed(f2.containerClassName, true).style("cursor", e4 ? null : "ew-resize"), s2.exit().each(function() {
            n2.select(this).selectAll("g." + f2.groupClassName).each(l3);
          }).remove(), 0 !== a2.length) {
            var u3 = s2.selectAll("g." + f2.groupClassName).data(a2, y2);
            u3.enter().append("g").classed(f2.groupClassName, true), u3.exit().each(l3).remove();
            for (var c3 = 0; c3 < a2.length; c3++) {
              var h3 = a2[c3];
              m2(t3, h3);
            }
            u3.each(function(e5) {
              var r5 = n2.select(this);
              !function(t4) {
                var e6 = t4._dims;
                e6.labelSteps = [];
                for (var r6 = t4._stepCount, n3 = 0; n3 < r6; n3 += e6.labelStride)
                  e6.labelSteps.push({ fraction: n3 / (r6 - 1), step: t4._visibleSteps[n3] });
              }(e5), i.manageCommandObserver(t3, e5, e5._visibleSteps, function(e6) {
                var n3 = r5.data()[0];
                n3.active !== e6.index && (n3._dragging || k2(t3, r5, n3, e6.index, false, true));
              }), function(t4, e6, r6) {
                (r6.steps[r6.active] || {}).visible || (r6.active = r6._visibleSteps[0]._index), e6.call(x, r6).call(P, r6).call(w2, r6).call(M, r6).call(C2, t4, r6).call(b2, t4, r6);
                var n3 = r6._dims;
                o.setTranslate(e6, n3.lx + r6.pad.l, n3.ly + r6.pad.t), e6.call(S, r6, false), e6.call(x, r6);
              }(t3, n2.select(this), e5);
            });
          }
        };
      }, 97544: function(t2, e3, r3) {
        var n2 = r3(60876);
        t2.exports = { moduleType: "component", name: n2.name, layoutAttributes: r3(89861), supplyLayoutDefaults: r3(8132), draw: r3(79664) };
      }, 81668: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(38248), a = r3(7316), o = r3(24040), s = r3(3400), l2 = s.strTranslate, u2 = r3(43616), c2 = r3(76308), f2 = r3(72736), h2 = r3(13448), p2 = r3(84284).OPPOSITE_SIDE, d2 = / [XY][0-9]* /;
        t2.exports = { draw: function(t3, e4, r4) {
          var v2, g2 = r4.propContainer, y2 = r4.propName, m2 = r4.placeholder, x = r4.traceIndex, b2 = r4.avoid || {}, _ = r4.attributes, w2 = r4.transform, T = r4.containerGroup, k2 = t3._fullLayout, A2 = 1, M = false, S = g2.title, E2 = (S && S.text ? S.text : "").trim(), L = S && S.font ? S.font : {}, C2 = L.family, P = L.size, O = L.color;
          "title.text" === y2 ? v2 = "titleText" : -1 !== y2.indexOf("axis") ? v2 = "axisTitleText" : y2.indexOf(true) && (v2 = "colorbarTitleText");
          var I2 = t3._context.edits[v2];
          "" === E2 ? A2 = 0 : E2.replace(d2, " % ") === m2.replace(d2, " % ") && (A2 = 0.2, M = true, I2 || (E2 = "")), r4._meta ? E2 = s.templateString(E2, r4._meta) : k2._meta && (E2 = s.templateString(E2, k2._meta));
          var D2, z2 = E2 || I2;
          T || (T = s.ensureSingle(k2._infolayer, "g", "g-" + e4), D2 = k2._hColorbarMoveTitle);
          var R = T.selectAll("text").data(z2 ? [0] : []);
          if (R.enter().append("text"), R.text(E2).attr("class", e4), R.exit().remove(), !z2)
            return T;
          function F2(t4) {
            s.syncOrAsync([B2, N], t4);
          }
          function B2(e5) {
            var r5;
            return !w2 && D2 && (w2 = {}), w2 ? (r5 = "", w2.rotate && (r5 += "rotate(" + [w2.rotate, _.x, _.y] + ")"), (w2.offset || D2) && (r5 += l2(0, (w2.offset || 0) - (D2 || 0)))) : r5 = null, e5.attr("transform", r5), e5.style({ "font-family": C2, "font-size": n2.round(P, 2) + "px", fill: c2.rgb(O), opacity: A2 * c2.opacity(O), "font-weight": a.fontWeight }).attr(_).call(f2.convertToTspans, t3), a.previousPromises(t3);
          }
          function N(e5) {
            var r5 = n2.select(e5.node().parentNode);
            if (b2 && b2.selection && b2.side && E2) {
              r5.attr("transform", null);
              var a2 = p2[b2.side], o2 = "left" === b2.side || "top" === b2.side ? -1 : 1, c3 = i(b2.pad) ? b2.pad : 2, f3 = u2.bBox(r5.node()), h3 = { t: 0, b: 0, l: 0, r: 0 }, d3 = t3._fullLayout._reservedMargin;
              for (var v3 in d3)
                for (var y3 in d3[v3]) {
                  var m3 = d3[v3][y3];
                  h3[y3] = Math.max(h3[y3], m3);
                }
              var x2 = { left: h3.l, top: h3.t, right: k2.width - h3.r, bottom: k2.height - h3.b }, _2 = b2.maxShift || o2 * (x2[b2.side] - f3[b2.side]), w3 = 0;
              if (_2 < 0)
                w3 = _2;
              else {
                var T2 = b2.offsetLeft || 0, A3 = b2.offsetTop || 0;
                f3.left -= T2, f3.right -= T2, f3.top -= A3, f3.bottom -= A3, b2.selection.each(function() {
                  var t4 = u2.bBox(this);
                  s.bBoxIntersect(f3, t4, c3) && (w3 = Math.max(w3, o2 * (t4[b2.side] - f3[a2]) + c3));
                }), w3 = Math.min(_2, w3), g2._titleScoot = Math.abs(w3);
              }
              if (w3 > 0 || _2 < 0) {
                var M2 = { left: [-w3, 0], right: [w3, 0], top: [0, -w3], bottom: [0, w3] }[b2.side];
                r5.attr("transform", l2(M2[0], M2[1]));
              }
            }
          }
          return R.call(F2), I2 && (E2 ? R.on(".opacity", null) : (A2 = 0, M = true, R.text(m2).on("mouseover.opacity", function() {
            n2.select(this).transition().duration(h2.SHOW_PLACEHOLDER).style("opacity", 1);
          }).on("mouseout.opacity", function() {
            n2.select(this).transition().duration(h2.HIDE_PLACEHOLDER).style("opacity", 0);
          })), R.call(f2.makeEditable, { gd: t3 }).on("edit", function(e5) {
            void 0 !== x ? o.call("_guiRestyle", t3, y2, e5, x) : o.call("_guiRelayout", t3, y2, e5);
          }).on("cancel", function() {
            this.text(this.attr("data-unformatted")).call(F2);
          }).on("input", function(t4) {
            this.text(t4 || " ").call(f2.positionText, _.x, _.y);
          })), R.classed("js-placeholder", M), T;
        } };
      }, 88444: function(t2, e3, r3) {
        var n2 = r3(25376), i = r3(22548), a = r3(92880).extendFlat, o = r3(67824).overrideAll, s = r3(66741), l2 = r3(31780).templatedArray, u2 = l2("button", { visible: { valType: "boolean" }, method: { valType: "enumerated", values: ["restyle", "relayout", "animate", "update", "skip"], dflt: "restyle" }, args: { valType: "info_array", freeLength: true, items: [{ valType: "any" }, { valType: "any" }, { valType: "any" }] }, args2: { valType: "info_array", freeLength: true, items: [{ valType: "any" }, { valType: "any" }, { valType: "any" }] }, label: { valType: "string", dflt: "" }, execute: { valType: "boolean", dflt: true } });
        t2.exports = o(l2("updatemenu", { _arrayAttrRegexps: [/^updatemenus\[(0|[1-9][0-9]+)\]\.buttons/], visible: { valType: "boolean" }, type: { valType: "enumerated", values: ["dropdown", "buttons"], dflt: "dropdown" }, direction: { valType: "enumerated", values: ["left", "right", "up", "down"], dflt: "down" }, active: { valType: "integer", min: -1, dflt: 0 }, showactive: { valType: "boolean", dflt: true }, buttons: u2, x: { valType: "number", min: -2, max: 3, dflt: -0.05 }, xanchor: { valType: "enumerated", values: ["auto", "left", "center", "right"], dflt: "right" }, y: { valType: "number", min: -2, max: 3, dflt: 1 }, yanchor: { valType: "enumerated", values: ["auto", "top", "middle", "bottom"], dflt: "top" }, pad: a(s({ editType: "arraydraw" }), {}), font: n2({}), bgcolor: { valType: "color" }, bordercolor: { valType: "color", dflt: i.borderLine }, borderwidth: { valType: "number", min: 0, dflt: 1, editType: "arraydraw" } }), "arraydraw", "from-root");
      }, 73712: function(t2) {
        t2.exports = { name: "updatemenus", containerClassName: "updatemenu-container", headerGroupClassName: "updatemenu-header-group", headerClassName: "updatemenu-header", headerArrowClassName: "updatemenu-header-arrow", dropdownButtonGroupClassName: "updatemenu-dropdown-button-group", dropdownButtonClassName: "updatemenu-dropdown-button", buttonClassName: "updatemenu-button", itemRectClassName: "updatemenu-item-rect", itemTextClassName: "updatemenu-item-text", menuIndexAttrName: "updatemenu-active-index", autoMarginIdRoot: "updatemenu-", blankHeaderOpts: { label: "  " }, minWidth: 30, minHeight: 30, textPadX: 24, arrowPadX: 16, rx: 2, ry: 2, textOffsetX: 12, textOffsetY: 3, arrowOffsetX: 4, gapButtonHeader: 5, gapButton: 2, activeColor: "#F4FAFF", hoverColor: "#F4FAFF", arrowSymbol: { left: "◄", right: "►", up: "▲", down: "▼" } };
      }, 91384: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(51272), a = r3(88444), o = r3(73712).name, s = a.buttons;
        function l2(t3, e4, r4) {
          function o2(r5, i2) {
            return n2.coerce(t3, e4, a, r5, i2);
          }
          o2("visible", i(t3, e4, { name: "buttons", handleItemDefaults: u2 }).length > 0) && (o2("active"), o2("direction"), o2("type"), o2("showactive"), o2("x"), o2("y"), n2.noneOrAll(t3, e4, ["x", "y"]), o2("xanchor"), o2("yanchor"), o2("pad.t"), o2("pad.r"), o2("pad.b"), o2("pad.l"), n2.coerceFont(o2, "font", r4.font), o2("bgcolor", r4.paper_bgcolor), o2("bordercolor"), o2("borderwidth"));
        }
        function u2(t3, e4) {
          function r4(r5, i2) {
            return n2.coerce(t3, e4, s, r5, i2);
          }
          r4("visible", "skip" === t3.method || Array.isArray(t3.args)) && (r4("method"), r4("args"), r4("args2"), r4("label"), r4("execute"));
        }
        t2.exports = function(t3, e4) {
          i(t3, e4, { name: o, handleItemDefaults: l2 });
        };
      }, 14420: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(7316), a = r3(76308), o = r3(43616), s = r3(3400), l2 = r3(72736), u2 = r3(31780).arrayEditor, c2 = r3(84284).LINE_SPACING, f2 = r3(73712), h2 = r3(37400);
        function p2(t3) {
          return t3._index;
        }
        function d2(t3, e4) {
          return +t3.attr(f2.menuIndexAttrName) === e4._index;
        }
        function v2(t3, e4, r4, n3, i2, a2, o2, s2) {
          e4.active = o2, u2(t3.layout, f2.name, e4).applyUpdate("active", o2), "buttons" === e4.type ? y2(t3, n3, null, null, e4) : "dropdown" === e4.type && (i2.attr(f2.menuIndexAttrName, "-1"), g2(t3, n3, i2, a2, e4), s2 || y2(t3, n3, i2, a2, e4));
        }
        function g2(t3, e4, r4, n3, i2) {
          var a2 = s.ensureSingle(e4, "g", f2.headerClassName, function(t4) {
            t4.style("pointer-events", "all");
          }), l3 = i2._dims, u3 = i2.active, c3 = i2.buttons[u3] || f2.blankHeaderOpts, h3 = { y: i2.pad.t, yPad: 0, x: i2.pad.l, xPad: 0, index: 0 }, p3 = { width: l3.headerWidth, height: l3.headerHeight };
          a2.call(m2, i2, c3, t3).call(M, i2, h3, p3), s.ensureSingle(e4, "text", f2.headerArrowClassName, function(t4) {
            t4.attr("text-anchor", "end").call(o.font, i2.font).text(f2.arrowSymbol[i2.direction]);
          }).attr({ x: l3.headerWidth - f2.arrowOffsetX + i2.pad.l, y: l3.headerHeight / 2 + f2.textOffsetY + i2.pad.t }), a2.on("click", function() {
            r4.call(S, String(d2(r4, i2) ? -1 : i2._index)), y2(t3, e4, r4, n3, i2);
          }), a2.on("mouseover", function() {
            a2.call(w2);
          }), a2.on("mouseout", function() {
            a2.call(T, i2);
          }), o.setTranslate(e4, l3.lx, l3.ly);
        }
        function y2(t3, e4, r4, a2, o2) {
          r4 || (r4 = e4).attr("pointer-events", "all");
          var l3 = function(t4) {
            return -1 == +t4.attr(f2.menuIndexAttrName);
          }(r4) && "buttons" !== o2.type ? [] : o2.buttons, u3 = "dropdown" === o2.type ? f2.dropdownButtonClassName : f2.buttonClassName, c3 = r4.selectAll("g." + u3).data(s.filterVisible(l3)), h3 = c3.enter().append("g").classed(u3, true), p3 = c3.exit();
          "dropdown" === o2.type ? (h3.attr("opacity", "0").transition().attr("opacity", "1"), p3.transition().attr("opacity", "0").remove()) : p3.remove();
          var d3 = 0, g3 = 0, y3 = o2._dims, x2 = -1 !== ["up", "down"].indexOf(o2.direction);
          "dropdown" === o2.type && (x2 ? g3 = y3.headerHeight + f2.gapButtonHeader : d3 = y3.headerWidth + f2.gapButtonHeader), "dropdown" === o2.type && "up" === o2.direction && (g3 = -f2.gapButtonHeader + f2.gapButton - y3.openHeight), "dropdown" === o2.type && "left" === o2.direction && (d3 = -f2.gapButtonHeader + f2.gapButton - y3.openWidth);
          var b3 = { x: y3.lx + d3 + o2.pad.l, y: y3.ly + g3 + o2.pad.t, yPad: f2.gapButton, xPad: f2.gapButton, index: 0 }, k3 = { l: b3.x + o2.borderwidth, t: b3.y + o2.borderwidth };
          c3.each(function(s2, l4) {
            var u4 = n2.select(this);
            u4.call(m2, o2, s2, t3).call(M, o2, b3), u4.on("click", function() {
              n2.event.defaultPrevented || (s2.execute && (s2.args2 && o2.active === l4 ? (v2(t3, o2, 0, e4, r4, a2, -1), i.executeAPICommand(t3, s2.method, s2.args2)) : (v2(t3, o2, 0, e4, r4, a2, l4), i.executeAPICommand(t3, s2.method, s2.args))), t3.emit("plotly_buttonclicked", { menu: o2, button: s2, active: o2.active }));
            }), u4.on("mouseover", function() {
              u4.call(w2);
            }), u4.on("mouseout", function() {
              u4.call(T, o2), c3.call(_, o2);
            });
          }), c3.call(_, o2), x2 ? (k3.w = Math.max(y3.openWidth, y3.headerWidth), k3.h = b3.y - k3.t) : (k3.w = b3.x - k3.l, k3.h = Math.max(y3.openHeight, y3.headerHeight)), k3.direction = o2.direction, a2 && (c3.size() ? function(t4, e5, r5, n3, i2, a3) {
            var o3, s2, l4, u4 = i2.direction, c4 = "up" === u4 || "down" === u4, h4 = i2._dims, p4 = i2.active;
            if (c4)
              for (s2 = 0, l4 = 0; l4 < p4; l4++)
                s2 += h4.heights[l4] + f2.gapButton;
            else
              for (o3 = 0, l4 = 0; l4 < p4; l4++)
                o3 += h4.widths[l4] + f2.gapButton;
            n3.enable(a3, o3, s2), n3.hbar && n3.hbar.attr("opacity", "0").transition().attr("opacity", "1"), n3.vbar && n3.vbar.attr("opacity", "0").transition().attr("opacity", "1");
          }(0, 0, 0, a2, o2, k3) : function(t4) {
            var e5 = !!t4.hbar, r5 = !!t4.vbar;
            e5 && t4.hbar.transition().attr("opacity", "0").each("end", function() {
              e5 = false, r5 || t4.disable();
            }), r5 && t4.vbar.transition().attr("opacity", "0").each("end", function() {
              r5 = false, e5 || t4.disable();
            });
          }(a2));
        }
        function m2(t3, e4, r4, n3) {
          t3.call(x, e4).call(b2, e4, r4, n3);
        }
        function x(t3, e4) {
          s.ensureSingle(t3, "rect", f2.itemRectClassName, function(t4) {
            t4.attr({ rx: f2.rx, ry: f2.ry, "shape-rendering": "crispEdges" });
          }).call(a.stroke, e4.bordercolor).call(a.fill, e4.bgcolor).style("stroke-width", e4.borderwidth + "px");
        }
        function b2(t3, e4, r4, n3) {
          var i2 = s.ensureSingle(t3, "text", f2.itemTextClassName, function(t4) {
            t4.attr({ "text-anchor": "start", "data-notex": 1 });
          }), a2 = r4.label, u3 = n3._fullLayout._meta;
          u3 && (a2 = s.templateString(a2, u3)), i2.call(o.font, e4.font).text(a2).call(l2.convertToTspans, n3);
        }
        function _(t3, e4) {
          var r4 = e4.active;
          t3.each(function(t4, i2) {
            var o2 = n2.select(this);
            i2 === r4 && e4.showactive && o2.select("rect." + f2.itemRectClassName).call(a.fill, f2.activeColor);
          });
        }
        function w2(t3) {
          t3.select("rect." + f2.itemRectClassName).call(a.fill, f2.hoverColor);
        }
        function T(t3, e4) {
          t3.select("rect." + f2.itemRectClassName).call(a.fill, e4.bgcolor);
        }
        function k2(t3, e4) {
          var r4 = e4._dims = { width1: 0, height1: 0, heights: [], widths: [], totalWidth: 0, totalHeight: 0, openWidth: 0, openHeight: 0, lx: 0, ly: 0 }, a2 = o.tester.selectAll("g." + f2.dropdownButtonClassName).data(s.filterVisible(e4.buttons));
          a2.enter().append("g").classed(f2.dropdownButtonClassName, true);
          var u3 = -1 !== ["up", "down"].indexOf(e4.direction);
          a2.each(function(i2, a3) {
            var s2 = n2.select(this);
            s2.call(m2, e4, i2, t3);
            var h4 = s2.select("." + f2.itemTextClassName), p4 = h4.node() && o.bBox(h4.node()).width, d4 = Math.max(p4 + f2.textPadX, f2.minWidth), v4 = e4.font.size * c2, g4 = l2.lineCount(h4), y3 = Math.max(v4 * g4, f2.minHeight) + f2.textOffsetY;
            y3 = Math.ceil(y3), d4 = Math.ceil(d4), r4.widths[a3] = d4, r4.heights[a3] = y3, r4.height1 = Math.max(r4.height1, y3), r4.width1 = Math.max(r4.width1, d4), u3 ? (r4.totalWidth = Math.max(r4.totalWidth, d4), r4.openWidth = r4.totalWidth, r4.totalHeight += y3 + f2.gapButton, r4.openHeight += y3 + f2.gapButton) : (r4.totalWidth += d4 + f2.gapButton, r4.openWidth += d4 + f2.gapButton, r4.totalHeight = Math.max(r4.totalHeight, y3), r4.openHeight = r4.totalHeight);
          }), u3 ? r4.totalHeight -= f2.gapButton : r4.totalWidth -= f2.gapButton, r4.headerWidth = r4.width1 + f2.arrowPadX, r4.headerHeight = r4.height1, "dropdown" === e4.type && (u3 ? (r4.width1 += f2.arrowPadX, r4.totalHeight = r4.height1) : r4.totalWidth = r4.width1, r4.totalWidth += f2.arrowPadX), a2.remove();
          var h3 = r4.totalWidth + e4.pad.l + e4.pad.r, p3 = r4.totalHeight + e4.pad.t + e4.pad.b, d3 = t3._fullLayout._size;
          r4.lx = d3.l + d3.w * e4.x, r4.ly = d3.t + d3.h * (1 - e4.y);
          var v3 = "left";
          s.isRightAnchor(e4) && (r4.lx -= h3, v3 = "right"), s.isCenterAnchor(e4) && (r4.lx -= h3 / 2, v3 = "center");
          var g3 = "top";
          s.isBottomAnchor(e4) && (r4.ly -= p3, g3 = "bottom"), s.isMiddleAnchor(e4) && (r4.ly -= p3 / 2, g3 = "middle"), r4.totalWidth = Math.ceil(r4.totalWidth), r4.totalHeight = Math.ceil(r4.totalHeight), r4.lx = Math.round(r4.lx), r4.ly = Math.round(r4.ly), i.autoMargin(t3, A2(e4), { x: e4.x, y: e4.y, l: h3 * ({ right: 1, center: 0.5 }[v3] || 0), r: h3 * ({ left: 1, center: 0.5 }[v3] || 0), b: p3 * ({ top: 1, middle: 0.5 }[g3] || 0), t: p3 * ({ bottom: 1, middle: 0.5 }[g3] || 0) });
        }
        function A2(t3) {
          return f2.autoMarginIdRoot + t3._index;
        }
        function M(t3, e4, r4, n3) {
          n3 = n3 || {};
          var i2 = t3.select("." + f2.itemRectClassName), a2 = t3.select("." + f2.itemTextClassName), s2 = e4.borderwidth, u3 = r4.index, h3 = e4._dims;
          o.setTranslate(t3, s2 + r4.x, s2 + r4.y);
          var p3 = -1 !== ["up", "down"].indexOf(e4.direction), d3 = n3.height || (p3 ? h3.heights[u3] : h3.height1);
          i2.attr({ x: 0, y: 0, width: n3.width || (p3 ? h3.width1 : h3.widths[u3]), height: d3 });
          var v3 = e4.font.size * c2, g3 = (l2.lineCount(a2) - 1) * v3 / 2;
          l2.positionText(a2, f2.textOffsetX, d3 / 2 - g3 + f2.textOffsetY), p3 ? r4.y += h3.heights[u3] + r4.yPad : r4.x += h3.widths[u3] + r4.xPad, r4.index++;
        }
        function S(t3, e4) {
          t3.attr(f2.menuIndexAttrName, e4 || "-1").selectAll("g." + f2.dropdownButtonClassName).remove();
        }
        t2.exports = function(t3) {
          var e4 = t3._fullLayout, r4 = s.filterVisible(e4[f2.name]);
          function a2(e5) {
            i.autoMargin(t3, A2(e5));
          }
          var o2 = e4._menulayer.selectAll("g." + f2.containerClassName).data(r4.length > 0 ? [0] : []);
          if (o2.enter().append("g").classed(f2.containerClassName, true).style("cursor", "pointer"), o2.exit().each(function() {
            n2.select(this).selectAll("g." + f2.headerGroupClassName).each(a2);
          }).remove(), 0 !== r4.length) {
            var l3 = o2.selectAll("g." + f2.headerGroupClassName).data(r4, p2);
            l3.enter().append("g").classed(f2.headerGroupClassName, true);
            for (var u3 = s.ensureSingle(o2, "g", f2.dropdownButtonGroupClassName, function(t4) {
              t4.style("pointer-events", "all");
            }), c3 = 0; c3 < r4.length; c3++) {
              var m3 = r4[c3];
              k2(t3, m3);
            }
            var x2 = "updatemenus" + e4._uid, b3 = new h2(t3, u3, x2);
            l3.enter().size() && (u3.node().parentNode.appendChild(u3.node()), u3.call(S)), l3.exit().each(function(t4) {
              u3.call(S), a2(t4);
            }).remove(), l3.each(function(e5) {
              var r5 = n2.select(this), a3 = "dropdown" === e5.type ? u3 : null;
              i.manageCommandObserver(t3, e5, e5.buttons, function(n3) {
                v2(t3, e5, e5.buttons[n3.index], r5, a3, b3, n3.index, true);
              }), "dropdown" === e5.type ? (g2(t3, r5, u3, b3, e5), d2(u3, e5) && y2(t3, r5, u3, b3, e5)) : y2(t3, r5, null, null, e5);
            });
          }
        };
      }, 76908: function(t2, e3, r3) {
        var n2 = r3(73712);
        t2.exports = { moduleType: "component", name: n2.name, layoutAttributes: r3(88444), supplyLayoutDefaults: r3(91384), draw: r3(14420) };
      }, 37400: function(t2, e3, r3) {
        t2.exports = s;
        var n2 = r3(33428), i = r3(76308), a = r3(43616), o = r3(3400);
        function s(t3, e4, r4) {
          this.gd = t3, this.container = e4, this.id = r4, this.position = null, this.translateX = null, this.translateY = null, this.hbar = null, this.vbar = null, this.bg = this.container.selectAll("rect.scrollbox-bg").data([0]), this.bg.exit().on(".drag", null).on("wheel", null).remove(), this.bg.enter().append("rect").classed("scrollbox-bg", true).style("pointer-events", "all").attr({ opacity: 0, x: 0, y: 0, width: 0, height: 0 });
        }
        s.barWidth = 2, s.barLength = 20, s.barRadius = 2, s.barPad = 1, s.barColor = "#808BA4", s.prototype.enable = function(t3, e4, r4) {
          var o2 = this.gd._fullLayout, l2 = o2.width, u2 = o2.height;
          this.position = t3;
          var c2, f2, h2, p2, d2 = this.position.l, v2 = this.position.w, g2 = this.position.t, y2 = this.position.h, m2 = this.position.direction, x = "down" === m2, b2 = "left" === m2, _ = "up" === m2, w2 = v2, T = y2;
          x || b2 || "right" === m2 || _ || (this.position.direction = "down", x = true), x || _ ? (f2 = (c2 = d2) + w2, x ? (h2 = g2, T = (p2 = Math.min(h2 + T, u2)) - h2) : T = (p2 = g2 + T) - (h2 = Math.max(p2 - T, 0))) : (p2 = (h2 = g2) + T, b2 ? w2 = (f2 = d2 + w2) - (c2 = Math.max(f2 - w2, 0)) : (c2 = d2, w2 = (f2 = Math.min(c2 + w2, l2)) - c2)), this._box = { l: c2, t: h2, w: w2, h: T };
          var k2 = v2 > w2, A2 = s.barLength + 2 * s.barPad, M = s.barWidth + 2 * s.barPad, S = d2, E2 = g2 + y2;
          E2 + M > u2 && (E2 = u2 - M);
          var L = this.container.selectAll("rect.scrollbar-horizontal").data(k2 ? [0] : []);
          L.exit().on(".drag", null).remove(), L.enter().append("rect").classed("scrollbar-horizontal", true).call(i.fill, s.barColor), k2 ? (this.hbar = L.attr({ rx: s.barRadius, ry: s.barRadius, x: S, y: E2, width: A2, height: M }), this._hbarXMin = S + A2 / 2, this._hbarTranslateMax = w2 - A2) : (delete this.hbar, delete this._hbarXMin, delete this._hbarTranslateMax);
          var C2 = y2 > T, P = s.barWidth + 2 * s.barPad, O = s.barLength + 2 * s.barPad, I2 = d2 + v2, D2 = g2;
          I2 + P > l2 && (I2 = l2 - P);
          var z2 = this.container.selectAll("rect.scrollbar-vertical").data(C2 ? [0] : []);
          z2.exit().on(".drag", null).remove(), z2.enter().append("rect").classed("scrollbar-vertical", true).call(i.fill, s.barColor), C2 ? (this.vbar = z2.attr({ rx: s.barRadius, ry: s.barRadius, x: I2, y: D2, width: P, height: O }), this._vbarYMin = D2 + O / 2, this._vbarTranslateMax = T - O) : (delete this.vbar, delete this._vbarYMin, delete this._vbarTranslateMax);
          var R = this.id, F2 = c2 - 0.5, B2 = C2 ? f2 + P + 0.5 : f2 + 0.5, N = h2 - 0.5, j = k2 ? p2 + M + 0.5 : p2 + 0.5, U = o2._topdefs.selectAll("#" + R).data(k2 || C2 ? [0] : []);
          if (U.exit().remove(), U.enter().append("clipPath").attr("id", R).append("rect"), k2 || C2 ? (this._clipRect = U.select("rect").attr({ x: Math.floor(F2), y: Math.floor(N), width: Math.ceil(B2) - Math.floor(F2), height: Math.ceil(j) - Math.floor(N) }), this.container.call(a.setClipUrl, R, this.gd), this.bg.attr({ x: d2, y: g2, width: v2, height: y2 })) : (this.bg.attr({ width: 0, height: 0 }), this.container.on("wheel", null).on(".drag", null).call(a.setClipUrl, null), delete this._clipRect), k2 || C2) {
            var V = n2.behavior.drag().on("dragstart", function() {
              n2.event.sourceEvent.preventDefault();
            }).on("drag", this._onBoxDrag.bind(this));
            this.container.on("wheel", null).on("wheel", this._onBoxWheel.bind(this)).on(".drag", null).call(V);
            var q2 = n2.behavior.drag().on("dragstart", function() {
              n2.event.sourceEvent.preventDefault(), n2.event.sourceEvent.stopPropagation();
            }).on("drag", this._onBarDrag.bind(this));
            k2 && this.hbar.on(".drag", null).call(q2), C2 && this.vbar.on(".drag", null).call(q2);
          }
          this.setTranslate(e4, r4);
        }, s.prototype.disable = function() {
          (this.hbar || this.vbar) && (this.bg.attr({ width: 0, height: 0 }), this.container.on("wheel", null).on(".drag", null).call(a.setClipUrl, null), delete this._clipRect), this.hbar && (this.hbar.on(".drag", null), this.hbar.remove(), delete this.hbar, delete this._hbarXMin, delete this._hbarTranslateMax), this.vbar && (this.vbar.on(".drag", null), this.vbar.remove(), delete this.vbar, delete this._vbarYMin, delete this._vbarTranslateMax);
        }, s.prototype._onBoxDrag = function() {
          var t3 = this.translateX, e4 = this.translateY;
          this.hbar && (t3 -= n2.event.dx), this.vbar && (e4 -= n2.event.dy), this.setTranslate(t3, e4);
        }, s.prototype._onBoxWheel = function() {
          var t3 = this.translateX, e4 = this.translateY;
          this.hbar && (t3 += n2.event.deltaY), this.vbar && (e4 += n2.event.deltaY), this.setTranslate(t3, e4);
        }, s.prototype._onBarDrag = function() {
          var t3 = this.translateX, e4 = this.translateY;
          if (this.hbar) {
            var r4 = t3 + this._hbarXMin, i2 = r4 + this._hbarTranslateMax;
            t3 = (o.constrain(n2.event.x, r4, i2) - r4) / (i2 - r4) * (this.position.w - this._box.w);
          }
          if (this.vbar) {
            var a2 = e4 + this._vbarYMin, s2 = a2 + this._vbarTranslateMax;
            e4 = (o.constrain(n2.event.y, a2, s2) - a2) / (s2 - a2) * (this.position.h - this._box.h);
          }
          this.setTranslate(t3, e4);
        }, s.prototype.setTranslate = function(t3, e4) {
          var r4 = this.position.w - this._box.w, n3 = this.position.h - this._box.h;
          if (t3 = o.constrain(t3 || 0, 0, r4), e4 = o.constrain(e4 || 0, 0, n3), this.translateX = t3, this.translateY = e4, this.container.call(a.setTranslate, this._box.l - this.position.l - t3, this._box.t - this.position.t - e4), this._clipRect && this._clipRect.attr({ x: Math.floor(this.position.l + t3 - 0.5), y: Math.floor(this.position.t + e4 - 0.5) }), this.hbar) {
            var i2 = t3 / r4;
            this.hbar.call(a.setTranslate, t3 + i2 * this._hbarTranslateMax, e4);
          }
          if (this.vbar) {
            var s2 = e4 / n3;
            this.vbar.call(a.setTranslate, t3, e4 + s2 * this._vbarTranslateMax);
          }
        };
      }, 84284: function(t2) {
        t2.exports = { FROM_BL: { left: 0, center: 0.5, right: 1, bottom: 0, middle: 0.5, top: 1 }, FROM_TL: { left: 0, center: 0.5, right: 1, bottom: 1, middle: 0.5, top: 0 }, FROM_BR: { left: 1, center: 0.5, right: 0, bottom: 0, middle: 0.5, top: 1 }, LINE_SPACING: 1.3, CAP_SHIFT: 0.7, MID_SHIFT: 0.35, OPPOSITE_SIDE: { left: "right", right: "left", top: "bottom", bottom: "top" } };
      }, 36208: function(t2) {
        t2.exports = { axisRefDescription: function(t3, e3, r3) {
          return ["If set to a", t3, "axis id (e.g. *" + t3 + "* or", "*" + t3 + "2*), the `" + t3 + "` position refers to a", t3, "coordinate. If set to *paper*, the `" + t3 + "`", "position refers to the distance from the", e3, "of the plotting", "area in normalized coordinates where *0* (*1*) corresponds to the", e3, "(" + r3 + "). If set to a", t3, "axis ID followed by", "*domain* (separated by a space), the position behaves like for", "*paper*, but refers to the distance in fractions of the domain", "length from the", e3, "of the domain of that axis: e.g.,", "*" + t3 + "2 domain* refers to the domain of the second", t3, " axis and a", t3, "position of 0.5 refers to the", "point between the", e3, "and the", r3, "of the domain of the", "second", t3, "axis."].join(" ");
        } };
      }, 48164: function(t2) {
        t2.exports = { INCREASING: { COLOR: "#3D9970", SYMBOL: "▲" }, DECREASING: { COLOR: "#FF4136", SYMBOL: "▼" } };
      }, 26880: function(t2) {
        t2.exports = { FORMAT_LINK: "https://github.com/d3/d3-format/tree/v1.4.5#d3-format", DATE_FORMAT_LINK: "https://github.com/d3/d3-time-format/tree/v2.2.3#locale_format" };
      }, 69104: function(t2) {
        t2.exports = { COMPARISON_OPS: ["=", "!=", "<", ">=", ">", "<="], COMPARISON_OPS2: ["=", "<", ">=", ">", "<="], INTERVAL_OPS: ["[]", "()", "[)", "(]", "][", ")(", "](", ")["], SET_OPS: ["{}", "}{"], CONSTRAINT_REDUCTION: { "=": "=", "<": "<", "<=": "<", ">": ">", ">=": ">", "[]": "[]", "()": "[]", "[)": "[]", "(]": "[]", "][": "][", ")(": "][", "](": "][", ")[": "][" } };
      }, 99168: function(t2) {
        t2.exports = { solid: [[], 0], dot: [[0.5, 1], 200], dash: [[0.5, 1], 50], longdash: [[0.5, 1], 10], dashdot: [[0.5, 0.625, 0.875, 1], 50], longdashdot: [[0.5, 0.7, 0.8, 1], 10] };
      }, 87792: function(t2) {
        t2.exports = { circle: "●", "circle-open": "○", square: "■", "square-open": "□", diamond: "◆", "diamond-open": "◇", cross: "+", x: "❌" };
      }, 13448: function(t2) {
        t2.exports = { SHOW_PLACEHOLDER: 100, HIDE_PLACEHOLDER: 1e3, DESELECTDIM: 0.2 };
      }, 39032: function(t2) {
        t2.exports = { BADNUM: void 0, FP_SAFE: 1e-4 * Number.MAX_VALUE, ONEMAXYEAR: 316224e5, ONEAVGYEAR: 315576e5, ONEMINYEAR: 31536e6, ONEMAXQUARTER: 79488e5, ONEAVGQUARTER: 78894e5, ONEMINQUARTER: 76896e5, ONEMAXMONTH: 26784e5, ONEAVGMONTH: 26298e5, ONEMINMONTH: 24192e5, ONEWEEK: 6048e5, ONEDAY: 864e5, ONEHOUR: 36e5, ONEMIN: 6e4, ONESEC: 1e3, EPOCHJD: 24405875e-1, ALMOST_EQUAL: 0.999999, LOG_CLIP: 10, MINUS_SIGN: "−" };
      }, 2264: function(t2, e3) {
        e3.CSS_DECLARATIONS = [["image-rendering", "optimizeSpeed"], ["image-rendering", "-moz-crisp-edges"], ["image-rendering", "-o-crisp-edges"], ["image-rendering", "-webkit-optimize-contrast"], ["image-rendering", "optimize-contrast"], ["image-rendering", "crisp-edges"], ["image-rendering", "pixelated"]], e3.STYLE = e3.CSS_DECLARATIONS.map(function(t3) {
          return t3.join(": ") + "; ";
        }).join("");
      }, 9616: function(t2, e3) {
        e3.xmlns = "http://www.w3.org/2000/xmlns/", e3.svg = "http://www.w3.org/2000/svg", e3.xlink = "http://www.w3.org/1999/xlink", e3.svgAttrs = { xmlns: e3.svg, "xmlns:xlink": e3.xlink };
      }, 64884: function(t2, e3, r3) {
        e3.version = r3(25788).version, r3(88324), r3(79288);
        for (var n2 = r3(24040), i = e3.register = n2.register, a = r3(22448), o = Object.keys(a), s = 0; s < o.length; s++) {
          var l2 = o[s];
          "_" !== l2.charAt(0) && (e3[l2] = a[l2]), i({ moduleType: "apiMethod", name: l2, fn: a[l2] });
        }
        i(r3(65875)), i([r3(79180), r3(56864), r3(22676), r3(41592), r3(7402), r3(76908), r3(97544), r3(49692), r3(41152), r3(12704), r3(64968), r3(8932), r3(55080), r3(2780), r3(93024), r3(45460)]), i([r3(6580), r3(11680)]), window.PlotlyLocales && Array.isArray(window.PlotlyLocales) && (i(window.PlotlyLocales), delete window.PlotlyLocales), e3.Icons = r3(9224);
        var u2 = r3(93024), c2 = r3(7316);
        e3.Plots = { resize: c2.resize, graphJson: c2.graphJson, sendDataToCloud: c2.sendDataToCloud }, e3.Fx = { hover: u2.hover, unhover: u2.unhover, loneHover: u2.loneHover, loneUnhover: u2.loneUnhover }, e3.Snapshot = r3(78904), e3.PlotSchema = r3(73060);
      }, 9224: function(t2) {
        t2.exports = { undo: { width: 857.1, height: 1e3, path: "m857 350q0-87-34-166t-91-137-137-92-166-34q-96 0-183 41t-147 114q-4 6-4 13t5 11l76 77q6 5 14 5 9-1 13-7 41-53 100-82t126-29q58 0 110 23t92 61 61 91 22 111-22 111-61 91-92 61-110 23q-55 0-105-20t-90-57l77-77q17-16 8-38-10-23-33-23h-250q-15 0-25 11t-11 25v250q0 24 22 33 22 10 39-8l72-72q60 57 137 88t159 31q87 0 166-34t137-92 91-137 34-166z", transform: "matrix(1 0 0 -1 0 850)" }, home: { width: 928.6, height: 1e3, path: "m786 296v-267q0-15-11-26t-25-10h-214v214h-143v-214h-214q-15 0-25 10t-11 26v267q0 1 0 2t0 2l321 264 321-264q1-1 1-4z m124 39l-34-41q-5-5-12-6h-2q-7 0-12 3l-386 322-386-322q-7-4-13-4-7 2-12 7l-35 41q-4 5-3 13t6 12l401 334q18 15 42 15t43-15l136-114v109q0 8 5 13t13 5h107q8 0 13-5t5-13v-227l122-102q5-5 6-12t-4-13z", transform: "matrix(1 0 0 -1 0 850)" }, "camera-retro": { width: 1e3, height: 1e3, path: "m518 386q0 8-5 13t-13 5q-37 0-63-27t-26-63q0-8 5-13t13-5 12 5 5 13q0 23 16 38t38 16q8 0 13 5t5 13z m125-73q0-59-42-101t-101-42-101 42-42 101 42 101 101 42 101-42 42-101z m-572-320h858v71h-858v-71z m643 320q0 89-62 152t-152 62-151-62-63-152 63-151 151-63 152 63 62 151z m-571 358h214v72h-214v-72z m-72-107h858v143h-462l-36-71h-360v-72z m929 143v-714q0-30-21-51t-50-21h-858q-29 0-50 21t-21 51v714q0 30 21 51t50 21h858q29 0 50-21t21-51z", transform: "matrix(1 0 0 -1 0 850)" }, zoombox: { width: 1e3, height: 1e3, path: "m1000-25l-250 251c40 63 63 138 63 218 0 224-182 406-407 406-224 0-406-182-406-406s183-406 407-406c80 0 155 22 218 62l250-250 125 125z m-812 250l0 438 437 0 0-438-437 0z m62 375l313 0 0-312-313 0 0 312z", transform: "matrix(1 0 0 -1 0 850)" }, pan: { width: 1e3, height: 1e3, path: "m1000 350l-187 188 0-125-250 0 0 250 125 0-188 187-187-187 125 0 0-250-250 0 0 125-188-188 186-187 0 125 252 0 0-250-125 0 187-188 188 188-125 0 0 250 250 0 0-126 187 188z", transform: "matrix(1 0 0 -1 0 850)" }, zoom_plus: { width: 875, height: 1e3, path: "m1 787l0-875 875 0 0 875-875 0z m687-500l-187 0 0-187-125 0 0 187-188 0 0 125 188 0 0 187 125 0 0-187 187 0 0-125z", transform: "matrix(1 0 0 -1 0 850)" }, zoom_minus: { width: 875, height: 1e3, path: "m0 788l0-876 875 0 0 876-875 0z m688-500l-500 0 0 125 500 0 0-125z", transform: "matrix(1 0 0 -1 0 850)" }, autoscale: { width: 1e3, height: 1e3, path: "m250 850l-187 0-63 0 0-62 0-188 63 0 0 188 187 0 0 62z m688 0l-188 0 0-62 188 0 0-188 62 0 0 188 0 62-62 0z m-875-938l0 188-63 0 0-188 0-62 63 0 187 0 0 62-187 0z m875 188l0-188-188 0 0-62 188 0 62 0 0 62 0 188-62 0z m-125 188l-1 0-93-94-156 156 156 156 92-93 2 0 0 250-250 0 0-2 93-92-156-156-156 156 94 92 0 2-250 0 0-250 0 0 93 93 157-156-157-156-93 94 0 0 0-250 250 0 0 0-94 93 156 157 156-157-93-93 0 0 250 0 0 250z", transform: "matrix(1 0 0 -1 0 850)" }, tooltip_basic: { width: 1500, height: 1e3, path: "m375 725l0 0-375-375 375-374 0-1 1125 0 0 750-1125 0z", transform: "matrix(1 0 0 -1 0 850)" }, tooltip_compare: { width: 1125, height: 1e3, path: "m187 786l0 2-187-188 188-187 0 0 937 0 0 373-938 0z m0-499l0 1-187-188 188-188 0 0 937 0 0 376-938-1z", transform: "matrix(1 0 0 -1 0 850)" }, plotlylogo: { width: 1542, height: 1e3, path: "m0-10h182v-140h-182v140z m228 146h183v-286h-183v286z m225 714h182v-1000h-182v1000z m225-285h182v-715h-182v715z m225 142h183v-857h-183v857z m231-428h182v-429h-182v429z m225-291h183v-138h-183v138z", transform: "matrix(1 0 0 -1 0 850)" }, "z-axis": { width: 1e3, height: 1e3, path: "m833 5l-17 108v41l-130-65 130-66c0 0 0 38 0 39 0-1 36-14 39-25 4-15-6-22-16-30-15-12-39-16-56-20-90-22-187-23-279-23-261 0-341 34-353 59 3 60 228 110 228 110-140-8-351-35-351-116 0-120 293-142 474-142 155 0 477 22 477 142 0 50-74 79-163 96z m-374 94c-58-5-99-21-99-40 0-24 65-43 144-43 79 0 143 19 143 43 0 19-42 34-98 40v216h87l-132 135-133-135h88v-216z m167 515h-136v1c16 16 31 34 46 52l84 109v54h-230v-71h124v-1c-16-17-28-32-44-51l-89-114v-51h245v72z", transform: "matrix(1 0 0 -1 0 850)" }, "3d_rotate": { width: 1e3, height: 1e3, path: "m922 660c-5 4-9 7-14 11-359 263-580-31-580-31l-102 28 58-400c0 1 1 1 2 2 118 108 351 249 351 249s-62 27-100 42c88 83 222 183 347 122 16-8 30-17 44-27-2 1-4 2-6 4z m36-329c0 0 64 229-88 296-62 27-124 14-175-11 157-78 225-208 249-266 8-19 11-31 11-31 2 5 6 15 11 32-5-13-8-20-8-20z m-775-239c70-31 117-50 198-32-121 80-199 346-199 346l-96-15-58-12c0 0 55-226 155-287z m603 133l-317-139c0 0 4-4 19-14 7-5 24-15 24-15s-177-147-389 4c235-287 536-112 536-112l31-22 100 299-4-1z m-298-153c6-4 14-9 24-15 0 0-17 10-24 15z", transform: "matrix(1 0 0 -1 0 850)" }, camera: { width: 1e3, height: 1e3, path: "m500 450c-83 0-150-67-150-150 0-83 67-150 150-150 83 0 150 67 150 150 0 83-67 150-150 150z m400 150h-120c-16 0-34 13-39 29l-31 93c-6 15-23 28-40 28h-340c-16 0-34-13-39-28l-31-94c-6-15-23-28-40-28h-120c-55 0-100-45-100-100v-450c0-55 45-100 100-100h800c55 0 100 45 100 100v450c0 55-45 100-100 100z m-400-550c-138 0-250 112-250 250 0 138 112 250 250 250 138 0 250-112 250-250 0-138-112-250-250-250z m365 380c-19 0-35 16-35 35 0 19 16 35 35 35 19 0 35-16 35-35 0-19-16-35-35-35z", transform: "matrix(1 0 0 -1 0 850)" }, movie: { width: 1e3, height: 1e3, path: "m938 413l-188-125c0 37-17 71-44 94 64 38 107 107 107 187 0 121-98 219-219 219-121 0-219-98-219-219 0-61 25-117 66-156h-115c30 33 49 76 49 125 0 103-84 187-187 187s-188-84-188-187c0-57 26-107 65-141-38-22-65-62-65-109v-250c0-70 56-126 125-126h500c69 0 125 56 125 126l188-126c34 0 62 28 62 63v375c0 35-28 63-62 63z m-750 0c-69 0-125 56-125 125s56 125 125 125 125-56 125-125-56-125-125-125z m406-1c-87 0-157 70-157 157 0 86 70 156 157 156s156-70 156-156-70-157-156-157z", transform: "matrix(1 0 0 -1 0 850)" }, question: { width: 857.1, height: 1e3, path: "m500 82v107q0 8-5 13t-13 5h-107q-8 0-13-5t-5-13v-107q0-8 5-13t13-5h107q8 0 13 5t5 13z m143 375q0 49-31 91t-77 65-95 23q-136 0-207-119-9-14 4-24l74-55q4-4 10-4 9 0 14 7 30 38 48 51 19 14 48 14 27 0 48-15t21-33q0-21-11-34t-38-25q-35-16-65-48t-29-70v-20q0-8 5-13t13-5h107q8 0 13 5t5 13q0 10 12 27t30 28q18 10 28 16t25 19 25 27 16 34 7 45z m214-107q0-117-57-215t-156-156-215-58-216 58-155 156-58 215 58 215 155 156 216 58 215-58 156-156 57-215z", transform: "matrix(1 0 0 -1 0 850)" }, disk: { width: 857.1, height: 1e3, path: "m214-7h429v214h-429v-214z m500 0h72v500q0 8-6 21t-11 20l-157 156q-5 6-19 12t-22 5v-232q0-22-15-38t-38-16h-322q-22 0-37 16t-16 38v232h-72v-714h72v232q0 22 16 38t37 16h465q22 0 38-16t15-38v-232z m-214 518v178q0 8-5 13t-13 5h-107q-7 0-13-5t-5-13v-178q0-8 5-13t13-5h107q7 0 13 5t5 13z m357-18v-518q0-22-15-38t-38-16h-750q-23 0-38 16t-16 38v750q0 22 16 38t38 16h517q23 0 50-12t42-26l156-157q16-15 27-42t11-49z", transform: "matrix(1 0 0 -1 0 850)" }, drawopenpath: { width: 70, height: 70, path: "M33.21,85.65a7.31,7.31,0,0,1-2.59-.48c-8.16-3.11-9.27-19.8-9.88-41.3-.1-3.58-.19-6.68-.35-9-.15-2.1-.67-3.48-1.43-3.79-2.13-.88-7.91,2.32-12,5.86L3,32.38c1.87-1.64,11.55-9.66,18.27-6.9,2.13.87,4.75,3.14,5.17,9,.17,2.43.26,5.59.36,9.25a224.17,224.17,0,0,0,1.5,23.4c1.54,10.76,4,12.22,4.48,12.4.84.32,2.79-.46,5.76-3.59L43,80.07C41.53,81.57,37.68,85.64,33.21,85.65ZM74.81,69a11.34,11.34,0,0,0,6.09-6.72L87.26,44.5,74.72,32,56.9,38.35c-2.37.86-5.57,3.42-6.61,6L38.65,72.14l8.42,8.43ZM55,46.27a7.91,7.91,0,0,1,3.64-3.17l14.8-5.3,8,8L76.11,60.6l-.06.19a6.37,6.37,0,0,1-3,3.43L48.25,74.59,44.62,71Zm16.57,7.82A6.9,6.9,0,1,0,64.64,61,6.91,6.91,0,0,0,71.54,54.09Zm-4.05,0a2.85,2.85,0,1,1-2.85-2.85A2.86,2.86,0,0,1,67.49,54.09Zm-4.13,5.22L60.5,56.45,44.26,72.7l2.86,2.86ZM97.83,35.67,84.14,22l-8.57,8.57L89.26,44.24Zm-13.69-8,8,8-2.85,2.85-8-8Z", transform: "matrix(1 0 0 1 -15 -15)" }, drawclosedpath: { width: 90, height: 90, path: "M88.41,21.12a26.56,26.56,0,0,0-36.18,0l-2.07,2-2.07-2a26.57,26.57,0,0,0-36.18,0,23.74,23.74,0,0,0,0,34.8L48,90.12a3.22,3.22,0,0,0,4.42,0l36-34.21a23.73,23.73,0,0,0,0-34.79ZM84,51.24,50.16,83.35,16.35,51.25a17.28,17.28,0,0,1,0-25.47,20,20,0,0,1,27.3,0l4.29,4.07a3.23,3.23,0,0,0,4.44,0l4.29-4.07a20,20,0,0,1,27.3,0,17.27,17.27,0,0,1,0,25.46ZM66.76,47.68h-33v6.91h33ZM53.35,35H46.44V68h6.91Z", transform: "matrix(1 0 0 1 -5 -5)" }, lasso: { width: 1031, height: 1e3, path: "m1018 538c-36 207-290 336-568 286-277-48-473-256-436-463 10-57 36-108 76-151-13-66 11-137 68-183 34-28 75-41 114-42l-55-70 0 0c-2-1-3-2-4-3-10-14-8-34 5-45 14-11 34-8 45 4 1 1 2 3 2 5l0 0 113 140c16 11 31 24 45 40 4 3 6 7 8 11 48-3 100 0 151 9 278 48 473 255 436 462z m-624-379c-80 14-149 48-197 96 42 42 109 47 156 9 33-26 47-66 41-105z m-187-74c-19 16-33 37-39 60 50-32 109-55 174-68-42-25-95-24-135 8z m360 75c-34-7-69-9-102-8 8 62-16 128-68 170-73 59-175 54-244-5-9 20-16 40-20 61-28 159 121 317 333 354s407-60 434-217c28-159-121-318-333-355z", transform: "matrix(1 0 0 -1 0 850)" }, selectbox: { width: 1e3, height: 1e3, path: "m0 850l0-143 143 0 0 143-143 0z m286 0l0-143 143 0 0 143-143 0z m285 0l0-143 143 0 0 143-143 0z m286 0l0-143 143 0 0 143-143 0z m-857-286l0-143 143 0 0 143-143 0z m857 0l0-143 143 0 0 143-143 0z m-857-285l0-143 143 0 0 143-143 0z m857 0l0-143 143 0 0 143-143 0z m-857-286l0-143 143 0 0 143-143 0z m286 0l0-143 143 0 0 143-143 0z m285 0l0-143 143 0 0 143-143 0z m286 0l0-143 143 0 0 143-143 0z", transform: "matrix(1 0 0 -1 0 850)" }, drawline: { width: 70, height: 70, path: "M60.64,62.3a11.29,11.29,0,0,0,6.09-6.72l6.35-17.72L60.54,25.31l-17.82,6.4c-2.36.86-5.57,3.41-6.6,6L24.48,65.5l8.42,8.42ZM40.79,39.63a7.89,7.89,0,0,1,3.65-3.17l14.79-5.31,8,8L61.94,54l-.06.19a6.44,6.44,0,0,1-3,3.43L34.07,68l-3.62-3.63Zm16.57,7.81a6.9,6.9,0,1,0-6.89,6.9A6.9,6.9,0,0,0,57.36,47.44Zm-4,0a2.86,2.86,0,1,1-2.85-2.85A2.86,2.86,0,0,1,53.32,47.44Zm-4.13,5.22L46.33,49.8,30.08,66.05l2.86,2.86ZM83.65,29,70,15.34,61.4,23.9,75.09,37.59ZM70,21.06l8,8-2.84,2.85-8-8ZM87,80.49H10.67V87H87Z", transform: "matrix(1 0 0 1 -15 -15)" }, drawrect: { width: 80, height: 80, path: "M78,22V79H21V22H78m9-9H12V88H87V13ZM68,46.22H31V54H68ZM53,32H45.22V69H53Z", transform: "matrix(1 0 0 1 -10 -10)" }, drawcircle: { width: 80, height: 80, path: "M50,84.72C26.84,84.72,8,69.28,8,50.3S26.84,15.87,50,15.87,92,31.31,92,50.3,73.16,84.72,50,84.72Zm0-60.59c-18.6,0-33.74,11.74-33.74,26.17S31.4,76.46,50,76.46,83.74,64.72,83.74,50.3,68.6,24.13,50,24.13Zm17.15,22h-34v7.11h34Zm-13.8-13H46.24v34h7.11Z", transform: "matrix(1 0 0 1 -10 -10)" }, eraseshape: { width: 80, height: 80, path: "M82.77,78H31.85L6,49.57,31.85,21.14H82.77a8.72,8.72,0,0,1,8.65,8.77V69.24A8.72,8.72,0,0,1,82.77,78ZM35.46,69.84H82.77a.57.57,0,0,0,.49-.6V29.91a.57.57,0,0,0-.49-.61H35.46L17,49.57Zm32.68-34.7-24,24,5,5,24-24Zm-19,.53-5,5,24,24,5-5Z", transform: "matrix(1 0 0 1 -10 -10)" }, spikeline: { width: 1e3, height: 1e3, path: "M512 409c0-57-46-104-103-104-57 0-104 47-104 104 0 57 47 103 104 103 57 0 103-46 103-103z m-327-39l92 0 0 92-92 0z m-185 0l92 0 0 92-92 0z m370-186l92 0 0 93-92 0z m0-184l92 0 0 92-92 0z", transform: "matrix(1.5 0 0 -1.5 0 850)" }, pencil: { width: 1792, height: 1792, path: "M491 1536l91-91-235-235-91 91v107h128v128h107zm523-928q0-22-22-22-10 0-17 7l-542 542q-7 7-7 17 0 22 22 22 10 0 17-7l542-542q7-7 7-17zm-54-192l416 416-832 832h-416v-416zm683 96q0 53-37 90l-166 166-416-416 166-165q36-38 90-38 53 0 91 38l235 234q37 39 37 91z", transform: "matrix(1 0 0 1 0 1)" }, newplotlylogo: { name: "newplotlylogo", svg: ["<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 132 132'>", "<defs>", " <style>", "  .cls-0{fill:#000;}", "  .cls-1{fill:#FFF;}", "  .cls-2{fill:#F26;}", "  .cls-3{fill:#D69;}", "  .cls-4{fill:#BAC;}", "  .cls-5{fill:#9EF;}", " </style>", "</defs>", " <title>plotly-logomark</title>", " <g id='symbol'>", "  <rect class='cls-0' x='0' y='0' width='132' height='132' rx='18' ry='18'/>", "  <circle class='cls-5' cx='102' cy='30' r='6'/>", "  <circle class='cls-4' cx='78' cy='30' r='6'/>", "  <circle class='cls-4' cx='78' cy='54' r='6'/>", "  <circle class='cls-3' cx='54' cy='30' r='6'/>", "  <circle class='cls-2' cx='30' cy='30' r='6'/>", "  <circle class='cls-2' cx='30' cy='54' r='6'/>", "  <path class='cls-1' d='M30,72a6,6,0,0,0-6,6v24a6,6,0,0,0,12,0V78A6,6,0,0,0,30,72Z'/>", "  <path class='cls-1' d='M78,72a6,6,0,0,0-6,6v24a6,6,0,0,0,12,0V78A6,6,0,0,0,78,72Z'/>", "  <path class='cls-1' d='M54,48a6,6,0,0,0-6,6v48a6,6,0,0,0,12,0V54A6,6,0,0,0,54,48Z'/>", "  <path class='cls-1' d='M102,48a6,6,0,0,0-6,6v48a6,6,0,0,0,12,0V54A6,6,0,0,0,102,48Z'/>", " </g>", "</svg>"].join("") } };
      }, 98308: function(t2, e3) {
        e3.isLeftAnchor = function(t3) {
          return "left" === t3.xanchor || "auto" === t3.xanchor && t3.x <= 1 / 3;
        }, e3.isCenterAnchor = function(t3) {
          return "center" === t3.xanchor || "auto" === t3.xanchor && t3.x > 1 / 3 && t3.x < 2 / 3;
        }, e3.isRightAnchor = function(t3) {
          return "right" === t3.xanchor || "auto" === t3.xanchor && t3.x >= 2 / 3;
        }, e3.isTopAnchor = function(t3) {
          return "top" === t3.yanchor || "auto" === t3.yanchor && t3.y >= 2 / 3;
        }, e3.isMiddleAnchor = function(t3) {
          return "middle" === t3.yanchor || "auto" === t3.yanchor && t3.y > 1 / 3 && t3.y < 2 / 3;
        }, e3.isBottomAnchor = function(t3) {
          return "bottom" === t3.yanchor || "auto" === t3.yanchor && t3.y <= 1 / 3;
        };
      }, 11864: function(t2, e3, r3) {
        var n2 = r3(20435), i = n2.mod, a = n2.modHalf, o = Math.PI, s = 2 * o;
        function l2(t3) {
          return Math.abs(t3[1] - t3[0]) > s - 1e-14;
        }
        function u2(t3, e4) {
          return a(e4 - t3, s);
        }
        function c2(t3, e4) {
          if (l2(e4))
            return true;
          var r4, n3;
          e4[0] < e4[1] ? (r4 = e4[0], n3 = e4[1]) : (r4 = e4[1], n3 = e4[0]), (r4 = i(r4, s)) > (n3 = i(n3, s)) && (n3 += s);
          var a2 = i(t3, s), o2 = a2 + s;
          return a2 >= r4 && a2 <= n3 || o2 >= r4 && o2 <= n3;
        }
        function f2(t3, e4, r4, n3, i2, a2, u3) {
          i2 = i2 || 0, a2 = a2 || 0;
          var c3, f3, h2, p2, d2, v2 = l2([r4, n3]);
          function g2(t4, e5) {
            return [t4 * Math.cos(e5) + i2, a2 - t4 * Math.sin(e5)];
          }
          v2 ? (c3 = 0, f3 = o, h2 = s) : r4 < n3 ? (c3 = r4, h2 = n3) : (c3 = n3, h2 = r4), t3 < e4 ? (p2 = t3, d2 = e4) : (p2 = e4, d2 = t3);
          var y2, m2 = Math.abs(h2 - c3) <= o ? 0 : 1;
          function x(t4, e5, r5) {
            return "A" + [t4, t4] + " " + [0, m2, r5] + " " + g2(t4, e5);
          }
          return v2 ? y2 = null === p2 ? "M" + g2(d2, c3) + x(d2, f3, 0) + x(d2, h2, 0) + "Z" : "M" + g2(p2, c3) + x(p2, f3, 0) + x(p2, h2, 0) + "ZM" + g2(d2, c3) + x(d2, f3, 1) + x(d2, h2, 1) + "Z" : null === p2 ? (y2 = "M" + g2(d2, c3) + x(d2, h2, 0), u3 && (y2 += "L0,0Z")) : y2 = "M" + g2(p2, c3) + "L" + g2(d2, c3) + x(d2, h2, 0) + "L" + g2(p2, h2) + x(p2, c3, 1) + "Z", y2;
        }
        t2.exports = { deg2rad: function(t3) {
          return t3 / 180 * o;
        }, rad2deg: function(t3) {
          return t3 / o * 180;
        }, angleDelta: u2, angleDist: function(t3, e4) {
          return Math.abs(u2(t3, e4));
        }, isFullCircle: l2, isAngleInsideSector: c2, isPtInsideSector: function(t3, e4, r4, n3) {
          return !!c2(e4, n3) && (r4[0] < r4[1] ? (i2 = r4[0], a2 = r4[1]) : (i2 = r4[1], a2 = r4[0]), t3 >= i2 && t3 <= a2);
          var i2, a2;
        }, pathArc: function(t3, e4, r4, n3, i2) {
          return f2(null, t3, e4, r4, n3, i2, 0);
        }, pathSector: function(t3, e4, r4, n3, i2) {
          return f2(null, t3, e4, r4, n3, i2, 1);
        }, pathAnnulus: function(t3, e4, r4, n3, i2, a2) {
          return f2(t3, e4, r4, n3, i2, a2, 1);
        } };
      }, 38116: function(t2, e3, r3) {
        var n2 = r3(83160).decode, i = r3(63620), a = Array.isArray, o = ArrayBuffer, s = DataView;
        function l2(t3) {
          return o.isView(t3) && !(t3 instanceof s);
        }
        function u2(t3) {
          return a(t3) || l2(t3);
        }
        e3.isTypedArray = l2, e3.isArrayOrTypedArray = u2, e3.isArray1D = function(t3) {
          return !u2(t3[0]);
        }, e3.ensureArray = function(t3, e4) {
          return a(t3) || (t3 = []), t3.length = e4, t3;
        };
        var c2 = { u1c: "undefined" == typeof Uint8ClampedArray ? void 0 : Uint8ClampedArray, i1: "undefined" == typeof Int8Array ? void 0 : Int8Array, u1: "undefined" == typeof Uint8Array ? void 0 : Uint8Array, i2: "undefined" == typeof Int16Array ? void 0 : Int16Array, u2: "undefined" == typeof Uint16Array ? void 0 : Uint16Array, i4: "undefined" == typeof Int32Array ? void 0 : Int32Array, u4: "undefined" == typeof Uint32Array ? void 0 : Uint32Array, f4: "undefined" == typeof Float32Array ? void 0 : Float32Array, f8: "undefined" == typeof Float64Array ? void 0 : Float64Array };
        function f2(t3) {
          return t3.constructor === ArrayBuffer;
        }
        function h2(t3, e4, r4) {
          if (u2(t3)) {
            if (u2(t3[0])) {
              for (var n3 = r4, i2 = 0; i2 < t3.length; i2++)
                n3 = e4(n3, t3[i2].length);
              return n3;
            }
            return t3.length;
          }
          return 0;
        }
        c2.uint8c = c2.u1c, c2.uint8 = c2.u1, c2.int8 = c2.i1, c2.uint16 = c2.u2, c2.int16 = c2.i2, c2.uint32 = c2.u4, c2.int32 = c2.i4, c2.float32 = c2.f4, c2.float64 = c2.f8, e3.isArrayBuffer = f2, e3.decodeTypedArraySpec = function(t3) {
          var e4 = [], r4 = function(t4) {
            return { bdata: t4.bdata, dtype: t4.dtype, shape: t4.shape };
          }(t3), i2 = r4.dtype, a2 = c2[i2];
          if (!a2)
            throw new Error('Error in dtype: "' + i2 + '"');
          var o2 = a2.BYTES_PER_ELEMENT, s2 = r4.bdata;
          f2(s2) || (s2 = n2(s2));
          var l3 = void 0 === r4.shape ? [s2.byteLength / o2] : ("" + r4.shape).split(",");
          l3.reverse();
          var u3, h3, p2 = l3.length, d2 = +l3[0], v2 = o2 * d2, g2 = 0;
          if (1 === p2)
            e4 = new a2(s2);
          else if (2 === p2)
            for (u3 = +l3[1], h3 = 0; h3 < u3; h3++)
              e4[h3] = new a2(s2, g2, d2), g2 += v2;
          else {
            if (3 !== p2)
              throw new Error("ndim: " + p2 + 'is not supported with the shape:"' + r4.shape + '"');
            u3 = +l3[1];
            for (var y2 = +l3[2], m2 = 0; m2 < y2; m2++)
              for (e4[m2] = [], h3 = 0; h3 < u3; h3++)
                e4[m2][h3] = new a2(s2, g2, d2), g2 += v2;
          }
          return e4.bdata = r4.bdata, e4.dtype = r4.dtype, e4.shape = l3.reverse().join(","), t3._inputArray = e4, e4;
        }, e3.isTypedArraySpec = function(t3) {
          return i(t3) && t3.hasOwnProperty("dtype") && "string" == typeof t3.dtype && t3.hasOwnProperty("bdata") && ("string" == typeof t3.bdata || f2(t3.bdata)) && (void 0 === t3.shape || t3.hasOwnProperty("shape") && ("string" == typeof t3.shape || "number" == typeof t3.shape));
        }, e3.concat = function() {
          var t3, e4, r4, n3, i2, o2, s2, l3, u3 = [], c3 = true, f3 = 0;
          for (r4 = 0; r4 < arguments.length; r4++)
            (o2 = (n3 = arguments[r4]).length) && (e4 ? u3.push(n3) : (e4 = n3, i2 = o2), a(n3) ? t3 = false : (c3 = false, f3 ? t3 !== n3.constructor && (t3 = false) : t3 = n3.constructor), f3 += o2);
          if (!f3)
            return [];
          if (!u3.length)
            return e4;
          if (c3)
            return e4.concat.apply(e4, u3);
          if (t3) {
            for ((s2 = new t3(f3)).set(e4), r4 = 0; r4 < u3.length; r4++)
              n3 = u3[r4], s2.set(n3, i2), i2 += n3.length;
            return s2;
          }
          for (s2 = new Array(f3), l3 = 0; l3 < e4.length; l3++)
            s2[l3] = e4[l3];
          for (r4 = 0; r4 < u3.length; r4++) {
            for (n3 = u3[r4], l3 = 0; l3 < n3.length; l3++)
              s2[i2 + l3] = n3[l3];
            i2 += l3;
          }
          return s2;
        }, e3.maxRowLength = function(t3) {
          return h2(t3, Math.max, 0);
        }, e3.minRowLength = function(t3) {
          return h2(t3, Math.min, 1 / 0);
        };
      }, 54037: function(t2, e3, r3) {
        var n2 = r3(38248), i = r3(39032).BADNUM, a = /^['"%,$#\s']+|[, ]|['"%,$#\s']+$/g;
        t2.exports = function(t3) {
          return "string" == typeof t3 && (t3 = t3.replace(a, "")), n2(t3) ? Number(t3) : i;
        };
      }, 73696: function(t2) {
        t2.exports = function(t3) {
          var e3 = t3._fullLayout;
          e3._glcanvas && e3._glcanvas.size() && e3._glcanvas.each(function(t4) {
            t4.regl && t4.regl.clear({ color: true, depth: true });
          });
        };
      }, 75352: function(t2) {
        t2.exports = function(t3) {
          t3._responsiveChartHandler && (window.removeEventListener("resize", t3._responsiveChartHandler), delete t3._responsiveChartHandler);
        };
      }, 63064: function(t2, e3, r3) {
        var n2 = r3(38248), i = r3(49760), a = r3(45464), o = r3(88304), s = r3(76308), l2 = r3(13448).DESELECTDIM, u2 = r3(22296), c2 = r3(53756).counter, f2 = r3(20435).modHalf, h2 = r3(38116).isArrayOrTypedArray, p2 = r3(38116).isTypedArraySpec, d2 = r3(38116).decodeTypedArraySpec;
        function v2(t3, r4) {
          var n3 = e3.valObjectMeta[r4.valType];
          if (r4.arrayOk && h2(t3))
            return true;
          if (n3.validateFunction)
            return n3.validateFunction(t3, r4);
          var i2 = {}, a2 = i2, o2 = { set: function(t4) {
            a2 = t4;
          } };
          return n3.coerceFunction(t3, o2, i2, r4), a2 !== i2;
        }
        e3.valObjectMeta = { data_array: { coerceFunction: function(t3, e4, r4) {
          e4.set(h2(t3) ? t3 : p2(t3) ? d2(t3) : r4);
        } }, enumerated: { coerceFunction: function(t3, e4, r4, n3) {
          n3.coerceNumber && (t3 = +t3), -1 === n3.values.indexOf(t3) ? e4.set(r4) : e4.set(t3);
        }, validateFunction: function(t3, e4) {
          e4.coerceNumber && (t3 = +t3);
          for (var r4 = e4.values, n3 = 0; n3 < r4.length; n3++) {
            var i2 = String(r4[n3]);
            if ("/" === i2.charAt(0) && "/" === i2.charAt(i2.length - 1)) {
              if (new RegExp(i2.substr(1, i2.length - 2)).test(t3))
                return true;
            } else if (t3 === r4[n3])
              return true;
          }
          return false;
        } }, boolean: { coerceFunction: function(t3, e4, r4) {
          true === t3 || false === t3 ? e4.set(t3) : e4.set(r4);
        } }, number: { coerceFunction: function(t3, e4, r4, i2) {
          !n2(t3) || void 0 !== i2.min && t3 < i2.min || void 0 !== i2.max && t3 > i2.max ? e4.set(r4) : e4.set(+t3);
        } }, integer: { coerceFunction: function(t3, e4, r4, i2) {
          t3 % 1 || !n2(t3) || void 0 !== i2.min && t3 < i2.min || void 0 !== i2.max && t3 > i2.max ? e4.set(r4) : e4.set(+t3);
        } }, string: { coerceFunction: function(t3, e4, r4, n3) {
          if ("string" != typeof t3) {
            var i2 = "number" == typeof t3;
            true !== n3.strict && i2 ? e4.set(String(t3)) : e4.set(r4);
          } else
            n3.noBlank && !t3 ? e4.set(r4) : e4.set(t3);
        } }, color: { coerceFunction: function(t3, e4, r4) {
          i(t3).isValid() ? e4.set(t3) : e4.set(r4);
        } }, colorlist: { coerceFunction: function(t3, e4, r4) {
          Array.isArray(t3) && t3.length && t3.every(function(t4) {
            return i(t4).isValid();
          }) ? e4.set(t3) : e4.set(r4);
        } }, colorscale: { coerceFunction: function(t3, e4, r4) {
          e4.set(o.get(t3, r4));
        } }, angle: { coerceFunction: function(t3, e4, r4) {
          "auto" === t3 ? e4.set("auto") : n2(t3) ? e4.set(f2(+t3, 360)) : e4.set(r4);
        } }, subplotid: { coerceFunction: function(t3, e4, r4, n3) {
          var i2 = n3.regex || c2(r4);
          "string" == typeof t3 && i2.test(t3) ? e4.set(t3) : e4.set(r4);
        }, validateFunction: function(t3, e4) {
          var r4 = e4.dflt;
          return t3 === r4 || "string" == typeof t3 && !!c2(r4).test(t3);
        } }, flaglist: { coerceFunction: function(t3, e4, r4, n3) {
          if (-1 === (n3.extras || []).indexOf(t3))
            if ("string" == typeof t3) {
              for (var i2 = t3.split("+"), a2 = 0; a2 < i2.length; ) {
                var o2 = i2[a2];
                -1 === n3.flags.indexOf(o2) || i2.indexOf(o2) < a2 ? i2.splice(a2, 1) : a2++;
              }
              i2.length ? e4.set(i2.join("+")) : e4.set(r4);
            } else
              e4.set(r4);
          else
            e4.set(t3);
        } }, any: { coerceFunction: function(t3, e4, r4) {
          void 0 === t3 ? e4.set(r4) : e4.set(p2(t3) ? d2(t3) : t3);
        } }, info_array: { coerceFunction: function(t3, r4, n3, i2) {
          function a2(t4, r5, n4) {
            var i3, a3 = { set: function(t5) {
              i3 = t5;
            } };
            return void 0 === n4 && (n4 = r5.dflt), e3.valObjectMeta[r5.valType].coerceFunction(t4, a3, n4, r5), i3;
          }
          if (p2(t3) && (t3 = d2(t3)), h2(t3)) {
            var o2, s2, l3, u3, c3, f3, v3 = 2 === i2.dimensions || "1-2" === i2.dimensions && Array.isArray(t3) && h2(t3[0]), g2 = i2.items, y2 = [], m2 = Array.isArray(g2), x = m2 && v3 && h2(g2[0]), b2 = v3 && m2 && !x, _ = m2 && !b2 ? g2.length : t3.length;
            if (n3 = Array.isArray(n3) ? n3 : [], v3)
              for (o2 = 0; o2 < _; o2++)
                for (y2[o2] = [], l3 = h2(t3[o2]) ? t3[o2] : [], c3 = b2 ? g2.length : m2 ? g2[o2].length : l3.length, s2 = 0; s2 < c3; s2++)
                  u3 = b2 ? g2[s2] : m2 ? g2[o2][s2] : g2, void 0 !== (f3 = a2(l3[s2], u3, (n3[o2] || [])[s2])) && (y2[o2][s2] = f3);
            else
              for (o2 = 0; o2 < _; o2++)
                void 0 !== (f3 = a2(t3[o2], m2 ? g2[o2] : g2, n3[o2])) && (y2[o2] = f3);
            r4.set(y2);
          } else
            r4.set(n3);
        }, validateFunction: function(t3, e4) {
          if (!h2(t3))
            return false;
          var r4 = e4.items, n3 = Array.isArray(r4), i2 = 2 === e4.dimensions;
          if (!e4.freeLength && t3.length !== r4.length)
            return false;
          for (var a2 = 0; a2 < t3.length; a2++)
            if (i2) {
              if (!h2(t3[a2]) || !e4.freeLength && t3[a2].length !== r4[a2].length)
                return false;
              for (var o2 = 0; o2 < t3[a2].length; o2++)
                if (!v2(t3[a2][o2], n3 ? r4[a2][o2] : r4))
                  return false;
            } else if (!v2(t3[a2], n3 ? r4[a2] : r4))
              return false;
          return true;
        } } }, e3.coerce = function(t3, r4, n3, i2, a2) {
          var o2 = u2(n3, i2).get(), s2 = u2(t3, i2), l3 = u2(r4, i2), c3 = s2.get(), f3 = r4._template;
          if (void 0 === c3 && f3 && (c3 = u2(f3, i2).get(), f3 = 0), void 0 === a2 && (a2 = o2.dflt), o2.arrayOk) {
            if (h2(c3))
              return l3.set(c3), c3;
            if (p2(c3))
              return c3 = d2(c3), l3.set(c3), c3;
          }
          var g2 = e3.valObjectMeta[o2.valType].coerceFunction;
          g2(c3, l3, a2, o2);
          var y2 = l3.get();
          return f3 && y2 === a2 && !v2(c3, o2) && (g2(c3 = u2(f3, i2).get(), l3, a2, o2), y2 = l3.get()), y2;
        }, e3.coerce2 = function(t3, r4, n3, i2, a2) {
          var o2 = u2(t3, i2), s2 = e3.coerce(t3, r4, n3, i2, a2);
          return null != o2.get() && s2;
        }, e3.coerceFont = function(t3, e4, r4) {
          var n3 = {};
          return r4 = r4 || {}, n3.family = t3(e4 + ".family", r4.family), n3.size = t3(e4 + ".size", r4.size), n3.color = t3(e4 + ".color", r4.color), n3;
        }, e3.coercePattern = function(t3, e4, r4, n3) {
          if (t3(e4 + ".shape")) {
            t3(e4 + ".solidity"), t3(e4 + ".size");
            var i2 = "overlay" === t3(e4 + ".fillmode");
            if (!n3) {
              var a2 = t3(e4 + ".bgcolor", i2 ? r4 : void 0);
              t3(e4 + ".fgcolor", i2 ? s.contrast(a2) : r4);
            }
            t3(e4 + ".fgopacity", i2 ? 0.5 : 1);
          }
        }, e3.coerceHoverinfo = function(t3, r4, n3) {
          var i2, o2 = r4._module.attributes, s2 = o2.hoverinfo ? o2 : a, l3 = s2.hoverinfo;
          if (1 === n3._dataLength) {
            var u3 = "all" === l3.dflt ? l3.flags.slice() : l3.dflt.split("+");
            u3.splice(u3.indexOf("name"), 1), i2 = u3.join("+");
          }
          return e3.coerce(t3, r4, s2, "hoverinfo", i2);
        }, e3.coerceSelectionMarkerOpacity = function(t3, e4) {
          if (t3.marker) {
            var r4, n3, i2 = t3.marker.opacity;
            void 0 !== i2 && (h2(i2) || t3.selected || t3.unselected || (r4 = i2, n3 = l2 * i2), e4("selected.marker.opacity", r4), e4("unselected.marker.opacity", n3));
          }
        }, e3.validate = v2;
      }, 67555: function(t2, e3, r3) {
        var n2, i, a = r3(94336).Yn, o = r3(38248), s = r3(24248), l2 = r3(20435).mod, u2 = r3(39032), c2 = u2.BADNUM, f2 = u2.ONEDAY, h2 = u2.ONEHOUR, p2 = u2.ONEMIN, d2 = u2.ONESEC, v2 = u2.EPOCHJD, g2 = r3(24040), y2 = r3(94336).E9, m2 = /^\s*(-?\d\d\d\d|\d\d)(-(\d?\d)(-(\d?\d)([ Tt]([01]?\d|2[0-3])(:([0-5]\d)(:([0-5]\d(\.\d+)?))?(Z|z|[+\-]\d\d(:?\d\d)?)?)?)?)?)?\s*$/m, x = /^\s*(-?\d\d\d\d|\d\d)(-(\d?\di?)(-(\d?\d)([ Tt]([01]?\d|2[0-3])(:([0-5]\d)(:([0-5]\d(\.\d+)?))?(Z|z|[+\-]\d\d(:?\d\d)?)?)?)?)?)?\s*$/m, b2 = new Date().getFullYear() - 70;
        function _(t3) {
          return t3 && g2.componentsRegistry.calendars && "string" == typeof t3 && "gregorian" !== t3;
        }
        function w2(t3, e4) {
          return String(t3 + Math.pow(10, e4)).substr(1);
        }
        e3.dateTick0 = function(t3, r4) {
          var n3 = function(t4, e4) {
            return _(t4) ? e4 ? g2.getComponentMethod("calendars", "CANONICAL_SUNDAY")[t4] : g2.getComponentMethod("calendars", "CANONICAL_TICK")[t4] : e4 ? "2000-01-02" : "2000-01-01";
          }(t3, !!r4);
          if (r4 < 2)
            return n3;
          var i2 = e3.dateTime2ms(n3, t3);
          return i2 += f2 * (r4 - 1), e3.ms2DateTime(i2, 0, t3);
        }, e3.dfltRange = function(t3) {
          return _(t3) ? g2.getComponentMethod("calendars", "DFLTRANGE")[t3] : ["2000-01-01", "2001-01-01"];
        }, e3.isJSDate = function(t3) {
          return "object" == typeof t3 && null !== t3 && "function" == typeof t3.getTime;
        }, e3.dateTime2ms = function(t3, r4) {
          if (e3.isJSDate(t3)) {
            var a2 = t3.getTimezoneOffset() * p2, o2 = (t3.getUTCMinutes() - t3.getMinutes()) * p2 + (t3.getUTCSeconds() - t3.getSeconds()) * d2 + (t3.getUTCMilliseconds() - t3.getMilliseconds());
            if (o2) {
              var s2 = 3 * p2;
              a2 = a2 - s2 / 2 + l2(o2 - a2 + s2 / 2, s2);
            }
            return (t3 = Number(t3) - a2) >= n2 && t3 <= i ? t3 : c2;
          }
          if ("string" != typeof t3 && "number" != typeof t3)
            return c2;
          t3 = String(t3);
          var u3 = _(r4), y3 = t3.charAt(0);
          !u3 || "G" !== y3 && "g" !== y3 || (t3 = t3.substr(1), r4 = "");
          var w3 = u3 && "chinese" === r4.substr(0, 7), T2 = t3.match(w3 ? x : m2);
          if (!T2)
            return c2;
          var k3 = T2[1], A3 = T2[3] || "1", M2 = Number(T2[5] || 1), S2 = Number(T2[7] || 0), E3 = Number(T2[9] || 0), L2 = Number(T2[11] || 0);
          if (u3) {
            if (2 === k3.length)
              return c2;
            var C3;
            k3 = Number(k3);
            try {
              var P2 = g2.getComponentMethod("calendars", "getCal")(r4);
              if (w3) {
                var O2 = "i" === A3.charAt(A3.length - 1);
                A3 = parseInt(A3, 10), C3 = P2.newDate(k3, P2.toMonthIndex(k3, A3, O2), M2);
              } else
                C3 = P2.newDate(k3, Number(A3), M2);
            } catch (t4) {
              return c2;
            }
            return C3 ? (C3.toJD() - v2) * f2 + S2 * h2 + E3 * p2 + L2 * d2 : c2;
          }
          k3 = 2 === k3.length ? (Number(k3) + 2e3 - b2) % 100 + b2 : Number(k3), A3 -= 1;
          var I2 = new Date(Date.UTC(2e3, A3, M2, S2, E3));
          return I2.setUTCFullYear(k3), I2.getUTCMonth() !== A3 || I2.getUTCDate() !== M2 ? c2 : I2.getTime() + L2 * d2;
        }, n2 = e3.MIN_MS = e3.dateTime2ms("-9999"), i = e3.MAX_MS = e3.dateTime2ms("9999-12-31 23:59:59.9999"), e3.isDateTime = function(t3, r4) {
          return e3.dateTime2ms(t3, r4) !== c2;
        };
        var T = 90 * f2, k2 = 3 * h2, A2 = 5 * p2;
        function M(t3, e4, r4, n3, i2) {
          if ((e4 || r4 || n3 || i2) && (t3 += " " + w2(e4, 2) + ":" + w2(r4, 2), (n3 || i2) && (t3 += ":" + w2(n3, 2), i2))) {
            for (var a2 = 4; i2 % 10 == 0; )
              a2 -= 1, i2 /= 10;
            t3 += "." + w2(i2, a2);
          }
          return t3;
        }
        e3.ms2DateTime = function(t3, e4, r4) {
          if ("number" != typeof t3 || !(t3 >= n2 && t3 <= i))
            return c2;
          e4 || (e4 = 0);
          var a2, o2, s2, u3, m3, x2, b3 = Math.floor(10 * l2(t3 + 0.05, 1)), w3 = Math.round(t3 - b3 / 10);
          if (_(r4)) {
            var S2 = Math.floor(w3 / f2) + v2, E3 = Math.floor(l2(t3, f2));
            try {
              a2 = g2.getComponentMethod("calendars", "getCal")(r4).fromJD(S2).formatDate("yyyy-mm-dd");
            } catch (t4) {
              a2 = y2("G%Y-%m-%d")(new Date(w3));
            }
            if ("-" === a2.charAt(0))
              for (; a2.length < 11; )
                a2 = "-0" + a2.substr(1);
            else
              for (; a2.length < 10; )
                a2 = "0" + a2;
            o2 = e4 < T ? Math.floor(E3 / h2) : 0, s2 = e4 < T ? Math.floor(E3 % h2 / p2) : 0, u3 = e4 < k2 ? Math.floor(E3 % p2 / d2) : 0, m3 = e4 < A2 ? E3 % d2 * 10 + b3 : 0;
          } else
            x2 = new Date(w3), a2 = y2("%Y-%m-%d")(x2), o2 = e4 < T ? x2.getUTCHours() : 0, s2 = e4 < T ? x2.getUTCMinutes() : 0, u3 = e4 < k2 ? x2.getUTCSeconds() : 0, m3 = e4 < A2 ? 10 * x2.getUTCMilliseconds() + b3 : 0;
          return M(a2, o2, s2, u3, m3);
        }, e3.ms2DateTimeLocal = function(t3) {
          if (!(t3 >= n2 + f2 && t3 <= i - f2))
            return c2;
          var e4 = Math.floor(10 * l2(t3 + 0.05, 1)), r4 = new Date(Math.round(t3 - e4 / 10));
          return M(a("%Y-%m-%d")(r4), r4.getHours(), r4.getMinutes(), r4.getSeconds(), 10 * r4.getUTCMilliseconds() + e4);
        }, e3.cleanDate = function(t3, r4, n3) {
          if (t3 === c2)
            return r4;
          if (e3.isJSDate(t3) || "number" == typeof t3 && isFinite(t3)) {
            if (_(n3))
              return s.error("JS Dates and milliseconds are incompatible with world calendars", t3), r4;
            if (!(t3 = e3.ms2DateTimeLocal(+t3)) && void 0 !== r4)
              return r4;
          } else if (!e3.isDateTime(t3, n3))
            return s.error("unrecognized date", t3), r4;
          return t3;
        };
        var S = /%\d?f/g, E2 = /%h/g, L = { 1: "1", 2: "1", 3: "2", 4: "2" };
        function C2(t3, e4, r4, n3) {
          t3 = t3.replace(S, function(t4) {
            var r5 = Math.min(+t4.charAt(1) || 6, 6);
            return (e4 / 1e3 % 1 + 2).toFixed(r5).substr(2).replace(/0+$/, "") || "0";
          });
          var i2 = new Date(Math.floor(e4 + 0.05));
          if (t3 = t3.replace(E2, function() {
            return L[r4("%q")(i2)];
          }), _(n3))
            try {
              t3 = g2.getComponentMethod("calendars", "worldCalFmt")(t3, e4, n3);
            } catch (t4) {
              return "Invalid";
            }
          return r4(t3)(i2);
        }
        var P = [59, 59.9, 59.99, 59.999, 59.9999];
        e3.formatDate = function(t3, e4, r4, n3, i2, a2) {
          if (i2 = _(i2) && i2, !e4)
            if ("y" === r4)
              e4 = a2.year;
            else if ("m" === r4)
              e4 = a2.month;
            else {
              if ("d" !== r4)
                return function(t4, e5) {
                  var r5 = l2(t4 + 0.05, f2), n4 = w2(Math.floor(r5 / h2), 2) + ":" + w2(l2(Math.floor(r5 / p2), 60), 2);
                  if ("M" !== e5) {
                    o(e5) || (e5 = 0);
                    var i3 = (100 + Math.min(l2(t4 / d2, 60), P[e5])).toFixed(e5).substr(1);
                    e5 > 0 && (i3 = i3.replace(/0+$/, "").replace(/[\.]$/, "")), n4 += ":" + i3;
                  }
                  return n4;
                }(t3, r4) + "\n" + C2(a2.dayMonthYear, t3, n3, i2);
              e4 = a2.dayMonth + "\n" + a2.year;
            }
          return C2(e4, t3, n3, i2);
        };
        var O = 3 * f2;
        e3.incrementMonth = function(t3, e4, r4) {
          r4 = _(r4) && r4;
          var n3 = l2(t3, f2);
          if (t3 = Math.round(t3 - n3), r4)
            try {
              var i2 = Math.round(t3 / f2) + v2, a2 = g2.getComponentMethod("calendars", "getCal")(r4), o2 = a2.fromJD(i2);
              return e4 % 12 ? a2.add(o2, e4, "m") : a2.add(o2, e4 / 12, "y"), (o2.toJD() - v2) * f2 + n3;
            } catch (e5) {
              s.error("invalid ms " + t3 + " in calendar " + r4);
            }
          var u3 = new Date(t3 + O);
          return u3.setUTCMonth(u3.getUTCMonth() + e4) + n3 - O;
        }, e3.findExactDates = function(t3, e4) {
          for (var r4, n3, i2 = 0, a2 = 0, s2 = 0, l3 = 0, u3 = _(e4) && g2.getComponentMethod("calendars", "getCal")(e4), c3 = 0; c3 < t3.length; c3++)
            if (n3 = t3[c3], o(n3)) {
              if (!(n3 % f2))
                if (u3)
                  try {
                    1 === (r4 = u3.fromJD(n3 / f2 + v2)).day() ? 1 === r4.month() ? i2++ : a2++ : s2++;
                  } catch (t4) {
                  }
                else
                  1 === (r4 = new Date(n3)).getUTCDate() ? 0 === r4.getUTCMonth() ? i2++ : a2++ : s2++;
            } else
              l3++;
          s2 += a2 += i2;
          var h3 = t3.length - l3;
          return { exactYears: i2 / h3, exactMonths: a2 / h3, exactDays: s2 / h3 };
        };
      }, 52200: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(24248), a = r3(52248), o = r3(36524);
        function s(t3) {
          var e4 = t3 && t3.parentNode;
          e4 && e4.removeChild(t3);
        }
        function l2(t3, e4, r4) {
          var n3 = "plotly.js-style-" + t3, a2 = document.getElementById(n3);
          a2 || ((a2 = document.createElement("style")).setAttribute("id", n3), a2.appendChild(document.createTextNode("")), document.head.appendChild(a2));
          var o2 = a2.sheet;
          o2.insertRule ? o2.insertRule(e4 + "{" + r4 + "}", 0) : o2.addRule ? o2.addRule(e4, r4, 0) : i.warn("addStyleRule failed");
        }
        function u2(t3) {
          var e4 = window.getComputedStyle(t3, null), r4 = e4.getPropertyValue("-webkit-transform") || e4.getPropertyValue("-moz-transform") || e4.getPropertyValue("-ms-transform") || e4.getPropertyValue("-o-transform") || e4.getPropertyValue("transform");
          return "none" === r4 ? null : r4.replace("matrix", "").replace("3d", "").slice(1, -1).split(",").map(function(t4) {
            return +t4;
          });
        }
        function c2(t3) {
          for (var e4 = []; f2(t3); )
            e4.push(t3), t3 = t3.parentNode;
          return e4;
        }
        function f2(t3) {
          return t3 && (t3 instanceof Element || t3 instanceof HTMLElement);
        }
        t2.exports = { getGraphDiv: function(t3) {
          var e4;
          if ("string" == typeof t3) {
            if (null === (e4 = document.getElementById(t3)))
              throw new Error("No DOM element with id '" + t3 + "' exists on the page.");
            return e4;
          }
          if (null == t3)
            throw new Error("DOM element provided is null or undefined");
          return t3;
        }, isPlotDiv: function(t3) {
          var e4 = n2.select(t3);
          return e4.node() instanceof HTMLElement && e4.size() && e4.classed("js-plotly-plot");
        }, removeElement: s, addStyleRule: function(t3, e4) {
          l2("global", t3, e4);
        }, addRelatedStyleRule: l2, deleteRelatedStyleRule: function(t3) {
          var e4 = "plotly.js-style-" + t3, r4 = document.getElementById(e4);
          r4 && s(r4);
        }, getFullTransformMatrix: function(t3) {
          var e4 = c2(t3), r4 = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];
          return e4.forEach(function(t4) {
            var e5 = u2(t4);
            if (e5) {
              var n3 = a.convertCssMatrix(e5);
              r4 = o.multiply(r4, r4, n3);
            }
          }), r4;
        }, getElementTransformMatrix: u2, getElementAndAncestors: c2, equalDomRects: function(t3, e4) {
          return t3 && e4 && t3.top === e4.top && t3.left === e4.left && t3.right === e4.right && t3.bottom === e4.bottom;
        } };
      }, 95924: function(t2, e3, r3) {
        var n2 = r3(61252).EventEmitter, i = { init: function(t3) {
          if (t3._ev instanceof n2)
            return t3;
          var e4 = new n2(), r4 = new n2();
          return t3._ev = e4, t3._internalEv = r4, t3.on = e4.on.bind(e4), t3.once = e4.once.bind(e4), t3.removeListener = e4.removeListener.bind(e4), t3.removeAllListeners = e4.removeAllListeners.bind(e4), t3._internalOn = r4.on.bind(r4), t3._internalOnce = r4.once.bind(r4), t3._removeInternalListener = r4.removeListener.bind(r4), t3._removeAllInternalListeners = r4.removeAllListeners.bind(r4), t3.emit = function(n3, i2) {
            "undefined" != typeof jQuery && jQuery(t3).trigger(n3, i2), e4.emit(n3, i2), r4.emit(n3, i2);
          }, t3;
        }, triggerHandler: function(t3, e4, r4) {
          var n3, i2;
          "undefined" != typeof jQuery && (n3 = jQuery(t3).triggerHandler(e4, r4));
          var a = t3._ev;
          if (!a)
            return n3;
          var o, s = a._events[e4];
          if (!s)
            return n3;
          function l2(t4) {
            return t4.listener ? (a.removeListener(e4, t4.listener), t4.fired ? void 0 : (t4.fired = true, t4.listener.apply(a, [r4]))) : t4.apply(a, [r4]);
          }
          for (s = Array.isArray(s) ? s : [s], o = 0; o < s.length - 1; o++)
            l2(s[o]);
          return i2 = l2(s[o]), void 0 !== n3 ? n3 : i2;
        }, purge: function(t3) {
          return delete t3._ev, delete t3.on, delete t3.once, delete t3.removeListener, delete t3.removeAllListeners, delete t3.emit, delete t3._ev, delete t3._internalEv, delete t3._internalOn, delete t3._internalOnce, delete t3._removeInternalListener, delete t3._removeAllInternalListeners, t3;
        } };
        t2.exports = i;
      }, 92880: function(t2, e3, r3) {
        var n2 = r3(63620), i = Array.isArray;
        function a(t3, e4, r4, o) {
          var s, l2, u2, c2, f2, h2, p2, d2 = t3[0], v2 = t3.length;
          if (2 === v2 && i(d2) && i(t3[1]) && 0 === d2.length) {
            if (p2 = function(t4, e5) {
              var r5, n3;
              for (r5 = 0; r5 < t4.length; r5++) {
                if (null !== (n3 = t4[r5]) && "object" == typeof n3)
                  return false;
                void 0 !== n3 && (e5[r5] = n3);
              }
              return true;
            }(t3[1], d2), p2)
              return d2;
            d2.splice(0, d2.length);
          }
          for (var g2 = 1; g2 < v2; g2++)
            for (l2 in s = t3[g2])
              u2 = d2[l2], c2 = s[l2], o && i(c2) ? d2[l2] = c2 : e4 && c2 && (n2(c2) || (f2 = i(c2))) ? (f2 ? (f2 = false, h2 = u2 && i(u2) ? u2 : []) : h2 = u2 && n2(u2) ? u2 : {}, d2[l2] = a([h2, c2], e4, r4, o)) : (void 0 !== c2 || r4) && (d2[l2] = c2);
          return d2;
        }
        e3.extendFlat = function() {
          return a(arguments, false, false, false);
        }, e3.extendDeep = function() {
          return a(arguments, true, false, false);
        }, e3.extendDeepAll = function() {
          return a(arguments, true, true, false);
        }, e3.extendDeepNoArrays = function() {
          return a(arguments, true, false, true);
        };
      }, 68944: function(t2) {
        t2.exports = function(t3) {
          for (var e3 = {}, r3 = [], n2 = 0, i = 0; i < t3.length; i++) {
            var a = t3[i];
            1 !== e3[a] && (e3[a] = 1, r3[n2++] = a);
          }
          return r3;
        };
      }, 43880: function(t2) {
        function e3(t3) {
          return true === t3.visible;
        }
        function r3(t3) {
          var e4 = t3[0].trace;
          return true === e4.visible && 0 !== e4._length;
        }
        t2.exports = function(t3) {
          for (var n2, i = (n2 = t3, Array.isArray(n2) && Array.isArray(n2[0]) && n2[0][0] && n2[0][0].trace ? r3 : e3), a = [], o = 0; o < t3.length; o++) {
            var s = t3[o];
            i(s) && a.push(s);
          }
          return a;
        };
      }, 27144: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(36116), a = r3(40440), o = r3(77844), s = r3(42428), l2 = r3(35536), u2 = r3(24248), c2 = r3(63620), f2 = r3(22296), h2 = r3(92065), p2 = Object.keys(i), d2 = { "ISO-3": l2, "USA-states": l2, "country names": function(t3) {
          for (var e4 = 0; e4 < p2.length; e4++) {
            var r4 = p2[e4];
            if (new RegExp(i[r4]).test(t3.trim().toLowerCase()))
              return r4;
          }
          return u2.log("Unrecognized country name: " + t3 + "."), false;
        } };
        function v2(t3) {
          var e4 = t3.geojson, r4 = window.PlotlyGeoAssets || {}, n3 = "string" == typeof e4 ? r4[e4] : e4;
          return c2(n3) ? n3 : (u2.error("Oops ... something went wrong when fetching " + e4), false);
        }
        t2.exports = { locationToFeature: function(t3, e4, r4) {
          if (!e4 || "string" != typeof e4)
            return false;
          var n3, i2, a2, o2 = d2[t3](e4);
          if (o2) {
            if ("USA-states" === t3)
              for (n3 = [], a2 = 0; a2 < r4.length; a2++)
                (i2 = r4[a2]).properties && i2.properties.gu && "USA" === i2.properties.gu && n3.push(i2);
            else
              n3 = r4;
            for (a2 = 0; a2 < n3.length; a2++)
              if ((i2 = n3[a2]).id === o2)
                return i2;
            u2.log(["Location with id", o2, "does not have a matching topojson feature at this resolution."].join(" "));
          }
          return false;
        }, feature2polygons: function(t3) {
          var e4, r4, n3, i2, a2 = t3.geometry, o2 = a2.coordinates, s2 = t3.id, l3 = [];
          function u3(t4) {
            for (var e5 = 0; e5 < t4.length - 1; e5++)
              if (t4[e5][0] > 0 && t4[e5 + 1][0] < 0)
                return e5;
            return null;
          }
          switch (e4 = "RUS" === s2 || "FJI" === s2 ? function(t4) {
            var e5;
            if (null === u3(t4))
              e5 = t4;
            else
              for (e5 = new Array(t4.length), i2 = 0; i2 < t4.length; i2++)
                e5[i2] = [t4[i2][0] < 0 ? t4[i2][0] + 360 : t4[i2][0], t4[i2][1]];
            l3.push(h2.tester(e5));
          } : "ATA" === s2 ? function(t4) {
            var e5 = u3(t4);
            if (null === e5)
              return l3.push(h2.tester(t4));
            var r5 = new Array(t4.length + 1), n4 = 0;
            for (i2 = 0; i2 < t4.length; i2++)
              i2 > e5 ? r5[n4++] = [t4[i2][0] + 360, t4[i2][1]] : i2 === e5 ? (r5[n4++] = t4[i2], r5[n4++] = [t4[i2][0], -90]) : r5[n4++] = t4[i2];
            var a3 = h2.tester(r5);
            a3.pts.pop(), l3.push(a3);
          } : function(t4) {
            l3.push(h2.tester(t4));
          }, a2.type) {
            case "MultiPolygon":
              for (r4 = 0; r4 < o2.length; r4++)
                for (n3 = 0; n3 < o2[r4].length; n3++)
                  e4(o2[r4][n3]);
              break;
            case "Polygon":
              for (r4 = 0; r4 < o2.length; r4++)
                e4(o2[r4]);
          }
          return l3;
        }, getTraceGeojson: v2, extractTraceFeature: function(t3) {
          var e4 = t3[0].trace, r4 = v2(e4);
          if (!r4)
            return false;
          var n3, i2 = {}, s2 = [];
          for (n3 = 0; n3 < e4._length; n3++) {
            var l3 = t3[n3];
            (l3.loc || 0 === l3.loc) && (i2[l3.loc] = l3);
          }
          function c3(t4) {
            var r5 = f2(t4, e4.featureidkey || "id").get(), n4 = i2[r5];
            if (n4) {
              var l4 = t4.geometry;
              if ("Polygon" === l4.type || "MultiPolygon" === l4.type) {
                var c4 = { type: "Feature", id: r5, geometry: l4, properties: {} };
                c4.properties.ct = function(t5) {
                  var e5, r6 = t5.geometry;
                  if ("MultiPolygon" === r6.type)
                    for (var n5 = r6.coordinates, i3 = 0, s3 = 0; s3 < n5.length; s3++) {
                      var l5 = { type: "Polygon", coordinates: n5[s3] }, u3 = a.default(l5);
                      u3 > i3 && (i3 = u3, e5 = l5);
                    }
                  else
                    e5 = r6;
                  return o.default(e5).geometry.coordinates;
                }(c4), n4.fIn = t4, n4.fOut = c4, s2.push(c4);
              } else
                u2.log(["Location", n4.loc, "does not have a valid GeoJSON geometry.", "Traces with locationmode *geojson-id* only support", "*Polygon* and *MultiPolygon* geometries."].join(" "));
            }
            delete i2[r5];
          }
          switch (r4.type) {
            case "FeatureCollection":
              var h3 = r4.features;
              for (n3 = 0; n3 < h3.length; n3++)
                c3(h3[n3]);
              break;
            case "Feature":
              c3(r4);
              break;
            default:
              return u2.warn(["Invalid GeoJSON type", (r4.type || "none") + ".", "Traces with locationmode *geojson-id* only support", "*FeatureCollection* and *Feature* types."].join(" ")), false;
          }
          for (var p3 in i2)
            u2.log(["Location *" + p3 + "*", "does not have a matching feature with id-key", "*" + e4.featureidkey + "*."].join(" "));
          return s2;
        }, fetchTraceGeoData: function(t3) {
          var e4 = window.PlotlyGeoAssets || {}, r4 = [];
          function i2(t4) {
            return new Promise(function(r5, i3) {
              n2.json(t4, function(n3, a3) {
                if (n3) {
                  delete e4[t4];
                  var o3 = 404 === n3.status ? 'GeoJSON at URL "' + t4 + '" does not exist.' : "Unexpected error while fetching from " + t4;
                  return i3(new Error(o3));
                }
                return e4[t4] = a3, r5(a3);
              });
            });
          }
          function a2(t4) {
            return new Promise(function(r5, n3) {
              var i3 = 0, a3 = setInterval(function() {
                return e4[t4] && "pending" !== e4[t4] ? (clearInterval(a3), r5(e4[t4])) : i3 > 100 ? (clearInterval(a3), n3("Unexpected error while fetching from " + t4)) : void i3++;
              }, 50);
            });
          }
          for (var o2 = 0; o2 < t3.length; o2++) {
            var s2 = t3[o2][0].trace.geojson;
            "string" == typeof s2 && (e4[s2] ? "pending" === e4[s2] && r4.push(a2(s2)) : (e4[s2] = "pending", r4.push(i2(s2))));
          }
          return r4;
        }, computeBbox: function(t3) {
          return s.default(t3);
        } };
      }, 44808: function(t2, e3, r3) {
        var n2 = r3(39032).BADNUM;
        e3.calcTraceToLineCoords = function(t3) {
          for (var e4 = t3[0].trace.connectgaps, r4 = [], i = [], a = 0; a < t3.length; a++) {
            var o = t3[a].lonlat;
            o[0] !== n2 ? i.push(o) : !e4 && i.length > 0 && (r4.push(i), i = []);
          }
          return i.length > 0 && r4.push(i), r4;
        }, e3.makeLine = function(t3) {
          return 1 === t3.length ? { type: "LineString", coordinates: t3[0] } : { type: "MultiLineString", coordinates: t3 };
        }, e3.makePolygon = function(t3) {
          if (1 === t3.length)
            return { type: "Polygon", coordinates: t3 };
          for (var e4 = new Array(t3.length), r4 = 0; r4 < t3.length; r4++)
            e4[r4] = [t3[r4]];
          return { type: "MultiPolygon", coordinates: e4 };
        }, e3.makeBlank = function() {
          return { type: "Point", coordinates: [] };
        };
      }, 92348: function(t2, e3, r3) {
        var n2, i, a, o = r3(20435).mod;
        function s(t3, e4, r4, n3, i2, a2, o2, s2) {
          var l3 = r4 - t3, u2 = i2 - t3, c2 = o2 - i2, f2 = n3 - e4, h2 = a2 - e4, p2 = s2 - a2, d2 = l3 * p2 - c2 * f2;
          if (0 === d2)
            return null;
          var v2 = (u2 * p2 - c2 * h2) / d2, g2 = (u2 * f2 - l3 * h2) / d2;
          return g2 < 0 || g2 > 1 || v2 < 0 || v2 > 1 ? null : { x: t3 + l3 * v2, y: e4 + f2 * v2 };
        }
        function l2(t3, e4, r4, n3, i2) {
          var a2 = n3 * t3 + i2 * e4;
          if (a2 < 0)
            return n3 * n3 + i2 * i2;
          if (a2 > r4) {
            var o2 = n3 - t3, s2 = i2 - e4;
            return o2 * o2 + s2 * s2;
          }
          var l3 = n3 * e4 - i2 * t3;
          return l3 * l3 / r4;
        }
        e3.segmentsIntersect = s, e3.segmentDistance = function(t3, e4, r4, n3, i2, a2, o2, u2) {
          if (s(t3, e4, r4, n3, i2, a2, o2, u2))
            return 0;
          var c2 = r4 - t3, f2 = n3 - e4, h2 = o2 - i2, p2 = u2 - a2, d2 = c2 * c2 + f2 * f2, v2 = h2 * h2 + p2 * p2, g2 = Math.min(l2(c2, f2, d2, i2 - t3, a2 - e4), l2(c2, f2, d2, o2 - t3, u2 - e4), l2(h2, p2, v2, t3 - i2, e4 - a2), l2(h2, p2, v2, r4 - i2, n3 - a2));
          return Math.sqrt(g2);
        }, e3.getTextLocation = function(t3, e4, r4, s2) {
          if (t3 === i && s2 === a || (n2 = {}, i = t3, a = s2), n2[r4])
            return n2[r4];
          var l3 = t3.getPointAtLength(o(r4 - s2 / 2, e4)), u2 = t3.getPointAtLength(o(r4 + s2 / 2, e4)), c2 = Math.atan((u2.y - l3.y) / (u2.x - l3.x)), f2 = t3.getPointAtLength(o(r4, e4)), h2 = { x: (4 * f2.x + l3.x + u2.x) / 6, y: (4 * f2.y + l3.y + u2.y) / 6, theta: c2 };
          return n2[r4] = h2, h2;
        }, e3.clearLocationCache = function() {
          i = null;
        }, e3.getVisibleSegment = function(t3, e4, r4) {
          var n3, i2, a2 = e4.left, o2 = e4.right, s2 = e4.top, l3 = e4.bottom, u2 = 0, c2 = t3.getTotalLength(), f2 = c2;
          function h2(e5) {
            var r5 = t3.getPointAtLength(e5);
            0 === e5 ? n3 = r5 : e5 === c2 && (i2 = r5);
            var u3 = r5.x < a2 ? a2 - r5.x : r5.x > o2 ? r5.x - o2 : 0, f3 = r5.y < s2 ? s2 - r5.y : r5.y > l3 ? r5.y - l3 : 0;
            return Math.sqrt(u3 * u3 + f3 * f3);
          }
          for (var p2 = h2(u2); p2; ) {
            if ((u2 += p2 + r4) > f2)
              return;
            p2 = h2(u2);
          }
          for (p2 = h2(f2); p2; ) {
            if (u2 > (f2 -= p2 + r4))
              return;
            p2 = h2(f2);
          }
          return { min: u2, max: f2, len: f2 - u2, total: c2, isClosed: 0 === u2 && f2 === c2 && Math.abs(n3.x - i2.x) < 0.1 && Math.abs(n3.y - i2.y) < 0.1 };
        }, e3.findPointOnPath = function(t3, e4, r4, n3) {
          for (var i2, a2, o2, s2 = (n3 = n3 || {}).pathLength || t3.getTotalLength(), l3 = n3.tolerance || 1e-3, u2 = n3.iterationLimit || 30, c2 = t3.getPointAtLength(0)[r4] > t3.getPointAtLength(s2)[r4] ? -1 : 1, f2 = 0, h2 = 0, p2 = s2; f2 < u2; ) {
            if (i2 = (h2 + p2) / 2, o2 = (a2 = t3.getPointAtLength(i2))[r4] - e4, Math.abs(o2) < l3)
              return a2;
            c2 * o2 > 0 ? p2 = i2 : h2 = i2, f2++;
          }
          return a2;
        };
      }, 33040: function(t2, e3, r3) {
        var n2 = r3(38248), i = r3(49760), a = r3(72160), o = r3(8932), s = r3(22548).defaultLine, l2 = r3(38116).isArrayOrTypedArray, u2 = a(s);
        function c2(t3, e4) {
          var r4 = t3;
          return r4[3] *= e4, r4;
        }
        function f2(t3) {
          if (n2(t3))
            return u2;
          var e4 = a(t3);
          return e4.length ? e4 : u2;
        }
        function h2(t3) {
          return n2(t3) ? t3 : 1;
        }
        t2.exports = { formatColor: function(t3, e4, r4) {
          var n3 = t3.color;
          n3 && n3._inputArray && (n3 = n3._inputArray);
          var i2, s2, p2, d2, v2, g2 = l2(n3), y2 = l2(e4), m2 = o.extractOpts(t3), x = [];
          if (i2 = void 0 !== m2.colorscale ? o.makeColorScaleFuncFromTrace(t3) : f2, s2 = g2 ? function(t4, e5) {
            return void 0 === t4[e5] ? u2 : a(i2(t4[e5]));
          } : f2, p2 = y2 ? function(t4, e5) {
            return void 0 === t4[e5] ? 1 : h2(t4[e5]);
          } : h2, g2 || y2)
            for (var b2 = 0; b2 < r4; b2++)
              d2 = s2(n3, b2), v2 = p2(e4, b2), x[b2] = c2(d2, v2);
          else
            x = c2(a(n3), e4);
          return x;
        }, parseColorScale: function(t3) {
          var e4 = o.extractOpts(t3), r4 = e4.colorscale;
          return e4.reversescale && (r4 = o.flipScale(e4.colorscale)), r4.map(function(t4) {
            var e5 = t4[0], r5 = i(t4[1]).toRgb();
            return { index: e5, rgb: [r5.r, r5.g, r5.b, r5.a] };
          });
        } };
      }, 71688: function(t2, e3, r3) {
        var n2 = r3(35536);
        function i(t3) {
          return [t3];
        }
        t2.exports = { keyFun: function(t3) {
          return t3.key;
        }, repeat: i, descend: n2, wrap: i, unwrap: function(t3) {
          return t3[0];
        } };
      }, 35536: function(t2) {
        t2.exports = function(t3) {
          return t3;
        };
      }, 1396: function(t2) {
        t2.exports = function(t3, e3) {
          if (!e3)
            return t3;
          var r3 = 1 / Math.abs(e3), n2 = r3 > 1 ? (r3 * t3 + r3 * e3) / r3 : t3 + e3, i = String(n2).length;
          if (i > 16) {
            var a = String(e3).length;
            if (i >= String(t3).length + a) {
              var o = parseFloat(n2).toPrecision(12);
              -1 === o.indexOf("e+") && (n2 = +o);
            }
          }
          return n2;
        };
      }, 3400: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(94336).E9, a = r3(57624).E9, o = r3(38248), s = r3(39032), l2 = s.FP_SAFE, u2 = -l2, c2 = s.BADNUM, f2 = t2.exports = {};
        f2.adjustFormat = function(t3) {
          return !t3 || /^\d[.]\df/.test(t3) || /[.]\d%/.test(t3) ? t3 : "0.f" === t3 ? "~f" : /^\d%/.test(t3) ? "~%" : /^\ds/.test(t3) ? "~s" : !/^[~,.0$]/.test(t3) && /[&fps]/.test(t3) ? "~" + t3 : t3;
        };
        var h2 = {};
        f2.warnBadFormat = function(t3) {
          var e4 = String(t3);
          h2[e4] || (h2[e4] = 1, f2.warn('encountered bad format: "' + e4 + '"'));
        }, f2.noFormat = function(t3) {
          return String(t3);
        }, f2.numberFormat = function(t3) {
          var e4;
          try {
            e4 = a(f2.adjustFormat(t3));
          } catch (e5) {
            return f2.warnBadFormat(t3), f2.noFormat;
          }
          return e4;
        }, f2.nestedProperty = r3(22296), f2.keyedContainer = r3(37804), f2.relativeAttr = r3(23193), f2.isPlainObject = r3(63620), f2.toLogRange = r3(36896), f2.relinkPrivateKeys = r3(51528);
        var p2 = r3(38116);
        f2.isArrayBuffer = p2.isArrayBuffer, f2.isTypedArray = p2.isTypedArray, f2.isArrayOrTypedArray = p2.isArrayOrTypedArray, f2.isArray1D = p2.isArray1D, f2.ensureArray = p2.ensureArray, f2.concat = p2.concat, f2.maxRowLength = p2.maxRowLength, f2.minRowLength = p2.minRowLength;
        var d2 = r3(20435);
        f2.mod = d2.mod, f2.modHalf = d2.modHalf;
        var v2 = r3(63064);
        f2.valObjectMeta = v2.valObjectMeta, f2.coerce = v2.coerce, f2.coerce2 = v2.coerce2, f2.coerceFont = v2.coerceFont, f2.coercePattern = v2.coercePattern, f2.coerceHoverinfo = v2.coerceHoverinfo, f2.coerceSelectionMarkerOpacity = v2.coerceSelectionMarkerOpacity, f2.validate = v2.validate;
        var g2 = r3(67555);
        f2.dateTime2ms = g2.dateTime2ms, f2.isDateTime = g2.isDateTime, f2.ms2DateTime = g2.ms2DateTime, f2.ms2DateTimeLocal = g2.ms2DateTimeLocal, f2.cleanDate = g2.cleanDate, f2.isJSDate = g2.isJSDate, f2.formatDate = g2.formatDate, f2.incrementMonth = g2.incrementMonth, f2.dateTick0 = g2.dateTick0, f2.dfltRange = g2.dfltRange, f2.findExactDates = g2.findExactDates, f2.MIN_MS = g2.MIN_MS, f2.MAX_MS = g2.MAX_MS;
        var y2 = r3(14952);
        f2.findBin = y2.findBin, f2.sorterAsc = y2.sorterAsc, f2.sorterDes = y2.sorterDes, f2.distinctVals = y2.distinctVals, f2.roundUp = y2.roundUp, f2.sort = y2.sort, f2.findIndexOfMin = y2.findIndexOfMin, f2.sortObjectKeys = r3(95376);
        var m2 = r3(63084);
        f2.aggNums = m2.aggNums, f2.len = m2.len, f2.mean = m2.mean, f2.median = m2.median, f2.midRange = m2.midRange, f2.variance = m2.variance, f2.stdev = m2.stdev, f2.interp = m2.interp;
        var x = r3(52248);
        f2.init2dArray = x.init2dArray, f2.transposeRagged = x.transposeRagged, f2.dot = x.dot, f2.translationMatrix = x.translationMatrix, f2.rotationMatrix = x.rotationMatrix, f2.rotationXYMatrix = x.rotationXYMatrix, f2.apply3DTransform = x.apply3DTransform, f2.apply2DTransform = x.apply2DTransform, f2.apply2DTransform2 = x.apply2DTransform2, f2.convertCssMatrix = x.convertCssMatrix, f2.inverseTransformMatrix = x.inverseTransformMatrix;
        var b2 = r3(11864);
        f2.deg2rad = b2.deg2rad, f2.rad2deg = b2.rad2deg, f2.angleDelta = b2.angleDelta, f2.angleDist = b2.angleDist, f2.isFullCircle = b2.isFullCircle, f2.isAngleInsideSector = b2.isAngleInsideSector, f2.isPtInsideSector = b2.isPtInsideSector, f2.pathArc = b2.pathArc, f2.pathSector = b2.pathSector, f2.pathAnnulus = b2.pathAnnulus;
        var _ = r3(98308);
        f2.isLeftAnchor = _.isLeftAnchor, f2.isCenterAnchor = _.isCenterAnchor, f2.isRightAnchor = _.isRightAnchor, f2.isTopAnchor = _.isTopAnchor, f2.isMiddleAnchor = _.isMiddleAnchor, f2.isBottomAnchor = _.isBottomAnchor;
        var w2 = r3(92348);
        f2.segmentsIntersect = w2.segmentsIntersect, f2.segmentDistance = w2.segmentDistance, f2.getTextLocation = w2.getTextLocation, f2.clearLocationCache = w2.clearLocationCache, f2.getVisibleSegment = w2.getVisibleSegment, f2.findPointOnPath = w2.findPointOnPath;
        var T = r3(92880);
        f2.extendFlat = T.extendFlat, f2.extendDeep = T.extendDeep, f2.extendDeepAll = T.extendDeepAll, f2.extendDeepNoArrays = T.extendDeepNoArrays;
        var k2 = r3(24248);
        f2.log = k2.log, f2.warn = k2.warn, f2.error = k2.error;
        var A2 = r3(53756);
        f2.counterRegex = A2.counter;
        var M = r3(91200);
        f2.throttle = M.throttle, f2.throttleDone = M.done, f2.clearThrottle = M.clear;
        var S = r3(52200);
        function E2(t3) {
          var e4 = {};
          for (var r4 in t3)
            for (var n3 = t3[r4], i2 = 0; i2 < n3.length; i2++)
              e4[n3[i2]] = +r4;
          return e4;
        }
        f2.getGraphDiv = S.getGraphDiv, f2.isPlotDiv = S.isPlotDiv, f2.removeElement = S.removeElement, f2.addStyleRule = S.addStyleRule, f2.addRelatedStyleRule = S.addRelatedStyleRule, f2.deleteRelatedStyleRule = S.deleteRelatedStyleRule, f2.getFullTransformMatrix = S.getFullTransformMatrix, f2.getElementTransformMatrix = S.getElementTransformMatrix, f2.getElementAndAncestors = S.getElementAndAncestors, f2.equalDomRects = S.equalDomRects, f2.clearResponsive = r3(75352), f2.preserveDrawingBuffer = r3(34296), f2.makeTraceGroups = r3(30988), f2._ = r3(98356), f2.notifier = r3(41792), f2.filterUnique = r3(68944), f2.filterVisible = r3(43880), f2.pushUnique = r3(52416), f2.increment = r3(1396), f2.cleanNumber = r3(54037), f2.ensureNumber = function(t3) {
          return o(t3) ? (t3 = Number(t3)) > l2 || t3 < u2 ? c2 : t3 : c2;
        }, f2.isIndex = function(t3, e4) {
          return !(void 0 !== e4 && t3 >= e4) && o(t3) && t3 >= 0 && t3 % 1 == 0;
        }, f2.noop = r3(16628), f2.identity = r3(35536), f2.repeat = function(t3, e4) {
          for (var r4 = new Array(e4), n3 = 0; n3 < e4; n3++)
            r4[n3] = t3;
          return r4;
        }, f2.swapAttrs = function(t3, e4, r4, n3) {
          r4 || (r4 = "x"), n3 || (n3 = "y");
          for (var i2 = 0; i2 < e4.length; i2++) {
            var a2 = e4[i2], o2 = f2.nestedProperty(t3, a2.replace("?", r4)), s2 = f2.nestedProperty(t3, a2.replace("?", n3)), l3 = o2.get();
            o2.set(s2.get()), s2.set(l3);
          }
        }, f2.raiseToTop = function(t3) {
          t3.parentNode.appendChild(t3);
        }, f2.cancelTransition = function(t3) {
          return t3.transition().duration(0);
        }, f2.constrain = function(t3, e4, r4) {
          return e4 > r4 ? Math.max(r4, Math.min(e4, t3)) : Math.max(e4, Math.min(r4, t3));
        }, f2.bBoxIntersect = function(t3, e4, r4) {
          return r4 = r4 || 0, t3.left <= e4.right + r4 && e4.left <= t3.right + r4 && t3.top <= e4.bottom + r4 && e4.top <= t3.bottom + r4;
        }, f2.simpleMap = function(t3, e4, r4, n3, i2) {
          for (var a2 = t3.length, o2 = new Array(a2), s2 = 0; s2 < a2; s2++)
            o2[s2] = e4(t3[s2], r4, n3, i2);
          return o2;
        }, f2.randstr = function t3(e4, r4, n3, i2) {
          if (n3 || (n3 = 16), void 0 === r4 && (r4 = 24), r4 <= 0)
            return "0";
          var a2, o2, s2 = Math.log(Math.pow(2, r4)) / Math.log(n3), l3 = "";
          for (a2 = 2; s2 === 1 / 0; a2 *= 2)
            s2 = Math.log(Math.pow(2, r4 / a2)) / Math.log(n3) * a2;
          var u3 = s2 - Math.floor(s2);
          for (a2 = 0; a2 < Math.floor(s2); a2++)
            l3 = Math.floor(Math.random() * n3).toString(n3) + l3;
          u3 && (o2 = Math.pow(n3, u3), l3 = Math.floor(Math.random() * o2).toString(n3) + l3);
          var c3 = parseInt(l3, n3);
          return e4 && e4[l3] || c3 !== 1 / 0 && c3 >= Math.pow(2, r4) ? i2 > 10 ? (f2.warn("randstr failed uniqueness"), l3) : t3(e4, r4, n3, (i2 || 0) + 1) : l3;
        }, f2.OptionControl = function(t3, e4) {
          t3 || (t3 = {}), e4 || (e4 = "opt");
          var r4 = { optionList: [], _newoption: function(n3) {
            n3[e4] = t3, r4[n3.name] = n3, r4.optionList.push(n3);
          } };
          return r4["_" + e4] = t3, r4;
        }, f2.smooth = function(t3, e4) {
          if ((e4 = Math.round(e4) || 0) < 2)
            return t3;
          var r4, n3, i2, a2, o2 = t3.length, s2 = 2 * o2, l3 = 2 * e4 - 1, u3 = new Array(l3), c3 = new Array(o2);
          for (r4 = 0; r4 < l3; r4++)
            u3[r4] = (1 - Math.cos(Math.PI * (r4 + 1) / e4)) / (2 * e4);
          for (r4 = 0; r4 < o2; r4++) {
            for (a2 = 0, n3 = 0; n3 < l3; n3++)
              (i2 = r4 + n3 + 1 - e4) < -o2 ? i2 -= s2 * Math.round(i2 / s2) : i2 >= s2 && (i2 -= s2 * Math.floor(i2 / s2)), i2 < 0 ? i2 = -1 - i2 : i2 >= o2 && (i2 = s2 - 1 - i2), a2 += t3[i2] * u3[n3];
            c3[r4] = a2;
          }
          return c3;
        }, f2.syncOrAsync = function(t3, e4, r4) {
          var n3;
          function i2() {
            return f2.syncOrAsync(t3, e4, r4);
          }
          for (; t3.length; )
            if ((n3 = (0, t3.splice(0, 1)[0])(e4)) && n3.then)
              return n3.then(i2);
          return r4 && r4(e4);
        }, f2.stripTrailingSlash = function(t3) {
          return "/" === t3.substr(-1) ? t3.substr(0, t3.length - 1) : t3;
        }, f2.noneOrAll = function(t3, e4, r4) {
          if (t3) {
            var n3, i2 = false, a2 = true;
            for (n3 = 0; n3 < r4.length; n3++)
              null != t3[r4[n3]] ? i2 = true : a2 = false;
            if (i2 && !a2)
              for (n3 = 0; n3 < r4.length; n3++)
                t3[r4[n3]] = e4[r4[n3]];
          }
        }, f2.mergeArray = function(t3, e4, r4, n3) {
          var i2 = "function" == typeof n3;
          if (f2.isArrayOrTypedArray(t3))
            for (var a2 = Math.min(t3.length, e4.length), o2 = 0; o2 < a2; o2++) {
              var s2 = t3[o2];
              e4[o2][r4] = i2 ? n3(s2) : s2;
            }
        }, f2.mergeArrayCastPositive = function(t3, e4, r4) {
          return f2.mergeArray(t3, e4, r4, function(t4) {
            var e5 = +t4;
            return isFinite(e5) && e5 > 0 ? e5 : 0;
          });
        }, f2.fillArray = function(t3, e4, r4, n3) {
          if (n3 = n3 || f2.identity, f2.isArrayOrTypedArray(t3))
            for (var i2 = 0; i2 < e4.length; i2++)
              e4[i2][r4] = n3(t3[i2]);
        }, f2.castOption = function(t3, e4, r4, n3) {
          n3 = n3 || f2.identity;
          var i2 = f2.nestedProperty(t3, r4).get();
          return f2.isArrayOrTypedArray(i2) ? Array.isArray(e4) && f2.isArrayOrTypedArray(i2[e4[0]]) ? n3(i2[e4[0]][e4[1]]) : n3(i2[e4]) : i2;
        }, f2.extractOption = function(t3, e4, r4, n3) {
          if (r4 in t3)
            return t3[r4];
          var i2 = f2.nestedProperty(e4, n3).get();
          return Array.isArray(i2) ? void 0 : i2;
        }, f2.tagSelected = function(t3, e4, r4) {
          var n3, i2, a2 = e4.selectedpoints, o2 = e4._indexToPoints;
          o2 && (n3 = E2(o2));
          for (var s2 = 0; s2 < a2.length; s2++) {
            var l3 = a2[s2];
            if (f2.isIndex(l3) || f2.isArrayOrTypedArray(l3) && f2.isIndex(l3[0]) && f2.isIndex(l3[1])) {
              var u3 = n3 ? n3[l3] : l3, c3 = r4 ? r4[u3] : u3;
              void 0 !== (i2 = c3) && i2 < t3.length && (t3[c3].selected = 1);
            }
          }
        }, f2.selIndices2selPoints = function(t3) {
          var e4 = t3.selectedpoints, r4 = t3._indexToPoints;
          if (r4) {
            for (var n3 = E2(r4), i2 = [], a2 = 0; a2 < e4.length; a2++) {
              var o2 = e4[a2];
              if (f2.isIndex(o2)) {
                var s2 = n3[o2];
                f2.isIndex(s2) && i2.push(s2);
              }
            }
            return i2;
          }
          return e4;
        }, f2.getTargetArray = function(t3, e4) {
          var r4 = e4.target;
          if ("string" == typeof r4 && r4) {
            var n3 = f2.nestedProperty(t3, r4).get();
            return !!f2.isArrayOrTypedArray(n3) && n3;
          }
          return !!f2.isArrayOrTypedArray(r4) && r4;
        }, f2.minExtend = function t3(e4, r4, n3) {
          var i2 = {};
          "object" != typeof r4 && (r4 = {});
          var a2, o2, s2, l3 = "pieLike" === n3 ? -1 : 3, u3 = Object.keys(e4);
          for (a2 = 0; a2 < u3.length; a2++)
            s2 = e4[o2 = u3[a2]], "_" !== o2.charAt(0) && "function" != typeof s2 && ("module" === o2 ? i2[o2] = s2 : Array.isArray(s2) ? i2[o2] = "colorscale" === o2 || -1 === l3 ? s2.slice() : s2.slice(0, l3) : f2.isTypedArray(s2) ? i2[o2] = -1 === l3 ? s2.subarray() : s2.subarray(0, l3) : i2[o2] = s2 && "object" == typeof s2 ? t3(e4[o2], r4[o2], n3) : s2);
          for (u3 = Object.keys(r4), a2 = 0; a2 < u3.length; a2++)
            "object" == typeof (s2 = r4[o2 = u3[a2]]) && o2 in i2 && "object" == typeof i2[o2] || (i2[o2] = s2);
          return i2;
        }, f2.titleCase = function(t3) {
          return t3.charAt(0).toUpperCase() + t3.substr(1);
        }, f2.containsAny = function(t3, e4) {
          for (var r4 = 0; r4 < e4.length; r4++)
            if (-1 !== t3.indexOf(e4[r4]))
              return true;
          return false;
        }, f2.isIE = function() {
          return void 0 !== window.navigator.msSaveBlob;
        };
        var L = /Version\/[\d\.]+.*Safari/;
        f2.isSafari = function() {
          return L.test(window.navigator.userAgent);
        };
        var C2 = /iPad|iPhone|iPod/;
        f2.isIOS = function() {
          return C2.test(window.navigator.userAgent);
        };
        var P = /Firefox\/(\d+)\.\d+/;
        f2.getFirefoxVersion = function() {
          var t3 = P.exec(window.navigator.userAgent);
          if (t3 && 2 === t3.length) {
            var e4 = parseInt(t3[1]);
            if (!isNaN(e4))
              return e4;
          }
          return null;
        }, f2.isD3Selection = function(t3) {
          return t3 instanceof n2.selection;
        }, f2.ensureSingle = function(t3, e4, r4, n3) {
          var i2 = t3.select(e4 + (r4 ? "." + r4 : ""));
          if (i2.size())
            return i2;
          var a2 = t3.append(e4);
          return r4 && a2.classed(r4, true), n3 && a2.call(n3), a2;
        }, f2.ensureSingleById = function(t3, e4, r4, n3) {
          var i2 = t3.select(e4 + "#" + r4);
          if (i2.size())
            return i2;
          var a2 = t3.append(e4).attr("id", r4);
          return n3 && a2.call(n3), a2;
        }, f2.objectFromPath = function(t3, e4) {
          for (var r4, n3 = t3.split("."), i2 = r4 = {}, a2 = 0; a2 < n3.length; a2++) {
            var o2 = n3[a2], s2 = null, l3 = n3[a2].match(/(.*)\[([0-9]+)\]/);
            l3 ? (o2 = l3[1], s2 = l3[2], r4 = r4[o2] = [], a2 === n3.length - 1 ? r4[s2] = e4 : r4[s2] = {}, r4 = r4[s2]) : (a2 === n3.length - 1 ? r4[o2] = e4 : r4[o2] = {}, r4 = r4[o2]);
          }
          return i2;
        };
        var O = /^([^\[\.]+)\.(.+)?/, I2 = /^([^\.]+)\[([0-9]+)\](\.)?(.+)?/;
        function D2(t3) {
          return "__" === t3.slice(0, 2);
        }
        f2.expandObjectPaths = function(t3) {
          var e4, r4, n3, i2, a2, o2, s2;
          if ("object" == typeof t3 && !Array.isArray(t3)) {
            for (r4 in t3)
              if (t3.hasOwnProperty(r4))
                if (e4 = r4.match(O)) {
                  if (i2 = t3[r4], D2(n3 = e4[1]))
                    continue;
                  delete t3[r4], t3[n3] = f2.extendDeepNoArrays(t3[n3] || {}, f2.objectFromPath(r4, f2.expandObjectPaths(i2))[n3]);
                } else if (e4 = r4.match(I2)) {
                  if (i2 = t3[r4], D2(n3 = e4[1]))
                    continue;
                  if (a2 = parseInt(e4[2]), delete t3[r4], t3[n3] = t3[n3] || [], "." === e4[3])
                    s2 = e4[4], o2 = t3[n3][a2] = t3[n3][a2] || {}, f2.extendDeepNoArrays(o2, f2.objectFromPath(s2, f2.expandObjectPaths(i2)));
                  else {
                    if (D2(n3))
                      continue;
                    t3[n3][a2] = f2.expandObjectPaths(i2);
                  }
                } else {
                  if (D2(r4))
                    continue;
                  t3[r4] = f2.expandObjectPaths(t3[r4]);
                }
          }
          return t3;
        }, f2.numSeparate = function(t3, e4, r4) {
          if (r4 || (r4 = false), "string" != typeof e4 || 0 === e4.length)
            throw new Error("Separator string required for formatting!");
          "number" == typeof t3 && (t3 = String(t3));
          var n3 = /(\d+)(\d{3})/, i2 = e4.charAt(0), a2 = e4.charAt(1), o2 = t3.split("."), s2 = o2[0], l3 = o2.length > 1 ? i2 + o2[1] : "";
          if (a2 && (o2.length > 1 || s2.length > 4 || r4))
            for (; n3.test(s2); )
              s2 = s2.replace(n3, "$1" + a2 + "$2");
          return s2 + l3;
        }, f2.TEMPLATE_STRING_REGEX = /%{([^\s%{}:]*)([:|\|][^}]*)?}/g;
        var z2 = /^\w*$/;
        f2.templateString = function(t3, e4) {
          var r4 = {};
          return t3.replace(f2.TEMPLATE_STRING_REGEX, function(t4, n3) {
            var i2;
            return z2.test(n3) ? i2 = e4[n3] : (r4[n3] = r4[n3] || f2.nestedProperty(e4, n3).get, i2 = r4[n3]()), f2.isValidTextValue(i2) ? i2 : "";
          });
        };
        var R = { max: 10, count: 0, name: "hovertemplate" };
        f2.hovertemplateString = function() {
          return U.apply(R, arguments);
        };
        var F2 = { max: 10, count: 0, name: "texttemplate" };
        f2.texttemplateString = function() {
          return U.apply(F2, arguments);
        };
        var B2 = /^(\S+)([\*\/])(-?\d+(\.\d+)?)$/, N = { max: 10, count: 0, name: "texttemplate", parseMultDiv: true };
        f2.texttemplateStringForShapes = function() {
          return U.apply(N, arguments);
        };
        var j = /^[:|\|]/;
        function U(t3, e4, r4) {
          var n3 = this, a2 = arguments;
          e4 || (e4 = {});
          var o2 = {};
          return t3.replace(f2.TEMPLATE_STRING_REGEX, function(t4, s2, l3) {
            var u3 = "_xother" === s2 || "_yother" === s2, c3 = "_xother_" === s2 || "_yother_" === s2, h3 = "xother_" === s2 || "yother_" === s2, p3 = "xother" === s2 || "yother" === s2 || u3 || h3 || c3, d3 = s2;
            (u3 || c3) && (d3 = d3.substring(1)), (h3 || c3) && (d3 = d3.substring(0, d3.length - 1));
            var v3, g3, y3, m3 = null, x2 = null;
            if (n3.parseMultDiv) {
              var b3 = function(t5) {
                var e5 = t5.match(B2);
                return e5 ? { key: e5[1], op: e5[2], number: Number(e5[3]) } : { key: t5, op: null, number: null };
              }(d3);
              d3 = b3.key, m3 = b3.op, x2 = b3.number;
            }
            if (p3) {
              if (void 0 === (v3 = e4[d3]))
                return "";
            } else
              for (y3 = 3; y3 < a2.length; y3++)
                if (g3 = a2[y3]) {
                  if (g3.hasOwnProperty(d3)) {
                    v3 = g3[d3];
                    break;
                  }
                  if (z2.test(d3) || (v3 = f2.nestedProperty(g3, d3).get(), (v3 = o2[d3] || f2.nestedProperty(g3, d3).get()) && (o2[d3] = v3)), void 0 !== v3)
                    break;
                }
            if (void 0 !== v3 && ("*" === m3 && (v3 *= x2), "/" === m3 && (v3 /= x2)), void 0 === v3 && n3)
              return n3.count < n3.max && (f2.warn("Variable '" + d3 + "' in " + n3.name + " could not be found!"), v3 = t4), n3.count === n3.max && f2.warn("Too many " + n3.name + " warnings - additional warnings will be suppressed"), n3.count++, t4;
            if (l3) {
              var _2;
              if (":" === l3[0] && (v3 = (_2 = r4 ? r4.numberFormat : f2.numberFormat)(l3.replace(j, ""))(v3)), "|" === l3[0]) {
                _2 = r4 ? r4.timeFormat : i;
                var w3 = f2.dateTime2ms(v3);
                v3 = f2.formatDate(w3, l3.replace(j, ""), false, _2);
              }
            } else {
              var T2 = d3 + "Label";
              e4.hasOwnProperty(T2) && (v3 = e4[T2]);
            }
            return p3 && (v3 = "(" + v3 + ")", (u3 || c3) && (v3 = " " + v3), (h3 || c3) && (v3 += " ")), v3;
          });
        }
        f2.subplotSort = function(t3, e4) {
          for (var r4 = Math.min(t3.length, e4.length) + 1, n3 = 0, i2 = 0, a2 = 0; a2 < r4; a2++) {
            var o2 = t3.charCodeAt(a2) || 0, s2 = e4.charCodeAt(a2) || 0, l3 = o2 >= 48 && o2 <= 57, u3 = s2 >= 48 && s2 <= 57;
            if (l3 && (n3 = 10 * n3 + o2 - 48), u3 && (i2 = 10 * i2 + s2 - 48), !l3 || !u3) {
              if (n3 !== i2)
                return n3 - i2;
              if (o2 !== s2)
                return o2 - s2;
            }
          }
          return i2 - n3;
        };
        var V = 2e9;
        f2.seedPseudoRandom = function() {
          V = 2e9;
        }, f2.pseudoRandom = function() {
          var t3 = V;
          return V = (69069 * V + 1) % 4294967296, Math.abs(V - t3) < 429496729 ? f2.pseudoRandom() : V / 4294967296;
        }, f2.fillText = function(t3, e4, r4) {
          var n3 = Array.isArray(r4) ? function(t4) {
            r4.push(t4);
          } : function(t4) {
            r4.text = t4;
          }, i2 = f2.extractOption(t3, e4, "htx", "hovertext");
          if (f2.isValidTextValue(i2))
            return n3(i2);
          var a2 = f2.extractOption(t3, e4, "tx", "text");
          return f2.isValidTextValue(a2) ? n3(a2) : void 0;
        }, f2.isValidTextValue = function(t3) {
          return t3 || 0 === t3;
        }, f2.formatPercent = function(t3, e4) {
          e4 = e4 || 0;
          for (var r4 = (Math.round(100 * t3 * Math.pow(10, e4)) * Math.pow(0.1, e4)).toFixed(e4) + "%", n3 = 0; n3 < e4; n3++)
            -1 !== r4.indexOf(".") && (r4 = (r4 = r4.replace("0%", "%")).replace(".%", "%"));
          return r4;
        }, f2.isHidden = function(t3) {
          var e4 = window.getComputedStyle(t3).display;
          return !e4 || "none" === e4;
        }, f2.strTranslate = function(t3, e4) {
          return t3 || e4 ? "translate(" + t3 + "," + e4 + ")" : "";
        }, f2.strRotate = function(t3) {
          return t3 ? "rotate(" + t3 + ")" : "";
        }, f2.strScale = function(t3) {
          return 1 !== t3 ? "scale(" + t3 + ")" : "";
        }, f2.getTextTransform = function(t3) {
          var e4 = t3.noCenter, r4 = t3.textX, n3 = t3.textY, i2 = t3.targetX, a2 = t3.targetY, o2 = t3.anchorX || 0, s2 = t3.anchorY || 0, l3 = t3.rotate, u3 = t3.scale;
          return u3 ? u3 > 1 && (u3 = 1) : u3 = 0, f2.strTranslate(i2 - u3 * (r4 + o2), a2 - u3 * (n3 + s2)) + f2.strScale(u3) + (l3 ? "rotate(" + l3 + (e4 ? "" : " " + r4 + " " + n3) + ")" : "");
        }, f2.setTransormAndDisplay = function(t3, e4) {
          t3.attr("transform", f2.getTextTransform(e4)), t3.style("display", e4.scale ? null : "none");
        }, f2.ensureUniformFontSize = function(t3, e4) {
          var r4 = f2.extendFlat({}, e4);
          return r4.size = Math.max(e4.size, t3._fullLayout.uniformtext.minsize || 0), r4;
        }, f2.join2 = function(t3, e4, r4) {
          var n3 = t3.length;
          return n3 > 1 ? t3.slice(0, -1).join(e4) + r4 + t3[n3 - 1] : t3.join(e4);
        }, f2.bigFont = function(t3) {
          return Math.round(1.2 * t3);
        };
        var q2 = f2.getFirefoxVersion(), H2 = null !== q2 && q2 < 86;
        f2.getPositionFromD3Event = function() {
          return H2 ? [n2.event.layerX, n2.event.layerY] : [n2.event.offsetX, n2.event.offsetY];
        };
      }, 63620: function(t2) {
        t2.exports = function(t3) {
          return window && window.process && window.process.versions ? "[object Object]" === Object.prototype.toString.call(t3) : "[object Object]" === Object.prototype.toString.call(t3) && Object.getPrototypeOf(t3).hasOwnProperty("hasOwnProperty");
        };
      }, 37804: function(t2, e3, r3) {
        var n2 = r3(22296), i = /^\w*$/;
        t2.exports = function(t3, e4, r4, a) {
          var o, s, l2;
          r4 = r4 || "name", a = a || "value";
          var u2 = {};
          e4 && e4.length ? (l2 = n2(t3, e4), s = l2.get()) : s = t3, e4 = e4 || "";
          var c2 = {};
          if (s)
            for (o = 0; o < s.length; o++)
              c2[s[o][r4]] = o;
          var f2 = i.test(a), h2 = { set: function(t4, e5) {
            var i2 = null === e5 ? 4 : 0;
            if (!s) {
              if (!l2 || 4 === i2)
                return;
              s = [], l2.set(s);
            }
            var o2 = c2[t4];
            if (void 0 === o2) {
              if (4 === i2)
                return;
              i2 |= 3, o2 = s.length, c2[t4] = o2;
            } else
              e5 !== (f2 ? s[o2][a] : n2(s[o2], a).get()) && (i2 |= 2);
            var p2 = s[o2] = s[o2] || {};
            return p2[r4] = t4, f2 ? p2[a] = e5 : n2(p2, a).set(e5), null !== e5 && (i2 &= -5), u2[o2] = u2[o2] | i2, h2;
          }, get: function(t4) {
            if (s) {
              var e5 = c2[t4];
              return void 0 === e5 ? void 0 : f2 ? s[e5][a] : n2(s[e5], a).get();
            }
          }, rename: function(t4, e5) {
            var n3 = c2[t4];
            return void 0 === n3 || (u2[n3] = 1 | u2[n3], c2[e5] = n3, delete c2[t4], s[n3][r4] = e5), h2;
          }, remove: function(t4) {
            var e5 = c2[t4];
            if (void 0 === e5)
              return h2;
            var i2 = s[e5];
            if (Object.keys(i2).length > 2)
              return u2[e5] = 2 | u2[e5], h2.set(t4, null);
            if (f2) {
              for (o = e5; o < s.length; o++)
                u2[o] = 3 | u2[o];
              for (o = e5; o < s.length; o++)
                c2[s[o][r4]]--;
              s.splice(e5, 1), delete c2[t4];
            } else
              n2(i2, a).set(null), u2[e5] = 6 | u2[e5];
            return h2;
          }, constructUpdate: function() {
            for (var t4, i2, o2 = {}, l3 = Object.keys(u2), c3 = 0; c3 < l3.length; c3++)
              i2 = l3[c3], t4 = e4 + "[" + i2 + "]", s[i2] ? (1 & u2[i2] && (o2[t4 + "." + r4] = s[i2][r4]), 2 & u2[i2] && (o2[t4 + "." + a] = f2 ? 4 & u2[i2] ? null : s[i2][a] : 4 & u2[i2] ? null : n2(s[i2], a).get())) : o2[t4] = null;
            return o2;
          } };
          return h2;
        };
      }, 98356: function(t2, e3, r3) {
        var n2 = r3(24040);
        t2.exports = function(t3, e4) {
          for (var r4 = t3._context.locale, i = 0; i < 2; i++) {
            for (var a = t3._context.locales, o = 0; o < 2; o++) {
              var s = (a[r4] || {}).dictionary;
              if (s) {
                var l2 = s[e4];
                if (l2)
                  return l2;
              }
              a = n2.localeRegistry;
            }
            var u2 = r4.split("-")[0];
            if (u2 === r4)
              break;
            r4 = u2;
          }
          return e4;
        };
      }, 24248: function(t2, e3, r3) {
        var n2 = r3(20556).dfltConfig, i = r3(41792), a = t2.exports = {};
        a.log = function() {
          var t3;
          if (n2.logging > 1) {
            var e4 = ["LOG:"];
            for (t3 = 0; t3 < arguments.length; t3++)
              e4.push(arguments[t3]);
            console.trace.apply(console, e4);
          }
          if (n2.notifyOnLogging > 1) {
            var r4 = [];
            for (t3 = 0; t3 < arguments.length; t3++)
              r4.push(arguments[t3]);
            i(r4.join("<br>"), "long");
          }
        }, a.warn = function() {
          var t3;
          if (n2.logging > 0) {
            var e4 = ["WARN:"];
            for (t3 = 0; t3 < arguments.length; t3++)
              e4.push(arguments[t3]);
            console.trace.apply(console, e4);
          }
          if (n2.notifyOnLogging > 0) {
            var r4 = [];
            for (t3 = 0; t3 < arguments.length; t3++)
              r4.push(arguments[t3]);
            i(r4.join("<br>"), "stick");
          }
        }, a.error = function() {
          var t3;
          if (n2.logging > 0) {
            var e4 = ["ERROR:"];
            for (t3 = 0; t3 < arguments.length; t3++)
              e4.push(arguments[t3]);
            console.error.apply(console, e4);
          }
          if (n2.notifyOnLogging > 0) {
            var r4 = [];
            for (t3 = 0; t3 < arguments.length; t3++)
              r4.push(arguments[t3]);
            i(r4.join("<br>"), "stick");
          }
        };
      }, 30988: function(t2, e3, r3) {
        var n2 = r3(33428);
        t2.exports = function(t3, e4, r4) {
          var i = t3.selectAll("g." + r4.replace(/\s/g, ".")).data(e4, function(t4) {
            return t4[0].trace.uid;
          });
          i.exit().remove(), i.enter().append("g").attr("class", r4), i.order();
          var a = t3.classed("rangeplot") ? "nodeRangePlot3" : "node3";
          return i.each(function(t4) {
            t4[0][a] = n2.select(this);
          }), i;
        };
      }, 52248: function(t2, e3, r3) {
        var n2 = r3(36524);
        e3.init2dArray = function(t3, e4) {
          for (var r4 = new Array(t3), n3 = 0; n3 < t3; n3++)
            r4[n3] = new Array(e4);
          return r4;
        }, e3.transposeRagged = function(t3) {
          var e4, r4, n3 = 0, i = t3.length;
          for (e4 = 0; e4 < i; e4++)
            n3 = Math.max(n3, t3[e4].length);
          var a = new Array(n3);
          for (e4 = 0; e4 < n3; e4++)
            for (a[e4] = new Array(i), r4 = 0; r4 < i; r4++)
              a[e4][r4] = t3[r4][e4];
          return a;
        }, e3.dot = function(t3, r4) {
          if (!t3.length || !r4.length || t3.length !== r4.length)
            return null;
          var n3, i, a = t3.length;
          if (t3[0].length)
            for (n3 = new Array(a), i = 0; i < a; i++)
              n3[i] = e3.dot(t3[i], r4);
          else if (r4[0].length) {
            var o = e3.transposeRagged(r4);
            for (n3 = new Array(o.length), i = 0; i < o.length; i++)
              n3[i] = e3.dot(t3, o[i]);
          } else
            for (n3 = 0, i = 0; i < a; i++)
              n3 += t3[i] * r4[i];
          return n3;
        }, e3.translationMatrix = function(t3, e4) {
          return [[1, 0, t3], [0, 1, e4], [0, 0, 1]];
        }, e3.rotationMatrix = function(t3) {
          var e4 = t3 * Math.PI / 180;
          return [[Math.cos(e4), -Math.sin(e4), 0], [Math.sin(e4), Math.cos(e4), 0], [0, 0, 1]];
        }, e3.rotationXYMatrix = function(t3, r4, n3) {
          return e3.dot(e3.dot(e3.translationMatrix(r4, n3), e3.rotationMatrix(t3)), e3.translationMatrix(-r4, -n3));
        }, e3.apply3DTransform = function(t3) {
          return function() {
            var r4 = arguments, n3 = 1 === arguments.length ? r4[0] : [r4[0], r4[1], r4[2] || 0];
            return e3.dot(t3, [n3[0], n3[1], n3[2], 1]).slice(0, 3);
          };
        }, e3.apply2DTransform = function(t3) {
          return function() {
            var r4 = arguments;
            3 === r4.length && (r4 = r4[0]);
            var n3 = 1 === arguments.length ? r4[0] : [r4[0], r4[1]];
            return e3.dot(t3, [n3[0], n3[1], 1]).slice(0, 2);
          };
        }, e3.apply2DTransform2 = function(t3) {
          var r4 = e3.apply2DTransform(t3);
          return function(t4) {
            return r4(t4.slice(0, 2)).concat(r4(t4.slice(2, 4)));
          };
        }, e3.convertCssMatrix = function(t3) {
          if (t3) {
            var e4 = t3.length;
            if (16 === e4)
              return t3;
            if (6 === e4)
              return [t3[0], t3[1], 0, 0, t3[2], t3[3], 0, 0, 0, 0, 1, 0, t3[4], t3[5], 0, 1];
          }
          return [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];
        }, e3.inverseTransformMatrix = function(t3) {
          var e4 = [];
          return n2.invert(e4, t3), [[e4[0], e4[1], e4[2], e4[3]], [e4[4], e4[5], e4[6], e4[7]], [e4[8], e4[9], e4[10], e4[11]], [e4[12], e4[13], e4[14], e4[15]]];
        };
      }, 20435: function(t2) {
        t2.exports = { mod: function(t3, e3) {
          var r3 = t3 % e3;
          return r3 < 0 ? r3 + e3 : r3;
        }, modHalf: function(t3, e3) {
          return Math.abs(t3) > e3 / 2 ? t3 - Math.round(t3 / e3) * e3 : t3;
        } };
      }, 22296: function(t2, e3, r3) {
        var n2 = r3(38248), i = r3(38116).isArrayOrTypedArray;
        function a(t3, e4) {
          return function() {
            var r4, n3, o2, s2, l3, u3 = t3;
            for (s2 = 0; s2 < e4.length - 1; s2++) {
              if (-1 === (r4 = e4[s2])) {
                for (n3 = true, o2 = [], l3 = 0; l3 < u3.length; l3++)
                  o2[l3] = a(u3[l3], e4.slice(s2 + 1))(), o2[l3] !== o2[0] && (n3 = false);
                return n3 ? o2[0] : o2;
              }
              if ("number" == typeof r4 && !i(u3))
                return;
              if ("object" != typeof (u3 = u3[r4]) || null === u3)
                return;
            }
            if ("object" == typeof u3 && null !== u3 && null !== (o2 = u3[e4[s2]]))
              return o2;
          };
        }
        t2.exports = function(t3, e4) {
          if (n2(e4))
            e4 = String(e4);
          else if ("string" != typeof e4 || "[-1]" === e4.substr(e4.length - 4))
            throw "bad property string";
          var r4, i2, o2, s2, u3 = e4.split(".");
          for (s2 = 0; s2 < u3.length; s2++)
            if ("__" === String(u3[s2]).slice(0, 2))
              throw "bad property string";
          for (s2 = 0; s2 < u3.length; ) {
            if (r4 = String(u3[s2]).match(/^([^\[\]]*)((\[\-?[0-9]*\])+)$/)) {
              if (r4[1])
                u3[s2] = r4[1];
              else {
                if (0 !== s2)
                  throw "bad property string";
                u3.splice(0, 1);
              }
              for (i2 = r4[2].substr(1, r4[2].length - 2).split("]["), o2 = 0; o2 < i2.length; o2++)
                s2++, u3.splice(s2, 0, Number(i2[o2]));
            }
            s2++;
          }
          return "object" != typeof t3 ? function(t4, e5, r5) {
            return { set: function() {
              throw "bad container";
            }, get: function() {
            }, astr: e5, parts: r5, obj: t4 };
          }(t3, e4, u3) : { set: l2(t3, u3, e4), get: a(t3, u3), astr: e4, parts: u3, obj: t3 };
        };
        var o = /(^|\.)args\[/;
        function s(t3, e4) {
          return void 0 === t3 || null === t3 && !e4.match(o);
        }
        function l2(t3, e4, r4) {
          return function(n3) {
            var a2, o2, l3 = t3, h2 = "", d2 = s(n3, r4);
            for (o2 = 0; o2 < e4.length - 1; o2++) {
              if ("number" == typeof (a2 = e4[o2]) && !i(l3))
                throw "array index but container is not an array";
              if (-1 === a2) {
                if (d2 = !c2(l3, e4.slice(o2 + 1), n3, r4))
                  break;
                return;
              }
              if (!f2(l3, a2, e4[o2 + 1], d2))
                break;
              if ("object" != typeof (l3 = l3[a2]) || null === l3)
                throw "container is not an object";
              h2 = u2(h2, a2);
            }
            if (d2) {
              if (o2 === e4.length - 1 && (delete l3[e4[o2]], Array.isArray(l3) && +e4[o2] == l3.length - 1))
                for (; l3.length && void 0 === l3[l3.length - 1]; )
                  l3.pop();
            } else
              l3[e4[o2]] = n3;
          };
        }
        function u2(t3, e4) {
          var r4 = e4;
          return n2(e4) ? r4 = "[" + e4 + "]" : t3 && (r4 = "." + e4), t3 + r4;
        }
        function c2(t3, e4, r4, n3) {
          var a2, o2 = i(r4), u3 = true, c3 = r4, h2 = n3.replace("-1", 0), p2 = !o2 && s(r4, h2), d2 = e4[0];
          for (a2 = 0; a2 < t3.length; a2++)
            h2 = n3.replace("-1", a2), o2 && (p2 = s(c3 = r4[a2 % r4.length], h2)), p2 && (u3 = false), f2(t3, a2, d2, p2) && l2(t3[a2], e4, n3.replace("-1", a2))(c3);
          return u3;
        }
        function f2(t3, e4, r4, n3) {
          if (void 0 === t3[e4]) {
            if (n3)
              return false;
            t3[e4] = "number" == typeof r4 ? [] : {};
          }
          return true;
        }
      }, 16628: function(t2) {
        t2.exports = function() {
        };
      }, 41792: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(38248), a = [];
        t2.exports = function(t3, e4) {
          if (-1 === a.indexOf(t3)) {
            a.push(t3);
            var r4 = 1e3;
            i(e4) ? r4 = e4 : "long" === e4 && (r4 = 3e3);
            var o = n2.select("body").selectAll(".plotly-notifier").data([0]);
            o.enter().append("div").classed("plotly-notifier", true), o.selectAll(".notifier-note").data(a).enter().append("div").classed("notifier-note", true).style("opacity", 0).each(function(t4) {
              var i2 = n2.select(this);
              i2.append("button").classed("notifier-close", true).html("&times;").on("click", function() {
                i2.transition().call(s);
              });
              for (var a2 = i2.append("p"), o2 = t4.split(/<br\s*\/?>/g), l2 = 0; l2 < o2.length; l2++)
                l2 && a2.append("br"), a2.append("span").text(o2[l2]);
              "stick" === e4 ? i2.transition().duration(350).style("opacity", 1) : i2.transition().duration(700).style("opacity", 1).transition().delay(r4).call(s);
            });
          }
          function s(t4) {
            t4.duration(700).style("opacity", 0).each("end", function(t5) {
              var e5 = a.indexOf(t5);
              -1 !== e5 && a.splice(e5, 1), n2.select(this).remove();
            });
          }
        };
      }, 72213: function(t2, e3, r3) {
        var n2 = r3(93972), i = "data-savedcursor";
        t2.exports = function(t3, e4) {
          var r4 = t3.attr(i);
          if (e4) {
            if (!r4) {
              for (var a = (t3.attr("class") || "").split(" "), o = 0; o < a.length; o++) {
                var s = a[o];
                0 === s.indexOf("cursor-") && t3.attr(i, s.substr(7)).classed(s, false);
              }
              t3.attr(i) || t3.attr(i, "!!");
            }
            n2(t3, e4);
          } else
            r4 && (t3.attr(i, null), "!!" === r4 ? n2(t3) : n2(t3, r4));
        };
      }, 92065: function(t2, e3, r3) {
        var n2 = r3(52248).dot, i = r3(39032).BADNUM, a = t2.exports = {};
        a.tester = function(t3) {
          var e4, r4 = t3.slice(), n3 = r4[0][0], a2 = n3, o = r4[0][1], s = o;
          for (r4[r4.length - 1][0] === r4[0][0] && r4[r4.length - 1][1] === r4[0][1] || r4.push(r4[0]), e4 = 1; e4 < r4.length; e4++)
            n3 = Math.min(n3, r4[e4][0]), a2 = Math.max(a2, r4[e4][0]), o = Math.min(o, r4[e4][1]), s = Math.max(s, r4[e4][1]);
          var l2, u2 = false;
          5 === r4.length && (r4[0][0] === r4[1][0] ? r4[2][0] === r4[3][0] && r4[0][1] === r4[3][1] && r4[1][1] === r4[2][1] && (u2 = true, l2 = function(t4) {
            return t4[0] === r4[0][0];
          }) : r4[0][1] === r4[1][1] && r4[2][1] === r4[3][1] && r4[0][0] === r4[3][0] && r4[1][0] === r4[2][0] && (u2 = true, l2 = function(t4) {
            return t4[1] === r4[0][1];
          }));
          var c2 = true, f2 = r4[0];
          for (e4 = 1; e4 < r4.length; e4++)
            if (f2[0] !== r4[e4][0] || f2[1] !== r4[e4][1]) {
              c2 = false;
              break;
            }
          return { xmin: n3, xmax: a2, ymin: o, ymax: s, pts: r4, contains: u2 ? function(t4, e5) {
            var r5 = t4[0], u3 = t4[1];
            return !(r5 === i || r5 < n3 || r5 > a2 || u3 === i || u3 < o || u3 > s || e5 && l2(t4));
          } : function(t4, e5) {
            var l3 = t4[0], u3 = t4[1];
            if (l3 === i || l3 < n3 || l3 > a2 || u3 === i || u3 < o || u3 > s)
              return false;
            var c3, f3, h2, p2, d2, v2 = r4.length, g2 = r4[0][0], y2 = r4[0][1], m2 = 0;
            for (c3 = 1; c3 < v2; c3++)
              if (f3 = g2, h2 = y2, g2 = r4[c3][0], y2 = r4[c3][1], !(l3 < (p2 = Math.min(f3, g2)) || l3 > Math.max(f3, g2) || u3 > Math.max(h2, y2)))
                if (u3 < Math.min(h2, y2))
                  l3 !== p2 && m2++;
                else {
                  if (u3 === (d2 = g2 === f3 ? u3 : h2 + (l3 - f3) * (y2 - h2) / (g2 - f3)))
                    return 1 !== c3 || !e5;
                  u3 <= d2 && l3 !== p2 && m2++;
                }
            return m2 % 2 == 1;
          }, isRect: u2, degenerate: c2 };
        }, a.isSegmentBent = function(t3, e4, r4, i2) {
          var a2, o, s, l2 = t3[e4], u2 = [t3[r4][0] - l2[0], t3[r4][1] - l2[1]], c2 = n2(u2, u2), f2 = Math.sqrt(c2), h2 = [-u2[1] / f2, u2[0] / f2];
          for (a2 = e4 + 1; a2 < r4; a2++)
            if (o = [t3[a2][0] - l2[0], t3[a2][1] - l2[1]], (s = n2(o, u2)) < 0 || s > c2 || Math.abs(n2(o, h2)) > i2)
              return true;
          return false;
        }, a.filter = function(t3, e4) {
          var r4 = [t3[0]], n3 = 0, i2 = 0;
          function o(o2) {
            t3.push(o2);
            var s = r4.length, l2 = n3;
            r4.splice(i2 + 1);
            for (var u2 = l2 + 1; u2 < t3.length; u2++)
              (u2 === t3.length - 1 || a.isSegmentBent(t3, l2, u2 + 1, e4)) && (r4.push(t3[u2]), r4.length < s - 2 && (n3 = u2, i2 = r4.length - 1), l2 = u2);
          }
          return t3.length > 1 && o(t3.pop()), { addPt: o, raw: t3, filtered: r4 };
        };
      }, 5048: function(t2, e3, r3) {
        var n2 = r3(16576), i = r3(28624);
        t2.exports = function(t3, e4, a) {
          var o = t3._fullLayout, s = true;
          return o._glcanvas.each(function(n3) {
            if (n3.regl)
              n3.regl.preloadCachedCode(a);
            else if (!n3.pick || o._has("parcoords")) {
              try {
                n3.regl = i({ canvas: this, attributes: { antialias: !n3.pick, preserveDrawingBuffer: true }, pixelRatio: t3._context.plotGlPixelRatio || r3.g.devicePixelRatio, extensions: e4 || [], cachedCode: a || {} });
              } catch (t4) {
                s = false;
              }
              n3.regl || (s = false), s && this.addEventListener("webglcontextlost", function(e5) {
                t3 && t3.emit && t3.emit("plotly_webglcontextlost", { event: e5, layer: n3.key });
              }, false);
            }
          }), s || n2({ container: o._glcontainer.node() }), s;
        };
      }, 34296: function(t2, e3, r3) {
        var n2 = r3(38248), i = r3(25928);
        t2.exports = function(t3) {
          var e4;
          if ("string" != typeof (e4 = t3 && t3.hasOwnProperty("userAgent") ? t3.userAgent : function() {
            var t4;
            return "undefined" != typeof navigator && (t4 = navigator.userAgent), t4 && t4.headers && "string" == typeof t4.headers["user-agent"] && (t4 = t4.headers["user-agent"]), t4;
          }()))
            return true;
          var r4 = i({ ua: { headers: { "user-agent": e4 } }, tablet: true, featureDetect: false });
          if (!r4) {
            for (var a = e4.split(" "), o = 1; o < a.length; o++)
              if (-1 !== a[o].indexOf("Safari"))
                for (var s = o - 1; s > -1; s--) {
                  var l2 = a[s];
                  if ("Version/" === l2.substr(0, 8)) {
                    var u2 = l2.substr(8).split(".")[0];
                    if (n2(u2) && (u2 = +u2), u2 >= 13)
                      return true;
                  }
                }
          }
          return r4;
        };
      }, 52416: function(t2) {
        t2.exports = function(t3, e3) {
          if (e3 instanceof RegExp) {
            for (var r3 = e3.toString(), n2 = 0; n2 < t3.length; n2++)
              if (t3[n2] instanceof RegExp && t3[n2].toString() === r3)
                return t3;
            t3.push(e3);
          } else
            !e3 && 0 !== e3 || -1 !== t3.indexOf(e3) || t3.push(e3);
          return t3;
        };
      }, 94552: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(20556).dfltConfig, a = { add: function(t3, e4, r4, n3, a2) {
          var o, s;
          t3.undoQueue = t3.undoQueue || { index: 0, queue: [], sequence: false }, s = t3.undoQueue.index, t3.autoplay ? t3.undoQueue.inSequence || (t3.autoplay = false) : (!t3.undoQueue.sequence || t3.undoQueue.beginSequence ? (o = { undo: { calls: [], args: [] }, redo: { calls: [], args: [] } }, t3.undoQueue.queue.splice(s, t3.undoQueue.queue.length - s, o), t3.undoQueue.index += 1) : o = t3.undoQueue.queue[s - 1], t3.undoQueue.beginSequence = false, o && (o.undo.calls.unshift(e4), o.undo.args.unshift(r4), o.redo.calls.push(n3), o.redo.args.push(a2)), t3.undoQueue.queue.length > i.queueLength && (t3.undoQueue.queue.shift(), t3.undoQueue.index--));
        }, startSequence: function(t3) {
          t3.undoQueue = t3.undoQueue || { index: 0, queue: [], sequence: false }, t3.undoQueue.sequence = true, t3.undoQueue.beginSequence = true;
        }, stopSequence: function(t3) {
          t3.undoQueue = t3.undoQueue || { index: 0, queue: [], sequence: false }, t3.undoQueue.sequence = false, t3.undoQueue.beginSequence = false;
        }, undo: function(t3) {
          var e4, r4;
          if (!(void 0 === t3.undoQueue || isNaN(t3.undoQueue.index) || t3.undoQueue.index <= 0)) {
            for (t3.undoQueue.index--, e4 = t3.undoQueue.queue[t3.undoQueue.index], t3.undoQueue.inSequence = true, r4 = 0; r4 < e4.undo.calls.length; r4++)
              a.plotDo(t3, e4.undo.calls[r4], e4.undo.args[r4]);
            t3.undoQueue.inSequence = false, t3.autoplay = false;
          }
        }, redo: function(t3) {
          var e4, r4;
          if (!(void 0 === t3.undoQueue || isNaN(t3.undoQueue.index) || t3.undoQueue.index >= t3.undoQueue.queue.length)) {
            for (e4 = t3.undoQueue.queue[t3.undoQueue.index], t3.undoQueue.inSequence = true, r4 = 0; r4 < e4.redo.calls.length; r4++)
              a.plotDo(t3, e4.redo.calls[r4], e4.redo.args[r4]);
            t3.undoQueue.inSequence = false, t3.autoplay = false, t3.undoQueue.index++;
          }
        }, plotDo: function(t3, e4, r4) {
          t3.autoplay = true, r4 = function(t4, e5) {
            for (var r5, i2 = [], a2 = 0; a2 < e5.length; a2++)
              r5 = e5[a2], i2[a2] = r5 === t4 ? r5 : "object" == typeof r5 ? Array.isArray(r5) ? n2.extendDeep([], r5) : n2.extendDeepAll({}, r5) : r5;
            return i2;
          }(t3, r4), e4.apply(null, r4);
        } };
        t2.exports = a;
      }, 53756: function(t2, e3) {
        e3.counter = function(t3, e4, r3, n2) {
          var i = (e4 || "") + (r3 ? "" : "$"), a = false === n2 ? "" : "^";
          return "xy" === t3 ? new RegExp(a + "x([2-9]|[1-9][0-9]+)?y([2-9]|[1-9][0-9]+)?" + i) : new RegExp(a + t3 + "([2-9]|[1-9][0-9]+)?" + i);
        };
      }, 23193: function(t2) {
        var e3 = /^(.*)(\.[^\.\[\]]+|\[\d\])$/, r3 = /^[^\.\[\]]+$/;
        t2.exports = function(t3, n2) {
          for (; n2; ) {
            var i = t3.match(e3);
            if (i)
              t3 = i[1];
            else {
              if (!t3.match(r3))
                throw new Error("bad relativeAttr call:" + [t3, n2]);
              t3 = "";
            }
            if ("^" !== n2.charAt(0))
              break;
            n2 = n2.slice(1);
          }
          return t3 && "[" !== n2.charAt(0) ? t3 + "." + n2 : t3 + n2;
        };
      }, 51528: function(t2, e3, r3) {
        var n2 = r3(38116).isArrayOrTypedArray, i = r3(63620);
        t2.exports = function t3(e4, r4) {
          for (var a in r4) {
            var o = r4[a], s = e4[a];
            if (s !== o)
              if ("_" === a.charAt(0) || "function" == typeof o) {
                if (a in e4)
                  continue;
                e4[a] = o;
              } else if (n2(o) && n2(s) && i(o[0])) {
                if ("customdata" === a || "ids" === a)
                  continue;
                for (var l2 = Math.min(o.length, s.length), u2 = 0; u2 < l2; u2++)
                  s[u2] !== o[u2] && i(o[u2]) && i(s[u2]) && t3(s[u2], o[u2]);
              } else
                i(o) && i(s) && (t3(s, o), Object.keys(s).length || delete e4[a]);
          }
        };
      }, 14952: function(t2, e3, r3) {
        var n2 = r3(38248), i = r3(24248), a = r3(35536), o = r3(39032).BADNUM, s = 1e-9;
        function l2(t3, e4) {
          return t3 < e4;
        }
        function u2(t3, e4) {
          return t3 <= e4;
        }
        function c2(t3, e4) {
          return t3 > e4;
        }
        function f2(t3, e4) {
          return t3 >= e4;
        }
        e3.findBin = function(t3, e4, r4) {
          if (n2(e4.start))
            return r4 ? Math.ceil((t3 - e4.start) / e4.size - s) - 1 : Math.floor((t3 - e4.start) / e4.size + s);
          var a2, o2, h2 = 0, p2 = e4.length, d2 = 0, v2 = p2 > 1 ? (e4[p2 - 1] - e4[0]) / (p2 - 1) : 1;
          for (o2 = v2 >= 0 ? r4 ? l2 : u2 : r4 ? f2 : c2, t3 += v2 * s * (r4 ? -1 : 1) * (v2 >= 0 ? 1 : -1); h2 < p2 && d2++ < 100; )
            o2(e4[a2 = Math.floor((h2 + p2) / 2)], t3) ? h2 = a2 + 1 : p2 = a2;
          return d2 > 90 && i.log("Long binary search..."), h2 - 1;
        }, e3.sorterAsc = function(t3, e4) {
          return t3 - e4;
        }, e3.sorterDes = function(t3, e4) {
          return e4 - t3;
        }, e3.distinctVals = function(t3) {
          var r4, n3 = t3.slice();
          for (n3.sort(e3.sorterAsc), r4 = n3.length - 1; r4 > -1 && n3[r4] === o; r4--)
            ;
          for (var i2, a2 = n3[r4] - n3[0] || 1, s2 = a2 / (r4 || 1) / 1e4, l3 = [], u3 = 0; u3 <= r4; u3++) {
            var c3 = n3[u3], f3 = c3 - i2;
            void 0 === i2 ? (l3.push(c3), i2 = c3) : f3 > s2 && (a2 = Math.min(a2, f3), l3.push(c3), i2 = c3);
          }
          return { vals: l3, minDiff: a2 };
        }, e3.roundUp = function(t3, e4, r4) {
          for (var n3, i2 = 0, a2 = e4.length - 1, o2 = 0, s2 = r4 ? 0 : 1, l3 = r4 ? 1 : 0, u3 = r4 ? Math.ceil : Math.floor; i2 < a2 && o2++ < 100; )
            e4[n3 = u3((i2 + a2) / 2)] <= t3 ? i2 = n3 + s2 : a2 = n3 - l3;
          return e4[i2];
        }, e3.sort = function(t3, e4) {
          for (var r4 = 0, n3 = 0, i2 = 1; i2 < t3.length; i2++) {
            var a2 = e4(t3[i2], t3[i2 - 1]);
            if (a2 < 0 ? r4 = 1 : a2 > 0 && (n3 = 1), r4 && n3)
              return t3.sort(e4);
          }
          return n3 ? t3 : t3.reverse();
        }, e3.findIndexOfMin = function(t3, e4) {
          e4 = e4 || a;
          for (var r4, n3 = 1 / 0, i2 = 0; i2 < t3.length; i2++) {
            var o2 = e4(t3[i2]);
            o2 < n3 && (n3 = o2, r4 = i2);
          }
          return r4;
        };
      }, 93972: function(t2) {
        t2.exports = function(t3, e3) {
          (t3.attr("class") || "").split(" ").forEach(function(e4) {
            0 === e4.indexOf("cursor-") && t3.classed(e4, false);
          }), e3 && t3.classed("cursor-" + e3, true);
        };
      }, 16576: function(t2, e3, r3) {
        var n2 = r3(76308), i = function() {
        };
        t2.exports = function(t3) {
          for (var e4 in t3)
            "function" == typeof t3[e4] && (t3[e4] = i);
          t3.destroy = function() {
            t3.container.parentNode.removeChild(t3.container);
          };
          var r4 = document.createElement("div");
          r4.className = "no-webgl", r4.style.cursor = "pointer", r4.style.fontSize = "24px", r4.style.color = n2.defaults[0], r4.style.position = "absolute", r4.style.left = r4.style.top = "0px", r4.style.width = r4.style.height = "100%", r4.style["background-color"] = n2.lightLine, r4.style["z-index"] = 30;
          var a = document.createElement("p");
          return a.textContent = "WebGL is not supported by your browser - visit https://get.webgl.org for more info", a.style.position = "relative", a.style.top = "50%", a.style.left = "50%", a.style.height = "30%", a.style.width = "50%", a.style.margin = "-15% 0 0 -25%", r4.appendChild(a), t3.container.appendChild(r4), t3.container.style.background = "#FFFFFF", t3.container.onclick = function() {
            window.open("https://get.webgl.org");
          }, false;
        };
      }, 95376: function(t2) {
        t2.exports = function(t3) {
          return Object.keys(t3).sort();
        };
      }, 63084: function(t2, e3, r3) {
        var n2 = r3(38248), i = r3(38116).isArrayOrTypedArray;
        e3.aggNums = function(t3, r4, a, o) {
          var s, l2;
          if ((!o || o > a.length) && (o = a.length), n2(r4) || (r4 = false), i(a[0])) {
            for (l2 = new Array(o), s = 0; s < o; s++)
              l2[s] = e3.aggNums(t3, r4, a[s]);
            a = l2;
          }
          for (s = 0; s < o; s++)
            n2(r4) ? n2(a[s]) && (r4 = t3(+r4, +a[s])) : r4 = a[s];
          return r4;
        }, e3.len = function(t3) {
          return e3.aggNums(function(t4) {
            return t4 + 1;
          }, 0, t3);
        }, e3.mean = function(t3, r4) {
          return r4 || (r4 = e3.len(t3)), e3.aggNums(function(t4, e4) {
            return t4 + e4;
          }, 0, t3) / r4;
        }, e3.midRange = function(t3) {
          if (void 0 !== t3 && 0 !== t3.length)
            return (e3.aggNums(Math.max, null, t3) + e3.aggNums(Math.min, null, t3)) / 2;
        }, e3.variance = function(t3, r4, i2) {
          return r4 || (r4 = e3.len(t3)), n2(i2) || (i2 = e3.mean(t3, r4)), e3.aggNums(function(t4, e4) {
            return t4 + Math.pow(e4 - i2, 2);
          }, 0, t3) / r4;
        }, e3.stdev = function(t3, r4, n3) {
          return Math.sqrt(e3.variance(t3, r4, n3));
        }, e3.median = function(t3) {
          var r4 = t3.slice().sort();
          return e3.interp(r4, 0.5);
        }, e3.interp = function(t3, e4) {
          if (!n2(e4))
            throw "n should be a finite number";
          if ((e4 = e4 * t3.length - 0.5) < 0)
            return t3[0];
          if (e4 > t3.length - 1)
            return t3[t3.length - 1];
          var r4 = e4 % 1;
          return r4 * t3[Math.ceil(e4)] + (1 - r4) * t3[Math.floor(e4)];
        };
      }, 43080: function(t2, e3, r3) {
        var n2 = r3(72160);
        t2.exports = function(t3) {
          return t3 ? n2(t3) : [0, 0, 0, 1];
        };
      }, 9188: function(t2, e3, r3) {
        var n2 = r3(2264), i = r3(43616), a = r3(3400), o = null;
        t2.exports = function() {
          if (null !== o)
            return o;
          o = false;
          var t3 = a.isIE() || a.isSafari() || a.isIOS();
          if (window.navigator.userAgent && !t3) {
            var e4 = Array.from(n2.CSS_DECLARATIONS).reverse(), r4 = window.CSS && window.CSS.supports || window.supportsCSS;
            if ("function" == typeof r4)
              o = e4.some(function(t4) {
                return r4.apply(null, t4);
              });
            else {
              var s = i.tester.append("image").attr("style", n2.STYLE), l2 = window.getComputedStyle(s.node()).imageRendering;
              o = e4.some(function(t4) {
                var e5 = t4[1];
                return l2 === e5 || l2 === e5.toLowerCase();
              }), s.remove();
            }
          }
          return o;
        };
      }, 72736: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(3400), a = i.strTranslate, o = r3(9616), s = r3(84284).LINE_SPACING, l2 = /([^$]*)([$]+[^$]*[$]+)([^$]*)/;
        e3.convertToTspans = function(t3, r4, g3) {
          var S2 = t3.text(), E3 = !t3.attr("data-notex") && r4 && r4._context.typesetMath && "undefined" != typeof MathJax && S2.match(l2), P2 = n2.select(t3.node().parentNode);
          if (!P2.empty()) {
            var O2 = t3.attr("class") ? t3.attr("class").split(" ")[0] : "text";
            return O2 += "-math", P2.selectAll("svg." + O2).remove(), P2.selectAll("g." + O2 + "-group").remove(), t3.style("display", null).attr({ "data-unformatted": S2, "data-math": "N" }), E3 ? (r4 && r4._promises || []).push(new Promise(function(e4) {
              t3.style("display", "none");
              var r5 = parseInt(t3.node().style.fontSize, 10), o2 = { fontSize: r5 };
              !function(t4, e5, r6) {
                var a2, o3, s2, l3, h3 = parseInt((MathJax.version || "").split(".")[0]);
                if (2 === h3 || 3 === h3) {
                  var p3 = function() {
                    var r7 = "math-output-" + i.randstr({}, 64), a3 = (l3 = n2.select("body").append("div").attr({ id: r7 }).style({ visibility: "hidden", position: "absolute", "font-size": e5.fontSize + "px" }).text(t4.replace(u2, "\\lt ").replace(c2, "\\gt "))).node();
                    return 2 === h3 ? MathJax.Hub.Typeset(a3) : MathJax.typeset([a3]);
                  }, d3 = function() {
                    var e6 = l3.select(2 === h3 ? ".MathJax_SVG" : ".MathJax"), a3 = !e6.empty() && l3.select("svg").node();
                    if (a3) {
                      var o4, s3 = a3.getBoundingClientRect();
                      o4 = 2 === h3 ? n2.select("body").select("#MathJax_SVG_glyphs") : e6.select("defs"), r6(e6, o4, s3);
                    } else
                      i.log("There was an error in the tex syntax.", t4), r6();
                    l3.remove();
                  };
                  2 === h3 ? MathJax.Hub.Queue(function() {
                    return o3 = i.extendDeepAll({}, MathJax.Hub.config), s2 = MathJax.Hub.processSectionDelay, void 0 !== MathJax.Hub.processSectionDelay && (MathJax.Hub.processSectionDelay = 0), MathJax.Hub.Config({ messageStyle: "none", tex2jax: { inlineMath: f2 }, displayAlign: "left" });
                  }, function() {
                    if ("SVG" !== (a2 = MathJax.Hub.config.menuSettings.renderer))
                      return MathJax.Hub.setRenderer("SVG");
                  }, p3, d3, function() {
                    if ("SVG" !== a2)
                      return MathJax.Hub.setRenderer(a2);
                  }, function() {
                    return void 0 !== s2 && (MathJax.Hub.processSectionDelay = s2), MathJax.Hub.Config(o3);
                  }) : 3 === h3 && (o3 = i.extendDeepAll({}, MathJax.config), MathJax.config.tex || (MathJax.config.tex = {}), MathJax.config.tex.inlineMath = f2, "svg" !== (a2 = MathJax.config.startup.output) && (MathJax.config.startup.output = "svg"), MathJax.startup.defaultReady(), MathJax.startup.promise.then(function() {
                    p3(), d3(), "svg" !== a2 && (MathJax.config.startup.output = a2), MathJax.config = o3;
                  }));
                } else
                  i.warn("No MathJax version:", MathJax.version);
              }(E3[2], o2, function(n3, i2, o3) {
                P2.selectAll("svg." + O2).remove(), P2.selectAll("g." + O2 + "-group").remove();
                var s2 = n3 && n3.select("svg");
                if (!s2 || !s2.node())
                  return I2(), void e4();
                var l3 = P2.append("g").classed(O2 + "-group", true).attr({ "pointer-events": "none", "data-unformatted": S2, "data-math": "Y" });
                l3.node().appendChild(s2.node()), i2 && i2.node() && s2.node().insertBefore(i2.node().cloneNode(true), s2.node().firstChild);
                var u3 = o3.width, c3 = o3.height;
                s2.attr({ class: O2, height: c3, preserveAspectRatio: "xMinYMin meet" }).style({ overflow: "visible", "pointer-events": "none" });
                var f3 = t3.node().style.fill || "black", h3 = s2.select("g");
                h3.attr({ fill: f3, stroke: f3 });
                var p3 = h3.node().getBoundingClientRect(), d3 = p3.width, v3 = p3.height;
                (d3 > u3 || v3 > c3) && (s2.style("overflow", "hidden"), d3 = (p3 = s2.node().getBoundingClientRect()).width, v3 = p3.height);
                var y3 = +t3.attr("x"), m3 = +t3.attr("y"), x2 = -(r5 || t3.node().getBoundingClientRect().height) / 4;
                if ("y" === O2[0])
                  l3.attr({ transform: "rotate(" + [-90, y3, m3] + ")" + a(-d3 / 2, x2 - v3 / 2) });
                else if ("l" === O2[0])
                  m3 = x2 - v3 / 2;
                else if ("a" === O2[0] && 0 !== O2.indexOf("atitle"))
                  y3 = 0, m3 = x2;
                else {
                  var b3 = t3.attr("text-anchor");
                  y3 -= d3 * ("middle" === b3 ? 0.5 : "end" === b3 ? 1 : 0), m3 = m3 + x2 - v3 / 2;
                }
                s2.attr({ x: y3, y: m3 }), g3 && g3.call(t3, l3), e4(l3);
              });
            })) : I2(), t3;
          }
          function I2() {
            P2.empty() || (O2 = t3.attr("class") + "-math", P2.select("svg." + O2).remove()), t3.text("").style("white-space", "pre");
            var r5 = function(t4, e4) {
              e4 = e4.replace(y2, " ");
              var r6, a2 = false, l3 = [], u3 = -1;
              function c3() {
                u3++;
                var e5 = document.createElementNS(o.svg, "tspan");
                n2.select(e5).attr({ class: "line", dy: u3 * s + "em" }), t4.appendChild(e5), r6 = e5;
                var i2 = l3;
                if (l3 = [{ node: e5 }], i2.length > 1)
                  for (var a3 = 1; a3 < i2.length; a3++)
                    f3(i2[a3]);
              }
              function f3(t5) {
                var e5, i2 = t5.type, a3 = {};
                if ("a" === i2) {
                  e5 = "a";
                  var s2 = t5.target, u4 = t5.href, c4 = t5.popup;
                  u4 && (a3 = { "xlink:xlink:show": "_blank" === s2 || "_" !== s2.charAt(0) ? "new" : "replace", target: s2, "xlink:xlink:href": u4 }, c4 && (a3.onclick = 'window.open(this.href.baseVal,this.target.baseVal,"' + c4 + '");return false;'));
                } else
                  e5 = "tspan";
                t5.style && (a3.style = t5.style);
                var f4 = document.createElementNS(o.svg, e5);
                if ("sup" === i2 || "sub" === i2) {
                  g4(r6, v2), r6.appendChild(f4);
                  var h3 = document.createElementNS(o.svg, "tspan");
                  g4(h3, v2), n2.select(h3).attr("dy", d2[i2]), a3.dy = p2[i2], r6.appendChild(f4), r6.appendChild(h3);
                } else
                  r6.appendChild(f4);
                n2.select(f4).attr(a3), r6 = t5.node = f4, l3.push(t5);
              }
              function g4(t5, e5) {
                t5.appendChild(document.createTextNode(e5));
              }
              function S3(t5) {
                if (1 !== l3.length) {
                  var n3 = l3.pop();
                  t5 !== n3.type && i.log("Start tag <" + n3.type + "> doesnt match end tag <" + t5 + ">. Pretending it did match.", e4), r6 = l3[l3.length - 1].node;
                } else
                  i.log("Ignoring unexpected end tag </" + t5 + ">.", e4);
              }
              b2.test(e4) ? c3() : (r6 = t4, l3 = [{ node: t4 }]);
              for (var E4 = e4.split(m2), P3 = 0; P3 < E4.length; P3++) {
                var O3 = E4[P3], I3 = O3.match(x), D2 = I3 && I3[2].toLowerCase(), z2 = h2[D2];
                if ("br" === D2)
                  c3();
                else if (void 0 === z2)
                  g4(r6, L(O3));
                else if (I3[1])
                  S3(D2);
                else {
                  var R = I3[4], F2 = { type: D2 }, B2 = A2(R, _);
                  if (B2 ? (B2 = B2.replace(M, "$1 fill:"), z2 && (B2 += ";" + z2)) : z2 && (B2 = z2), B2 && (F2.style = B2), "a" === D2) {
                    a2 = true;
                    var N = A2(R, w2);
                    if (N) {
                      var j = C2(N);
                      j && (F2.href = j, F2.target = A2(R, T) || "_blank", F2.popup = A2(R, k2));
                    }
                  }
                  f3(F2);
                }
              }
              return a2;
            }(t3.node(), S2);
            r5 && t3.style("pointer-events", "all"), e3.positionText(t3), g3 && g3.call(t3);
          }
        };
        var u2 = /(<|&lt;|&#60;)/g, c2 = /(>|&gt;|&#62;)/g, f2 = [["$", "$"], ["\\(", "\\)"]], h2 = { sup: "font-size:70%", sub: "font-size:70%", b: "font-weight:bold", i: "font-style:italic", a: "cursor:pointer", span: "", em: "font-style:italic;font-weight:bold" }, p2 = { sub: "0.3em", sup: "-0.6em" }, d2 = { sub: "-0.21em", sup: "0.42em" }, v2 = "​", g2 = ["http:", "https:", "mailto:", "", void 0, ":"], y2 = e3.NEWLINES = /(\r\n?|\n)/g, m2 = /(<[^<>]*>)/, x = /<(\/?)([^ >]*)(\s+(.*))?>/i, b2 = /<br(\s+.*)?>/i;
        e3.BR_TAG_ALL = /<br(\s+.*)?>/gi;
        var _ = /(^|[\s"'])style\s*=\s*("([^"]*);?"|'([^']*);?')/i, w2 = /(^|[\s"'])href\s*=\s*("([^"]*)"|'([^']*)')/i, T = /(^|[\s"'])target\s*=\s*("([^"\s]*)"|'([^'\s]*)')/i, k2 = /(^|[\s"'])popup\s*=\s*("([\w=,]*)"|'([\w=,]*)')/i;
        function A2(t3, e4) {
          if (!t3)
            return null;
          var r4 = t3.match(e4), n3 = r4 && (r4[3] || r4[4]);
          return n3 && L(n3);
        }
        var M = /(^|;)\s*color:/;
        e3.plainText = function(t3, e4) {
          for (var r4 = void 0 !== (e4 = e4 || {}).len && -1 !== e4.len ? e4.len : 1 / 0, n3 = void 0 !== e4.allowedTags ? e4.allowedTags : ["br"], i2 = t3.split(m2), a2 = [], o2 = "", s2 = 0, l3 = 0; l3 < i2.length; l3++) {
            var u3 = i2[l3], c3 = u3.match(x), f3 = c3 && c3[2].toLowerCase();
            if (f3)
              -1 !== n3.indexOf(f3) && (a2.push(u3), o2 = f3);
            else {
              var h3 = u3.length;
              if (s2 + h3 < r4)
                a2.push(u3), s2 += h3;
              else if (s2 < r4) {
                var p3 = r4 - s2;
                o2 && ("br" !== o2 || p3 <= 3 || h3 <= 3) && a2.pop(), r4 > 3 ? a2.push(u3.substr(0, p3 - 3) + "...") : a2.push(u3.substr(0, p3));
                break;
              }
              o2 = "";
            }
          }
          return a2.join("");
        };
        var S = { mu: "μ", amp: "&", lt: "<", gt: ">", nbsp: " ", times: "×", plusmn: "±", deg: "°" }, E2 = /&(#\d+|#x[\da-fA-F]+|[a-z]+);/g;
        function L(t3) {
          return t3.replace(E2, function(t4, e4) {
            return ("#" === e4.charAt(0) ? function(t5) {
              if (!(t5 > 1114111)) {
                var e5 = String.fromCodePoint;
                if (e5)
                  return e5(t5);
                var r4 = String.fromCharCode;
                return t5 <= 65535 ? r4(t5) : r4(55232 + (t5 >> 10), t5 % 1024 + 56320);
              }
            }("x" === e4.charAt(1) ? parseInt(e4.substr(2), 16) : parseInt(e4.substr(1), 10)) : S[e4]) || t4;
          });
        }
        function C2(t3) {
          var e4 = encodeURI(decodeURI(t3)), r4 = document.createElement("a"), n3 = document.createElement("a");
          r4.href = t3, n3.href = e4;
          var i2 = r4.protocol, a2 = n3.protocol;
          return -1 !== g2.indexOf(i2) && -1 !== g2.indexOf(a2) ? e4 : "";
        }
        function P(t3, e4, r4) {
          var n3, a2, o2, s2 = r4.horizontalAlign, l3 = r4.verticalAlign || "top", u3 = t3.node().getBoundingClientRect(), c3 = e4.node().getBoundingClientRect();
          return a2 = "bottom" === l3 ? function() {
            return u3.bottom - n3.height;
          } : "middle" === l3 ? function() {
            return u3.top + (u3.height - n3.height) / 2;
          } : function() {
            return u3.top;
          }, o2 = "right" === s2 ? function() {
            return u3.right - n3.width;
          } : "center" === s2 ? function() {
            return u3.left + (u3.width - n3.width) / 2;
          } : function() {
            return u3.left;
          }, function() {
            n3 = this.node().getBoundingClientRect();
            var t4 = o2() - c3.left, e5 = a2() - c3.top, s3 = r4.gd || {};
            if (r4.gd) {
              s3._fullLayout._calcInverseTransform(s3);
              var l4 = i.apply3DTransform(s3._fullLayout._invTransform)(t4, e5);
              t4 = l4[0], e5 = l4[1];
            }
            return this.style({ top: e5 + "px", left: t4 + "px", "z-index": 1e3 }), this;
          };
        }
        e3.convertEntities = L, e3.sanitizeHTML = function(t3) {
          t3 = t3.replace(y2, " ");
          for (var e4 = document.createElement("p"), r4 = e4, i2 = [], a2 = t3.split(m2), o2 = 0; o2 < a2.length; o2++) {
            var s2 = a2[o2], l3 = s2.match(x), u3 = l3 && l3[2].toLowerCase();
            if (u3 in h2)
              if (l3[1])
                i2.length && (r4 = i2.pop());
              else {
                var c3 = l3[4], f3 = A2(c3, _), p3 = f3 ? { style: f3 } : {};
                if ("a" === u3) {
                  var d3 = A2(c3, w2);
                  if (d3) {
                    var v3 = C2(d3);
                    if (v3) {
                      p3.href = v3;
                      var g3 = A2(c3, T);
                      g3 && (p3.target = g3);
                    }
                  }
                }
                var b3 = document.createElement(u3);
                r4.appendChild(b3), n2.select(b3).attr(p3), r4 = b3, i2.push(b3);
              }
            else
              r4.appendChild(document.createTextNode(L(s2)));
          }
          return e4.innerHTML;
        }, e3.lineCount = function(t3) {
          return t3.selectAll("tspan.line").size() || 1;
        }, e3.positionText = function(t3, e4, r4) {
          return t3.each(function() {
            var t4 = n2.select(this);
            function i2(e5, r5) {
              return void 0 === r5 ? null === (r5 = t4.attr(e5)) && (t4.attr(e5, 0), r5 = 0) : t4.attr(e5, r5), r5;
            }
            var a2 = i2("x", e4), o2 = i2("y", r4);
            "text" === this.nodeName && t4.selectAll("tspan.line").attr({ x: a2, y: o2 });
          });
        };
        var O = "1px ";
        e3.makeTextShadow = function(t3) {
          return O + O + O + t3 + ", -" + O + "-" + O + O + t3 + ", " + O + "-" + O + O + t3 + ", -" + O + O + O + t3;
        }, e3.makeEditable = function(t3, e4) {
          var r4 = e4.gd, i2 = e4.delegate, a2 = n2.dispatch("edit", "input", "cancel"), o2 = i2 || t3;
          if (t3.style({ "pointer-events": i2 ? "none" : "all" }), 1 !== t3.size())
            throw new Error("boo");
          function s2() {
            var i3, s3, u3, c3, f3;
            i3 = n2.select(r4).select(".svg-container"), s3 = i3.append("div"), u3 = t3.node().style, c3 = parseFloat(u3.fontSize || 12), void 0 === (f3 = e4.text) && (f3 = t3.attr("data-unformatted")), s3.classed("plugin-editable editable", true).style({ position: "absolute", "font-family": u3.fontFamily || "Arial", "font-size": c3, color: e4.fill || u3.fill || "black", opacity: 1, "background-color": e4.background || "transparent", outline: "#ffffff33 1px solid", margin: [-c3 / 8 + 1, 0, 0, -1].join("px ") + "px", padding: "0", "box-sizing": "border-box" }).attr({ contenteditable: true }).text(f3).call(P(t3, i3, e4)).on("blur", function() {
              r4._editing = false, t3.text(this.textContent).style({ opacity: 1 });
              var e5, i4 = n2.select(this).attr("class");
              (e5 = i4 ? "." + i4.split(" ")[0] + "-math-group" : "[class*=-math-group]") && n2.select(t3.node().parentNode).select(e5).style({ opacity: 0 });
              var o3 = this.textContent;
              n2.select(this).transition().duration(0).remove(), n2.select(document).on("mouseup", null), a2.edit.call(t3, o3);
            }).on("focus", function() {
              var t4 = this;
              r4._editing = true, n2.select(document).on("mouseup", function() {
                if (n2.event.target === t4)
                  return false;
                document.activeElement === s3.node() && s3.node().blur();
              });
            }).on("keyup", function() {
              27 === n2.event.which ? (r4._editing = false, t3.style({ opacity: 1 }), n2.select(this).style({ opacity: 0 }).on("blur", function() {
                return false;
              }).transition().remove(), a2.cancel.call(t3, this.textContent)) : (a2.input.call(t3, this.textContent), n2.select(this).call(P(t3, i3, e4)));
            }).on("keydown", function() {
              13 === n2.event.which && this.blur();
            }).call(l3), t3.style({ opacity: 0 });
            var h3, p3 = o2.attr("class");
            (h3 = p3 ? "." + p3.split(" ")[0] + "-math-group" : "[class*=-math-group]") && n2.select(t3.node().parentNode).select(h3).style({ opacity: 0 });
          }
          function l3(t4) {
            var e5 = t4.node(), r5 = document.createRange();
            r5.selectNodeContents(e5);
            var n3 = window.getSelection();
            n3.removeAllRanges(), n3.addRange(r5), e5.focus();
          }
          return e4.immediate ? s2() : o2.on("click", s2), n2.rebind(t3, a2, "on");
        };
      }, 91200: function(t2, e3) {
        var r3 = {};
        function n2(t3) {
          t3 && null !== t3.timer && (clearTimeout(t3.timer), t3.timer = null);
        }
        e3.throttle = function(t3, e4, i) {
          var a = r3[t3], o = Date.now();
          if (!a) {
            for (var s in r3)
              r3[s].ts < o - 6e4 && delete r3[s];
            a = r3[t3] = { ts: 0, timer: null };
          }
          function l2() {
            i(), a.ts = Date.now(), a.onDone && (a.onDone(), a.onDone = null);
          }
          n2(a), o > a.ts + e4 ? l2() : a.timer = setTimeout(function() {
            l2(), a.timer = null;
          }, e4);
        }, e3.done = function(t3) {
          var e4 = r3[t3];
          return e4 && e4.timer ? new Promise(function(t4) {
            var r4 = e4.onDone;
            e4.onDone = function() {
              r4 && r4(), t4(), e4.onDone = null;
            };
          }) : Promise.resolve();
        }, e3.clear = function(t3) {
          if (t3)
            n2(r3[t3]), delete r3[t3];
          else
            for (var i in r3)
              e3.clear(i);
        };
      }, 36896: function(t2, e3, r3) {
        var n2 = r3(38248);
        t2.exports = function(t3, e4) {
          if (t3 > 0)
            return Math.log(t3) / Math.LN10;
          var r4 = Math.log(Math.min(e4[0], e4[1])) / Math.LN10;
          return n2(r4) || (r4 = Math.log(Math.max(e4[0], e4[1])) / Math.LN10 - 6), r4;
        };
      }, 59972: function(t2, e3, r3) {
        var n2 = t2.exports = {}, i = r3(79552).locationmodeToLayer, a = r3(55712).NO;
        n2.getTopojsonName = function(t3) {
          return [t3.scope.replace(/ /g, "-"), "_", t3.resolution.toString(), "m"].join("");
        }, n2.getTopojsonPath = function(t3, e4) {
          return t3 + e4 + ".json";
        }, n2.getTopojsonFeatures = function(t3, e4) {
          var r4 = i[t3.locationmode], n3 = e4.objects[r4];
          return a(e4, n3).features;
        };
      }, 11680: function(t2) {
        t2.exports = { moduleType: "locale", name: "en-US", dictionary: { "Click to enter Colorscale title": "Click to enter Colorscale title" }, format: { date: "%m/%d/%Y" } };
      }, 6580: function(t2) {
        t2.exports = { moduleType: "locale", name: "en", dictionary: { "Click to enter Colorscale title": "Click to enter Colourscale title" }, format: { days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"], shortDays: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"], months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"], shortMonths: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"], periods: ["AM", "PM"], dateTime: "%a %b %e %X %Y", date: "%d/%m/%Y", time: "%H:%M:%S", decimal: ".", thousands: ",", grouping: [3], currency: ["$", ""], year: "%Y", month: "%b %Y", dayMonth: "%b %-d", dayMonthYear: "%b %-d, %Y" } };
      }, 69820: function(t2, e3, r3) {
        var n2 = r3(24040);
        t2.exports = function(t3) {
          for (var e4, r4, i = n2.layoutArrayContainers, a = n2.layoutArrayRegexes, o = t3.split("[")[0], s = 0; s < a.length; s++)
            if ((r4 = t3.match(a[s])) && 0 === r4.index) {
              e4 = r4[0];
              break;
            }
          if (e4 || (e4 = i[i.indexOf(o)]), !e4)
            return false;
          var l2 = t3.substr(e4.length);
          return l2 ? !!(r4 = l2.match(/^\[(0|[1-9][0-9]*)\](\.(.+))?$/)) && { array: e4, index: Number(r4[1]), property: r4[3] || "" } : { array: e4, index: "", property: "" };
        };
      }, 67824: function(t2, e3, r3) {
        var n2 = r3(92880).extendFlat, i = r3(63620), a = { valType: "flaglist", extras: ["none"], flags: ["calc", "clearAxisTypes", "plot", "style", "markerSize", "colorbars"] }, o = { valType: "flaglist", extras: ["none"], flags: ["calc", "plot", "legend", "ticks", "axrange", "layoutstyle", "modebar", "camera", "arraydraw", "colorbars"] }, s = a.flags.slice().concat(["fullReplot"]), l2 = o.flags.slice().concat("layoutReplot");
        function u2(t3) {
          for (var e4 = {}, r4 = 0; r4 < t3.length; r4++)
            e4[t3[r4]] = false;
          return e4;
        }
        function c2(t3, e4, r4) {
          var a2 = n2({}, t3);
          for (var o2 in a2) {
            var s2 = a2[o2];
            i(s2) && (a2[o2] = f2(s2, e4, 0, o2));
          }
          return "from-root" === r4 && (a2.editType = e4), a2;
        }
        function f2(t3, e4, r4, i2) {
          if (t3.valType) {
            var a2 = n2({}, t3);
            if (a2.editType = e4, Array.isArray(t3.items)) {
              a2.items = new Array(t3.items.length);
              for (var o2 = 0; o2 < t3.items.length; o2++)
                a2.items[o2] = f2(t3.items[o2], e4);
            }
            return a2;
          }
          return c2(t3, e4, "_" === i2.charAt(0) ? "nested" : "from-root");
        }
        t2.exports = { traces: a, layout: o, traceFlags: function() {
          return u2(s);
        }, layoutFlags: function() {
          return u2(l2);
        }, update: function(t3, e4) {
          var r4 = e4.editType;
          if (r4 && "none" !== r4)
            for (var n3 = r4.split("+"), i2 = 0; i2 < n3.length; i2++)
              t3[n3[i2]] = true;
        }, overrideAll: c2 };
      }, 93404: function(t2, e3, r3) {
        var n2 = r3(38248), i = r3(61784), a = r3(24040), o = r3(3400), s = r3(7316), l2 = r3(79811), u2 = r3(76308), c2 = l2.cleanId, f2 = l2.getFromTrace, h2 = a.traceIs;
        function p2(t3, e4) {
          var r4 = t3[e4], n3 = e4.charAt(0);
          r4 && "paper" !== r4 && (t3[e4] = c2(r4, n3, true));
        }
        function d2(t3) {
          function e4(e5, r4) {
            var n3 = t3[e5], i2 = t3.title && t3.title[r4];
            n3 && !i2 && (t3.title || (t3.title = {}), t3.title[r4] = t3[e5], delete t3[e5]);
          }
          t3 && ("string" != typeof t3.title && "number" != typeof t3.title || (t3.title = { text: t3.title }), e4("titlefont", "font"), e4("titleposition", "position"), e4("titleside", "side"), e4("titleoffset", "offset"));
        }
        function v2(t3) {
          if (!o.isPlainObject(t3))
            return false;
          var e4 = t3.name;
          return delete t3.name, delete t3.showlegend, ("string" == typeof e4 || "number" == typeof e4) && String(e4);
        }
        function g2(t3, e4, r4, n3) {
          if (r4 && !n3)
            return t3;
          if (n3 && !r4)
            return e4;
          if (!t3.trim())
            return e4;
          if (!e4.trim())
            return t3;
          var i2, a2 = Math.min(t3.length, e4.length);
          for (i2 = 0; i2 < a2 && t3.charAt(i2) === e4.charAt(i2); i2++)
            ;
          return t3.substr(0, i2).trim();
        }
        function y2(t3) {
          var e4 = "middle", r4 = "center";
          return "string" == typeof t3 && (-1 !== t3.indexOf("top") ? e4 = "top" : -1 !== t3.indexOf("bottom") && (e4 = "bottom"), -1 !== t3.indexOf("left") ? r4 = "left" : -1 !== t3.indexOf("right") && (r4 = "right")), e4 + " " + r4;
        }
        function m2(t3, e4) {
          return e4 in t3 && "object" == typeof t3[e4] && 0 === Object.keys(t3[e4]).length;
        }
        e3.clearPromiseQueue = function(t3) {
          Array.isArray(t3._promises) && t3._promises.length > 0 && o.log("Clearing previous rejected promises from queue."), t3._promises = [];
        }, e3.cleanLayout = function(t3) {
          var r4, n3;
          t3 || (t3 = {}), t3.xaxis1 && (t3.xaxis || (t3.xaxis = t3.xaxis1), delete t3.xaxis1), t3.yaxis1 && (t3.yaxis || (t3.yaxis = t3.yaxis1), delete t3.yaxis1), t3.scene1 && (t3.scene || (t3.scene = t3.scene1), delete t3.scene1);
          var a2 = (s.subplotsRegistry.cartesian || {}).attrRegex, l3 = (s.subplotsRegistry.polar || {}).attrRegex, f3 = (s.subplotsRegistry.ternary || {}).attrRegex, h3 = (s.subplotsRegistry.gl3d || {}).attrRegex, v3 = Object.keys(t3);
          for (r4 = 0; r4 < v3.length; r4++) {
            var g3 = v3[r4];
            if (a2 && a2.test(g3)) {
              var y3 = t3[g3];
              y3.anchor && "free" !== y3.anchor && (y3.anchor = c2(y3.anchor)), y3.overlaying && (y3.overlaying = c2(y3.overlaying)), y3.type || (y3.isdate ? y3.type = "date" : y3.islog ? y3.type = "log" : false === y3.isdate && false === y3.islog && (y3.type = "linear")), "withzero" !== y3.autorange && "tozero" !== y3.autorange || (y3.autorange = true, y3.rangemode = "tozero"), y3.insiderange && delete y3.range, delete y3.islog, delete y3.isdate, delete y3.categories, m2(y3, "domain") && delete y3.domain, void 0 !== y3.autotick && (void 0 === y3.tickmode && (y3.tickmode = y3.autotick ? "auto" : "linear"), delete y3.autotick), d2(y3);
            } else if (l3 && l3.test(g3))
              d2(t3[g3].radialaxis);
            else if (f3 && f3.test(g3)) {
              var x2 = t3[g3];
              d2(x2.aaxis), d2(x2.baxis), d2(x2.caxis);
            } else if (h3 && h3.test(g3)) {
              var b3 = t3[g3], _2 = b3.cameraposition;
              if (Array.isArray(_2) && 4 === _2[0].length) {
                var w2 = _2[0], T = _2[1], k2 = _2[2], A2 = i([], w2), M = [];
                for (n3 = 0; n3 < 3; ++n3)
                  M[n3] = T[n3] + k2 * A2[2 + 4 * n3];
                b3.camera = { eye: { x: M[0], y: M[1], z: M[2] }, center: { x: T[0], y: T[1], z: T[2] }, up: { x: 0, y: 0, z: 1 } }, delete b3.cameraposition;
              }
              d2(b3.xaxis), d2(b3.yaxis), d2(b3.zaxis);
            }
          }
          var S = Array.isArray(t3.annotations) ? t3.annotations.length : 0;
          for (r4 = 0; r4 < S; r4++) {
            var E2 = t3.annotations[r4];
            o.isPlainObject(E2) && (E2.ref && ("paper" === E2.ref ? (E2.xref = "paper", E2.yref = "paper") : "data" === E2.ref && (E2.xref = "x", E2.yref = "y"), delete E2.ref), p2(E2, "xref"), p2(E2, "yref"));
          }
          var L = Array.isArray(t3.shapes) ? t3.shapes.length : 0;
          for (r4 = 0; r4 < L; r4++) {
            var C2 = t3.shapes[r4];
            o.isPlainObject(C2) && (p2(C2, "xref"), p2(C2, "yref"));
          }
          var P = Array.isArray(t3.images) ? t3.images.length : 0;
          for (r4 = 0; r4 < P; r4++) {
            var O = t3.images[r4];
            o.isPlainObject(O) && (p2(O, "xref"), p2(O, "yref"));
          }
          var I2 = t3.legend;
          return I2 && (I2.x > 3 ? (I2.x = 1.02, I2.xanchor = "left") : I2.x < -2 && (I2.x = -0.02, I2.xanchor = "right"), I2.y > 3 ? (I2.y = 1.02, I2.yanchor = "bottom") : I2.y < -2 && (I2.y = -0.02, I2.yanchor = "top")), d2(t3), "rotate" === t3.dragmode && (t3.dragmode = "orbit"), u2.clean(t3), t3.template && t3.template.layout && e3.cleanLayout(t3.template.layout), t3;
        }, e3.cleanData = function(t3) {
          for (var r4 = 0; r4 < t3.length; r4++) {
            var n3, i2 = t3[r4];
            if ("histogramy" === i2.type && "xbins" in i2 && !("ybins" in i2) && (i2.ybins = i2.xbins, delete i2.xbins), i2.error_y && "opacity" in i2.error_y) {
              var l3 = u2.defaults, f3 = i2.error_y.color || (h2(i2, "bar") ? u2.defaultLine : l3[r4 % l3.length]);
              i2.error_y.color = u2.addOpacity(u2.rgb(f3), u2.opacity(f3) * i2.error_y.opacity), delete i2.error_y.opacity;
            }
            if ("bardir" in i2 && ("h" !== i2.bardir || !h2(i2, "bar") && "histogram" !== i2.type.substr(0, 9) || (i2.orientation = "h", e3.swapXYData(i2)), delete i2.bardir), "histogramy" === i2.type && e3.swapXYData(i2), "histogramx" !== i2.type && "histogramy" !== i2.type || (i2.type = "histogram"), "scl" in i2 && !("colorscale" in i2) && (i2.colorscale = i2.scl, delete i2.scl), "reversescl" in i2 && !("reversescale" in i2) && (i2.reversescale = i2.reversescl, delete i2.reversescl), i2.xaxis && (i2.xaxis = c2(i2.xaxis, "x")), i2.yaxis && (i2.yaxis = c2(i2.yaxis, "y")), h2(i2, "gl3d") && i2.scene && (i2.scene = s.subplotsRegistry.gl3d.cleanId(i2.scene)), !h2(i2, "pie-like") && !h2(i2, "bar-like"))
              if (Array.isArray(i2.textposition))
                for (n3 = 0; n3 < i2.textposition.length; n3++)
                  i2.textposition[n3] = y2(i2.textposition[n3]);
              else
                i2.textposition && (i2.textposition = y2(i2.textposition));
            var p3 = a.getModule(i2);
            if (p3 && p3.colorbar) {
              var x2 = p3.colorbar.container, b3 = x2 ? i2[x2] : i2;
              b3 && b3.colorscale && ("YIGnBu" === b3.colorscale && (b3.colorscale = "YlGnBu"), "YIOrRd" === b3.colorscale && (b3.colorscale = "YlOrRd"));
            }
            if ("surface" === i2.type && o.isPlainObject(i2.contours)) {
              var _2 = ["x", "y", "z"];
              for (n3 = 0; n3 < _2.length; n3++) {
                var w2 = i2.contours[_2[n3]];
                o.isPlainObject(w2) && (w2.highlightColor && (w2.highlightcolor = w2.highlightColor, delete w2.highlightColor), w2.highlightWidth && (w2.highlightwidth = w2.highlightWidth, delete w2.highlightWidth));
              }
            }
            if ("candlestick" === i2.type || "ohlc" === i2.type) {
              var T = false !== (i2.increasing || {}).showlegend, k2 = false !== (i2.decreasing || {}).showlegend, A2 = v2(i2.increasing), M = v2(i2.decreasing);
              if (false !== A2 && false !== M) {
                var S = g2(A2, M, T, k2);
                S && (i2.name = S);
              } else
                !A2 && !M || i2.name || (i2.name = A2 || M);
            }
            if (Array.isArray(i2.transforms)) {
              var E2 = i2.transforms;
              for (n3 = 0; n3 < E2.length; n3++) {
                var L = E2[n3];
                if (o.isPlainObject(L))
                  switch (L.type) {
                    case "filter":
                      L.filtersrc && (L.target = L.filtersrc, delete L.filtersrc), L.calendar && (L.valuecalendar || (L.valuecalendar = L.calendar), delete L.calendar);
                      break;
                    case "groupby":
                      if (L.styles = L.styles || L.style, L.styles && !Array.isArray(L.styles)) {
                        var C2 = L.styles, P = Object.keys(C2);
                        L.styles = [];
                        for (var O = 0; O < P.length; O++)
                          L.styles.push({ target: P[O], value: C2[P[O]] });
                      }
                  }
              }
            }
            m2(i2, "line") && delete i2.line, "marker" in i2 && (m2(i2.marker, "line") && delete i2.marker.line, m2(i2, "marker") && delete i2.marker), u2.clean(i2), i2.autobinx && (delete i2.autobinx, delete i2.xbins), i2.autobiny && (delete i2.autobiny, delete i2.ybins), d2(i2), i2.colorbar && d2(i2.colorbar), i2.marker && i2.marker.colorbar && d2(i2.marker.colorbar), i2.line && i2.line.colorbar && d2(i2.line.colorbar), i2.aaxis && d2(i2.aaxis), i2.baxis && d2(i2.baxis);
          }
        }, e3.swapXYData = function(t3) {
          var e4;
          if (o.swapAttrs(t3, ["?", "?0", "d?", "?bins", "nbins?", "autobin?", "?src", "error_?"]), Array.isArray(t3.z) && Array.isArray(t3.z[0]) && (t3.transpose ? delete t3.transpose : t3.transpose = true), t3.error_x && t3.error_y) {
            var r4 = t3.error_y, n3 = "copy_ystyle" in r4 ? r4.copy_ystyle : !(r4.color || r4.thickness || r4.width);
            o.swapAttrs(t3, ["error_?.copy_ystyle"]), n3 && o.swapAttrs(t3, ["error_?.color", "error_?.thickness", "error_?.width"]);
          }
          if ("string" == typeof t3.hoverinfo) {
            var i2 = t3.hoverinfo.split("+");
            for (e4 = 0; e4 < i2.length; e4++)
              "x" === i2[e4] ? i2[e4] = "y" : "y" === i2[e4] && (i2[e4] = "x");
            t3.hoverinfo = i2.join("+");
          }
        }, e3.coerceTraceIndices = function(t3, e4) {
          if (n2(e4))
            return [e4];
          if (!Array.isArray(e4) || !e4.length)
            return t3.data.map(function(t4, e5) {
              return e5;
            });
          if (Array.isArray(e4)) {
            for (var r4 = [], i2 = 0; i2 < e4.length; i2++)
              o.isIndex(e4[i2], t3.data.length) ? r4.push(e4[i2]) : o.warn("trace index (", e4[i2], ") is not a number or is out of bounds");
            return r4;
          }
          return e4;
        }, e3.manageArrayContainers = function(t3, e4, r4) {
          var i2 = t3.obj, a2 = t3.parts, s2 = a2.length, l3 = a2[s2 - 1], u3 = n2(l3);
          if (u3 && null === e4) {
            var c3 = a2.slice(0, s2 - 1).join(".");
            o.nestedProperty(i2, c3).get().splice(l3, 1);
          } else
            u3 && void 0 === t3.get() ? (void 0 === t3.get() && (r4[t3.astr] = null), t3.set(e4)) : t3.set(e4);
        };
        var x = /(\.[^\[\]\.]+|\[[^\[\]\.]+\])$/;
        function b2(t3) {
          var e4 = t3.search(x);
          if (e4 > 0)
            return t3.substr(0, e4);
        }
        e3.hasParent = function(t3, e4) {
          for (var r4 = b2(e4); r4; ) {
            if (r4 in t3)
              return true;
            r4 = b2(r4);
          }
          return false;
        };
        var _ = ["x", "y", "z"];
        e3.clearAxisTypes = function(t3, e4, r4) {
          for (var n3 = 0; n3 < e4.length; n3++)
            for (var i2 = t3._fullData[n3], a2 = 0; a2 < 3; a2++) {
              var s2 = f2(t3, i2, _[a2]);
              if (s2 && "log" !== s2.type) {
                var l3 = s2._name, u3 = s2._id.substr(1);
                if ("scene" === u3.substr(0, 5)) {
                  if (void 0 !== r4[u3])
                    continue;
                  l3 = u3 + "." + l3;
                }
                var c3 = l3 + ".type";
                void 0 === r4[l3] && void 0 === r4[c3] && o.nestedProperty(t3.layout, c3).set(null);
              }
            }
        };
      }, 22448: function(t2, e3, r3) {
        var n2 = r3(36424);
        e3._doPlot = n2._doPlot, e3.newPlot = n2.newPlot, e3.restyle = n2.restyle, e3.relayout = n2.relayout, e3.redraw = n2.redraw, e3.update = n2.update, e3._guiRestyle = n2._guiRestyle, e3._guiRelayout = n2._guiRelayout, e3._guiUpdate = n2._guiUpdate, e3._storeDirectGUIEdit = n2._storeDirectGUIEdit, e3.react = n2.react, e3.extendTraces = n2.extendTraces, e3.prependTraces = n2.prependTraces, e3.addTraces = n2.addTraces, e3.deleteTraces = n2.deleteTraces, e3.moveTraces = n2.moveTraces, e3.purge = n2.purge, e3.addFrames = n2.addFrames, e3.deleteFrames = n2.deleteFrames, e3.animate = n2.animate, e3.setPlotConfig = n2.setPlotConfig;
        var i = r3(52200).getGraphDiv, a = r3(4016).eraseActiveShape;
        e3.deleteActiveShape = function(t3) {
          return a(i(t3));
        }, e3.toImage = r3(67024), e3.validate = r3(21480), e3.downloadImage = r3(39792);
        var o = r3(94828);
        e3.makeTemplate = o.makeTemplate, e3.validateTemplate = o.validateTemplate;
      }, 17680: function(t2, e3, r3) {
        var n2 = r3(63620), i = r3(16628), a = r3(24248), o = r3(14952).sorterAsc, s = r3(24040);
        e3.containerArrayMatch = r3(69820);
        var l2 = e3.isAddVal = function(t3) {
          return "add" === t3 || n2(t3);
        }, u2 = e3.isRemoveVal = function(t3) {
          return null === t3 || "remove" === t3;
        };
        e3.applyContainerArrayChanges = function(t3, e4, r4, n3, c2) {
          var f2 = e4.astr, h2 = s.getComponentMethod(f2, "supplyLayoutDefaults"), p2 = s.getComponentMethod(f2, "draw"), d2 = s.getComponentMethod(f2, "drawOne"), v2 = n3.replot || n3.recalc || h2 === i || p2 === i, g2 = t3.layout, y2 = t3._fullLayout;
          if (r4[""]) {
            Object.keys(r4).length > 1 && a.warn("Full array edits are incompatible with other edits", f2);
            var m2 = r4[""][""];
            if (u2(m2))
              e4.set(null);
            else {
              if (!Array.isArray(m2))
                return a.warn("Unrecognized full array edit value", f2, m2), true;
              e4.set(m2);
            }
            return !v2 && (h2(g2, y2), p2(t3), true);
          }
          var x, b2, _, w2, T, k2, A2, M, S = Object.keys(r4).map(Number).sort(o), E2 = e4.get(), L = E2 || [], C2 = c2(y2, f2).get(), P = [], O = -1, I2 = L.length;
          for (x = 0; x < S.length; x++)
            if (w2 = r4[_ = S[x]], T = Object.keys(w2), k2 = w2[""], A2 = l2(k2), _ < 0 || _ > L.length - (A2 ? 0 : 1))
              a.warn("index out of range", f2, _);
            else if (void 0 !== k2)
              T.length > 1 && a.warn("Insertion & removal are incompatible with edits to the same index.", f2, _), u2(k2) ? P.push(_) : A2 ? ("add" === k2 && (k2 = {}), L.splice(_, 0, k2), C2 && C2.splice(_, 0, {})) : a.warn("Unrecognized full object edit value", f2, _, k2), -1 === O && (O = _);
            else
              for (b2 = 0; b2 < T.length; b2++)
                M = f2 + "[" + _ + "].", c2(L[_], T[b2], M).set(w2[T[b2]]);
          for (x = P.length - 1; x >= 0; x--)
            L.splice(P[x], 1), C2 && C2.splice(P[x], 1);
          if (L.length ? E2 || e4.set(L) : e4.set(null), v2)
            return false;
          if (h2(g2, y2), d2 !== i) {
            var D2;
            if (-1 === O)
              D2 = S;
            else {
              for (I2 = Math.max(L.length, I2), D2 = [], x = 0; x < S.length && !((_ = S[x]) >= O); x++)
                D2.push(_);
              for (x = O; x < I2; x++)
                D2.push(x);
            }
            for (x = 0; x < D2.length; x++)
              d2(t3, D2[x]);
          } else
            p2(t3);
          return true;
        };
      }, 36424: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(38248), a = r3(52264), o = r3(3400), s = o.nestedProperty, l2 = r3(95924), u2 = r3(94552), c2 = r3(24040), f2 = r3(73060), h2 = r3(7316), p2 = r3(54460), d2 = r3(96312), v2 = r3(94724), g2 = r3(43616), y2 = r3(76308), m2 = r3(42464).initInteractions, x = r3(9616), b2 = r3(22676).clearOutline, _ = r3(20556).dfltConfig, w2 = r3(17680), T = r3(93404), k2 = r3(39172), A2 = r3(67824), M = r3(33816).AX_NAME_PATTERN, S = 0;
        function E2(t3) {
          var e4 = t3._fullLayout;
          e4._redrawFromAutoMarginCount ? e4._redrawFromAutoMarginCount-- : t3.emit("plotly_afterplot");
        }
        function L(t3, e4) {
          try {
            t3._fullLayout._paper.style("background", e4);
          } catch (t4) {
            o.error(t4);
          }
        }
        function C2(t3, e4) {
          L(t3, y2.combine(e4, "white"));
        }
        function P(t3, e4) {
          if (!t3._context) {
            t3._context = o.extendDeep({}, _);
            var r4 = n2.select("base");
            t3._context._baseUrl = r4.size() && r4.attr("href") ? window.location.href.split("#")[0] : "";
          }
          var i2, s2, l3, u3 = t3._context;
          if (e4) {
            for (s2 = Object.keys(e4), i2 = 0; i2 < s2.length; i2++)
              "editable" !== (l3 = s2[i2]) && "edits" !== l3 && l3 in u3 && ("setBackground" === l3 && "opaque" === e4[l3] ? u3[l3] = C2 : u3[l3] = e4[l3]);
            e4.plot3dPixelRatio && !u3.plotGlPixelRatio && (u3.plotGlPixelRatio = u3.plot3dPixelRatio);
            var c3 = e4.editable;
            if (void 0 !== c3)
              for (u3.editable = c3, s2 = Object.keys(u3.edits), i2 = 0; i2 < s2.length; i2++)
                u3.edits[s2[i2]] = c3;
            if (e4.edits)
              for (s2 = Object.keys(e4.edits), i2 = 0; i2 < s2.length; i2++)
                (l3 = s2[i2]) in u3.edits && (u3.edits[l3] = e4.edits[l3]);
            u3._exportedPlot = e4._exportedPlot;
          }
          u3.staticPlot && (u3.editable = false, u3.edits = {}, u3.autosizable = false, u3.scrollZoom = false, u3.doubleClick = false, u3.showTips = false, u3.showLink = false, u3.displayModeBar = false), "hover" !== u3.displayModeBar || a || (u3.displayModeBar = true), "transparent" !== u3.setBackground && "function" == typeof u3.setBackground || (u3.setBackground = L), u3._hasZeroHeight = u3._hasZeroHeight || 0 === t3.clientHeight, u3._hasZeroWidth = u3._hasZeroWidth || 0 === t3.clientWidth;
          var f3 = u3.scrollZoom, h3 = u3._scrollZoom = {};
          if (true === f3)
            h3.cartesian = 1, h3.gl3d = 1, h3.geo = 1, h3.mapbox = 1;
          else if ("string" == typeof f3) {
            var p3 = f3.split("+");
            for (i2 = 0; i2 < p3.length; i2++)
              h3[p3[i2]] = 1;
          } else
            false !== f3 && (h3.gl3d = 1, h3.geo = 1, h3.mapbox = 1);
        }
        function O(t3, e4) {
          var r4, n3, i2 = e4 + 1, a2 = [];
          for (r4 = 0; r4 < t3.length; r4++)
            (n3 = t3[r4]) < 0 ? a2.push(i2 + n3) : a2.push(n3);
          return a2;
        }
        function I2(t3, e4, r4) {
          var n3, i2;
          for (n3 = 0; n3 < e4.length; n3++) {
            if ((i2 = e4[n3]) !== parseInt(i2, 10))
              throw new Error("all values in " + r4 + " must be integers");
            if (i2 >= t3.data.length || i2 < -t3.data.length)
              throw new Error(r4 + " must be valid indices for gd.data.");
            if (e4.indexOf(i2, n3 + 1) > -1 || i2 >= 0 && e4.indexOf(-t3.data.length + i2) > -1 || i2 < 0 && e4.indexOf(t3.data.length + i2) > -1)
              throw new Error("each index in " + r4 + " must be unique.");
          }
        }
        function D2(t3, e4, r4) {
          if (!Array.isArray(t3.data))
            throw new Error("gd.data must be an array.");
          if (void 0 === e4)
            throw new Error("currentIndices is a required argument.");
          if (Array.isArray(e4) || (e4 = [e4]), I2(t3, e4, "currentIndices"), void 0 === r4 || Array.isArray(r4) || (r4 = [r4]), void 0 !== r4 && I2(t3, r4, "newIndices"), void 0 !== r4 && e4.length !== r4.length)
            throw new Error("current and new indices must be of equal length.");
        }
        function z2(t3, e4, r4, n3, a2) {
          !function(t4, e5, r5, n4) {
            var i2 = o.isPlainObject(n4);
            if (!Array.isArray(t4.data))
              throw new Error("gd.data must be an array");
            if (!o.isPlainObject(e5))
              throw new Error("update must be a key:value object");
            if (void 0 === r5)
              throw new Error("indices must be an integer or array of integers");
            for (var a3 in I2(t4, r5, "indices"), e5) {
              if (!Array.isArray(e5[a3]) || e5[a3].length !== r5.length)
                throw new Error("attribute " + a3 + " must be an array of length equal to indices array length");
              if (i2 && (!(a3 in n4) || !Array.isArray(n4[a3]) || n4[a3].length !== e5[a3].length))
                throw new Error("when maxPoints is set as a key:value object it must contain a 1:1 corrispondence with the keys and number of traces in the update object");
            }
          }(t3, e4, r4, n3);
          for (var l3 = function(t4, e5, r5, n4) {
            var a3, l4, u4, c4, f4, h4 = o.isPlainObject(n4), p4 = [];
            for (var d4 in Array.isArray(r5) || (r5 = [r5]), r5 = O(r5, t4.data.length - 1), e5)
              for (var v3 = 0; v3 < r5.length; v3++) {
                if (a3 = t4.data[r5[v3]], l4 = (u4 = s(a3, d4)).get(), c4 = e5[d4][v3], !o.isArrayOrTypedArray(c4))
                  throw new Error("attribute: " + d4 + " index: " + v3 + " must be an array");
                if (!o.isArrayOrTypedArray(l4))
                  throw new Error("cannot extend missing or non-array attribute: " + d4);
                if (l4.constructor !== c4.constructor)
                  throw new Error("cannot extend array with an array of a different type: " + d4);
                f4 = h4 ? n4[d4][v3] : n4, i(f4) || (f4 = -1), p4.push({ prop: u4, target: l4, insert: c4, maxp: Math.floor(f4) });
              }
            return p4;
          }(t3, e4, r4, n3), u3 = {}, c3 = {}, f3 = 0; f3 < l3.length; f3++) {
            var h3 = l3[f3].prop, p3 = l3[f3].maxp, d3 = a2(l3[f3].target, l3[f3].insert, p3);
            h3.set(d3[0]), Array.isArray(u3[h3.astr]) || (u3[h3.astr] = []), u3[h3.astr].push(d3[1]), Array.isArray(c3[h3.astr]) || (c3[h3.astr] = []), c3[h3.astr].push(l3[f3].target.length);
          }
          return { update: u3, maxPoints: c3 };
        }
        function R(t3, e4) {
          var r4 = new t3.constructor(t3.length + e4.length);
          return r4.set(t3), r4.set(e4, t3.length), r4;
        }
        function F2(t3, r4, n3, i2) {
          t3 = o.getGraphDiv(t3), T.clearPromiseQueue(t3);
          var a2 = {};
          if ("string" == typeof r4)
            a2[r4] = n3;
          else {
            if (!o.isPlainObject(r4))
              return o.warn("Restyle fail.", r4, n3, i2), Promise.reject();
            a2 = o.extendFlat({}, r4), void 0 === i2 && (i2 = n3);
          }
          Object.keys(a2).length && (t3.changed = true);
          var s2 = T.coerceTraceIndices(t3, i2), l3 = U(t3, a2, s2), c3 = l3.flags;
          c3.calc && (t3.calcdata = void 0), c3.clearAxisTypes && T.clearAxisTypes(t3, s2, {});
          var f3 = [];
          c3.fullReplot ? f3.push(e3._doPlot) : (f3.push(h2.previousPromises), h2.supplyDefaults(t3), c3.markerSize && (h2.doCalcdata(t3), G2(f3)), c3.style && f3.push(k2.doTraceStyle), c3.colorbars && f3.push(k2.doColorBars), f3.push(E2)), f3.push(h2.rehover, h2.redrag, h2.reselect), u2.add(t3, F2, [t3, l3.undoit, l3.traces], F2, [t3, l3.redoit, l3.traces]);
          var p3 = o.syncOrAsync(f3, t3);
          return p3 && p3.then || (p3 = Promise.resolve()), p3.then(function() {
            return t3.emit("plotly_restyle", l3.eventData), t3;
          });
        }
        function B2(t3) {
          return void 0 === t3 ? null : t3;
        }
        function N(t3, e4) {
          return e4 ? function(e5, r4, n3) {
            var i2 = s(e5, r4), a2 = i2.set;
            return i2.set = function(e6) {
              j((n3 || "") + r4, i2.get(), e6, t3), a2(e6);
            }, i2;
          } : s;
        }
        function j(t3, e4, r4, n3) {
          if (Array.isArray(e4) || Array.isArray(r4))
            for (var i2 = Array.isArray(e4) ? e4 : [], a2 = Array.isArray(r4) ? r4 : [], s2 = Math.max(i2.length, a2.length), l3 = 0; l3 < s2; l3++)
              j(t3 + "[" + l3 + "]", i2[l3], a2[l3], n3);
          else if (o.isPlainObject(e4) || o.isPlainObject(r4)) {
            var u3 = o.isPlainObject(e4) ? e4 : {}, c3 = o.isPlainObject(r4) ? r4 : {}, f3 = o.extendFlat({}, u3, c3);
            for (var h3 in f3)
              j(t3 + "." + h3, u3[h3], c3[h3], n3);
          } else
            void 0 === n3[t3] && (n3[t3] = B2(e4));
        }
        function U(t3, e4, r4) {
          var n3, i2 = t3._fullLayout, a2 = t3._fullData, l3 = t3.data, u3 = i2._guiEditing, d3 = N(i2._preGUI, u3), v3 = o.extendDeepAll({}, e4);
          V(e4);
          var g3, y3 = A2.traceFlags(), m3 = {}, x2 = {};
          function b3() {
            return r4.map(function() {
            });
          }
          function _2(t4) {
            var e5 = p2.id2name(t4);
            -1 === g3.indexOf(e5) && g3.push(e5);
          }
          function w3(t4) {
            return "LAYOUT" + t4 + ".autorange";
          }
          function k3(t4) {
            return "LAYOUT" + t4 + ".range";
          }
          function M2(t4) {
            for (var e5 = t4; e5 < a2.length; e5++)
              if (a2[e5]._input === l3[t4])
                return a2[e5];
          }
          function S2(n4, a3, o2) {
            if (Array.isArray(n4))
              n4.forEach(function(t4) {
                S2(t4, a3, o2);
              });
            else if (!(n4 in e4) && !T.hasParent(e4, n4)) {
              var s2;
              if ("LAYOUT" === n4.substr(0, 6))
                s2 = d3(t3.layout, n4.replace("LAYOUT", ""));
              else {
                var c3 = r4[o2];
                s2 = N(i2._tracePreGUI[M2(c3)._fullInput.uid], u3)(l3[c3], n4);
              }
              n4 in x2 || (x2[n4] = b3()), void 0 === x2[n4][o2] && (x2[n4][o2] = B2(s2.get())), void 0 !== a3 && s2.set(a3);
            }
          }
          function E3(t4) {
            return function(e5) {
              return a2[e5][t4];
            };
          }
          function L2(t4) {
            return function(e5, n4) {
              return false === e5 ? a2[r4[n4]][t4] : null;
            };
          }
          for (var C3 in e4) {
            if (T.hasParent(e4, C3))
              throw new Error("cannot set " + C3 + " and a parent attribute simultaneously");
            var P2, O2, I3, D3, z3, R2, F3 = e4[C3];
            if ("autobinx" !== C3 && "autobiny" !== C3 || (C3 = C3.charAt(C3.length - 1) + "bins", F3 = Array.isArray(F3) ? F3.map(L2(C3)) : false === F3 ? r4.map(E3(C3)) : null), m3[C3] = F3, "LAYOUT" !== C3.substr(0, 6)) {
              for (x2[C3] = b3(), n3 = 0; n3 < r4.length; n3++)
                if (P2 = l3[r4[n3]], O2 = M2(r4[n3]), D3 = (I3 = N(i2._tracePreGUI[O2._fullInput.uid], u3)(P2, C3)).get(), void 0 !== (z3 = Array.isArray(F3) ? F3[n3 % F3.length] : F3)) {
                  var j2 = I3.parts[I3.parts.length - 1], U2 = C3.substr(0, C3.length - j2.length - 1), q3 = U2 ? U2 + "." : "", H3 = U2 ? s(O2, U2).get() : O2;
                  if ((R2 = f2.getTraceValObject(O2, I3.parts)) && R2.impliedEdits && null !== z3)
                    for (var G3 in R2.impliedEdits)
                      S2(o.relativeAttr(C3, G3), R2.impliedEdits[G3], n3);
                  else if ("thicknessmode" !== j2 && "lenmode" !== j2 || D3 === z3 || "fraction" !== z3 && "pixels" !== z3 || !H3) {
                    if ("type" === C3 && ("pie" === z3 != ("pie" === D3) || "funnelarea" === z3 != ("funnelarea" === D3))) {
                      var W2 = "x", Y2 = "y";
                      "bar" !== z3 && "bar" !== D3 || "h" !== P2.orientation || (W2 = "y", Y2 = "x"), o.swapAttrs(P2, ["?", "?src"], "labels", W2), o.swapAttrs(P2, ["d?", "?0"], "label", W2), o.swapAttrs(P2, ["?", "?src"], "values", Y2), "pie" === D3 || "funnelarea" === D3 ? (s(P2, "marker.color").set(s(P2, "marker.colors").get()), i2._pielayer.selectAll("g.trace").remove()) : c2.traceIs(P2, "cartesian") && s(P2, "marker.colors").set(s(P2, "marker.color").get());
                    }
                  } else {
                    var X2 = i2._size, Z2 = H3.orient, K2 = "top" === Z2 || "bottom" === Z2;
                    if ("thicknessmode" === j2) {
                      var J2 = K2 ? X2.h : X2.w;
                      S2(q3 + "thickness", H3.thickness * ("fraction" === z3 ? 1 / J2 : J2), n3);
                    } else {
                      var $2 = K2 ? X2.w : X2.h;
                      S2(q3 + "len", H3.len * ("fraction" === z3 ? 1 / $2 : $2), n3);
                    }
                  }
                  if (x2[C3][n3] = B2(D3), -1 !== ["swapxy", "swapxyaxes", "orientation", "orientationaxes"].indexOf(C3)) {
                    if ("orientation" === C3) {
                      I3.set(z3);
                      var Q2 = P2.x && !P2.y ? "h" : "v";
                      if ((I3.get() || Q2) === O2.orientation)
                        continue;
                    } else
                      "orientationaxes" === C3 && (P2.orientation = { v: "h", h: "v" }[O2.orientation]);
                    T.swapXYData(P2), y3.calc = y3.clearAxisTypes = true;
                  } else
                    -1 !== h2.dataArrayContainers.indexOf(I3.parts[0]) ? (T.manageArrayContainers(I3, z3, x2), y3.calc = true) : (R2 ? R2.arrayOk && !c2.traceIs(O2, "regl") && (o.isArrayOrTypedArray(z3) || o.isArrayOrTypedArray(D3)) ? y3.calc = true : A2.update(y3, R2) : y3.calc = true, I3.set(z3));
                }
              if (-1 !== ["swapxyaxes", "orientationaxes"].indexOf(C3) && p2.swap(t3, r4), "orientationaxes" === C3) {
                var tt3 = s(t3.layout, "hovermode"), et2 = tt3.get();
                "x" === et2 ? tt3.set("y") : "y" === et2 ? tt3.set("x") : "x unified" === et2 ? tt3.set("y unified") : "y unified" === et2 && tt3.set("x unified");
              }
              if (-1 !== ["orientation", "type"].indexOf(C3)) {
                for (g3 = [], n3 = 0; n3 < r4.length; n3++) {
                  var rt2 = l3[r4[n3]];
                  c2.traceIs(rt2, "cartesian") && (_2(rt2.xaxis || "x"), _2(rt2.yaxis || "y"));
                }
                S2(g3.map(w3), true, 0), S2(g3.map(k3), [0, 1], 0);
              }
            } else
              I3 = d3(t3.layout, C3.replace("LAYOUT", "")), x2[C3] = [B2(I3.get())], I3.set(Array.isArray(F3) ? F3[0] : F3), y3.calc = true;
          }
          return (y3.calc || y3.plot) && (y3.fullReplot = true), { flags: y3, undoit: x2, redoit: m3, traces: r4, eventData: o.extendDeepNoArrays([], [v3, r4]) };
        }
        function V(t3) {
          var e4, r4, n3, i2 = o.counterRegex("axis", ".title", false, false), a2 = /colorbar\.title$/, s2 = Object.keys(t3);
          for (e4 = 0; e4 < s2.length; e4++)
            r4 = s2[e4], n3 = t3[r4], "title" !== r4 && !i2.test(r4) && !a2.test(r4) || "string" != typeof n3 && "number" != typeof n3 ? r4.indexOf("titlefont") > -1 && -1 === r4.indexOf("grouptitlefont") ? l3(r4, r4.replace("titlefont", "title.font")) : r4.indexOf("titleposition") > -1 ? l3(r4, r4.replace("titleposition", "title.position")) : r4.indexOf("titleside") > -1 ? l3(r4, r4.replace("titleside", "title.side")) : r4.indexOf("titleoffset") > -1 && l3(r4, r4.replace("titleoffset", "title.offset")) : l3(r4, r4.replace("title", "title.text"));
          function l3(e5, r5) {
            t3[r5] = t3[e5], delete t3[e5];
          }
        }
        function q2(t3, e4, r4) {
          t3 = o.getGraphDiv(t3), T.clearPromiseQueue(t3);
          var n3 = {};
          if ("string" == typeof e4)
            n3[e4] = r4;
          else {
            if (!o.isPlainObject(e4))
              return o.warn("Relayout fail.", e4, r4), Promise.reject();
            n3 = o.extendFlat({}, e4);
          }
          Object.keys(n3).length && (t3.changed = true);
          var i2 = Z(t3, n3), a2 = i2.flags;
          a2.calc && (t3.calcdata = void 0);
          var s2 = [h2.previousPromises];
          a2.layoutReplot ? s2.push(k2.layoutReplot) : Object.keys(n3).length && (H2(t3, a2, i2) || h2.supplyDefaults(t3), a2.legend && s2.push(k2.doLegend), a2.layoutstyle && s2.push(k2.layoutStyles), a2.axrange && G2(s2, i2.rangesAltered), a2.ticks && s2.push(k2.doTicksRelayout), a2.modebar && s2.push(k2.doModeBar), a2.camera && s2.push(k2.doCamera), a2.colorbars && s2.push(k2.doColorBars), s2.push(E2)), s2.push(h2.rehover, h2.redrag, h2.reselect), u2.add(t3, q2, [t3, i2.undoit], q2, [t3, i2.redoit]);
          var l3 = o.syncOrAsync(s2, t3);
          return l3 && l3.then || (l3 = Promise.resolve(t3)), l3.then(function() {
            return t3.emit("plotly_relayout", i2.eventData), t3;
          });
        }
        function H2(t3, e4, r4) {
          var n3, i2, a2 = t3._fullLayout;
          if (!e4.axrange)
            return false;
          for (var s2 in e4)
            if ("axrange" !== s2 && e4[s2])
              return false;
          var l3 = function(t4, e5) {
            return o.coerce(n3, i2, v2, t4, e5);
          }, u3 = {};
          for (var c3 in r4.rangesAltered) {
            var f3 = p2.id2name(c3);
            if (n3 = t3.layout[f3], i2 = a2[f3], d2(n3, i2, l3, u3), i2._matchGroup) {
              for (var h3 in i2._matchGroup)
                if (h3 !== c3) {
                  var g3 = a2[p2.id2name(h3)];
                  g3.autorange = i2.autorange, g3.range = i2.range.slice(), g3._input.range = i2.range.slice();
                }
            }
          }
          return true;
        }
        function G2(t3, e4) {
          var r4 = e4 ? function(t4) {
            var r5 = [];
            for (var n3 in e4) {
              var i2 = p2.getFromId(t4, n3);
              if (r5.push(n3), -1 !== (i2.ticklabelposition || "").indexOf("inside") && i2._anchorAxis && r5.push(i2._anchorAxis._id), i2._matchGroup)
                for (var a2 in i2._matchGroup)
                  e4[a2] || r5.push(a2);
            }
            return p2.draw(t4, r5, { skipTitle: true });
          } : function(t4) {
            return p2.draw(t4, "redraw");
          };
          t3.push(b2, k2.doAutoRangeAndConstraints, r4, k2.drawData, k2.finalDraw);
        }
        var W = /^[xyz]axis[0-9]*\.range(\[[0|1]\])?$/, Y = /^[xyz]axis[0-9]*\.autorange$/, X = /^[xyz]axis[0-9]*\.domain(\[[0|1]\])?$/;
        function Z(t3, e4) {
          var r4, n3, i2, a2 = t3.layout, l3 = t3._fullLayout, u3 = l3._guiEditing, h3 = N(l3._preGUI, u3), d3 = Object.keys(e4), v3 = p2.list(t3), g3 = o.extendDeepAll({}, e4), y3 = {};
          for (V(e4), d3 = Object.keys(e4), n3 = 0; n3 < d3.length; n3++)
            if (0 === d3[n3].indexOf("allaxes")) {
              for (i2 = 0; i2 < v3.length; i2++) {
                var m3 = v3[i2]._id.substr(1), x2 = -1 !== m3.indexOf("scene") ? m3 + "." : "", b3 = d3[n3].replace("allaxes", x2 + v3[i2]._name);
                e4[b3] || (e4[b3] = e4[d3[n3]]);
              }
              delete e4[d3[n3]];
            }
          var _2 = A2.layoutFlags(), k3 = {}, S2 = {};
          function E3(t4, r5) {
            if (Array.isArray(t4))
              t4.forEach(function(t5) {
                E3(t5, r5);
              });
            else if (!(t4 in e4) && !T.hasParent(e4, t4)) {
              var n4 = h3(a2, t4);
              t4 in S2 || (S2[t4] = B2(n4.get())), void 0 !== r5 && n4.set(r5);
            }
          }
          var L2, C3 = {};
          function P2(t4) {
            var e5 = p2.name2id(t4.split(".")[0]);
            return C3[e5] = 1, e5;
          }
          for (var O2 in e4) {
            if (T.hasParent(e4, O2))
              throw new Error("cannot set " + O2 + " and a parent attribute simultaneously");
            for (var I3 = h3(a2, O2), D3 = e4[O2], z3 = I3.parts.length - 1; z3 > 0 && "string" != typeof I3.parts[z3]; )
              z3--;
            var R2 = I3.parts[z3], F3 = I3.parts[z3 - 1] + "." + R2, j2 = I3.parts.slice(0, z3).join("."), U2 = s(t3.layout, j2).get(), q3 = s(l3, j2).get(), H3 = I3.get();
            if (void 0 !== D3) {
              k3[O2] = D3, S2[O2] = "reverse" === R2 ? D3 : B2(H3);
              var G3 = f2.getLayoutValObject(l3, I3.parts);
              if (G3 && G3.impliedEdits && null !== D3)
                for (var Z2 in G3.impliedEdits)
                  E3(o.relativeAttr(O2, Z2), G3.impliedEdits[Z2]);
              if (-1 !== ["width", "height"].indexOf(O2))
                if (D3) {
                  E3("autosize", null);
                  var J2 = "height" === O2 ? "width" : "height";
                  E3(J2, l3[J2]);
                } else
                  l3[O2] = t3._initialAutoSize[O2];
              else if ("autosize" === O2)
                E3("width", D3 ? null : l3.width), E3("height", D3 ? null : l3.height);
              else if (F3.match(W))
                P2(F3), s(l3, j2 + "._inputRange").set(null);
              else if (F3.match(Y)) {
                P2(F3), s(l3, j2 + "._inputRange").set(null);
                var $2 = s(l3, j2).get();
                $2._inputDomain && ($2._input.domain = $2._inputDomain.slice());
              } else
                F3.match(X) && s(l3, j2 + "._inputDomain").set(null);
              if ("type" === R2) {
                L2 = U2;
                var Q2 = "linear" === q3.type && "log" === D3, tt3 = "log" === q3.type && "linear" === D3;
                if (Q2 || tt3) {
                  if (L2 && L2.range)
                    if (q3.autorange)
                      Q2 && (L2.range = L2.range[1] > L2.range[0] ? [1, 2] : [2, 1]);
                    else {
                      var et2 = L2.range[0], rt2 = L2.range[1];
                      Q2 ? (et2 <= 0 && rt2 <= 0 && E3(j2 + ".autorange", true), et2 <= 0 ? et2 = rt2 / 1e6 : rt2 <= 0 && (rt2 = et2 / 1e6), E3(j2 + ".range[0]", Math.log(et2) / Math.LN10), E3(j2 + ".range[1]", Math.log(rt2) / Math.LN10)) : (E3(j2 + ".range[0]", Math.pow(10, et2)), E3(j2 + ".range[1]", Math.pow(10, rt2)));
                    }
                  else
                    E3(j2 + ".autorange", true);
                  Array.isArray(l3._subplots.polar) && l3._subplots.polar.length && l3[I3.parts[0]] && "radialaxis" === I3.parts[1] && delete l3[I3.parts[0]]._subplot.viewInitial["radialaxis.range"], c2.getComponentMethod("annotations", "convertCoords")(t3, q3, D3, E3), c2.getComponentMethod("images", "convertCoords")(t3, q3, D3, E3);
                } else
                  E3(j2 + ".autorange", true), E3(j2 + ".range", null);
                s(l3, j2 + "._inputRange").set(null);
              } else if (R2.match(M)) {
                var nt2 = s(l3, O2).get(), it2 = (D3 || {}).type;
                it2 && "-" !== it2 || (it2 = "linear"), c2.getComponentMethod("annotations", "convertCoords")(t3, nt2, it2, E3), c2.getComponentMethod("images", "convertCoords")(t3, nt2, it2, E3);
              }
              var at2 = w2.containerArrayMatch(O2);
              if (at2) {
                r4 = at2.array, n3 = at2.index;
                var ot2 = at2.property, st2 = G3 || { editType: "calc" };
                "" !== n3 && "" === ot2 && (w2.isAddVal(D3) ? S2[O2] = null : w2.isRemoveVal(D3) ? S2[O2] = (s(a2, r4).get() || [])[n3] : o.warn("unrecognized full object value", e4)), A2.update(_2, st2), y3[r4] || (y3[r4] = {});
                var lt2 = y3[r4][n3];
                lt2 || (lt2 = y3[r4][n3] = {}), lt2[ot2] = D3, delete e4[O2];
              } else
                "reverse" === R2 ? (U2.range ? U2.range.reverse() : (E3(j2 + ".autorange", true), U2.range = [1, 0]), q3.autorange ? _2.calc = true : _2.plot = true) : ("dragmode" === O2 && (false === D3 && false !== H3 || false !== D3 && false === H3) || l3._has("scatter-like") && l3._has("regl") && "dragmode" === O2 && ("lasso" === D3 || "select" === D3) && "lasso" !== H3 && "select" !== H3 || l3._has("gl2d") ? _2.plot = true : G3 ? A2.update(_2, G3) : _2.calc = true, I3.set(D3));
            }
          }
          for (r4 in y3)
            w2.applyContainerArrayChanges(t3, h3(a2, r4), y3[r4], _2, h3) || (_2.plot = true);
          for (var ut in C3) {
            var ct = (L2 = p2.getFromId(t3, ut)) && L2._constraintGroup;
            if (ct)
              for (var ft in _2.calc = true, ct)
                C3[ft] || (p2.getFromId(t3, ft)._constraintShrinkable = true);
          }
          (K(t3) || e4.height || e4.width) && (_2.plot = true);
          var ht = l3.shapes;
          for (n3 = 0; n3 < ht.length; n3++)
            if (ht[n3].showlegend) {
              _2.calc = true;
              break;
            }
          return (_2.plot || _2.calc) && (_2.layoutReplot = true), { flags: _2, rangesAltered: C3, undoit: S2, redoit: k3, eventData: g3 };
        }
        function K(t3) {
          var e4 = t3._fullLayout, r4 = e4.width, n3 = e4.height;
          return t3.layout.autosize && h2.plotAutoSize(t3, t3.layout, e4), e4.width !== r4 || e4.height !== n3;
        }
        function J(t3, r4, n3, i2) {
          t3 = o.getGraphDiv(t3), T.clearPromiseQueue(t3), o.isPlainObject(r4) || (r4 = {}), o.isPlainObject(n3) || (n3 = {}), Object.keys(r4).length && (t3.changed = true), Object.keys(n3).length && (t3.changed = true);
          var a2 = T.coerceTraceIndices(t3, i2), s2 = U(t3, o.extendFlat({}, r4), a2), l3 = s2.flags, c3 = Z(t3, o.extendFlat({}, n3)), f3 = c3.flags;
          (l3.calc || f3.calc) && (t3.calcdata = void 0), l3.clearAxisTypes && T.clearAxisTypes(t3, a2, n3);
          var p3 = [];
          f3.layoutReplot ? p3.push(k2.layoutReplot) : l3.fullReplot ? p3.push(e3._doPlot) : (p3.push(h2.previousPromises), H2(t3, f3, c3) || h2.supplyDefaults(t3), l3.style && p3.push(k2.doTraceStyle), (l3.colorbars || f3.colorbars) && p3.push(k2.doColorBars), f3.legend && p3.push(k2.doLegend), f3.layoutstyle && p3.push(k2.layoutStyles), f3.axrange && G2(p3, c3.rangesAltered), f3.ticks && p3.push(k2.doTicksRelayout), f3.modebar && p3.push(k2.doModeBar), f3.camera && p3.push(k2.doCamera), p3.push(E2)), p3.push(h2.rehover, h2.redrag, h2.reselect), u2.add(t3, J, [t3, s2.undoit, c3.undoit, s2.traces], J, [t3, s2.redoit, c3.redoit, s2.traces]);
          var d3 = o.syncOrAsync(p3, t3);
          return d3 && d3.then || (d3 = Promise.resolve(t3)), d3.then(function() {
            return t3.emit("plotly_update", { data: s2.eventData, layout: c3.eventData }), t3;
          });
        }
        function $(t3) {
          return function(e4) {
            e4._fullLayout._guiEditing = true;
            var r4 = t3.apply(null, arguments);
            return e4._fullLayout._guiEditing = false, r4;
          };
        }
        var Q = [{ pattern: /^hiddenlabels/, attr: "legend.uirevision" }, { pattern: /^((x|y)axis\d*)\.((auto)?range|title\.text)/ }, { pattern: /axis\d*\.showspikes$/, attr: "modebar.uirevision" }, { pattern: /(hover|drag)mode$/, attr: "modebar.uirevision" }, { pattern: /^(scene\d*)\.camera/ }, { pattern: /^(geo\d*)\.(projection|center|fitbounds)/ }, { pattern: /^(ternary\d*\.[abc]axis)\.(min|title\.text)$/ }, { pattern: /^(polar\d*\.radialaxis)\.((auto)?range|angle|title\.text)/ }, { pattern: /^(polar\d*\.angularaxis)\.rotation/ }, { pattern: /^(mapbox\d*)\.(center|zoom|bearing|pitch)/ }, { pattern: /^legend\.(x|y)$/, attr: "editrevision" }, { pattern: /^(shapes|annotations)/, attr: "editrevision" }, { pattern: /^title\.text$/, attr: "editrevision" }], tt2 = [{ pattern: /^selectedpoints$/, attr: "selectionrevision" }, { pattern: /(^|value\.)visible$/, attr: "legend.uirevision" }, { pattern: /^dimensions\[\d+\]\.constraintrange/ }, { pattern: /^node\.(x|y|groups)/ }, { pattern: /^level$/ }, { pattern: /(^|value\.)name$/ }, { pattern: /colorbar\.title\.text$/ }, { pattern: /colorbar\.(x|y)$/, attr: "editrevision" }];
        function et(t3, e4) {
          for (var r4 = 0; r4 < e4.length; r4++) {
            var n3 = e4[r4], i2 = t3.match(n3.pattern);
            if (i2) {
              var a2 = i2[1] || "";
              return { head: a2, tail: t3.substr(a2.length + 1), attr: n3.attr };
            }
          }
        }
        function rt(t3, e4) {
          var r4 = s(e4, t3).get();
          if (void 0 !== r4)
            return r4;
          var n3 = t3.split(".");
          for (n3.pop(); n3.length > 1; )
            if (n3.pop(), void 0 !== (r4 = s(e4, n3.join(".") + ".uirevision").get()))
              return r4;
          return e4.uirevision;
        }
        function nt(t3, e4) {
          for (var r4 = 0; r4 < e4.length; r4++)
            if (e4[r4]._fullInput.uid === t3)
              return r4;
          return -1;
        }
        function it(t3, e4, r4) {
          for (var n3 = 0; n3 < e4.length; n3++)
            if (e4[n3].uid === t3)
              return n3;
          return !e4[r4] || e4[r4].uid ? -1 : r4;
        }
        function at(t3, e4) {
          var r4 = o.isPlainObject(t3), n3 = Array.isArray(t3);
          return r4 || n3 ? (r4 && o.isPlainObject(e4) || n3 && Array.isArray(e4)) && JSON.stringify(t3) === JSON.stringify(e4) : t3 === e4;
        }
        function ot(t3, e4, r4, n3) {
          var i2, a2, l3, u3 = n3.getValObject, c3 = n3.flags, f3 = n3.immutable, h3 = n3.inArray, p3 = n3.arrayIndex;
          function d3() {
            var t4 = i2.editType;
            h3 && -1 !== t4.indexOf("arraydraw") ? o.pushUnique(c3.arrays[h3], p3) : (A2.update(c3, i2), "none" !== t4 && c3.nChanges++, n3.transition && i2.anim && c3.nChangesAnim++, (W.test(l3) || Y.test(l3)) && (c3.rangesAltered[r4[0]] = 1), X.test(l3) && s(e4, "_inputDomain").set(null), "datarevision" === a2 && (c3.newDataRevision = 1));
          }
          function v3(t4) {
            return "data_array" === t4.valType || t4.arrayOk;
          }
          for (a2 in t3) {
            if (c3.calc && !n3.transition)
              return;
            var g3 = t3[a2], y3 = e4[a2], m3 = r4.concat(a2);
            if (l3 = m3.join("."), "_" !== a2.charAt(0) && "function" != typeof g3 && g3 !== y3) {
              if (("tick0" === a2 || "dtick" === a2) && "geo" !== r4[0]) {
                var x2 = e4.tickmode;
                if ("auto" === x2 || "array" === x2 || !x2)
                  continue;
              }
              if (("range" !== a2 || !e4.autorange) && ("zmin" !== a2 && "zmax" !== a2 || "contourcarpet" !== e4.type) && (i2 = u3(m3)) && (!i2._compareAsJSON || JSON.stringify(g3) !== JSON.stringify(y3))) {
                var b3, _2 = i2.valType, w3 = v3(i2), T2 = Array.isArray(g3), k3 = Array.isArray(y3);
                if (T2 && k3) {
                  var M2 = "_input_" + a2, S2 = t3[M2], E3 = e4[M2];
                  if (Array.isArray(S2) && S2 === E3)
                    continue;
                }
                if (void 0 === y3)
                  w3 && T2 ? c3.calc = true : d3();
                else if (i2._isLinkedToArray) {
                  var L2 = [], C3 = false;
                  h3 || (c3.arrays[a2] = L2);
                  var P2 = Math.min(g3.length, y3.length), O2 = Math.max(g3.length, y3.length);
                  if (P2 !== O2) {
                    if ("arraydraw" !== i2.editType) {
                      d3();
                      continue;
                    }
                    C3 = true;
                  }
                  for (b3 = 0; b3 < P2; b3++)
                    ot(g3[b3], y3[b3], m3.concat(b3), o.extendFlat({ inArray: a2, arrayIndex: b3 }, n3));
                  if (C3)
                    for (b3 = P2; b3 < O2; b3++)
                      L2.push(b3);
                } else
                  !_2 && o.isPlainObject(g3) ? ot(g3, y3, m3, n3) : w3 ? T2 && k3 ? (f3 && (c3.calc = true), (f3 || n3.newDataRevision) && d3()) : T2 !== k3 ? c3.calc = true : d3() : T2 && k3 && g3.length === y3.length && String(g3) === String(y3) || d3();
              }
            }
          }
          for (a2 in e4)
            if (!(a2 in t3) && "_" !== a2.charAt(0) && "function" != typeof e4[a2]) {
              if (v3(i2 = u3(r4.concat(a2))) && Array.isArray(e4[a2]))
                return void (c3.calc = true);
              d3();
            }
        }
        function st(t3, e4) {
          var r4;
          for (r4 in t3)
            if ("_" !== r4.charAt(0)) {
              var n3 = t3[r4], i2 = e4[r4];
              if (n3 !== i2)
                if (o.isPlainObject(n3) && o.isPlainObject(i2)) {
                  if (st(n3, i2))
                    return true;
                } else {
                  if (!Array.isArray(n3) || !Array.isArray(i2))
                    return true;
                  if (n3.length !== i2.length)
                    return true;
                  for (var a2 = 0; a2 < n3.length; a2++)
                    if (n3[a2] !== i2[a2]) {
                      if (!o.isPlainObject(n3[a2]) || !o.isPlainObject(i2[a2]))
                        return true;
                      if (st(n3[a2], i2[a2]))
                        return true;
                    }
                }
            }
        }
        function lt(t3) {
          var e4 = t3._fullLayout, r4 = t3.getBoundingClientRect();
          if (!o.equalDomRects(r4, e4._lastBBox)) {
            var n3 = e4._invTransform = o.inverseTransformMatrix(o.getFullTransformMatrix(t3));
            e4._invScaleX = Math.sqrt(n3[0][0] * n3[0][0] + n3[0][1] * n3[0][1] + n3[0][2] * n3[0][2]), e4._invScaleY = Math.sqrt(n3[1][0] * n3[1][0] + n3[1][1] * n3[1][1] + n3[1][2] * n3[1][2]), e4._lastBBox = r4;
          }
        }
        e3.animate = function(t3, e4, r4) {
          if (t3 = o.getGraphDiv(t3), !o.isPlotDiv(t3))
            throw new Error("This element is not a Plotly plot: " + t3 + ". It's likely that you've failed to create a plot before animating it. For more details, see https://plotly.com/javascript/animations/");
          var n3 = t3._transitionData;
          n3._frameQueue || (n3._frameQueue = []);
          var i2 = (r4 = h2.supplyAnimationDefaults(r4)).transition, a2 = r4.frame;
          function s2(t4) {
            return Array.isArray(i2) ? t4 >= i2.length ? i2[0] : i2[t4] : i2;
          }
          function l3(t4) {
            return Array.isArray(a2) ? t4 >= a2.length ? a2[0] : a2[t4] : a2;
          }
          function u3(t4, e5) {
            var r5 = 0;
            return function() {
              if (t4 && ++r5 === e5)
                return t4();
            };
          }
          return void 0 === n3._frameWaitingCnt && (n3._frameWaitingCnt = 0), new Promise(function(a3, c3) {
            function f3() {
              t3.emit("plotly_animating"), n3._lastFrameAt = -1 / 0, n3._timeToNext = 0, n3._runningTransitions = 0, n3._currentFrame = null;
              var e5 = function() {
                n3._animationRaf = window.requestAnimationFrame(e5), Date.now() - n3._lastFrameAt > n3._timeToNext && function() {
                  n3._currentFrame && n3._currentFrame.onComplete && n3._currentFrame.onComplete();
                  var e6 = n3._currentFrame = n3._frameQueue.shift();
                  if (e6) {
                    var r5 = e6.name ? e6.name.toString() : null;
                    t3._fullLayout._currentFrame = r5, n3._lastFrameAt = Date.now(), n3._timeToNext = e6.frameOpts.duration, h2.transition(t3, e6.frame.data, e6.frame.layout, T.coerceTraceIndices(t3, e6.frame.traces), e6.frameOpts, e6.transitionOpts).then(function() {
                      e6.onComplete && e6.onComplete();
                    }), t3.emit("plotly_animatingframe", { name: r5, frame: e6.frame, animation: { frame: e6.frameOpts, transition: e6.transitionOpts } });
                  } else
                    t3.emit("plotly_animated"), window.cancelAnimationFrame(n3._animationRaf), n3._animationRaf = null;
                }();
              };
              e5();
            }
            var p3, d3, v3 = 0;
            function g3(t4) {
              return Array.isArray(i2) ? v3 >= i2.length ? t4.transitionOpts = i2[v3] : t4.transitionOpts = i2[0] : t4.transitionOpts = i2, v3++, t4;
            }
            var y3 = [], m3 = null == e4, x2 = Array.isArray(e4);
            if (m3 || x2 || !o.isPlainObject(e4)) {
              if (m3 || -1 !== ["string", "number"].indexOf(typeof e4))
                for (p3 = 0; p3 < n3._frames.length; p3++)
                  (d3 = n3._frames[p3]) && (m3 || String(d3.group) === String(e4)) && y3.push({ type: "byname", name: String(d3.name), data: g3({ name: d3.name }) });
              else if (x2)
                for (p3 = 0; p3 < e4.length; p3++) {
                  var b3 = e4[p3];
                  -1 !== ["number", "string"].indexOf(typeof b3) ? (b3 = String(b3), y3.push({ type: "byname", name: b3, data: g3({ name: b3 }) })) : o.isPlainObject(b3) && y3.push({ type: "object", data: g3(o.extendFlat({}, b3)) });
                }
            } else
              y3.push({ type: "object", data: g3(o.extendFlat({}, e4)) });
            for (p3 = 0; p3 < y3.length; p3++)
              if ("byname" === (d3 = y3[p3]).type && !n3._frameHash[d3.data.name])
                return o.warn('animate failure: frame not found: "' + d3.data.name + '"'), void c3();
            -1 !== ["next", "immediate"].indexOf(r4.mode) && function() {
              if (0 !== n3._frameQueue.length) {
                for (; n3._frameQueue.length; ) {
                  var e5 = n3._frameQueue.pop();
                  e5.onInterrupt && e5.onInterrupt();
                }
                t3.emit("plotly_animationinterrupted", []);
              }
            }(), "reverse" === r4.direction && y3.reverse();
            var _2 = t3._fullLayout._currentFrame;
            if (_2 && r4.fromcurrent) {
              var w3 = -1;
              for (p3 = 0; p3 < y3.length; p3++)
                if ("byname" === (d3 = y3[p3]).type && d3.name === _2) {
                  w3 = p3;
                  break;
                }
              if (w3 > 0 && w3 < y3.length - 1) {
                var k3 = [];
                for (p3 = 0; p3 < y3.length; p3++)
                  d3 = y3[p3], ("byname" !== y3[p3].type || p3 > w3) && k3.push(d3);
                y3 = k3;
              }
            }
            y3.length > 0 ? function(e5) {
              if (0 !== e5.length) {
                for (var i3 = 0; i3 < e5.length; i3++) {
                  var o2;
                  o2 = "byname" === e5[i3].type ? h2.computeFrame(t3, e5[i3].name) : e5[i3].data;
                  var p4 = l3(i3), d4 = s2(i3);
                  d4.duration = Math.min(d4.duration, p4.duration);
                  var v4 = { frame: o2, name: e5[i3].name, frameOpts: p4, transitionOpts: d4 };
                  i3 === e5.length - 1 && (v4.onComplete = u3(a3, 2), v4.onInterrupt = c3), n3._frameQueue.push(v4);
                }
                "immediate" === r4.mode && (n3._lastFrameAt = -1 / 0), n3._animationRaf || f3();
              }
            }(y3) : (t3.emit("plotly_animated"), a3());
          });
        }, e3.addFrames = function(t3, e4, r4) {
          if (t3 = o.getGraphDiv(t3), null == e4)
            return Promise.resolve();
          if (!o.isPlotDiv(t3))
            throw new Error("This element is not a Plotly plot: " + t3 + ". It's likely that you've failed to create a plot before adding frames. For more details, see https://plotly.com/javascript/animations/");
          var n3, i2, a2, s2, l3 = t3._transitionData._frames, c3 = t3._transitionData._frameHash;
          if (!Array.isArray(e4))
            throw new Error("addFrames failure: frameList must be an Array of frame definitions" + e4);
          var f3 = l3.length + 2 * e4.length, p3 = [], d3 = {};
          for (n3 = e4.length - 1; n3 >= 0; n3--)
            if (o.isPlainObject(e4[n3])) {
              var v3 = e4[n3].name, g3 = (c3[v3] || d3[v3] || {}).name, y3 = e4[n3].name, m3 = c3[g3] || d3[g3];
              g3 && y3 && "number" == typeof y3 && m3 && S < 5 && (S++, o.warn('addFrames: overwriting frame "' + (c3[g3] || d3[g3]).name + '" with a frame whose name of type "number" also equates to "' + g3 + '". This is valid but may potentially lead to unexpected behavior since all plotly.js frame names are stored internally as strings.'), 5 === S && o.warn("addFrames: This API call has yielded too many of these warnings. For the rest of this call, further warnings about numeric frame names will be suppressed.")), d3[v3] = { name: v3 }, p3.push({ frame: h2.supplyFrameDefaults(e4[n3]), index: r4 && void 0 !== r4[n3] && null !== r4[n3] ? r4[n3] : f3 + n3 });
            }
          p3.sort(function(t4, e5) {
            return t4.index > e5.index ? -1 : t4.index < e5.index ? 1 : 0;
          });
          var x2 = [], b3 = [], _2 = l3.length;
          for (n3 = p3.length - 1; n3 >= 0; n3--) {
            if ("number" == typeof (i2 = p3[n3].frame).name && o.warn("Warning: addFrames accepts frames with numeric names, but the numbers areimplicitly cast to strings"), !i2.name)
              for (; c3[i2.name = "frame " + t3._transitionData._counter++]; )
                ;
            if (c3[i2.name]) {
              for (a2 = 0; a2 < l3.length && (l3[a2] || {}).name !== i2.name; a2++)
                ;
              x2.push({ type: "replace", index: a2, value: i2 }), b3.unshift({ type: "replace", index: a2, value: l3[a2] });
            } else
              s2 = Math.max(0, Math.min(p3[n3].index, _2)), x2.push({ type: "insert", index: s2, value: i2 }), b3.unshift({ type: "delete", index: s2 }), _2++;
          }
          var w3 = h2.modifyFrames, T2 = h2.modifyFrames, k3 = [t3, b3], A3 = [t3, x2];
          return u2 && u2.add(t3, w3, k3, T2, A3), h2.modifyFrames(t3, x2);
        }, e3.deleteFrames = function(t3, e4) {
          if (t3 = o.getGraphDiv(t3), !o.isPlotDiv(t3))
            throw new Error("This element is not a Plotly plot: " + t3);
          var r4, n3, i2 = t3._transitionData._frames, a2 = [], s2 = [];
          if (!e4)
            for (e4 = [], r4 = 0; r4 < i2.length; r4++)
              e4.push(r4);
          for ((e4 = e4.slice()).sort(), r4 = e4.length - 1; r4 >= 0; r4--)
            n3 = e4[r4], a2.push({ type: "delete", index: n3 }), s2.unshift({ type: "insert", index: n3, value: i2[n3] });
          var l3 = h2.modifyFrames, c3 = h2.modifyFrames, f3 = [t3, s2], p3 = [t3, a2];
          return u2 && u2.add(t3, l3, f3, c3, p3), h2.modifyFrames(t3, a2);
        }, e3.addTraces = function t3(r4, n3, i2) {
          r4 = o.getGraphDiv(r4);
          var a2, s2, l3 = [], c3 = e3.deleteTraces, f3 = t3, h3 = [r4, l3], p3 = [r4, n3];
          for (function(t4, e4, r5) {
            var n4, i3;
            if (!Array.isArray(t4.data))
              throw new Error("gd.data must be an array.");
            if (void 0 === e4)
              throw new Error("traces must be defined.");
            for (Array.isArray(e4) || (e4 = [e4]), n4 = 0; n4 < e4.length; n4++)
              if ("object" != typeof (i3 = e4[n4]) || Array.isArray(i3) || null === i3)
                throw new Error("all values in traces array must be non-array objects");
            if (void 0 === r5 || Array.isArray(r5) || (r5 = [r5]), void 0 !== r5 && r5.length !== e4.length)
              throw new Error("if indices is specified, traces.length must equal indices.length");
          }(r4, n3, i2), Array.isArray(n3) || (n3 = [n3]), n3 = n3.map(function(t4) {
            return o.extendFlat({}, t4);
          }), T.cleanData(n3), a2 = 0; a2 < n3.length; a2++)
            r4.data.push(n3[a2]);
          for (a2 = 0; a2 < n3.length; a2++)
            l3.push(-n3.length + a2);
          if (void 0 === i2)
            return s2 = e3.redraw(r4), u2.add(r4, c3, h3, f3, p3), s2;
          Array.isArray(i2) || (i2 = [i2]);
          try {
            D2(r4, l3, i2);
          } catch (t4) {
            throw r4.data.splice(r4.data.length - n3.length, n3.length), t4;
          }
          return u2.startSequence(r4), u2.add(r4, c3, h3, f3, p3), s2 = e3.moveTraces(r4, l3, i2), u2.stopSequence(r4), s2;
        }, e3.deleteTraces = function t3(r4, n3) {
          r4 = o.getGraphDiv(r4);
          var i2, a2, s2 = [], l3 = e3.addTraces, c3 = t3, f3 = [r4, s2, n3], h3 = [r4, n3];
          if (void 0 === n3)
            throw new Error("indices must be an integer or array of integers.");
          for (Array.isArray(n3) || (n3 = [n3]), I2(r4, n3, "indices"), (n3 = O(n3, r4.data.length - 1)).sort(o.sorterDes), i2 = 0; i2 < n3.length; i2 += 1)
            a2 = r4.data.splice(n3[i2], 1)[0], s2.push(a2);
          var p3 = e3.redraw(r4);
          return u2.add(r4, l3, f3, c3, h3), p3;
        }, e3.extendTraces = function t3(r4, n3, i2, a2) {
          var s2 = z2(r4 = o.getGraphDiv(r4), n3, i2, a2, function(t4, e4, r5) {
            var n4, i3;
            if (o.isTypedArray(t4))
              if (r5 < 0) {
                var a3 = new t4.constructor(0), s3 = R(t4, e4);
                r5 < 0 ? (n4 = s3, i3 = a3) : (n4 = a3, i3 = s3);
              } else if (n4 = new t4.constructor(r5), i3 = new t4.constructor(t4.length + e4.length - r5), r5 === e4.length)
                n4.set(e4), i3.set(t4);
              else if (r5 < e4.length) {
                var l4 = e4.length - r5;
                n4.set(e4.subarray(l4)), i3.set(t4), i3.set(e4.subarray(0, l4), t4.length);
              } else {
                var u3 = r5 - e4.length, c4 = t4.length - u3;
                n4.set(t4.subarray(c4)), n4.set(e4, u3), i3.set(t4.subarray(0, c4));
              }
            else
              n4 = t4.concat(e4), i3 = r5 >= 0 && r5 < n4.length ? n4.splice(0, n4.length - r5) : [];
            return [n4, i3];
          }), l3 = e3.redraw(r4), c3 = [r4, s2.update, i2, s2.maxPoints];
          return u2.add(r4, e3.prependTraces, c3, t3, arguments), l3;
        }, e3.moveTraces = function t3(r4, n3, i2) {
          var a2, s2 = [], l3 = [], c3 = t3, f3 = t3, h3 = [r4 = o.getGraphDiv(r4), i2, n3], p3 = [r4, n3, i2];
          if (D2(r4, n3, i2), n3 = Array.isArray(n3) ? n3 : [n3], void 0 === i2)
            for (i2 = [], a2 = 0; a2 < n3.length; a2++)
              i2.push(-n3.length + a2);
          for (i2 = Array.isArray(i2) ? i2 : [i2], n3 = O(n3, r4.data.length - 1), i2 = O(i2, r4.data.length - 1), a2 = 0; a2 < r4.data.length; a2++)
            -1 === n3.indexOf(a2) && s2.push(r4.data[a2]);
          for (a2 = 0; a2 < n3.length; a2++)
            l3.push({ newIndex: i2[a2], trace: r4.data[n3[a2]] });
          for (l3.sort(function(t4, e4) {
            return t4.newIndex - e4.newIndex;
          }), a2 = 0; a2 < l3.length; a2 += 1)
            s2.splice(l3[a2].newIndex, 0, l3[a2].trace);
          r4.data = s2;
          var d3 = e3.redraw(r4);
          return u2.add(r4, c3, h3, f3, p3), d3;
        }, e3.prependTraces = function t3(r4, n3, i2, a2) {
          var s2 = z2(r4 = o.getGraphDiv(r4), n3, i2, a2, function(t4, e4, r5) {
            var n4, i3;
            if (o.isTypedArray(t4))
              if (r5 <= 0) {
                var a3 = new t4.constructor(0), s3 = R(e4, t4);
                r5 < 0 ? (n4 = s3, i3 = a3) : (n4 = a3, i3 = s3);
              } else if (n4 = new t4.constructor(r5), i3 = new t4.constructor(t4.length + e4.length - r5), r5 === e4.length)
                n4.set(e4), i3.set(t4);
              else if (r5 < e4.length) {
                var l4 = e4.length - r5;
                n4.set(e4.subarray(0, l4)), i3.set(e4.subarray(l4)), i3.set(t4, l4);
              } else {
                var u3 = r5 - e4.length;
                n4.set(e4), n4.set(t4.subarray(0, u3), e4.length), i3.set(t4.subarray(u3));
              }
            else
              n4 = e4.concat(t4), i3 = r5 >= 0 && r5 < n4.length ? n4.splice(r5, n4.length) : [];
            return [n4, i3];
          }), l3 = e3.redraw(r4), c3 = [r4, s2.update, i2, s2.maxPoints];
          return u2.add(r4, e3.extendTraces, c3, t3, arguments), l3;
        }, e3.newPlot = function(t3, r4, n3, i2) {
          return t3 = o.getGraphDiv(t3), h2.cleanPlot([], {}, t3._fullData || [], t3._fullLayout || {}), h2.purge(t3), e3._doPlot(t3, r4, n3, i2);
        }, e3._doPlot = function(t3, r4, i2, a2) {
          var s2;
          if (t3 = o.getGraphDiv(t3), l2.init(t3), o.isPlainObject(r4)) {
            var u3 = r4;
            r4 = u3.data, i2 = u3.layout, a2 = u3.config, s2 = u3.frames;
          }
          if (false === l2.triggerHandler(t3, "plotly_beforeplot", [r4, i2, a2]))
            return Promise.reject();
          r4 || i2 || o.isPlotDiv(t3) || o.warn("Calling _doPlot as if redrawing but this container doesn't yet have a plot.", t3), P(t3, a2), i2 || (i2 = {}), n2.select(t3).classed("js-plotly-plot", true), g2.makeTester(), Array.isArray(t3._promises) || (t3._promises = []);
          var f3 = 0 === (t3.data || []).length && Array.isArray(r4);
          Array.isArray(r4) && (T.cleanData(r4), f3 ? t3.data = r4 : t3.data.push.apply(t3.data, r4), t3.empty = false), t3.layout && !f3 || (t3.layout = T.cleanLayout(i2)), h2.supplyDefaults(t3);
          var d3 = t3._fullLayout, v3 = d3._has("cartesian");
          d3._replotting = true, (f3 || d3._shouldCreateBgLayer) && (function(t4) {
            var e4 = n2.select(t4), r5 = t4._fullLayout;
            if (r5._calcInverseTransform = lt, r5._calcInverseTransform(t4), r5._container = e4.selectAll(".plot-container").data([0]), r5._container.enter().insert("div", ":first-child").classed("plot-container", true).classed("plotly", true), r5._paperdiv = r5._container.selectAll(".svg-container").data([0]), r5._paperdiv.enter().append("div").classed("user-select-none", true).classed("svg-container", true).style("position", "relative"), r5._glcontainer = r5._paperdiv.selectAll(".gl-container").data([{}]), r5._glcontainer.enter().append("div").classed("gl-container", true), r5._paperdiv.selectAll(".main-svg").remove(), r5._paperdiv.select(".modebar-container").remove(), r5._paper = r5._paperdiv.insert("svg", ":first-child").classed("main-svg", true), r5._toppaper = r5._paperdiv.append("svg").classed("main-svg", true), r5._modebardiv = r5._paperdiv.append("div"), delete r5._modeBar, r5._hoverpaper = r5._paperdiv.append("svg").classed("main-svg", true), !r5._uid) {
              var i3 = {};
              n2.selectAll("defs").each(function() {
                this.id && (i3[this.id.split("-")[1]] = 1);
              }), r5._uid = o.randstr(i3);
            }
            r5._paperdiv.selectAll(".main-svg").attr(x.svgAttrs), r5._defs = r5._paper.append("defs").attr("id", "defs-" + r5._uid), r5._clips = r5._defs.append("g").classed("clips", true), r5._topdefs = r5._toppaper.append("defs").attr("id", "topdefs-" + r5._uid), r5._topclips = r5._topdefs.append("g").classed("clips", true), r5._bgLayer = r5._paper.append("g").classed("bglayer", true), r5._draggers = r5._paper.append("g").classed("draglayer", true);
            var a3 = r5._paper.append("g").classed("layer-below", true);
            r5._imageLowerLayer = a3.append("g").classed("imagelayer", true), r5._shapeLowerLayer = a3.append("g").classed("shapelayer", true), r5._cartesianlayer = r5._paper.append("g").classed("cartesianlayer", true), r5._polarlayer = r5._paper.append("g").classed("polarlayer", true), r5._smithlayer = r5._paper.append("g").classed("smithlayer", true), r5._ternarylayer = r5._paper.append("g").classed("ternarylayer", true), r5._geolayer = r5._paper.append("g").classed("geolayer", true), r5._funnelarealayer = r5._paper.append("g").classed("funnelarealayer", true), r5._pielayer = r5._paper.append("g").classed("pielayer", true), r5._iciclelayer = r5._paper.append("g").classed("iciclelayer", true), r5._treemaplayer = r5._paper.append("g").classed("treemaplayer", true), r5._sunburstlayer = r5._paper.append("g").classed("sunburstlayer", true), r5._indicatorlayer = r5._toppaper.append("g").classed("indicatorlayer", true), r5._glimages = r5._paper.append("g").classed("glimages", true);
            var s3 = r5._toppaper.append("g").classed("layer-above", true);
            r5._imageUpperLayer = s3.append("g").classed("imagelayer", true), r5._shapeUpperLayer = s3.append("g").classed("shapelayer", true), r5._selectionLayer = r5._toppaper.append("g").classed("selectionlayer", true), r5._infolayer = r5._toppaper.append("g").classed("infolayer", true), r5._menulayer = r5._toppaper.append("g").classed("menulayer", true), r5._zoomlayer = r5._toppaper.append("g").classed("zoomlayer", true), r5._hoverlayer = r5._hoverpaper.append("g").classed("hoverlayer", true), r5._modebardiv.classed("modebar-container", true).style("position", "absolute").style("top", "0px").style("right", "0px"), t4.emit("plotly_framework");
          }(t3), d3._shouldCreateBgLayer && delete d3._shouldCreateBgLayer), g2.initGradients(t3), g2.initPatterns(t3), f3 && p2.saveShowSpikeInitial(t3);
          var y3 = !t3.calcdata || t3.calcdata.length !== (t3._fullData || []).length;
          y3 && h2.doCalcdata(t3);
          for (var b3 = 0; b3 < t3.calcdata.length; b3++)
            t3.calcdata[b3][0].trace = t3._fullData[b3];
          t3._context.responsive ? t3._responsiveChartHandler || (t3._responsiveChartHandler = function() {
            o.isHidden(t3) || h2.resize(t3);
          }, window.addEventListener("resize", t3._responsiveChartHandler)) : o.clearResponsive(t3);
          var _2 = o.extendFlat({}, d3._size), w3 = 0;
          function A3() {
            if (h2.clearAutoMarginIds(t3), k2.drawMarginPushers(t3), p2.allowAutoMargin(t3), t3._fullLayout.title.text && t3._fullLayout.title.automargin && h2.allowAutoMargin(t3, "title.automargin"), d3._has("pie"))
              for (var e4 = t3._fullData, r5 = 0; r5 < e4.length; r5++) {
                var n3 = e4[r5];
                "pie" === n3.type && n3.automargin && h2.allowAutoMargin(t3, "pie." + n3.uid + ".automargin");
              }
            return h2.doAutoMargin(t3), h2.previousPromises(t3);
          }
          function M2() {
            t3._transitioning || (k2.doAutoRangeAndConstraints(t3), f3 && p2.saveRangeInitial(t3), c2.getComponentMethod("rangeslider", "calcAutorange")(t3));
          }
          var S2 = [h2.previousPromises, function() {
            if (s2)
              return e3.addFrames(t3, s2);
          }, function e4() {
            for (var r5 = d3._basePlotModules, n3 = 0; n3 < r5.length; n3++)
              r5[n3].drawFramework && r5[n3].drawFramework(t3);
            !d3._glcanvas && d3._has("gl") && (d3._glcanvas = d3._glcontainer.selectAll(".gl-canvas").data([{ key: "contextLayer", context: true, pick: false }, { key: "focusLayer", context: false, pick: false }, { key: "pickLayer", context: false, pick: true }], function(t4) {
              return t4.key;
            }), d3._glcanvas.enter().append("canvas").attr("class", function(t4) {
              return "gl-canvas gl-canvas-" + t4.key.replace("Layer", "");
            }).style({ position: "absolute", top: 0, left: 0, overflow: "visible", "pointer-events": "none" }));
            var i3 = t3._context.plotGlPixelRatio;
            if (d3._glcanvas) {
              d3._glcanvas.attr("width", d3.width * i3).attr("height", d3.height * i3).style("width", d3.width + "px").style("height", d3.height + "px");
              var a3 = d3._glcanvas.data()[0].regl;
              if (a3 && (Math.floor(d3.width * i3) !== a3._gl.drawingBufferWidth || Math.floor(d3.height * i3) !== a3._gl.drawingBufferHeight)) {
                var s3 = "WebGL context buffer and canvas dimensions do not match due to browser/WebGL bug.";
                if (!w3)
                  return o.log(s3 + " Clearing graph and plotting again."), h2.cleanPlot([], {}, t3._fullData, d3), h2.supplyDefaults(t3), d3 = t3._fullLayout, h2.doCalcdata(t3), w3++, e4();
                o.error(s3);
              }
            }
            return "h" === d3.modebar.orientation ? d3._modebardiv.style("height", null).style("width", "100%") : d3._modebardiv.style("width", null).style("height", d3.height + "px"), h2.previousPromises(t3);
          }, A3, function() {
            if (h2.didMarginChange(_2, d3._size))
              return o.syncOrAsync([A3, k2.layoutStyles], t3);
          }];
          v3 && S2.push(function() {
            if (y3)
              return o.syncOrAsync([c2.getComponentMethod("shapes", "calcAutorange"), c2.getComponentMethod("annotations", "calcAutorange"), M2], t3);
            M2();
          }), S2.push(k2.layoutStyles), v3 && S2.push(function() {
            return p2.draw(t3, f3 ? "" : "redraw");
          }, function(t4) {
            var e4 = t4._fullLayout._insideTickLabelsUpdaterange;
            if (e4)
              return t4._fullLayout._insideTickLabelsUpdaterange = void 0, q2(t4, e4).then(function() {
                p2.saveRangeInitial(t4, true);
              });
          }), S2.push(k2.drawData, k2.finalDraw, m2, h2.addLinks, h2.rehover, h2.redrag, h2.reselect, h2.doAutoMargin, h2.previousPromises);
          var L2 = o.syncOrAsync(S2, t3);
          return L2 && L2.then || (L2 = Promise.resolve()), L2.then(function() {
            return E2(t3), t3;
          });
        }, e3.purge = function(t3) {
          var e4 = (t3 = o.getGraphDiv(t3))._fullLayout || {}, r4 = t3._fullData || [];
          return h2.cleanPlot([], {}, r4, e4), h2.purge(t3), l2.purge(t3), e4._container && e4._container.remove(), delete t3._context, t3;
        }, e3.react = function(t3, r4, n3, i2) {
          var a2, l3;
          t3 = o.getGraphDiv(t3), T.clearPromiseQueue(t3);
          var u3 = t3._fullData, p3 = t3._fullLayout;
          if (o.isPlotDiv(t3) && u3 && p3) {
            if (o.isPlainObject(r4)) {
              var d3 = r4;
              r4 = d3.data, n3 = d3.layout, i2 = d3.config, a2 = d3.frames;
            }
            var v3 = false;
            if (i2) {
              var g3 = o.extendDeep({}, t3._context);
              t3._context = void 0, P(t3, i2), v3 = st(g3, t3._context);
            }
            t3.data = r4 || [], T.cleanData(t3.data), t3.layout = n3 || {}, T.cleanLayout(t3.layout), function(t4, e4, r5, n4) {
              var i3, a3, l4, u4, c3, f3, h3, p4, d4, v4, g4 = n4._preGUI, y4 = [], m4 = {}, x3 = {};
              for (i3 in g4) {
                if (c3 = et(i3, Q)) {
                  if (d4 = c3.head, v4 = c3.tail, a3 = c3.attr || d4 + ".uirevision", (u4 = (l4 = s(n4, a3).get()) && rt(a3, e4)) && u4 === l4) {
                    if (null === (f3 = g4[i3]) && (f3 = void 0), at(p4 = (h3 = s(e4, i3)).get(), f3)) {
                      void 0 === p4 && "autorange" === v4 && y4.push(d4), h3.set(B2(s(n4, i3).get()));
                      continue;
                    }
                    if ("autorange" === v4 || "range[" === v4.substr(0, 6)) {
                      var b4 = g4[d4 + ".range[0]"], _3 = g4[d4 + ".range[1]"], w4 = g4[d4 + ".autorange"];
                      if (w4 || null === w4 && null === b4 && null === _3) {
                        if (!(d4 in m4)) {
                          var T2 = s(e4, d4).get();
                          m4[d4] = T2 && (T2.autorange || false !== T2.autorange && (!T2.range || 2 !== T2.range.length));
                        }
                        if (m4[d4]) {
                          h3.set(B2(s(n4, i3).get()));
                          continue;
                        }
                      }
                    }
                  }
                } else
                  o.warn("unrecognized GUI edit: " + i3);
                delete g4[i3], c3 && "range[" === c3.tail.substr(0, 6) && (x3[c3.head] = 1);
              }
              for (var k3 = 0; k3 < y4.length; k3++) {
                var A3 = y4[k3];
                if (x3[A3]) {
                  var M3 = s(e4, A3).get();
                  M3 && delete M3.autorange;
                }
              }
              var S3 = n4._tracePreGUI;
              for (var E3 in S3) {
                var L3, C4 = S3[E3], P2 = null;
                for (i3 in C4) {
                  if (!P2) {
                    var O3 = nt(E3, r5);
                    if (O3 < 0) {
                      delete S3[E3];
                      break;
                    }
                    var I4 = it(E3, t4, (L3 = r5[O3]._fullInput).index);
                    if (I4 < 0) {
                      delete S3[E3];
                      break;
                    }
                    P2 = t4[I4];
                  }
                  if (c3 = et(i3, tt2)) {
                    if (c3.attr ? u4 = (l4 = s(n4, c3.attr).get()) && rt(c3.attr, e4) : (l4 = L3.uirevision, void 0 === (u4 = P2.uirevision) && (u4 = e4.uirevision)), u4 && u4 === l4 && (null === (f3 = C4[i3]) && (f3 = void 0), at(p4 = (h3 = s(P2, i3)).get(), f3))) {
                      h3.set(B2(s(L3, i3).get()));
                      continue;
                    }
                  } else
                    o.warn("unrecognized GUI edit: " + i3 + " in trace uid " + E3);
                  delete C4[i3];
                }
              }
            }(t3.data, t3.layout, u3, p3), h2.supplyDefaults(t3, { skipUpdateCalc: true });
            var y3 = t3._fullData, m3 = t3._fullLayout, x2 = void 0 === m3.datarevision, b3 = m3.transition, _2 = function(t4, e4, r5, n4, i3) {
              var a3 = A2.layoutFlags();
              return a3.arrays = {}, a3.rangesAltered = {}, a3.nChanges = 0, a3.nChangesAnim = 0, ot(e4, r5, [], { getValObject: function(t5) {
                return f2.getLayoutValObject(r5, t5);
              }, flags: a3, immutable: n4, transition: i3, gd: t4 }), (a3.plot || a3.calc) && (a3.layoutReplot = true), i3 && a3.nChanges && a3.nChangesAnim && (a3.anim = a3.nChanges === a3.nChangesAnim ? "all" : "some"), a3;
            }(t3, p3, m3, x2, b3), w3 = _2.newDataRevision, M2 = function(t4, e4, r5, n4, i3, a3) {
              var o2 = e4.length === r5.length;
              if (!i3 && !o2)
                return { fullReplot: true, calc: true };
              var s2, l4, u4 = A2.traceFlags();
              u4.arrays = {}, u4.nChanges = 0, u4.nChangesAnim = 0;
              var c3 = { getValObject: function(t5) {
                var e5 = f2.getTraceValObject(l4, t5);
                return !l4._module.animatable && e5.anim && (e5.anim = false), e5;
              }, flags: u4, immutable: n4, transition: i3, newDataRevision: a3, gd: t4 }, p4 = {};
              for (s2 = 0; s2 < e4.length; s2++)
                if (r5[s2]) {
                  if (l4 = r5[s2]._fullInput, h2.hasMakesDataTransform(l4) && (l4 = r5[s2]), p4[l4.uid])
                    continue;
                  p4[l4.uid] = 1, ot(e4[s2]._fullInput, l4, [], c3);
                }
              return (u4.calc || u4.plot) && (u4.fullReplot = true), i3 && u4.nChanges && u4.nChangesAnim && (u4.anim = u4.nChanges === u4.nChangesAnim && o2 ? "all" : "some"), u4;
            }(t3, u3, y3, x2, b3, w3);
            if (K(t3) && (_2.layoutReplot = true), M2.calc || _2.calc) {
              t3.calcdata = void 0;
              for (var S2 = Object.getOwnPropertyNames(m3), L2 = 0; L2 < S2.length; L2++) {
                var C3 = S2[L2], O2 = C3.substring(0, 5);
                if ("xaxis" === O2 || "yaxis" === O2) {
                  var I3 = m3[C3]._emptyCategories;
                  I3 && I3();
                }
              }
            } else
              h2.supplyDefaultsUpdateCalc(t3.calcdata, y3);
            var D3 = [];
            if (a2 && (t3._transitionData = {}, h2.createTransitionData(t3), D3.push(function() {
              return e3.addFrames(t3, a2);
            })), m3.transition && !v3 && (M2.anim || _2.anim))
              _2.ticks && D3.push(k2.doTicksRelayout), h2.doCalcdata(t3), k2.doAutoRangeAndConstraints(t3), D3.push(function() {
                return h2.transitionFromReact(t3, M2, _2, p3);
              });
            else if (M2.fullReplot || _2.layoutReplot || v3)
              t3._fullLayout._skipDefaults = true, D3.push(e3._doPlot);
            else {
              for (var z3 in _2.arrays) {
                var R2 = _2.arrays[z3];
                if (R2.length) {
                  var F3 = c2.getComponentMethod(z3, "drawOne");
                  if (F3 !== o.noop)
                    for (var N2 = 0; N2 < R2.length; N2++)
                      F3(t3, R2[N2]);
                  else {
                    var j2 = c2.getComponentMethod(z3, "draw");
                    if (j2 === o.noop)
                      throw new Error("cannot draw components: " + z3);
                    j2(t3);
                  }
                }
              }
              D3.push(h2.previousPromises), M2.style && D3.push(k2.doTraceStyle), (M2.colorbars || _2.colorbars) && D3.push(k2.doColorBars), _2.legend && D3.push(k2.doLegend), _2.layoutstyle && D3.push(k2.layoutStyles), _2.axrange && G2(D3), _2.ticks && D3.push(k2.doTicksRelayout), _2.modebar && D3.push(k2.doModeBar), _2.camera && D3.push(k2.doCamera), D3.push(E2);
            }
            D3.push(h2.rehover, h2.redrag, h2.reselect), (l3 = o.syncOrAsync(D3, t3)) && l3.then || (l3 = Promise.resolve(t3));
          } else
            l3 = e3.newPlot(t3, r4, n3, i2);
          return l3.then(function() {
            return t3.emit("plotly_react", { data: r4, layout: n3 }), t3;
          });
        }, e3.redraw = function(t3) {
          if (t3 = o.getGraphDiv(t3), !o.isPlotDiv(t3))
            throw new Error("This element is not a Plotly plot: " + t3);
          return T.cleanData(t3.data), T.cleanLayout(t3.layout), t3.calcdata = void 0, e3._doPlot(t3).then(function() {
            return t3.emit("plotly_redraw"), t3;
          });
        }, e3.relayout = q2, e3.restyle = F2, e3.setPlotConfig = function(t3) {
          return o.extendFlat(_, t3);
        }, e3.update = J, e3._guiRelayout = $(q2), e3._guiRestyle = $(F2), e3._guiUpdate = $(J), e3._storeDirectGUIEdit = function(t3, e4, r4) {
          for (var n3 in r4)
            j(n3, s(t3, n3).get(), r4[n3], e4);
        };
      }, 20556: function(t2) {
        var e3 = { staticPlot: { valType: "boolean", dflt: false }, typesetMath: { valType: "boolean", dflt: true }, plotlyServerURL: { valType: "string", dflt: "" }, editable: { valType: "boolean", dflt: false }, edits: { annotationPosition: { valType: "boolean", dflt: false }, annotationTail: { valType: "boolean", dflt: false }, annotationText: { valType: "boolean", dflt: false }, axisTitleText: { valType: "boolean", dflt: false }, colorbarPosition: { valType: "boolean", dflt: false }, colorbarTitleText: { valType: "boolean", dflt: false }, legendPosition: { valType: "boolean", dflt: false }, legendText: { valType: "boolean", dflt: false }, shapePosition: { valType: "boolean", dflt: false }, titleText: { valType: "boolean", dflt: false } }, editSelection: { valType: "boolean", dflt: true }, autosizable: { valType: "boolean", dflt: false }, responsive: { valType: "boolean", dflt: false }, fillFrame: { valType: "boolean", dflt: false }, frameMargins: { valType: "number", dflt: 0, min: 0, max: 0.5 }, scrollZoom: { valType: "flaglist", flags: ["cartesian", "gl3d", "geo", "mapbox"], extras: [true, false], dflt: "gl3d+geo+mapbox" }, doubleClick: { valType: "enumerated", values: [false, "reset", "autosize", "reset+autosize"], dflt: "reset+autosize" }, doubleClickDelay: { valType: "number", dflt: 300, min: 0 }, showAxisDragHandles: { valType: "boolean", dflt: true }, showAxisRangeEntryBoxes: { valType: "boolean", dflt: true }, showTips: { valType: "boolean", dflt: true }, showLink: { valType: "boolean", dflt: false }, linkText: { valType: "string", dflt: "Edit chart", noBlank: true }, sendData: { valType: "boolean", dflt: true }, showSources: { valType: "any", dflt: false }, displayModeBar: { valType: "enumerated", values: ["hover", true, false], dflt: "hover" }, showSendToCloud: { valType: "boolean", dflt: false }, showEditInChartStudio: { valType: "boolean", dflt: false }, modeBarButtonsToRemove: { valType: "any", dflt: [] }, modeBarButtonsToAdd: { valType: "any", dflt: [] }, modeBarButtons: { valType: "any", dflt: false }, toImageButtonOptions: { valType: "any", dflt: {} }, displaylogo: { valType: "boolean", dflt: true }, watermark: { valType: "boolean", dflt: false }, plotGlPixelRatio: { valType: "number", dflt: 2, min: 1, max: 4 }, setBackground: { valType: "any", dflt: "transparent" }, topojsonURL: { valType: "string", noBlank: true, dflt: "https://cdn.plot.ly/" }, mapboxAccessToken: { valType: "string", dflt: null }, logging: { valType: "integer", min: 0, max: 2, dflt: 1 }, notifyOnLogging: { valType: "integer", min: 0, max: 2, dflt: 0 }, queueLength: { valType: "integer", min: 0, dflt: 0 }, globalTransforms: { valType: "any", dflt: [] }, locale: { valType: "string", dflt: "en-US" }, locales: { valType: "any", dflt: {} } }, r3 = {};
        !function t3(e4, r4) {
          for (var n2 in e4) {
            var i = e4[n2];
            i.valType ? r4[n2] = i.dflt : (r4[n2] || (r4[n2] = {}), t3(i, r4[n2]));
          }
        }(e3, r3), t2.exports = { configAttributes: e3, dfltConfig: r3 };
      }, 73060: function(t2, e3, r3) {
        var n2 = r3(24040), i = r3(3400), a = r3(45464), o = r3(64859), s = r3(16672), l2 = r3(85656), u2 = r3(20556).configAttributes, c2 = r3(67824), f2 = i.extendDeepAll, h2 = i.isPlainObject, p2 = i.isArrayOrTypedArray, d2 = i.nestedProperty, v2 = i.valObjectMeta, g2 = "_isSubplotObj", y2 = "_isLinkedToArray", m2 = "_deprecated", x = [g2, y2, "_arrayAttrRegexps", m2];
        function b2(t3, e4, r4) {
          if (!t3)
            return false;
          if (t3._isLinkedToArray) {
            if (_(e4[r4]))
              r4++;
            else if (r4 < e4.length)
              return false;
          }
          for (; r4 < e4.length; r4++) {
            var n3 = t3[e4[r4]];
            if (!h2(n3))
              break;
            if (t3 = n3, r4 === e4.length - 1)
              break;
            if (t3._isLinkedToArray) {
              if (!_(e4[++r4]))
                return false;
            } else if ("info_array" === t3.valType) {
              var i2 = e4[++r4];
              if (!_(i2))
                return false;
              var a2 = t3.items;
              if (Array.isArray(a2)) {
                if (i2 >= a2.length)
                  return false;
                if (2 === t3.dimensions) {
                  if (r4++, e4.length === r4)
                    return t3;
                  var o2 = e4[r4];
                  if (!_(o2))
                    return false;
                  t3 = a2[i2][o2];
                } else
                  t3 = a2[i2];
              } else
                t3 = a2;
            }
          }
          return t3;
        }
        function _(t3) {
          return t3 === Math.round(t3) && t3 >= 0;
        }
        function w2() {
          var t3, e4, r4 = {};
          for (t3 in f2(r4, o), n2.subplotsRegistry)
            if ((e4 = n2.subplotsRegistry[t3]).layoutAttributes)
              if (Array.isArray(e4.attr))
                for (var i2 = 0; i2 < e4.attr.length; i2++)
                  k2(r4, e4, e4.attr[i2]);
              else
                k2(r4, e4, "subplot" === e4.attr ? e4.name : e4.attr);
          for (t3 in n2.componentsRegistry) {
            var a2 = (e4 = n2.componentsRegistry[t3]).schema;
            if (a2 && (a2.subplots || a2.layout)) {
              var s2 = a2.subplots;
              if (s2 && s2.xaxis && !s2.yaxis)
                for (var l3 in s2.xaxis)
                  delete r4.yaxis[l3];
              delete r4.xaxis.shift, delete r4.xaxis.autoshift;
            } else
              "colorscale" === e4.name ? f2(r4, e4.layoutAttributes) : e4.layoutAttributes && A2(r4, e4.layoutAttributes, e4.name);
          }
          return { layoutAttributes: T(r4) };
        }
        function T(t3) {
          return function(t4) {
            e3.crawl(t4, function(t5, r4, n3) {
              e3.isValObject(t5) ? true !== t5.arrayOk && "data_array" !== t5.valType || (n3[r4 + "src"] = { valType: "string", editType: "none" }) : h2(t5) && (t5.role = "object");
            });
          }(t3), function(t4) {
            e3.crawl(t4, function(t5, e4, r4) {
              if (t5) {
                var n3 = t5[y2];
                n3 && (delete t5[y2], r4[e4] = { items: {} }, r4[e4].items[n3] = t5, r4[e4].role = "object");
              }
            });
          }(t3), function(t4) {
            !function t5(e4) {
              for (var r4 in e4)
                if (h2(e4[r4]))
                  t5(e4[r4]);
                else if (Array.isArray(e4[r4]))
                  for (var n3 = 0; n3 < e4[r4].length; n3++)
                    t5(e4[r4][n3]);
                else
                  e4[r4] instanceof RegExp && (e4[r4] = e4[r4].toString());
            }(t4);
          }(t3), t3;
        }
        function k2(t3, e4, r4) {
          var n3 = d2(t3, r4), i2 = f2({}, e4.layoutAttributes);
          i2[g2] = true, n3.set(i2);
        }
        function A2(t3, e4, r4) {
          var n3 = d2(t3, r4);
          n3.set(f2(n3.get() || {}, e4));
        }
        e3.IS_SUBPLOT_OBJ = g2, e3.IS_LINKED_TO_ARRAY = y2, e3.DEPRECATED = m2, e3.UNDERSCORE_ATTRS = x, e3.get = function() {
          var t3 = {};
          n2.allTypes.forEach(function(r5) {
            t3[r5] = function(t4) {
              var r6, i3;
              i3 = (r6 = n2.modules[t4]._module).basePlotModule;
              var o2 = { type: null }, s2 = f2({}, a), l3 = f2({}, r6.attributes);
              e3.crawl(l3, function(t5, e4, r7, n3, i4) {
                d2(s2, i4).set(void 0), void 0 === t5 && d2(l3, i4).set(void 0);
              }), f2(o2, s2), n2.traceIs(t4, "noOpacity") && delete o2.opacity, n2.traceIs(t4, "showLegend") || (delete o2.showlegend, delete o2.legendgroup), n2.traceIs(t4, "noHover") && (delete o2.hoverinfo, delete o2.hoverlabel), r6.selectPoints || delete o2.selectedpoints, f2(o2, l3), i3.attributes && f2(o2, i3.attributes), o2.type = t4;
              var u3 = { meta: r6.meta || {}, categories: r6.categories || {}, animatable: Boolean(r6.animatable), type: t4, attributes: T(o2) };
              if (r6.layoutAttributes) {
                var c3 = {};
                f2(c3, r6.layoutAttributes), u3.layoutAttributes = T(c3);
              }
              return r6.animatable || e3.crawl(u3, function(t5) {
                e3.isValObject(t5) && "anim" in t5 && delete t5.anim;
              }), u3;
            }(r5);
          });
          var r4, i2 = {};
          return Object.keys(n2.transformsRegistry).forEach(function(t4) {
            i2[t4] = function(t5) {
              var e4 = n2.transformsRegistry[t5], r5 = f2({}, e4.attributes);
              return Object.keys(n2.componentsRegistry).forEach(function(e5) {
                var i3 = n2.componentsRegistry[e5];
                i3.schema && i3.schema.transforms && i3.schema.transforms[t5] && Object.keys(i3.schema.transforms[t5]).forEach(function(e6) {
                  A2(r5, i3.schema.transforms[t5][e6], e6);
                });
              }), { attributes: T(r5) };
            }(t4);
          }), { defs: { valObjects: v2, metaKeys: x.concat(["description", "role", "editType", "impliedEdits"]), editType: { traces: c2.traces, layout: c2.layout }, impliedEdits: {} }, traces: t3, layout: w2(), transforms: i2, frames: (r4 = { frames: f2({}, s) }, T(r4), r4.frames), animation: T(l2), config: T(u2) };
        }, e3.crawl = function(t3, r4, n3, i2) {
          var a2 = n3 || 0;
          i2 = i2 || "", Object.keys(t3).forEach(function(n4) {
            var o2 = t3[n4];
            if (-1 === x.indexOf(n4)) {
              var s2 = (i2 ? i2 + "." : "") + n4;
              r4(o2, n4, t3, a2, s2), e3.isValObject(o2) || h2(o2) && "impliedEdits" !== n4 && e3.crawl(o2, r4, a2 + 1, s2);
            }
          });
        }, e3.isValObject = function(t3) {
          return t3 && void 0 !== t3.valType;
        }, e3.findArrayAttributes = function(t3) {
          var r4, n3, i2 = [], o2 = [], s2 = [];
          function l3(t4, e4, n4, i3) {
            o2 = o2.slice(0, i3).concat([e4]), s2 = s2.slice(0, i3).concat([t4 && t4._isLinkedToArray]), t4 && ("data_array" === t4.valType || true === t4.arrayOk) && ("colorbar" !== o2[i3 - 1] || "ticktext" !== e4 && "tickvals" !== e4) && u3(r4, 0, "");
          }
          function u3(t4, e4, r5) {
            var a2 = t4[o2[e4]], l4 = r5 + o2[e4];
            if (e4 === o2.length - 1)
              p2(a2) && i2.push(n3 + l4);
            else if (s2[e4]) {
              if (Array.isArray(a2))
                for (var c4 = 0; c4 < a2.length; c4++)
                  h2(a2[c4]) && u3(a2[c4], e4 + 1, l4 + "[" + c4 + "].");
            } else
              h2(a2) && u3(a2, e4 + 1, l4 + ".");
          }
          r4 = t3, n3 = "", e3.crawl(a, l3), t3._module && t3._module.attributes && e3.crawl(t3._module.attributes, l3);
          var c3 = t3.transforms;
          if (c3)
            for (var f3 = 0; f3 < c3.length; f3++) {
              var d3 = c3[f3], v3 = d3._module;
              v3 && (n3 = "transforms[" + f3 + "].", r4 = d3, e3.crawl(v3.attributes, l3));
            }
          return i2;
        }, e3.getTraceValObject = function(t3, e4) {
          var r4, i2, o2 = e4[0], s2 = 1;
          if ("transforms" === o2) {
            if (1 === e4.length)
              return a.transforms;
            var l3 = t3.transforms;
            if (!Array.isArray(l3) || !l3.length)
              return false;
            var u3 = e4[1];
            if (!_(u3) || u3 >= l3.length)
              return false;
            i2 = (r4 = (n2.transformsRegistry[l3[u3].type] || {}).attributes) && r4[e4[2]], s2 = 3;
          } else {
            var c3 = t3._module;
            if (c3 || (c3 = (n2.modules[t3.type || a.type.dflt] || {})._module), !c3)
              return false;
            if (!(i2 = (r4 = c3.attributes) && r4[o2])) {
              var f3 = c3.basePlotModule;
              f3 && f3.attributes && (i2 = f3.attributes[o2]);
            }
            i2 || (i2 = a[o2]);
          }
          return b2(i2, e4, s2);
        }, e3.getLayoutValObject = function(t3, e4) {
          var r4 = function(t4, e5) {
            var r5, i2, a2, s2, l3 = t4._basePlotModules;
            if (l3) {
              var u3;
              for (r5 = 0; r5 < l3.length; r5++) {
                if ((a2 = l3[r5]).attrRegex && a2.attrRegex.test(e5)) {
                  if (a2.layoutAttrOverrides)
                    return a2.layoutAttrOverrides;
                  !u3 && a2.layoutAttributes && (u3 = a2.layoutAttributes);
                }
                var c3 = a2.baseLayoutAttrOverrides;
                if (c3 && e5 in c3)
                  return c3[e5];
              }
              if (u3)
                return u3;
            }
            var f3 = t4._modules;
            if (f3) {
              for (r5 = 0; r5 < f3.length; r5++)
                if ((s2 = f3[r5].layoutAttributes) && e5 in s2)
                  return s2[e5];
            }
            for (i2 in n2.componentsRegistry) {
              if ("colorscale" === (a2 = n2.componentsRegistry[i2]).name && 0 === e5.indexOf("coloraxis"))
                return a2.layoutAttributes[e5];
              if (!a2.schema && e5 === a2.name)
                return a2.layoutAttributes;
            }
            return e5 in o && o[e5];
          }(t3, e4[0]);
          return b2(r4, e4, 1);
        };
      }, 31780: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(45464), a = "templateitemname", o = { name: { valType: "string", editType: "none" } };
        function s(t3) {
          return t3 && "string" == typeof t3;
        }
        function l2(t3) {
          var e4 = t3.length - 1;
          return "s" !== t3.charAt(e4) && n2.warn("bad argument to arrayDefaultKey: " + t3), t3.substr(0, t3.length - 1) + "defaults";
        }
        o[a] = { valType: "string", editType: "calc" }, e3.templatedArray = function(t3, e4) {
          return e4._isLinkedToArray = t3, e4.name = o.name, e4[a] = o[a], e4;
        }, e3.traceTemplater = function(t3) {
          var e4, r4, a2 = {};
          for (e4 in t3)
            r4 = t3[e4], Array.isArray(r4) && r4.length && (a2[e4] = 0);
          return { newTrace: function(o2) {
            var s2 = { type: e4 = n2.coerce(o2, {}, i, "type"), _template: null };
            if (e4 in a2) {
              r4 = t3[e4];
              var l3 = a2[e4] % r4.length;
              a2[e4]++, s2._template = r4[l3];
            }
            return s2;
          } };
        }, e3.newContainer = function(t3, e4, r4) {
          var i2 = t3._template, a2 = i2 && (i2[e4] || r4 && i2[r4]);
          return n2.isPlainObject(a2) || (a2 = null), t3[e4] = { _template: a2 };
        }, e3.arrayTemplater = function(t3, e4, r4) {
          var n3 = t3._template, i2 = n3 && n3[l2(e4)], o2 = n3 && n3[e4];
          Array.isArray(o2) && o2.length || (o2 = []);
          var u2 = {};
          return { newItem: function(t4) {
            var e5 = { name: t4.name, _input: t4 }, n4 = e5[a] = t4[a];
            if (!s(n4))
              return e5._template = i2, e5;
            for (var l3 = 0; l3 < o2.length; l3++) {
              var c2 = o2[l3];
              if (c2.name === n4)
                return u2[n4] = 1, e5._template = c2, e5;
            }
            return e5[r4] = t4[r4] || false, e5._template = false, e5;
          }, defaultItems: function() {
            for (var t4 = [], e5 = 0; e5 < o2.length; e5++) {
              var r5 = o2[e5], n4 = r5.name;
              if (s(n4) && !u2[n4]) {
                var i3 = { _template: r5, name: n4, _input: { _templateitemname: n4 } };
                i3[a] = r5[a], t4.push(i3), u2[n4] = 1;
              }
            }
            return t4;
          } };
        }, e3.arrayDefaultKey = l2, e3.arrayEditor = function(t3, e4, r4) {
          var i2 = (n2.nestedProperty(t3, e4).get() || []).length, o2 = r4._index, s2 = o2 >= i2 && (r4._input || {})._templateitemname;
          s2 && (o2 = i2);
          var l3, u2 = e4 + "[" + o2 + "]";
          function c2() {
            l3 = {}, s2 && (l3[u2] = {}, l3[u2][a] = s2);
          }
          function f2(t4, e5) {
            s2 ? n2.nestedProperty(l3[u2], t4).set(e5) : l3[u2 + "." + t4] = e5;
          }
          function h2() {
            var t4 = l3;
            return c2(), t4;
          }
          return c2(), { modifyBase: function(t4, e5) {
            l3[t4] = e5;
          }, modifyItem: f2, getUpdateObj: h2, applyUpdate: function(e5, r5) {
            e5 && f2(e5, r5);
            var i3 = h2();
            for (var a2 in i3)
              n2.nestedProperty(t3, a2).set(i3[a2]);
          } };
        };
      }, 39172: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(24040), a = r3(7316), o = r3(3400), s = r3(72736), l2 = r3(73696), u2 = r3(76308), c2 = r3(43616), f2 = r3(81668), h2 = r3(45460), p2 = r3(54460), d2 = r3(84284), v2 = r3(71888), g2 = v2.enforce, y2 = v2.clean, m2 = r3(19280).doAutoRange, x = "start";
        function b2(t3, e4, r4) {
          for (var n3 = 0; n3 < r4.length; n3++) {
            var i2 = r4[n3][0], a2 = r4[n3][1];
            if (!(i2[0] >= t3[1] || i2[1] <= t3[0]) && a2[0] < e4[1] && a2[1] > e4[0])
              return true;
          }
          return false;
        }
        function _(t3) {
          var r4, i2, s2, l3, f3, v3, g3 = t3._fullLayout, y3 = g3._size, m3 = y3.p, x2 = p2.list(t3, "", true);
          if (g3._paperdiv.style({ width: t3._context.responsive && g3.autosize && !t3._context._hasZeroWidth && !t3.layout.width ? "100%" : g3.width + "px", height: t3._context.responsive && g3.autosize && !t3._context._hasZeroHeight && !t3.layout.height ? "100%" : g3.height + "px" }).selectAll(".main-svg").call(c2.setSize, g3.width, g3.height), t3._context.setBackground(t3, g3.paper_bgcolor), e3.drawMainTitle(t3), h2.manage(t3), !g3._has("cartesian"))
            return a.previousPromises(t3);
          function _2(t4, e4, r5) {
            var n3 = t4._lw / 2;
            return "x" === t4._id.charAt(0) ? e4 ? "top" === r5 ? e4._offset - m3 - n3 : e4._offset + e4._length + m3 + n3 : y3.t + y3.h * (1 - (t4.position || 0)) + n3 % 1 : e4 ? "right" === r5 ? e4._offset + e4._length + m3 + n3 : e4._offset - m3 - n3 : y3.l + y3.w * (t4.position || 0) + n3 % 1;
          }
          for (r4 = 0; r4 < x2.length; r4++) {
            var T2 = (l3 = x2[r4])._anchorAxis;
            l3._linepositions = {}, l3._lw = c2.crispRound(t3, l3.linewidth, 1), l3._mainLinePosition = _2(l3, T2, l3.side), l3._mainMirrorPosition = l3.mirror && T2 ? _2(l3, T2, d2.OPPOSITE_SIDE[l3.side]) : null;
          }
          var A2 = [], M = [], S = [], E2 = 1 === u2.opacity(g3.paper_bgcolor) && 1 === u2.opacity(g3.plot_bgcolor) && g3.paper_bgcolor === g3.plot_bgcolor;
          for (i2 in g3._plots)
            if ((s2 = g3._plots[i2]).mainplot)
              s2.bg && s2.bg.remove(), s2.bg = void 0;
            else {
              var L = s2.xaxis.domain, C2 = s2.yaxis.domain, P = s2.plotgroup;
              if (b2(L, C2, S)) {
                var O = P.node(), I2 = s2.bg = o.ensureSingle(P, "rect", "bg");
                O.insertBefore(I2.node(), O.childNodes[0]), M.push(i2);
              } else
                P.select("rect.bg").remove(), S.push([L, C2]), E2 || (A2.push(i2), M.push(i2));
            }
          var D2, z2, R, F2, B2, N, j, U, V, q2, H2, G2, W, Y = g3._bgLayer.selectAll(".bg").data(A2);
          for (Y.enter().append("rect").classed("bg", true), Y.exit().remove(), Y.each(function(t4) {
            g3._plots[t4].bg = n2.select(this);
          }), r4 = 0; r4 < M.length; r4++)
            s2 = g3._plots[M[r4]], f3 = s2.xaxis, v3 = s2.yaxis, s2.bg && void 0 !== f3._offset && void 0 !== v3._offset && s2.bg.call(c2.setRect, f3._offset - m3, v3._offset - m3, f3._length + 2 * m3, v3._length + 2 * m3).call(u2.fill, g3.plot_bgcolor).style("stroke-width", 0);
          if (!g3._hasOnlyLargeSploms)
            for (i2 in g3._plots) {
              s2 = g3._plots[i2], f3 = s2.xaxis, v3 = s2.yaxis;
              var X, Z, K = s2.clipId = "clip" + g3._uid + i2 + "plot", J = o.ensureSingleById(g3._clips, "clipPath", K, function(t4) {
                t4.classed("plotclip", true).append("rect");
              });
              s2.clipRect = J.select("rect").attr({ width: f3._length, height: v3._length }), c2.setTranslate(s2.plot, f3._offset, v3._offset), s2._hasClipOnAxisFalse ? (X = null, Z = K) : (X = K, Z = null), c2.setClipUrl(s2.plot, X, t3), s2.layerClipId = Z;
            }
          function $(t4) {
            return "M" + D2 + "," + t4 + "H" + z2;
          }
          function Q(t4) {
            return "M" + f3._offset + "," + t4 + "h" + f3._length;
          }
          function tt2(t4) {
            return "M" + t4 + "," + U + "V" + j;
          }
          function et(t4) {
            return void 0 !== v3._shift && (t4 += v3._shift), "M" + t4 + "," + v3._offset + "v" + v3._length;
          }
          function rt(t4, e4, r5) {
            if (!t4.showline || i2 !== t4._mainSubplot)
              return "";
            if (!t4._anchorAxis)
              return r5(t4._mainLinePosition);
            var n3 = e4(t4._mainLinePosition);
            return t4.mirror && (n3 += e4(t4._mainMirrorPosition)), n3;
          }
          for (i2 in g3._plots) {
            s2 = g3._plots[i2], f3 = s2.xaxis, v3 = s2.yaxis;
            var nt = "M0,0";
            w2(f3, i2) && (B2 = k2(f3, "left", v3, x2), D2 = f3._offset - (B2 ? m3 + B2 : 0), N = k2(f3, "right", v3, x2), z2 = f3._offset + f3._length + (N ? m3 + N : 0), R = _2(f3, v3, "bottom"), F2 = _2(f3, v3, "top"), !(W = !f3._anchorAxis || i2 !== f3._mainSubplot) || "allticks" !== f3.mirror && "all" !== f3.mirror || (f3._linepositions[i2] = [R, F2]), nt = rt(f3, $, Q), W && f3.showline && ("all" === f3.mirror || "allticks" === f3.mirror) && (nt += $(R) + $(F2)), s2.xlines.style("stroke-width", f3._lw + "px").call(u2.stroke, f3.showline ? f3.linecolor : "rgba(0,0,0,0)")), s2.xlines.attr("d", nt);
            var it = "M0,0";
            w2(v3, i2) && (H2 = k2(v3, "bottom", f3, x2), j = v3._offset + v3._length + (H2 ? m3 : 0), G2 = k2(v3, "top", f3, x2), U = v3._offset - (G2 ? m3 : 0), V = _2(v3, f3, "left"), q2 = _2(v3, f3, "right"), !(W = !v3._anchorAxis || i2 !== v3._mainSubplot) || "allticks" !== v3.mirror && "all" !== v3.mirror || (v3._linepositions[i2] = [V, q2]), it = rt(v3, tt2, et), W && v3.showline && ("all" === v3.mirror || "allticks" === v3.mirror) && (it += tt2(V) + tt2(q2)), s2.ylines.style("stroke-width", v3._lw + "px").call(u2.stroke, v3.showline ? v3.linecolor : "rgba(0,0,0,0)")), s2.ylines.attr("d", it);
          }
          return p2.makeClipPaths(t3), a.previousPromises(t3);
        }
        function w2(t3, e4) {
          return (t3.ticks || t3.showline) && (e4 === t3._mainSubplot || "all" === t3.mirror || "allticks" === t3.mirror);
        }
        function T(t3, e4, r4) {
          if (!r4.showline || !r4._lw)
            return false;
          if ("all" === r4.mirror || "allticks" === r4.mirror)
            return true;
          var n3 = r4._anchorAxis;
          if (!n3)
            return false;
          var i2 = d2.FROM_BL[e4];
          return r4.side === e4 ? n3.domain[i2] === t3.domain[i2] : r4.mirror && n3.domain[1 - i2] === t3.domain[1 - i2];
        }
        function k2(t3, e4, r4, n3) {
          if (T(t3, e4, r4))
            return r4._lw;
          for (var i2 = 0; i2 < n3.length; i2++) {
            var a2 = n3[i2];
            if (a2._mainAxis === r4._mainAxis && T(t3, e4, a2))
              return a2._lw;
          }
          return 0;
        }
        e3.layoutStyles = function(t3) {
          return o.syncOrAsync([a.doAutoMargin, _], t3);
        }, e3.drawMainTitle = function(t3) {
          var e4, r4 = t3._fullLayout.title, i2 = t3._fullLayout, l3 = function(t4) {
            var e5 = t4.title, r5 = "middle";
            return o.isRightAnchor(e5) ? r5 = "end" : o.isLeftAnchor(e5) && (r5 = x), r5;
          }(i2), u3 = function(t4) {
            var e5 = t4.title, r5 = "0em";
            return o.isTopAnchor(e5) ? r5 = d2.CAP_SHIFT + "em" : o.isMiddleAnchor(e5) && (r5 = d2.MID_SHIFT + "em"), r5;
          }(i2), h3 = function(t4, e5) {
            var r5 = t4.title, n3 = t4._size, i3 = 0;
            return "0em" !== e5 && e5 ? e5 === d2.CAP_SHIFT + "em" && (i3 = r5.pad.t) : i3 = -r5.pad.b, "auto" === r5.y ? n3.t / 2 : "paper" === r5.yref ? n3.t + n3.h - n3.h * r5.y + i3 : t4.height - t4.height * r5.y + i3;
          }(i2, u3), p3 = function(t4, e5) {
            var r5 = t4.title, n3 = t4._size, i3 = 0;
            return e5 === x ? i3 = r5.pad.l : "end" === e5 && (i3 = -r5.pad.r), "paper" === r5.xref ? n3.l + n3.w * r5.x + i3 : t4.width * r5.x + i3;
          }(i2, l3);
          if (f2.draw(t3, "gtitle", { propContainer: i2, propName: "title.text", placeholder: i2._dfltTitle.plot, attributes: { x: p3, y: h3, "text-anchor": l3, dy: u3 } }), r4.text && r4.automargin) {
            var v3 = n2.selectAll(".gtitle"), g3 = c2.bBox(v3.node()).height, y3 = function(t4, e5, r5) {
              var n3 = e5.y, i3 = e5.yanchor, a2 = n3 > 0.5 ? "t" : "b", o2 = t4._fullLayout.margin[a2], s2 = 0;
              return "paper" === e5.yref ? s2 = r5 + e5.pad.t + e5.pad.b : "container" === e5.yref && (s2 = function(t5, e6, r6, n4, i4) {
                var a3 = 0;
                return "middle" === r6 && (a3 += i4 / 2), "t" === t5 ? ("top" === r6 && (a3 += i4), a3 += n4 - e6 * n4) : ("bottom" === r6 && (a3 += i4), a3 += e6 * n4), a3;
              }(a2, n3, i3, t4._fullLayout.height, r5) + e5.pad.t + e5.pad.b), s2 > o2 ? s2 : 0;
            }(t3, r4, g3);
            if (y3 > 0) {
              !function(t4, e5, r5, n3) {
                var i3 = "title.automargin", s2 = t4._fullLayout.title, l4 = s2.y > 0.5 ? "t" : "b", u4 = { x: s2.x, y: s2.y, t: 0, b: 0 }, c3 = {};
                "paper" === s2.yref && function(t5, e6, r6, n4, i4) {
                  var a2 = "paper" === e6.yref ? t5._fullLayout._size.h : t5._fullLayout.height, s3 = o.isTopAnchor(e6) ? n4 : n4 - i4, l5 = "b" === r6 ? a2 - s3 : s3;
                  return !(o.isTopAnchor(e6) && "t" === r6 || o.isBottomAnchor(e6) && "b" === r6) && l5 < i4;
                }(t4, s2, l4, e5, n3) ? u4[l4] = r5 : "container" === s2.yref && (c3[l4] = r5, t4._fullLayout._reservedMargin[i3] = c3), a.allowAutoMargin(t4, i3), a.autoMargin(t4, i3, u4);
              }(t3, h3, y3, g3), v3.attr({ x: p3, y: h3, "text-anchor": l3, dy: (e4 = r4.yanchor, "top" === e4 ? d2.CAP_SHIFT + 0.3 + "em" : "bottom" === e4 ? "-0.3em" : d2.MID_SHIFT + "em") }).call(s.positionText, p3, h3);
              var m3 = (r4.text.match(s.BR_TAG_ALL) || []).length;
              if (m3) {
                var b3 = d2.LINE_SPACING * m3 + d2.MID_SHIFT;
                0 === r4.y && (b3 = -b3), v3.selectAll(".line").each(function() {
                  var t4 = +this.getAttribute("dy").slice(0, -2) - b3 + "em";
                  this.setAttribute("dy", t4);
                });
              }
            }
          }
        }, e3.doTraceStyle = function(t3) {
          var r4, n3 = t3.calcdata, o2 = [];
          for (r4 = 0; r4 < n3.length; r4++) {
            var s2 = n3[r4], u3 = s2[0] || {}, c3 = u3.trace || {}, f3 = c3._module || {}, h3 = f3.arraysToCalcdata;
            h3 && h3(s2, c3);
            var p3 = f3.editStyle;
            p3 && o2.push({ fn: p3, cd0: u3 });
          }
          if (o2.length) {
            for (r4 = 0; r4 < o2.length; r4++) {
              var d3 = o2[r4];
              d3.fn(t3, d3.cd0);
            }
            l2(t3), e3.redrawReglTraces(t3);
          }
          return a.style(t3), i.getComponentMethod("legend", "draw")(t3), a.previousPromises(t3);
        }, e3.doColorBars = function(t3) {
          return i.getComponentMethod("colorbar", "draw")(t3), a.previousPromises(t3);
        }, e3.layoutReplot = function(t3) {
          var e4 = t3.layout;
          return t3.layout = void 0, i.call("_doPlot", t3, "", e4);
        }, e3.doLegend = function(t3) {
          return i.getComponentMethod("legend", "draw")(t3), a.previousPromises(t3);
        }, e3.doTicksRelayout = function(t3) {
          return p2.draw(t3, "redraw"), t3._fullLayout._hasOnlyLargeSploms && (i.subplotsRegistry.splom.updateGrid(t3), l2(t3), e3.redrawReglTraces(t3)), e3.drawMainTitle(t3), a.previousPromises(t3);
        }, e3.doModeBar = function(t3) {
          var e4 = t3._fullLayout;
          h2.manage(t3);
          for (var r4 = 0; r4 < e4._basePlotModules.length; r4++) {
            var n3 = e4._basePlotModules[r4].updateFx;
            n3 && n3(t3);
          }
          return a.previousPromises(t3);
        }, e3.doCamera = function(t3) {
          for (var e4 = t3._fullLayout, r4 = e4._subplots.gl3d, n3 = 0; n3 < r4.length; n3++) {
            var i2 = e4[r4[n3]];
            i2._scene.setViewport(i2);
          }
        }, e3.drawData = function(t3) {
          var r4 = t3._fullLayout;
          l2(t3);
          for (var n3 = r4._basePlotModules, o2 = 0; o2 < n3.length; o2++)
            n3[o2].plot(t3);
          return e3.redrawReglTraces(t3), a.style(t3), i.getComponentMethod("selections", "draw")(t3), i.getComponentMethod("shapes", "draw")(t3), i.getComponentMethod("annotations", "draw")(t3), i.getComponentMethod("images", "draw")(t3), r4._replotting = false, a.previousPromises(t3);
        }, e3.redrawReglTraces = function(t3) {
          var e4 = t3._fullLayout;
          if (e4._has("regl")) {
            var r4, n3, i2 = t3._fullData, a2 = [], s2 = [];
            for (e4._hasOnlyLargeSploms && e4._splomGrid.draw(), r4 = 0; r4 < i2.length; r4++) {
              var l3 = i2[r4];
              true === l3.visible && 0 !== l3._length && ("splom" === l3.type ? e4._splomScenes[l3.uid].draw() : "scattergl" === l3.type ? o.pushUnique(a2, l3.xaxis + l3.yaxis) : "scatterpolargl" === l3.type && o.pushUnique(s2, l3.subplot));
            }
            for (r4 = 0; r4 < a2.length; r4++)
              (n3 = e4._plots[a2[r4]])._scene && n3._scene.draw();
            for (r4 = 0; r4 < s2.length; r4++)
              (n3 = e4[s2[r4]]._subplot)._scene && n3._scene.draw();
          }
        }, e3.doAutoRangeAndConstraints = function(t3) {
          for (var e4, r4 = p2.list(t3, "", true), n3 = {}, i2 = 0; i2 < r4.length; i2++)
            if (!n3[(e4 = r4[i2])._id]) {
              n3[e4._id] = 1, y2(t3, e4), m2(t3, e4);
              var a2 = e4._matchGroup;
              if (a2)
                for (var o2 in a2) {
                  var s2 = p2.getFromId(t3, o2);
                  m2(t3, s2, e4.range), n3[o2] = 1;
                }
            }
          g2(t3);
        }, e3.finalDraw = function(t3) {
          i.getComponentMethod("rangeslider", "draw")(t3), i.getComponentMethod("rangeselector", "draw")(t3);
        }, e3.drawMarginPushers = function(t3) {
          i.getComponentMethod("legend", "draw")(t3), i.getComponentMethod("rangeselector", "draw")(t3), i.getComponentMethod("sliders", "draw")(t3), i.getComponentMethod("updatemenus", "draw")(t3), i.getComponentMethod("colorbar", "draw")(t3);
        };
      }, 94828: function(t2, e3, r3) {
        var n2 = r3(3400), i = n2.isPlainObject, a = r3(73060), o = r3(7316), s = r3(45464), l2 = r3(31780), u2 = r3(20556).dfltConfig;
        function c2(t3, e4) {
          t3 = n2.extendDeep({}, t3);
          var r4, a2, o2 = Object.keys(t3).sort();
          function s2(e5, r5, n3) {
            if (i(r5) && i(e5))
              c2(e5, r5);
            else if (Array.isArray(r5) && Array.isArray(e5)) {
              var o3 = l2.arrayTemplater({ _template: t3 }, n3);
              for (a2 = 0; a2 < r5.length; a2++) {
                var s3 = r5[a2], u4 = o3.newItem(s3)._template;
                u4 && c2(u4, s3);
              }
              var f3 = o3.defaultItems();
              for (a2 = 0; a2 < f3.length; a2++)
                r5.push(f3[a2]._template);
              for (a2 = 0; a2 < r5.length; a2++)
                delete r5[a2].templateitemname;
            }
          }
          for (r4 = 0; r4 < o2.length; r4++) {
            var u3 = o2[r4], h3 = t3[u3];
            if (u3 in e4 ? s2(h3, e4[u3], u3) : e4[u3] = h3, f2(u3) === u3)
              for (var p3 in e4) {
                var d3 = f2(p3);
                p3 === d3 || d3 !== u3 || p3 in t3 || s2(h3, e4[p3], u3);
              }
          }
        }
        function f2(t3) {
          return t3.replace(/[0-9]+$/, "");
        }
        function h2(t3, e4, r4, a2, o2) {
          var s2 = o2 && r4(o2);
          for (var u3 in t3) {
            var c3 = t3[u3], p3 = v2(t3, u3, a2), d3 = v2(t3, u3, o2), g3 = r4(d3);
            if (!g3) {
              var y3 = f2(u3);
              y3 !== u3 && (g3 = r4(d3 = v2(t3, y3, o2)));
            }
            if (!(s2 && s2 === g3 || !g3 || g3._noTemplating || "data_array" === g3.valType || g3.arrayOk && Array.isArray(c3)))
              if (!g3.valType && i(c3))
                h2(c3, e4, r4, p3, d3);
              else if (g3._isLinkedToArray && Array.isArray(c3))
                for (var m2 = false, x = 0, b2 = {}, _ = 0; _ < c3.length; _++) {
                  var w2 = c3[_];
                  if (i(w2)) {
                    var T = w2.name;
                    if (T)
                      b2[T] || (h2(w2, e4, r4, v2(c3, x, p3), v2(c3, x, d3)), x++, b2[T] = 1);
                    else if (!m2) {
                      var k2 = v2(t3, l2.arrayDefaultKey(u3), a2), A2 = v2(c3, x, p3);
                      h2(w2, e4, r4, A2, v2(c3, x, d3));
                      var M = n2.nestedProperty(e4, A2);
                      n2.nestedProperty(e4, k2).set(M.get()), M.set(null), m2 = true;
                    }
                  }
                }
              else
                n2.nestedProperty(e4, p3).set(c3);
          }
        }
        function p2(t3, e4) {
          return a.getLayoutValObject(t3, n2.nestedProperty({}, e4).parts);
        }
        function d2(t3, e4) {
          return a.getTraceValObject(t3, n2.nestedProperty({}, e4).parts);
        }
        function v2(t3, e4, r4) {
          return r4 ? Array.isArray(t3) ? r4 + "[" + e4 + "]" : r4 + "." + e4 : e4;
        }
        function g2(t3) {
          for (var e4 = 0; e4 < t3.length; e4++)
            if (i(t3[e4]))
              return true;
        }
        function y2(t3) {
          var e4;
          switch (t3.code) {
            case "data":
              e4 = "The template has no key data.";
              break;
            case "layout":
              e4 = "The template has no key layout.";
              break;
            case "missing":
              e4 = t3.path ? "There are no templates for item " + t3.path + " with name " + t3.templateitemname : "There are no templates for trace " + t3.index + ", of type " + t3.traceType + ".";
              break;
            case "unused":
              e4 = t3.path ? "The template item at " + t3.path + " was not used in constructing the plot." : t3.dataCount ? "Some of the templates of type " + t3.traceType + " were not used. The template has " + t3.templateCount + " traces, the data only has " + t3.dataCount + " of this type." : "The template has " + t3.templateCount + " traces of type " + t3.traceType + " but there are none in the data.";
              break;
            case "reused":
              e4 = "Some of the templates of type " + t3.traceType + " were used more than once. The template has " + t3.templateCount + " traces, the data has " + t3.dataCount + " of this type.";
          }
          return t3.msg = e4, t3;
        }
        e3.makeTemplate = function(t3) {
          t3 = n2.isPlainObject(t3) ? t3 : n2.getGraphDiv(t3), t3 = n2.extendDeep({ _context: u2 }, { data: t3.data, layout: t3.layout }), o.supplyDefaults(t3);
          var e4 = t3.data || [], r4 = t3.layout || {};
          r4._basePlotModules = t3._fullLayout._basePlotModules, r4._modules = t3._fullLayout._modules;
          var a2 = { data: {}, layout: {} };
          e4.forEach(function(t4) {
            var e5 = {};
            h2(t4, e5, d2.bind(null, t4));
            var r5 = n2.coerce(t4, {}, s, "type"), i2 = a2.data[r5];
            i2 || (i2 = a2.data[r5] = []), i2.push(e5);
          }), h2(r4, a2.layout, p2.bind(null, r4)), delete a2.layout.template;
          var l3 = r4.template;
          if (i(l3)) {
            var f3, v3, g3, y3, m2, x, b2 = l3.layout;
            i(b2) && c2(b2, a2.layout);
            var _ = l3.data;
            if (i(_)) {
              for (v3 in a2.data)
                if (g3 = _[v3], Array.isArray(g3)) {
                  for (x = (m2 = a2.data[v3]).length, y3 = g3.length, f3 = 0; f3 < x; f3++)
                    c2(g3[f3 % y3], m2[f3]);
                  for (f3 = x; f3 < y3; f3++)
                    m2.push(n2.extendDeep({}, g3[f3]));
                }
              for (v3 in _)
                v3 in a2.data || (a2.data[v3] = n2.extendDeep([], _[v3]));
            }
          }
          return a2;
        }, e3.validateTemplate = function(t3, e4) {
          var r4 = n2.extendDeep({}, { _context: u2, data: t3.data, layout: t3.layout }), a2 = r4.layout || {};
          i(e4) || (e4 = a2.template || {});
          var s2 = e4.layout, l3 = e4.data, c3 = [];
          r4.layout = a2, r4.layout.template = e4, o.supplyDefaults(r4);
          var h3 = r4._fullLayout, p3 = r4._fullData, d3 = {};
          if (i(s2) ? (function t4(e5, r5) {
            for (var n3 in e5)
              if ("_" !== n3.charAt(0) && i(e5[n3])) {
                var a3, o2 = f2(n3), s3 = [];
                for (a3 = 0; a3 < r5.length; a3++)
                  s3.push(v2(e5, n3, r5[a3])), o2 !== n3 && s3.push(v2(e5, o2, r5[a3]));
                for (a3 = 0; a3 < s3.length; a3++)
                  d3[s3[a3]] = 1;
                t4(e5[n3], s3);
              }
          }(h3, ["layout"]), function t4(e5, r5) {
            for (var n3 in e5)
              if (-1 === n3.indexOf("defaults") && i(e5[n3])) {
                var a3 = v2(e5, n3, r5);
                d3[a3] ? t4(e5[n3], a3) : c3.push({ code: "unused", path: a3 });
              }
          }(s2, "layout")) : c3.push({ code: "layout" }), i(l3)) {
            for (var m2, x = {}, b2 = 0; b2 < p3.length; b2++) {
              var _ = p3[b2];
              x[m2 = _.type] = (x[m2] || 0) + 1, _._fullInput._template || c3.push({ code: "missing", index: _._fullInput.index, traceType: m2 });
            }
            for (m2 in l3) {
              var w2 = l3[m2].length, T = x[m2] || 0;
              w2 > T ? c3.push({ code: "unused", traceType: m2, templateCount: w2, dataCount: T }) : T > w2 && c3.push({ code: "reused", traceType: m2, templateCount: w2, dataCount: T });
            }
          } else
            c3.push({ code: "data" });
          if (function t4(e5, r5) {
            for (var n3 in e5)
              if ("_" !== n3.charAt(0)) {
                var a3 = e5[n3], o2 = v2(e5, n3, r5);
                i(a3) ? (Array.isArray(e5) && false === a3._template && a3.templateitemname && c3.push({ code: "missing", path: o2, templateitemname: a3.templateitemname }), t4(a3, o2)) : Array.isArray(a3) && g2(a3) && t4(a3, o2);
              }
          }({ data: p3, layout: h3 }, ""), c3.length)
            return c3.map(y2);
        };
      }, 67024: function(t2, e3, r3) {
        var n2 = r3(38248), i = r3(36424), a = r3(7316), o = r3(3400), s = r3(81792), l2 = r3(37164), u2 = r3(63268), c2 = r3(25788).version, f2 = { format: { valType: "enumerated", values: ["png", "jpeg", "webp", "svg", "full-json"], dflt: "png" }, width: { valType: "number", min: 1 }, height: { valType: "number", min: 1 }, scale: { valType: "number", min: 0, dflt: 1 }, setBackground: { valType: "any", dflt: false }, imageDataOnly: { valType: "boolean", dflt: false } };
        t2.exports = function(t3, e4) {
          var r4, h2, p2, d2;
          function v2(t4) {
            return !(t4 in e4) || o.validate(e4[t4], f2[t4]);
          }
          if (e4 = e4 || {}, o.isPlainObject(t3) ? (r4 = t3.data || [], h2 = t3.layout || {}, p2 = t3.config || {}, d2 = {}) : (t3 = o.getGraphDiv(t3), r4 = o.extendDeep([], t3.data), h2 = o.extendDeep({}, t3.layout), p2 = t3._context, d2 = t3._fullLayout || {}), !v2("width") && null !== e4.width || !v2("height") && null !== e4.height)
            throw new Error("Height and width should be pixel values.");
          if (!v2("format"))
            throw new Error("Export format is not " + o.join2(f2.format.values, ", ", " or ") + ".");
          var g2 = {};
          function y2(t4, r5) {
            return o.coerce(e4, g2, f2, t4, r5);
          }
          var m2 = y2("format"), x = y2("width"), b2 = y2("height"), _ = y2("scale"), w2 = y2("setBackground"), T = y2("imageDataOnly"), k2 = document.createElement("div");
          k2.style.position = "absolute", k2.style.left = "-5000px", document.body.appendChild(k2);
          var A2 = o.extendFlat({}, h2);
          x ? A2.width = x : null === e4.width && n2(d2.width) && (A2.width = d2.width), b2 ? A2.height = b2 : null === e4.height && n2(d2.height) && (A2.height = d2.height);
          var M = o.extendFlat({}, p2, { _exportedPlot: true, staticPlot: true, setBackground: w2 }), S = s.getRedrawFunc(k2);
          function E2() {
            return new Promise(function(t4) {
              setTimeout(t4, s.getDelay(k2._fullLayout));
            });
          }
          function L() {
            return new Promise(function(t4, e5) {
              var r5 = l2(k2, m2, _), n3 = k2._fullLayout.width, f3 = k2._fullLayout.height;
              function h3() {
                i.purge(k2), document.body.removeChild(k2);
              }
              if ("full-json" === m2) {
                var p3 = a.graphJson(k2, false, "keepdata", "object", true, true);
                return p3.version = c2, p3 = JSON.stringify(p3), h3(), t4(T ? p3 : s.encodeJSON(p3));
              }
              if (h3(), "svg" === m2)
                return t4(T ? r5 : s.encodeSVG(r5));
              var d3 = document.createElement("canvas");
              d3.id = o.randstr(), u2({ format: m2, width: n3, height: f3, scale: _, canvas: d3, svg: r5, promise: true }).then(t4).catch(e5);
            });
          }
          return new Promise(function(t4, e5) {
            i.newPlot(k2, r4, A2, M).then(S).then(E2).then(L).then(function(e6) {
              t4(function(t5) {
                return T ? t5.replace(s.IMAGE_URL_PREFIX, "") : t5;
              }(e6));
            }).catch(function(t5) {
              e5(t5);
            });
          });
        };
      }, 21480: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(7316), a = r3(73060), o = r3(20556).dfltConfig, s = n2.isPlainObject, l2 = Array.isArray, u2 = n2.isArrayOrTypedArray;
        function c2(t3, e4, r4, i2, a2, o2) {
          o2 = o2 || [];
          for (var f3 = Object.keys(t3), h3 = 0; h3 < f3.length; h3++) {
            var g3 = f3[h3];
            if ("transforms" !== g3) {
              var y3 = o2.slice();
              y3.push(g3);
              var m2 = t3[g3], x = e4[g3], b2 = v2(r4, g3), _ = (b2 || {}).valType, w2 = "info_array" === _, T = "colorscale" === _, k2 = (b2 || {}).items;
              if (d2(r4, g3))
                if (s(m2) && s(x) && "any" !== _)
                  c2(m2, x, b2, i2, a2, y3);
                else if (w2 && l2(m2)) {
                  m2.length > x.length && i2.push(p2("unused", a2, y3.concat(x.length)));
                  var A2, M, S, E2, L, C2 = x.length, P = Array.isArray(k2);
                  if (P && (C2 = Math.min(C2, k2.length)), 2 === b2.dimensions)
                    for (M = 0; M < C2; M++)
                      if (l2(m2[M])) {
                        m2[M].length > x[M].length && i2.push(p2("unused", a2, y3.concat(M, x[M].length)));
                        var O = x[M].length;
                        for (A2 = 0; A2 < (P ? Math.min(O, k2[M].length) : O); A2++)
                          S = P ? k2[M][A2] : k2, E2 = m2[M][A2], L = x[M][A2], n2.validate(E2, S) ? L !== E2 && L !== +E2 && i2.push(p2("dynamic", a2, y3.concat(M, A2), E2, L)) : i2.push(p2("value", a2, y3.concat(M, A2), E2));
                      } else
                        i2.push(p2("array", a2, y3.concat(M), m2[M]));
                  else
                    for (M = 0; M < C2; M++)
                      S = P ? k2[M] : k2, E2 = m2[M], L = x[M], n2.validate(E2, S) ? L !== E2 && L !== +E2 && i2.push(p2("dynamic", a2, y3.concat(M), E2, L)) : i2.push(p2("value", a2, y3.concat(M), E2));
                } else if (b2.items && !w2 && l2(m2)) {
                  var I2, D2, z2 = k2[Object.keys(k2)[0]], R = [];
                  for (I2 = 0; I2 < x.length; I2++) {
                    var F2 = x[I2]._index || I2;
                    if ((D2 = y3.slice()).push(F2), s(m2[F2]) && s(x[I2])) {
                      R.push(F2);
                      var B2 = m2[F2], N = x[I2];
                      s(B2) && false !== B2.visible && false === N.visible ? i2.push(p2("invisible", a2, D2)) : c2(B2, N, z2, i2, a2, D2);
                    }
                  }
                  for (I2 = 0; I2 < m2.length; I2++)
                    (D2 = y3.slice()).push(I2), s(m2[I2]) ? -1 === R.indexOf(I2) && i2.push(p2("unused", a2, D2)) : i2.push(p2("object", a2, D2, m2[I2]));
                } else
                  !s(m2) && s(x) ? i2.push(p2("object", a2, y3, m2)) : u2(m2) || !u2(x) || w2 || T ? g3 in e4 ? n2.validate(m2, b2) ? "enumerated" === b2.valType && (b2.coerceNumber && m2 !== +x || m2 !== x) && i2.push(p2("dynamic", a2, y3, m2, x)) : i2.push(p2("value", a2, y3, m2)) : i2.push(p2("unused", a2, y3, m2)) : i2.push(p2("array", a2, y3, m2));
              else
                i2.push(p2("schema", a2, y3));
            }
          }
          return i2;
        }
        t2.exports = function(t3, e4) {
          void 0 === t3 && (t3 = []), void 0 === e4 && (e4 = {});
          var r4, u3, f3 = a.get(), h3 = [], d3 = { _context: n2.extendFlat({}, o) };
          l2(t3) ? (d3.data = n2.extendDeep([], t3), r4 = t3) : (d3.data = [], r4 = [], h3.push(p2("array", "data"))), s(e4) ? (d3.layout = n2.extendDeep({}, e4), u3 = e4) : (d3.layout = {}, u3 = {}, arguments.length > 1 && h3.push(p2("object", "layout"))), i.supplyDefaults(d3);
          for (var v3 = d3._fullData, g3 = r4.length, y3 = 0; y3 < g3; y3++) {
            var m2 = r4[y3], x = ["data", y3];
            if (s(m2)) {
              var b2 = v3[y3], _ = b2.type, w2 = f3.traces[_].attributes;
              w2.type = { valType: "enumerated", values: [_] }, false === b2.visible && false !== m2.visible && h3.push(p2("invisible", x)), c2(m2, b2, w2, h3, x);
              var T = m2.transforms, k2 = b2.transforms;
              if (T) {
                l2(T) || h3.push(p2("array", x, ["transforms"])), x.push("transforms");
                for (var A2 = 0; A2 < T.length; A2++) {
                  var M = ["transforms", A2], S = T[A2].type;
                  if (s(T[A2])) {
                    var E2 = f3.transforms[S] ? f3.transforms[S].attributes : {};
                    E2.type = { valType: "enumerated", values: Object.keys(f3.transforms) }, c2(T[A2], k2[A2], E2, h3, x, M);
                  } else
                    h3.push(p2("object", x, M));
                }
              }
            } else
              h3.push(p2("object", x));
          }
          var L = d3._fullLayout, C2 = function(t4, e5) {
            for (var r5 = t4.layout.layoutAttributes, i2 = 0; i2 < e5.length; i2++) {
              var a2 = e5[i2], o2 = t4.traces[a2.type], s2 = o2.layoutAttributes;
              s2 && (a2.subplot ? n2.extendFlat(r5[o2.attributes.subplot.dflt], s2) : n2.extendFlat(r5, s2));
            }
            return r5;
          }(f3, v3);
          return c2(u3, L, C2, h3, "layout"), 0 === h3.length ? void 0 : h3;
        };
        var f2 = { object: function(t3, e4) {
          return ("layout" === t3 && "" === e4 ? "The layout argument" : "data" === t3[0] && "" === e4 ? "Trace " + t3[1] + " in the data argument" : h2(t3) + "key " + e4) + " must be linked to an object container";
        }, array: function(t3, e4) {
          return ("data" === t3 ? "The data argument" : h2(t3) + "key " + e4) + " must be linked to an array container";
        }, schema: function(t3, e4) {
          return h2(t3) + "key " + e4 + " is not part of the schema";
        }, unused: function(t3, e4, r4) {
          var n3 = s(r4) ? "container" : "key";
          return h2(t3) + n3 + " " + e4 + " did not get coerced";
        }, dynamic: function(t3, e4, r4, n3) {
          return [h2(t3) + "key", e4, "(set to '" + r4 + "')", "got reset to", "'" + n3 + "'", "during defaults."].join(" ");
        }, invisible: function(t3, e4) {
          return (e4 ? h2(t3) + "item " + e4 : "Trace " + t3[1]) + " got defaulted to be not visible";
        }, value: function(t3, e4, r4) {
          return [h2(t3) + "key " + e4, "is set to an invalid value (" + r4 + ")"].join(" ");
        } };
        function h2(t3) {
          return l2(t3) ? "In data trace " + t3[1] + ", " : "In " + t3 + ", ";
        }
        function p2(t3, e4, r4, i2, a2) {
          var o2, s2;
          r4 = r4 || "", l2(e4) ? (o2 = e4[0], s2 = e4[1]) : (o2 = e4, s2 = null);
          var u3 = function(t4) {
            if (!l2(t4))
              return String(t4);
            for (var e5 = "", r5 = 0; r5 < t4.length; r5++) {
              var n3 = t4[r5];
              "number" == typeof n3 ? e5 = e5.substr(0, e5.length - 1) + "[" + n3 + "]" : e5 += n3, r5 < t4.length - 1 && (e5 += ".");
            }
            return e5;
          }(r4), c3 = f2[t3](e4, u3, i2, a2);
          return n2.log(c3), { code: t3, container: o2, trace: s2, path: r4, astr: u3, msg: c3 };
        }
        function d2(t3, e4) {
          var r4 = y2(e4), n3 = r4.keyMinusId, i2 = r4.id;
          return !!(n3 in t3 && t3[n3]._isSubplotObj && i2) || e4 in t3;
        }
        function v2(t3, e4) {
          return e4 in t3 ? t3[e4] : t3[y2(e4).keyMinusId];
        }
        var g2 = n2.counterRegex("([a-z]+)");
        function y2(t3) {
          var e4 = t3.match(g2);
          return { keyMinusId: e4 && e4[1], id: e4 && e4[2] };
        }
      }, 85656: function(t2) {
        t2.exports = { mode: { valType: "enumerated", dflt: "afterall", values: ["immediate", "next", "afterall"] }, direction: { valType: "enumerated", values: ["forward", "reverse"], dflt: "forward" }, fromcurrent: { valType: "boolean", dflt: false }, frame: { duration: { valType: "number", min: 0, dflt: 500 }, redraw: { valType: "boolean", dflt: true } }, transition: { duration: { valType: "number", min: 0, dflt: 500, editType: "none" }, easing: { valType: "enumerated", dflt: "cubic-in-out", values: ["linear", "quad", "cubic", "sin", "exp", "circle", "elastic", "back", "bounce", "linear-in", "quad-in", "cubic-in", "sin-in", "exp-in", "circle-in", "elastic-in", "back-in", "bounce-in", "linear-out", "quad-out", "cubic-out", "sin-out", "exp-out", "circle-out", "elastic-out", "back-out", "bounce-out", "linear-in-out", "quad-in-out", "cubic-in-out", "sin-in-out", "exp-in-out", "circle-in-out", "elastic-in-out", "back-in-out", "bounce-in-out"], editType: "none" }, ordering: { valType: "enumerated", values: ["layout first", "traces first"], dflt: "layout first", editType: "none" } } };
      }, 51272: function(t2, e3, r3) {
        var n2 = r3(3400), i = r3(31780);
        t2.exports = function(t3, e4, r4) {
          var a, o, s = r4.name, l2 = r4.inclusionAttr || "visible", u2 = e4[s], c2 = n2.isArrayOrTypedArray(t3[s]) ? t3[s] : [], f2 = e4[s] = [], h2 = i.arrayTemplater(e4, s, l2);
          for (a = 0; a < c2.length; a++) {
            var p2 = c2[a];
            n2.isPlainObject(p2) ? o = h2.newItem(p2) : (o = h2.newItem({}))[l2] = false, o._index = a, false !== o[l2] && r4.handleItemDefaults(p2, o, e4, r4), f2.push(o);
          }
          var d2 = h2.defaultItems();
          for (a = 0; a < d2.length; a++)
            (o = d2[a])._index = f2.length, r4.handleItemDefaults({}, o, e4, r4, {}), f2.push(o);
          if (n2.isArrayOrTypedArray(u2)) {
            var v2 = Math.min(u2.length, f2.length);
            for (a = 0; a < v2; a++)
              n2.relinkPrivateKeys(f2[a], u2[a]);
          }
          return f2;
        };
      }, 45464: function(t2, e3, r3) {
        var n2 = r3(25376), i = r3(55756);
        t2.exports = { type: { valType: "enumerated", values: [], dflt: "scatter", editType: "calc+clearAxisTypes", _noTemplating: true }, visible: { valType: "enumerated", values: [true, false, "legendonly"], dflt: true, editType: "calc" }, showlegend: { valType: "boolean", dflt: true, editType: "style" }, legend: { valType: "subplotid", dflt: "legend", editType: "style" }, legendgroup: { valType: "string", dflt: "", editType: "style" }, legendgrouptitle: { text: { valType: "string", dflt: "", editType: "style" }, font: n2({ editType: "style" }), editType: "style" }, legendrank: { valType: "number", dflt: 1e3, editType: "style" }, legendwidth: { valType: "number", min: 0, editType: "style" }, opacity: { valType: "number", min: 0, max: 1, dflt: 1, editType: "style" }, name: { valType: "string", editType: "style" }, uid: { valType: "string", editType: "plot", anim: true }, ids: { valType: "data_array", editType: "calc", anim: true }, customdata: { valType: "data_array", editType: "calc" }, meta: { valType: "any", arrayOk: true, editType: "plot" }, selectedpoints: { valType: "any", editType: "calc" }, hoverinfo: { valType: "flaglist", flags: ["x", "y", "z", "text", "name"], extras: ["all", "none", "skip"], arrayOk: true, dflt: "all", editType: "none" }, hoverlabel: i.hoverlabel, stream: { token: { valType: "string", noBlank: true, strict: true, editType: "calc" }, maxpoints: { valType: "number", min: 0, max: 1e4, dflt: 500, editType: "calc" }, editType: "calc" }, transforms: { _isLinkedToArray: "transform", editType: "calc" }, uirevision: { valType: "any", editType: "none" } };
      }, 1220: function(t2, e3, r3) {
        var n2 = r3(38248), i = r3(3400), a = i.dateTime2ms, o = i.incrementMonth, s = r3(39032).ONEAVGMONTH;
        t2.exports = function(t3, e4, r4, i2) {
          if ("date" !== e4.type)
            return { vals: i2 };
          var l2 = t3[r4 + "periodalignment"];
          if (!l2)
            return { vals: i2 };
          var u2, c2 = t3[r4 + "period"];
          if (n2(c2)) {
            if ((c2 = +c2) <= 0)
              return { vals: i2 };
          } else if ("string" == typeof c2 && "M" === c2.charAt(0)) {
            var f2 = +c2.substring(1);
            if (!(f2 > 0 && Math.round(f2) === f2))
              return { vals: i2 };
            u2 = f2;
          }
          for (var h2 = e4.calendar, p2 = "start" === l2, d2 = "end" === l2, v2 = t3[r4 + "period0"], g2 = a(v2, h2) || 0, y2 = [], m2 = [], x = [], b2 = i2.length, _ = 0; _ < b2; _++) {
            var w2, T, k2, A2 = i2[_];
            if (u2) {
              for (w2 = Math.round((A2 - g2) / (u2 * s)), k2 = o(g2, u2 * w2, h2); k2 > A2; )
                k2 = o(k2, -u2, h2);
              for (; k2 <= A2; )
                k2 = o(k2, u2, h2);
              T = o(k2, -u2, h2);
            } else {
              for (k2 = g2 + (w2 = Math.round((A2 - g2) / c2)) * c2; k2 > A2; )
                k2 -= c2;
              for (; k2 <= A2; )
                k2 += c2;
              T = k2 - c2;
            }
            y2[_] = p2 ? T : d2 ? k2 : (T + k2) / 2, m2[_] = T, x[_] = k2;
          }
          return { vals: y2, starts: m2, ends: x };
        };
      }, 26720: function(t2) {
        t2.exports = { xaxis: { valType: "subplotid", dflt: "x", editType: "calc+clearAxisTypes" }, yaxis: { valType: "subplotid", dflt: "y", editType: "calc+clearAxisTypes" } };
      }, 19280: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(38248), a = r3(3400), o = r3(39032).FP_SAFE, s = r3(24040), l2 = r3(43616), u2 = r3(79811), c2 = u2.getFromId, f2 = u2.isLinked;
        function h2(t3, e4) {
          var r4, n3, i2 = [], o2 = t3._fullLayout, s2 = d2(o2, e4, 0), l3 = d2(o2, e4, 1), u3 = g2(t3, e4), c3 = u3.min, f3 = u3.max;
          if (0 === c3.length || 0 === f3.length)
            return a.simpleMap(e4.range, e4.r2l);
          var h3 = c3[0].val, v3 = f3[0].val;
          for (r4 = 1; r4 < c3.length && h3 === v3; r4++)
            h3 = Math.min(h3, c3[r4].val);
          for (r4 = 1; r4 < f3.length && h3 === v3; r4++)
            v3 = Math.max(v3, f3[r4].val);
          var y3 = e4.autorange, m3 = "reversed" === y3 || "min reversed" === y3 || "max reversed" === y3;
          if (!m3 && e4.range) {
            var x2 = a.simpleMap(e4.range, e4.r2l);
            m3 = x2[1] < x2[0];
          }
          "reversed" === e4.autorange && (e4.autorange = true);
          var b3, _2, w3, T2, A2, M, S = e4.rangemode, E2 = "tozero" === S, L = "nonnegative" === S, C2 = e4._length, P = C2 / 10, O = 0;
          for (r4 = 0; r4 < c3.length; r4++)
            for (b3 = c3[r4], n3 = 0; n3 < f3.length; n3++)
              (M = (_2 = f3[n3]).val - b3.val - p2(e4, b3.val, _2.val)) > 0 && ((A2 = C2 - s2(b3) - l3(_2)) > P ? M / A2 > O && (w3 = b3, T2 = _2, O = M / A2) : M / C2 > O && (w3 = { val: b3.val, nopad: 1 }, T2 = { val: _2.val, nopad: 1 }, O = M / C2));
          if (h3 === v3) {
            var I2 = h3 - 1, D2 = h3 + 1;
            if (E2)
              if (0 === h3)
                i2 = [0, 1];
              else {
                var z2 = (h3 > 0 ? f3 : c3).reduce(function(t4, e5) {
                  return Math.max(t4, l3(e5));
                }, 0), R = h3 / (1 - Math.min(0.5, z2 / C2));
                i2 = h3 > 0 ? [0, R] : [R, 0];
              }
            else
              i2 = L ? [Math.max(0, I2), Math.max(1, D2)] : [I2, D2];
          } else
            E2 ? (w3.val >= 0 && (w3 = { val: 0, nopad: 1 }), T2.val <= 0 && (T2 = { val: 0, nopad: 1 })) : L && (w3.val - O * s2(w3) < 0 && (w3 = { val: 0, nopad: 1 }), T2.val <= 0 && (T2 = { val: 1, nopad: 1 })), O = (T2.val - w3.val - p2(e4, b3.val, _2.val)) / (C2 - s2(w3) - l3(T2)), i2 = [w3.val - O * s2(w3), T2.val + O * l3(T2)];
          return i2 = k2(i2, e4), e4.limitRange && e4.limitRange(), m3 && i2.reverse(), a.simpleMap(i2, e4.l2r || Number);
        }
        function p2(t3, e4, r4) {
          var n3 = 0;
          if (t3.rangebreaks)
            for (var i2 = t3.locateBreaks(e4, r4), a2 = 0; a2 < i2.length; a2++) {
              var o2 = i2[a2];
              n3 += o2.max - o2.min;
            }
          return n3;
        }
        function d2(t3, e4, r4) {
          var i2 = 0.05 * e4._length, o2 = e4._anchorAxis || {};
          if (-1 !== (e4.ticklabelposition || "").indexOf("inside") || -1 !== (o2.ticklabelposition || "").indexOf("inside")) {
            var s2 = e4.isReversed();
            if (!s2) {
              var u3 = a.simpleMap(e4.range, e4.r2l);
              s2 = u3[1] < u3[0];
            }
            s2 && (r4 = !r4);
          }
          var c3 = 0;
          return f2(t3, e4._id) || (c3 = function(t4, e5, r5) {
            var i3 = 0, o3 = "x" === e5._id.charAt(0);
            for (var s3 in t4._plots) {
              var u4 = t4._plots[s3];
              if (e5._id === u4.xaxis._id || e5._id === u4.yaxis._id) {
                var c4 = (o3 ? u4.yaxis : u4.xaxis) || {};
                if (-1 !== (c4.ticklabelposition || "").indexOf("inside") && (!r5 && ("left" === c4.side || "bottom" === c4.side) || r5 && ("top" === c4.side || "right" === c4.side))) {
                  if (c4._vals) {
                    var f3 = a.deg2rad(c4._tickAngles[c4._id + "tick"] || 0), h3 = Math.abs(Math.cos(f3)), p3 = Math.abs(Math.sin(f3));
                    if (!c4._vals[0].bb) {
                      var d3 = c4._id + "tick";
                      c4._selections[d3].each(function(t5) {
                        var e6 = n2.select(this);
                        e6.select(".text-math-group").empty() && (t5.bb = l2.bBox(e6.node()));
                      });
                    }
                    for (var g3 = 0; g3 < c4._vals.length; g3++) {
                      var y3 = c4._vals[g3].bb;
                      if (y3) {
                        var m3 = 2 * v2 + y3.width, x2 = 2 * v2 + y3.height;
                        i3 = Math.max(i3, o3 ? Math.max(m3 * h3, x2 * p3) : Math.max(x2 * h3, m3 * p3));
                      }
                    }
                  }
                  "inside" === c4.ticks && "inside" === c4.ticklabelposition && (i3 += c4.ticklen || 0);
                }
              }
            }
            return i3;
          }(t3, e4, r4)), i2 = Math.max(c3, i2), "domain" === e4.constrain && e4._inputDomain && (i2 *= (e4._inputDomain[1] - e4._inputDomain[0]) / (e4.domain[1] - e4.domain[0])), function(t4) {
            return t4.nopad ? 0 : t4.pad + (t4.extrapad ? i2 : c3);
          };
        }
        t2.exports = { applyAutorangeOptions: k2, getAutoRange: h2, makePadFn: d2, doAutoRange: function(t3, e4, r4) {
          if (e4.setScale(), e4.autorange) {
            e4.range = r4 ? r4.slice() : h2(t3, e4), e4._r = e4.range.slice(), e4._rl = a.simpleMap(e4._r, e4.r2l);
            var n3 = e4._input, i2 = {};
            i2[e4._attr + ".range"] = e4.range, i2[e4._attr + ".autorange"] = e4.autorange, s.call("_storeDirectGUIEdit", t3.layout, t3._fullLayout._preGUI, i2), n3.range = e4.range.slice(), n3.autorange = e4.autorange;
          }
          var o2 = e4._anchorAxis;
          if (o2 && o2.rangeslider) {
            var l3 = o2.rangeslider[e4._name];
            l3 && "auto" === l3.rangemode && (l3.range = h2(t3, e4)), o2._input.rangeslider[e4._name] = a.extendFlat({}, l3);
          }
        }, findExtremes: function(t3, e4, r4) {
          r4 || (r4 = {}), t3._m || t3.setScale();
          var n3, a2, s2, l3, u3, c3, f3, h3, p3, d3 = [], v3 = [], g3 = e4.length, x2 = r4.padded || false, _2 = r4.tozero && ("linear" === t3.type || "-" === t3.type), w3 = "log" === t3.type, T2 = false, k3 = r4.vpadLinearized || false;
          function A2(t4) {
            if (Array.isArray(t4))
              return T2 = true, function(e6) {
                return Math.max(Number(t4[e6] || 0), 0);
              };
            var e5 = Math.max(Number(t4 || 0), 0);
            return function() {
              return e5;
            };
          }
          var M = A2((t3._m > 0 ? r4.ppadplus : r4.ppadminus) || r4.ppad || 0), S = A2((t3._m > 0 ? r4.ppadminus : r4.ppadplus) || r4.ppad || 0), E2 = A2(r4.vpadplus || r4.vpad), L = A2(r4.vpadminus || r4.vpad);
          if (!T2) {
            if (h3 = 1 / 0, p3 = -1 / 0, w3)
              for (n3 = 0; n3 < g3; n3++)
                (a2 = e4[n3]) < h3 && a2 > 0 && (h3 = a2), a2 > p3 && a2 < o && (p3 = a2);
            else
              for (n3 = 0; n3 < g3; n3++)
                (a2 = e4[n3]) < h3 && a2 > -o && (h3 = a2), a2 > p3 && a2 < o && (p3 = a2);
            e4 = [h3, p3], g3 = 2;
          }
          var C2 = { tozero: _2, extrapad: x2 };
          function P(r5) {
            s2 = e4[r5], i(s2) && (c3 = M(r5), f3 = S(r5), k3 ? (l3 = t3.c2l(s2) - L(r5), u3 = t3.c2l(s2) + E2(r5)) : (h3 = s2 - L(r5), p3 = s2 + E2(r5), w3 && h3 < p3 / 10 && (h3 = p3 / 10), l3 = t3.c2l(h3), u3 = t3.c2l(p3)), _2 && (l3 = Math.min(0, l3), u3 = Math.max(0, u3)), b2(l3) && y2(d3, l3, f3, C2), b2(u3) && m2(v3, u3, c3, C2));
          }
          var O = Math.min(6, g3);
          for (n3 = 0; n3 < O; n3++)
            P(n3);
          for (n3 = g3 - 1; n3 >= O; n3--)
            P(n3);
          return { min: d3, max: v3, opts: r4 };
        }, concatExtremes: g2 };
        var v2 = 3;
        function g2(t3, e4, r4) {
          var n3, i2, a2, o2 = e4._id, s2 = t3._fullData, l3 = t3._fullLayout, u3 = [], f3 = [];
          function h3(t4, e5) {
            for (n3 = 0; n3 < e5.length; n3++) {
              var r5 = t4[e5[n3]], s3 = (r5._extremes || {})[o2];
              if (true === r5.visible && s3) {
                for (i2 = 0; i2 < s3.min.length; i2++)
                  a2 = s3.min[i2], y2(u3, a2.val, a2.pad, { extrapad: a2.extrapad });
                for (i2 = 0; i2 < s3.max.length; i2++)
                  a2 = s3.max[i2], m2(f3, a2.val, a2.pad, { extrapad: a2.extrapad });
              }
            }
          }
          if (h3(s2, e4._traceIndices), h3(l3.annotations || [], e4._annIndices || []), h3(l3.shapes || [], e4._shapeIndices || []), e4._matchGroup && !r4) {
            for (var p3 in e4._matchGroup)
              if (p3 !== e4._id) {
                var d3 = c2(t3, p3), v3 = g2(t3, d3, true), x2 = e4._length / d3._length;
                for (i2 = 0; i2 < v3.min.length; i2++)
                  a2 = v3.min[i2], y2(u3, a2.val, a2.pad * x2, { extrapad: a2.extrapad });
                for (i2 = 0; i2 < v3.max.length; i2++)
                  a2 = v3.max[i2], m2(f3, a2.val, a2.pad * x2, { extrapad: a2.extrapad });
              }
          }
          return { min: u3, max: f3 };
        }
        function y2(t3, e4, r4, n3) {
          x(t3, e4, r4, n3, _);
        }
        function m2(t3, e4, r4, n3) {
          x(t3, e4, r4, n3, w2);
        }
        function x(t3, e4, r4, n3, i2) {
          for (var a2 = n3.tozero, o2 = n3.extrapad, s2 = true, l3 = 0; l3 < t3.length && s2; l3++) {
            var u3 = t3[l3];
            if (i2(u3.val, e4) && u3.pad >= r4 && (u3.extrapad || !o2)) {
              s2 = false;
              break;
            }
            i2(e4, u3.val) && u3.pad <= r4 && (o2 || !u3.extrapad) && (t3.splice(l3, 1), l3--);
          }
          if (s2) {
            var c3 = a2 && 0 === e4;
            t3.push({ val: e4, pad: c3 ? 0 : r4, extrapad: !c3 && o2 });
          }
        }
        function b2(t3) {
          return i(t3) && Math.abs(t3) < o;
        }
        function _(t3, e4) {
          return t3 <= e4;
        }
        function w2(t3, e4) {
          return t3 >= e4;
        }
        function T(t3, e4, r4) {
          return void 0 === e4 || void 0 === r4 || (e4 = t3.d2l(e4)) < t3.d2l(r4);
        }
        function k2(t3, e4) {
          if (!e4 || !e4.autorangeoptions)
            return t3;
          var r4 = t3[0], n3 = t3[1], i2 = e4.autorangeoptions.include;
          if (void 0 !== i2) {
            var o2 = e4.d2l(r4), s2 = e4.d2l(n3);
            a.isArrayOrTypedArray(i2) || (i2 = [i2]);
            for (var l3 = 0; l3 < i2.length; l3++) {
              var u3 = e4.d2l(i2[l3]);
              o2 >= u3 && (o2 = u3, r4 = u3), s2 <= u3 && (s2 = u3, n3 = u3);
            }
          }
          return r4 = function(t4, e5) {
            var r5 = e5.autorangeoptions;
            return r5 && void 0 !== r5.minallowed && T(e5, r5.minallowed, r5.maxallowed) ? r5.minallowed : r5 && void 0 !== r5.clipmin && T(e5, r5.clipmin, r5.clipmax) ? Math.max(t4, e5.d2l(r5.clipmin)) : t4;
          }(r4, e4), n3 = function(t4, e5) {
            var r5 = e5.autorangeoptions;
            return r5 && void 0 !== r5.maxallowed && T(e5, r5.minallowed, r5.maxallowed) ? r5.maxallowed : r5 && void 0 !== r5.clipmax && T(e5, r5.clipmin, r5.clipmax) ? Math.min(t4, e5.d2l(r5.clipmax)) : t4;
          }(n3, e4), [r4, n3];
        }
      }, 76808: function(t2) {
        t2.exports = function(t3, e3, r3) {
          var n2, i;
          if (r3) {
            var a = "reversed" === e3 || "min reversed" === e3 || "max reversed" === e3;
            n2 = r3[a ? 1 : 0], i = r3[a ? 0 : 1];
          }
          var o = t3("autorangeoptions.minallowed", null === i ? n2 : void 0), s = t3("autorangeoptions.maxallowed", null === n2 ? i : void 0);
          void 0 === o && t3("autorangeoptions.clipmin"), void 0 === s && t3("autorangeoptions.clipmax"), t3("autorangeoptions.include");
        };
      }, 54460: function(t2, e3, r3) {
        var n2 = r3(33428), i = r3(38248), a = r3(7316), o = r3(24040), s = r3(3400), l2 = s.strTranslate, u2 = r3(72736), c2 = r3(81668), f2 = r3(76308), h2 = r3(43616), p2 = r3(94724), d2 = r3(98728), v2 = r3(39032), g2 = v2.ONEMAXYEAR, y2 = v2.ONEAVGYEAR, m2 = v2.ONEMINYEAR, x = v2.ONEMAXQUARTER, b2 = v2.ONEAVGQUARTER, _ = v2.ONEMINQUARTER, w2 = v2.ONEMAXMONTH, T = v2.ONEAVGMONTH, k2 = v2.ONEMINMONTH, A2 = v2.ONEWEEK, M = v2.ONEDAY, S = M / 2, E2 = v2.ONEHOUR, L = v2.ONEMIN, C2 = v2.ONESEC, P = v2.MINUS_SIGN, O = v2.BADNUM, I2 = { K: "zeroline" }, D2 = { K: "gridline", L: "path" }, z2 = { K: "minor-gridline", L: "path" }, R = { K: "tick", L: "path" }, F2 = { K: "tick", L: "text" }, B2 = { width: ["x", "r", "l", "xl", "xr"], height: ["y", "t", "b", "yt", "yb"], right: ["r", "xr"], left: ["l", "xl"], top: ["t", "yt"], bottom: ["b", "yb"] }, N = r3(84284), j = N.MID_SHIFT, U = N.CAP_SHIFT, V = N.LINE_SPACING, q2 = N.OPPOSITE_SIDE, H2 = t2.exports = {};
        H2.setConvert = r3(78344);
        var G2 = r3(52976), W = r3(79811), Y = W.idSort, X = W.isLinked;
        H2.id2name = W.id2name, H2.name2id = W.name2id, H2.cleanId = W.cleanId, H2.list = W.list, H2.listIds = W.listIds, H2.getFromId = W.getFromId, H2.getFromTrace = W.getFromTrace;
        var Z = r3(19280);
        H2.getAutoRange = Z.getAutoRange, H2.findExtremes = Z.findExtremes;
        var K = 1e-4;
        function J(t3) {
          var e4 = (t3[1] - t3[0]) * K;
          return [t3[0] - e4, t3[1] + e4];
        }
        H2.coerceRef = function(t3, e4, r4, n3, i2, a2) {
          var o2 = n3.charAt(n3.length - 1), l3 = r4._fullLayout._subplots[o2 + "axis"], u3 = n3 + "ref", c3 = {};
          return i2 || (i2 = l3[0] || ("string" == typeof a2 ? a2 : a2[0])), a2 || (a2 = i2), l3 = l3.concat(l3.map(function(t4) {
            return t4 + " domain";
          })), c3[u3] = { valType: "enumerated", values: l3.concat(a2 ? "string" == typeof a2 ? [a2] : a2 : []), dflt: i2 }, s.coerce(t3, e4, c3, u3);
        }, H2.getRefType = function(t3) {
          return void 0 === t3 ? t3 : "paper" === t3 ? "paper" : "pixel" === t3 ? "pixel" : /( domain)$/.test(t3) ? "domain" : "range";
        }, H2.coercePosition = function(t3, e4, r4, n3, i2, a2) {
          var o2, l3;
          if ("range" !== H2.getRefType(n3))
            o2 = s.ensureNumber, l3 = r4(i2, a2);
          else {
            var u3 = H2.getFromId(e4, n3);
            l3 = r4(i2, a2 = u3.fraction2r(a2)), o2 = u3.cleanPos;
          }
          t3[i2] = o2(l3);
        }, H2.cleanPosition = function(t3, e4, r4) {
          return ("paper" === r4 || "pixel" === r4 ? s.ensureNumber : H2.getFromId(e4, r4).cleanPos)(t3);
        }, H2.redrawComponents = function(t3, e4) {
          e4 = e4 || H2.listIds(t3);
          var r4 = t3._fullLayout;
          function n3(n4, i2, a2, s2) {
            for (var l3 = o.getComponentMethod(n4, i2), u3 = {}, c3 = 0; c3 < e4.length; c3++)
              for (var f3 = r4[H2.id2name(e4[c3])][a2], h3 = 0; h3 < f3.length; h3++) {
                var p3 = f3[h3];
                if (!u3[p3] && (l3(t3, p3), u3[p3] = 1, s2))
                  return;
              }
          }
          n3("annotations", "drawOne", "_annIndices"), n3("shapes", "drawOne", "_shapeIndices"), n3("images", "draw", "_imgIndices", true), n3("selections", "drawOne", "_selectionIndices");
        };
        var $ = H2.getDataConversions = function(t3, e4, r4, n3) {
          var i2, a2 = "x" === r4 || "y" === r4 || "z" === r4 ? r4 : n3;
          if (s.isArrayOrTypedArray(a2)) {
            if (i2 = { type: G2(n3, void 0, { autotypenumbers: t3._fullLayout.autotypenumbers }), _categories: [] }, H2.setConvert(i2), "category" === i2.type)
              for (var o2 = 0; o2 < n3.length; o2++)
                i2.d2c(n3[o2]);
          } else
            i2 = H2.getFromTrace(t3, e4, a2);
          return i2 ? { d2c: i2.d2c, c2d: i2.c2d } : "ids" === a2 ? { d2c: tt2, c2d: tt2 } : { d2c: Q, c2d: Q };
        };
        function Q(t3) {
          return +t3;
        }
        function tt2(t3) {
          return String(t3);
        }
        function et(t3, e4) {
          return Math.abs((t3 / e4 + 0.5) % 1 - 0.5) < 1e-3;
        }
        function rt(t3, e4) {
          return Math.abs(t3 / e4 - 1) < 1e-3;
        }
        function nt(t3) {
          return +t3.substring(1);
        }
        function it(t3, e4) {
          return t3.rangebreaks && (e4 = e4.filter(function(e5) {
            return t3.maskBreaks(e5.x) !== O;
          })), e4;
        }
        function at(t3) {
          var e4 = t3._mainAxis, r4 = [];
          if (e4._vals) {
            for (var n3 = 0; n3 < e4._vals.length; n3++)
              if (!e4._vals[n3].noTick) {
                var i2 = e4.l2p(e4._vals[n3].x), a2 = t3.p2l(i2), o2 = H2.tickText(t3, a2);
                e4._vals[n3].minor && (o2.minor = true, o2.text = ""), r4.push(o2);
              }
          }
          return it(t3, r4);
        }
        function ot(t3, e4) {
          var r4 = J(s.simpleMap(t3.range, t3.r2l)), n3 = Math.min(r4[0], r4[1]), i2 = Math.max(r4[0], r4[1]), a2 = "category" === t3.type ? t3.d2l_noadd : t3.d2l;
          "log" === t3.type && "L" !== String(t3.dtick).charAt(0) && (t3.dtick = "L" + Math.pow(10, Math.floor(Math.min(t3.range[0], t3.range[1])) - 1));
          for (var o2 = [], l3 = 0; l3 <= 1; l3++)
            if ((void 0 === e4 || !(e4 && l3 || false === e4 && !l3)) && (!l3 || t3.minor)) {
              var u3 = l3 ? t3.minor.tickvals : t3.tickvals, c3 = l3 ? [] : t3.ticktext;
              if (u3) {
                s.isArrayOrTypedArray(c3) || (c3 = []);
                for (var f3 = 0; f3 < u3.length; f3++) {
                  var h3 = a2(u3[f3]);
                  if (h3 > n3 && h3 < i2) {
                    var p3 = void 0 === c3[f3] ? H2.tickText(t3, h3) : gt(t3, h3, String(c3[f3]));
                    l3 && (p3.minor = true, p3.text = ""), o2.push(p3);
                  }
                }
              }
            }
          return it(t3, o2);
        }
        H2.getDataToCoordFunc = function(t3, e4, r4, n3) {
          return $(t3, e4, r4, n3).d2c;
        }, H2.counterLetter = function(t3) {
          var e4 = t3.charAt(0);
          return "x" === e4 ? "y" : "y" === e4 ? "x" : void 0;
        }, H2.minDtick = function(t3, e4, r4, n3) {
          -1 === ["log", "category", "multicategory"].indexOf(t3.type) && n3 ? void 0 === t3._minDtick ? (t3._minDtick = e4, t3._forceTick0 = r4) : t3._minDtick && ((t3._minDtick / e4 + 1e-6) % 1 < 2e-6 && ((r4 - t3._forceTick0) / e4 % 1 + 1.000001) % 1 < 2e-6 ? (t3._minDtick = e4, t3._forceTick0 = r4) : ((e4 / t3._minDtick + 1e-6) % 1 > 2e-6 || ((r4 - t3._forceTick0) / t3._minDtick % 1 + 1.000001) % 1 > 2e-6) && (t3._minDtick = 0)) : t3._minDtick = 0;
        }, H2.saveRangeInitial = function(t3, e4) {
          for (var r4 = H2.list(t3, "", true), n3 = false, i2 = 0; i2 < r4.length; i2++) {
            var a2 = r4[i2], o2 = void 0 === a2._rangeInitial0 && void 0 === a2._rangeInitial1, s2 = o2 || a2.range[0] !== a2._rangeInitial0 || a2.range[1] !== a2._rangeInitial1, l3 = a2.autorange;
            (o2 && true !== l3 || e4 && s2) && (a2._rangeInitial0 = "min" === l3 || "max reversed" === l3 ? void 0 : a2.range[0], a2._rangeInitial1 = "max" === l3 || "min reversed" === l3 ? void 0 : a2.range[1], a2._autorangeInitial = l3, n3 = true);
          }
          return n3;
        }, H2.saveShowSpikeInitial = function(t3, e4) {
          for (var r4 = H2.list(t3, "", true), n3 = false, i2 = "on", a2 = 0; a2 < r4.length; a2++) {
            var o2 = r4[a2], s2 = void 0 === o2._showSpikeInitial, l3 = s2 || !(o2.showspikes === o2._showspikes);
            (s2 || e4 && l3) && (o2._showSpikeInitial = o2.showspikes, n3 = true), "on" !== i2 || o2.showspikes || (i2 = "off");
          }
          return t3._fullLayout._cartesianSpikesEnabled = i2, n3;
        }, H2.autoBin = function(t3, e4, r4, n3, a2, o2) {
          var l3, u3 = s.aggNums(Math.min, null, t3), c3 = s.aggNums(Math.max, null, t3);
          if ("category" === e4.type || "multicategory" === e4.type)
            return { start: u3 - 0.5, end: c3 + 0.5, size: Math.max(1, Math.round(o2) || 1), _dataSpan: c3 - u3 };
          if (a2 || (a2 = e4.calendar), l3 = "log" === e4.type ? { type: "linear", range: [u3, c3] } : { type: e4.type, range: s.simpleMap([u3, c3], e4.c2r, 0, a2), calendar: a2 }, H2.setConvert(l3), o2 = o2 && d2.dtick(o2, l3.type))
            l3.dtick = o2, l3.tick0 = d2.tick0(void 0, l3.type, a2);
          else {
            var f3;
            if (r4)
              f3 = (c3 - u3) / r4;
            else {
              var h3 = s.distinctVals(t3), p3 = Math.pow(10, Math.floor(Math.log(h3.minDiff) / Math.LN10)), v3 = p3 * s.roundUp(h3.minDiff / p3, [0.9, 1.9, 4.9, 9.9], true);
              f3 = Math.max(v3, 2 * s.stdev(t3) / Math.pow(t3.length, n3 ? 0.25 : 0.4)), i(f3) || (f3 = 1);
            }
            H2.autoTicks(l3, f3);
          }
          var g3, y3 = l3.dtick, m3 = H2.tickIncrement(H2.tickFirst(l3), y3, "reverse", a2);
          if ("number" == typeof y3)
            m3 = function(t4, e5, r5, n4, a3) {
              var o3 = 0, s2 = 0, l4 = 0, u4 = 0;
              function c4(e6) {
                return (1 + 100 * (e6 - t4) / r5.dtick) % 100 < 2;
              }
              for (var f4 = 0; f4 < e5.length; f4++)
                e5[f4] % 1 == 0 ? l4++ : i(e5[f4]) || u4++, c4(e5[f4]) && o3++, c4(e5[f4] + r5.dtick / 2) && s2++;
   