/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc;

import com.datapps.linkoopdb.jdbc.SchemaObject;
import com.datapps.linkoopdb.jdbc.types.Type;

public class Token {
    public String tokenString = "";
    public int tokenType = -1;
    public Type dataType;
    public Object tokenValue;
    public String namePrefix;
    public String namePrePrefix;
    public String namePrePrePrefix;
    public String charsetSchema;
    public String charsetName;
    public int lobMultiplierType = -1;
    public boolean isDelimitedIdentifier;
    public boolean isDelimitedPrefix;
    public boolean isDelimitedPrePrefix;
    public boolean isUndelimitedIdentifier;
    public boolean hasIrregularChar;
    public boolean isReservedIdentifier;
    public boolean isCoreReservedIdentifier;
    public boolean isHostParameter;
    public boolean isMalformed;
    public int position;
    String fullString;
    boolean isDelimiter;
    boolean isDelimitedPrePrePrefix;
    Object expression;
    boolean hasColumnList;

    public static String getSQL(Token[] tokens) {
        boolean wasDelimiter = true;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tokens.length; ++i) {
            String sql = tokens[i].getSQL();
            if (!tokens[i].isDelimiter && !wasDelimiter) {
                sb.append(' ');
            }
            sb.append(sql);
            wasDelimiter = tokens[i].isDelimiter;
        }
        return sb.toString();
    }

    static Object[] getSimplifiedTokens(Token[] tokens) {
        Object[] array = new Object[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            array[i] = tokens[i].expression == null ? tokens[i].getSQL() : tokens[i].expression;
        }
        return array;
    }

    void reset() {
        this.tokenString = "";
        this.tokenType = -1;
        this.dataType = null;
        this.tokenValue = null;
        this.namePrefix = null;
        this.namePrePrefix = null;
        this.namePrePrePrefix = null;
        this.charsetSchema = null;
        this.charsetName = null;
        this.fullString = null;
        this.lobMultiplierType = -1;
        this.isDelimiter = false;
        this.isDelimitedIdentifier = false;
        this.isDelimitedPrefix = false;
        this.isDelimitedPrePrefix = false;
        this.isDelimitedPrePrePrefix = false;
        this.isUndelimitedIdentifier = false;
        this.hasIrregularChar = false;
        this.isReservedIdentifier = false;
        this.isCoreReservedIdentifier = false;
        this.isHostParameter = false;
        this.isMalformed = false;
        this.expression = null;
        this.hasColumnList = false;
    }

    public Token duplicate() {
        Token token = new Token();
        token.tokenString = this.tokenString;
        token.tokenType = this.tokenType;
        token.dataType = this.dataType;
        token.tokenValue = this.tokenValue;
        token.namePrefix = this.namePrefix;
        token.namePrePrefix = this.namePrePrefix;
        token.namePrePrePrefix = this.namePrePrePrefix;
        token.charsetSchema = this.charsetSchema;
        token.charsetName = this.charsetName;
        token.fullString = this.fullString;
        token.lobMultiplierType = this.lobMultiplierType;
        token.isDelimiter = this.isDelimiter;
        token.isDelimitedIdentifier = this.isDelimitedIdentifier;
        token.isDelimitedPrefix = this.isDelimitedPrefix;
        token.isDelimitedPrePrefix = this.isDelimitedPrePrefix;
        token.isDelimitedPrePrePrefix = this.isDelimitedPrePrePrefix;
        token.isUndelimitedIdentifier = this.isUndelimitedIdentifier;
        token.hasIrregularChar = this.hasIrregularChar;
        token.isReservedIdentifier = this.isReservedIdentifier;
        token.isCoreReservedIdentifier = this.isCoreReservedIdentifier;
        token.isHostParameter = this.isHostParameter;
        token.isMalformed = this.isMalformed;
        return token;
    }

    public String getFullString() {
        return this.fullString;
    }

    public void setExpression(Object expression) {
        this.expression = expression;
    }

    public void setWithColumnList() {
        this.hasColumnList = true;
    }

    String getSQL() {
        String sql = Type.typeHelper.getExpressionColumnSQL(this.tokenType, this.tokenString, this.expression);
        if (sql != null) {
            return sql;
        }
        if (this.expression instanceof SchemaObject) {
            this.isDelimiter = false;
            String nameString = ((SchemaObject)this.expression).getName().getSchemaQualifiedStatementName();
            if (this.hasColumnList) {
                nameString = nameString + Type.typeHelper.getColumnListSQL(this.expression);
            }
            return nameString;
        }
        if (this.expression instanceof Type) {
            this.isDelimiter = false;
            Type type = (Type)this.expression;
            if (type.isDistinctType() || type.isDomainType()) {
                return type.getName().getSchemaQualifiedStatementName();
            }
            return type.getNameString();
        }
        if (this.namePrefix == null && this.isUndelimitedIdentifier) {
            return this.tokenString;
        }
        if (this.tokenType == 1011) {
            return this.dataType.convertToSQLString(this.tokenValue);
        }
        StringBuffer sb = new StringBuffer();
        if (this.namePrePrefix != null) {
            if (this.isDelimitedPrePrefix) {
                sb.append('\"');
                sb.append(this.namePrePrefix);
                sb.append('\"');
            } else {
                sb.append(this.namePrePrefix);
            }
            sb.append('.');
        }
        if (this.namePrefix != null) {
            if (this.isDelimitedPrefix) {
                sb.append('\"');
                sb.append(this.namePrefix);
                sb.append('\"');
            } else {
                sb.append(this.namePrefix);
            }
            sb.append('.');
        }
        if (this.isDelimitedIdentifier) {
            sb.append('\"');
            sb.append(this.tokenString);
            sb.append('\"');
            this.isDelimiter = false;
        } else {
            sb.append(this.tokenString);
        }
        return sb.toString();
    }
}

