# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SwitchQosRulesOrderArgs', 'SwitchQosRulesOrder']

@pulumi.input_type
class SwitchQosRulesOrderArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 dscp: Optional[pulumi.Input[builtins.int]] = None,
                 dst_port: Optional[pulumi.Input[builtins.int]] = None,
                 dst_port_range: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 qos_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 src_port: Optional[pulumi.Input[builtins.int]] = None,
                 src_port_range: Optional[pulumi.Input[builtins.str]] = None,
                 vlan: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a SwitchQosRulesOrder resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.int] dscp: DSCP tag. Set this to -1 to trust incoming DSCP. Default value is 0
        :param pulumi.Input[builtins.int] dst_port: The destination port of the incoming packet. Applicable only if protocol is TCP or UDP.
        :param pulumi.Input[builtins.str] dst_port_range: The destination port range of the incoming packet. Applicable only if protocol is set to TCP or UDP. Example: 70-80
        :param pulumi.Input[builtins.str] protocol: The protocol of the incoming packet. Can be one of "ANY", "TCP" or "UDP". Default value is "ANY"
        :param pulumi.Input[builtins.str] qos_rule_id: qosRuleId path parameter. Qos rule ID
        :param pulumi.Input[builtins.int] src_port: The source port of the incoming packet. Applicable only if protocol is TCP or UDP.
        :param pulumi.Input[builtins.str] src_port_range: The source port range of the incoming packet. Applicable only if protocol is set to TCP or UDP. Example: 70-80
        :param pulumi.Input[builtins.int] vlan: The VLAN of the incoming packet. A null value will match any VLAN.
        """
        pulumi.set(__self__, "network_id", network_id)
        if dscp is not None:
            pulumi.set(__self__, "dscp", dscp)
        if dst_port is not None:
            pulumi.set(__self__, "dst_port", dst_port)
        if dst_port_range is not None:
            pulumi.set(__self__, "dst_port_range", dst_port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if qos_rule_id is not None:
            pulumi.set(__self__, "qos_rule_id", qos_rule_id)
        if src_port is not None:
            pulumi.set(__self__, "src_port", src_port)
        if src_port_range is not None:
            pulumi.set(__self__, "src_port_range", src_port_range)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def dscp(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        DSCP tag. Set this to -1 to trust incoming DSCP. Default value is 0
        """
        return pulumi.get(self, "dscp")

    @dscp.setter
    def dscp(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "dscp", value)

    @property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The destination port of the incoming packet. Applicable only if protocol is TCP or UDP.
        """
        return pulumi.get(self, "dst_port")

    @dst_port.setter
    def dst_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "dst_port", value)

    @property
    @pulumi.getter(name="dstPortRange")
    def dst_port_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The destination port range of the incoming packet. Applicable only if protocol is set to TCP or UDP. Example: 70-80
        """
        return pulumi.get(self, "dst_port_range")

    @dst_port_range.setter
    def dst_port_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dst_port_range", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The protocol of the incoming packet. Can be one of "ANY", "TCP" or "UDP". Default value is "ANY"
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="qosRuleId")
    def qos_rule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        qosRuleId path parameter. Qos rule ID
        """
        return pulumi.get(self, "qos_rule_id")

    @qos_rule_id.setter
    def qos_rule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "qos_rule_id", value)

    @property
    @pulumi.getter(name="srcPort")
    def src_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The source port of the incoming packet. Applicable only if protocol is TCP or UDP.
        """
        return pulumi.get(self, "src_port")

    @src_port.setter
    def src_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "src_port", value)

    @property
    @pulumi.getter(name="srcPortRange")
    def src_port_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The source port range of the incoming packet. Applicable only if protocol is set to TCP or UDP. Example: 70-80
        """
        return pulumi.get(self, "src_port_range")

    @src_port_range.setter
    def src_port_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "src_port_range", value)

    @property
    @pulumi.getter
    def vlan(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The VLAN of the incoming packet. A null value will match any VLAN.
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vlan", value)


@pulumi.input_type
class _SwitchQosRulesOrderState:
    def __init__(__self__, *,
                 dscp: Optional[pulumi.Input[builtins.int]] = None,
                 dst_port: Optional[pulumi.Input[builtins.int]] = None,
                 dst_port_range: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 qos_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 src_port: Optional[pulumi.Input[builtins.int]] = None,
                 src_port_range: Optional[pulumi.Input[builtins.str]] = None,
                 vlan: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering SwitchQosRulesOrder resources.
        :param pulumi.Input[builtins.int] dscp: DSCP tag. Set this to -1 to trust incoming DSCP. Default value is 0
        :param pulumi.Input[builtins.int] dst_port: The destination port of the incoming packet. Applicable only if protocol is TCP or UDP.
        :param pulumi.Input[builtins.str] dst_port_range: The destination port range of the incoming packet. Applicable only if protocol is set to TCP or UDP. Example: 70-80
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] protocol: The protocol of the incoming packet. Can be one of "ANY", "TCP" or "UDP". Default value is "ANY"
        :param pulumi.Input[builtins.str] qos_rule_id: qosRuleId path parameter. Qos rule ID
        :param pulumi.Input[builtins.int] src_port: The source port of the incoming packet. Applicable only if protocol is TCP or UDP.
        :param pulumi.Input[builtins.str] src_port_range: The source port range of the incoming packet. Applicable only if protocol is set to TCP or UDP. Example: 70-80
        :param pulumi.Input[builtins.int] vlan: The VLAN of the incoming packet. A null value will match any VLAN.
        """
        if dscp is not None:
            pulumi.set(__self__, "dscp", dscp)
        if dst_port is not None:
            pulumi.set(__self__, "dst_port", dst_port)
        if dst_port_range is not None:
            pulumi.set(__self__, "dst_port_range", dst_port_range)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if qos_rule_id is not None:
            pulumi.set(__self__, "qos_rule_id", qos_rule_id)
        if src_port is not None:
            pulumi.set(__self__, "src_port", src_port)
        if src_port_range is not None:
            pulumi.set(__self__, "src_port_range", src_port_range)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @property
    @pulumi.getter
    def dscp(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        DSCP tag. Set this to -1 to trust incoming DSCP. Default value is 0
        """
        return pulumi.get(self, "dscp")

    @dscp.setter
    def dscp(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "dscp", value)

    @property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The destination port of the incoming packet. Applicable only if protocol is TCP or UDP.
        """
        return pulumi.get(self, "dst_port")

    @dst_port.setter
    def dst_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "dst_port", value)

    @property
    @pulumi.getter(name="dstPortRange")
    def dst_port_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The destination port range of the incoming packet. Applicable only if protocol is set to TCP or UDP. Example: 70-80
        """
        return pulumi.get(self, "dst_port_range")

    @dst_port_range.setter
    def dst_port_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dst_port_range", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The protocol of the incoming packet. Can be one of "ANY", "TCP" or "UDP". Default value is "ANY"
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="qosRuleId")
    def qos_rule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        qosRuleId path parameter. Qos rule ID
        """
        return pulumi.get(self, "qos_rule_id")

    @qos_rule_id.setter
    def qos_rule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "qos_rule_id", value)

    @property
    @pulumi.getter(name="srcPort")
    def src_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The source port of the incoming packet. Applicable only if protocol is TCP or UDP.
        """
        return pulumi.get(self, "src_port")

    @src_port.setter
    def src_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "src_port", value)

    @property
    @pulumi.getter(name="srcPortRange")
    def src_port_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The source port range of the incoming packet. Applicable only if protocol is set to TCP or UDP. Example: 70-80
        """
        return pulumi.get(self, "src_port_range")

    @src_port_range.setter
    def src_port_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "src_port_range", value)

    @property
    @pulumi.getter
    def vlan(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The VLAN of the incoming packet. A null value will match any VLAN.
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vlan", value)


class SwitchQosRulesOrder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dscp: Optional[pulumi.Input[builtins.int]] = None,
                 dst_port: Optional[pulumi.Input[builtins.int]] = None,
                 dst_port_range: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 qos_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 src_port: Optional[pulumi.Input[builtins.int]] = None,
                 src_port_range: Optional[pulumi.Input[builtins.str]] = None,
                 vlan: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SwitchQosRulesOrder("example",
            dscp=1,
            dst_port=3000,
            dst_port_range="3000-3100",
            network_id="string",
            protocol="TCP",
            src_port=2000,
            src_port_range="70-80",
            vlan=100)
        pulumi.export("merakiNetworksSwitchQosRulesOrderExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchQosRulesOrder:SwitchQosRulesOrder example "network_id,qos_rule_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] dscp: DSCP tag. Set this to -1 to trust incoming DSCP. Default value is 0
        :param pulumi.Input[builtins.int] dst_port: The destination port of the incoming packet. Applicable only if protocol is TCP or UDP.
        :param pulumi.Input[builtins.str] dst_port_range: The destination port range of the incoming packet. Applicable only if protocol is set to TCP or UDP. Example: 70-80
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] protocol: The protocol of the incoming packet. Can be one of "ANY", "TCP" or "UDP". Default value is "ANY"
        :param pulumi.Input[builtins.str] qos_rule_id: qosRuleId path parameter. Qos rule ID
        :param pulumi.Input[builtins.int] src_port: The source port of the incoming packet. Applicable only if protocol is TCP or UDP.
        :param pulumi.Input[builtins.str] src_port_range: The source port range of the incoming packet. Applicable only if protocol is set to TCP or UDP. Example: 70-80
        :param pulumi.Input[builtins.int] vlan: The VLAN of the incoming packet. A null value will match any VLAN.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SwitchQosRulesOrderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SwitchQosRulesOrder("example",
            dscp=1,
            dst_port=3000,
            dst_port_range="3000-3100",
            network_id="string",
            protocol="TCP",
            src_port=2000,
            src_port_range="70-80",
            vlan=100)
        pulumi.export("merakiNetworksSwitchQosRulesOrderExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchQosRulesOrder:SwitchQosRulesOrder example "network_id,qos_rule_id"
        ```

        :param str resource_name: The name of the resource.
        :param SwitchQosRulesOrderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwitchQosRulesOrderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dscp: Optional[pulumi.Input[builtins.int]] = None,
                 dst_port: Optional[pulumi.Input[builtins.int]] = None,
                 dst_port_range: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 qos_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 src_port: Optional[pulumi.Input[builtins.int]] = None,
                 src_port_range: Optional[pulumi.Input[builtins.str]] = None,
                 vlan: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwitchQosRulesOrderArgs.__new__(SwitchQosRulesOrderArgs)

            __props__.__dict__["dscp"] = dscp
            __props__.__dict__["dst_port"] = dst_port
            __props__.__dict__["dst_port_range"] = dst_port_range
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["qos_rule_id"] = qos_rule_id
            __props__.__dict__["src_port"] = src_port
            __props__.__dict__["src_port_range"] = src_port_range
            __props__.__dict__["vlan"] = vlan
        super(SwitchQosRulesOrder, __self__).__init__(
            'meraki:networks/switchQosRulesOrder:SwitchQosRulesOrder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dscp: Optional[pulumi.Input[builtins.int]] = None,
            dst_port: Optional[pulumi.Input[builtins.int]] = None,
            dst_port_range: Optional[pulumi.Input[builtins.str]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            qos_rule_id: Optional[pulumi.Input[builtins.str]] = None,
            src_port: Optional[pulumi.Input[builtins.int]] = None,
            src_port_range: Optional[pulumi.Input[builtins.str]] = None,
            vlan: Optional[pulumi.Input[builtins.int]] = None) -> 'SwitchQosRulesOrder':
        """
        Get an existing SwitchQosRulesOrder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] dscp: DSCP tag. Set this to -1 to trust incoming DSCP. Default value is 0
        :param pulumi.Input[builtins.int] dst_port: The destination port of the incoming packet. Applicable only if protocol is TCP or UDP.
        :param pulumi.Input[builtins.str] dst_port_range: The destination port range of the incoming packet. Applicable only if protocol is set to TCP or UDP. Example: 70-80
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] protocol: The protocol of the incoming packet. Can be one of "ANY", "TCP" or "UDP". Default value is "ANY"
        :param pulumi.Input[builtins.str] qos_rule_id: qosRuleId path parameter. Qos rule ID
        :param pulumi.Input[builtins.int] src_port: The source port of the incoming packet. Applicable only if protocol is TCP or UDP.
        :param pulumi.Input[builtins.str] src_port_range: The source port range of the incoming packet. Applicable only if protocol is set to TCP or UDP. Example: 70-80
        :param pulumi.Input[builtins.int] vlan: The VLAN of the incoming packet. A null value will match any VLAN.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwitchQosRulesOrderState.__new__(_SwitchQosRulesOrderState)

        __props__.__dict__["dscp"] = dscp
        __props__.__dict__["dst_port"] = dst_port
        __props__.__dict__["dst_port_range"] = dst_port_range
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["qos_rule_id"] = qos_rule_id
        __props__.__dict__["src_port"] = src_port
        __props__.__dict__["src_port_range"] = src_port_range
        __props__.__dict__["vlan"] = vlan
        return SwitchQosRulesOrder(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def dscp(self) -> pulumi.Output[builtins.int]:
        """
        DSCP tag. Set this to -1 to trust incoming DSCP. Default value is 0
        """
        return pulumi.get(self, "dscp")

    @property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> pulumi.Output[builtins.int]:
        """
        The destination port of the incoming packet. Applicable only if protocol is TCP or UDP.
        """
        return pulumi.get(self, "dst_port")

    @property
    @pulumi.getter(name="dstPortRange")
    def dst_port_range(self) -> pulumi.Output[builtins.str]:
        """
        The destination port range of the incoming packet. Applicable only if protocol is set to TCP or UDP. Example: 70-80
        """
        return pulumi.get(self, "dst_port_range")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[builtins.str]:
        """
        The protocol of the incoming packet. Can be one of "ANY", "TCP" or "UDP". Default value is "ANY"
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="qosRuleId")
    def qos_rule_id(self) -> pulumi.Output[builtins.str]:
        """
        qosRuleId path parameter. Qos rule ID
        """
        return pulumi.get(self, "qos_rule_id")

    @property
    @pulumi.getter(name="srcPort")
    def src_port(self) -> pulumi.Output[builtins.int]:
        """
        The source port of the incoming packet. Applicable only if protocol is TCP or UDP.
        """
        return pulumi.get(self, "src_port")

    @property
    @pulumi.getter(name="srcPortRange")
    def src_port_range(self) -> pulumi.Output[builtins.str]:
        """
        The source port range of the incoming packet. Applicable only if protocol is set to TCP or UDP. Example: 70-80
        """
        return pulumi.get(self, "src_port_range")

    @property
    @pulumi.getter
    def vlan(self) -> pulumi.Output[builtins.int]:
        """
        The VLAN of the incoming packet. A null value will match any VLAN.
        """
        return pulumi.get(self, "vlan")

