# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SwitchStacksRoutingInterfacesDhcpArgs', 'SwitchStacksRoutingInterfacesDhcp']

@pulumi.input_type
class SwitchStacksRoutingInterfacesDhcpArgs:
    def __init__(__self__, *,
                 interface_id: pulumi.Input[builtins.str],
                 network_id: pulumi.Input[builtins.str],
                 switch_stack_id: pulumi.Input[builtins.str],
                 boot_file_name: Optional[pulumi.Input[builtins.str]] = None,
                 boot_next_server: Optional[pulumi.Input[builtins.str]] = None,
                 boot_options_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 dhcp_lease_time: Optional[pulumi.Input[builtins.str]] = None,
                 dhcp_mode: Optional[pulumi.Input[builtins.str]] = None,
                 dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpDhcpOptionArgs']]]] = None,
                 dhcp_relay_server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dns_custom_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dns_nameservers_option: Optional[pulumi.Input[builtins.str]] = None,
                 fixed_ip_assignments: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgs']]]] = None,
                 reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgs']]]] = None):
        """
        The set of arguments for constructing a SwitchStacksRoutingInterfacesDhcp resource.
        :param pulumi.Input[builtins.str] interface_id: interfaceId path parameter. Interface ID
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] switch_stack_id: switchStackId path parameter. Switch stack ID
        :param pulumi.Input[builtins.str] boot_file_name: The PXE boot server file name for the DHCP server running on the switch stack interface
        :param pulumi.Input[builtins.str] boot_next_server: The PXE boot server IP for the DHCP server running on the switch stack interface
        :param pulumi.Input[builtins.bool] boot_options_enabled: Enable DHCP boot options to provide PXE boot options configs for the dhcp server running on the switch stack interface
        :param pulumi.Input[builtins.str] dhcp_lease_time: The DHCP lease time config for the dhcp server running on the switch stack interface ('30 minutes', '1 hour', '4 hours', '12 hours', '1 day' or '1 week')
        :param pulumi.Input[builtins.str] dhcp_mode: The DHCP mode options for the switch stack interface ('dhcpDisabled', 'dhcpRelay' or 'dhcpServer')
        :param pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpDhcpOptionArgs']]] dhcp_options: Array of DHCP options consisting of code, type and value for the DHCP server running on the switch stack interface
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dhcp_relay_server_ips: The DHCP relay server IPs to which DHCP packets would get relayed for the switch stack interface
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_custom_nameservers: The DHCP name server IPs when DHCP name server option is 'custom'
        :param pulumi.Input[builtins.str] dns_nameservers_option: The DHCP name server option for the dhcp server running on the switch stack interface ('googlePublicDns', 'openDns' or 'custom')
        :param pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgs']]] fixed_ip_assignments: Array of DHCP reserved IP assignments for the DHCP server running on the switch stack interface
        :param pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgs']]] reserved_ip_ranges: Array of DHCP reserved IP assignments for the DHCP server running on the switch stack interface
        """
        pulumi.set(__self__, "interface_id", interface_id)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "switch_stack_id", switch_stack_id)
        if boot_file_name is not None:
            pulumi.set(__self__, "boot_file_name", boot_file_name)
        if boot_next_server is not None:
            pulumi.set(__self__, "boot_next_server", boot_next_server)
        if boot_options_enabled is not None:
            pulumi.set(__self__, "boot_options_enabled", boot_options_enabled)
        if dhcp_lease_time is not None:
            pulumi.set(__self__, "dhcp_lease_time", dhcp_lease_time)
        if dhcp_mode is not None:
            pulumi.set(__self__, "dhcp_mode", dhcp_mode)
        if dhcp_options is not None:
            pulumi.set(__self__, "dhcp_options", dhcp_options)
        if dhcp_relay_server_ips is not None:
            pulumi.set(__self__, "dhcp_relay_server_ips", dhcp_relay_server_ips)
        if dns_custom_nameservers is not None:
            pulumi.set(__self__, "dns_custom_nameservers", dns_custom_nameservers)
        if dns_nameservers_option is not None:
            pulumi.set(__self__, "dns_nameservers_option", dns_nameservers_option)
        if fixed_ip_assignments is not None:
            pulumi.set(__self__, "fixed_ip_assignments", fixed_ip_assignments)
        if reserved_ip_ranges is not None:
            pulumi.set(__self__, "reserved_ip_ranges", reserved_ip_ranges)

    @property
    @pulumi.getter(name="interfaceId")
    def interface_id(self) -> pulumi.Input[builtins.str]:
        """
        interfaceId path parameter. Interface ID
        """
        return pulumi.get(self, "interface_id")

    @interface_id.setter
    def interface_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "interface_id", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="switchStackId")
    def switch_stack_id(self) -> pulumi.Input[builtins.str]:
        """
        switchStackId path parameter. Switch stack ID
        """
        return pulumi.get(self, "switch_stack_id")

    @switch_stack_id.setter
    def switch_stack_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "switch_stack_id", value)

    @property
    @pulumi.getter(name="bootFileName")
    def boot_file_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The PXE boot server file name for the DHCP server running on the switch stack interface
        """
        return pulumi.get(self, "boot_file_name")

    @boot_file_name.setter
    def boot_file_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "boot_file_name", value)

    @property
    @pulumi.getter(name="bootNextServer")
    def boot_next_server(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The PXE boot server IP for the DHCP server running on the switch stack interface
        """
        return pulumi.get(self, "boot_next_server")

    @boot_next_server.setter
    def boot_next_server(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "boot_next_server", value)

    @property
    @pulumi.getter(name="bootOptionsEnabled")
    def boot_options_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable DHCP boot options to provide PXE boot options configs for the dhcp server running on the switch stack interface
        """
        return pulumi.get(self, "boot_options_enabled")

    @boot_options_enabled.setter
    def boot_options_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "boot_options_enabled", value)

    @property
    @pulumi.getter(name="dhcpLeaseTime")
    def dhcp_lease_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DHCP lease time config for the dhcp server running on the switch stack interface ('30 minutes', '1 hour', '4 hours', '12 hours', '1 day' or '1 week')
        """
        return pulumi.get(self, "dhcp_lease_time")

    @dhcp_lease_time.setter
    def dhcp_lease_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dhcp_lease_time", value)

    @property
    @pulumi.getter(name="dhcpMode")
    def dhcp_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DHCP mode options for the switch stack interface ('dhcpDisabled', 'dhcpRelay' or 'dhcpServer')
        """
        return pulumi.get(self, "dhcp_mode")

    @dhcp_mode.setter
    def dhcp_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dhcp_mode", value)

    @property
    @pulumi.getter(name="dhcpOptions")
    def dhcp_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpDhcpOptionArgs']]]]:
        """
        Array of DHCP options consisting of code, type and value for the DHCP server running on the switch stack interface
        """
        return pulumi.get(self, "dhcp_options")

    @dhcp_options.setter
    def dhcp_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpDhcpOptionArgs']]]]):
        pulumi.set(self, "dhcp_options", value)

    @property
    @pulumi.getter(name="dhcpRelayServerIps")
    def dhcp_relay_server_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The DHCP relay server IPs to which DHCP packets would get relayed for the switch stack interface
        """
        return pulumi.get(self, "dhcp_relay_server_ips")

    @dhcp_relay_server_ips.setter
    def dhcp_relay_server_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dhcp_relay_server_ips", value)

    @property
    @pulumi.getter(name="dnsCustomNameservers")
    def dns_custom_nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The DHCP name server IPs when DHCP name server option is 'custom'
        """
        return pulumi.get(self, "dns_custom_nameservers")

    @dns_custom_nameservers.setter
    def dns_custom_nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dns_custom_nameservers", value)

    @property
    @pulumi.getter(name="dnsNameserversOption")
    def dns_nameservers_option(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DHCP name server option for the dhcp server running on the switch stack interface ('googlePublicDns', 'openDns' or 'custom')
        """
        return pulumi.get(self, "dns_nameservers_option")

    @dns_nameservers_option.setter
    def dns_nameservers_option(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_nameservers_option", value)

    @property
    @pulumi.getter(name="fixedIpAssignments")
    def fixed_ip_assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgs']]]]:
        """
        Array of DHCP reserved IP assignments for the DHCP server running on the switch stack interface
        """
        return pulumi.get(self, "fixed_ip_assignments")

    @fixed_ip_assignments.setter
    def fixed_ip_assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgs']]]]):
        pulumi.set(self, "fixed_ip_assignments", value)

    @property
    @pulumi.getter(name="reservedIpRanges")
    def reserved_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgs']]]]:
        """
        Array of DHCP reserved IP assignments for the DHCP server running on the switch stack interface
        """
        return pulumi.get(self, "reserved_ip_ranges")

    @reserved_ip_ranges.setter
    def reserved_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgs']]]]):
        pulumi.set(self, "reserved_ip_ranges", value)


@pulumi.input_type
class _SwitchStacksRoutingInterfacesDhcpState:
    def __init__(__self__, *,
                 boot_file_name: Optional[pulumi.Input[builtins.str]] = None,
                 boot_next_server: Optional[pulumi.Input[builtins.str]] = None,
                 boot_options_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 dhcp_lease_time: Optional[pulumi.Input[builtins.str]] = None,
                 dhcp_mode: Optional[pulumi.Input[builtins.str]] = None,
                 dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpDhcpOptionArgs']]]] = None,
                 dhcp_relay_server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dns_custom_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dns_nameservers_option: Optional[pulumi.Input[builtins.str]] = None,
                 fixed_ip_assignments: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgs']]]] = None,
                 interface_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgs']]]] = None,
                 switch_stack_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SwitchStacksRoutingInterfacesDhcp resources.
        :param pulumi.Input[builtins.str] boot_file_name: The PXE boot server file name for the DHCP server running on the switch stack interface
        :param pulumi.Input[builtins.str] boot_next_server: The PXE boot server IP for the DHCP server running on the switch stack interface
        :param pulumi.Input[builtins.bool] boot_options_enabled: Enable DHCP boot options to provide PXE boot options configs for the dhcp server running on the switch stack interface
        :param pulumi.Input[builtins.str] dhcp_lease_time: The DHCP lease time config for the dhcp server running on the switch stack interface ('30 minutes', '1 hour', '4 hours', '12 hours', '1 day' or '1 week')
        :param pulumi.Input[builtins.str] dhcp_mode: The DHCP mode options for the switch stack interface ('dhcpDisabled', 'dhcpRelay' or 'dhcpServer')
        :param pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpDhcpOptionArgs']]] dhcp_options: Array of DHCP options consisting of code, type and value for the DHCP server running on the switch stack interface
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dhcp_relay_server_ips: The DHCP relay server IPs to which DHCP packets would get relayed for the switch stack interface
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_custom_nameservers: The DHCP name server IPs when DHCP name server option is 'custom'
        :param pulumi.Input[builtins.str] dns_nameservers_option: The DHCP name server option for the dhcp server running on the switch stack interface ('googlePublicDns', 'openDns' or 'custom')
        :param pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgs']]] fixed_ip_assignments: Array of DHCP reserved IP assignments for the DHCP server running on the switch stack interface
        :param pulumi.Input[builtins.str] interface_id: interfaceId path parameter. Interface ID
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgs']]] reserved_ip_ranges: Array of DHCP reserved IP assignments for the DHCP server running on the switch stack interface
        :param pulumi.Input[builtins.str] switch_stack_id: switchStackId path parameter. Switch stack ID
        """
        if boot_file_name is not None:
            pulumi.set(__self__, "boot_file_name", boot_file_name)
        if boot_next_server is not None:
            pulumi.set(__self__, "boot_next_server", boot_next_server)
        if boot_options_enabled is not None:
            pulumi.set(__self__, "boot_options_enabled", boot_options_enabled)
        if dhcp_lease_time is not None:
            pulumi.set(__self__, "dhcp_lease_time", dhcp_lease_time)
        if dhcp_mode is not None:
            pulumi.set(__self__, "dhcp_mode", dhcp_mode)
        if dhcp_options is not None:
            pulumi.set(__self__, "dhcp_options", dhcp_options)
        if dhcp_relay_server_ips is not None:
            pulumi.set(__self__, "dhcp_relay_server_ips", dhcp_relay_server_ips)
        if dns_custom_nameservers is not None:
            pulumi.set(__self__, "dns_custom_nameservers", dns_custom_nameservers)
        if dns_nameservers_option is not None:
            pulumi.set(__self__, "dns_nameservers_option", dns_nameservers_option)
        if fixed_ip_assignments is not None:
            pulumi.set(__self__, "fixed_ip_assignments", fixed_ip_assignments)
        if interface_id is not None:
            pulumi.set(__self__, "interface_id", interface_id)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if reserved_ip_ranges is not None:
            pulumi.set(__self__, "reserved_ip_ranges", reserved_ip_ranges)
        if switch_stack_id is not None:
            pulumi.set(__self__, "switch_stack_id", switch_stack_id)

    @property
    @pulumi.getter(name="bootFileName")
    def boot_file_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The PXE boot server file name for the DHCP server running on the switch stack interface
        """
        return pulumi.get(self, "boot_file_name")

    @boot_file_name.setter
    def boot_file_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "boot_file_name", value)

    @property
    @pulumi.getter(name="bootNextServer")
    def boot_next_server(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The PXE boot server IP for the DHCP server running on the switch stack interface
        """
        return pulumi.get(self, "boot_next_server")

    @boot_next_server.setter
    def boot_next_server(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "boot_next_server", value)

    @property
    @pulumi.getter(name="bootOptionsEnabled")
    def boot_options_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable DHCP boot options to provide PXE boot options configs for the dhcp server running on the switch stack interface
        """
        return pulumi.get(self, "boot_options_enabled")

    @boot_options_enabled.setter
    def boot_options_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "boot_options_enabled", value)

    @property
    @pulumi.getter(name="dhcpLeaseTime")
    def dhcp_lease_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DHCP lease time config for the dhcp server running on the switch stack interface ('30 minutes', '1 hour', '4 hours', '12 hours', '1 day' or '1 week')
        """
        return pulumi.get(self, "dhcp_lease_time")

    @dhcp_lease_time.setter
    def dhcp_lease_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dhcp_lease_time", value)

    @property
    @pulumi.getter(name="dhcpMode")
    def dhcp_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DHCP mode options for the switch stack interface ('dhcpDisabled', 'dhcpRelay' or 'dhcpServer')
        """
        return pulumi.get(self, "dhcp_mode")

    @dhcp_mode.setter
    def dhcp_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dhcp_mode", value)

    @property
    @pulumi.getter(name="dhcpOptions")
    def dhcp_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpDhcpOptionArgs']]]]:
        """
        Array of DHCP options consisting of code, type and value for the DHCP server running on the switch stack interface
        """
        return pulumi.get(self, "dhcp_options")

    @dhcp_options.setter
    def dhcp_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpDhcpOptionArgs']]]]):
        pulumi.set(self, "dhcp_options", value)

    @property
    @pulumi.getter(name="dhcpRelayServerIps")
    def dhcp_relay_server_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The DHCP relay server IPs to which DHCP packets would get relayed for the switch stack interface
        """
        return pulumi.get(self, "dhcp_relay_server_ips")

    @dhcp_relay_server_ips.setter
    def dhcp_relay_server_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dhcp_relay_server_ips", value)

    @property
    @pulumi.getter(name="dnsCustomNameservers")
    def dns_custom_nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The DHCP name server IPs when DHCP name server option is 'custom'
        """
        return pulumi.get(self, "dns_custom_nameservers")

    @dns_custom_nameservers.setter
    def dns_custom_nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dns_custom_nameservers", value)

    @property
    @pulumi.getter(name="dnsNameserversOption")
    def dns_nameservers_option(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DHCP name server option for the dhcp server running on the switch stack interface ('googlePublicDns', 'openDns' or 'custom')
        """
        return pulumi.get(self, "dns_nameservers_option")

    @dns_nameservers_option.setter
    def dns_nameservers_option(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_nameservers_option", value)

    @property
    @pulumi.getter(name="fixedIpAssignments")
    def fixed_ip_assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgs']]]]:
        """
        Array of DHCP reserved IP assignments for the DHCP server running on the switch stack interface
        """
        return pulumi.get(self, "fixed_ip_assignments")

    @fixed_ip_assignments.setter
    def fixed_ip_assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgs']]]]):
        pulumi.set(self, "fixed_ip_assignments", value)

    @property
    @pulumi.getter(name="interfaceId")
    def interface_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        interfaceId path parameter. Interface ID
        """
        return pulumi.get(self, "interface_id")

    @interface_id.setter
    def interface_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_id", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="reservedIpRanges")
    def reserved_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgs']]]]:
        """
        Array of DHCP reserved IP assignments for the DHCP server running on the switch stack interface
        """
        return pulumi.get(self, "reserved_ip_ranges")

    @reserved_ip_ranges.setter
    def reserved_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgs']]]]):
        pulumi.set(self, "reserved_ip_ranges", value)

    @property
    @pulumi.getter(name="switchStackId")
    def switch_stack_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        switchStackId path parameter. Switch stack ID
        """
        return pulumi.get(self, "switch_stack_id")

    @switch_stack_id.setter
    def switch_stack_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "switch_stack_id", value)


class SwitchStacksRoutingInterfacesDhcp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 boot_file_name: Optional[pulumi.Input[builtins.str]] = None,
                 boot_next_server: Optional[pulumi.Input[builtins.str]] = None,
                 boot_options_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 dhcp_lease_time: Optional[pulumi.Input[builtins.str]] = None,
                 dhcp_mode: Optional[pulumi.Input[builtins.str]] = None,
                 dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchStacksRoutingInterfacesDhcpDhcpOptionArgs', 'SwitchStacksRoutingInterfacesDhcpDhcpOptionArgsDict']]]]] = None,
                 dhcp_relay_server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dns_custom_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dns_nameservers_option: Optional[pulumi.Input[builtins.str]] = None,
                 fixed_ip_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgs', 'SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgsDict']]]]] = None,
                 interface_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgs', 'SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgsDict']]]]] = None,
                 switch_stack_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SwitchStacksRoutingInterfacesDhcp("example",
            boot_file_name="home_boot_file",
            boot_next_server="1.2.3.4",
            boot_options_enabled=True,
            dhcp_lease_time="1 day",
            dhcp_mode="dhcpServer",
            dhcp_options=[{
                "code": "5",
                "type": "text",
                "value": "five",
            }],
            dhcp_relay_server_ips=["1.2.3.4"],
            dns_custom_nameservers=["8.8.8.8, 8.8.4.4"],
            dns_nameservers_option="custom",
            fixed_ip_assignments=[{
                "ip": "192.168.1.12",
                "mac": "22:33:44:55:66:77",
                "name": "Cisco Meraki valued client",
            }],
            interface_id="string",
            network_id="string",
            reserved_ip_ranges=[{
                "comment": "A reserved IP range",
                "end": "192.168.1.10",
                "start": "192.168.1.1",
            }],
            switch_stack_id="string")
        pulumi.export("merakiNetworksSwitchStacksRoutingInterfacesDhcpExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchStacksRoutingInterfacesDhcp:SwitchStacksRoutingInterfacesDhcp example "interface_id,network_id,switch_stack_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] boot_file_name: The PXE boot server file name for the DHCP server running on the switch stack interface
        :param pulumi.Input[builtins.str] boot_next_server: The PXE boot server IP for the DHCP server running on the switch stack interface
        :param pulumi.Input[builtins.bool] boot_options_enabled: Enable DHCP boot options to provide PXE boot options configs for the dhcp server running on the switch stack interface
        :param pulumi.Input[builtins.str] dhcp_lease_time: The DHCP lease time config for the dhcp server running on the switch stack interface ('30 minutes', '1 hour', '4 hours', '12 hours', '1 day' or '1 week')
        :param pulumi.Input[builtins.str] dhcp_mode: The DHCP mode options for the switch stack interface ('dhcpDisabled', 'dhcpRelay' or 'dhcpServer')
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchStacksRoutingInterfacesDhcpDhcpOptionArgs', 'SwitchStacksRoutingInterfacesDhcpDhcpOptionArgsDict']]]] dhcp_options: Array of DHCP options consisting of code, type and value for the DHCP server running on the switch stack interface
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dhcp_relay_server_ips: The DHCP relay server IPs to which DHCP packets would get relayed for the switch stack interface
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_custom_nameservers: The DHCP name server IPs when DHCP name server option is 'custom'
        :param pulumi.Input[builtins.str] dns_nameservers_option: The DHCP name server option for the dhcp server running on the switch stack interface ('googlePublicDns', 'openDns' or 'custom')
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgs', 'SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgsDict']]]] fixed_ip_assignments: Array of DHCP reserved IP assignments for the DHCP server running on the switch stack interface
        :param pulumi.Input[builtins.str] interface_id: interfaceId path parameter. Interface ID
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgs', 'SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgsDict']]]] reserved_ip_ranges: Array of DHCP reserved IP assignments for the DHCP server running on the switch stack interface
        :param pulumi.Input[builtins.str] switch_stack_id: switchStackId path parameter. Switch stack ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SwitchStacksRoutingInterfacesDhcpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SwitchStacksRoutingInterfacesDhcp("example",
            boot_file_name="home_boot_file",
            boot_next_server="1.2.3.4",
            boot_options_enabled=True,
            dhcp_lease_time="1 day",
            dhcp_mode="dhcpServer",
            dhcp_options=[{
                "code": "5",
                "type": "text",
                "value": "five",
            }],
            dhcp_relay_server_ips=["1.2.3.4"],
            dns_custom_nameservers=["8.8.8.8, 8.8.4.4"],
            dns_nameservers_option="custom",
            fixed_ip_assignments=[{
                "ip": "192.168.1.12",
                "mac": "22:33:44:55:66:77",
                "name": "Cisco Meraki valued client",
            }],
            interface_id="string",
            network_id="string",
            reserved_ip_ranges=[{
                "comment": "A reserved IP range",
                "end": "192.168.1.10",
                "start": "192.168.1.1",
            }],
            switch_stack_id="string")
        pulumi.export("merakiNetworksSwitchStacksRoutingInterfacesDhcpExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchStacksRoutingInterfacesDhcp:SwitchStacksRoutingInterfacesDhcp example "interface_id,network_id,switch_stack_id"
        ```

        :param str resource_name: The name of the resource.
        :param SwitchStacksRoutingInterfacesDhcpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwitchStacksRoutingInterfacesDhcpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 boot_file_name: Optional[pulumi.Input[builtins.str]] = None,
                 boot_next_server: Optional[pulumi.Input[builtins.str]] = None,
                 boot_options_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 dhcp_lease_time: Optional[pulumi.Input[builtins.str]] = None,
                 dhcp_mode: Optional[pulumi.Input[builtins.str]] = None,
                 dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchStacksRoutingInterfacesDhcpDhcpOptionArgs', 'SwitchStacksRoutingInterfacesDhcpDhcpOptionArgsDict']]]]] = None,
                 dhcp_relay_server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dns_custom_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dns_nameservers_option: Optional[pulumi.Input[builtins.str]] = None,
                 fixed_ip_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgs', 'SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgsDict']]]]] = None,
                 interface_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgs', 'SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgsDict']]]]] = None,
                 switch_stack_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwitchStacksRoutingInterfacesDhcpArgs.__new__(SwitchStacksRoutingInterfacesDhcpArgs)

            __props__.__dict__["boot_file_name"] = boot_file_name
            __props__.__dict__["boot_next_server"] = boot_next_server
            __props__.__dict__["boot_options_enabled"] = boot_options_enabled
            __props__.__dict__["dhcp_lease_time"] = dhcp_lease_time
            __props__.__dict__["dhcp_mode"] = dhcp_mode
            __props__.__dict__["dhcp_options"] = dhcp_options
            __props__.__dict__["dhcp_relay_server_ips"] = dhcp_relay_server_ips
            __props__.__dict__["dns_custom_nameservers"] = dns_custom_nameservers
            __props__.__dict__["dns_nameservers_option"] = dns_nameservers_option
            __props__.__dict__["fixed_ip_assignments"] = fixed_ip_assignments
            if interface_id is None and not opts.urn:
                raise TypeError("Missing required property 'interface_id'")
            __props__.__dict__["interface_id"] = interface_id
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["reserved_ip_ranges"] = reserved_ip_ranges
            if switch_stack_id is None and not opts.urn:
                raise TypeError("Missing required property 'switch_stack_id'")
            __props__.__dict__["switch_stack_id"] = switch_stack_id
        super(SwitchStacksRoutingInterfacesDhcp, __self__).__init__(
            'meraki:networks/switchStacksRoutingInterfacesDhcp:SwitchStacksRoutingInterfacesDhcp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            boot_file_name: Optional[pulumi.Input[builtins.str]] = None,
            boot_next_server: Optional[pulumi.Input[builtins.str]] = None,
            boot_options_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            dhcp_lease_time: Optional[pulumi.Input[builtins.str]] = None,
            dhcp_mode: Optional[pulumi.Input[builtins.str]] = None,
            dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchStacksRoutingInterfacesDhcpDhcpOptionArgs', 'SwitchStacksRoutingInterfacesDhcpDhcpOptionArgsDict']]]]] = None,
            dhcp_relay_server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            dns_custom_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            dns_nameservers_option: Optional[pulumi.Input[builtins.str]] = None,
            fixed_ip_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgs', 'SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgsDict']]]]] = None,
            interface_id: Optional[pulumi.Input[builtins.str]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgs', 'SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgsDict']]]]] = None,
            switch_stack_id: Optional[pulumi.Input[builtins.str]] = None) -> 'SwitchStacksRoutingInterfacesDhcp':
        """
        Get an existing SwitchStacksRoutingInterfacesDhcp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] boot_file_name: The PXE boot server file name for the DHCP server running on the switch stack interface
        :param pulumi.Input[builtins.str] boot_next_server: The PXE boot server IP for the DHCP server running on the switch stack interface
        :param pulumi.Input[builtins.bool] boot_options_enabled: Enable DHCP boot options to provide PXE boot options configs for the dhcp server running on the switch stack interface
        :param pulumi.Input[builtins.str] dhcp_lease_time: The DHCP lease time config for the dhcp server running on the switch stack interface ('30 minutes', '1 hour', '4 hours', '12 hours', '1 day' or '1 week')
        :param pulumi.Input[builtins.str] dhcp_mode: The DHCP mode options for the switch stack interface ('dhcpDisabled', 'dhcpRelay' or 'dhcpServer')
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchStacksRoutingInterfacesDhcpDhcpOptionArgs', 'SwitchStacksRoutingInterfacesDhcpDhcpOptionArgsDict']]]] dhcp_options: Array of DHCP options consisting of code, type and value for the DHCP server running on the switch stack interface
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dhcp_relay_server_ips: The DHCP relay server IPs to which DHCP packets would get relayed for the switch stack interface
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_custom_nameservers: The DHCP name server IPs when DHCP name server option is 'custom'
        :param pulumi.Input[builtins.str] dns_nameservers_option: The DHCP name server option for the dhcp server running on the switch stack interface ('googlePublicDns', 'openDns' or 'custom')
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgs', 'SwitchStacksRoutingInterfacesDhcpFixedIpAssignmentArgsDict']]]] fixed_ip_assignments: Array of DHCP reserved IP assignments for the DHCP server running on the switch stack interface
        :param pulumi.Input[builtins.str] interface_id: interfaceId path parameter. Interface ID
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgs', 'SwitchStacksRoutingInterfacesDhcpReservedIpRangeArgsDict']]]] reserved_ip_ranges: Array of DHCP reserved IP assignments for the DHCP server running on the switch stack interface
        :param pulumi.Input[builtins.str] switch_stack_id: switchStackId path parameter. Switch stack ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwitchStacksRoutingInterfacesDhcpState.__new__(_SwitchStacksRoutingInterfacesDhcpState)

        __props__.__dict__["boot_file_name"] = boot_file_name
        __props__.__dict__["boot_next_server"] = boot_next_server
        __props__.__dict__["boot_options_enabled"] = boot_options_enabled
        __props__.__dict__["dhcp_lease_time"] = dhcp_lease_time
        __props__.__dict__["dhcp_mode"] = dhcp_mode
        __props__.__dict__["dhcp_options"] = dhcp_options
        __props__.__dict__["dhcp_relay_server_ips"] = dhcp_relay_server_ips
        __props__.__dict__["dns_custom_nameservers"] = dns_custom_nameservers
        __props__.__dict__["dns_nameservers_option"] = dns_nameservers_option
        __props__.__dict__["fixed_ip_assignments"] = fixed_ip_assignments
        __props__.__dict__["interface_id"] = interface_id
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["reserved_ip_ranges"] = reserved_ip_ranges
        __props__.__dict__["switch_stack_id"] = switch_stack_id
        return SwitchStacksRoutingInterfacesDhcp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bootFileName")
    def boot_file_name(self) -> pulumi.Output[builtins.str]:
        """
        The PXE boot server file name for the DHCP server running on the switch stack interface
        """
        return pulumi.get(self, "boot_file_name")

    @property
    @pulumi.getter(name="bootNextServer")
    def boot_next_server(self) -> pulumi.Output[builtins.str]:
        """
        The PXE boot server IP for the DHCP server running on the switch stack interface
        """
        return pulumi.get(self, "boot_next_server")

    @property
    @pulumi.getter(name="bootOptionsEnabled")
    def boot_options_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable DHCP boot options to provide PXE boot options configs for the dhcp server running on the switch stack interface
        """
        return pulumi.get(self, "boot_options_enabled")

    @property
    @pulumi.getter(name="dhcpLeaseTime")
    def dhcp_lease_time(self) -> pulumi.Output[builtins.str]:
        """
        The DHCP lease time config for the dhcp server running on the switch stack interface ('30 minutes', '1 hour', '4 hours', '12 hours', '1 day' or '1 week')
        """
        return pulumi.get(self, "dhcp_lease_time")

    @property
    @pulumi.getter(name="dhcpMode")
    def dhcp_mode(self) -> pulumi.Output[builtins.str]:
        """
        The DHCP mode options for the switch stack interface ('dhcpDisabled', 'dhcpRelay' or 'dhcpServer')
        """
        return pulumi.get(self, "dhcp_mode")

    @property
    @pulumi.getter(name="dhcpOptions")
    def dhcp_options(self) -> pulumi.Output[Sequence['outputs.SwitchStacksRoutingInterfacesDhcpDhcpOption']]:
        """
        Array of DHCP options consisting of code, type and value for the DHCP server running on the switch stack interface
        """
        return pulumi.get(self, "dhcp_options")

    @property
    @pulumi.getter(name="dhcpRelayServerIps")
    def dhcp_relay_server_ips(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The DHCP relay server IPs to which DHCP packets would get relayed for the switch stack interface
        """
        return pulumi.get(self, "dhcp_relay_server_ips")

    @property
    @pulumi.getter(name="dnsCustomNameservers")
    def dns_custom_nameservers(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The DHCP name server IPs when DHCP name server option is 'custom'
        """
        return pulumi.get(self, "dns_custom_nameservers")

    @property
    @pulumi.getter(name="dnsNameserversOption")
    def dns_nameservers_option(self) -> pulumi.Output[builtins.str]:
        """
        The DHCP name server option for the dhcp server running on the switch stack interface ('googlePublicDns', 'openDns' or 'custom')
        """
        return pulumi.get(self, "dns_nameservers_option")

    @property
    @pulumi.getter(name="fixedIpAssignments")
    def fixed_ip_assignments(self) -> pulumi.Output[Sequence['outputs.SwitchStacksRoutingInterfacesDhcpFixedIpAssignment']]:
        """
        Array of DHCP reserved IP assignments for the DHCP server running on the switch stack interface
        """
        return pulumi.get(self, "fixed_ip_assignments")

    @property
    @pulumi.getter(name="interfaceId")
    def interface_id(self) -> pulumi.Output[builtins.str]:
        """
        interfaceId path parameter. Interface ID
        """
        return pulumi.get(self, "interface_id")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="reservedIpRanges")
    def reserved_ip_ranges(self) -> pulumi.Output[Sequence['outputs.SwitchStacksRoutingInterfacesDhcpReservedIpRange']]:
        """
        Array of DHCP reserved IP assignments for the DHCP server running on the switch stack interface
        """
        return pulumi.get(self, "reserved_ip_ranges")

    @property
    @pulumi.getter(name="switchStackId")
    def switch_stack_id(self) -> pulumi.Output[builtins.str]:
        """
        switchStackId path parameter. Switch stack ID
        """
        return pulumi.get(self, "switch_stack_id")

