# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WirelessSsidsSplashSettingsArgs', 'WirelessSsidsSplashSettings']

@pulumi.input_type
class WirelessSsidsSplashSettingsArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 number: pulumi.Input[builtins.str],
                 allow_simultaneous_logins: Optional[pulumi.Input[builtins.bool]] = None,
                 billing: Optional[pulumi.Input['WirelessSsidsSplashSettingsBillingArgs']] = None,
                 block_all_traffic_before_sign_on: Optional[pulumi.Input[builtins.bool]] = None,
                 controller_disconnection_behavior: Optional[pulumi.Input[builtins.str]] = None,
                 guest_sponsorship: Optional[pulumi.Input['WirelessSsidsSplashSettingsGuestSponsorshipArgs']] = None,
                 redirect_url: Optional[pulumi.Input[builtins.str]] = None,
                 sentry_enrollment: Optional[pulumi.Input['WirelessSsidsSplashSettingsSentryEnrollmentArgs']] = None,
                 splash_image: Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashImageArgs']] = None,
                 splash_logo: Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashLogoArgs']] = None,
                 splash_prepaid_front: Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashPrepaidFrontArgs']] = None,
                 splash_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 splash_url: Optional[pulumi.Input[builtins.str]] = None,
                 theme_id: Optional[pulumi.Input[builtins.str]] = None,
                 use_redirect_url: Optional[pulumi.Input[builtins.bool]] = None,
                 use_splash_url: Optional[pulumi.Input[builtins.bool]] = None,
                 welcome_message: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a WirelessSsidsSplashSettings resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] number: number path parameter.
        :param pulumi.Input[builtins.bool] allow_simultaneous_logins: Whether or not to allow simultaneous logins from different devices.
        :param pulumi.Input['WirelessSsidsSplashSettingsBillingArgs'] billing: Details associated with billing splash
        :param pulumi.Input[builtins.bool] block_all_traffic_before_sign_on: How restricted allowing traffic should be. If true, all traffic types are blocked until the splash page is acknowledged. If false, all non-HTTP traffic is allowed before the splash page is acknowledged.
        :param pulumi.Input[builtins.str] controller_disconnection_behavior: How login attempts should be handled when the controller is unreachable.
        :param pulumi.Input['WirelessSsidsSplashSettingsGuestSponsorshipArgs'] guest_sponsorship: Details associated with guest sponsored splash
        :param pulumi.Input[builtins.str] redirect_url: The custom redirect URL where the users will go after the splash page.
        :param pulumi.Input['WirelessSsidsSplashSettingsSentryEnrollmentArgs'] sentry_enrollment: Systems Manager sentry enrollment splash settings.
        :param pulumi.Input['WirelessSsidsSplashSettingsSplashImageArgs'] splash_image: The image used in the splash page.
        :param pulumi.Input['WirelessSsidsSplashSettingsSplashLogoArgs'] splash_logo: The logo used in the splash page.
        :param pulumi.Input['WirelessSsidsSplashSettingsSplashPrepaidFrontArgs'] splash_prepaid_front: The prepaid front image used in the splash page.
        :param pulumi.Input[builtins.int] splash_timeout: Splash timeout in minutes.
        :param pulumi.Input[builtins.str] splash_url: The custom splash URL of the click-through splash page.
        :param pulumi.Input[builtins.str] theme_id: The id of the selected splash theme.
        :param pulumi.Input[builtins.bool] use_redirect_url: The Boolean indicating whether the the user will be redirected to the custom redirect URL after the splash page.
        :param pulumi.Input[builtins.bool] use_splash_url: Boolean indicating whether the users will be redirected to the custom splash url
        :param pulumi.Input[builtins.str] welcome_message: The welcome message for the users on the splash page.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "number", number)
        if allow_simultaneous_logins is not None:
            pulumi.set(__self__, "allow_simultaneous_logins", allow_simultaneous_logins)
        if billing is not None:
            pulumi.set(__self__, "billing", billing)
        if block_all_traffic_before_sign_on is not None:
            pulumi.set(__self__, "block_all_traffic_before_sign_on", block_all_traffic_before_sign_on)
        if controller_disconnection_behavior is not None:
            pulumi.set(__self__, "controller_disconnection_behavior", controller_disconnection_behavior)
        if guest_sponsorship is not None:
            pulumi.set(__self__, "guest_sponsorship", guest_sponsorship)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if sentry_enrollment is not None:
            pulumi.set(__self__, "sentry_enrollment", sentry_enrollment)
        if splash_image is not None:
            pulumi.set(__self__, "splash_image", splash_image)
        if splash_logo is not None:
            pulumi.set(__self__, "splash_logo", splash_logo)
        if splash_prepaid_front is not None:
            pulumi.set(__self__, "splash_prepaid_front", splash_prepaid_front)
        if splash_timeout is not None:
            pulumi.set(__self__, "splash_timeout", splash_timeout)
        if splash_url is not None:
            pulumi.set(__self__, "splash_url", splash_url)
        if theme_id is not None:
            pulumi.set(__self__, "theme_id", theme_id)
        if use_redirect_url is not None:
            pulumi.set(__self__, "use_redirect_url", use_redirect_url)
        if use_splash_url is not None:
            pulumi.set(__self__, "use_splash_url", use_splash_url)
        if welcome_message is not None:
            pulumi.set(__self__, "welcome_message", welcome_message)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def number(self) -> pulumi.Input[builtins.str]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter(name="allowSimultaneousLogins")
    def allow_simultaneous_logins(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not to allow simultaneous logins from different devices.
        """
        return pulumi.get(self, "allow_simultaneous_logins")

    @allow_simultaneous_logins.setter
    def allow_simultaneous_logins(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_simultaneous_logins", value)

    @property
    @pulumi.getter
    def billing(self) -> Optional[pulumi.Input['WirelessSsidsSplashSettingsBillingArgs']]:
        """
        Details associated with billing splash
        """
        return pulumi.get(self, "billing")

    @billing.setter
    def billing(self, value: Optional[pulumi.Input['WirelessSsidsSplashSettingsBillingArgs']]):
        pulumi.set(self, "billing", value)

    @property
    @pulumi.getter(name="blockAllTrafficBeforeSignOn")
    def block_all_traffic_before_sign_on(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        How restricted allowing traffic should be. If true, all traffic types are blocked until the splash page is acknowledged. If false, all non-HTTP traffic is allowed before the splash page is acknowledged.
        """
        return pulumi.get(self, "block_all_traffic_before_sign_on")

    @block_all_traffic_before_sign_on.setter
    def block_all_traffic_before_sign_on(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "block_all_traffic_before_sign_on", value)

    @property
    @pulumi.getter(name="controllerDisconnectionBehavior")
    def controller_disconnection_behavior(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How login attempts should be handled when the controller is unreachable.
        """
        return pulumi.get(self, "controller_disconnection_behavior")

    @controller_disconnection_behavior.setter
    def controller_disconnection_behavior(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "controller_disconnection_behavior", value)

    @property
    @pulumi.getter(name="guestSponsorship")
    def guest_sponsorship(self) -> Optional[pulumi.Input['WirelessSsidsSplashSettingsGuestSponsorshipArgs']]:
        """
        Details associated with guest sponsored splash
        """
        return pulumi.get(self, "guest_sponsorship")

    @guest_sponsorship.setter
    def guest_sponsorship(self, value: Optional[pulumi.Input['WirelessSsidsSplashSettingsGuestSponsorshipArgs']]):
        pulumi.set(self, "guest_sponsorship", value)

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The custom redirect URL where the users will go after the splash page.
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redirect_url", value)

    @property
    @pulumi.getter(name="sentryEnrollment")
    def sentry_enrollment(self) -> Optional[pulumi.Input['WirelessSsidsSplashSettingsSentryEnrollmentArgs']]:
        """
        Systems Manager sentry enrollment splash settings.
        """
        return pulumi.get(self, "sentry_enrollment")

    @sentry_enrollment.setter
    def sentry_enrollment(self, value: Optional[pulumi.Input['WirelessSsidsSplashSettingsSentryEnrollmentArgs']]):
        pulumi.set(self, "sentry_enrollment", value)

    @property
    @pulumi.getter(name="splashImage")
    def splash_image(self) -> Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashImageArgs']]:
        """
        The image used in the splash page.
        """
        return pulumi.get(self, "splash_image")

    @splash_image.setter
    def splash_image(self, value: Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashImageArgs']]):
        pulumi.set(self, "splash_image", value)

    @property
    @pulumi.getter(name="splashLogo")
    def splash_logo(self) -> Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashLogoArgs']]:
        """
        The logo used in the splash page.
        """
        return pulumi.get(self, "splash_logo")

    @splash_logo.setter
    def splash_logo(self, value: Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashLogoArgs']]):
        pulumi.set(self, "splash_logo", value)

    @property
    @pulumi.getter(name="splashPrepaidFront")
    def splash_prepaid_front(self) -> Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashPrepaidFrontArgs']]:
        """
        The prepaid front image used in the splash page.
        """
        return pulumi.get(self, "splash_prepaid_front")

    @splash_prepaid_front.setter
    def splash_prepaid_front(self, value: Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashPrepaidFrontArgs']]):
        pulumi.set(self, "splash_prepaid_front", value)

    @property
    @pulumi.getter(name="splashTimeout")
    def splash_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Splash timeout in minutes.
        """
        return pulumi.get(self, "splash_timeout")

    @splash_timeout.setter
    def splash_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "splash_timeout", value)

    @property
    @pulumi.getter(name="splashUrl")
    def splash_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The custom splash URL of the click-through splash page.
        """
        return pulumi.get(self, "splash_url")

    @splash_url.setter
    def splash_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "splash_url", value)

    @property
    @pulumi.getter(name="themeId")
    def theme_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the selected splash theme.
        """
        return pulumi.get(self, "theme_id")

    @theme_id.setter
    def theme_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "theme_id", value)

    @property
    @pulumi.getter(name="useRedirectUrl")
    def use_redirect_url(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The Boolean indicating whether the the user will be redirected to the custom redirect URL after the splash page.
        """
        return pulumi.get(self, "use_redirect_url")

    @use_redirect_url.setter
    def use_redirect_url(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_redirect_url", value)

    @property
    @pulumi.getter(name="useSplashUrl")
    def use_splash_url(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean indicating whether the users will be redirected to the custom splash url
        """
        return pulumi.get(self, "use_splash_url")

    @use_splash_url.setter
    def use_splash_url(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_splash_url", value)

    @property
    @pulumi.getter(name="welcomeMessage")
    def welcome_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The welcome message for the users on the splash page.
        """
        return pulumi.get(self, "welcome_message")

    @welcome_message.setter
    def welcome_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "welcome_message", value)


@pulumi.input_type
class _WirelessSsidsSplashSettingsState:
    def __init__(__self__, *,
                 allow_simultaneous_logins: Optional[pulumi.Input[builtins.bool]] = None,
                 billing: Optional[pulumi.Input['WirelessSsidsSplashSettingsBillingArgs']] = None,
                 block_all_traffic_before_sign_on: Optional[pulumi.Input[builtins.bool]] = None,
                 controller_disconnection_behavior: Optional[pulumi.Input[builtins.str]] = None,
                 guest_sponsorship: Optional[pulumi.Input['WirelessSsidsSplashSettingsGuestSponsorshipArgs']] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 number: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[builtins.str]] = None,
                 self_registration: Optional[pulumi.Input['WirelessSsidsSplashSettingsSelfRegistrationArgs']] = None,
                 sentry_enrollment: Optional[pulumi.Input['WirelessSsidsSplashSettingsSentryEnrollmentArgs']] = None,
                 splash_image: Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashImageArgs']] = None,
                 splash_logo: Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashLogoArgs']] = None,
                 splash_page: Optional[pulumi.Input[builtins.str]] = None,
                 splash_prepaid_front: Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashPrepaidFrontArgs']] = None,
                 splash_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 splash_url: Optional[pulumi.Input[builtins.str]] = None,
                 ssid_number: Optional[pulumi.Input[builtins.int]] = None,
                 theme_id: Optional[pulumi.Input[builtins.str]] = None,
                 use_redirect_url: Optional[pulumi.Input[builtins.bool]] = None,
                 use_splash_url: Optional[pulumi.Input[builtins.bool]] = None,
                 welcome_message: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WirelessSsidsSplashSettings resources.
        :param pulumi.Input[builtins.bool] allow_simultaneous_logins: Whether or not to allow simultaneous logins from different devices.
        :param pulumi.Input['WirelessSsidsSplashSettingsBillingArgs'] billing: Details associated with billing splash
        :param pulumi.Input[builtins.bool] block_all_traffic_before_sign_on: How restricted allowing traffic should be. If true, all traffic types are blocked until the splash page is acknowledged. If false, all non-HTTP traffic is allowed before the splash page is acknowledged.
        :param pulumi.Input[builtins.str] controller_disconnection_behavior: How login attempts should be handled when the controller is unreachable.
        :param pulumi.Input['WirelessSsidsSplashSettingsGuestSponsorshipArgs'] guest_sponsorship: Details associated with guest sponsored splash
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] number: number path parameter.
        :param pulumi.Input[builtins.str] redirect_url: The custom redirect URL where the users will go after the splash page.
        :param pulumi.Input['WirelessSsidsSplashSettingsSelfRegistrationArgs'] self_registration: Self-registration for splash with Meraki authentication.
        :param pulumi.Input['WirelessSsidsSplashSettingsSentryEnrollmentArgs'] sentry_enrollment: Systems Manager sentry enrollment splash settings.
        :param pulumi.Input['WirelessSsidsSplashSettingsSplashImageArgs'] splash_image: The image used in the splash page.
        :param pulumi.Input['WirelessSsidsSplashSettingsSplashLogoArgs'] splash_logo: The logo used in the splash page.
        :param pulumi.Input[builtins.str] splash_page: The type of splash page for this SSID
        :param pulumi.Input['WirelessSsidsSplashSettingsSplashPrepaidFrontArgs'] splash_prepaid_front: The prepaid front image used in the splash page.
        :param pulumi.Input[builtins.int] splash_timeout: Splash timeout in minutes.
        :param pulumi.Input[builtins.str] splash_url: The custom splash URL of the click-through splash page.
        :param pulumi.Input[builtins.int] ssid_number: SSID number
        :param pulumi.Input[builtins.str] theme_id: The id of the selected splash theme.
        :param pulumi.Input[builtins.bool] use_redirect_url: The Boolean indicating whether the the user will be redirected to the custom redirect URL after the splash page.
        :param pulumi.Input[builtins.bool] use_splash_url: Boolean indicating whether the users will be redirected to the custom splash url
        :param pulumi.Input[builtins.str] welcome_message: The welcome message for the users on the splash page.
        """
        if allow_simultaneous_logins is not None:
            pulumi.set(__self__, "allow_simultaneous_logins", allow_simultaneous_logins)
        if billing is not None:
            pulumi.set(__self__, "billing", billing)
        if block_all_traffic_before_sign_on is not None:
            pulumi.set(__self__, "block_all_traffic_before_sign_on", block_all_traffic_before_sign_on)
        if controller_disconnection_behavior is not None:
            pulumi.set(__self__, "controller_disconnection_behavior", controller_disconnection_behavior)
        if guest_sponsorship is not None:
            pulumi.set(__self__, "guest_sponsorship", guest_sponsorship)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if number is not None:
            pulumi.set(__self__, "number", number)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if self_registration is not None:
            pulumi.set(__self__, "self_registration", self_registration)
        if sentry_enrollment is not None:
            pulumi.set(__self__, "sentry_enrollment", sentry_enrollment)
        if splash_image is not None:
            pulumi.set(__self__, "splash_image", splash_image)
        if splash_logo is not None:
            pulumi.set(__self__, "splash_logo", splash_logo)
        if splash_page is not None:
            pulumi.set(__self__, "splash_page", splash_page)
        if splash_prepaid_front is not None:
            pulumi.set(__self__, "splash_prepaid_front", splash_prepaid_front)
        if splash_timeout is not None:
            pulumi.set(__self__, "splash_timeout", splash_timeout)
        if splash_url is not None:
            pulumi.set(__self__, "splash_url", splash_url)
        if ssid_number is not None:
            pulumi.set(__self__, "ssid_number", ssid_number)
        if theme_id is not None:
            pulumi.set(__self__, "theme_id", theme_id)
        if use_redirect_url is not None:
            pulumi.set(__self__, "use_redirect_url", use_redirect_url)
        if use_splash_url is not None:
            pulumi.set(__self__, "use_splash_url", use_splash_url)
        if welcome_message is not None:
            pulumi.set(__self__, "welcome_message", welcome_message)

    @property
    @pulumi.getter(name="allowSimultaneousLogins")
    def allow_simultaneous_logins(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not to allow simultaneous logins from different devices.
        """
        return pulumi.get(self, "allow_simultaneous_logins")

    @allow_simultaneous_logins.setter
    def allow_simultaneous_logins(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_simultaneous_logins", value)

    @property
    @pulumi.getter
    def billing(self) -> Optional[pulumi.Input['WirelessSsidsSplashSettingsBillingArgs']]:
        """
        Details associated with billing splash
        """
        return pulumi.get(self, "billing")

    @billing.setter
    def billing(self, value: Optional[pulumi.Input['WirelessSsidsSplashSettingsBillingArgs']]):
        pulumi.set(self, "billing", value)

    @property
    @pulumi.getter(name="blockAllTrafficBeforeSignOn")
    def block_all_traffic_before_sign_on(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        How restricted allowing traffic should be. If true, all traffic types are blocked until the splash page is acknowledged. If false, all non-HTTP traffic is allowed before the splash page is acknowledged.
        """
        return pulumi.get(self, "block_all_traffic_before_sign_on")

    @block_all_traffic_before_sign_on.setter
    def block_all_traffic_before_sign_on(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "block_all_traffic_before_sign_on", value)

    @property
    @pulumi.getter(name="controllerDisconnectionBehavior")
    def controller_disconnection_behavior(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How login attempts should be handled when the controller is unreachable.
        """
        return pulumi.get(self, "controller_disconnection_behavior")

    @controller_disconnection_behavior.setter
    def controller_disconnection_behavior(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "controller_disconnection_behavior", value)

    @property
    @pulumi.getter(name="guestSponsorship")
    def guest_sponsorship(self) -> Optional[pulumi.Input['WirelessSsidsSplashSettingsGuestSponsorshipArgs']]:
        """
        Details associated with guest sponsored splash
        """
        return pulumi.get(self, "guest_sponsorship")

    @guest_sponsorship.setter
    def guest_sponsorship(self, value: Optional[pulumi.Input['WirelessSsidsSplashSettingsGuestSponsorshipArgs']]):
        pulumi.set(self, "guest_sponsorship", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The custom redirect URL where the users will go after the splash page.
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redirect_url", value)

    @property
    @pulumi.getter(name="selfRegistration")
    def self_registration(self) -> Optional[pulumi.Input['WirelessSsidsSplashSettingsSelfRegistrationArgs']]:
        """
        Self-registration for splash with Meraki authentication.
        """
        return pulumi.get(self, "self_registration")

    @self_registration.setter
    def self_registration(self, value: Optional[pulumi.Input['WirelessSsidsSplashSettingsSelfRegistrationArgs']]):
        pulumi.set(self, "self_registration", value)

    @property
    @pulumi.getter(name="sentryEnrollment")
    def sentry_enrollment(self) -> Optional[pulumi.Input['WirelessSsidsSplashSettingsSentryEnrollmentArgs']]:
        """
        Systems Manager sentry enrollment splash settings.
        """
        return pulumi.get(self, "sentry_enrollment")

    @sentry_enrollment.setter
    def sentry_enrollment(self, value: Optional[pulumi.Input['WirelessSsidsSplashSettingsSentryEnrollmentArgs']]):
        pulumi.set(self, "sentry_enrollment", value)

    @property
    @pulumi.getter(name="splashImage")
    def splash_image(self) -> Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashImageArgs']]:
        """
        The image used in the splash page.
        """
        return pulumi.get(self, "splash_image")

    @splash_image.setter
    def splash_image(self, value: Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashImageArgs']]):
        pulumi.set(self, "splash_image", value)

    @property
    @pulumi.getter(name="splashLogo")
    def splash_logo(self) -> Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashLogoArgs']]:
        """
        The logo used in the splash page.
        """
        return pulumi.get(self, "splash_logo")

    @splash_logo.setter
    def splash_logo(self, value: Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashLogoArgs']]):
        pulumi.set(self, "splash_logo", value)

    @property
    @pulumi.getter(name="splashPage")
    def splash_page(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of splash page for this SSID
        """
        return pulumi.get(self, "splash_page")

    @splash_page.setter
    def splash_page(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "splash_page", value)

    @property
    @pulumi.getter(name="splashPrepaidFront")
    def splash_prepaid_front(self) -> Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashPrepaidFrontArgs']]:
        """
        The prepaid front image used in the splash page.
        """
        return pulumi.get(self, "splash_prepaid_front")

    @splash_prepaid_front.setter
    def splash_prepaid_front(self, value: Optional[pulumi.Input['WirelessSsidsSplashSettingsSplashPrepaidFrontArgs']]):
        pulumi.set(self, "splash_prepaid_front", value)

    @property
    @pulumi.getter(name="splashTimeout")
    def splash_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Splash timeout in minutes.
        """
        return pulumi.get(self, "splash_timeout")

    @splash_timeout.setter
    def splash_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "splash_timeout", value)

    @property
    @pulumi.getter(name="splashUrl")
    def splash_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The custom splash URL of the click-through splash page.
        """
        return pulumi.get(self, "splash_url")

    @splash_url.setter
    def splash_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "splash_url", value)

    @property
    @pulumi.getter(name="ssidNumber")
    def ssid_number(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        SSID number
        """
        return pulumi.get(self, "ssid_number")

    @ssid_number.setter
    def ssid_number(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ssid_number", value)

    @property
    @pulumi.getter(name="themeId")
    def theme_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the selected splash theme.
        """
        return pulumi.get(self, "theme_id")

    @theme_id.setter
    def theme_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "theme_id", value)

    @property
    @pulumi.getter(name="useRedirectUrl")
    def use_redirect_url(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The Boolean indicating whether the the user will be redirected to the custom redirect URL after the splash page.
        """
        return pulumi.get(self, "use_redirect_url")

    @use_redirect_url.setter
    def use_redirect_url(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_redirect_url", value)

    @property
    @pulumi.getter(name="useSplashUrl")
    def use_splash_url(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean indicating whether the users will be redirected to the custom splash url
        """
        return pulumi.get(self, "use_splash_url")

    @use_splash_url.setter
    def use_splash_url(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_splash_url", value)

    @property
    @pulumi.getter(name="welcomeMessage")
    def welcome_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The welcome message for the users on the splash page.
        """
        return pulumi.get(self, "welcome_message")

    @welcome_message.setter
    def welcome_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "welcome_message", value)


class WirelessSsidsSplashSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_simultaneous_logins: Optional[pulumi.Input[builtins.bool]] = None,
                 billing: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsBillingArgs', 'WirelessSsidsSplashSettingsBillingArgsDict']]] = None,
                 block_all_traffic_before_sign_on: Optional[pulumi.Input[builtins.bool]] = None,
                 controller_disconnection_behavior: Optional[pulumi.Input[builtins.str]] = None,
                 guest_sponsorship: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsGuestSponsorshipArgs', 'WirelessSsidsSplashSettingsGuestSponsorshipArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 number: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[builtins.str]] = None,
                 sentry_enrollment: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsSentryEnrollmentArgs', 'WirelessSsidsSplashSettingsSentryEnrollmentArgsDict']]] = None,
                 splash_image: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsSplashImageArgs', 'WirelessSsidsSplashSettingsSplashImageArgsDict']]] = None,
                 splash_logo: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsSplashLogoArgs', 'WirelessSsidsSplashSettingsSplashLogoArgsDict']]] = None,
                 splash_prepaid_front: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsSplashPrepaidFrontArgs', 'WirelessSsidsSplashSettingsSplashPrepaidFrontArgsDict']]] = None,
                 splash_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 splash_url: Optional[pulumi.Input[builtins.str]] = None,
                 theme_id: Optional[pulumi.Input[builtins.str]] = None,
                 use_redirect_url: Optional[pulumi.Input[builtins.bool]] = None,
                 use_splash_url: Optional[pulumi.Input[builtins.bool]] = None,
                 welcome_message: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessSsidsSplashSettings:WirelessSsidsSplashSettings example "network_id,number"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_simultaneous_logins: Whether or not to allow simultaneous logins from different devices.
        :param pulumi.Input[Union['WirelessSsidsSplashSettingsBillingArgs', 'WirelessSsidsSplashSettingsBillingArgsDict']] billing: Details associated with billing splash
        :param pulumi.Input[builtins.bool] block_all_traffic_before_sign_on: How restricted allowing traffic should be. If true, all traffic types are blocked until the splash page is acknowledged. If false, all non-HTTP traffic is allowed before the splash page is acknowledged.
        :param pulumi.Input[builtins.str] controller_disconnection_behavior: How login attempts should be handled when the controller is unreachable.
        :param pulumi.Input[Union['WirelessSsidsSplashSettingsGuestSponsorshipArgs', 'WirelessSsidsSplashSettingsGuestSponsorshipArgsDict']] guest_sponsorship: Details associated with guest sponsored splash
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] number: number path parameter.
        :param pulumi.Input[builtins.str] redirect_url: The custom redirect URL where the users will go after the splash page.
        :param pulumi.Input[Union['WirelessSsidsSplashSettingsSentryEnrollmentArgs', 'WirelessSsidsSplashSettingsSentryEnrollmentArgsDict']] sentry_enrollment: Systems Manager sentry enrollment splash settings.
        :param pulumi.Input[Union['WirelessSsidsSplashSettingsSplashImageArgs', 'WirelessSsidsSplashSettingsSplashImageArgsDict']] splash_image: The image used in the splash page.
        :param pulumi.Input[Union['WirelessSsidsSplashSettingsSplashLogoArgs', 'WirelessSsidsSplashSettingsSplashLogoArgsDict']] splash_logo: The logo used in the splash page.
        :param pulumi.Input[Union['WirelessSsidsSplashSettingsSplashPrepaidFrontArgs', 'WirelessSsidsSplashSettingsSplashPrepaidFrontArgsDict']] splash_prepaid_front: The prepaid front image used in the splash page.
        :param pulumi.Input[builtins.int] splash_timeout: Splash timeout in minutes.
        :param pulumi.Input[builtins.str] splash_url: The custom splash URL of the click-through splash page.
        :param pulumi.Input[builtins.str] theme_id: The id of the selected splash theme.
        :param pulumi.Input[builtins.bool] use_redirect_url: The Boolean indicating whether the the user will be redirected to the custom redirect URL after the splash page.
        :param pulumi.Input[builtins.bool] use_splash_url: Boolean indicating whether the users will be redirected to the custom splash url
        :param pulumi.Input[builtins.str] welcome_message: The welcome message for the users on the splash page.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WirelessSsidsSplashSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessSsidsSplashSettings:WirelessSsidsSplashSettings example "network_id,number"
        ```

        :param str resource_name: The name of the resource.
        :param WirelessSsidsSplashSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WirelessSsidsSplashSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_simultaneous_logins: Optional[pulumi.Input[builtins.bool]] = None,
                 billing: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsBillingArgs', 'WirelessSsidsSplashSettingsBillingArgsDict']]] = None,
                 block_all_traffic_before_sign_on: Optional[pulumi.Input[builtins.bool]] = None,
                 controller_disconnection_behavior: Optional[pulumi.Input[builtins.str]] = None,
                 guest_sponsorship: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsGuestSponsorshipArgs', 'WirelessSsidsSplashSettingsGuestSponsorshipArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 number: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[builtins.str]] = None,
                 sentry_enrollment: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsSentryEnrollmentArgs', 'WirelessSsidsSplashSettingsSentryEnrollmentArgsDict']]] = None,
                 splash_image: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsSplashImageArgs', 'WirelessSsidsSplashSettingsSplashImageArgsDict']]] = None,
                 splash_logo: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsSplashLogoArgs', 'WirelessSsidsSplashSettingsSplashLogoArgsDict']]] = None,
                 splash_prepaid_front: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsSplashPrepaidFrontArgs', 'WirelessSsidsSplashSettingsSplashPrepaidFrontArgsDict']]] = None,
                 splash_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 splash_url: Optional[pulumi.Input[builtins.str]] = None,
                 theme_id: Optional[pulumi.Input[builtins.str]] = None,
                 use_redirect_url: Optional[pulumi.Input[builtins.bool]] = None,
                 use_splash_url: Optional[pulumi.Input[builtins.bool]] = None,
                 welcome_message: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WirelessSsidsSplashSettingsArgs.__new__(WirelessSsidsSplashSettingsArgs)

            __props__.__dict__["allow_simultaneous_logins"] = allow_simultaneous_logins
            __props__.__dict__["billing"] = billing
            __props__.__dict__["block_all_traffic_before_sign_on"] = block_all_traffic_before_sign_on
            __props__.__dict__["controller_disconnection_behavior"] = controller_disconnection_behavior
            __props__.__dict__["guest_sponsorship"] = guest_sponsorship
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if number is None and not opts.urn:
                raise TypeError("Missing required property 'number'")
            __props__.__dict__["number"] = number
            __props__.__dict__["redirect_url"] = redirect_url
            __props__.__dict__["sentry_enrollment"] = sentry_enrollment
            __props__.__dict__["splash_image"] = splash_image
            __props__.__dict__["splash_logo"] = splash_logo
            __props__.__dict__["splash_prepaid_front"] = splash_prepaid_front
            __props__.__dict__["splash_timeout"] = splash_timeout
            __props__.__dict__["splash_url"] = splash_url
            __props__.__dict__["theme_id"] = theme_id
            __props__.__dict__["use_redirect_url"] = use_redirect_url
            __props__.__dict__["use_splash_url"] = use_splash_url
            __props__.__dict__["welcome_message"] = welcome_message
            __props__.__dict__["self_registration"] = None
            __props__.__dict__["splash_page"] = None
            __props__.__dict__["ssid_number"] = None
        super(WirelessSsidsSplashSettings, __self__).__init__(
            'meraki:networks/wirelessSsidsSplashSettings:WirelessSsidsSplashSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_simultaneous_logins: Optional[pulumi.Input[builtins.bool]] = None,
            billing: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsBillingArgs', 'WirelessSsidsSplashSettingsBillingArgsDict']]] = None,
            block_all_traffic_before_sign_on: Optional[pulumi.Input[builtins.bool]] = None,
            controller_disconnection_behavior: Optional[pulumi.Input[builtins.str]] = None,
            guest_sponsorship: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsGuestSponsorshipArgs', 'WirelessSsidsSplashSettingsGuestSponsorshipArgsDict']]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            number: Optional[pulumi.Input[builtins.str]] = None,
            redirect_url: Optional[pulumi.Input[builtins.str]] = None,
            self_registration: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsSelfRegistrationArgs', 'WirelessSsidsSplashSettingsSelfRegistrationArgsDict']]] = None,
            sentry_enrollment: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsSentryEnrollmentArgs', 'WirelessSsidsSplashSettingsSentryEnrollmentArgsDict']]] = None,
            splash_image: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsSplashImageArgs', 'WirelessSsidsSplashSettingsSplashImageArgsDict']]] = None,
            splash_logo: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsSplashLogoArgs', 'WirelessSsidsSplashSettingsSplashLogoArgsDict']]] = None,
            splash_page: Optional[pulumi.Input[builtins.str]] = None,
            splash_prepaid_front: Optional[pulumi.Input[Union['WirelessSsidsSplashSettingsSplashPrepaidFrontArgs', 'WirelessSsidsSplashSettingsSplashPrepaidFrontArgsDict']]] = None,
            splash_timeout: Optional[pulumi.Input[builtins.int]] = None,
            splash_url: Optional[pulumi.Input[builtins.str]] = None,
            ssid_number: Optional[pulumi.Input[builtins.int]] = None,
            theme_id: Optional[pulumi.Input[builtins.str]] = None,
            use_redirect_url: Optional[pulumi.Input[builtins.bool]] = None,
            use_splash_url: Optional[pulumi.Input[builtins.bool]] = None,
            welcome_message: Optional[pulumi.Input[builtins.str]] = None) -> 'WirelessSsidsSplashSettings':
        """
        Get an existing WirelessSsidsSplashSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_simultaneous_logins: Whether or not to allow simultaneous logins from different devices.
        :param pulumi.Input[Union['WirelessSsidsSplashSettingsBillingArgs', 'WirelessSsidsSplashSettingsBillingArgsDict']] billing: Details associated with billing splash
        :param pulumi.Input[builtins.bool] block_all_traffic_before_sign_on: How restricted allowing traffic should be. If true, all traffic types are blocked until the splash page is acknowledged. If false, all non-HTTP traffic is allowed before the splash page is acknowledged.
        :param pulumi.Input[builtins.str] controller_disconnection_behavior: How login attempts should be handled when the controller is unreachable.
        :param pulumi.Input[Union['WirelessSsidsSplashSettingsGuestSponsorshipArgs', 'WirelessSsidsSplashSettingsGuestSponsorshipArgsDict']] guest_sponsorship: Details associated with guest sponsored splash
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] number: number path parameter.
        :param pulumi.Input[builtins.str] redirect_url: The custom redirect URL where the users will go after the splash page.
        :param pulumi.Input[Union['WirelessSsidsSplashSettingsSelfRegistrationArgs', 'WirelessSsidsSplashSettingsSelfRegistrationArgsDict']] self_registration: Self-registration for splash with Meraki authentication.
        :param pulumi.Input[Union['WirelessSsidsSplashSettingsSentryEnrollmentArgs', 'WirelessSsidsSplashSettingsSentryEnrollmentArgsDict']] sentry_enrollment: Systems Manager sentry enrollment splash settings.
        :param pulumi.Input[Union['WirelessSsidsSplashSettingsSplashImageArgs', 'WirelessSsidsSplashSettingsSplashImageArgsDict']] splash_image: The image used in the splash page.
        :param pulumi.Input[Union['WirelessSsidsSplashSettingsSplashLogoArgs', 'WirelessSsidsSplashSettingsSplashLogoArgsDict']] splash_logo: The logo used in the splash page.
        :param pulumi.Input[builtins.str] splash_page: The type of splash page for this SSID
        :param pulumi.Input[Union['WirelessSsidsSplashSettingsSplashPrepaidFrontArgs', 'WirelessSsidsSplashSettingsSplashPrepaidFrontArgsDict']] splash_prepaid_front: The prepaid front image used in the splash page.
        :param pulumi.Input[builtins.int] splash_timeout: Splash timeout in minutes.
        :param pulumi.Input[builtins.str] splash_url: The custom splash URL of the click-through splash page.
        :param pulumi.Input[builtins.int] ssid_number: SSID number
        :param pulumi.Input[builtins.str] theme_id: The id of the selected splash theme.
        :param pulumi.Input[builtins.bool] use_redirect_url: The Boolean indicating whether the the user will be redirected to the custom redirect URL after the splash page.
        :param pulumi.Input[builtins.bool] use_splash_url: Boolean indicating whether the users will be redirected to the custom splash url
        :param pulumi.Input[builtins.str] welcome_message: The welcome message for the users on the splash page.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WirelessSsidsSplashSettingsState.__new__(_WirelessSsidsSplashSettingsState)

        __props__.__dict__["allow_simultaneous_logins"] = allow_simultaneous_logins
        __props__.__dict__["billing"] = billing
        __props__.__dict__["block_all_traffic_before_sign_on"] = block_all_traffic_before_sign_on
        __props__.__dict__["controller_disconnection_behavior"] = controller_disconnection_behavior
        __props__.__dict__["guest_sponsorship"] = guest_sponsorship
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["number"] = number
        __props__.__dict__["redirect_url"] = redirect_url
        __props__.__dict__["self_registration"] = self_registration
        __props__.__dict__["sentry_enrollment"] = sentry_enrollment
        __props__.__dict__["splash_image"] = splash_image
        __props__.__dict__["splash_logo"] = splash_logo
        __props__.__dict__["splash_page"] = splash_page
        __props__.__dict__["splash_prepaid_front"] = splash_prepaid_front
        __props__.__dict__["splash_timeout"] = splash_timeout
        __props__.__dict__["splash_url"] = splash_url
        __props__.__dict__["ssid_number"] = ssid_number
        __props__.__dict__["theme_id"] = theme_id
        __props__.__dict__["use_redirect_url"] = use_redirect_url
        __props__.__dict__["use_splash_url"] = use_splash_url
        __props__.__dict__["welcome_message"] = welcome_message
        return WirelessSsidsSplashSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowSimultaneousLogins")
    def allow_simultaneous_logins(self) -> pulumi.Output[builtins.bool]:
        """
        Whether or not to allow simultaneous logins from different devices.
        """
        return pulumi.get(self, "allow_simultaneous_logins")

    @property
    @pulumi.getter
    def billing(self) -> pulumi.Output['outputs.WirelessSsidsSplashSettingsBilling']:
        """
        Details associated with billing splash
        """
        return pulumi.get(self, "billing")

    @property
    @pulumi.getter(name="blockAllTrafficBeforeSignOn")
    def block_all_traffic_before_sign_on(self) -> pulumi.Output[builtins.bool]:
        """
        How restricted allowing traffic should be. If true, all traffic types are blocked until the splash page is acknowledged. If false, all non-HTTP traffic is allowed before the splash page is acknowledged.
        """
        return pulumi.get(self, "block_all_traffic_before_sign_on")

    @property
    @pulumi.getter(name="controllerDisconnectionBehavior")
    def controller_disconnection_behavior(self) -> pulumi.Output[builtins.str]:
        """
        How login attempts should be handled when the controller is unreachable.
        """
        return pulumi.get(self, "controller_disconnection_behavior")

    @property
    @pulumi.getter(name="guestSponsorship")
    def guest_sponsorship(self) -> pulumi.Output['outputs.WirelessSsidsSplashSettingsGuestSponsorship']:
        """
        Details associated with guest sponsored splash
        """
        return pulumi.get(self, "guest_sponsorship")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def number(self) -> pulumi.Output[builtins.str]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> pulumi.Output[builtins.str]:
        """
        The custom redirect URL where the users will go after the splash page.
        """
        return pulumi.get(self, "redirect_url")

    @property
    @pulumi.getter(name="selfRegistration")
    def self_registration(self) -> pulumi.Output['outputs.WirelessSsidsSplashSettingsSelfRegistration']:
        """
        Self-registration for splash with Meraki authentication.
        """
        return pulumi.get(self, "self_registration")

    @property
    @pulumi.getter(name="sentryEnrollment")
    def sentry_enrollment(self) -> pulumi.Output['outputs.WirelessSsidsSplashSettingsSentryEnrollment']:
        """
        Systems Manager sentry enrollment splash settings.
        """
        return pulumi.get(self, "sentry_enrollment")

    @property
    @pulumi.getter(name="splashImage")
    def splash_image(self) -> pulumi.Output['outputs.WirelessSsidsSplashSettingsSplashImage']:
        """
        The image used in the splash page.
        """
        return pulumi.get(self, "splash_image")

    @property
    @pulumi.getter(name="splashLogo")
    def splash_logo(self) -> pulumi.Output['outputs.WirelessSsidsSplashSettingsSplashLogo']:
        """
        The logo used in the splash page.
        """
        return pulumi.get(self, "splash_logo")

    @property
    @pulumi.getter(name="splashPage")
    def splash_page(self) -> pulumi.Output[builtins.str]:
        """
        The type of splash page for this SSID
        """
        return pulumi.get(self, "splash_page")

    @property
    @pulumi.getter(name="splashPrepaidFront")
    def splash_prepaid_front(self) -> pulumi.Output['outputs.WirelessSsidsSplashSettingsSplashPrepaidFront']:
        """
        The prepaid front image used in the splash page.
        """
        return pulumi.get(self, "splash_prepaid_front")

    @property
    @pulumi.getter(name="splashTimeout")
    def splash_timeout(self) -> pulumi.Output[builtins.int]:
        """
        Splash timeout in minutes.
        """
        return pulumi.get(self, "splash_timeout")

    @property
    @pulumi.getter(name="splashUrl")
    def splash_url(self) -> pulumi.Output[builtins.str]:
        """
        The custom splash URL of the click-through splash page.
        """
        return pulumi.get(self, "splash_url")

    @property
    @pulumi.getter(name="ssidNumber")
    def ssid_number(self) -> pulumi.Output[builtins.int]:
        """
        SSID number
        """
        return pulumi.get(self, "ssid_number")

    @property
    @pulumi.getter(name="themeId")
    def theme_id(self) -> pulumi.Output[builtins.str]:
        """
        The id of the selected splash theme.
        """
        return pulumi.get(self, "theme_id")

    @property
    @pulumi.getter(name="useRedirectUrl")
    def use_redirect_url(self) -> pulumi.Output[builtins.bool]:
        """
        The Boolean indicating whether the the user will be redirected to the custom redirect URL after the splash page.
        """
        return pulumi.get(self, "use_redirect_url")

    @property
    @pulumi.getter(name="useSplashUrl")
    def use_splash_url(self) -> pulumi.Output[builtins.bool]:
        """
        Boolean indicating whether the users will be redirected to the custom splash url
        """
        return pulumi.get(self, "use_splash_url")

    @property
    @pulumi.getter(name="welcomeMessage")
    def welcome_message(self) -> pulumi.Output[builtins.str]:
        """
        The welcome message for the users on the splash page.
        """
        return pulumi.get(self, "welcome_message")

