# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AdaptivePolicySettingsArgs', 'AdaptivePolicySettings']

@pulumi.input_type
class AdaptivePolicySettingsArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[builtins.str],
                 enabled_networks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a AdaptivePolicySettings resource.
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] enabled_networks: List of network IDs with adaptive policy enabled
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if enabled_networks is not None:
            pulumi.set(__self__, "enabled_networks", enabled_networks)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="enabledNetworks")
    def enabled_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of network IDs with adaptive policy enabled
        """
        return pulumi.get(self, "enabled_networks")

    @enabled_networks.setter
    def enabled_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "enabled_networks", value)


@pulumi.input_type
class _AdaptivePolicySettingsState:
    def __init__(__self__, *,
                 enabled_networks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AdaptivePolicySettings resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] enabled_networks: List of network IDs with adaptive policy enabled
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        """
        if enabled_networks is not None:
            pulumi.set(__self__, "enabled_networks", enabled_networks)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)

    @property
    @pulumi.getter(name="enabledNetworks")
    def enabled_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of network IDs with adaptive policy enabled
        """
        return pulumi.get(self, "enabled_networks")

    @enabled_networks.setter
    def enabled_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "enabled_networks", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)


class AdaptivePolicySettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled_networks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.AdaptivePolicySettings("example",
            enabled_networks=[
                "L_11111111",
                "L_22222222",
                "N_33333333",
                "L_44444444",
            ],
            organization_id="string")
        pulumi.export("merakiOrganizationsAdaptivePolicySettingsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/adaptivePolicySettings:AdaptivePolicySettings example "organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] enabled_networks: List of network IDs with adaptive policy enabled
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AdaptivePolicySettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.AdaptivePolicySettings("example",
            enabled_networks=[
                "L_11111111",
                "L_22222222",
                "N_33333333",
                "L_44444444",
            ],
            organization_id="string")
        pulumi.export("merakiOrganizationsAdaptivePolicySettingsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/adaptivePolicySettings:AdaptivePolicySettings example "organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param AdaptivePolicySettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AdaptivePolicySettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled_networks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AdaptivePolicySettingsArgs.__new__(AdaptivePolicySettingsArgs)

            __props__.__dict__["enabled_networks"] = enabled_networks
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
        super(AdaptivePolicySettings, __self__).__init__(
            'meraki:organizations/adaptivePolicySettings:AdaptivePolicySettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled_networks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None) -> 'AdaptivePolicySettings':
        """
        Get an existing AdaptivePolicySettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] enabled_networks: List of network IDs with adaptive policy enabled
        :param pulumi.Input[builtins.str] organization_id: organizationId path parameter. Organization ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AdaptivePolicySettingsState.__new__(_AdaptivePolicySettingsState)

        __props__.__dict__["enabled_networks"] = enabled_networks
        __props__.__dict__["organization_id"] = organization_id
        return AdaptivePolicySettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enabledNetworks")
    def enabled_networks(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of network IDs with adaptive policy enabled
        """
        return pulumi.get(self, "enabled_networks")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

