# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.6.2006

    Generated by OpenAPI Generator: 6.5.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, conint, constr, validator

class CalculationSettings(BaseModel):
    """
    Calculation settings.
    """
    max_calculation_time: Optional[constr(strict=True, max_length=16, min_length=3)] = Field('PT20M', description="Max calculation time. The countdown starts from the time when data is uploaded to the server and calculation starts. ")
    max_waiting_time: Optional[constr(strict=True, max_length=16, min_length=3)] = Field('PT30M', description="Max calculation time. The countdown starts from the time when data is uploaded to the server. ")
    result_ttl: Optional[constr(strict=True, max_length=16, min_length=3)] = Field('PT20M', description="Calculation result lifetime. The countdown starts from the time when the calculation is completed. ")
    result_timezone: Optional[conint(strict=True, le=12, ge=-12)] = Field(0, description="The time zone where the calculation result is returned. ")
    treat_warnings_as_errors: Optional[StrictBool] = Field(False, description="Treat warnings as errors. ")
    precision: Optional[conint(strict=True, le=6, ge=0)] = Field(2, description="Specifies the calculation accuracy in the decimal point sequence number. It equals 2 by default, so the accuracy is 0.01. ")
    __properties = ["max_calculation_time", "max_waiting_time", "result_ttl", "result_timezone", "treat_warnings_as_errors", "precision"]

    @validator('max_calculation_time')
    def max_calculation_time_validate_regular_expression(cls, v):
        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", v):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return v

    @validator('max_waiting_time')
    def max_waiting_time_validate_regular_expression(cls, v):
        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", v):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return v

    @validator('result_ttl')
    def result_ttl_validate_regular_expression(cls, v):
        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", v):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CalculationSettings:
        """Create an instance of CalculationSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CalculationSettings:
        """Create an instance of CalculationSettings from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CalculationSettings.parse_obj(obj)

        _obj = CalculationSettings.parse_obj({
            "max_calculation_time": obj.get("max_calculation_time") if obj.get("max_calculation_time") is not None else 'PT20M',
            "max_waiting_time": obj.get("max_waiting_time") if obj.get("max_waiting_time") is not None else 'PT30M',
            "result_ttl": obj.get("result_ttl") if obj.get("result_ttl") is not None else 'PT20M',
            "result_timezone": obj.get("result_timezone") if obj.get("result_timezone") is not None else 0,
            "treat_warnings_as_errors": obj.get("treat_warnings_as_errors") if obj.get("treat_warnings_as_errors") is not None else False,
            "precision": obj.get("precision") if obj.get("precision") is not None else 2
        })
        return _obj

