# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.6.2006

    Generated by OpenAPI Generator: 6.5.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist, constr
from vrt_lss_agro.models.capacity_forecast_element import CapacityForecastElement
from vrt_lss_agro.models.cost_forecast_element import CostForecastElement
from vrt_lss_agro.models.productivity_forecast_element import ProductivityForecastElement

class Chamber(BaseModel):
    """
    A chamber. 
    """
    crop_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Target key.")
    capacity_forecast: conlist(CapacityForecastElement, max_items=3653, min_items=0) = Field(..., description="Capacity forecast.")
    productivity_forecast: conlist(ProductivityForecastElement, max_items=3653, min_items=0) = Field(..., description="Productivity forecast.")
    cost_forecast: Optional[conlist(CostForecastElement, max_items=3653, min_items=0)] = Field(None, description="Cost forecast.")
    __properties = ["crop_key", "capacity_forecast", "productivity_forecast", "cost_forecast"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Chamber:
        """Create an instance of Chamber from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in capacity_forecast (list)
        _items = []
        if self.capacity_forecast:
            for _item in self.capacity_forecast:
                if _item:
                    _items.append(_item.to_dict())
            _dict['capacity_forecast'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in productivity_forecast (list)
        _items = []
        if self.productivity_forecast:
            for _item in self.productivity_forecast:
                if _item:
                    _items.append(_item.to_dict())
            _dict['productivity_forecast'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cost_forecast (list)
        _items = []
        if self.cost_forecast:
            for _item in self.cost_forecast:
                if _item:
                    _items.append(_item.to_dict())
            _dict['cost_forecast'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Chamber:
        """Create an instance of Chamber from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Chamber.parse_obj(obj)

        _obj = Chamber.parse_obj({
            "crop_key": obj.get("crop_key"),
            "capacity_forecast": [CapacityForecastElement.from_dict(_item) for _item in obj.get("capacity_forecast")] if obj.get("capacity_forecast") is not None else None,
            "productivity_forecast": [ProductivityForecastElement.from_dict(_item) for _item in obj.get("productivity_forecast")] if obj.get("productivity_forecast") is not None else None,
            "cost_forecast": [CostForecastElement.from_dict(_item) for _item in obj.get("cost_forecast")] if obj.get("cost_forecast") is not None else None
        })
        return _obj

