# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.6.2006

    Generated by OpenAPI Generator: 6.5.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, confloat, conint

class PlanStatistics(BaseModel):
    """
    General statistics. 
    """
    days_count: conint(strict=True, le=3653, ge=0) = Field(..., description="The number of planned fields.")
    fields_count: conint(strict=True, le=10001, ge=0) = Field(..., description="The total number of planned fields.")
    fields_part_count: conint(strict=True, le=10001, ge=0) = Field(..., description="Total number of partially harvested fields.")
    elevators_count: conint(strict=True, le=10001, ge=0) = Field(..., description="The total number of planned elevators.")
    factory_count: conint(strict=True, le=10001, ge=0) = Field(..., description="The total number of planned factories.")
    markets_count: conint(strict=True, le=10001, ge=0) = Field(..., description="The total number of planned markets.")
    total_distance: conint(strict=True, le=10000000000, ge=0) = Field(..., description="Total mileage, in km.")
    total_cost: confloat(le=10000000000, ge=0, strict=True) = Field(..., description="The total cost of all transactions, in conventional monetary units.")
    __properties = ["days_count", "fields_count", "fields_part_count", "elevators_count", "factory_count", "markets_count", "total_distance", "total_cost"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PlanStatistics:
        """Create an instance of PlanStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PlanStatistics:
        """Create an instance of PlanStatistics from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PlanStatistics.parse_obj(obj)

        _obj = PlanStatistics.parse_obj({
            "days_count": obj.get("days_count"),
            "fields_count": obj.get("fields_count"),
            "fields_part_count": obj.get("fields_part_count"),
            "elevators_count": obj.get("elevators_count"),
            "factory_count": obj.get("factory_count"),
            "markets_count": obj.get("markets_count"),
            "total_distance": obj.get("total_distance"),
            "total_cost": obj.get("total_cost")
        })
        return _obj

