/*
 * Decompiled with CFR 0.152.
 */
package org.ray.api.options;

import java.util.HashMap;
import java.util.Map;
import org.ray.api.options.BaseTaskOptions;

public class ActorCreationOptions
extends BaseTaskOptions {
    public static final int NO_RECONSTRUCTION = 0;
    public static final int INFINITE_RECONSTRUCTION = (int)Math.pow(2.0, 30.0);
    public static final boolean DEFAULT_USE_DIRECT_CALL = "1".equals(System.getenv("ACTOR_CREATION_OPTIONS_DEFAULT_USE_DIRECT_CALL"));
    public final int maxReconstructions;
    public final boolean useDirectCall;
    public final String jvmOptions;

    private ActorCreationOptions(Map<String, Double> resources, int maxReconstructions, boolean useDirectCall, String jvmOptions) {
        super(resources);
        this.maxReconstructions = maxReconstructions;
        this.useDirectCall = useDirectCall;
        this.jvmOptions = jvmOptions;
    }

    public static class Builder {
        private Map<String, Double> resources = new HashMap<String, Double>();
        private int maxReconstructions = 0;
        private boolean useDirectCall = DEFAULT_USE_DIRECT_CALL;
        private String jvmOptions = null;

        public Builder setResources(Map<String, Double> resources) {
            this.resources = resources;
            return this;
        }

        public Builder setMaxReconstructions(int maxReconstructions) {
            this.maxReconstructions = maxReconstructions;
            return this;
        }

        public Builder setJvmOptions(String jvmOptions) {
            this.jvmOptions = jvmOptions;
            return this;
        }

        public ActorCreationOptions createActorCreationOptions() {
            return new ActorCreationOptions(this.resources, this.maxReconstructions, this.useDirectCall, this.jvmOptions);
        }
    }
}

