/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime;

import java.util.concurrent.atomic.AtomicInteger;
import org.ray.api.RayActor;
import org.ray.api.id.JobId;
import org.ray.api.id.ObjectId;
import org.ray.api.id.UniqueId;
import org.ray.runtime.AbstractRayRuntime;
import org.ray.runtime.config.RayConfig;
import org.ray.runtime.context.LocalModeWorkerContext;
import org.ray.runtime.functionmanager.FunctionManager;
import org.ray.runtime.object.LocalModeObjectStore;
import org.ray.runtime.task.LocalModeTaskExecutor;
import org.ray.runtime.task.LocalModeTaskSubmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RayDevRuntime
extends AbstractRayRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(RayDevRuntime.class);
    private AtomicInteger jobCounter = new AtomicInteger(0);

    public RayDevRuntime(RayConfig rayConfig, FunctionManager functionManager) {
        super(rayConfig, functionManager);
        if (rayConfig.getJobId().isNil()) {
            rayConfig.setJobId(this.nextJobId());
        }
        this.taskExecutor = new LocalModeTaskExecutor(this);
        this.workerContext = new LocalModeWorkerContext(rayConfig.getJobId());
        this.objectStore = new LocalModeObjectStore(this.workerContext);
        this.taskSubmitter = new LocalModeTaskSubmitter(this, (LocalModeObjectStore)this.objectStore, rayConfig.numberExecThreadsForDevRuntime);
        ((LocalModeObjectStore)this.objectStore).addObjectPutCallback(objectId -> ((LocalModeTaskSubmitter)this.taskSubmitter).onObjectPut((ObjectId)objectId));
    }

    @Override
    public void shutdown() {
        if (this.taskSubmitter != null) {
            ((LocalModeTaskSubmitter)this.taskSubmitter).shutdown();
            this.taskSubmitter = null;
        }
        this.taskExecutor = null;
    }

    @Override
    public void setResource(String resourceName, double capacity, UniqueId nodeId) {
        LOGGER.error("Not implemented under SINGLE_PROCESS mode.");
    }

    @Override
    public void killActor(RayActor<?> actor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getAsyncContext() {
        return null;
    }

    @Override
    public void setAsyncContext(Object asyncContext) {
    }

    private JobId nextJobId() {
        return JobId.fromInt(this.jobCounter.getAndIncrement());
    }
}

