/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ray.api.id.JobId;
import org.ray.runtime.config.RunMode;
import org.ray.runtime.generated.Common;
import org.ray.runtime.util.NetworkUtil;
import org.ray.runtime.util.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RayConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RayConfig.class);
    public static final String DEFAULT_CONFIG_FILE = "ray.default.conf";
    public static final String CUSTOM_CONFIG_FILE = "ray.conf";
    public final String nodeIp;
    public final Common.WorkerType workerMode;
    public final RunMode runMode;
    public final Map<String, Double> resources;
    private JobId jobId;
    public final String logDir;
    public final boolean redirectOutput;
    public final List<String> libraryPath;
    public final List<String> classpath;
    public final List<String> jvmParameters;
    private String redisAddress;
    private String redisIp;
    private Integer redisPort;
    public final int headRedisPort;
    public final int numberRedisShards;
    public final String headRedisPassword;
    public final String redisPassword;
    public final String objectStoreSocketName;
    public final Long objectStoreSize;
    public final String rayletSocketName;
    private int nodeManagerPort;
    public final List<String> rayletConfigParameters;
    public final String jobResourcePath;
    public final String pythonWorkerCommand;
    public final int numberExecThreadsForDevRuntime;
    public final int numWorkersPerProcess;

    private void validate() {
        if (this.workerMode == Common.WorkerType.WORKER) {
            Preconditions.checkArgument(this.redisAddress != null, "Redis address must be set in worker mode.");
        }
    }

    private String removeTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public RayConfig(Config config) {
        String jobId;
        Common.WorkerType localWorkerMode;
        try {
            localWorkerMode = config.getEnum(Common.WorkerType.class, "ray.worker.mode");
        }
        catch (ConfigException.Missing e) {
            localWorkerMode = Common.WorkerType.DRIVER;
        }
        this.workerMode = localWorkerMode;
        boolean isDriver = this.workerMode == Common.WorkerType.DRIVER;
        this.runMode = config.getEnum(RunMode.class, "ray.run-mode");
        String nodeIp = config.getString("ray.node-ip");
        if (nodeIp.isEmpty()) {
            nodeIp = NetworkUtil.getIpAddress(null);
        }
        this.nodeIp = nodeIp;
        this.resources = ResourceUtil.getResourcesMapFromString(config.getString("ray.resources"));
        if (isDriver && !this.resources.containsKey("CPU")) {
            int numCpu = Runtime.getRuntime().availableProcessors();
            LOGGER.warn("No CPU resource is set in configuration, setting it to the number of CPU cores: {}", (Object)numCpu);
            this.resources.put("CPU", (double)numCpu * 1.0);
        }
        this.jobId = !(jobId = config.getString("ray.job.id")).isEmpty() ? JobId.fromHexString(jobId) : JobId.NIL;
        this.logDir = this.removeTrailingSlash(config.getString("ray.log-dir"));
        this.redirectOutput = config.getBoolean("ray.redirect-output");
        this.libraryPath = config.getStringList("ray.library.path");
        this.classpath = config.getStringList("ray.classpath");
        this.jvmParameters = config.hasPath("ray.worker.jvm-parameters") ? config.getStringList("ray.worker.jvm-parameters") : ImmutableList.of();
        this.pythonWorkerCommand = config.hasPath("ray.worker.python-command") ? config.getString("ray.worker.python-command") : null;
        String redisAddress = config.getString("ray.redis.address");
        if (!redisAddress.isEmpty()) {
            this.setRedisAddress(redisAddress);
        } else {
            this.redisAddress = null;
        }
        this.headRedisPort = config.getInt("ray.redis.head-port");
        this.numberRedisShards = config.getInt("ray.redis.shard-number");
        this.headRedisPassword = config.getString("ray.redis.head-password");
        this.redisPassword = config.getString("ray.redis.password");
        this.objectStoreSocketName = config.getString("ray.object-store.socket-name");
        this.objectStoreSize = config.getBytes("ray.object-store.size");
        this.rayletSocketName = config.getString("ray.raylet.socket-name");
        this.nodeManagerPort = config.getInt("ray.raylet.node-manager-port");
        if (this.nodeManagerPort == 0) {
            Preconditions.checkState(this.redisAddress == null, "Java worker started by raylet should accept the node manager port from raylet.");
            this.nodeManagerPort = NetworkUtil.getUnusedPort();
        }
        this.rayletConfigParameters = new ArrayList<String>();
        Config rayletConfig = config.getConfig("ray.raylet.config");
        for (Map.Entry<String, ConfigValue> entry : rayletConfig.entrySet()) {
            String parameter = entry.getKey() + "," + entry.getValue().unwrapped();
            this.rayletConfigParameters.add(parameter);
        }
        this.jobResourcePath = config.hasPath("ray.job.resource-path") ? config.getString("ray.job.resource-path") : null;
        this.numberExecThreadsForDevRuntime = config.getInt("ray.dev-runtime.execution-parallelism");
        this.numWorkersPerProcess = config.getInt("ray.raylet.config.num_workers_per_process_java");
        this.validate();
        LOGGER.debug("Created config: {}", (Object)this);
    }

    public void setRedisAddress(String redisAddress) {
        Preconditions.checkNotNull(redisAddress);
        Preconditions.checkState(this.redisAddress == null, "Redis address was already set");
        this.redisAddress = redisAddress;
        String[] ipAndPort = redisAddress.split(":");
        Preconditions.checkArgument(ipAndPort.length == 2, "Invalid redis address.");
        this.redisIp = ipAndPort[0];
        this.redisPort = Integer.parseInt(ipAndPort[1]);
    }

    public String getRedisAddress() {
        return this.redisAddress;
    }

    public String getRedisIp() {
        return this.redisIp;
    }

    public Integer getRedisPort() {
        return this.redisPort;
    }

    public void setJobId(JobId jobId) {
        this.jobId = jobId;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public int getNodeManagerPort() {
        return this.nodeManagerPort;
    }

    public String toString() {
        return "RayConfig{, nodeIp='" + this.nodeIp + '\'' + ", workerMode=" + this.workerMode + ", runMode=" + (Object)((Object)this.runMode) + ", resources=" + this.resources + ", jobId=" + this.jobId + ", logDir='" + this.logDir + '\'' + ", redirectOutput=" + this.redirectOutput + ", libraryPath=" + this.libraryPath + ", classpath=" + this.classpath + ", jvmParameters=" + this.jvmParameters + ", redisAddress='" + this.redisAddress + '\'' + ", redisIp='" + this.redisIp + '\'' + ", redisPort=" + this.redisPort + ", headRedisPort=" + this.headRedisPort + ", numberRedisShards=" + this.numberRedisShards + ", objectStoreSocketName='" + this.objectStoreSocketName + '\'' + ", objectStoreSize=" + this.objectStoreSize + ", rayletSocketName='" + this.rayletSocketName + '\'' + ", rayletConfigParameters=" + this.rayletConfigParameters + ", jobResourcePath='" + this.jobResourcePath + '\'' + ", pythonWorkerCommand='" + this.pythonWorkerCommand + '\'' + '}';
    }

    public static RayConfig create() {
        ConfigFactory.invalidateCaches();
        Config config = ConfigFactory.systemProperties();
        String configPath = System.getProperty("ray.config");
        if (Strings.isNullOrEmpty(configPath)) {
            LOGGER.info("Loading config from \"ray.conf\" file in classpath.");
            config = config.withFallback(ConfigFactory.load(CUSTOM_CONFIG_FILE));
        } else {
            LOGGER.info("Loading config from " + configPath + ".");
            config = config.withFallback(ConfigFactory.parseFile(new File(configPath)));
        }
        config = config.withFallback(ConfigFactory.load(DEFAULT_CONFIG_FILE));
        return new RayConfig(config);
    }
}

