/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.context;

import java.nio.ByteBuffer;
import org.ray.api.id.ActorId;
import org.ray.api.id.JobId;
import org.ray.api.id.TaskId;
import org.ray.api.id.UniqueId;
import org.ray.runtime.context.WorkerContext;
import org.ray.runtime.generated.Common;

public class NativeWorkerContext
implements WorkerContext {
    private final long nativeCoreWorkerPointer;
    private ClassLoader currentClassLoader;

    public NativeWorkerContext(long nativeCoreWorkerPointer) {
        this.nativeCoreWorkerPointer = nativeCoreWorkerPointer;
    }

    @Override
    public UniqueId getCurrentWorkerId() {
        return UniqueId.fromByteBuffer(NativeWorkerContext.nativeGetCurrentWorkerId(this.nativeCoreWorkerPointer));
    }

    @Override
    public JobId getCurrentJobId() {
        return JobId.fromByteBuffer(NativeWorkerContext.nativeGetCurrentJobId(this.nativeCoreWorkerPointer));
    }

    @Override
    public ActorId getCurrentActorId() {
        return ActorId.fromByteBuffer(NativeWorkerContext.nativeGetCurrentActorId(this.nativeCoreWorkerPointer));
    }

    @Override
    public ClassLoader getCurrentClassLoader() {
        return this.currentClassLoader;
    }

    @Override
    public void setCurrentClassLoader(ClassLoader currentClassLoader) {
        if (this.currentClassLoader != currentClassLoader) {
            this.currentClassLoader = currentClassLoader;
        }
    }

    @Override
    public Common.TaskType getCurrentTaskType() {
        return Common.TaskType.forNumber(NativeWorkerContext.nativeGetCurrentTaskType(this.nativeCoreWorkerPointer));
    }

    @Override
    public TaskId getCurrentTaskId() {
        return TaskId.fromByteBuffer(NativeWorkerContext.nativeGetCurrentTaskId(this.nativeCoreWorkerPointer));
    }

    private static native int nativeGetCurrentTaskType(long var0);

    private static native ByteBuffer nativeGetCurrentTaskId(long var0);

    private static native ByteBuffer nativeGetCurrentJobId(long var0);

    private static native ByteBuffer nativeGetCurrentWorkerId(long var0);

    private static native ByteBuffer nativeGetCurrentActorId(long var0);
}

