/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);

    public static TempFile getTempFileFromResource(String resourceFileName) {
        File file;
        try {
            file = File.createTempFile(resourceFileName, "");
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't create temp file " + resourceFileName, e);
        }
        try (InputStream in = FileUtil.class.getResourceAsStream("/" + resourceFileName);){
            Preconditions.checkNotNull(in, "{} doesn't exist.", (Object)resourceFileName);
            Files.copy(in, Paths.get(file.getCanonicalPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't get temp file from resource " + resourceFileName, e);
        }
        return new TempFile(file);
    }

    public static class TempFile
    implements AutoCloseable {
        File file;

        TempFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public void close() {
            if (!this.file.delete()) {
                LOGGER.warn("Couldn't delete temp file {}", (Object)this.file.getAbsolutePath());
            }
        }
    }
}

