/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.util;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.sun.jna.NativeLibrary;
import java.lang.reflect.Field;
import java.util.Set;
import org.ray.runtime.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JniUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JniUtils.class);
    private static Set<String> loadedLibs = Sets.newHashSet();

    public static synchronized void loadLibrary(String libraryName) {
        JniUtils.loadLibrary(libraryName, false);
    }

    public static synchronized void loadLibrary(String libraryName, boolean exportSymbols) {
        if (!loadedLibs.contains(libraryName)) {
            LOGGER.debug("Loading native library {}.", (Object)libraryName);
            String fileName = System.mapLibraryName(libraryName);
            String libPath = null;
            try (FileUtil.TempFile libFile = FileUtil.getTempFileFromResource(fileName);){
                libPath = libFile.getFile().getAbsolutePath();
                if (exportSymbols) {
                    NativeLibrary.getInstance(libFile.getFile().getAbsolutePath());
                }
                System.load(libPath);
            }
            LOGGER.debug("Native library loaded.");
            JniUtils.resetLibraryPath(libPath);
            loadedLibs.add(libraryName);
        }
    }

    public static synchronized void resetLibraryPath(String libPath) {
        if (Strings.isNullOrEmpty(libPath)) {
            return;
        }
        String path = System.getProperty("java.library.path");
        String separator = System.getProperty("path.separator");
        path = Strings.isNullOrEmpty(path) ? "" : path + separator;
        path = path + String.join((CharSequence)separator, libPath);
        System.setProperty("java.library.path", path);
        try {
            Field sysPathsField = ClassLoader.class.getDeclaredField("sys_paths");
            sysPathsField.setAccessible(true);
            sysPathsField.set(null, null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Failed to set library path.", e);
        }
    }
}

