"""add projects table

Revision ID: 5fe1ab1ccebe
Revises: cc7172b46608
Create Date: 2025-05-14 09:05:18.214357

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "5fe1ab1ccebe"
down_revision: Union[str, None] = "cc7172b46608"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###

    # SQLite FTS5 virtual table handling is SQLite-specific
    # For Postgres, search_index is a regular table managed by ORM
    connection = op.get_bind()
    is_sqlite = connection.dialect.name == "sqlite"

    op.create_table(
        "project",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("permalink", sa.String(), nullable=False),
        sa.Column("path", sa.String(), nullable=False),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.Column("is_default", sa.Boolean(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("updated_at", sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("is_default"),
        sa.UniqueConstraint("name"),
        sa.UniqueConstraint("permalink"),
        if_not_exists=True,
    )
    with op.batch_alter_table("project", schema=None) as batch_op:
        batch_op.create_index(
            "ix_project_created_at", ["created_at"], unique=False, if_not_exists=True
        )
        batch_op.create_index("ix_project_name", ["name"], unique=True, if_not_exists=True)
        batch_op.create_index("ix_project_path", ["path"], unique=False, if_not_exists=True)
        batch_op.create_index(
            "ix_project_permalink", ["permalink"], unique=True, if_not_exists=True
        )
        batch_op.create_index(
            "ix_project_updated_at", ["updated_at"], unique=False, if_not_exists=True
        )

    with op.batch_alter_table("entity", schema=None) as batch_op:
        batch_op.add_column(sa.Column("project_id", sa.Integer(), nullable=False))
        batch_op.drop_index(
            "uix_entity_permalink",
            sqlite_where=sa.text("content_type = 'text/markdown' AND permalink IS NOT NULL")
            if is_sqlite
            else None,
        )
        batch_op.drop_index("ix_entity_file_path")
        batch_op.create_index(batch_op.f("ix_entity_file_path"), ["file_path"], unique=False)
        batch_op.create_index("ix_entity_project_id", ["project_id"], unique=False)
        batch_op.create_index(
            "uix_entity_file_path_project", ["file_path", "project_id"], unique=True
        )
        batch_op.create_index(
            "uix_entity_permalink_project",
            ["permalink", "project_id"],
            unique=True,
            sqlite_where=sa.text("content_type = 'text/markdown' AND permalink IS NOT NULL")
            if is_sqlite
            else None,
        )
        batch_op.create_foreign_key("fk_entity_project_id", "project", ["project_id"], ["id"])

    # drop the search index table. it will be recreated
    # Only drop for SQLite - Postgres uses regular table managed by ORM
    if is_sqlite:
        op.drop_table("search_index")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("entity", schema=None) as batch_op:
        batch_op.drop_constraint("fk_entity_project_id", type_="foreignkey")
        batch_op.drop_index(
            "uix_entity_permalink_project",
            sqlite_where=sa.text("content_type = 'text/markdown' AND permalink IS NOT NULL"),
        )
        batch_op.drop_index("uix_entity_file_path_project")
        batch_op.drop_index("ix_entity_project_id")
        batch_op.drop_index(batch_op.f("ix_entity_file_path"))
        batch_op.create_index("ix_entity_file_path", ["file_path"], unique=1)
        batch_op.create_index(
            "uix_entity_permalink",
            ["permalink"],
            unique=1,
            sqlite_where=sa.text("content_type = 'text/markdown' AND permalink IS NOT NULL"),
        )
        batch_op.drop_column("project_id")

    with op.batch_alter_table("project", schema=None) as batch_op:
        batch_op.drop_index("ix_project_updated_at")
        batch_op.drop_index("ix_project_permalink")
        batch_op.drop_index("ix_project_path")
        batch_op.drop_index("ix_project_name")
        batch_op.drop_index("ix_project_created_at")

    op.drop_table("project")
    # ### end Alembic commands ###
