# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DocumentCDQReasons(BaseModel):
    """
    DocumentCDQReasons
    """ # noqa: E501
    obscured_data_points: Optional[StrictStr] = Field(default=None, description="When data points are obscured to the point that we cannot confirm if the fonts match the expected ones.")
    obscured_security_features: Optional[StrictStr] = Field(default=None, description="When a critical security feature is obscured. This can also refer to when the holder's wet signature, necessary for the document to be valid, is not present.")
    abnormal_document_features: Optional[StrictStr] = Field(default=None, description="One of 3 reasons (1) OCR Assisted Scans (i.e. when you're able to move the mouse and highlight part of text), (2) Severely Washed out Background, (3) Overlapping Text.")
    watermarks_digital_text_overlay: Optional[StrictStr] = Field(default=None, description="Any digital text or electronic watermarks on the document.")
    corner_removed: Optional[StrictStr] = Field(default=None, description="If the corner has been physically cut off. This can be found on some documents that are no longer valid.")
    punctured_document: Optional[StrictStr] = Field(default=None, description="A punched hole is present.")
    missing_back: Optional[StrictStr] = Field(default=None, description="When the back of a document is needed for processing, but is not available.")
    digital_document: Optional[StrictStr] = Field(default=None, description="When a document has been published digitally, there aren't enough security features to review so we cannot perform a full fraud assessment.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["obscured_data_points", "obscured_security_features", "abnormal_document_features", "watermarks_digital_text_overlay", "corner_removed", "punctured_document", "missing_back", "digital_document"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocumentCDQReasons from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocumentCDQReasons from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "obscured_data_points": obj.get("obscured_data_points"),
            "obscured_security_features": obj.get("obscured_security_features"),
            "abnormal_document_features": obj.get("abnormal_document_features"),
            "watermarks_digital_text_overlay": obj.get("watermarks_digital_text_overlay"),
            "corner_removed": obj.get("corner_removed"),
            "punctured_document": obj.get("punctured_document"),
            "missing_back": obj.get("missing_back"),
            "digital_document": obj.get("digital_document")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


