import unittest

from decawave_1001_rjg import DwmLocationResponse

from rover_position_rjg.sensors.decawave.csv.dwm_location_response_to_csv import DwmLocationResponseCsvConverter


class TestDwmLocationResponseCsvConverter(unittest.TestCase):
    data = [0x40, 0x01, 0x00, 0x41, 0x0D,
            0x01, 0x02, 0x00, 0x00,
            0x05, 0x00, 0x00, 0x00,
            0xFB, 0x00, 0x00, 0x00,
            0x0F,
            0x49, 0x51, 0x04,
            0x01, 0x0A, 0x05, 0x00, 0x00, 0x00, 0x64, 0x01, 0x02, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0xFB, 0x00, 0x00,
            0x00, 0x0F,
            0x02, 0x0B, 0x05, 0x00, 0x00, 0x00, 0x64, 0x01, 0x02, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0xFB, 0x00, 0x00,
            0x00, 0x0F,
            0x03, 0x0C, 0x05, 0x00, 0x00, 0x00, 0x64, 0x01, 0x02, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0xFB, 0x00, 0x00,
            0x00, 0x0F,
            0x04, 0x0D, 0x05, 0x00, 0x00, 0x00, 0x64, 0x01, 0x02, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0xFB, 0x00, 0x00,
            0x00, 0x0F
            ]

    def setUp(self):
        self.converter = DwmLocationResponseCsvConverter()
        self.message = DwmLocationResponse(bytes(self.data))

    def test_to_csv(self):
        csv = self.converter.to_row(self.message)
        expected = [513, 5, 251, 15,
                    'A01', 5, 100, 513, 5, 251, 15,
                    'B02', 5, 100, 513, 5, 251, 15,
                    'C03', 5, 100, 513, 5, 251, 15,
                    'D04', 5, 100, 513, 5, 251, 15]
        self.assertEqual(expected, csv)

    def test_to_object(self):
        obj = self.converter.to_object(
            [513, 5, 251, 15,
             'A01', 5, 100, 513, 5, 251, 15,
             'B02', 5, 100, 513, 5, 251, 15,
             'C03', 5, 100, 513, 5, 251, 15,
             'D04', 5, 100, 513, 5, 251, 15])
        self.assertEqual(self.data, obj.message)
