"""
Custom exceptions for Hypersets.
"""


class HypersetsError(Exception):
    """Base exception for all Hypersets errors."""

    pass


class DatasetNotFoundError(HypersetsError):
    """Raised when a dataset cannot be found."""

    pass


class ConfigNotFoundError(HypersetsError):
    """Raised when a dataset config cannot be found."""

    pass


class SplitNotFoundError(HypersetsError):
    """Raised when a dataset split cannot be found."""

    pass


class QueryError(HypersetsError):
    """Raised when a SQL query fails."""

    pass


class DuckDBError(HypersetsError):
    """Raised when DuckDB operations fail."""

    pass
