/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.object;

import io.ray.api.id.BaseId;
import io.ray.api.id.ObjectId;
import io.ray.runtime.context.WorkerContext;
import io.ray.runtime.object.NativeRayObject;
import io.ray.runtime.object.ObjectStore;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeObjectStore
extends ObjectStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeObjectStore.class);

    public NativeObjectStore(WorkerContext workerContext) {
        super(workerContext);
    }

    @Override
    public ObjectId putRaw(NativeRayObject obj) {
        return new ObjectId(NativeObjectStore.nativePut(obj));
    }

    @Override
    public void putRaw(NativeRayObject obj, ObjectId objectId) {
        NativeObjectStore.nativePut(objectId.getBytes(), obj);
    }

    @Override
    public List<NativeRayObject> getRaw(List<ObjectId> objectIds, long timeoutMs) {
        return NativeObjectStore.nativeGet(NativeObjectStore.toBinaryList(objectIds), timeoutMs);
    }

    @Override
    public List<Boolean> wait(List<ObjectId> objectIds, int numObjects, long timeoutMs) {
        return NativeObjectStore.nativeWait(NativeObjectStore.toBinaryList(objectIds), numObjects, timeoutMs);
    }

    @Override
    public void delete(List<ObjectId> objectIds, boolean localOnly, boolean deleteCreatingTasks) {
        NativeObjectStore.nativeDelete(NativeObjectStore.toBinaryList(objectIds), localOnly, deleteCreatingTasks);
    }

    private static List<byte[]> toBinaryList(List<ObjectId> ids) {
        return ids.stream().map(BaseId::getBytes).collect(Collectors.toList());
    }

    private static native byte[] nativePut(NativeRayObject var0);

    private static native void nativePut(byte[] var0, NativeRayObject var1);

    private static native List<NativeRayObject> nativeGet(List<byte[]> var0, long var1);

    private static native List<Boolean> nativeWait(List<byte[]> var0, int var1, long var2);

    private static native void nativeDelete(List<byte[]> var0, boolean var1, boolean var2);
}

