/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.task;

import com.google.common.base.Preconditions;
import io.ray.api.BaseActor;
import io.ray.api.id.ObjectId;
import io.ray.api.options.ActorCreationOptions;
import io.ray.api.options.CallOptions;
import io.ray.runtime.actor.NativeRayActor;
import io.ray.runtime.functionmanager.FunctionDescriptor;
import io.ray.runtime.task.FunctionArg;
import io.ray.runtime.task.TaskSubmitter;
import java.util.List;
import java.util.stream.Collectors;

public class NativeTaskSubmitter
implements TaskSubmitter {
    @Override
    public List<ObjectId> submitTask(FunctionDescriptor functionDescriptor, List<FunctionArg> args, int numReturns, CallOptions options) {
        List<byte[]> returnIds = NativeTaskSubmitter.nativeSubmitTask(functionDescriptor, args, numReturns, options);
        return returnIds.stream().map(ObjectId::new).collect(Collectors.toList());
    }

    @Override
    public BaseActor createActor(FunctionDescriptor functionDescriptor, List<FunctionArg> args, ActorCreationOptions options) {
        byte[] actorId = NativeTaskSubmitter.nativeCreateActor(functionDescriptor, args, options);
        return NativeRayActor.create(actorId, functionDescriptor.getLanguage());
    }

    @Override
    public List<ObjectId> submitActorTask(BaseActor actor, FunctionDescriptor functionDescriptor, List<FunctionArg> args, int numReturns, CallOptions options) {
        Preconditions.checkState(actor instanceof NativeRayActor);
        List<byte[]> returnIds = NativeTaskSubmitter.nativeSubmitActorTask(actor.getId().getBytes(), functionDescriptor, args, numReturns, options);
        return returnIds.stream().map(ObjectId::new).collect(Collectors.toList());
    }

    private static native List<byte[]> nativeSubmitTask(FunctionDescriptor var0, List<FunctionArg> var1, int var2, CallOptions var3);

    private static native byte[] nativeCreateActor(FunctionDescriptor var0, List<FunctionArg> var1, ActorCreationOptions var2);

    private static native List<byte[]> nativeSubmitActorTask(byte[] var0, FunctionDescriptor var1, List<FunctionArg> var2, int var3, CallOptions var4);
}

