/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.core.graph.executiongraph;

import com.google.common.base.MoreObjects;
import io.ray.streaming.api.partition.Partition;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionJobEdge;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionVertex;
import java.io.Serializable;

public class ExecutionEdge
implements Serializable {
    private final ExecutionVertex sourceVertex;
    private final ExecutionVertex targetVertex;
    private final Partition partition;
    private final String executionEdgeIndex;

    public ExecutionEdge(ExecutionVertex sourceVertex, ExecutionVertex targetVertex, ExecutionJobEdge executionJobEdge) {
        this.sourceVertex = sourceVertex;
        this.targetVertex = targetVertex;
        this.partition = executionJobEdge.getPartition();
        this.executionEdgeIndex = this.generateExecutionEdgeIndex();
    }

    private String generateExecutionEdgeIndex() {
        return this.sourceVertex.getId() + "\u2014" + this.targetVertex.getId();
    }

    public ExecutionVertex getSourceVertex() {
        return this.sourceVertex;
    }

    public ExecutionVertex getTargetVertex() {
        return this.targetVertex;
    }

    public int getSourceVertexId() {
        return this.sourceVertex.getId();
    }

    public int getTargetVertexId() {
        return this.targetVertex.getId();
    }

    public Partition getPartition() {
        return this.partition;
    }

    public String getExecutionEdgeIndex() {
        return this.executionEdgeIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sourceVertex", this.sourceVertex).add("targetVertex", this.targetVertex).add("partition", this.partition).add("executionEdgeIndex", this.executionEdgeIndex).toString();
    }
}

