/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.core.graph.executiongraph;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.ray.api.RayActor;
import io.ray.streaming.api.Language;
import io.ray.streaming.jobgraph.JobVertex;
import io.ray.streaming.jobgraph.VertexType;
import io.ray.streaming.operator.StreamOperator;
import io.ray.streaming.runtime.config.master.ResourceConfig;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionJobEdge;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionVertex;
import io.ray.streaming.runtime.worker.JobWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.aeonbits.owner.ConfigFactory;

public class ExecutionJobVertex {
    private final int jobVertexId;
    private final String jobVertexName;
    private final StreamOperator streamOperator;
    private final VertexType vertexType;
    private final Language language;
    private final Map<String, String> jobConfig;
    private int parallelism;
    private List<ExecutionVertex> executionVertices;
    private List<ExecutionJobEdge> inputEdges = new ArrayList<ExecutionJobEdge>();
    private List<ExecutionJobEdge> outputEdges = new ArrayList<ExecutionJobEdge>();

    public ExecutionJobVertex(JobVertex jobVertex, Map<String, String> jobConfig, AtomicInteger idGenerator) {
        this.jobVertexId = jobVertex.getVertexId();
        this.jobVertexName = jobVertex.getStreamOperator().getName();
        this.streamOperator = jobVertex.getStreamOperator();
        this.vertexType = jobVertex.getVertexType();
        this.language = jobVertex.getLanguage();
        this.jobConfig = jobConfig;
        this.parallelism = jobVertex.getParallelism();
        this.executionVertices = this.createExecutionVertics(idGenerator);
    }

    private List<ExecutionVertex> createExecutionVertics(AtomicInteger idGenerator) {
        ArrayList<ExecutionVertex> executionVertices = new ArrayList<ExecutionVertex>();
        ResourceConfig resourceConfig = ConfigFactory.create(ResourceConfig.class, this.jobConfig);
        for (int subIndex = 0; subIndex < this.parallelism; ++subIndex) {
            executionVertices.add(new ExecutionVertex(idGenerator.getAndIncrement(), subIndex, this, resourceConfig));
        }
        return executionVertices;
    }

    public Map<Integer, RayActor<JobWorker>> getExecutionVertexWorkers() {
        HashMap<Integer, RayActor<JobWorker>> executionVertexWorkersMap = new HashMap<Integer, RayActor<JobWorker>>();
        Preconditions.checkArgument(this.executionVertices != null && !this.executionVertices.isEmpty(), "Empty execution vertex.");
        this.executionVertices.stream().forEach(vertex -> {
            Preconditions.checkArgument(vertex.getWorkerActor() != null, "Empty execution vertex worker actor.");
            executionVertexWorkersMap.put(vertex.getId(), vertex.getWorkerActor());
        });
        return executionVertexWorkersMap;
    }

    public int getJobVertexId() {
        return this.jobVertexId;
    }

    public String getJobVertexName() {
        return this.jobVertexName;
    }

    public String getVertexNameWithIndex() {
        return this.jobVertexId + "-" + this.jobVertexName;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public List<ExecutionVertex> getExecutionVertices() {
        return this.executionVertices;
    }

    public void setExecutionVertices(List<ExecutionVertex> executionVertex) {
        this.executionVertices = executionVertex;
    }

    public List<ExecutionJobEdge> getOutputEdges() {
        return this.outputEdges;
    }

    public void setOutputEdges(List<ExecutionJobEdge> outputEdges) {
        this.outputEdges = outputEdges;
    }

    public List<ExecutionJobEdge> getInputEdges() {
        return this.inputEdges;
    }

    public void setInputEdges(List<ExecutionJobEdge> inputEdges) {
        this.inputEdges = inputEdges;
    }

    public StreamOperator getStreamOperator() {
        return this.streamOperator;
    }

    public VertexType getVertexType() {
        return this.vertexType;
    }

    public Language getLanguage() {
        return this.language;
    }

    public boolean isSourceVertex() {
        return this.getVertexType() == VertexType.SOURCE;
    }

    public boolean isTransformationVertex() {
        return this.getVertexType() == VertexType.TRANSFORMATION;
    }

    public boolean isSinkVertex() {
        return this.getVertexType() == VertexType.SINK;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("jobVertexId", this.jobVertexId).add("jobVertexName", this.jobVertexName).add("vertexType", (Object)this.vertexType).add("parallelism", this.parallelism).toString();
    }
}

