/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.core.graph.executiongraph;

import com.google.common.base.MoreObjects;
import io.ray.api.RayActor;
import io.ray.api.id.ActorId;
import io.ray.streaming.api.Language;
import io.ray.streaming.jobgraph.VertexType;
import io.ray.streaming.operator.StreamOperator;
import io.ray.streaming.runtime.config.master.ResourceConfig;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionEdge;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionJobVertex;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionVertexState;
import io.ray.streaming.runtime.core.resource.ContainerID;
import io.ray.streaming.runtime.core.resource.ResourceType;
import io.ray.streaming.runtime.worker.JobWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExecutionVertex
implements Serializable {
    private final int id;
    private final int jobVertexId;
    private final String jobVertexName;
    private final StreamOperator streamOperator;
    private final VertexType vertexType;
    private final Language language;
    private final Map<String, Double> resources;
    private int vertexIndex;
    private ExecutionVertexState state = ExecutionVertexState.TO_ADD;
    private ContainerID containerId;
    private RayActor<JobWorker> workerActor;
    private List<ExecutionEdge> inputEdges = new ArrayList<ExecutionEdge>();
    private List<ExecutionEdge> outputEdges = new ArrayList<ExecutionEdge>();

    public ExecutionVertex(int globalIndex, int index, ExecutionJobVertex executionJobVertex, ResourceConfig resourceConfig) {
        this.id = globalIndex;
        this.jobVertexId = executionJobVertex.getJobVertexId();
        this.jobVertexName = executionJobVertex.getJobVertexName();
        this.streamOperator = executionJobVertex.getStreamOperator();
        this.vertexType = executionJobVertex.getVertexType();
        this.language = executionJobVertex.getLanguage();
        this.vertexIndex = index;
        this.resources = this.generateResources(resourceConfig);
    }

    public int getId() {
        return this.id;
    }

    public int getJobVertexId() {
        return this.jobVertexId;
    }

    public String getJobVertexName() {
        return this.jobVertexName;
    }

    public StreamOperator getStreamOperator() {
        return this.streamOperator;
    }

    public VertexType getVertexType() {
        return this.vertexType;
    }

    public Language getLanguage() {
        return this.language;
    }

    public int getVertexIndex() {
        return this.vertexIndex;
    }

    public String getVertexName() {
        return this.jobVertexId + "-" + this.jobVertexName + "-" + this.vertexIndex;
    }

    public ExecutionVertexState getState() {
        return this.state;
    }

    public void setState(ExecutionVertexState state) {
        this.state = state;
    }

    public boolean is2Add() {
        return this.state == ExecutionVertexState.TO_ADD;
    }

    public boolean isRunning() {
        return this.state == ExecutionVertexState.RUNNING;
    }

    public boolean is2Delete() {
        return this.state == ExecutionVertexState.TO_DEL;
    }

    public RayActor<JobWorker> getWorkerActor() {
        return this.workerActor;
    }

    public ActorId getWorkerActorId() {
        return this.workerActor.getId();
    }

    public void setWorkerActor(RayActor<JobWorker> workerActor) {
        this.workerActor = workerActor;
    }

    public List<ExecutionEdge> getInputEdges() {
        return this.inputEdges;
    }

    public void setInputEdges(List<ExecutionEdge> inputEdges) {
        this.inputEdges = inputEdges;
    }

    public List<ExecutionEdge> getOutputEdges() {
        return this.outputEdges;
    }

    public void setOutputEdges(List<ExecutionEdge> outputEdges) {
        this.outputEdges = outputEdges;
    }

    public Map<String, Double> getResources() {
        return this.resources;
    }

    public ContainerID getContainerId() {
        return this.containerId;
    }

    public void setContainerId(ContainerID containerId) {
        this.containerId = containerId;
    }

    public void setContainerIfNotExist(ContainerID containerId) {
        if (null == this.containerId) {
            this.containerId = containerId;
        }
    }

    private Map<String, Double> generateResources(ResourceConfig resourceConfig) {
        HashMap<String, Double> resourceMap = new HashMap<String, Double>();
        if (resourceConfig.isTaskCpuResourceLimit()) {
            resourceMap.put(ResourceType.CPU.name(), resourceConfig.taskCpuResource());
        }
        if (resourceConfig.isTaskMemResourceLimit()) {
            resourceMap.put(ResourceType.MEM.name(), resourceConfig.taskMemResource());
        }
        return resourceMap;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExecutionVertex) {
            return this.id == ((ExecutionVertex)obj).getId();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.outputEdges);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("name", this.getVertexName()).add("resources", this.resources).add("state", this.state).add("containerId", this.containerId).add("workerActor", this.workerActor).toString();
    }
}

