/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.core.processor;

import io.ray.streaming.api.collector.Collector;
import io.ray.streaming.api.context.RuntimeContext;
import io.ray.streaming.operator.Operator;
import io.ray.streaming.runtime.core.processor.Processor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamProcessor<T, P extends Operator>
implements Processor<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamProcessor.class);
    protected List<Collector> collectors;
    protected RuntimeContext runtimeContext;
    protected P operator;

    public StreamProcessor(P operator) {
        this.operator = operator;
    }

    @Override
    public void open(List<Collector> collectors, RuntimeContext runtimeContext) {
        this.collectors = collectors;
        this.runtimeContext = runtimeContext;
        if (this.operator != null) {
            this.operator.open(collectors, runtimeContext);
        }
        LOGGER.info("opened {}", (Object)this);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

