/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.python;

import com.google.protobuf.ByteString;
import io.ray.runtime.actor.NativeRayActor;
import io.ray.streaming.api.function.Function;
import io.ray.streaming.api.partition.Partition;
import io.ray.streaming.operator.Operator;
import io.ray.streaming.python.PythonFunction;
import io.ray.streaming.python.PythonOperator;
import io.ray.streaming.python.PythonPartition;
import io.ray.streaming.runtime.core.graph.ExecutionEdge;
import io.ray.streaming.runtime.core.graph.ExecutionGraph;
import io.ray.streaming.runtime.core.graph.ExecutionNode;
import io.ray.streaming.runtime.core.graph.ExecutionTask;
import io.ray.streaming.runtime.generated.RemoteCall;
import io.ray.streaming.runtime.generated.Streaming;
import io.ray.streaming.runtime.serialization.MsgPackSerializer;
import java.util.Arrays;

public class GraphPbBuilder {
    private MsgPackSerializer serializer = new MsgPackSerializer();

    public RemoteCall.ExecutionGraph buildExecutionGraphPb(ExecutionGraph graph) {
        RemoteCall.ExecutionGraph.Builder builder = RemoteCall.ExecutionGraph.newBuilder();
        builder.setBuildTime(graph.getBuildTime());
        for (ExecutionNode node : graph.getExecutionNodeList()) {
            RemoteCall.ExecutionGraph.ExecutionNode.Builder nodeBuilder = RemoteCall.ExecutionGraph.ExecutionNode.newBuilder();
            nodeBuilder.setNodeId(node.getNodeId());
            nodeBuilder.setParallelism(node.getParallelism());
            nodeBuilder.setNodeType(Streaming.NodeType.valueOf(node.getNodeType().name()));
            nodeBuilder.setLanguage(Streaming.Language.valueOf(node.getLanguage().name()));
            byte[] operatorBytes = this.serializeOperator(node.getStreamOperator());
            nodeBuilder.setOperator(ByteString.copyFrom(operatorBytes));
            for (ExecutionTask task : node.getExecutionTasks()) {
                RemoteCall.ExecutionGraph.ExecutionTask.Builder taskBuilder = RemoteCall.ExecutionGraph.ExecutionTask.newBuilder();
                byte[] serializedActorHandle = ((NativeRayActor)task.getWorker()).toBytes();
                taskBuilder.setTaskId(task.getTaskId()).setTaskIndex(task.getTaskIndex()).setWorkerActor(ByteString.copyFrom(serializedActorHandle));
                nodeBuilder.addExecutionTasks(taskBuilder.build());
            }
            for (ExecutionEdge edge : node.getInputsEdges()) {
                nodeBuilder.addInputEdges(this.buildEdgePb(edge));
            }
            for (ExecutionEdge edge : node.getOutputEdges()) {
                nodeBuilder.addOutputEdges(this.buildEdgePb(edge));
            }
            builder.addExecutionNodes(nodeBuilder.build());
        }
        return builder.build();
    }

    private RemoteCall.ExecutionGraph.ExecutionEdge buildEdgePb(ExecutionEdge edge) {
        RemoteCall.ExecutionGraph.ExecutionEdge.Builder edgeBuilder = RemoteCall.ExecutionGraph.ExecutionEdge.newBuilder();
        edgeBuilder.setSrcNodeId(edge.getSrcNodeId());
        edgeBuilder.setTargetNodeId(edge.getTargetNodeId());
        edgeBuilder.setPartition(ByteString.copyFrom(this.serializePartition(edge.getPartition())));
        return edgeBuilder.build();
    }

    private byte[] serializeOperator(Operator operator) {
        if (operator instanceof PythonOperator) {
            PythonOperator pythonOperator = (PythonOperator)operator;
            return this.serializer.serialize(Arrays.asList(this.serializeFunction(pythonOperator.getFunction()), pythonOperator.getModuleName(), pythonOperator.getClassName()));
        }
        return new byte[0];
    }

    private byte[] serializeFunction(Function function) {
        if (function instanceof PythonFunction) {
            PythonFunction pyFunc = (PythonFunction)function;
            return this.serializer.serialize(Arrays.asList(pyFunc.getFunction(), pyFunc.getModuleName(), pyFunc.getFunctionName(), pyFunc.getFunctionInterface()));
        }
        return new byte[0];
    }

    private byte[] serializePartition(Partition partition) {
        if (partition instanceof PythonPartition) {
            PythonPartition pythonPartition = (PythonPartition)partition;
            return this.serializer.serialize(Arrays.asList(pythonPartition.getPartition(), pythonPartition.getModuleName(), pythonPartition.getFunctionName()));
        }
        return new byte[0];
    }
}

