/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.state.backend;

import io.ray.streaming.state.backend.BackendType;
import io.ray.streaming.state.backend.StateStrategy;
import io.ray.streaming.state.config.ConfigKey;
import io.ray.streaming.state.keystate.desc.AbstractStateDescriptor;
import io.ray.streaming.state.serialization.KeyMapStoreSerializer;
import io.ray.streaming.state.store.KeyMapStore;
import io.ray.streaming.state.store.KeyValueStore;
import java.io.Serializable;
import java.util.Map;

public abstract class AbstractStateBackend
implements Serializable {
    protected final Map<String, String> config;
    protected final StateStrategy stateStrategy;
    protected final BackendType backendType;
    protected int keyGroupIndex = -1;

    protected AbstractStateBackend(Map<String, String> config) {
        this.stateStrategy = StateStrategy.getEnum(ConfigKey.getStateStrategyEnum(config));
        this.backendType = BackendType.getEnum(ConfigKey.getBackendType(config));
        this.config = config;
    }

    public abstract <K, V> KeyValueStore<K, V> getKeyValueStore(String var1);

    public abstract <K, S, T> KeyMapStore<K, S, T> getKeyMapStore(String var1);

    public abstract <K, S, T> KeyMapStore<K, S, T> getKeyMapStore(String var1, KeyMapStoreSerializer var2);

    public BackendType getBackendType() {
        return this.backendType;
    }

    public StateStrategy getStateStrategy() {
        return this.stateStrategy;
    }

    public String getTableName(AbstractStateDescriptor stateDescriptor) {
        return stateDescriptor.getTableName();
    }

    public String getStateKey(String descName, String currentKey) {
        return descName + "\u0001\b" + currentKey;
    }

    public void setKeyGroupIndex(int keyGroupIndex) {
        this.keyGroupIndex = keyGroupIndex;
    }
}

