/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.state.backend;

import io.ray.streaming.state.backend.AbstractKeyStateBackend;
import io.ray.streaming.state.backend.AbstractStateBackend;
import io.ray.streaming.state.keystate.KeyGroup;
import io.ray.streaming.state.keystate.KeyGroupAssignment;
import io.ray.streaming.state.keystate.desc.ListStateDescriptor;
import io.ray.streaming.state.keystate.desc.MapStateDescriptor;
import io.ray.streaming.state.keystate.desc.ValueStateDescriptor;
import io.ray.streaming.state.keystate.state.ListState;
import io.ray.streaming.state.keystate.state.MapState;
import io.ray.streaming.state.keystate.state.ValueState;
import io.ray.streaming.state.keystate.state.proxy.ListStateStoreManagerProxy;
import io.ray.streaming.state.keystate.state.proxy.MapStateStoreManagerProxy;
import io.ray.streaming.state.keystate.state.proxy.ValueStateStoreManagerProxy;
import io.ray.streaming.state.strategy.StateStoreManagerProxy;

public class KeyStateBackend
extends AbstractKeyStateBackend {
    protected final int numberOfKeyGroups;
    protected final KeyGroup keyGroup;

    public KeyStateBackend(int numberOfKeyGroups, KeyGroup keyGroup, AbstractStateBackend abstractStateBackend) {
        super(abstractStateBackend);
        this.numberOfKeyGroups = numberOfKeyGroups;
        this.keyGroup = keyGroup;
    }

    protected <T> ValueStateStoreManagerProxy<T> newValueStateProxy(ValueStateDescriptor<T> stateDescriptor) {
        return new ValueStateStoreManagerProxy<T>(this, stateDescriptor);
    }

    public <T> ValueState<T> getValueState(ValueStateDescriptor<T> stateDescriptor) {
        String desc = stateDescriptor.getIdentify();
        if (this.valueManagerProxyHashMap.containsKey(desc)) {
            return ((ValueStateStoreManagerProxy)this.valueManagerProxyHashMap.get(desc)).getValueState();
        }
        ValueStateStoreManagerProxy<T> valueStateProxy = this.newValueStateProxy(stateDescriptor);
        this.valueManagerProxyHashMap.put(desc, valueStateProxy);
        return valueStateProxy.getValueState();
    }

    protected <T> ListStateStoreManagerProxy<T> newListStateProxy(ListStateDescriptor<T> stateDescriptor) {
        return new ListStateStoreManagerProxy<T>((AbstractKeyStateBackend)this, stateDescriptor);
    }

    public <T> ListState<T> getListState(ListStateDescriptor<T> stateDescriptor) {
        String desc = stateDescriptor.getIdentify();
        if (this.listManagerProxyHashMap.containsKey(desc)) {
            ListStateStoreManagerProxy listStateProxy = (ListStateStoreManagerProxy)this.listManagerProxyHashMap.get(desc);
            return listStateProxy.getListState();
        }
        ListStateStoreManagerProxy<T> listStateProxy = this.newListStateProxy(stateDescriptor);
        this.listManagerProxyHashMap.put(desc, listStateProxy);
        return listStateProxy.getListState();
    }

    protected <S, T> MapStateStoreManagerProxy<S, T> newMapStateProxy(MapStateDescriptor<S, T> stateDescriptor) {
        return new MapStateStoreManagerProxy<S, T>(this, stateDescriptor);
    }

    public <S, T> MapState<S, T> getMapState(MapStateDescriptor<S, T> stateDescriptor) {
        String desc = stateDescriptor.getIdentify();
        if (this.mapManagerProxyHashMap.containsKey(desc)) {
            MapStateStoreManagerProxy mapStateProxy = (MapStateStoreManagerProxy)this.mapManagerProxyHashMap.get(desc);
            return mapStateProxy.getMapState();
        }
        MapStateStoreManagerProxy<S, T> mapStateProxy = this.newMapStateProxy(stateDescriptor);
        this.mapManagerProxyHashMap.put(desc, mapStateProxy);
        return mapStateProxy.getMapState();
    }

    @Override
    public void setCurrentKey(Object currentKey) {
        this.keyGroupIndex = KeyGroupAssignment.assignKeyGroupIndexForKey(currentKey, this.numberOfKeyGroups);
        this.currentKey = currentKey;
    }

    public int getNumberOfKeyGroups() {
        return this.numberOfKeyGroups;
    }

    public KeyGroup getKeyGroup() {
        return this.keyGroup;
    }

    public void close() {
        for (StateStoreManagerProxy proxy : this.valueManagerProxyHashMap.values()) {
            proxy.close();
        }
        for (StateStoreManagerProxy proxy : this.listManagerProxyHashMap.values()) {
            proxy.close();
        }
        for (StateStoreManagerProxy proxy : this.mapManagerProxyHashMap.values()) {
            proxy.close();
        }
    }
}

