/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.state.config;

import io.ray.streaming.state.config.ConfigHelper;
import java.util.Map;

public final class ConfigKey {
    public static final String STATE_BACKEND_TYPE = "state.backend.type";
    public static final String STATE_TABLE_NAME = "state.table.name";
    public static final String STATE_STRATEGY_MODE = "state.strategy.mode";
    public static final String NUMBER_PER_CHECKPOINT = "number.per.checkpoint";
    public static final String JOB_MAX_PARALLEL = "job.max.parallel";
    public static final String DELIMITER = "\u0001\b";

    private ConfigKey() {
        throw new AssertionError();
    }

    public static String getStateStrategyEnum(Map<String, String> config) {
        return ConfigHelper.getStringOrDefault(config, STATE_STRATEGY_MODE, "DUAL_VERSION");
    }

    public static String getBackendType(Map<String, String> config) {
        return ConfigHelper.getStringOrDefault(config, STATE_BACKEND_TYPE, "MEMORY");
    }

    public static int getNumberPerCheckpoint(Map<String, String> config) {
        return ConfigHelper.getIntegerOrDefault(config, NUMBER_PER_CHECKPOINT, 5);
    }

    public static String getStateTableName(Map<String, String> config) {
        return ConfigHelper.getStringOrDefault(config, STATE_TABLE_NAME, "table");
    }
}

