/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.state.keystate.state.impl;

import io.ray.streaming.state.backend.KeyStateBackend;
import io.ray.streaming.state.keystate.desc.MapStateDescriptor;
import io.ray.streaming.state.keystate.state.MapState;
import io.ray.streaming.state.keystate.state.impl.StateHelper;
import java.util.HashMap;
import java.util.Map;

public class MapStateImpl<K, V>
implements MapState<K, V> {
    private final StateHelper<Map<K, V>> helper;

    public MapStateImpl(MapStateDescriptor<K, V> descriptor, KeyStateBackend backend) {
        this.helper = new StateHelper(backend, descriptor);
    }

    @Override
    public Map<K, V> get() {
        Map<K, V> map = this.helper.get();
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    @Override
    public V get(K key) {
        Object map = this.get();
        return map.get(key);
    }

    @Override
    public void put(K key, V value) {
        Object map = this.get();
        map.put(key, value);
        this.helper.put((Map<K, V>)map);
    }

    @Override
    public void update(Map<K, V> map) {
        if (map == null) {
            map = new HashMap();
        }
        this.helper.put(map);
    }

    @Override
    public void putAll(Map<K, V> newMap) {
        Object map = this.get();
        map.putAll(newMap);
        this.helper.put((Map<K, V>)map);
    }

    @Override
    public void remove(K key) {
        Object map = this.get();
        map.remove(key);
        this.helper.put((Map<K, V>)map);
    }

    @Override
    public void setCurrentKey(Object currentKey) {
        this.helper.setCurrentKey(currentKey);
    }
}

