/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.state.store.impl;

import com.google.common.collect.Maps;
import io.ray.streaming.state.store.KeyValueStore;
import java.io.IOException;
import java.util.Map;

public class MemoryKeyValueStore<K, V>
implements KeyValueStore<K, V> {
    private Map<K, V> memoryStore = Maps.newConcurrentMap();

    @Override
    public void put(K key, V value) throws IOException {
        this.memoryStore.put(key, value);
    }

    @Override
    public V get(K key) throws IOException {
        return this.memoryStore.get(key);
    }

    @Override
    public void remove(K key) throws IOException {
        this.memoryStore.remove(key);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void clearCache() {
    }

    @Override
    public void close() throws IOException {
        if (this.memoryStore != null) {
            this.memoryStore.clear();
        }
    }
}

