/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.state.strategy;

import io.ray.streaming.state.StateStoreManager;
import io.ray.streaming.state.backend.AbstractKeyStateBackend;
import io.ray.streaming.state.backend.StateStrategy;
import io.ray.streaming.state.keystate.desc.AbstractStateDescriptor;
import io.ray.streaming.state.store.KeyValueStore;
import io.ray.streaming.state.strategy.AbstractStateStoreManager;
import io.ray.streaming.state.strategy.DualStateStoreManager;
import io.ray.streaming.state.strategy.MVStateStoreManager;
import java.util.Map;

public abstract class StateStoreManagerProxy<V>
implements StateStoreManager {
    protected final AbstractStateStoreManager<V> stateStrategy;
    private final AbstractKeyStateBackend keyStateBackend;

    public StateStoreManagerProxy(AbstractKeyStateBackend keyStateBackend, AbstractStateDescriptor stateDescriptor) {
        this.keyStateBackend = keyStateBackend;
        KeyValueStore<String, Map<Long, byte[]>> backStorage = keyStateBackend.getBackStorage(stateDescriptor);
        StateStrategy stateStrategy = keyStateBackend.getStateStrategy();
        switch (stateStrategy) {
            case DUAL_VERSION: {
                this.stateStrategy = new DualStateStoreManager(backStorage);
                break;
            }
            case SINGLE_VERSION: {
                this.stateStrategy = new MVStateStoreManager(backStorage);
                break;
            }
            default: {
                throw new UnsupportedOperationException("store vertexType not support");
            }
        }
    }

    protected void setKeyGroupIndex(int index) {
        this.stateStrategy.setKeyGroupIndex(index);
    }

    @Override
    public void finish(long checkpointId) {
        this.stateStrategy.finish(checkpointId);
    }

    @Override
    public void commit(long checkpointId) {
        this.stateStrategy.commit(checkpointId);
    }

    @Override
    public void ackCommit(long checkpointId, long timeStamp) {
        this.stateStrategy.ackCommit(checkpointId);
    }

    @Override
    public void rollBack(long checkpointId) {
        this.stateStrategy.rollBack(checkpointId);
    }

    public void close() {
        this.stateStrategy.close();
    }

    public V get(String key) {
        this.stateStrategy.setKeyGroupIndex(this.keyStateBackend.getKeyGroupIndex());
        return this.stateStrategy.get(this.keyStateBackend.getCheckpointId(), key);
    }

    public void put(String key, V value) {
        this.stateStrategy.setKeyGroupIndex(this.keyStateBackend.getKeyGroupIndex());
        this.stateStrategy.put(this.keyStateBackend.getCheckpointId(), key, value);
    }
}

