/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml.dom;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.testng.collections.Lists;
import org.testng.internal.collections.Pair;
import org.testng.xml.dom.OnElement;
import org.testng.xml.dom.OnElementList;
import org.testng.xml.dom.Tag;
import org.testng.xml.dom.Wrapper;

public class Reflect {
    public static List<Pair<Method, Wrapper>> findMethodsWithAnnotation(Class<?> c, Class<? extends Annotation> ac, Object bean) {
        List<Pair<Method, Wrapper>> result = Lists.newArrayList();
        for (Method m3 : c.getMethods()) {
            Annotation a = m3.getAnnotation(ac);
            if (a == null) continue;
            result.add(Pair.of(m3, new Wrapper(a, bean)));
        }
        return result;
    }

    public static Pair<Method, Wrapper> findSetterForTag(Class<?> c, String tagName, Object bean) {
        List<Class> annotations = Arrays.asList(OnElement.class, OnElementList.class, Tag.class);
        for (Class annotationClass : annotations) {
            List<Pair<Method, Wrapper>> methods = Reflect.findMethodsWithAnnotation(c, annotationClass, bean);
            for (Pair<Method, Wrapper> pair : methods) {
                if (!pair.second().getTagName().equals(tagName)) continue;
                return pair;
            }
        }
        for (String prefix : new String[]{"add", "set"}) {
            for (Method m3 : c.getDeclaredMethods()) {
                String methodName = Reflect.toCamelCase(tagName, prefix);
                if (!m3.getName().equals(methodName)) continue;
                return Pair.of(m3, null);
            }
        }
        return null;
    }

    private static String toCamelCase(String name, String prefix) {
        return prefix + Reflect.toCapitalizedCamelCase(name);
    }

    public static String toCapitalizedCamelCase(String name) {
        StringBuilder result = new StringBuilder(name.substring(0, 1).toUpperCase());
        for (int i = 1; i < name.length(); ++i) {
            if (name.charAt(i) == '-') {
                result.append(Character.toUpperCase(name.charAt(i + 1)));
                ++i;
                continue;
            }
            result.append(name.charAt(i));
        }
        return result.toString();
    }
}

