"""
Claude Code ADK-Inspired Validation Hooks

Hybrid security + TDD validation for Claude Code tool execution using Google Gemini and ADK-inspired patterns.
"""

__version__ = "1.2.0"
__author__ = "Jihun Kim"
__email__ = "jihunkim0@noreply.github.com"

from .validator import ClaudeToolValidator
from .hybrid_validator import HybridValidator
from .security_validator import SecurityValidator
from .tdd_validator import TDDValidator
from .file_storage import FileStorage
from .pytest_plugin import PytestReporter
from .test_reporters import (
    BaseTestReporter,
    TestResult,
    PythonTestReporter,
    TypeScriptTestReporter,
    GoTestReporter,
    RustTestReporter,
    DartTestReporter,
    get_test_reporter,
    store_manual_test_results,
)

__all__ = [
    "ClaudeToolValidator",  # Legacy compatibility
    "HybridValidator",  # Main hybrid validator
    "SecurityValidator",  # Security-only validator
    "TDDValidator",  # TDD-only validator
    "FileStorage",  # Context persistence
    "PytestReporter",  # Automatic pytest result capture
    "BaseTestReporter",  # Base class for test reporters
    "TestResult",  # Standardized test result format
    "PythonTestReporter",  # Python test result parsing
    "TypeScriptTestReporter",  # TypeScript/JavaScript test parsing
    "GoTestReporter",  # Go test result parsing
    "RustTestReporter",  # Rust test result parsing
    "DartTestReporter",  # Dart/Flutter test parsing
    "get_test_reporter",  # Get reporter by language
    "store_manual_test_results",  # Manual test result storage
]
