import Boost.Python
from _typeshed import Incomplete
from typing import Any, ClassVar, overload

BVH_BUILD_STATE_BEGUN: BVHBuildState
BVH_BUILD_STATE_EMPTY: BVHBuildState
BVH_BUILD_STATE_PROCESSED: BVHBuildState
BVH_BUILD_STATE_REPLACE_BEGUN: BVHBuildState
BVH_BUILD_STATE_UPDATED: BVHBuildState
BVH_BUILD_STATE_UPDATE_BEGUN: BVHBuildState
BVH_MODEL_POINTCLOUD: BVHModelType
BVH_MODEL_TRIANGLES: BVHModelType
BVH_MODEL_UNKNOWN: BVHModelType
HPP_FCL_MAJOR_VERSION: int
HPP_FCL_MINOR_VERSION: int
HPP_FCL_PATCH_VERSION: int
__raw_version__: str
__version__: str

class AABB(Boost.Python.instance):
    __safe_for_unpickling__: ClassVar[bool] = ...
    max_: Incomplete
    min_: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def center(cls, hpp) -> Any: ...
    @classmethod
    def contain(cls, *args, **kwargs): ...
    @classmethod
    def depth(cls, hpp) -> Any: ...
    @classmethod
    def distance(cls, *args, **kwargs): ...
    @classmethod
    def expand(cls, hpp, double) -> Any: ...
    @classmethod
    def height(cls, hpp) -> Any: ...
    @classmethod
    def overlap(cls, *args, **kwargs): ...
    @classmethod
    def size(cls, hpp) -> Any: ...
    @classmethod
    def volume(cls, hpp) -> Any: ...
    @classmethod
    def width(cls, hpp) -> Any: ...
    @classmethod
    def __add__(cls, other): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __getinitargs__(cls, hpp) -> Any: ...
    @classmethod
    def __iadd__(cls, boost, hpp) -> Any: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...

class BVHBuildState(Boost.Python.enum):
    BVH_BUILD_STATE_BEGUN: ClassVar[BVHBuildState] = ...
    BVH_BUILD_STATE_EMPTY: ClassVar[BVHBuildState] = ...
    BVH_BUILD_STATE_PROCESSED: ClassVar[BVHBuildState] = ...
    BVH_BUILD_STATE_REPLACE_BEGUN: ClassVar[BVHBuildState] = ...
    BVH_BUILD_STATE_UPDATED: ClassVar[BVHBuildState] = ...
    BVH_BUILD_STATE_UPDATE_BEGUN: ClassVar[BVHBuildState] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...

class BVHModelBase(CollisionGeometry):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def addSubModel(cls, *args, **kwargs): ...
    @classmethod
    def addTriangle(cls, *args, **kwargs): ...
    @classmethod
    def addTriangles(cls, *args, **kwargs): ...
    @classmethod
    def addVertex(cls, *args, **kwargs): ...
    @classmethod
    def addVertices(cls, *args, **kwargs): ...
    @classmethod
    def beginModel(cls, *args, **kwargs): ...
    @classmethod
    def beginReplaceModel(cls, hpp) -> Any: ...
    @classmethod
    def buildConvexHull(cls, *args, **kwargs): ...
    @classmethod
    def buildConvexRepresentation(cls, hpp, bool) -> Any: ...
    @classmethod
    def endModel(cls, hpp) -> Any: ...
    @classmethod
    def endReplaceModel(cls, *args, **kwargs): ...
    @classmethod
    def getModelType(cls, hpp) -> Any: ...
    @classmethod
    def replaceSubModel(cls, *args, **kwargs): ...
    @classmethod
    def replaceTriangle(cls, *args, **kwargs): ...
    @classmethod
    def replaceVertex(cls, *args, **kwargs): ...
    @classmethod
    def tri_indices(cls, hpp, unsignedint) -> Any: ...
    @classmethod
    def vertex(cls, hpp, unsignedint) -> Any: ...
    @overload
    @classmethod
    def vertices(cls, hpp, unsignedint) -> Any: ...
    @overload
    @classmethod
    def vertices(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def build_state(self): ...
    @property
    def convex(self): ...
    @property
    def num_tris(self): ...
    @property
    def num_vertices(self): ...

class BVHModelOBB(BVHModelBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, hpp) -> Any: ...
    @classmethod
    def getNumBVs(cls, hpp) -> Any: ...
    @classmethod
    def makeParentRelative(cls, hpp) -> Any: ...
    @classmethod
    def memUsage(cls, hpp, bool) -> Any: ...
    @classmethod
    def __getinitargs__(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class BVHModelOBBRSS(BVHModelBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, hpp) -> Any: ...
    @classmethod
    def getNumBVs(cls, hpp) -> Any: ...
    @classmethod
    def makeParentRelative(cls, hpp) -> Any: ...
    @classmethod
    def memUsage(cls, hpp, bool) -> Any: ...
    @classmethod
    def __getinitargs__(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class BVHModelType(Boost.Python.enum):
    BVH_MODEL_POINTCLOUD: ClassVar[BVHModelType] = ...
    BVH_MODEL_TRIANGLES: ClassVar[BVHModelType] = ...
    BVH_MODEL_UNKNOWN: ClassVar[BVHModelType] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...

class Box(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    halfSide: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, hpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class BroadPhaseCollisionManager(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @overload
    @classmethod
    def clear(cls, hpp) -> Any: ...
    @overload
    @classmethod
    def clear(cls, hpp) -> Any: ...
    @classmethod
    def collide(cls, *args, **kwargs): ...
    @classmethod
    def distance(cls, *args, **kwargs): ...
    @overload
    @classmethod
    def empty(cls, hpp) -> Any: ...
    @overload
    @classmethod
    def empty(cls, hpp) -> Any: ...
    @overload
    @classmethod
    def getObjects(cls, hpp) -> Any: ...
    @overload
    @classmethod
    def getObjects(cls, hpp) -> Any: ...
    @classmethod
    def registerObject(cls, *args, **kwargs): ...
    @classmethod
    def registerObjects(cls, *args, **kwargs): ...
    @overload
    @classmethod
    def setup(cls, hpp) -> Any: ...
    @overload
    @classmethod
    def setup(cls, hpp) -> Any: ...
    @overload
    @classmethod
    def size(cls, hpp) -> Any: ...
    @overload
    @classmethod
    def size(cls, hpp) -> Any: ...
    @classmethod
    def unregisterObject(cls, *args, **kwargs): ...
    @overload
    @classmethod
    def update(cls, hpp) -> Any: ...
    @overload
    @classmethod
    def update(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class Capsule(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    halfLength: Incomplete
    radius: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, hpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class CollisionCallBackBase(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def collide(cls, *args, **kwargs): ...
    @overload
    @classmethod
    def init(cls, hpp) -> Any: ...
    @overload
    @classmethod
    def init(cls, hpp) -> Any: ...
    @classmethod
    def __call__(cls, *args, **kwargs): ...
    @classmethod
    def __reduce__(cls): ...

class CollisionCallBackCollect(CollisionCallBackBase):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def exist(cls, *args, **kwargs): ...
    @classmethod
    def getCollisionPairs(cls, hpp) -> Any: ...
    @classmethod
    def numCollisionPairs(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class CollisionCallBackDefault(CollisionCallBackBase):
    data: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class CollisionData(Boost.Python.instance):
    done: Incomplete
    request: Incomplete
    result: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class CollisionGeometry(Boost.Python.instance):
    aabb_center: Incomplete
    aabb_local: Incomplete
    aabb_radius: Incomplete
    cost_density: Incomplete
    threshold_free: Incomplete
    threshold_occupied: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def computeCOM(cls, hpp) -> Any: ...
    @classmethod
    def computeLocalAABB(cls, hpp) -> Any: ...
    @classmethod
    def computeMomentofInertia(cls, hpp) -> Any: ...
    @classmethod
    def computeMomentofInertiaRelatedToCOM(cls, hpp) -> Any: ...
    @classmethod
    def computeVolume(cls, hpp) -> Any: ...
    @classmethod
    def getNodeType(cls, hpp) -> Any: ...
    @classmethod
    def getObjectType(cls, hpp) -> Any: ...
    @classmethod
    def isFree(cls, hpp) -> Any: ...
    @classmethod
    def isOccupied(cls, hpp) -> Any: ...
    @classmethod
    def isUncertain(cls, hpp) -> Any: ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...

class ComputeCollision(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __call__(cls, *args, **kwargs): ...
    @classmethod
    def __reduce__(cls): ...

class ComputeDistance(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __call__(cls, *args, **kwargs): ...
    @classmethod
    def __reduce__(cls): ...

class Cone(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    halfLength: Incomplete
    radius: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, hpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class Convex(ConvexBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def polygons(cls, hpp, unsignedint) -> Any: ...
    @classmethod
    def __getinitargs__(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def num_polygons(self): ...

class ConvexBase(ShapeBase):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, hpp) -> Any: ...
    @classmethod
    def convexHull(cls, *args, **kwargs): ...
    @classmethod
    def neighbors(cls, hpp, unsignedint) -> Any: ...
    @classmethod
    def point(cls, hpp, unsignedint) -> Any: ...
    @overload
    @classmethod
    def points(cls, hpp, unsignedint) -> Any: ...
    @overload
    @classmethod
    def points(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def center(self): ...
    @property
    def num_points(self): ...

class Cylinder(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    halfLength: Incomplete
    radius: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, hpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class DistanceCallBackBase(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def distance(cls, *args, **kwargs): ...
    @overload
    @classmethod
    def init(cls, hpp) -> Any: ...
    @overload
    @classmethod
    def init(cls, hpp) -> Any: ...
    @classmethod
    def __call__(cls, *args, **kwargs): ...
    @classmethod
    def __reduce__(cls): ...

class DistanceCallBackDefault(DistanceCallBackBase):
    data: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class DistanceData(Boost.Python.instance):
    done: Incomplete
    request: Incomplete
    result: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class DynamicAABBTreeArrayCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class DynamicAABBTreeCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class Ellipsoid(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    radii: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, hpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class Halfspace(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    d: Incomplete
    n: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, hpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class HeightFieldAABB(CollisionGeometry):
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, hpp) -> Any: ...
    @classmethod
    def getBV(cls, hpp, unsignedint) -> Any: ...
    @classmethod
    def getHeights(cls, hpp) -> Any: ...
    @classmethod
    def getMaxHeight(cls, hpp) -> Any: ...
    @classmethod
    def getMinHeight(cls, hpp) -> Any: ...
    @classmethod
    def getNodeType(cls, hpp) -> Any: ...
    @classmethod
    def getXDim(cls, hpp) -> Any: ...
    @classmethod
    def getXGrid(cls, hpp) -> Any: ...
    @classmethod
    def getYDim(cls, hpp) -> Any: ...
    @classmethod
    def getYGrid(cls, hpp) -> Any: ...
    @classmethod
    def updateHeights(cls, *args, **kwargs): ...
    @classmethod
    def __getinitargs__(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class HeightFieldOBBRSS(CollisionGeometry):
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, hpp) -> Any: ...
    @classmethod
    def getBV(cls, hpp, unsignedint) -> Any: ...
    @classmethod
    def getHeights(cls, hpp) -> Any: ...
    @classmethod
    def getMaxHeight(cls, hpp) -> Any: ...
    @classmethod
    def getMinHeight(cls, hpp) -> Any: ...
    @classmethod
    def getNodeType(cls, hpp) -> Any: ...
    @classmethod
    def getXDim(cls, hpp) -> Any: ...
    @classmethod
    def getXGrid(cls, hpp) -> Any: ...
    @classmethod
    def getYDim(cls, hpp) -> Any: ...
    @classmethod
    def getYGrid(cls, hpp) -> Any: ...
    @classmethod
    def updateHeights(cls, *args, **kwargs): ...
    @classmethod
    def __getinitargs__(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class IntervalTreeCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class NaiveCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class Plane(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    d: Incomplete
    n: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, hpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class SSaPCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class SaPCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class ShapeBase(CollisionGeometry):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class SpatialHashingCollisionManager(BroadPhaseCollisionManager):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class Sphere(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    radius: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, hpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

class Transform3f(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def Identity(cls) -> Any: ...
    @classmethod
    def getQuatRotation(cls, hpp) -> Any: ...
    @classmethod
    def getRotation(cls, hpp) -> Any: ...
    @classmethod
    def getTranslation(cls, hpp) -> Any: ...
    @classmethod
    def inverse(cls, hpp) -> Any: ...
    @classmethod
    def inverseInPlace(cls, hpp) -> Any: ...
    @classmethod
    def inverseTimes(cls, *args, **kwargs): ...
    @classmethod
    def isIdentity(cls, hpp) -> Any: ...
    @classmethod
    def setIdentity(cls, hpp) -> Any: ...
    @classmethod
    def setQuatRotation(cls, *args, **kwargs): ...
    @classmethod
    def setRotation(cls, *args, **kwargs): ...
    @classmethod
    def setTransform(cls, *args, **kwargs): ...
    @classmethod
    def setTranslation(cls, *args, **kwargs): ...
    @classmethod
    def transform(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __imul__(cls, boost, hpp) -> Any: ...
    @classmethod
    def __mul__(cls, other): ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...

class Triangle(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def set(cls, *args, **kwargs): ...
    @classmethod
    def size(cls) -> Any: ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __getitem__(cls, hpp, int) -> Any: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, hpp, int, unsignedlong) -> Any: ...

class TriangleP(ShapeBase):
    __safe_for_unpickling__: ClassVar[bool] = ...
    a: Incomplete
    b: Incomplete
    c: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def clone(cls, hpp) -> Any: ...
    @classmethod
    def __getinitargs__(cls, hpp) -> Any: ...
    @classmethod
    def __reduce__(cls): ...

def checkVersionAtLeast(*args, **kwargs): ...
def checkVersionAtMost(*args, **kwargs): ...
def collide(*args, **kwargs): ...
@overload
def computeMemoryFootprint(hpp) -> Any: ...
@overload
def computeMemoryFootprint(hpp) -> Any: ...
@overload
def computeMemoryFootprint(hpp) -> Any: ...
@overload
def computeMemoryFootprint(hpp) -> Any: ...
@overload
def computeMemoryFootprint(hpp) -> Any: ...
@overload
def computeMemoryFootprint(hpp) -> Any: ...
@overload
def computeMemoryFootprint(hpp) -> Any: ...
@overload
def computeMemoryFootprint(hpp) -> Any: ...
@overload
def computeMemoryFootprint(hpp) -> Any: ...
@overload
def computeMemoryFootprint(hpp) -> Any: ...
@overload
def computeMemoryFootprint(hpp) -> Any: ...
@overload
def computeMemoryFootprint(hpp) -> Any: ...
def distance(*args, **kwargs): ...
def rotate(*args, **kwargs): ...
@overload
def seed(unsignedint) -> Any: ...
@overload
def seed(unsignedint) -> Any: ...
@overload
def sharedMemory(bool) -> Any: ...
@overload
def sharedMemory() -> Any: ...
@overload
def sharedMemory(bool) -> Any: ...
@overload
def sharedMemory() -> Any: ...
def translate(*args, **kwargs): ...
