# coding: utf-8

"""
    Gate API v4

    APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.  # noqa: E501

    Contact: support@mail.gate.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class SubAccountTransfer(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'currency': 'str',
        'sub_account': 'str',
        'direction': 'str',
        'amount': 'str',
        'uid': 'str',
        'timest': 'str',
        'source': 'str',
    }

    attribute_map = {
        'currency': 'currency',
        'sub_account': 'sub_account',
        'direction': 'direction',
        'amount': 'amount',
        'uid': 'uid',
        'timest': 'timest',
        'source': 'source',
    }

    def __init__(
        self,
        currency=None,
        sub_account=None,
        direction=None,
        amount=None,
        uid=None,
        timest=None,
        source=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        # type: (str, str, str, str, str, str, str, Configuration) -> None
        """SubAccountTransfer - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._currency = None
        self._sub_account = None
        self._direction = None
        self._amount = None
        self._uid = None
        self._timest = None
        self._source = None
        self.discriminator = None

        self.currency = currency
        self.sub_account = sub_account
        self.direction = direction
        self.amount = amount
        if uid is not None:
            self.uid = uid
        if timest is not None:
            self.timest = timest
        if source is not None:
            self.source = source

    @property
    def currency(self):
        """Gets the currency of this SubAccountTransfer.  # noqa: E501

        Transfer currency name  # noqa: E501

        :return: The currency of this SubAccountTransfer.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this SubAccountTransfer.

        Transfer currency name  # noqa: E501

        :param currency: The currency of this SubAccountTransfer.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and currency is None:  # noqa: E501
            raise ValueError("Invalid value for `currency`, must not be `None`")  # noqa: E501

        self._currency = currency

    @property
    def sub_account(self):
        """Gets the sub_account of this SubAccountTransfer.  # noqa: E501

        Sub account user ID  # noqa: E501

        :return: The sub_account of this SubAccountTransfer.  # noqa: E501
        :rtype: str
        """
        return self._sub_account

    @sub_account.setter
    def sub_account(self, sub_account):
        """Sets the sub_account of this SubAccountTransfer.

        Sub account user ID  # noqa: E501

        :param sub_account: The sub_account of this SubAccountTransfer.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and sub_account is None:  # noqa: E501
            raise ValueError("Invalid value for `sub_account`, must not be `None`")  # noqa: E501

        self._sub_account = sub_account

    @property
    def direction(self):
        """Gets the direction of this SubAccountTransfer.  # noqa: E501

        Transfer direction. to - transfer into sub account; from - transfer out from sub account  # noqa: E501

        :return: The direction of this SubAccountTransfer.  # noqa: E501
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction):
        """Sets the direction of this SubAccountTransfer.

        Transfer direction. to - transfer into sub account; from - transfer out from sub account  # noqa: E501

        :param direction: The direction of this SubAccountTransfer.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and direction is None:  # noqa: E501
            raise ValueError("Invalid value for `direction`, must not be `None`")  # noqa: E501
        allowed_values = ["to", "from"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and direction not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `direction` ({0}), must be one of {1}".format(  # noqa: E501
                    direction, allowed_values
                )
            )

        self._direction = direction

    @property
    def amount(self):
        """Gets the amount of this SubAccountTransfer.  # noqa: E501

        Transfer amount  # noqa: E501

        :return: The amount of this SubAccountTransfer.  # noqa: E501
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this SubAccountTransfer.

        Transfer amount  # noqa: E501

        :param amount: The amount of this SubAccountTransfer.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and amount is None:  # noqa: E501
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def uid(self):
        """Gets the uid of this SubAccountTransfer.  # noqa: E501

        Main account user ID  # noqa: E501

        :return: The uid of this SubAccountTransfer.  # noqa: E501
        :rtype: str
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """Sets the uid of this SubAccountTransfer.

        Main account user ID  # noqa: E501

        :param uid: The uid of this SubAccountTransfer.  # noqa: E501
        :type: str
        """

        self._uid = uid

    @property
    def timest(self):
        """Gets the timest of this SubAccountTransfer.  # noqa: E501

        Transfer timestamp  # noqa: E501

        :return: The timest of this SubAccountTransfer.  # noqa: E501
        :rtype: str
        """
        return self._timest

    @timest.setter
    def timest(self, timest):
        """Sets the timest of this SubAccountTransfer.

        Transfer timestamp  # noqa: E501

        :param timest: The timest of this SubAccountTransfer.  # noqa: E501
        :type: str
        """

        self._timest = timest

    @property
    def source(self):
        """Gets the source of this SubAccountTransfer.  # noqa: E501

        Where the operation is initiated from  # noqa: E501

        :return: The source of this SubAccountTransfer.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this SubAccountTransfer.

        Where the operation is initiated from  # noqa: E501

        :param source: The source of this SubAccountTransfer.  # noqa: E501
        :type: str
        """

        self._source = source

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict()) if hasattr(item[1], "to_dict") else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SubAccountTransfer):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SubAccountTransfer):
            return True

        return self.to_dict() != other.to_dict()
