"""
Binance Crypto Loan REST API

OpenAPI Specification for the Binance Crypto Loan REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import Optional
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.errors import RequiredError
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import CheckCollateralRepayRateResponse
from ..models import FlexibleLoanAdjustLtvResponse
from ..models import FlexibleLoanBorrowResponse
from ..models import FlexibleLoanRepayResponse
from ..models import GetFlexibleLoanAssetsDataResponse
from ..models import GetFlexibleLoanBorrowHistoryResponse
from ..models import GetFlexibleLoanCollateralAssetsDataResponse
from ..models import GetFlexibleLoanLiquidationHistoryResponse
from ..models import GetFlexibleLoanLtvAdjustmentHistoryResponse
from ..models import GetFlexibleLoanOngoingOrdersResponse
from ..models import GetFlexibleLoanRepaymentHistoryResponse


class FlexibleRateApi:
    """API Client for FlexibleRateApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def check_collateral_repay_rate(
        self,
        loan_coin: str = None,
        collateral_coin: str = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CheckCollateralRepayRateResponse]:
        """
                Check Collateral Repay Rate (USER_DATA)
                GET /sapi/v2/loan/flexible/repay/rate
                https://developers.binance.com/docs/crypto_loan/flexible-rate/user-information/Check-Collateral-Repay-Rate


        Weight: 6000

                Args:
                    loan_coin (str):
                    collateral_coin (str):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[CheckCollateralRepayRateResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if loan_coin is None:
            raise RequiredError(
                field="loan_coin",
                error_message="Missing required parameter 'loan_coin'",
            )
        if collateral_coin is None:
            raise RequiredError(
                field="collateral_coin",
                error_message="Missing required parameter 'collateral_coin'",
            )

        payload = {
            "loan_coin": loan_coin,
            "collateral_coin": collateral_coin,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v2/loan/flexible/repay/rate",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=CheckCollateralRepayRateResponse,
            is_signed=True,
            signer=self._signer,
        )

    def flexible_loan_adjust_ltv(
        self,
        loan_coin: str = None,
        collateral_coin: str = None,
        adjustment_amount: float = None,
        direction: str = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[FlexibleLoanAdjustLtvResponse]:
        """
                Flexible Loan Adjust LTV(TRADE)
                POST /sapi/v2/loan/flexible/adjust/ltv
                https://developers.binance.com/docs/crypto_loan/flexible-rate/trade/Flexible-Loan-Adjust-LTV

                Flexible Loan Adjust LTV

        * API Key needs Spot & Margin Trading permission for this endpoint

        Weight: 6000

                Args:
                    loan_coin (str):
                    collateral_coin (str):
                    adjustment_amount (float):
                    direction (str): "ADDITIONAL", "REDUCED"
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[FlexibleLoanAdjustLtvResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if loan_coin is None:
            raise RequiredError(
                field="loan_coin",
                error_message="Missing required parameter 'loan_coin'",
            )
        if collateral_coin is None:
            raise RequiredError(
                field="collateral_coin",
                error_message="Missing required parameter 'collateral_coin'",
            )
        if adjustment_amount is None:
            raise RequiredError(
                field="adjustment_amount",
                error_message="Missing required parameter 'adjustment_amount'",
            )
        if direction is None:
            raise RequiredError(
                field="direction",
                error_message="Missing required parameter 'direction'",
            )

        payload = {
            "loan_coin": loan_coin,
            "collateral_coin": collateral_coin,
            "adjustment_amount": adjustment_amount,
            "direction": direction,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v2/loan/flexible/adjust/ltv",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=FlexibleLoanAdjustLtvResponse,
            is_signed=True,
            signer=self._signer,
        )

    def flexible_loan_borrow(
        self,
        loan_coin: str = None,
        collateral_coin: str = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[FlexibleLoanBorrowResponse]:
        """
                Flexible Loan Borrow(TRADE)
                POST /sapi/v2/loan/flexible/borrow
                https://developers.binance.com/docs/crypto_loan/flexible-rate/trade/Flexible-Loan-Borrow

                Borrow Flexible Loan


        * Only available for master account
        * You can customize LTV by entering loanAmount and collateralAmount.

        Weight: 6000

                Args:
                    loan_coin (str):
                    collateral_coin (str):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[FlexibleLoanBorrowResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if loan_coin is None:
            raise RequiredError(
                field="loan_coin",
                error_message="Missing required parameter 'loan_coin'",
            )
        if collateral_coin is None:
            raise RequiredError(
                field="collateral_coin",
                error_message="Missing required parameter 'collateral_coin'",
            )

        payload = {
            "loan_coin": loan_coin,
            "collateral_coin": collateral_coin,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v2/loan/flexible/borrow",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=FlexibleLoanBorrowResponse,
            is_signed=True,
            signer=self._signer,
        )

    def flexible_loan_repay(
        self,
        loan_coin: str = None,
        collateral_coin: str = None,
        repay_amount: float = None,
        collateral_return: Optional[bool] = None,
        full_repayment: Optional[bool] = None,
        repayment_type: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[FlexibleLoanRepayResponse]:
        """
                Flexible Loan Repay(TRADE)
                POST /sapi/v2/loan/flexible/repay
                https://developers.binance.com/docs/crypto_loan/flexible-rate/trade/Flexible-Loan-Repay

                Flexible Loan Repay


        * repayAmount is mandatory even fullRepayment = FALSE

        Weight: 6000

                Args:
                    loan_coin (str):
                    collateral_coin (str):
                    repay_amount (float): repay amount of loanCoin
                    collateral_return (Optional[bool]): Default: TRUE. TRUE: Return extra collateral to spot account; FALSE: Keep extra collateral in the order, and lower LTV.
                    full_repayment (Optional[bool]): Default: FALSE. TRUE: Full repayment; FALSE: Partial repayment, based on loanAmount
                    repayment_type (Optional[int]): Default: 1. 1: Repayment with loan asset; 2: Repayment with collateral
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[FlexibleLoanRepayResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if loan_coin is None:
            raise RequiredError(
                field="loan_coin",
                error_message="Missing required parameter 'loan_coin'",
            )
        if collateral_coin is None:
            raise RequiredError(
                field="collateral_coin",
                error_message="Missing required parameter 'collateral_coin'",
            )
        if repay_amount is None:
            raise RequiredError(
                field="repay_amount",
                error_message="Missing required parameter 'repay_amount'",
            )

        payload = {
            "loan_coin": loan_coin,
            "collateral_coin": collateral_coin,
            "repay_amount": repay_amount,
            "collateral_return": collateral_return,
            "full_repayment": full_repayment,
            "repayment_type": repayment_type,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v2/loan/flexible/repay",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=FlexibleLoanRepayResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_flexible_loan_assets_data(
        self,
        loan_coin: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleLoanAssetsDataResponse]:
        """
                Get Flexible Loan Assets Data(USER_DATA)
                GET /sapi/v2/loan/flexible/loanable/data
                https://developers.binance.com/docs/crypto_loan/flexible-rate/market-data/Get-Flexible-Loan-Assets-Data

                Get interest rate and borrow limit of flexible loanable assets. The borrow limit is shown in USD value.

        Weight: 400

                Args:
                    loan_coin (Optional[str]):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[GetFlexibleLoanAssetsDataResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"loan_coin": loan_coin, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v2/loan/flexible/loanable/data",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFlexibleLoanAssetsDataResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_flexible_loan_borrow_history(
        self,
        loan_coin: Optional[str] = None,
        collateral_coin: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleLoanBorrowHistoryResponse]:
        """
                Get Flexible Loan Borrow History(USER_DATA)
                GET /sapi/v2/loan/flexible/borrow/history
                https://developers.binance.com/docs/crypto_loan/flexible-rate/user-information/Get-Flexible-Loan-Borrow-History

                Get Flexible Loan Borrow History

        * If startTime and endTime are not sent, the recent 90-day data will be returned.
        * The max interval between startTime and endTime is 180 days.

        Weight: 400

                Args:
                    loan_coin (Optional[str]):
                    collateral_coin (Optional[str]):
                    start_time (Optional[int]):
                    end_time (Optional[int]):
                    current (Optional[int]): Current querying page. Start from 1; default: 1; max: 1000
                    limit (Optional[int]): Default: 10; max: 100
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[GetFlexibleLoanBorrowHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "loan_coin": loan_coin,
            "collateral_coin": collateral_coin,
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v2/loan/flexible/borrow/history",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFlexibleLoanBorrowHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_flexible_loan_collateral_assets_data(
        self,
        collateral_coin: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleLoanCollateralAssetsDataResponse]:
        """
                Get Flexible Loan Collateral Assets Data(USER_DATA)
                GET /sapi/v2/loan/flexible/collateral/data
                https://developers.binance.com/docs/crypto_loan/flexible-rate/market-data/Get-Flexible-Loan-Collateral-Assets-Data

                Get LTV information and collateral limit of flexible loan's collateral assets. The collateral limit is shown in USD value.

        Weight: 400

                Args:
                    collateral_coin (Optional[str]):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[GetFlexibleLoanCollateralAssetsDataResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"collateral_coin": collateral_coin, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v2/loan/flexible/collateral/data",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFlexibleLoanCollateralAssetsDataResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_flexible_loan_liquidation_history(
        self,
        loan_coin: Optional[str] = None,
        collateral_coin: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleLoanLiquidationHistoryResponse]:
        """
                Get Flexible Loan Liquidation History (USER_DATA)
                GET /sapi/v2/loan/flexible/liquidation/history
                https://developers.binance.com/docs/crypto_loan/flexible-rate/user-information/Get-Flexible-Loan-Liquidation-History


        Weight: 400

                Args:
                    loan_coin (Optional[str]):
                    collateral_coin (Optional[str]):
                    start_time (Optional[int]):
                    end_time (Optional[int]):
                    current (Optional[int]): Current querying page. Start from 1; default: 1; max: 1000
                    limit (Optional[int]): Default: 10; max: 100
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[GetFlexibleLoanLiquidationHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "loan_coin": loan_coin,
            "collateral_coin": collateral_coin,
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v2/loan/flexible/liquidation/history",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFlexibleLoanLiquidationHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_flexible_loan_ltv_adjustment_history(
        self,
        loan_coin: Optional[str] = None,
        collateral_coin: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleLoanLtvAdjustmentHistoryResponse]:
        """
                Get Flexible Loan LTV Adjustment History(USER_DATA)
                GET /sapi/v2/loan/flexible/ltv/adjustment/history
                https://developers.binance.com/docs/crypto_loan/flexible-rate/user-information/Get-Flexible-Loan-LTV-Adjustment-History

                Get Flexible Loan LTV Adjustment History

        * If startTime and endTime are not sent, the recent 90-day data will be returned.
        * The max interval between startTime and endTime is 180 days.

        Weight: 400

                Args:
                    loan_coin (Optional[str]):
                    collateral_coin (Optional[str]):
                    start_time (Optional[int]):
                    end_time (Optional[int]):
                    current (Optional[int]): Current querying page. Start from 1; default: 1; max: 1000
                    limit (Optional[int]): Default: 10; max: 100
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[GetFlexibleLoanLtvAdjustmentHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "loan_coin": loan_coin,
            "collateral_coin": collateral_coin,
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v2/loan/flexible/ltv/adjustment/history",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFlexibleLoanLtvAdjustmentHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_flexible_loan_ongoing_orders(
        self,
        loan_coin: Optional[str] = None,
        collateral_coin: Optional[str] = None,
        current: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleLoanOngoingOrdersResponse]:
        """
                Get Flexible Loan Ongoing Orders(USER_DATA)
                GET /sapi/v2/loan/flexible/ongoing/orders
                https://developers.binance.com/docs/crypto_loan/flexible-rate/user-information/Get-Flexible-Loan-Ongoing-Orders

                Get Flexible Loan Ongoing Orders

        Weight: 300

                Args:
                    loan_coin (Optional[str]):
                    collateral_coin (Optional[str]):
                    current (Optional[int]): Current querying page. Start from 1; default: 1; max: 1000
                    limit (Optional[int]): Default: 10; max: 100
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[GetFlexibleLoanOngoingOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "loan_coin": loan_coin,
            "collateral_coin": collateral_coin,
            "current": current,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v2/loan/flexible/ongoing/orders",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFlexibleLoanOngoingOrdersResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_flexible_loan_repayment_history(
        self,
        loan_coin: Optional[str] = None,
        collateral_coin: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        current: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFlexibleLoanRepaymentHistoryResponse]:
        """
                Get Flexible Loan Repayment History(USER_DATA)
                GET /sapi/v2/loan/flexible/repay/history
                https://developers.binance.com/docs/crypto_loan/flexible-rate/user-information/Get-Flexible-Loan-Repayment-History

                Get Flexible Loan Repayment History

        * If startTime and endTime are not sent, the recent 90-day data will be returned.
        * The max interval between startTime and endTime is 180 days.

        Weight: 400

                Args:
                    loan_coin (Optional[str]):
                    collateral_coin (Optional[str]):
                    start_time (Optional[int]):
                    end_time (Optional[int]):
                    current (Optional[int]): Current querying page. Start from 1; default: 1; max: 1000
                    limit (Optional[int]): Default: 10; max: 100
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[GetFlexibleLoanRepaymentHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "loan_coin": loan_coin,
            "collateral_coin": collateral_coin,
            "start_time": start_time,
            "end_time": end_time,
            "current": current,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v2/loan/flexible/repay/history",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFlexibleLoanRepaymentHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )
